/*!
 * # Semantic UI 2.1.3 - Progress
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,r){"use strict";e.fn.progress=function(t){var a,o=e(this),i=o.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,g=[].slice.call(arguments,1);return o.each(function(){var o,v,p=e.isPlainObject(t)?e.extend(!0,{},e.fn.progress.settings,t):e.extend({},e.fn.progress.settings),d=p.className,m=p.metadata,b=p.namespace,f=p.selector,h=p.error,w="."+b,x="module-"+b,y=e(this),C=e(this).find(f.bar),T=e(this).find(f.progress),E=e(this).find(f.label),A=this,S=y.data(x),V=!1;v={initialize:function(){v.debug("Initializing progress bar",p),v.set.duration(),v.set.transitionEvent(),v.read.metadata(),v.read.settings(),v.instantiate()},instantiate:function(){v.verbose("Storing instance of progress",v),S=v,y.data(x,v)},destroy:function(){v.verbose("Destroying previous progress for",y),clearInterval(S.interval),v.remove.state(),y.removeData(x),S=r},reset:function(){v.set.percent(0)},complete:function(){(v.percent===r||v.percent<100)&&v.set.percent(100)},read:{metadata:function(){var e={percent:y.data(m.percent),total:y.data(m.total),value:y.data(m.value)};e.percent&&(v.debug("Current percent value set from metadata",e.percent),v.set.percent(e.percent)),e.total&&(v.debug("Total value set from metadata",e.total),v.set.total(e.total)),e.value&&(v.debug("Current value set from metadata",e.value),v.set.value(e.value),v.set.progress(e.value))},settings:function(){p.total!==!1&&(v.debug("Current total set in settings",p.total),v.set.total(p.total)),p.value!==!1&&(v.debug("Current value set in settings",p.value),v.set.value(p.value),v.set.progress(v.value)),p.percent!==!1&&(v.debug("Current percent set in settings",p.percent),v.set.percent(p.percent))}},increment:function(e){var t,n,r;v.has.total()?(n=v.get.value(),e=e||1,r=n+e,t=v.get.total(),v.debug("Incrementing value",n,r,t),r>t&&(v.debug("Value cannot increment above total",t),r=t)):(n=v.get.percent(),e=e||v.get.randomValue(),r=n+e,t=100,v.debug("Incrementing percentage by",n,r),r>t&&(v.debug("Value cannot increment above 100 percent"),r=t)),v.set.progress(r)},decrement:function(e){var t,n,r=v.get.total();r?(t=v.get.value(),e=e||1,n=t-e,v.debug("Decrementing value by",e,t)):(t=v.get.percent(),e=e||v.get.randomValue(),n=t-e,v.debug("Decrementing percentage by",e,t)),0>n&&(v.debug("Value cannot decrement below 0"),n=0),v.set.progress(n)},has:{total:function(){return v.get.total()!==!1}},get:{text:function(e){var t=v.value||0,n=v.total||0,r=V?v.get.displayPercent():v.percent||0,a=v.total>0?n-t:100-r;return e=e||"",e=e.replace("{value}",t).replace("{total}",n).replace("{left}",a).replace("{percent}",r),v.debug("Adding variables to progress bar text",e),e},randomValue:function(){return v.debug("Generating random increment percentage"),Math.floor(Math.random()*p.random.max+p.random.min)},numericValue:function(e){return"string"==typeof e?""!==e.replace(/[^\d.]/g,"")?+e.replace(/[^\d.]/g,""):!1:e},transitionEnd:function(){var e,t=n.createElement("element"),a={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in a)if(t.style[e]!==r)return a[e]},displayPercent:function(){var e=C.width(),t=y.width(),n=parseInt(C.css("min-width"),10),r=e>n?e/t*100:v.percent;return p.precision>0?Math.round(10*r*p.precision)/(10*p.precision):Math.round(r)},percent:function(){return v.percent||0},value:function(){return v.value||0},total:function(){return v.total||!1}},is:{success:function(){return y.hasClass(d.success)},warning:function(){return y.hasClass(d.warning)},error:function(){return y.hasClass(d.error)},active:function(){return y.hasClass(d.active)},visible:function(){return y.is(":visible")}},remove:{state:function(){v.verbose("Removing stored state"),delete v.total,delete v.percent,delete v.value},active:function(){v.verbose("Removing active state"),y.removeClass(d.active)},success:function(){v.verbose("Removing success state"),y.removeClass(d.success)},warning:function(){v.verbose("Removing warning state"),y.removeClass(d.warning)},error:function(){v.verbose("Removing error state"),y.removeClass(d.error)}},set:{barWidth:function(e){e>100?v.error(h.tooHigh,e):0>e?v.error(h.tooLow,e):(C.css("width",e+"%"),y.attr("data-percent",parseInt(e,10)))},duration:function(e){e=e||p.duration,e="number"==typeof e?e+"ms":e,v.verbose("Setting progress bar transition duration",e),C.css({"transition-duration":e})},percent:function(e){e="string"==typeof e?+e.replace("%",""):e,e=p.precision>0?Math.round(10*e*p.precision)/(10*p.precision):Math.round(e),v.percent=e,v.has.total()||(v.value=p.precision>0?Math.round(e/100*v.total*10*p.precision)/(10*p.precision):Math.round(e/100*v.total*10)/10,p.limitValues&&(v.value=v.value>100?100:v.value<0?0:v.value)),v.set.barWidth(e),v.set.labelInterval(),v.set.labels(),p.onChange.call(A,e,v.value,v.total)},labelInterval:function(){var e=function(){v.verbose("Bar finished animating, removing continuous label updates"),clearInterval(v.interval),V=!1,v.set.labels()};clearInterval(v.interval),C.one(o+w,e),v.timer=setTimeout(e,p.duration+100),V=!0,v.interval=setInterval(v.set.labels,p.framerate)},labels:function(){v.verbose("Setting both bar progress and outer label text"),v.set.barLabel(),v.set.state()},label:function(e){e=e||"",e&&(e=v.get.text(e),v.debug("Setting label to text",e),E.text(e))},state:function(e){e=e!==r?e:v.percent,100===e?!p.autoSuccess||v.is.warning()||v.is.error()?(v.verbose("Reached 100% removing active state"),v.remove.active()):(v.set.success(),v.debug("Automatically triggering success at 100%")):e>0?(v.verbose("Adjusting active progress bar label",e),v.set.active()):(v.remove.active(),v.set.label(p.text.active))},barLabel:function(e){e!==r?T.text(v.get.text(e)):"ratio"==p.label&&v.total?(v.debug("Adding ratio to bar label"),T.text(v.get.text(p.text.ratio))):"percent"==p.label&&(v.debug("Adding percentage to bar label"),T.text(v.get.text(p.text.percent)))},active:function(e){e=e||p.text.active,v.debug("Setting active state"),p.showActivity&&!v.is.active()&&y.addClass(d.active),v.remove.warning(),v.remove.error(),v.remove.success(),e&&v.set.label(e),p.onActive.call(A,v.value,v.total)},success:function(e){e=e||p.text.success,v.debug("Setting success state"),y.addClass(d.success),v.remove.active(),v.remove.warning(),v.remove.error(),v.complete(),e&&v.set.label(e),p.onSuccess.call(A,v.total)},warning:function(e){e=e||p.text.warning,v.debug("Setting warning state"),y.addClass(d.warning),v.remove.active(),v.remove.success(),v.remove.error(),v.complete(),e&&v.set.label(e),p.onWarning.call(A,v.value,v.total)},error:function(e){e=e||p.text.error,v.debug("Setting error state"),y.addClass(d.error),v.remove.active(),v.remove.success(),v.remove.warning(),v.complete(),e&&v.set.label(e),p.onError.call(A,v.value,v.total)},transitionEvent:function(){o=v.get.transitionEnd()},total:function(e){v.total=e},value:function(e){v.value=e},progress:function(e){var t,n=v.get.numericValue(e);n===!1&&v.error(h.nonNumeric,e),v.has.total()?(v.set.value(n),t=n/v.total*100,v.debug("Calculating percent complete from total",t),v.set.percent(t)):(t=n,v.debug("Setting value to exact percentage value",t),v.set.percent(t))}},setting:function(t,n){if(v.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,p,t);else{if(n===r)return p[t];p[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,v,t);else{if(n===r)return v[t];v[t]=n}},debug:function(){p.debug&&(p.performance?v.performance.log(arguments):(v.debug=Function.prototype.bind.call(console.info,console,p.name+":"),v.debug.apply(console,arguments)))},verbose:function(){p.verbose&&p.debug&&(p.performance?v.performance.log(arguments):(v.verbose=Function.prototype.bind.call(console.info,console,p.name+":"),v.verbose.apply(console,arguments)))},error:function(){v.error=Function.prototype.bind.call(console.error,console,p.name+":"),v.error.apply(console,arguments)},performance:{log:function(e){var t,n,r;p.performance&&(t=(new Date).getTime(),r=s||t,n=t-r,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:A,"Execution Time":n})),clearTimeout(v.performance.timer),v.performance.timer=setTimeout(v.performance.display,500)},display:function(){var t=p.name+":",n=0;s=!1,clearTimeout(v.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",i&&(t+=" '"+i+"'"),(console.group!==r||console.table!==r)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,o){var i,s,c,l=S;return n=n||g,o=A||o,"string"==typeof t&&l!==r&&(t=t.split(/[\. ]/),i=t.length-1,e.each(t,function(n,a){var o=n!=i?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[o])&&n!=i)l=l[o];else{if(l[o]!==r)return s=l[o],!1;if(!e.isPlainObject(l[a])||n==i)return l[a]!==r?(s=l[a],!1):(v.error(h.method,t),!1);l=l[a]}})),e.isFunction(s)?c=s.apply(o,n):s!==r&&(c=s),e.isArray(a)?a.push(c):a!==r?a=[a,c]:c!==r&&(a=c),s}},u?(S===r&&v.initialize(),v.invoke(l)):(S!==r&&S.invoke("destroy"),v.initialize())}),a!==r?a:this},e.fn.progress.settings={name:"Progress",namespace:"progress",debug:!1,verbose:!1,performance:!0,random:{min:2,max:5},duration:300,autoSuccess:!0,showActivity:!0,limitValues:!0,label:"percent",precision:0,framerate:1e3/30,percent:!1,total:!1,value:!1,onChange:function(e,t,n){},onSuccess:function(e){},onActive:function(e,t){},onError:function(e,t){},onWarning:function(e,t){},error:{method:"The method you called is not defined.",nonNumeric:"Progress value is non numeric",tooHigh:"Value specified is above 100%",tooLow:"Value specified is below 0%"},regExp:{variable:/\{\$*[A-z0-9]+\}/g},metadata:{percent:"percent",total:"total",value:"value"},selector:{bar:"> .bar",label:"> .label",progress:".bar > .progress"},text:{active:!1,error:!1,success:!1,warning:!1,percent:"{percent}%",ratio:"{value} of {total}"},className:{active:"active",error:"error",success:"success",warning:"warning"}}}(jQuery,window,document);