/*!
 * # Semantic UI 2.1.4 - Dropdown
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.dropdown=function(a){var o,s=e(this),r=e(n),l=s.selector||"",c="ontouchstart"in n.documentElement,u=(new Date).getTime(),d=[],v=arguments[0],m="string"==typeof v,f=[].slice.call(arguments,1);return s.each(function(h){var g,p,b,w,x,C,S,y=e.isPlainObject(a)?e.extend(!0,{},e.fn.dropdown.settings,a):e.extend({},e.fn.dropdown.settings),T=y.className,A=y.message,k=y.fields,L=y.metadata,D=y.namespace,I=y.regExp,R=y.selector,q=y.error,V=y.templates,E="."+D,O="module-"+D,F=e(this),P=e(y.context),M=F.find(R.text),z=F.find(R.search),H=F.find(R.input),j=F.find(R.icon),U=F.prev().find(R.text).length>0?F.prev().find(R.text):F.prev(),N=F.children(R.menu),K=N.find(R.item),B=!1,W=!1,$=!1,Q=this,Y=F.data(O);S={initialize:function(){S.debug("Initializing dropdown",y),S.is.alreadySetup()?S.setup.reference():(S.setup.layout(),S.refreshData(),S.save.defaults(),S.restore.selected(),S.create.id(),S.bind.events(),S.observeChanges(),S.instantiate())},instantiate:function(){S.verbose("Storing instance of dropdown",S),Y=S,F.data(O,S)},destroy:function(){S.verbose("Destroying previous dropdown",F),S.remove.tabbable(),F.off(E).removeData(O),N.off(E),r.off(b),x&&x.disconnect(),C&&C.disconnect()},observeChanges:function(){"MutationObserver"in t&&(x=new MutationObserver(function(e){S.debug("<select> modified, recreating menu"),S.setup.select()}),C=new MutationObserver(function(e){S.debug("Menu modified, updating selector cache"),S.refresh()}),S.has.input()&&x.observe(H[0],{childList:!0,subtree:!0}),S.has.menu()&&C.observe(N[0],{childList:!0,subtree:!0}),S.debug("Setting up mutation observer",x,C))},create:{id:function(){w=(Math.random().toString(16)+"000000000").substr(2,8),b="."+w,S.verbose("Creating unique id for element",w)},userChoice:function(t){var n,a,o;return(t=t||S.get.userValues())?(t=e.isArray(t)?t:[t],e.each(t,function(t,s){S.get.item(s)===!1&&(o=y.templates.addition(S.add.variables(A.addResult,s)),a=e("<div />").html(o).attr("data-"+L.value,s).attr("data-"+L.text,s).addClass(T.addition).addClass(T.item),n=n===i?a:n.add(a),S.verbose("Creating user choices for value",s,a))}),n):!1},userLabels:function(t){var n=S.get.userValues();n&&(S.debug("Adding user labels",n),e.each(n,function(e,t){S.verbose("Adding custom user value"),S.add.label(t,t)}))},menu:function(){N=e("<div />").addClass(T.menu).appendTo(F)}},search:function(e){e=e!==i?e:S.get.query(),S.verbose("Searching for query",e),S.filter(e)},select:{firstUnfiltered:function(){S.verbose("Selecting first non-filtered element"),S.remove.selectedItem(),K.not(R.unselectable).eq(0).addClass(T.selected)},nextAvailable:function(e){e=e.eq(0);var t=e.nextAll(R.item).not(R.unselectable).eq(0),n=e.prevAll(R.item).not(R.unselectable).eq(0),i=t.length>0;i?(S.verbose("Moving selection to",t),t.addClass(T.selected)):(S.verbose("Moving selection to",n),n.addClass(T.selected))}},setup:{api:function(){var e={debug:y.debug,on:!1};S.verbose("First request, initializing API"),F.api(e)},layout:function(){F.is("select")&&(S.setup.select(),S.setup.returnedObject()),S.has.menu()||S.create.menu(),S.is.search()&&!S.has.search()&&(S.verbose("Adding search input"),z=e("<input />").addClass(T.search).insertBefore(M)),y.allowTab&&S.set.tabbable()},select:function(){var t=S.get.selectValues();S.debug("Dropdown initialized on a select",t),F.is("select")&&(H=F),H.parent(R.dropdown).length>0?(S.debug("UI dropdown already exists. Creating dropdown menu only"),F=H.closest(R.dropdown),S.has.menu()||S.create.menu(),N=F.children(R.menu),S.setup.menu(t)):(S.debug("Creating entire dropdown from select"),F=e("<div />").attr("class",H.attr("class")).addClass(T.selection).addClass(T.dropdown).html(V.dropdown(t)).insertBefore(H),H.hasClass(T.multiple)&&H.prop("multiple")===!1&&(S.error(q.missingMultiple),H.prop("multiple",!0)),H.is("[multiple]")&&S.set.multiple(),H.prop("disabled")&&(S.debug("Disabling dropdown"),F.addClass(T.disabled)),H.removeAttr("class").detach().prependTo(F)),S.refresh()},menu:function(e){N.html(V.menu(e,k)),K=N.find(R.item)},reference:function(){S.debug("Dropdown behavior was called on select, replacing with closest dropdown"),F=F.parent(R.dropdown),S.refresh(),S.setup.returnedObject(),m&&(Y=S,S.invoke(v))},returnedObject:function(){var e=s.slice(0,h),t=s.slice(h+1);s=e.add(F).add(t)}},refresh:function(){S.refreshSelectors(),S.refreshData()},refreshSelectors:function(){S.verbose("Refreshing selector cache"),M=F.find(R.text),z=F.find(R.search),H=F.find(R.input),j=F.find(R.icon),U=F.prev().find(R.text).length>0?F.prev().find(R.text):F.prev(),N=F.children(R.menu),K=N.find(R.item)},refreshData:function(){S.verbose("Refreshing cached metadata"),K.removeData(L.text).removeData(L.value),F.removeData(L.defaultText).removeData(L.defaultValue).removeData(L.placeholderText)},toggle:function(){S.verbose("Toggling menu visibility"),S.is.active()?S.hide():S.show()},show:function(t){if(t=e.isFunction(t)?t:function(){},S.can.show()&&!S.is.active()){if(S.debug("Showing dropdown"),S.is.multiple()&&!S.has.search()&&S.is.allFiltered())return!0;S.has.message()&&!S.has.maxSelections()&&S.remove.message(),y.onShow.call(Q)!==!1&&S.animate.show(function(){S.can.click()&&S.bind.intent(),S.set.visible(),t.call(Q)})}},hide:function(t){t=e.isFunction(t)?t:function(){},S.is.active()&&(S.debug("Hiding dropdown"),y.onHide.call(Q)!==!1&&S.animate.hide(function(){S.remove.visible(),t.call(Q)}))},hideOthers:function(){S.verbose("Finding other dropdowns to hide"),s.not(F).has(R.menu+"."+T.visible).dropdown("hide")},hideMenu:function(){S.verbose("Hiding menu  instantaneously"),S.remove.active(),S.remove.visible(),N.transition("hide")},hideSubMenus:function(){var e=N.children(R.item).find(R.menu);S.verbose("Hiding sub menus",e),e.transition("hide")},bind:{events:function(){c&&S.bind.touchEvents(),S.bind.keyboardEvents(),S.bind.inputEvents(),S.bind.mouseEvents()},touchEvents:function(){S.debug("Touch device detected binding additional touch events"),S.is.searchSelection()||S.is.single()&&F.on("touchstart"+E,S.event.test.toggle),N.on("touchstart"+E,R.item,S.event.item.mouseenter)},keyboardEvents:function(){S.verbose("Binding keyboard events"),F.on("keydown"+E,S.event.keydown),S.has.search()&&F.on(S.get.inputEvent()+E,R.search,S.event.input),S.is.multiple()&&r.on("keydown"+b,S.event.document.keydown)},inputEvents:function(){S.verbose("Binding input change events"),F.on("change"+E,R.input,S.event.change)},mouseEvents:function(){S.verbose("Binding mouse events"),S.is.multiple()&&F.on("click"+E,R.label,S.event.label.click).on("click"+E,R.remove,S.event.remove.click),S.is.searchSelection()?(F.on("mousedown"+E,R.menu,S.event.menu.mousedown).on("mouseup"+E,R.menu,S.event.menu.mouseup).on("click"+E,R.icon,S.event.icon.click).on("click"+E,R.search,S.show).on("focus"+E,R.search,S.event.search.focus).on("blur"+E,R.search,S.event.search.blur).on("click"+E,R.text,S.event.text.focus),S.is.multiple()&&F.on("click"+E,S.event.click)):("click"==y.on?F.on("click"+E,R.icon,S.event.icon.click).on("click"+E,S.event.test.toggle):"hover"==y.on?F.on("mouseenter"+E,S.delay.show).on("mouseleave"+E,S.delay.hide):F.on(y.on+E,S.toggle),F.on("mousedown"+E,S.event.mousedown).on("mouseup"+E,S.event.mouseup).on("focus"+E,S.event.focus).on("blur"+E,S.event.blur)),N.on("mouseenter"+E,R.item,S.event.item.mouseenter).on("mouseleave"+E,R.item,S.event.item.mouseleave).on("click"+E,R.item,S.event.item.click)},intent:function(){S.verbose("Binding hide intent event to document"),c&&r.on("touchstart"+b,S.event.test.touch).on("touchmove"+b,S.event.test.touch),r.on("click"+b,S.event.test.hide)}},unbind:{intent:function(){S.verbose("Removing hide intent event from document"),c&&r.off("touchstart"+b).off("touchmove"+b),r.off("click"+b)}},filter:function(e){var t=e!==i?e:S.get.query(),n=function(){S.is.multiple()&&S.filterActive(),S.select.firstUnfiltered(),S.has.allResultsFiltered()?y.onNoResults.call(Q,t)?y.allowAdditions||(S.verbose("All items filtered, showing message",t),S.add.message(A.noResults)):(S.verbose("All items filtered, hiding dropdown",t),S.hideMenu()):S.remove.message(),y.allowAdditions&&S.add.userSuggestion(e),S.is.searchSelection()&&S.can.show()&&S.is.focusedOnSearch()&&S.show()};y.useLabels&&S.has.maxSelections()||(y.apiSettings?S.can.useAPI()?S.queryRemote(t,function(){n()}):S.error(q.noAPI):(S.filterItems(t),n()))},queryRemote:function(t,n){var i={errorDuration:!1,throttle:y.throttle,urlData:{query:t},onError:function(){S.add.message(A.serverError),n()},onFailure:function(){S.add.message(A.serverError),n()},onSuccess:function(e){S.remove.message(),S.setup.menu({values:e.results}),n()}};F.api("get request")||S.setup.api(),i=e.extend(!0,{},i,y.apiSettings),F.api("setting",i).api("query")},filterItems:function(t){var n=t!==i?t:S.get.query(),a=e(),o=S.escape.regExp(n),s=new RegExp("^"+o,"igm");S.has.query()?(S.verbose("Searching for matching values",n),K.each(function(){var t,i,o=e(this);if("both"==y.match||"text"==y.match){if(t=String(S.get.choiceText(o,!1)),-1!==t.search(s))return a=a.add(o),!0;if(y.fullTextSearch&&S.fuzzySearch(n,t))return a=a.add(o),!0}if("both"==y.match||"value"==y.match){if(i=String(S.get.choiceValue(o,t)),-1!==i.search(s))return a=a.add(o),!0;if(y.fullTextSearch&&S.fuzzySearch(n,i))return a=a.add(o),!0}})):a=K,S.debug("Showing only matched items",n),S.remove.filteredItem(),K.not(a).addClass(T.filtered)},fuzzySearch:function(e,t){var n=t.length,i=e.length;if(e=e.toLowerCase(),t=t.toLowerCase(),i>n)return!1;if(i===n)return e===t;e:for(var a=0,o=0;i>a;a++){for(var s=e.charCodeAt(a);n>o;)if(t.charCodeAt(o++)===s)continue e;return!1}return!0},filterActive:function(){y.useLabels&&K.filter("."+T.active).addClass(T.filtered)},focusSearch:function(){S.is.search()&&!S.is.focusedOnSearch()&&z[0].focus()},forceSelection:function(){var e=K.not(T.filtered).filter("."+T.selected).eq(0),t=K.not(T.filtered).filter("."+T.active).eq(0),n=e.length>0?e:t,i=n.size()>0;i&&S.has.query()?(S.debug("Forcing partial selection to selected item",n),S.event.item.click.call(n)):S.hide()},event:{change:function(){$||(S.debug("Input changed, updating selection"),S.set.selected())},focus:function(){y.showOnFocus&&!B&&S.is.hidden()&&!p&&S.show()},click:function(t){var n=e(t.target);n.is(F)&&!S.is.focusedOnSearch()&&S.focusSearch()},blur:function(e){p=n.activeElement===this,B||p||(S.remove.activeLabel(),S.hide())},mousedown:function(){B=!0},mouseup:function(){B=!1},search:{focus:function(){B=!0,S.is.multiple()&&S.remove.activeLabel(),y.showOnFocus&&S.show()},blur:function(e){p=n.activeElement===this,W||p?p&&y.forceSelection&&S.forceSelection():S.is.multiple()?(S.remove.activeLabel(),S.hide()):y.forceSelection?S.forceSelection():S.hide()}},icon:{click:function(e){S.toggle(),e.stopPropagation()}},text:{focus:function(e){B=!0,S.focusSearch()}},input:function(e){(S.is.multiple()||S.is.searchSelection())&&S.set.filtered(),clearTimeout(S.timer),S.timer=setTimeout(S.search,y.delay.search)},label:{click:function(t){var n=e(this),i=F.find(R.label),a=i.filter("."+T.active),o=n.nextAll("."+T.active),s=n.prevAll("."+T.active),r=o.length>0?n.nextUntil(o).add(a).add(n):n.prevUntil(s).add(a).add(n);t.shiftKey?(a.removeClass(T.active),r.addClass(T.active)):t.ctrlKey?n.toggleClass(T.active):(a.removeClass(T.active),n.addClass(T.active)),y.onLabelSelect.apply(this,i.filter("."+T.active))}},remove:{click:function(){var t=e(this).parent();t.hasClass(T.active)?S.remove.activeLabels():S.remove.activeLabels(t)}},test:{toggle:function(e){var t=S.is.multiple()?S.show:S.toggle;S.determine.eventOnElement(e,t)&&e.preventDefault()},touch:function(e){S.determine.eventOnElement(e,function(){"touchstart"==e.type?S.timer=setTimeout(function(){S.hide()},y.delay.touch):"touchmove"==e.type&&clearTimeout(S.timer)}),e.stopPropagation()},hide:function(e){S.determine.eventInModule(e,S.hide)}},menu:{mousedown:function(){W=!0},mouseup:function(){W=!1}},item:{mouseenter:function(t){var n=e(this).children(R.menu),i=e(this).siblings(R.item).children(R.menu);n.length>0&&(clearTimeout(S.itemTimer),S.itemTimer=setTimeout(function(){S.verbose("Showing sub-menu",n),e.each(i,function(){S.animate.hide(!1,e(this))}),S.animate.show(!1,n)},y.delay.show),t.preventDefault())},mouseleave:function(t){var n=e(this).children(R.menu);n.length>0&&(clearTimeout(S.itemTimer),S.itemTimer=setTimeout(function(){S.verbose("Hiding sub-menu",n),S.animate.hide(!1,n)},y.delay.hide))},touchend:function(){},click:function(t){var n=e(this),i=e(t?t.target:""),a=n.find(R.menu),o=S.get.choiceText(n),s=S.get.choiceValue(n,o),r=a.length>0,l=a.find(i).length>0;l||r&&!y.allowCategorySelection||(y.useLabels||(S.remove.filteredItem(),S.remove.searchTerm(),S.set.scrollPosition(n)),S.determine.selectAction.call(this,o,s))}},document:{keydown:function(e){var t=e.which,n=S.get.shortcutKeys(),i=S.is.inObject(t,n);if(i){var a=F.find(R.label),o=a.filter("."+T.active),s=(o.data(L.value),a.index(o)),r=a.length,l=o.length>0,c=o.length>1,u=0===s,d=s+1==r,v=S.is.searchSelection(),m=S.is.focusedOnSearch(),f=S.is.focused(),h=m&&0===S.get.caretPosition();if(v&&!l&&!m)return;t==n.leftArrow?!f&&!h||l?l&&(e.shiftKey?S.verbose("Adding previous label to selection"):(S.verbose("Selecting previous label"),a.removeClass(T.active)),u&&!c?o.addClass(T.active):o.prev(R.siblingLabel).addClass(T.active).end(),e.preventDefault()):(S.verbose("Selecting previous label"),a.last().addClass(T.active)):t==n.rightArrow?(f&&!l&&a.first().addClass(T.active),l&&(e.shiftKey?S.verbose("Adding next label to selection"):(S.verbose("Selecting next label"),a.removeClass(T.active)),d?v?m?a.removeClass(T.active):S.focusSearch():c?o.next(R.siblingLabel).addClass(T.active):o.addClass(T.active):o.next(R.siblingLabel).addClass(T.active),e.preventDefault())):t==n.deleteKey||t==n.backspace?l?(S.verbose("Removing active labels"),d&&v&&!m&&S.focusSearch(),o.last().next(R.siblingLabel).addClass(T.active),S.remove.activeLabels(o),e.preventDefault()):h&&!l&&t==n.backspace&&(S.verbose("Removing last label on input backspace"),o=a.last().addClass(T.active),S.remove.activeLabels(o)):o.removeClass(T.active)}}},keydown:function(e){var t=e.which,n=S.get.shortcutKeys(),i=S.is.inObject(t,n);if(i){var a,o,s=K.not(R.unselectable).filter("."+T.selected).eq(0),r=N.children("."+T.active).eq(0),l=s.length>0?s:r,c=l.length>0?l.siblings(":not(."+T.filtered+")").andSelf():N.children(":not(."+T.filtered+")"),u=l.children(R.menu),d=l.closest(R.menu),v=d.hasClass(T.visible)||d.hasClass(T.animating)||d.parent(R.menu).length>0,m=u.length>0,f=l.length>0,h=l.not(R.unselectable).length>0,g=t==n.delimiter&&y.allowAdditions&&S.is.multiple();if(S.is.visible()){if((t==n.enter||g)&&(t==n.enter&&f&&m&&!y.allowCategorySelection?(S.verbose("Pressed enter on unselectable category, opening sub menu"),t=n.rightArrow):h&&(S.verbose("Selecting item from keyboard shortcut",l),S.event.item.click.call(l,e),S.is.searchSelection()&&S.remove.searchTerm()),e.preventDefault()),t==n.leftArrow&&(o=d[0]!==N[0],o&&(S.verbose("Left key pressed, closing sub-menu"),S.animate.hide(!1,d),l.removeClass(T.selected),d.closest(R.item).addClass(T.selected),e.preventDefault())),t==n.rightArrow&&m&&(S.verbose("Right key pressed, opening sub-menu"),S.animate.show(!1,u),l.removeClass(T.selected),u.find(R.item).eq(0).addClass(T.selected),e.preventDefault()),t==n.upArrow){if(a=f&&v?l.prevAll(R.item+":not("+R.unselectable+")").eq(0):K.eq(0),c.index(a)<0)return S.verbose("Up key pressed but reached top of current menu"),void e.preventDefault();S.verbose("Up key pressed, changing active item"),l.removeClass(T.selected),a.addClass(T.selected),S.set.scrollPosition(a),e.preventDefault()}if(t==n.downArrow){if(a=f&&v?a=l.nextAll(R.item+":not("+R.unselectable+")").eq(0):K.eq(0),0===a.length)return S.verbose("Down key pressed but reached bottom of current menu"),void e.preventDefault();S.verbose("Down key pressed, changing active item"),K.removeClass(T.selected),a.addClass(T.selected),S.set.scrollPosition(a),e.preventDefault()}t==n.pageUp&&(S.scrollPage("up"),e.preventDefault()),t==n.pageDown&&(S.scrollPage("down"),e.preventDefault()),t==n.escape&&(S.verbose("Escape key pressed, closing dropdown"),S.hide())}else g&&e.preventDefault(),t==n.downArrow&&(S.verbose("Down key pressed, showing dropdown"),S.show(),e.preventDefault())}else S.is.selection()&&!S.is.search()&&S.set.selectedLetter(String.fromCharCode(t))}},determine:{selectAction:function(t,n){S.verbose("Determining action",y.action),e.isFunction(S.action[y.action])?(S.verbose("Triggering preset action",y.action,t,n),S.action[y.action].call(this,t,n)):e.isFunction(y.action)?(S.verbose("Triggering user action",y.action,t,n),y.action.call(this,t,n)):S.error(q.action,y.action)},eventInModule:function(t,i){var a=e(t.target),o=a.closest(n.documentElement).length>0,s=a.closest(F).length>0;return i=e.isFunction(i)?i:function(){},o&&!s?(S.verbose("Triggering event",i),i(),!0):(S.verbose("Event occurred in dropdown, canceling callback"),!1)},eventOnElement:function(t,n){var i=e(t.target),a=i.closest(R.siblingLabel),o=0===F.find(a).length,s=0===i.closest(N).length;return n=e.isFunction(n)?n:function(){},o&&s?(S.verbose("Triggering event",n),n(),!0):(S.verbose("Event occurred in dropdown menu, canceling callback"),!1)}},action:{nothing:function(){},activate:function(t,n){if(n=n!==i?n:t,S.can.activate(e(this))){if(S.set.selected(n,e(this)),S.is.multiple()&&!S.is.allFiltered())return;S.hideAndClear()}},select:function(e,t){S.action.activate.call(this)},combo:function(t,n){n=n!==i?n:t,S.set.selected(n,e(this)),S.hideAndClear()},hide:function(e,t){S.set.value(t),S.hideAndClear()}},get:{id:function(){return w},defaultText:function(){return F.data(L.defaultText)},defaultValue:function(){return F.data(L.defaultValue)},placeholderText:function(){return F.data(L.placeholderText)||""},text:function(){return M.text()},query:function(){return e.trim(z.val())},searchWidth:function(e){return e*y.glyphWidth+"em"},selectionCount:function(){var t,n=S.get.values();return t=S.is.multiple()?e.isArray(n)?n.length:0:""!==S.get.value()?1:0},transition:function(e){return"auto"==y.transition?S.is.upward(e)?"slide up":"slide down":y.transition},userValues:function(){var t=S.get.values();return t?(t=e.isArray(t)?t:[t],e.grep(t,function(e){return S.get.item(e)===!1})):!1},uniqueArray:function(t){return e.grep(t,function(n,i){return e.inArray(n,t)===i})},caretPosition:function(){var e,t,i=z.get(0);return"selectionStart"in i?i.selectionStart:n.selection?(i.focus(),e=n.selection.createRange(),t=e.text.length,e.moveStart("character",-i.value.length),e.text.length-t):void 0},shortcutKeys:function(){return{backspace:8,delimiter:188,deleteKey:46,enter:13,escape:27,pageUp:33,pageDown:34,leftArrow:37,upArrow:38,rightArrow:39,downArrow:40}},value:function(){var t=H.length>0?H.val():F.data(L.value);return e.isArray(t)&&1===t.length&&""===t[0]?"":t},values:function(){var e=S.get.value();return""===e?"":!S.has.selectInput()&&S.is.multiple()?"string"==typeof e?e.split(y.delimiter):"":e},remoteValues:function(){var t=S.get.values(),n=!1;return t&&("string"==typeof t&&(t=[t]),n={},e.each(t,function(e,t){var i=S.read.remoteData(t);S.verbose("Restoring value from session data",i,t),n[t]=i?i:t})),n},choiceText:function(t,n){return n=n!==i?n:y.preserveHTML,t?(t.find(R.menu).length>0&&(S.verbose("Retreiving text of element with sub-menu"),t=t.clone(),t.find(R.menu).remove(),t.find(R.menuIcon).remove()),t.data(L.text)!==i?t.data(L.text):e.trim(n?t.html():t.text())):void 0},choiceValue:function(t,n){return n=n||S.get.choiceText(t),t?t.data(L.value)!==i?String(t.data(L.value)):"string"==typeof n?e.trim(n.toLowerCase()):String(n):!1},inputEvent:function(){var e=z[0];return e?e.oninput!==i?"input":e.onpropertychange!==i?"propertychange":"keyup":!1},selectValues:function(){var t={};return t.values=[],F.find("option").each(function(){var n=e(this),a=n.html(),o=n.attr("disabled"),s=n.attr("value")!==i?n.attr("value"):a;"auto"===y.placeholder&&""===s?t.placeholder=a:t.values.push({name:a,value:s,disabled:o})}),y.placeholder&&"auto"!==y.placeholder&&(S.debug("Setting placeholder value to",y.placeholder),t.placeholder=y.placeholder),y.sortSelect?(t.values.sort(function(e,t){return e.name>t.name?1:-1}),S.debug("Retrieved and sorted values from select",t)):S.debug("Retreived values from select",t),t},activeItem:function(){return K.filter("."+T.active)},selectedItem:function(){var e=K.not(R.unselectable).filter("."+T.selected);return e.length>0?e:K.eq(0)},itemWithAdditions:function(e){var t=S.get.item(e),n=S.create.userChoice(e),i=n&&n.length>0;return i&&(t=t.length>0?t.add(n):n),t},item:function(t,n){var a,o,s=!1;return t=t!==i?t:S.get.values()!==i?S.get.values():S.get.text(),a=o?t.length>0:t!==i&&null!==t,o=S.is.multiple()&&e.isArray(t),n=""===t||0===t?!0:n||!1,a&&K.each(function(){var a=e(this),r=S.get.choiceText(a),l=S.get.choiceValue(a,r);if(null!==l&&l!==i)if(o)(-1!==e.inArray(String(l),t)||-1!==e.inArray(r,t))&&(s=s?s.add(a):a);else if(n){if(S.verbose("Ambiguous dropdown value using strict type check",a,t),l===t||r===t)return s=a,!0}else if(String(l)==String(t)||r==t)return S.verbose("Found select item by value",l,t),s=a,!0}),s}},check:{maxSelections:function(e){return y.maxSelections?(e=e!==i?e:S.get.selectionCount(),e>=y.maxSelections?(S.debug("Maximum selection count reached"),y.useLabels&&(K.addClass(T.filtered),S.add.message(A.maxSelections)),!0):(S.verbose("No longer at maximum selection count"),S.remove.message(),S.remove.filteredItem(),S.is.searchSelection()&&S.filterItems(),!1)):!0}},restore:{defaults:function(){S.clear(),S.restore.defaultText(),S.restore.defaultValue()},defaultText:function(){var e=S.get.defaultText(),t=S.get.placeholderText;e===t?(S.debug("Restoring default placeholder text",e),S.set.placeholderText(e)):(S.debug("Restoring default text",e),S.set.text(e))},defaultValue:function(){var e=S.get.defaultValue();e!==i&&(S.debug("Restoring default value",e),""!==e?(S.set.value(e),S.set.selected()):(S.remove.activeItem(),S.remove.selectedItem()))},labels:function(){y.allowAdditions&&(y.useLabels||(S.error(q.labels),y.useLabels=!0),S.debug("Restoring selected values"),S.create.userLabels()),S.check.maxSelections()},selected:function(){S.restore.values(),S.is.multiple()?(S.debug("Restoring previously selected values and labels"),S.restore.labels()):S.debug("Restoring previously selected values")},values:function(){S.set.initialLoad(),y.apiSettings?y.saveRemoteData?S.restore.remoteValues():S.clearValue():S.set.selected(),S.remove.initialLoad()},remoteValues:function(){var t=S.get.remoteValues();S.debug("Recreating selected from session data",t),t&&(S.is.single()?e.each(t,function(e,t){S.set.text(t)}):e.each(t,function(e,t){S.add.label(e,t)}))}},read:{remoteData:function(e){var n;return t.Storage===i?void S.error(q.noStorage):(n=sessionStorage.getItem(e),n!==i?n:!1)}},save:{defaults:function(){S.save.defaultText(),S.save.placeholderText(),S.save.defaultValue()},defaultValue:function(){var e=S.get.value();S.verbose("Saving default value as",e),F.data(L.defaultValue,e)},defaultText:function(){var e=S.get.text();S.verbose("Saving default text as",e),F.data(L.defaultText,e)},placeholderText:function(){var e;y.placeholder!==!1&&M.hasClass(T.placeholder)&&(e=S.get.text(),S.verbose("Saving placeholder text as",e),F.data(L.placeholderText,e))},remoteData:function(e,n){return t.Storage===i?void S.error(q.noStorage):(S.verbose("Saving remote data to session storage",n,e),void sessionStorage.setItem(n,e))}},clear:function(){S.is.multiple()?S.remove.labels():(S.remove.activeItem(),S.remove.selectedItem()),S.set.placeholderText(),S.clearValue()},clearValue:function(){S.set.value("")},scrollPage:function(e,t){var n,i,a,o=t||S.get.selectedItem(),s=o.closest(R.menu),r=s.outerHeight(),l=s.scrollTop(),c=K.eq(0).outerHeight(),u=Math.floor(r/c),d=(s.prop("scrollHeight"),"up"==e?l-c*u:l+c*u),v=K.not(R.unselectable);a="up"==e?v.index(o)-u:v.index(o)+u,n="up"==e?a>=0:a<v.length,i=n?v.eq(a):"up"==e?v.first():v.last(),i.length>0&&(S.debug("Scrolling page",e,i),o.removeClass(T.selected),i.addClass(T.selected),s.scrollTop(d))},set:{filtered:function(){var e=S.is.multiple(),t=S.is.searchSelection(),n=e&&t,i=t?S.get.query():"",a="string"==typeof i&&i.length>0,o=S.get.searchWidth(i.length),s=""!==i;e&&a&&(S.verbose("Adjusting input width",o,y.glyphWidth),z.css("width",o)),a||n&&s?(S.verbose("Hiding placeholder text"),M.addClass(T.filtered)):(!e||n&&!s)&&(S.verbose("Showing placeholder text"),M.removeClass(T.filtered))},loading:function(){F.addClass(T.loading)},placeholderText:function(e){e=e||S.get.placeholderText(),S.debug("Setting placeholder text",e),S.set.text(e),M.addClass(T.placeholder)},tabbable:function(){S.has.search()?(S.debug("Added tabindex to searchable dropdown"),z.val("").attr("tabindex",0),N.attr("tabindex",-1)):(S.debug("Added tabindex to dropdown"),F.attr("tabindex")||(F.attr("tabindex",0),N.attr("tabindex",-1)))},initialLoad:function(){S.verbose("Setting initial load"),g=!0},activeItem:function(e){e.addClass(y.allowAdditions&&e.filter(R.addition).length>0?T.filtered:T.active)},scrollPosition:function(e,t){var n,a,o,s,r,l,c,u,d,v=5;e=e||S.get.selectedItem(),n=e.closest(R.menu),a=e&&e.length>0,t=t!==i?t:!1,e&&n.length>0&&a&&(s=e.position().top,n.addClass(T.loading),l=n.scrollTop(),r=n.offset().top,s=e.offset().top,o=l-r+s,t||(c=n.height(),d=o+v>l+c,u=l>o-v),S.debug("Scrolling to active item",o),(t||u||d)&&n.scrollTop(o),n.removeClass(T.loading))},text:function(e){"select"!==y.action&&("combo"==y.action?(S.debug("Changing combo button text",e,U),y.preserveHTML?U.html(e):U.text(e)):(e!==S.get.placeholderText()&&M.removeClass(T.placeholder),S.debug("Changing text",e,M),M.removeClass(T.filtered),y.preserveHTML?M.html(e):M.text(e)))},selectedLetter:function(t){var n,i=K.filter("."+T.selected),a=i.length>0&&S.has.firstLetter(i,t),o=!1;a&&(n=i.nextAll(K).eq(0),S.has.firstLetter(n,t)&&(o=n)),o||K.each(function(){return S.has.firstLetter(e(this),t)?(o=e(this),!1):void 0}),o&&(S.verbose("Scrolling to next value with letter",t),S.set.scrollPosition(o),i.removeClass(T.selected),o.addClass(T.selected))},direction:function(e){"auto"==y.direction?S.is.onScreen(e)?S.remove.upward(e):S.set.upward(e):"upward"==y.direction&&S.set.upward(e)},upward:function(e){var t=e||F;t.addClass(T.upward)},value:function(e,t,n){var a=H.length>0,o=(!S.has.value(e),S.get.values()),s=e!==i?String(e):e;if(a){if(s==o&&(S.verbose("Skipping value update already same value",e,o),!S.is.initialLoad()))return;S.is.single()&&S.has.selectInput()&&S.can.extendSelect()&&(S.debug("Adding user option",e),S.add.optionValue(e)),S.debug("Updating input value",e,o),$=!0,H.val(e),y.fireOnInit===!1&&S.is.initialLoad()?S.debug("Input native change event ignored on initial load"):H.trigger("change"),$=!1}else S.verbose("Storing value in metadata",e,H),e!==o&&F.data(L.value,s);y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("No callback on initial load",y.onChange):y.onChange.call(Q,e,t,n)},active:function(){F.addClass(T.active)},multiple:function(){F.addClass(T.multiple)},visible:function(){F.addClass(T.visible)},exactly:function(e,t){S.debug("Setting selected to exact values"),S.clear(),S.set.selected(e,t)},selected:function(t,n){var i=S.is.multiple();n=y.allowAdditions?n||S.get.itemWithAdditions(t):n||S.get.item(t),n&&(S.debug("Setting selected menu item to",n),S.is.single()?(S.remove.activeItem(),S.remove.selectedItem()):y.useLabels&&S.remove.selectedItem(),n.each(function(){var t=e(this),a=S.get.choiceText(t),o=S.get.choiceValue(t,a),s=t.hasClass(T.filtered),r=t.hasClass(T.active),l=t.hasClass(T.addition),c=i&&1==n.length;i?!r||l?(y.apiSettings&&y.saveRemoteData&&S.save.remoteData(a,o),y.useLabels?(S.add.value(o,a,t),S.add.label(o,a,c),S.set.activeItem(t),S.filterActive(),S.select.nextAvailable(n)):(S.add.value(o,a,t),S.set.text(S.add.variables(A.count)),S.set.activeItem(t))):s||(S.debug("Selected active value, removing label"),S.remove.selected(o)):(y.apiSettings&&y.saveRemoteData&&S.save.remoteData(a,o),S.set.text(a),S.set.value(o,a,t),t.addClass(T.active).addClass(T.selected))}))}},add:{label:function(t,n,i){var a,o=S.is.searchSelection()?z:M;return a=e("<a />").addClass(T.label).attr("data-value",t).html(V.label(t,n)),a=y.onLabelCreate.call(a,t,n),S.has.label(t)?void S.debug("Label already exists, skipping",t):(y.label.variation&&a.addClass(y.label.variation),void(i===!0?(S.debug("Animating in label",a),a.addClass(T.hidden).insertBefore(o).transition(y.label.transition,y.label.duration)):(S.debug("Adding selection label",a),a.insertBefore(o))))},message:function(t){var n=N.children(R.message),i=y.templates.message(S.add.variables(t));n.length>0?n.html(i):n=e("<div/>").html(i).addClass(T.message).appendTo(N)},optionValue:function(t){var n=H.find('option[value="'+t+'"]'),i=n.length>0;i||(x&&(x.disconnect(),S.verbose("Temporarily disconnecting mutation observer",t)),S.is.single()&&(S.verbose("Removing previous user addition"),H.find("option."+T.addition).remove()),e("<option/>").prop("value",t).addClass(T.addition).html(t).appendTo(H),S.verbose("Adding user addition as an <option>",t),x&&x.observe(H[0],{childList:!0,subtree:!0}))},userSuggestion:function(e){var t,n=N.children(R.addition),i=S.get.item(e),a=i&&i.not(R.addition).length,o=n.length>0;if(!y.useLabels||!S.has.maxSelections()){if(""===e||a)return void n.remove();K.removeClass(T.selected),o?(t=y.templates.addition(S.add.variables(A.addResult,e)),n.html(t).attr("data-"+L.value,e).attr("data-"+L.text,e).removeClass(T.filtered).addClass(T.selected),S.verbose("Replacing user suggestion with new value",n)):(n=S.create.userChoice(e),n.prependTo(N).addClass(T.selected),S.verbose("Adding item choice to menu corresponding with user choice addition",n))}},variables:function(e,t){var n,i,a=-1!==e.search("{count}"),o=-1!==e.search("{maxCount}"),s=-1!==e.search("{term}");return S.verbose("Adding templated variables to message",e),a&&(n=S.get.selectionCount(),e=e.replace("{count}",n)),o&&(n=S.get.selectionCount(),e=e.replace("{maxCount}",y.maxSelections)),s&&(i=t||S.get.query(),e=e.replace("{term}",i)),e},value:function(t,n,i){var a,o=S.get.values();return""===t?void S.debug("Cannot select blank values from multiselect"):(e.isArray(o)?(a=o.concat([t]),a=S.get.uniqueArray(a)):a=[t],S.has.selectInput()?S.can.extendSelect()&&(S.debug("Adding value to select",t,a,H),S.add.optionValue(t)):(a=a.join(y.delimiter),S.debug("Setting hidden input to delimited value",a,H)),y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("Skipping onadd callback on initial load",y.onAdd):y.onAdd.call(Q,t,n,i),S.set.value(a,t,n,i),void S.check.maxSelections())}},remove:{active:function(){F.removeClass(T.active)},activeLabel:function(){F.find(R.label).removeClass(T.active)},loading:function(){F.removeClass(T.loading)},initialLoad:function(){g=!1},upward:function(e){var t=e||F;t.removeClass(T.upward)},visible:function(){F.removeClass(T.visible)},activeItem:function(){K.removeClass(T.active)},filteredItem:function(){y.useLabels&&S.has.maxSelections()||(y.useLabels&&S.is.multiple()?K.not("."+T.active).removeClass(T.filtered):K.removeClass(T.filtered))},optionValue:function(e){var t=H.find('option[value="'+e+'"]'),n=t.length>0;n&&t.hasClass(T.addition)&&(x&&(x.disconnect(),S.verbose("Temporarily disconnecting mutation observer",e)),t.remove(),S.verbose("Removing user addition as an <option>",e),x&&x.observe(H[0],{childList:!0,subtree:!0}))},message:function(){N.children(R.message).remove()},searchTerm:function(){S.verbose("Cleared search term"),z.val(""),S.set.filtered()},selected:function(t,n){return(n=y.allowAdditions?n||S.get.itemWithAdditions(t):n||S.get.item(t))?void n.each(function(){var t=e(this),n=S.get.choiceText(t),i=S.get.choiceValue(t,n);S.is.multiple()?y.useLabels?(S.remove.value(i,n,t),S.remove.label(i)):(S.remove.value(i,n,t),0===S.get.selectionCount()?S.set.placeholderText():S.set.text(S.add.variables(A.count))):S.remove.value(i,n,t),t.removeClass(T.filtered).removeClass(T.active),
y.useLabels&&t.removeClass(T.selected)}):!1},selectedItem:function(){K.removeClass(T.selected)},value:function(e,t,n){var i,a=S.get.values();S.has.selectInput()?(S.verbose("Input is <select> removing selected option",e),i=S.remove.arrayValue(e,a),S.remove.optionValue(e)):(S.verbose("Removing from delimited values",e),i=S.remove.arrayValue(e,a),i=i.join(y.delimiter)),y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("No callback on initial load",y.onRemove):y.onRemove.call(Q,e,t,n),S.set.value(i,t,n),S.check.maxSelections()},arrayValue:function(t,n){return e.isArray(n)||(n=[n]),n=e.grep(n,function(e){return t!=e}),S.verbose("Removed value from delimited string",t,n),n},label:function(e,t){var n=F.find(R.label),i=n.filter('[data-value="'+e+'"]');S.verbose("Removing label",i),i.remove()},activeLabels:function(e){e=e||F.find(R.label).filter("."+T.active),S.verbose("Removing active label selections",e),S.remove.labels(e)},labels:function(t){t=t||F.find(R.label),S.verbose("Removing labels",t),t.each(function(){var t=e(this).data(L.value),n=t!==i?String(t):t,a=S.is.userValue(n);a?(S.remove.value(n),S.remove.label(n)):S.remove.selected(n)})},tabbable:function(){S.has.search()?(S.debug("Searchable dropdown initialized"),z.attr("tabindex","-1"),N.attr("tabindex","-1")):(S.debug("Simple selection dropdown initialized"),F.attr("tabindex","-1"),N.attr("tabindex","-1"))}},has:{search:function(){return z.length>0},selectInput:function(){return H.is("select")},firstLetter:function(e,t){var n,i;return e&&0!==e.length&&"string"==typeof t?(n=S.get.choiceText(e,!1),t=t.toLowerCase(),i=String(n).charAt(0).toLowerCase(),t==i):!1},input:function(){return H.length>0},items:function(){return K.length>0},menu:function(){return N.length>0},message:function(){return 0!==N.children(R.message).length},label:function(e){var t=F.find(R.label);return t.filter('[data-value="'+e+'"]').length>0},maxSelections:function(){return y.maxSelections&&S.get.selectionCount()>=y.maxSelections},allResultsFiltered:function(){return K.filter(R.unselectable).length===K.length},query:function(){return""!==S.get.query()},value:function(t){var n=S.get.values(),i=e.isArray(n)?n&&-1!==e.inArray(t,n):n==t;return i?!0:!1}},is:{active:function(){return F.hasClass(T.active)},alreadySetup:function(){return F.is("select")&&F.parent(R.dropdown).length>0&&0===F.prev().length},animating:function(e){return e?e.transition&&e.transition("is animating"):N.transition&&N.transition("is animating")},disabled:function(){return F.hasClass(T.disabled)},focused:function(){return n.activeElement===F[0]},focusedOnSearch:function(){return n.activeElement===z[0]},allFiltered:function(){return(S.is.multiple()||S.has.search())&&!S.has.message()&&S.has.allResultsFiltered()},hidden:function(e){return!S.is.visible(e)},initialLoad:function(){return g},onScreen:function(e){var t,n=e||N,i=!0,a={};return n.addClass(T.loading),t={context:{scrollTop:P.scrollTop(),height:P.outerHeight()},menu:{offset:n.offset(),height:n.outerHeight()}},a={above:t.context.scrollTop<=t.menu.offset.top-t.menu.height,below:t.context.scrollTop+t.context.height>=t.menu.offset.top+t.menu.height},a.below?(S.verbose("Dropdown can fit in context downward",a),i=!0):a.below||a.above?(S.verbose("Dropdown cannot fit below, opening upward",a),i=!1):(S.verbose("Dropdown cannot fit in either direction, favoring downward",a),i=!0),n.removeClass(T.loading),i},inObject:function(t,n){var i=!1;return e.each(n,function(e,n){return n==t?(i=!0,!0):void 0}),i},multiple:function(){return F.hasClass(T.multiple)},single:function(){return!S.is.multiple()},selectMutation:function(t){var n=!1;return e.each(t,function(t,i){return i.target&&e(i.target).is("select")?(n=!0,!0):void 0}),n},search:function(){return F.hasClass(T.search)},searchSelection:function(){return S.has.search()&&1===z.parent(R.dropdown).length},selection:function(){return F.hasClass(T.selection)},userValue:function(t){return-1!==e.inArray(t,S.get.userValues())},upward:function(e){var t=e||F;return t.hasClass(T.upward)},visible:function(e){return e?e.hasClass(T.visible):N.hasClass(T.visible)}},can:{activate:function(e){return y.useLabels?!0:S.has.maxSelections()?S.has.maxSelections()&&e.hasClass(T.active)?!0:!1:!0},click:function(){return c||"click"==y.on},extendSelect:function(){return y.allowAdditions||y.apiSettings},show:function(){return!S.is.disabled()&&(S.has.items()||S.has.message())},useAPI:function(){return e.fn.api!==i}},animate:{show:function(t,n){var a,o=n||N,s=n?function(){}:function(){S.hideSubMenus(),S.hideOthers(),S.set.active()};t=e.isFunction(t)?t:function(){},S.verbose("Doing menu show animation",o),S.set.direction(n),a=S.get.transition(n),S.is.selection()&&S.set.scrollPosition(S.get.selectedItem(),!0),(S.is.hidden(o)||S.is.animating(o))&&("none"==a?(s(),o.transition("show"),t.call(Q)):e.fn.transition!==i&&F.transition("is supported")?o.transition({animation:a+" in",debug:y.debug,verbose:y.verbose,duration:y.duration,queue:!0,onStart:s,onComplete:function(){t.call(Q)}}):S.error(q.noTransition,a))},hide:function(t,n){var a=n||N,o=(n?.9*y.duration:y.duration,n?function(){}:function(){S.can.click()&&S.unbind.intent(),S.remove.active()}),s=S.get.transition(n);t=e.isFunction(t)?t:function(){},(S.is.visible(a)||S.is.animating(a))&&(S.verbose("Doing menu hide animation",a),"none"==s?(o(),a.transition("hide"),t.call(Q)):e.fn.transition!==i&&F.transition("is supported")?a.transition({animation:s+" out",duration:y.duration,debug:y.debug,verbose:y.verbose,queue:!0,onStart:o,onComplete:function(){"auto"==y.direction&&S.remove.upward(n),t.call(Q)}}):S.error(q.transition))}},hideAndClear:function(){S.remove.searchTerm(),S.has.maxSelections()||(S.has.search()?S.hide(function(){S.remove.filteredItem()}):S.hide())},delay:{show:function(){S.verbose("Delaying show event to ensure user intent"),clearTimeout(S.timer),S.timer=setTimeout(S.show,y.delay.show)},hide:function(){S.verbose("Delaying hide event to ensure user intent"),clearTimeout(S.timer),S.timer=setTimeout(S.hide,y.delay.hide)}},escape:{regExp:function(e){return e=String(e),e.replace(I.escape,"\\$&")}},setting:function(t,n){if(S.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,y,t);else{if(n===i)return y[t];y[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,S,t);else{if(n===i)return S[t];S[t]=n}},debug:function(){y.debug&&(y.performance?S.performance.log(arguments):(S.debug=Function.prototype.bind.call(console.info,console,y.name+":"),S.debug.apply(console,arguments)))},verbose:function(){y.verbose&&y.debug&&(y.performance?S.performance.log(arguments):(S.verbose=Function.prototype.bind.call(console.info,console,y.name+":"),S.verbose.apply(console,arguments)))},error:function(){S.error=Function.prototype.bind.call(console.error,console,y.name+":"),S.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;y.performance&&(t=(new Date).getTime(),i=u||t,n=t-i,u=t,d.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:Q,"Execution Time":n})),clearTimeout(S.performance.timer),S.performance.timer=setTimeout(S.performance.display,500)},display:function(){var t=y.name+":",n=0;u=!1,clearTimeout(S.performance.timer),e.each(d,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",l&&(t+=" '"+l+"'"),(console.group!==i||console.table!==i)&&d.length>0&&(console.groupCollapsed(t),console.table?console.table(d):e.each(d,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),d=[]}},invoke:function(t,n,a){var s,r,l,c=Y;return n=n||f,a=Q||a,"string"==typeof t&&c!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,a){var o=n!=s?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(c[o])&&n!=s)c=c[o];else{if(c[o]!==i)return r=c[o],!1;if(!e.isPlainObject(c[a])||n==s)return c[a]!==i?(r=c[a],!1):(S.error(q.method,t),!1);c=c[a]}})),e.isFunction(r)?l=r.apply(a,n):r!==i&&(l=r),e.isArray(o)?o.push(l):o!==i?o=[o,l]:l!==i&&(o=l),r}},m?(Y===i&&S.initialize(),S.invoke(v)):(Y!==i&&Y.invoke("destroy"),S.initialize())}),o!==i?o:s},e.fn.dropdown.settings={debug:!1,verbose:!1,performance:!0,on:"click",action:"activate",apiSettings:!1,saveRemoteData:!0,throttle:200,context:t,direction:"auto",keepOnScreen:!0,match:"both",fullTextSearch:!1,placeholder:"auto",preserveHTML:!0,sortSelect:!1,forceSelection:!0,allowAdditions:!1,maxSelections:!1,useLabels:!0,delimiter:",",showOnFocus:!0,allowTab:!0,allowCategorySelection:!1,fireOnInit:!1,transition:"auto",duration:200,glyphWidth:1.0714,label:{transition:"scale",duration:200,variation:!1},delay:{hide:300,show:200,search:20,touch:50},onChange:function(e,t,n){},onAdd:function(e,t,n){},onRemove:function(e,t,n){},onLabelSelect:function(e){},onLabelCreate:function(t,n){return e(this)},onNoResults:function(e){return!0},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",message:{addResult:"Add <b>{term}</b>",count:"{count} selected",maxSelections:"Max {maxCount} selections",noResults:"No results found.",serverError:"There was an error contacting the server"},error:{action:"You called a dropdown action that was not defined",alreadySetup:"Once a select has been initialized behaviors must be called on the created ui dropdown",labels:"Allowing user additions currently requires the use of labels.",missingMultiple:"<select> requires multiple property to be set to correctly preserve multiple values",method:"The method you called is not defined.",noAPI:"The API module is required to load resources remotely",noStorage:"Saving remote data requires session storage",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>"},regExp:{escape:/[-[\]{}()*+?.,\\^$|#\s]/g},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",placeholderText:"placeholder",text:"text",value:"value"},fields:{values:"values",name:"name",value:"value"},selector:{addition:".addition",dropdown:".ui.dropdown",icon:"> .dropdown.icon",input:'> input[type="hidden"], > select',item:".item",label:"> .label",remove:"> .label > .delete.icon",siblingLabel:".label",menu:".menu",message:".message",menuIcon:".dropdown.icon",search:"input.search, .menu > .search > input",text:"> .text:not(.icon)",unselectable:".disabled, .filtered"},className:{active:"active",addition:"addition",animating:"animating",disabled:"disabled",dropdown:"ui dropdown",filtered:"filtered",hidden:"hidden transition",item:"item",label:"ui label",loading:"loading",menu:"menu",message:"message",multiple:"multiple",placeholder:"default",search:"search",selected:"selected",selection:"selection",upward:"upward",visible:"visible"}},e.fn.dropdown.settings.templates={dropdown:function(t){var n=t.placeholder||!1,i=(t.values||{},"");return i+='<i class="dropdown icon"></i>',i+=t.placeholder?'<div class="default text">'+n+"</div>":'<div class="text"></div>',i+='<div class="menu">',e.each(t.values,function(e,t){i+=t.disabled?'<div class="disabled item" data-value="'+t.value+'">'+t.name+"</div>":'<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),i+="</div>"},menu:function(t,n){var i=(t.values||{},"");return e.each(t[n.values],function(e,t){i+='<div class="item" data-value="'+t[n.value]+'">'+t[n.name]+"</div>"}),i},label:function(e,t){return t+'<i class="delete icon"></i>'},message:function(e){return e},addition:function(e){return e}}}(jQuery,window,document);