//////////////////////////////////////////////////////////////////// 
//
//  AbcText
//  by Ange Capalini
//  Originally Written  10/31/2011
//  code released to the public domain
// 
//////////////////////////////////////////////////////////////////// 
 
 
//==================================================================
//               INSTRUCTIONS
//==================================================================
//
//  - set Max Particles to 4096
//  - create white cube "board" <15.500, 0.010, 0.800>
//  - create red cube "cursor" <0.050, 0.010, 0.030> & drop AbcText
//  - link cursor (child) to board (root)
//  - send message <= 25 char. to chanel 20
//  - that's all folk's
//
/////////////////////////////////////////////////////////////////////
 
 
//===========================================
//               CONSTANTS
//===========================================
float  Size_Point = 0.1; //pixel size
string Txt_Point = "";  //pixel texture
vector Color_Point = < 0., 0., 1. >; //pixel color
vector Size_Affich = <15.5, .01, .8>; //display size
 
//===========================================
//           GLOBALS VARIABLES
//===========================================
list Alphabet = [   " ",
                    "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M",
                    "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z",
 
                    "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m",
                    "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z",
 
                    "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", 
 
                    ":", "'", ",", "!", "?", "#", ".", "/", "-", "�", "�", "�"     ];
 
//char matrix 6 x 5 points
list Matrices = [ " ", 
                    "011001001010010111101001000000", //A
                    "111001001011100100101110000000",
                    "011001000010000100000110000000",
                    "111001001010010100101110000000",
                    "111001000011100100001110000000",
                    "111001000011100100001000000000",
                    "011101000010110100100111000000",
                    "100101001011110100101001000000",
                    "111000100001000010001110000000",
                    "001100001000010100100110000000",
                    "100101010011000101001001000000",
                    "100001000010000100001110000000",
                    "100011101110101100011000100000",
                    "100101101010110100101001000000",
                    "011001001010010100100110000000",
                    "111001001010010111001000000000",
                    "011001001010010100100110000010",
                    "111001001010010111001001000000",
                    "011101000001100000101110000000",
                    "111000100001000010000100000000",
                    "100101001010010100100110000000",
                    "100101001010100101000100000000",
                    "100011010110101101010101000000",
                    "100101001001100100101001000000",
                    "100101001001110000100110000000",
                    "111100001001100100001111000000", //Z
 
                    "000000110010010100100111000000", //a
                    "100001110010010100101110000000",
                    "000000110010000100000110000000",
                    "000100111010010100100111000000",
                    "000000111010010101000111000000",
                    "011001000011000100001000000000",
                    "011001001010010011100001001100",
                    "100001110010010100101001000000",
                    "100000000010000100001000000000",
                    "001000000000100001000010011000",
                    "100001001010100110101001000000",
                    "100001000010000100001000000000",
                    "000001101010101101011010100000",
                    "000001110010010100101001000000",
                    "000000110010010100100110000000",
                    "111001001010010111001000010000",
                    "011101001010010011100001000010",
                    "000001010011000100001000000000",
                    "000000111011000001101110000000",
                    "010001110001000010000100000000",
                    "000001001010010100100111000000",
                    "000001001010010100100110000000",
                    "000001010110101101010101000000",
                    "000001001001100011001001000000",
                    "100101001010010011100001001100",
                    "000001111000100010001111000000", //z
 
                    "011001001010010100100110000000", //0
                    "011000010000100001000010000000",
                    "111000001001100100001111000000",
                    "111000001001100000101110000000",
                    "001000110010100111100010000000",
                    "111101000011100000101110000000",
                    "011001000011100100100110000000",
                    "111100001000100010000100000000",
                    "011001001001100100100110000000",
                    "011001001001110000100110000000", //9
 
                    "000000000000100000000010000000", //:
                    "000100010000000000000000000000",
                    "000000000000000000100010000000",
                    "001000010000100000000010000000",
                    "001000101000010001000000000100",
                    "010101111101010111110101000000", 
                    "000000000000000000000010000000", 
                    "000010001000100010001000000000", 
                    "000000000001110000000000000000", 
                    "000100110010010101000111000000",
                    "010000111010010101000111000000",
                    "010000110010010100100111000000"  //�
                    ];
 
list    Particle_Parameters=[];
vector  Origine;
string  Texte;
integer id_Phrase;
integer len_Phrase;
integer id_Lettre;
string  Lettre;
string  matrice_Lettre;
vector  point_zero;
integer x;
integer z;
 
//===========================================
//        SET PARTICLES
//===========================================
 
init_particles(){
 
    Particle_Parameters = [  
           PSYS_SRC_TEXTURE, Txt_Point, 
           PSYS_PART_START_SCALE, < Size_Point, Size_Point, FALSE >, 
           PSYS_PART_END_SCALE,   < Size_Point, Size_Point, FALSE >, 
           PSYS_PART_START_COLOR, Color_Point,    
           PSYS_PART_END_COLOR,   Color_Point, 
 
           PSYS_SRC_BURST_PART_COUNT, (integer)1, 
           PSYS_SRC_BURST_RATE, (float) 0.0,  
           PSYS_PART_MAX_AGE, (float) 30.0, 
 
           PSYS_SRC_PATTERN, (integer) 1,
 
           PSYS_PART_FLAGS,
           PSYS_PART_EMISSIVE_MASK
           ];
}
 
//===========================================
//          SET DISPLAY
//===========================================
affichage (string phrase) {
 
    integer len_Phrase = llStringLength(phrase)-1;  
    for(id_Phrase = 0; id_Phrase <= len_Phrase;++id_Phrase){ 
        Lettre = llGetSubString(phrase, id_Phrase, id_Phrase);
        id_Lettre = llListFindList(Alphabet, [Lettre]);
        matrice_Lettre = llList2String(Matrices, id_Lettre); 
        z=0; 
        do{ 
            x=0;
            do{
                if( (integer)llGetSubString(matrice_Lettre, x + 5*z, x + 5*z) ) {
                    llSetLinkPrimitiveParamsFast(LINK_THIS, [PRIM_POSITION, point_zero + < x*Size_Point, 0.0, -z*Size_Point > ]);
                    llParticleSystem( Particle_Parameters );
                    llSleep(0.12);
                    llParticleSystem( [] );
                }
            } while( ++x <= 4);
        } while( ++z <= 5);
 
        point_zero += < 6. * Size_Point, 0.0, 0.0 >; //locate next char
    }
}
/////////////////////////////////////
///////////////////////////////////// 
/////////////////////////////////////
/////////////////////////////////////
 
 
default {
 
    state_entry() {
 
        llListen(20, "", llGetOwner(), "");
        init_particles(); 
        Origine = < (-0.48 * Size_Affich.x) , (-1.25 * Size_Point) , (0.3 * Size_Affich.z)  >; //raz cursor
    }
 
    listen( integer channel, string name, key id, string msg ) {
 
        Texte = msg;
        point_zero = Origine;    //raz cursor         
        llSetTimerEvent(30.);
        affichage(Texte);
    } 
 
    timer(){
 
        point_zero = Origine;  //raz cursor
        affichage(Texte);
    }
 
    on_rez(integer param) {llResetScript();}
    changed(integer mask) {if(mask & CHANGED_OWNER) {llResetScript();}} 
 
}
