"no use strict";
;(function(window) {
if (typeof window.window != "undefined" && window.document)
    return;
if (window.require && window.define)
    return;

if (!window.console) {
    window.console = function() {
        var msgs = Array.prototype.slice.call(arguments, 0);
        postMessage({type: "log", data: msgs});
    };
    window.console.error =
    window.console.warn = 
    window.console.log =
    window.console.trace = window.console;
}
window.window = window;
window.ace = window;

window.onerror = function(message, file, line, col, err) {
    postMessage({type: "error", data: {
        message: message,
        data: err.data,
        file: file,
        line: line, 
        col: col,
        stack: err.stack
    }});
};

window.normalizeModule = function(parentId, moduleName) {
    // normalize plugin requires
    if (moduleName.indexOf("!") !== -1) {
        var chunks = moduleName.split("!");
        return window.normalizeModule(parentId, chunks[0]) + "!" + window.normalizeModule(parentId, chunks[1]);
    }
    // normalize relative requires
    if (moduleName.charAt(0) == ".") {
        var base = parentId.split("/").slice(0, -1).join("/");
        moduleName = (base ? base + "/" : "") + moduleName;
        
        while (moduleName.indexOf(".") !== -1 && previous != moduleName) {
            var previous = moduleName;
            moduleName = moduleName.replace(/^\.\//, "").replace(/\/\.\//, "/").replace(/[^\/]+\/\.\.\//, "");
        }
    }
    
    return moduleName;
};

window.require = function require(parentId, id) {
    if (!id) {
        id = parentId;
        parentId = null;
    }
    if (!id.charAt)
        throw new Error("worker.js require() accepts only (parentId, id) as arguments");

    id = window.normalizeModule(parentId, id);

    var module = window.require.modules[id];
    if (module) {
        if (!module.initialized) {
            module.initialized = true;
            module.exports = module.factory().exports;
        }
        return module.exports;
    }
   
    if (!window.require.tlns)
        return console.log("unable to load " + id);
    
    var path = resolveModuleId(id, window.require.tlns);
    if (path.slice(-3) != ".js") path += ".js";
    
    window.require.id = id;
    window.require.modules[id] = {}; // prevent infinite loop on broken modules
    importScripts(path);
    return window.require(parentId, id);
};
function resolveModuleId(id, paths) {
    var testPath = id, tail = "";
    while (testPath) {
        var alias = paths[testPath];
        if (typeof alias == "string") {
            return alias + tail;
        } else if (alias) {
            return  alias.location.replace(/\/*$/, "/") + (tail || alias.main || alias.name);
        } else if (alias === false) {
            return "";
        }
        var i = testPath.lastIndexOf("/");
        if (i === -1) break;
        tail = testPath.substr(i) + tail;
        testPath = testPath.slice(0, i);
    }
    return id;
}
window.require.modules = {};
window.require.tlns = {};

window.define = function(id, deps, factory) {
    if (arguments.length == 2) {
        factory = deps;
        if (typeof id != "string") {
            deps = id;
            id = window.require.id;
        }
    } else if (arguments.length == 1) {
        factory = id;
        deps = [];
        id = window.require.id;
    }
    
    if (typeof factory != "function") {
        window.require.modules[id] = {
            exports: factory,
            initialized: true
        };
        return;
    }

    if (!deps.length)
        // If there is no dependencies, we inject "require", "exports" and
        // "module" as dependencies, to provide CommonJS compatibility.
        deps = ["require", "exports", "module"];

    var req = function(childId) {
        return window.require(id, childId);
    };

    window.require.modules[id] = {
        exports: {},
        factory: function() {
            var module = this;
            var returnExports = factory.apply(this, deps.map(function(dep) {
                switch (dep) {
                    // Because "require", "exports" and "module" aren't actual
                    // dependencies, we must handle them seperately.
                    case "require": return req;
                    case "exports": return module.exports;
                    case "module":  return module;
                    // But for all other dependencies, we can just go ahead and
                    // require them.
                    default:        return req(dep);
                }
            }));
            if (returnExports)
                module.exports = returnExports;
            return module;
        }
    };
};
window.define.amd = {};
require.tlns = {};
window.initBaseUrls  = function initBaseUrls(topLevelNamespaces) {
    for (var i in topLevelNamespaces)
        require.tlns[i] = topLevelNamespaces[i];
};

window.initSender = function initSender() {

    var EventEmitter = window.require("ace/lib/event_emitter").EventEmitter;
    var oop = window.require("ace/lib/oop");
    
    var Sender = function() {};
    
    (function() {
        
        oop.implement(this, EventEmitter);
                
        this.callback = function(data, callbackId) {
            postMessage({
                type: "call",
                id: callbackId,
                data: data
            });
        };
    
        this.emit = function(name, data) {
            postMessage({
                type: "event",
                name: name,
                data: data
            });
        };
        
    }).call(Sender.prototype);
    
    return new Sender();
};

var main = window.main = null;
var sender = window.sender = null;

window.onmessage = function(e) {
    var msg = e.data;
    if (msg.event && sender) {
        sender._signal(msg.event, msg.data);
    }
    else if (msg.command) {
        if (main[msg.command])
            main[msg.command].apply(main, msg.args);
        else if (window[msg.command])
            window[msg.command].apply(window, msg.args);
        else
            throw new Error("Unknown command:" + msg.command);
    }
    else if (msg.init) {
        window.initBaseUrls(msg.tlns);
        require("ace/lib/es5-shim");
        sender = window.sender = window.initSender();
        var clazz = require(msg.module)[msg.classname];
        main = window.main = new clazz(sender);
    }
};
})(this);

ace.define("ace/lib/oop",["require","exports","module"], function(require, exports, module) {
"use strict";

exports.inherits = function(ctor, superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
            value: ctor,
            enumerable: false,
            writable: true,
            configurable: true
        }
    });
};

exports.mixin = function(obj, mixin) {
    for (var key in mixin) {
        obj[key] = mixin[key];
    }
    return obj;
};

exports.implement = function(proto, mixin) {
    exports.mixin(proto, mixin);
};

});

ace.define("ace/range",["require","exports","module"], function(require, exports, module) {
"use strict";
var comparePoints = function(p1, p2) {
    return p1.row - p2.row || p1.column - p2.column;
};
var Range = function(startRow, startColumn, endRow, endColumn) {
    this.start = {
        row: startRow,
        column: startColumn
    };

    this.end = {
        row: endRow,
        column: endColumn
    };
};

(function() {
    this.isEqual = function(range) {
        return this.start.row === range.start.row &&
            this.end.row === range.end.row &&
            this.start.column === range.start.column &&
            this.end.column === range.end.column;
    };
    this.toString = function() {
        return ("Range: [" + this.start.row + "/" + this.start.column +
            "] -> [" + this.end.row + "/" + this.end.column + "]");
    };

    this.contains = function(row, column) {
        return this.compare(row, column) == 0;
    };
    this.compareRange = function(range) {
        var cmp,
            end = range.end,
            start = range.start;

        cmp = this.compare(end.row, end.column);
        if (cmp == 1) {
            cmp = this.compare(start.row, start.column);
            if (cmp == 1) {
                return 2;
            } else if (cmp == 0) {
                return 1;
            } else {
                return 0;
            }
        } else if (cmp == -1) {
            return -2;
        } else {
            cmp = this.compare(start.row, start.column);
            if (cmp == -1) {
                return -1;
            } else if (cmp == 1) {
                return 42;
            } else {
                return 0;
            }
        }
    };
    this.comparePoint = function(p) {
        return this.compare(p.row, p.column);
    };
    this.containsRange = function(range) {
        return this.comparePoint(range.start) == 0 && this.comparePoint(range.end) == 0;
    };
    this.intersects = function(range) {
        var cmp = this.compareRange(range);
        return (cmp == -1 || cmp == 0 || cmp == 1);
    };
    this.isEnd = function(row, column) {
        return this.end.row == row && this.end.column == column;
    };
    this.isStart = function(row, column) {
        return this.start.row == row && this.start.column == column;
    };
    this.setStart = function(row, column) {
        if (typeof row == "object") {
            this.start.column = row.column;
            this.start.row = row.row;
        } else {
            this.start.row = row;
            this.start.column = column;
        }
    };
    this.setEnd = function(row, column) {
        if (typeof row == "object") {
            this.end.column = row.column;
            this.end.row = row.row;
        } else {
            this.end.row = row;
            this.end.column = column;
        }
    };
    this.inside = function(row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isEnd(row, column) || this.isStart(row, column)) {
                return false;
            } else {
                return true;
            }
        }
        return false;
    };
    this.insideStart = function(row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isEnd(row, column)) {
                return false;
            } else {
                return true;
            }
        }
        return false;
    };
    this.insideEnd = function(row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isStart(row, column)) {
                return false;
            } else {
                return true;
            }
        }
        return false;
    };
    this.compare = function(row, column) {
        if (!this.isMultiLine()) {
            if (row === this.start.row) {
                return column < this.start.column ? -1 : (column > this.end.column ? 1 : 0);
            };
        }

        if (row < this.start.row)
            return -1;

        if (row > this.end.row)
            return 1;

        if (this.start.row === row)
            return column >= this.start.column ? 0 : -1;

        if (this.end.row === row)
            return column <= this.end.column ? 0 : 1;

        return 0;
    };
    this.compareStart = function(row, column) {
        if (this.start.row == row && this.start.column == column) {
            return -1;
        } else {
            return this.compare(row, column);
        }
    };
    this.compareEnd = function(row, column) {
        if (this.end.row == row && this.end.column == column) {
            return 1;
        } else {
            return this.compare(row, column);
        }
    };
    this.compareInside = function(row, column) {
        if (this.end.row == row && this.end.column == column) {
            return 1;
        } else if (this.start.row == row && this.start.column == column) {
            return -1;
        } else {
            return this.compare(row, column);
        }
    };
    this.clipRows = function(firstRow, lastRow) {
        if (this.end.row > lastRow)
            var end = {row: lastRow + 1, column: 0};
        else if (this.end.row < firstRow)
            var end = {row: firstRow, column: 0};

        if (this.start.row > lastRow)
            var start = {row: lastRow + 1, column: 0};
        else if (this.start.row < firstRow)
            var start = {row: firstRow, column: 0};

        return Range.fromPoints(start || this.start, end || this.end);
    };
    this.extend = function(row, column) {
        var cmp = this.compare(row, column);

        if (cmp == 0)
            return this;
        else if (cmp == -1)
            var start = {row: row, column: column};
        else
            var end = {row: row, column: column};

        return Range.fromPoints(start || this.start, end || this.end);
    };

    this.isEmpty = function() {
        return (this.start.row === this.end.row && this.start.column === this.end.column);
    };
    this.isMultiLine = function() {
        return (this.start.row !== this.end.row);
    };
    this.clone = function() {
        return Range.fromPoints(this.start, this.end);
    };
    this.collapseRows = function() {
        if (this.end.column == 0)
            return new Range(this.start.row, 0, Math.max(this.start.row, this.end.row-1), 0)
        else
            return new Range(this.start.row, 0, this.end.row, 0)
    };
    this.toScreenRange = function(session) {
        var screenPosStart = session.documentToScreenPosition(this.start);
        var screenPosEnd = session.documentToScreenPosition(this.end);

        return new Range(
            screenPosStart.row, screenPosStart.column,
            screenPosEnd.row, screenPosEnd.column
        );
    };
    this.moveBy = function(row, column) {
        this.start.row += row;
        this.start.column += column;
        this.end.row += row;
        this.end.column += column;
    };

}).call(Range.prototype);
Range.fromPoints = function(start, end) {
    return new Range(start.row, start.column, end.row, end.column);
};
Range.comparePoints = comparePoints;

Range.comparePoints = function(p1, p2) {
    return p1.row - p2.row || p1.column - p2.column;
};


exports.Range = Range;
});

ace.define("ace/apply_delta",["require","exports","module"], function(require, exports, module) {
"use strict";

function throwDeltaError(delta, errorText){
    console.log("Invalid Delta:", delta);
    throw "Invalid Delta: " + errorText;
}

function positionInDocument(docLines, position) {
    return position.row    >= 0 && position.row    <  docLines.length &&
           position.column >= 0 && position.column <= docLines[position.row].length;
}

function validateDelta(docLines, delta) {
    if (delta.action != "insert" && delta.action != "remove")
        throwDeltaError(delta, "delta.action must be 'insert' or 'remove'");
    if (!(delta.lines instanceof Array))
        throwDeltaError(delta, "delta.lines must be an Array");
    if (!delta.start || !delta.end)
       throwDeltaError(delta, "delta.start/end must be an present");
    var start = delta.start;
    if (!positionInDocument(docLines, delta.start))
        throwDeltaError(delta, "delta.start must be contained in document");
    var end = delta.end;
    if (delta.action == "remove" && !positionInDocument(docLines, end))
        throwDeltaError(delta, "delta.end must contained in document for 'remove' actions");
    var numRangeRows = end.row - start.row;
    var numRangeLastLineChars = (end.column - (numRangeRows == 0 ? start.column : 0));
    if (numRangeRows != delta.lines.length - 1 || delta.lines[numRangeRows].length != numRangeLastLineChars)
        throwDeltaError(delta, "delta.range must match delta lines");
}

exports.applyDelta = function(docLines, delta, doNotValidate) {
    
    var row = delta.start.row;
    var startColumn = delta.start.column;
    var line = docLines[row] || "";
    switch (delta.action) {
        case "insert":
            var lines = delta.lines;
            if (lines.length === 1) {
                docLines[row] = line.substring(0, startColumn) + delta.lines[0] + line.substring(startColumn);
            } else {
                var args = [row, 1].concat(delta.lines);
                docLines.splice.apply(docLines, args);
                docLines[row] = line.substring(0, startColumn) + docLines[row];
                docLines[row + delta.lines.length - 1] += line.substring(startColumn);
            }
            break;
        case "remove":
            var endColumn = delta.end.column;
            var endRow = delta.end.row;
            if (row === endRow) {
                docLines[row] = line.substring(0, startColumn) + line.substring(endColumn);
            } else {
                docLines.splice(
                    row, endRow - row + 1,
                    line.substring(0, startColumn) + docLines[endRow].substring(endColumn)
                );
            }
            break;
    }
}
});

ace.define("ace/lib/event_emitter",["require","exports","module"], function(require, exports, module) {
"use strict";

var EventEmitter = {};
var stopPropagation = function() { this.propagationStopped = true; };
var preventDefault = function() { this.defaultPrevented = true; };

EventEmitter._emit =
EventEmitter._dispatchEvent = function(eventName, e) {
    this._eventRegistry || (this._eventRegistry = {});
    this._defaultHandlers || (this._defaultHandlers = {});

    var listeners = this._eventRegistry[eventName] || [];
    var defaultHandler = this._defaultHandlers[eventName];
    if (!listeners.length && !defaultHandler)
        return;

    if (typeof e != "object" || !e)
        e = {};

    if (!e.type)
        e.type = eventName;
    if (!e.stopPropagation)
        e.stopPropagation = stopPropagation;
    if (!e.preventDefault)
        e.preventDefault = preventDefault;

    listeners = listeners.slice();
    for (var i=0; i<listeners.length; i++) {
        listeners[i](e, this);
        if (e.propagationStopped)
            break;
    }
    
    if (defaultHandler && !e.defaultPrevented)
        return defaultHandler(e, this);
};


EventEmitter._signal = function(eventName, e) {
    var listeners = (this._eventRegistry || {})[eventName];
    if (!listeners)
        return;
    listeners = listeners.slice();
    for (var i=0; i<listeners.length; i++)
        listeners[i](e, this);
};

EventEmitter.once = function(eventName, callback) {
    var _self = this;
    callback && this.addEventListener(eventName, function newCallback() {
        _self.removeEventListener(eventName, newCallback);
        callback.apply(null, arguments);
    });
};


EventEmitter.setDefaultHandler = function(eventName, callback) {
    var handlers = this._defaultHandlers
    if (!handlers)
        handlers = this._defaultHandlers = {_disabled_: {}};
    
    if (handlers[eventName]) {
        var old = handlers[eventName];
        var disabled = handlers._disabled_[eventName];
        if (!disabled)
            handlers._disabled_[eventName] = disabled = [];
        disabled.push(old);
        var i = disabled.indexOf(callback);
        if (i != -1) 
            disabled.splice(i, 1);
    }
    handlers[eventName] = callback;
};
EventEmitter.removeDefaultHandler = function(eventName, callback) {
    var handlers = this._defaultHandlers
    if (!handlers)
        return;
    var disabled = handlers._disabled_[eventName];
    
    if (handlers[eventName] == callback) {
        var old = handlers[eventName];
        if (disabled)
            this.setDefaultHandler(eventName, disabled.pop());
    } else if (disabled) {
        var i = disabled.indexOf(callback);
        if (i != -1)
            disabled.splice(i, 1);
    }
};

EventEmitter.on =
EventEmitter.addEventListener = function(eventName, callback, capturing) {
    this._eventRegistry = this._eventRegistry || {};

    var listeners = this._eventRegistry[eventName];
    if (!listeners)
        listeners = this._eventRegistry[eventName] = [];

    if (listeners.indexOf(callback) == -1)
        listeners[capturing ? "unshift" : "push"](callback);
    return callback;
};

EventEmitter.off =
EventEmitter.removeListener =
EventEmitter.removeEventListener = function(eventName, callback) {
    this._eventRegistry = this._eventRegistry || {};

    var listeners = this._eventRegistry[eventName];
    if (!listeners)
        return;

    var index = listeners.indexOf(callback);
    if (index !== -1)
        listeners.splice(index, 1);
};

EventEmitter.removeAllListeners = function(eventName) {
    if (this._eventRegistry) this._eventRegistry[eventName] = [];
};

exports.EventEmitter = EventEmitter;

});

ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"], function(require, exports, module) {
"use strict";

var oop = require("./lib/oop");
var EventEmitter = require("./lib/event_emitter").EventEmitter;

var Anchor = exports.Anchor = function(doc, row, column) {
    this.$onChange = this.onChange.bind(this);
    this.attach(doc);
    
    if (typeof column == "undefined")
        this.setPosition(row.row, row.column);
    else
        this.setPosition(row, column);
};

(function() {

    oop.implement(this, EventEmitter);
    this.getPosition = function() {
        return this.$clipPositionToDocument(this.row, this.column);
    };
    this.getDocument = function() {
        return this.document;
    };
    this.$insertRight = false;
    this.onChange = function(delta) {
        if (delta.start.row == delta.end.row && delta.start.row != this.row)
            return;

        if (delta.start.row > this.row)
            return;
            
        var point = $getTransformedPoint(delta, {row: this.row, column: this.column}, this.$insertRight);
        this.setPosition(point.row, point.column, true);
    };
    
    function $pointsInOrder(point1, point2, equalPointsInOrder) {
        var bColIsAfter = equalPointsInOrder ? point1.column <= point2.column : point1.column < point2.column;
        return (point1.row < point2.row) || (point1.row == point2.row && bColIsAfter);
    }
            
    function $getTransformedPoint(delta, point, moveIfEqual) {
        var deltaIsInsert = delta.action == "insert";
        var deltaRowShift = (deltaIsInsert ? 1 : -1) * (delta.end.row    - delta.start.row);
        var deltaColShift = (deltaIsInsert ? 1 : -1) * (delta.end.column - delta.start.column);
        var deltaStart = delta.start;
        var deltaEnd = deltaIsInsert ? deltaStart : delta.end; // Collapse insert range.
        if ($pointsInOrder(point, deltaStart, moveIfEqual)) {
            return {
                row: point.row,
                column: point.column
            };
        }
        if ($pointsInOrder(deltaEnd, point, !moveIfEqual)) {
            return {
                row: point.row + deltaRowShift,
                column: point.column + (point.row == deltaEnd.row ? deltaColShift : 0)
            };
        }
        
        return {
            row: deltaStart.row,
            column: deltaStart.column
        };
    }
    this.setPosition = function(row, column, noClip) {
        var pos;
        if (noClip) {
            pos = {
                row: row,
                column: column
            };
        } else {
            pos = this.$clipPositionToDocument(row, column);
        }

        if (this.row == pos.row && this.column == pos.column)
            return;

        var old = {
            row: this.row,
            column: this.column
        };

        this.row = pos.row;
        this.column = pos.column;
        this._signal("change", {
            old: old,
            value: pos
        });
    };
    this.detach = function() {
        this.document.removeEventListener("change", this.$onChange);
    };
    this.attach = function(doc) {
        this.document = doc || this.document;
        this.document.on("change", this.$onChange);
    };
    this.$clipPositionToDocument = function(row, column) {
        var pos = {};

        if (row >= this.document.getLength()) {
            pos.row = Math.max(0, this.document.getLength() - 1);
            pos.column = this.document.getLine(pos.row).length;
        }
        else if (row < 0) {
            pos.row = 0;
            pos.column = 0;
        }
        else {
            pos.row = row;
            pos.column = Math.min(this.document.getLine(pos.row).length, Math.max(0, column));
        }

        if (column < 0)
            pos.column = 0;

        return pos;
    };

}).call(Anchor.prototype);

});

ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"], function(require, exports, module) {
"use strict";

var oop = require("./lib/oop");
var applyDelta = require("./apply_delta").applyDelta;
var EventEmitter = require("./lib/event_emitter").EventEmitter;
var Range = require("./range").Range;
var Anchor = require("./anchor").Anchor;

var Document = function(textOrLines) {
    this.$lines = [""];
    if (textOrLines.length === 0) {
        this.$lines = [""];
    } else if (Array.isArray(textOrLines)) {
        this.insertMergedLines({row: 0, column: 0}, textOrLines);
    } else {
        this.insert({row: 0, column:0}, textOrLines);
    }
};

(function() {

    oop.implement(this, EventEmitter);
    this.setValue = function(text) {
        var len = this.getLength() - 1;
        this.remove(new Range(0, 0, len, this.getLine(len).length));
        this.insert({row: 0, column: 0}, text);
    };
    this.getValue = function() {
        return this.getAllLines().join(this.getNewLineCharacter());
    };
    this.createAnchor = function(row, column) {
        return new Anchor(this, row, column);
    };
    if ("aaa".split(/a/).length === 0) {
        this.$split = function(text) {
            return text.replace(/\r\n|\r/g, "\n").split("\n");
        };
    } else {
        this.$split = function(text) {
            return text.split(/\r\n|\r|\n/);
        };
    }


    this.$detectNewLine = function(text) {
        var match = text.match(/^.*?(\r\n|\r|\n)/m);
        this.$autoNewLine = match ? match[1] : "\n";
        this._signal("changeNewLineMode");
    };
    this.getNewLineCharacter = function() {
        switch (this.$newLineMode) {
          case "windows":
            return "\r\n";
          case "unix":
            return "\n";
          default:
            return this.$autoNewLine || "\n";
        }
    };

    this.$autoNewLine = "";
    this.$newLineMode = "auto";
    this.setNewLineMode = function(newLineMode) {
        if (this.$newLineMode === newLineMode)
            return;

        this.$newLineMode = newLineMode;
        this._signal("changeNewLineMode");
    };
    this.getNewLineMode = function() {
        return this.$newLineMode;
    };
    this.isNewLine = function(text) {
        return (text == "\r\n" || text == "\r" || text == "\n");
    };
    this.getLine = function(row) {
        return this.$lines[row] || "";
    };
    this.getLines = function(firstRow, lastRow) {
        return this.$lines.slice(firstRow, lastRow + 1);
    };
    this.getAllLines = function() {
        return this.getLines(0, this.getLength());
    };
    this.getLength = function() {
        return this.$lines.length;
    };
    this.getTextRange = function(range) {
        return this.getLinesForRange(range).join(this.getNewLineCharacter());
    };
    this.getLinesForRange = function(range) {
        var lines;
        if (range.start.row === range.end.row) {
            lines = [this.getLine(range.start.row).substring(range.start.column, range.end.column)];
        } else {
            lines = this.getLines(range.start.row, range.end.row);
            lines[0] = (lines[0] || "").substring(range.start.column);
            var l = lines.length - 1;
            if (range.end.row - range.start.row == l)
                lines[l] = lines[l].substring(0, range.end.column);
        }
        return lines;
    };
    this.insertLines = function(row, lines) {
        console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead.");
        return this.insertFullLines(row, lines);
    };
    this.removeLines = function(firstRow, lastRow) {
        console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead.");
        return this.removeFullLines(firstRow, lastRow);
    };
    this.insertNewLine = function(position) {
        console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, [\'\', \'\']) instead.");
        return this.insertMergedLines(position, ["", ""]);
    };
    this.insert = function(position, text) {
        if (this.getLength() <= 1)
            this.$detectNewLine(text);
        
        return this.insertMergedLines(position, this.$split(text));
    };
    this.insertInLine = function(position, text) {
        var start = this.clippedPos(position.row, position.column);
        var end = this.pos(position.row, position.column + text.length);
        
        this.applyDelta({
            start: start,
            end: end,
            action: "insert",
            lines: [text]
        }, true);
        
        return this.clonePos(end);
    };
    
    this.clippedPos = function(row, column) {
        var length = this.getLength();
        if (row === undefined) {
            row = length;
        } else if (row < 0) {
            row = 0;
        } else if (row >= length) {
            row = length - 1;
            column = undefined;
        }
        var line = this.getLine(row);
        if (column == undefined)
            column = line.length;
        column = Math.min(Math.max(column, 0), line.length);
        return {row: row, column: column};
    };
    
    this.clonePos = function(pos) {
        return {row: pos.row, column: pos.column};
    };
    
    this.pos = function(row, column) {
        return {row: row, column: column};
    };
    
    this.$clipPosition = function(position) {
        var length = this.getLength();
        if (position.row >= length) {
            position.row = Math.max(0, length - 1);
            position.column = this.getLine(length - 1).length;
        } else {
            position.row = Math.max(0, position.row);
            position.column = Math.min(Math.max(position.column, 0), this.getLine(position.row).length);
        }
        return position;
    };
    this.insertFullLines = function(row, lines) {
        row = Math.min(Math.max(row, 0), this.getLength());
        var column = 0;
        if (row < this.getLength()) {
            lines = lines.concat([""]);
            column = 0;
        } else {
            lines = [""].concat(lines);
            row--;
            column = this.$lines[row].length;
        }
        this.insertMergedLines({row: row, column: column}, lines);
    };    
    this.insertMergedLines = function(position, lines) {
        var start = this.clippedPos(position.row, position.column);
        var end = {
            row: start.row + lines.length - 1,
            column: (lines.length == 1 ? start.column : 0) + lines[lines.length - 1].length
        };
        
        this.applyDelta({
            start: start,
            end: end,
            action: "insert",
            lines: lines
        });
        
        return this.clonePos(end);
    };
    this.remove = function(range) {
        var start = this.clippedPos(range.start.row, range.start.column);
        var end = this.clippedPos(range.end.row, range.end.column);
        this.applyDelta({
            start: start,
            end: end,
            action: "remove",
            lines: this.getLinesForRange({start: start, end: end})
        });
        return this.clonePos(start);
    };
    this.removeInLine = function(row, startColumn, endColumn) {
        var start = this.clippedPos(row, startColumn);
        var end = this.clippedPos(row, endColumn);
        
        this.applyDelta({
            start: start,
            end: end,
            action: "remove",
            lines: this.getLinesForRange({start: start, end: end})
        }, true);
        
        return this.clonePos(start);
    };
    this.removeFullLines = function(firstRow, lastRow) {
        firstRow = Math.min(Math.max(0, firstRow), this.getLength() - 1);
        lastRow  = Math.min(Math.max(0, lastRow ), this.getLength() - 1);
        var deleteFirstNewLine = lastRow == this.getLength() - 1 && firstRow > 0;
        var deleteLastNewLine  = lastRow  < this.getLength() - 1;
        var startRow = ( deleteFirstNewLine ? firstRow - 1                  : firstRow                    );
        var startCol = ( deleteFirstNewLine ? this.getLine(startRow).length : 0                           );
        var endRow   = ( deleteLastNewLine  ? lastRow + 1                   : lastRow                     );
        var endCol   = ( deleteLastNewLine  ? 0                             : this.getLine(endRow).length ); 
        var range = new Range(startRow, startCol, endRow, endCol);
        var deletedLines = this.$lines.slice(firstRow, lastRow + 1);
        
        this.applyDelta({
            start: range.start,
            end: range.end,
            action: "remove",
            lines: this.getLinesForRange(range)
        });
        return deletedLines;
    };
    this.removeNewLine = function(row) {
        if (row < this.getLength() - 1 && row >= 0) {
            this.applyDelta({
                start: this.pos(row, this.getLine(row).length),
                end: this.pos(row + 1, 0),
                action: "remove",
                lines: ["", ""]
            });
        }
    };
    this.replace = function(range, text) {
        if (!(range instanceof Range))
            range = Range.fromPoints(range.start, range.end);
        if (text.length === 0 && range.isEmpty())
            return range.start;
        if (text == this.getTextRange(range))
            return range.end;

        this.remove(range);
        var end;
        if (text) {
            end = this.insert(range.start, text);
        }
        else {
            end = range.start;
        }
        
        return end;
    };
    this.applyDeltas = function(deltas) {
        for (var i=0; i<deltas.length; i++) {
            this.applyDelta(deltas[i]);
        }
    };
    this.revertDeltas = function(deltas) {
        for (var i=deltas.length-1; i>=0; i--) {
            this.revertDelta(deltas[i]);
        }
    };
    this.applyDelta = function(delta, doNotValidate) {
        var isInsert = delta.action == "insert";
        if (isInsert ? delta.lines.length <= 1 && !delta.lines[0]
            : !Range.comparePoints(delta.start, delta.end)) {
            return;
        }
        
        if (isInsert && delta.lines.length > 20000)
            this.$splitAndapplyLargeDelta(delta, 20000);
        applyDelta(this.$lines, delta, doNotValidate);
        this._signal("change", delta);
    };
    
    this.$splitAndapplyLargeDelta = function(delta, MAX) {
        var lines = delta.lines;
        var l = lines.length;
        var row = delta.start.row; 
        var column = delta.start.column;
        var from = 0, to = 0;
        do {
            from = to;
            to += MAX - 1;
            var chunk = lines.slice(from, to);
            if (to > l) {
                delta.lines = chunk;
                delta.start.row = row + from;
                delta.start.column = column;
                break;
            }
            chunk.push("");
            this.applyDelta({
                start: this.pos(row + from, column),
                end: this.pos(row + to, column = 0),
                action: delta.action,
                lines: chunk
            }, true);
        } while(true);
    };
    this.revertDelta = function(delta) {
        this.applyDelta({
            start: this.clonePos(delta.start),
            end: this.clonePos(delta.end),
            action: (delta.action == "insert" ? "remove" : "insert"),
            lines: delta.lines.slice()
        });
    };
    this.indexToPosition = function(index, startRow) {
        var lines = this.$lines || this.getAllLines();
        var newlineLength = this.getNewLineCharacter().length;
        for (var i = startRow || 0, l = lines.length; i < l; i++) {
            index -= lines[i].length + newlineLength;
            if (index < 0)
                return {row: i, column: index + lines[i].length + newlineLength};
        }
        return {row: l-1, column: lines[l-1].length};
    };
    this.positionToIndex = function(pos, startRow) {
        var lines = this.$lines || this.getAllLines();
        var newlineLength = this.getNewLineCharacter().length;
        var index = 0;
        var row = Math.min(pos.row, lines.length);
        for (var i = startRow || 0; i < row; ++i)
            index += lines[i].length + newlineLength;

        return index + pos.column;
    };

}).call(Document.prototype);

exports.Document = Document;
});

ace.define("ace/lib/lang",["require","exports","module"], function(require, exports, module) {
"use strict";

exports.last = function(a) {
    return a[a.length - 1];
};

exports.stringReverse = function(string) {
    return string.split("").reverse().join("");
};

exports.stringRepeat = function (string, count) {
    var result = '';
    while (count > 0) {
        if (count & 1)
            result += string;

        if (count >>= 1)
            string += string;
    }
    return result;
};

var trimBeginRegexp = /^\s\s*/;
var trimEndRegexp = /\s\s*$/;

exports.stringTrimLeft = function (string) {
    return string.replace(trimBeginRegexp, '');
};

exports.stringTrimRight = function (string) {
    return string.replace(trimEndRegexp, '');
};

exports.copyObject = function(obj) {
    var copy = {};
    for (var key in obj) {
        copy[key] = obj[key];
    }
    return copy;
};

exports.copyArray = function(array){
    var copy = [];
    for (var i=0, l=array.length; i<l; i++) {
        if (array[i] && typeof array[i] == "object")
            copy[i] = this.copyObject( array[i] );
        else 
            copy[i] = array[i];
    }
    return copy;
};

exports.deepCopy = function deepCopy(obj) {
    if (typeof obj !== "object" || !obj)
        return obj;
    var copy;
    if (Array.isArray(obj)) {
        copy = [];
        for (var key = 0; key < obj.length; key++) {
            copy[key] = deepCopy(obj[key]);
        }
        return copy;
    }
    var cons = obj.constructor;
    if (cons === RegExp)
        return obj;
    
    copy = cons();
    for (var key in obj) {
        copy[key] = deepCopy(obj[key]);
    }
    return copy;
};

exports.arrayToMap = function(arr) {
    var map = {};
    for (var i=0; i<arr.length; i++) {
        map[arr[i]] = 1;
    }
    return map;

};

exports.createMap = function(props) {
    var map = Object.create(null);
    for (var i in props) {
        map[i] = props[i];
    }
    return map;
};
exports.arrayRemove = function(array, value) {
  for (var i = 0; i <= array.length; i++) {
    if (value === array[i]) {
      array.splice(i, 1);
    }
  }
};

exports.escapeRegExp = function(str) {
    return str.replace(/([.*+?^${}()|[\]\/\\])/g, '\\$1');
};

exports.escapeHTML = function(str) {
    return str.replace(/&/g, "&#38;").replace(/"/g, "&#34;").replace(/'/g, "&#39;").replace(/</g, "&#60;");
};

exports.getMatchOffsets = function(string, regExp) {
    var matches = [];

    string.replace(regExp, function(str) {
        matches.push({
            offset: arguments[arguments.length-2],
            length: str.length
        });
    });

    return matches;
};
exports.deferredCall = function(fcn) {
    var timer = null;
    var callback = function() {
        timer = null;
        fcn();
    };

    var deferred = function(timeout) {
        deferred.cancel();
        timer = setTimeout(callback, timeout || 0);
        return deferred;
    };

    deferred.schedule = deferred;

    deferred.call = function() {
        this.cancel();
        fcn();
        return deferred;
    };

    deferred.cancel = function() {
        clearTimeout(timer);
        timer = null;
        return deferred;
    };
    
    deferred.isPending = function() {
        return timer;
    };

    return deferred;
};


exports.delayedCall = function(fcn, defaultTimeout) {
    var timer = null;
    var callback = function() {
        timer = null;
        fcn();
    };

    var _self = function(timeout) {
        if (timer == null)
            timer = setTimeout(callback, timeout || defaultTimeout);
    };

    _self.delay = function(timeout) {
        timer && clearTimeout(timer);
        timer = setTimeout(callback, timeout || defaultTimeout);
    };
    _self.schedule = _self;

    _self.call = function() {
        this.cancel();
        fcn();
    };

    _self.cancel = function() {
        timer && clearTimeout(timer);
        timer = null;
    };

    _self.isPending = function() {
        return timer;
    };

    return _self;
};
});

ace.define("ace/worker/mirror",["require","exports","module","ace/range","ace/document","ace/lib/lang"], function(require, exports, module) {
"use strict";

var Range = require("../range").Range;
var Document = require("../document").Document;
var lang = require("../lib/lang");
    
var Mirror = exports.Mirror = function(sender) {
    this.sender = sender;
    var doc = this.doc = new Document("");
    
    var deferredUpdate = this.deferredUpdate = lang.delayedCall(this.onUpdate.bind(this));
    
    var _self = this;
    sender.on("change", function(e) {
        var data = e.data;
        if (data[0].start) {
            doc.applyDeltas(data);
        } else {
            for (var i = 0; i < data.length; i += 2) {
                if (Array.isArray(data[i+1])) {
                    var d = {action: "insert", start: data[i], lines: data[i+1]};
                } else {
                    var d = {action: "remove", start: data[i], end: data[i+1]};
                }
                doc.applyDelta(d, true);
            }
        }
        if (_self.$timeout)
            return deferredUpdate.schedule(_self.$timeout);
        _self.onUpdate();
    });
};

(function() {
    
    this.$timeout = 500;
    
    this.setTimeout = function(timeout) {
        this.$timeout = timeout;
    };
    
    this.setValue = function(value) {
        this.doc.setValue(value);
        this.deferredUpdate.schedule(this.$timeout);
    };
    
    this.getValue = function(callbackId) {
        this.sender.callback(this.doc.getValue(), callbackId);
    };
    
    this.onUpdate = function() {
    };
    
    this.isPending = function() {
        return this.deferredUpdate.isPending();
    };
    
}).call(Mirror.prototype);

});

ace.define("ace/mode/xquery/xqlint",["require","exports","module","ace/mode/tree_ops","ace/mode/xquery/errors","ace/mode/tree_ops","ace/mode/xquery/errors","ace/mode/xquery/schema_built-in_types","ace/mode/xquery/errors","ace/mode/tree_ops","ace/mode/xquery/static_context","ace/mode/xquery/handlers","ace/mode/tree_ops","ace/mode/xquery/parsers/JSONiqParser","ace/mode/xquery/parsers/XQueryParser","ace/mode/xquery/parsers/JSONParseTreeHandler","ace/mode/xquery/compiler/translator","ace/mode/xquery/formatter/style_checker","ace/mode/lib/completion/completer","ace/mode/xquery/compiler/static_context"], function(require, exports, module) {
module.exports = (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({
1:[function(require,module,exports){
'use strict';

var init = function(that, code, message, pos, type){
    if(!code) {
        throw new Error(type + ' code is missing.');
    }
    
    if(!message) {
        throw new Error(type + ' message is missing.');
    }
    
    if(!pos) {
        throw new Error(type + ' position is missing.');
    }

    that.getCode = function(){
        return code;
    };
    
    that.getMessage = function(){
        return message;
    };

    that.getPos = function(){
        return pos;
    };
};

var StaticError = {};
var StaticWarning = {};
StaticError.prototype = new Error();
StaticWarning.prototype = new Error();

exports.StaticError = StaticError.prototype.constructor = function(code, message, pos) {
    init(this, code, message, pos, 'Error');
};

exports.StaticWarning = StaticWarning.prototype.constructor = function(code, message, pos) {
    init(this, code, message, pos, 'Warning');
};
},
{}],
2:[function(require,module,exports){
'use strict';

var TreeOps = require('../tree_ops').TreeOps;
var Errors = require('./errors');
var StaticWarning = Errors.StaticWarning;
exports.ModuleDecl = function(translator, rootSctx, node){
    var prefix = '';
    return {
        NCName: function(ncname){
            prefix = TreeOps.flatten(ncname);
        },

        URILiteral: function(uri) {
            uri = TreeOps.flatten(uri);
            uri = uri.substring(1, uri.length - 1);
            translator.apply(function(){
                rootSctx.moduleNamespace = uri;
                rootSctx.addNamespace(uri, prefix, node.pos, 'moduleDecl');
            });
        }
    };
};

exports.ModuleImport = function(translator, rootSctx, node) {
    var prefix = '';
    var moduleURI;

    return {
        NCName: function(ncname){
            prefix = TreeOps.flatten(ncname);
        },

        URILiteral: function(uri) {
            if(moduleURI !== undefined) {
                return;
            }
            uri = TreeOps.flatten(uri);
            uri = uri.substring(1, uri.length - 1);
            moduleURI = uri;
            translator.apply(function(){
                rootSctx.importModule(uri, prefix, node.pos);
            });
        }
    };
};

exports.SchemaImport = function(translator, rootSctx, node) {
    var prefix = '';
    var schemaURI;
    
    return {
        SchemaPrefix: function(schemaPrefix) {
            var SchemaPrefixHandler = function () {
                this.NCName = function (ncname) {
                    prefix = TreeOps.flatten(ncname);
                };
            };
            translator.visitChildren(schemaPrefix, new SchemaPrefixHandler());
        },

        URILiteral: function(uri) {
            if(schemaURI !== undefined) {
                return;
            }
            uri = TreeOps.flatten(uri);
            uri = uri.substring(1, uri.length - 1);
            schemaURI = uri;
            translator.apply(function(){
                rootSctx.addNamespace(uri, prefix, node.pos, 'schema');
            });
        }
    };
};

exports.DefaultNamespaceDecl = function(translator, rootSctx, node) {
    var fn = false;
    var ns = '';

    return {
        TOKEN: function(token){
            fn = fn ? true : (token.value === 'function');
        },
        URILiteral: function(uri){
            ns = TreeOps.flatten(uri);
            ns = ns.substring(1, ns.length - 1);
            if(!fn) {
                translator.apply(function(){
                    throw new StaticWarning('W06', 'Avoid default element namespace declarations.', node.pos);
                });
                rootSctx.defaultElementNamespace = ns;
            } else {
                rootSctx.defaultFunctionNamespace = ns;
            }
        }
    };
};

exports.NamespaceDecl = function(translator, rootSctx, node) {
    var prefix = '';
    return {
        NCName: function(ncname) {
            prefix = TreeOps.flatten(ncname);
        },
        URILiteral: function(uri) {
            uri = TreeOps.flatten(uri);
            uri = uri.substring(1, uri.length - 1);
            translator.apply(function(){
                rootSctx.addNamespace(uri, prefix, node.pos, 'declare');
            });
        }
    };
};
exports.VarHandler = function(translator, sctx, node){
    var EQNameHandler = function(eqname){
        var value = TreeOps.flatten(eqname);
        translator.apply(function(){
            var qname = sctx.resolveQName(value, eqname.pos);
            sctx.addVariable(qname, node.name, eqname.pos);
        });
    };
    return {
        ExprSingle: function(){ return true; },
        VarValue: function(){ return true; },
        VarDefaultValue: function(){ return true; },
        VarName: EQNameHandler,
        EQName: EQNameHandler
    };
};

exports.VarRefHandler = function(translator, sctx, node){
    return {
        VarName: function(eqname){
            var value = TreeOps.flatten(eqname);
            translator.apply(function(){
                var qname = sctx.resolveQName(value, node.pos);
                if(qname.uri !== '') {
                    sctx.root.namespaces[qname.uri].used = true;
                }
                sctx.addVarRef(qname, eqname.pos);
            });
        }
    };
};
},
{"../tree_ops":11,"./errors":1}],
3:[function(require,module,exports){
'use strict';
exports.getSchemaBuiltinTypes = function(){
    var ns = 'http://www.w3.org/2001/XMLSchema';
    var SchemaBuiltinTypes = {};
    SchemaBuiltinTypes[ns] = {
        variables: {},
        functions: {}
    };
    SchemaBuiltinTypes[ns].functions[ns + '#string#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'string', arity: 1, eqname: { uri: ns, name: 'string' } };
    SchemaBuiltinTypes[ns].functions[ns + '#boolean#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'boolean', arity: 1, eqname: { uri: ns, name: 'boolean' } };
    SchemaBuiltinTypes[ns].functions[ns + '#decimal#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'decimal', arity: 1, eqname: { uri: ns, name: 'decimal' } };
    SchemaBuiltinTypes[ns].functions[ns + '#float#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'float', arity: 1, eqname: { uri: ns, name: 'float' } };
    SchemaBuiltinTypes[ns].functions[ns + '#double#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'double', arity: 1, eqname: { uri: ns, name: 'double' } };
    SchemaBuiltinTypes[ns].functions[ns + '#duration#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'duration', arity: 1, eqname: { uri: ns, name: 'duration' } };
    SchemaBuiltinTypes[ns].functions[ns + '#dateTime#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'dateTime', arity: 1, eqname: { uri: ns, name: 'dateTime' } };
    SchemaBuiltinTypes[ns].functions[ns + '#time#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'time', arity: 1, eqname: { uri: ns, name: 'time' } };
    SchemaBuiltinTypes[ns].functions[ns + '#date#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'date', arity: 1, eqname: { uri: ns, name: 'date' } };
    SchemaBuiltinTypes[ns].functions[ns + '#gYearMonth#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'gYearMonth', arity: 1, eqname: { uri: ns, name: 'gYearMonth' } };
    SchemaBuiltinTypes[ns].functions[ns + '#gYear#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'gYear', arity: 1, eqname: { uri: ns, name: 'gYear' } };
    SchemaBuiltinTypes[ns].functions[ns + '#gMonthDay#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'gMonthDay', arity: 1, eqname: { uri: ns, name: 'gMonthDay' } };
    SchemaBuiltinTypes[ns].functions[ns + '#gDay#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'gDay', arity: 1, eqname: { uri: ns, name: 'gDay' } };
    SchemaBuiltinTypes[ns].functions[ns + '#gMonth#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'gMonth', arity: 1, eqname: { uri: ns, name: 'gMonth' } };
    SchemaBuiltinTypes[ns].functions[ns + '#hexBinary#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'hexBinary', arity: 1, eqname: { uri: ns, name: 'hexBinary' } };
    SchemaBuiltinTypes[ns].functions[ns + '#base64Binary#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'base64Binary', arity: 1, eqname: { uri: ns, name: 'base64Binary' } };
    SchemaBuiltinTypes[ns].functions[ns + '#anyURI#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'anyURI', arity: 1, eqname: { uri: ns, name: 'anyURI' } };
    SchemaBuiltinTypes[ns].functions[ns + '#QName#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'QName', arity: 1, eqname: { uri: ns, name: 'QName' } };
    SchemaBuiltinTypes[ns].functions[ns + '#normalizedString#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'normalizedString', arity: 1, eqname: { uri: ns, name: 'normalizedString' } };
    SchemaBuiltinTypes[ns].functions[ns + '#token#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'token', arity: 1, eqname: { uri: ns, name: 'token' } };
    SchemaBuiltinTypes[ns].functions[ns + '#language#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'language', arity: 1, eqname: { uri: ns, name: 'language' } };
    SchemaBuiltinTypes[ns].functions[ns + '#NMTOKEN#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'NMTOKEN', arity: 1, eqname: { uri: ns, name: 'NMTOKEN' } };
    SchemaBuiltinTypes[ns].functions[ns + '#Name#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'Name', arity: 1, eqname: { uri: ns, name: 'Name' } };
    SchemaBuiltinTypes[ns].functions[ns + '#NCName#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'NCName', arity: 1, eqname: { uri: ns, name: 'NCName' } };
    SchemaBuiltinTypes[ns].functions[ns + '#ID#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'ID', arity: 1, eqname: { uri: ns, name: 'ID' } };
    SchemaBuiltinTypes[ns].functions[ns + '#IDREF#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'IDREF', arity: 1, eqname: { uri: ns, name: 'IDREF' } };
    SchemaBuiltinTypes[ns].functions[ns + '#ENTITY#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'ENTITY', arity: 1, eqname: { uri: ns, name: 'ENTITY' } };
    SchemaBuiltinTypes[ns].functions[ns + '#integer#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'integer', arity: 1, eqname: { uri: ns, name: 'integer' } };
    SchemaBuiltinTypes[ns].functions[ns + '#nonPositiveInteger#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'nonPositiveInteger', arity: 1, eqname: { uri: ns, name: 'nonPositiveInteger' } };
    SchemaBuiltinTypes[ns].functions[ns + '#negativeInteger#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'negativeInteger', arity: 1, eqname: { uri: ns, name: 'negativeInteger' } };
    SchemaBuiltinTypes[ns].functions[ns + '#long#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'long', arity: 1, eqname: { uri: ns, name: 'long' } };
    SchemaBuiltinTypes[ns].functions[ns + '#int#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'int', arity: 1, eqname: { uri: ns, name: 'int' } };
    SchemaBuiltinTypes[ns].functions[ns + '#short#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'short', arity: 1, eqname: { uri: ns, name: 'short' } };
    SchemaBuiltinTypes[ns].functions[ns + '#byte#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'byte', arity: 1, eqname: { uri: ns, name: 'byte' } };
    SchemaBuiltinTypes[ns].functions[ns + '#nonNegativeInteger#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'nonNegativeInteger', arity: 1, eqname: { uri: ns, name: 'nonNegativeInteger' } };
    SchemaBuiltinTypes[ns].functions[ns + '#unsignedLong#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'unsignedLong', arity: 1, eqname: { uri: ns, name: 'unsignedLong' } };
    SchemaBuiltinTypes[ns].functions[ns + '#unsignedInt#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'unsignedInt', arity: 1, eqname: { uri: ns, name: 'unsignedInt' } };
    SchemaBuiltinTypes[ns].functions[ns + '#unsignedShort#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'unsignedShort', arity: 1, eqname: { uri: ns, name: 'unsignedShort' } };
    SchemaBuiltinTypes[ns].functions[ns + '#unsignedByte#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'unsignedByte', arity: 1, eqname: { uri: ns, name: 'unsignedByte' } };
    SchemaBuiltinTypes[ns].functions[ns + '#positiveInteger#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'positiveInteger', arity: 1, eqname: { uri: ns, name: 'positiveInteger' } };
    SchemaBuiltinTypes[ns].functions[ns + '#yearMonthDuration#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'yearMonthDuration', arity: 1, eqname: { uri: ns, name: 'yearMonthDuration' } };
    SchemaBuiltinTypes[ns].functions[ns + '#dayTimeDuration#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'dayTimeDuration', arity: 1, eqname: { uri: ns, name: 'dayTimeDuration' } };
    SchemaBuiltinTypes[ns].functions[ns + '#untypedAtomic#1'] = { params: ['$arg as xs:anyAtomicType?'], annotations: [], name: 'untypedAtomic', arity: 1, eqname: { uri: ns, name: 'untypedAtomic' } };
    return SchemaBuiltinTypes;
};
},
{}],
4:[function(require,module,exports){
exports.StaticContext = function (parent, pos) {
    'use strict';
    
    var TreeOps = require('../tree_ops').TreeOps;
    
    var Errors = require('./errors');
    var StaticError = Errors.StaticError;
    var StaticWarning = Errors.StaticWarning;
    
    var getSchemaBuiltinTypes = require('./schema_built-in_types').getSchemaBuiltinTypes;
    
    var emptyPos = { sl:0, sc: 0, el: 0, ec: 0 };
    var namespaces = {};
    
    var getVarKey = function(qname) {
        return qname.uri + '#' + qname.name;
    };

    var getFnKey = function(qname, arity) {
        return getVarKey(qname) + '#' + arity;
    };

    if(!parent) {
        namespaces['http://jsoniq.org/functions'] = {
            prefix: 'jn',
            pos: emptyPos,
            type: 'module',
            override: true
        };
        namespaces['http://www.28msec.com/modules/collections'] = {
            prefix: 'db',
            pos: emptyPos,
            type: 'module',
            override: true
        };
        namespaces['http://www.28msec.com/modules/store'] = {
            prefix: 'store',
            pos: emptyPos,
            type: 'module',
            override: true
        };
        namespaces['http://jsoniq.org/function-library'] = {
            prefix: 'libjn',
            pos: emptyPos,
            type: 'module',
            override: true
        };
        namespaces['http://www.w3.org/2005/xpath-functions'] = {
            prefix: 'fn',
            pos: emptyPos,
            type: 'module',
            override: true
        };
        namespaces['http://www.w3.org/2005/xquery-local-functions'] = {
            prefix: 'local',
            pos: emptyPos,
            type: 'declare',
            override: true
        };
        namespaces['http://www.w3.org/2001/XMLSchema-instance'] = {
            prefix: 'xsi',
            pos: emptyPos,
            type: 'declare'
        };
        namespaces['http://www.w3.org/2001/XMLSchema'] = {
            prefix: 'xs',
            pos: emptyPos,
            type: 'declare'
        };
        namespaces['http://www.w3.org/XML/1998/namespace'] = {
            prefix: 'xml',
            pos: emptyPos,
            type: 'declare'
        };
        namespaces['http://zorba.io/annotations'] = {
            prefix: 'an',
            pos: emptyPos,
            type: 'declare',
            override: true
        };
        namespaces['http://www.28msec.com/annotations/rest'] = {
            prefix: 'rest',
            pos: emptyPos,
            type: 'declare',
            override: true
        };
        namespaces['http://www.w3.org/2005/xqt-errors'] = {
            prefix: 'err',
            pos: emptyPos,
            type: 'declare',
            override: true
        };
        namespaces['http://zorba.io/errors'] = {
            prefix: 'zerr',
            pos: emptyPos,
            type: 'declare',
            override: true
        };
    }

    var s = {
        parent: parent,
        children: [],
        pos: pos,
        setModuleResolver: function(resolver){
            this.root.moduleResolver = resolver;
            return this;
        },
        setModules: function(index){
            if(this !== this.root){
                throw new Error('setModules() not invoked from the root static context.');
            }
            this.moduleResolver = function(uri){
                return index[uri];
            };
            var that = this;
            Object.keys(this.namespaces).forEach(function(uri){
                var ns = that.namespaces[uri];
                if(ns.type === 'module') {
                    var mod = that.moduleResolver(uri);
                    if(mod.variables) {
                        TreeOps.concat(that.variables, mod.variables);
                    }
                    if(mod.functions) {
                        TreeOps.concat(that.functions, mod.functions);
                    }
                }
            });
            return this;
        },
        setModulesFromXQDoc: function(xqdoc){
            if(this !== this.root){
                throw new Error('setModulesFromXQDoc() not invoked from the root static context.');
            }
            var index = {};
            Object.keys(xqdoc).forEach(function(uri) {
                var mod = xqdoc[uri];
                var variables = {};
                var functions = {};
                mod.functions.forEach(function(fn){
                    functions[uri + '#' + fn.name + '#' + fn.arity] = {
                        params: [],
                        annotations: [],
                        name: fn.name,
                        arity: fn.arity,
                        eqname: { uri: uri, name: fn.name }
                    };
                    fn.parameters.forEach(function(param){
                        functions[uri + '#' + fn.name + '#' + fn.arity].params.push('$' + param.name);
                    });
                });
                mod.variables.forEach(function(variable){
                    var name = variable.name.substring(variable.name.indexOf(':') + 1);
                    variables[uri + '#' + name] = { type: 'VarDecl', annotations: [], eqname: { uri: uri, name: name } };
                });
                index[uri] = {
                    variables: variables,
                    functions: functions
                };
            });
            this.root.moduleResolver = function(uri){
                return index[uri];
            };
            var that = this;
            Object.keys(this.namespaces).forEach(function(uri){
                var ns = that.namespaces[uri];
                if(ns.type === 'module') {
                    var mod = that.moduleResolver(uri);
                    if(mod.variables) {
                        TreeOps.concat(that.variables, mod.variables);
                    }
                    if(mod.functions) {
                        TreeOps.concat(that.functions, mod.functions);
                    }
                }
            });
            return this;
        },
        moduleNamespace: '',
        defaultFunctionNamespace: 'http://www.w3.org/2005/xpath-functions',
        defaultFunctionNamespaces: [
            'http://www.28msec.com/modules/collections',
            'http://www.28msec.com/modules/store',
            'http://jsoniq.org/functions',
            'http://jsoniq.org/function-library',
            'http://www.w3.org/2001/XMLSchema' //Built-in type constructors
        ],
        defaultElementNamespace: '',
        namespaces: namespaces,
        availableModuleNamespaces: [],
        importModule: function(uri, prefix, pos) {
            if(this !== this.root){
                throw new Error('Function not invoked from the root static context.');
            }
            this.addNamespace(uri, prefix, pos, 'module');
            if(this.moduleResolver) {
                try {
                    var mod = this.moduleResolver(uri, []);
                    if(mod.variables) {
                        TreeOps.concat(this.variables, mod.variables);
                    }
                    if(mod.functions) {
                        TreeOps.concat(this.functions, mod.functions);
                    }
                } catch(e) {
                    throw new StaticError('XQST0059', 'module "' + uri + '" not found', pos);
                }
            }
            return this;
        },
        getAvailableModuleNamespaces: function(){
            return this.root.availableModuleNamespaces;
        },
        getPrefixByNamespace: function(uri){
            return this.root.namespaces[uri].prefix;
        },
        addNamespace: function (uri, prefix, pos, type) {
            if(prefix === '' && type === 'module') {
                throw new StaticWarning('W01', 'Avoid this type of import. Use import module namespace instead', pos);
            }
            if (uri === '') {
                throw new StaticError('XQST0088', 'empty target namespace in module import or module declaration', pos);
            }
            var namespace = this.getNamespace(uri);
            if (namespace && namespace.type === type && type !== 'declare' && !namespace.override) {
                throw new StaticError('XQST0047', '"' + uri + '": duplicate target namespace', pos);
            }
            namespace = this.getNamespaceByPrefix(prefix);
            if (namespace && !namespace.override) {
                throw new StaticError('XQST0033', '"' + prefix + '": namespace prefix already bound to "' + namespace.uri + '"', pos);
            }

            namespace = this.namespaces[uri];
            this.namespaces[uri] = {
                prefix: prefix,
                pos: pos,
                type: type
            };

            if (namespace) {
                throw new StaticWarning('W02', '"' + uri + '" already bound to the "' + namespace.prefix + '" prefix', pos);
            }

        },

        getNamespaces: function(){
            return this.root.namespaces;
        },
        
        getNamespace: function (uri) {
            var that = this;
            while (that) {
                var namespace = that.namespaces[uri];
                if (namespace) {
                    return namespace;
                }
                that = that.parent;
            }

        },

        getNamespaceByPrefix: function (prefix) {
            var handler = function (uri) {
                var namespace = that.namespaces[uri];
                if (namespace.prefix === prefix) {
                    namespace.uri = uri;
                    throw namespace;
                }
            };
            var that = this;
            while (that) {
                try {
                    Object.keys(that.namespaces).forEach(handler);
                } catch (e) {
                    return e;
                }
                that = that.parent;
            }

        },
        
        resolveQName: function(value, pos){
            var qname = {
                uri: '',
                prefix: '',
                name: ''
            };
            var idx;
            if (value.substring(0, 2) === 'Q{') {
                idx = value.indexOf('}');
                qname.uri = value.substring(2, idx);
                qname.name = value.substring(idx + 1);
            } else {
                idx = value.indexOf(':');
                qname.prefix = value.substring(0, idx);
                var namespace = this.getNamespaceByPrefix(qname.prefix);
                if(!namespace && qname.prefix !== '' && ['fn', 'jn'].indexOf(qname.prefix) === -1) {
                    throw new StaticError('XPST0081', '"' + qname.prefix + '": can not expand prefix of lexical QName to namespace URI', pos);
                }
                if(namespace) {
                    qname.uri = namespace.uri;
                }
                qname.name = value.substring(idx + 1);
            }
            return qname;
        },
        
        variables: {},
        varRefs: {},
        functionCalls: {},
    
        addVariable: function(qname, type, pos){
            if(
                type === 'VarDecl' && this.moduleNamespace !== '' &&
                !(this.moduleNamespace === qname.uri || (qname.uri === '' && this.defaultFunctionNamespace === this.moduleNamespace))
            ) {
                throw new StaticError('XQST0048', '"' + qname.prefix + ':' + qname.name + '": Qname not library namespace', pos);
            }
            var key = getVarKey(qname);
            if(type === 'VarDecl' && this.variables[key]) {
                throw new StaticError('XQST0049', '"' + qname.name + '": duplicate variable declaration', pos);
            }
            this.variables[key] = {
                type: type,
                pos: pos,
                qname: qname,
                annotations: {}
            };
            return this;
        },
        
        getVariables: function(){
            var variables = {};
            var that = this;
            var handler = function(key){
                if(!variables[key]){
                    variables[key] = that.variables[key];
                }
            };
            while(that){
                Object.keys(that.variables).forEach(handler);
                that = that.parent;
            }
            return variables;
        },
        
        getVariable: function(qname) {
            var key = getVarKey(qname);
            var that = this;
            while(that) {
                if(that.variables[key]) {
                    return that.variables[key];
                }
                that = that.parent;
            }
        },
        
        addVarRef: function(qname, pos){
            var varDecl = this.getVariable(qname);
            if(!varDecl && (qname.uri === '' || this.root.moduleResolver)) {
                throw new StaticError('XPST0008', '"' + qname.name + '": undeclared variable', pos);
            }
            var key = getVarKey(qname);
            this.varRefs[key] = true;
        },
        
        addFunctionCall: function(qname, arity, pos){
            var fn = this.getFunction(qname, arity);
            if(!fn && (qname.uri === 'http://www.w3.org/2005/xquery-local-functions' || this.root.moduleResolver)){
                if((qname.uri === 'http://www.w3.org/2005/xpath-functions' ||
                    (qname.uri === '' && this.root.defaultFunctionNamespaces.concat(this.root.defaultFunctionNamespace).indexOf('http://www.w3.org/2005/xpath-functions') !== -1)) && qname.name === 'concat') {
                } else if(!fn){
                    throw new StaticError('XPST0008', '"' + qname.name + '#' + arity + '": undeclared function', pos);
                }
            }
            var key = getFnKey(qname, arity);
            this.functionCalls[key] = true;
        },
        
        functions: getSchemaBuiltinTypes()['http://www.w3.org/2001/XMLSchema'].functions,

        getFunctions: function(){
            return this.root.functions;
        },
        
        getFunction: function(qname, arity){
            var key = getFnKey(qname, arity);
            var fn;
            if(qname.uri === '') {
                var that = this;
                this.root.defaultFunctionNamespaces.concat([this.root.defaultFunctionNamespace]).forEach(function(defaultFunctionNamespace){
                    if(!fn){
                        fn = that.getFunction({ uri: defaultFunctionNamespace, prefix: qname.prefix, name: qname.name }, arity);
                    } else {
                        return false;
                    }
                });
                return fn;
            } else {
                return this.root.functions[key];
            }
        },
        
        addFunction: function(qname, pos, params) {
            if(this !== this.root){
                throw new Error('addFunction() not invoked from the root static context.');
            }
            var arity = params.length;
            if(
                this.moduleNamespace !== '' &&
                !(this.moduleNamespace === qname.uri || (qname.uri === '' && this.defaultFunctionNamespace === this.moduleNamespace))
            ) {
                throw new StaticError('XQST0048', '"' + qname.prefix + ':' + qname.name + '": Qname not library namespace', pos);
            }
            var key = getFnKey(qname, arity);
            if(this.functions[key]) {
                throw new StaticError('XQST0034', '"' + qname.name + '": duplicate function declaration', pos);
            }
            this.functions[key] = {
                pos: pos,
                params: params
            };
            return this;
        }
        
    };
    s.root = parent ? parent.root : s;
    return s;
};

},
{"../tree_ops":11,"./errors":1,"./schema_built-in_types":3}],
5:[function(require,module,exports){
exports.Translator = function(rootStcx, ast){
    'use strict';

    var Errors = require('./errors');
    var StaticError = Errors.StaticError;
    var StaticWarning = Errors.StaticWarning;
    
    var TreeOps = require('../tree_ops').TreeOps;
    var StaticContext = require('./static_context').StaticContext;
    var Handlers = require('./handlers');
    
    var get = function(node, path){
        var result = [];
        if(path.length === 0){
            return node;
        }
        node.children.forEach(function(child){
            if(child.name === path[0] && path.length > 1) {
                result = get(child, path.slice(1));
            } else if(child.name === path[0]) {
                result.push(child);
            }
        });
        return result;
    };
    
    var markers = [];
    this.apply = function(fn) {
        try {
            fn();
        } catch(e) {
            if(e instanceof StaticError) {
                addStaticError(e);
            } else if(e instanceof StaticWarning) {
                addWarning(e.getCode(), e.getMessage(), e.getPos());
            } else {
                throw e;
            }
        }
    };

    var addStaticError = function(e){
        markers.push({
            pos: e.getPos(),
            type: 'error',
            level: 'error',
            message: '[' + e.getCode() + '] ' + e.getMessage()
        });
    };
    
    var addWarning = function(code, message, pos) {
        markers.push({
            pos: pos,
            type: 'warning',
            level: 'warning',
            message: '[' + code + '] ' + message
        });
    };
    
    this.getMarkers = function(){
        return markers;
    };

    var translator = this;

    rootStcx.pos = ast.pos;
    var sctx = rootStcx;
    var pushSctx = function(pos){
        sctx = new StaticContext(sctx, pos);
        sctx.parent.children.push(sctx);
    };
    
    var popSctx = function(pos){
        if (pos !== undefined) {
            sctx.pos.el = pos.el;
            sctx.pos.ec = pos.ec;
        }

        Object.keys(sctx.varRefs).forEach(function(key){
            if(!sctx.variables[key]) {
                sctx.parent.varRefs[key] = true;
            }
        });
        Object.keys(sctx.variables).forEach(function(key){
            if(!sctx.varRefs[key] && sctx.variables[key].type !== 'GroupingVariable' && sctx.variables[key].type !== 'CatchVar') {
                addWarning('W03', 'Unused variable "$' + sctx.variables[key].qname.name + '"', sctx.variables[key].pos);
            }
        });
        
        sctx = sctx.parent;
    };
    
    this.visitOnly = function(node, names) {
        node.children.forEach(function(child){
            if (names.indexOf(child.name) !== -1){
                translator.visit(child);
            }
        });
    };
    
    this.getFirstChild = function(node, name) {
        var result;
        node.children.forEach(function(child){
            if(child.name === name && result === undefined){
                result = child;
            }
        });
        return result;
    };
    
    this.ModuleDecl = function(node){
        this.visitChildren(node, Handlers.ModuleDecl(translator, rootStcx, node));
        return true;
    };
    
    this.Prolog = function(node){
        this.visitOnly(node, ['DefaultNamespaceDecl', 'Setter', 'NamespaceDecl', 'Import']);
        ast.index.forEach(function(node){
            if(node.name === 'VarDecl') {
                node.children.forEach(function(child){
                    if(child.name === 'VarName') {
                        translator.apply(function(){
                            var value = TreeOps.flatten(child);
                            var qname = rootStcx.resolveQName(value, child.pos);
                            rootStcx.addVariable(qname, node.name, child.pos);
                        });
                    }
                });
            } else if(node.name === 'FunctionDecl') {
                var qname, pos, params = [];
                node.children.forEach(function(child){
                    if(child.name === 'EQName') {
                        qname = child;
                        pos = child.pos;
                    } else if(child.name === 'ParamList'){
                        child.children.forEach(function(c){
                            if(c.name === 'Param') {
                                params.push(TreeOps.flatten(c));
                            }
                        });
                    }
                });
                translator.apply(function(){
                    qname = TreeOps.flatten(qname);
                    qname = rootStcx.resolveQName(qname, pos);
                    rootStcx.addFunction(qname, pos, params);
                });
            }
        });
        this.visitOnly(node, ['ContextItemDecl', 'AnnotatedDecl', 'OptionDecl']);
        return true;
    };
    
    this.ModuleImport = function (node) {
        this.visitChildren(node, Handlers.ModuleImport(translator, rootStcx, node));
        return true;
    };
    
    this.SchemaImport = function (node) {
        this.visitChildren(node, Handlers.SchemaImport(translator, rootStcx, node));
        return true;
    };
    
    this.DefaultNamespaceDecl = function(node){
        this.visitChildren(node, Handlers.DefaultNamespaceDecl(translator, rootStcx, node));
        return true;
    };
    
    this.NamespaceDecl = function (node) {
        this.visitChildren(node, Handlers.NamespaceDecl(translator, rootStcx, node));
        return true;
    };
    
    var annotations = {};
    this.AnnotatedDecl = function(node) {
        annotations = {};
        this.visitChildren(node, Handlers.NamespaceDecl(translator, rootStcx, node));
        return true;
    };
    
    this.CompatibilityAnnotation = function(){
        annotations['http://www.w3.org/2012/xquery#updating'] = [];
        return true;
    };
    
    this.Annotation = function(node){
        this.visitChildren(node, {
            EQName: function(eqname){
                var value = TreeOps.flatten(eqname);
                translator.apply(function(){
                    var qname = sctx.resolveQName(value, eqname.pos);
                    annotations[qname.uri + '#' + qname.name] = [];
                });
            }
        });
        return true;
    };
    
    this.VarDecl = function(node){
        try {
            var varname = translator.getFirstChild(node, 'VarName');
            var value = TreeOps.flatten(varname);
            var qname = sctx.resolveQName(value, varname.pos);
            var variable = rootStcx.getVariable(qname);
            if(variable) {
                variable.annotations = annotations;
            }
        } catch(e) {
        }
        this.visitOnly(node, ['ExprSingle', 'VarValue', 'VarDefaultValue']);
        return true;
    };
    
    this.FunctionDecl = function(node) {
        var isUpdating = annotations['http://www.w3.org/2012/xquery#updating'] !== undefined;
        var typeDecl = get(node, ['ReturnType'])[0];
        var name = get(node, ['EQName'])[0];
        if(!typeDecl && !isUpdating){
            addWarning('W05', 'Untyped return value', name.pos);
        }
        var isExternal = false;
        node.children.forEach(function(child){
            if(child.name === 'TOKEN' && child.value === 'external') {
                isExternal = true;
                return false;
            }
        });
        if(!isExternal) {
            pushSctx(node.pos);
            this.visitChildren(node);
            popSctx();
        }
        return true;
    };
    
    this.VarRef = function(node) {
        this.visitChildren(node, Handlers.VarRefHandler(translator, sctx, node));
        return true;
    };
    
    this.Param = function(node){
        var typeDecl = get(node, ['TypeDeclaration'])[0];
        if(!typeDecl){
            addWarning('W05', 'Untyped function parameter', node.pos);
        }
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };
    
    this.InlineFunctionExpr	= function(node) {
        pushSctx(node.pos);
        this.visitChildren(node);
        popSctx();
        return true;
    };
    var statementCount = [];
    var handleStatements = function(node) {
        pushSctx(node.pos);
        statementCount.push(0);
        translator.visitChildren(node);
        for (var i = 1; i <= statementCount[statementCount.length - 1]; i++) {
            popSctx(node.pos);
        }
        statementCount.pop();
        popSctx();
    };

    this.StatementsAndOptionalExpr = function (node) {
        handleStatements(node);
        return true;
    };

    this.StatementsAndExpr = function (node) {
        handleStatements(node);
        return true;
    };

    this.BlockStatement = function (node) {
        handleStatements(node);
        return true;
    };
    
    this.VarDeclStatement = function(node){
        pushSctx(node.pos);
        statementCount[statementCount.length - 1]++;
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
    };
    var clauses = [];
    this.FLWORExpr = this.FLWORStatement = function (node) {
        pushSctx(node.pos);
        clauses.push(0);
        this.visitChildren(node);
        for(var i=1; i <= clauses[clauses.length - 1]; i++) {
            popSctx(node.pos);
        }
        clauses.pop();
        popSctx();
        return true;
    };
    
    this.ForBinding = function (node) {
        this.visitOnly(node, ['ExprSingle', 'VarValue', 'VarDefaultValue']);
        pushSctx(node.pos);
        clauses[clauses.length - 1]++;
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };
    
    this.LetBinding = function(node){
        this.visitOnly(node, ['ExprSingle', 'VarValue', 'VarDefaultValue']);
        pushSctx(node.pos);
        clauses[clauses.length - 1]++;
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };

    this.GroupingSpec = function(node){
        var isVarDecl = false;
        node.children.forEach(function(child){
            if(child.value === ':=') {
                isVarDecl = true;
                return false;
            }
        });
        if(isVarDecl) {
            var groupingVariable = node.children[0];
            this.visitOnly(node, ['ExprSingle', 'VarValue', 'VarDefaultValue']);
            pushSctx(node.pos);
            clauses[clauses.length - 1]++;
            this.visitChildren(groupingVariable, Handlers.VarHandler(translator, sctx, groupingVariable));
            return true;
        } else {
            
        }
    };
    
    this.TumblingWindowClause = function (node) {
        this.visitOnly(node, ['ExprSingle']);
        pushSctx(node.pos);
        clauses[clauses.length - 1]++;
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        this.visitOnly(node, ['WindowStartCondition', 'WindowEndCondition']);
        return true;
    };

    this.WindowVars = function (node) {
        pushSctx(node.pos);
        clauses[clauses.length - 1]++;
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };

    this.SlidingWindowClause = function (node) {
        this.visitOnly(node, ['ExprSingle', 'VarValue', 'VarDefaultValue']);
        pushSctx(node.pos);
        clauses[clauses.length - 1]++;
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        this.visitOnly(node, ['WindowStartCondition', 'WindowEndCondition']);
        return true;
    };

    this.PositionalVar = function (node) {
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };

    this.PositionalVar = function (node) {
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };

    this.CurrentItem = function (node) {
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };

    this.PreviousItem = function (node) {
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };

    this.NextItem = function (node) {
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };

    this.CountClause = function (node) {
        pushSctx(node.pos);
        clauses[clauses.length - 1]++;
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };
    
    this.CaseClause = function(node) {
        pushSctx(node.pos);
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        this.visitOnly(node, ['ExprSingle']);
        popSctx();
        return true;
    };
    
    this.TransformExpr = function (node) {
        pushSctx(node.pos);
        this.visitChildren(node);
        popSctx();
        return true;
    };
    
    this.TransformSpec = function(node) {
        this.visitOnly(node, ['ExprSingle', 'VarValue', 'VarDefaultValue']);
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };
    var quantifiedDecls = [];
    this.QuantifiedExpr = function (node) {
        pushSctx(node.pos);
        quantifiedDecls.push(0);
        this.visitChildren(node);
        for(var i=1; i <= quantifiedDecls[quantifiedDecls.length - 1]; i++) {
            popSctx(node.pos);
        }
        quantifiedDecls.pop();
        popSctx();
        return true;
    };
    
    this.QuantifiedVarDecl = function(node) {
        this.visitOnly(node, ['ExprSingle']);
        pushSctx(node.pos);
        quantifiedDecls[quantifiedDecls.length - 1]++;
        this.visitChildren(node, Handlers.VarHandler(translator, sctx, node));
        return true;
    };
    
    this.FunctionCall = function(node){
        this.visitOnly(node, ['ArgumentList']);
        var name = translator.getFirstChild(node, 'EQName');
        var eqname = TreeOps.flatten(name);
        var arity = get(node, ['ArgumentList', 'Argument']).length;
        translator.apply(function(){
            var qname = sctx.resolveQName(eqname, node.pos);
            try {
                if(qname.uri !== '') {
                    sctx.root.namespaces[qname.uri].used = true;
                }
            } catch(e){
            }
            sctx.addFunctionCall(qname, arity, name.pos);
        });
        return true;
    };
    
    this.TryClause = function(node){
        pushSctx(node.pos);
        this.visitChildren(node);
        popSctx();
        return true;
    };
    
    this.CatchClause = function(node){
        pushSctx(node.pos);
        var prefix = 'err';
        var uri = 'http://www.w3.org/2005/xqt-errors';
        var emptyPos = { sl: 0, sc: 0, el: 0, ec: 0 };
        sctx.addVariable({ prefix: prefix, uri: uri, name: 'code' }, 'CatchVar', emptyPos);
        sctx.addVariable({ prefix: prefix, uri: uri, name: 'description' }, 'CatchVar', emptyPos);
        sctx.addVariable({ prefix: prefix, uri: uri, name: 'value' }, 'CatchVar', emptyPos);
        sctx.addVariable({ prefix: prefix, uri: uri, name: 'module' }, 'CatchVar', emptyPos);
        sctx.addVariable({ prefix: prefix, uri: uri, name: 'line-number' }, 'CatchVar', emptyPos);
        sctx.addVariable({ prefix: prefix, uri: uri, name: 'column-number' }, 'CatchVar', emptyPos);
        sctx.addVariable({ prefix: prefix, uri: uri, name: 'additional' }, 'CatchVar', emptyPos);
        this.visitChildren(node);
        popSctx();
        return true;
    };

    this.Pragma = function(node){
        var qname = TreeOps.flatten(get(node, ['EQName'])[0]);
        qname = rootStcx.resolveQName(qname, node);
        var value = TreeOps.flatten(get(node, ['PragmaContents'])[0]);
        if (qname.name === 'xqlint' && qname.uri === 'http://xqlint.io') {
            pushSctx(node.pos);
            var commands = value.match(/[a-zA-Z]+\(([^)]+)\)/g);
            commands.forEach(function (command) {
                var name = command.substring(0, command.indexOf('('));
                var args = command.substring(0, command.length - 1).substring(command.indexOf('(') + 1).split(',').map(function (val) {
                    return val.trim();
                });
                if (name === 'varrefs') {
                    args.forEach(function (arg) {
                        var qname = sctx.resolveQName(arg.substring(1), node.pos);
                        if (qname.uri !== '') {
                            sctx.root.namespaces[qname.uri].used = true;
                        }
                        sctx.addVarRef(qname, node.pos);
                    });
                }
            });
            this.visitChildren(node);
            popSctx();
            return true;
        }
    };

    this.visit = function (node) {
        var name = node.name;
        var skip = false;

        if (typeof this[name] === 'function') {
            skip = this[name](node) === true;
        }

        if (!skip) {
            this.visitChildren(node);
        }
    };

    this.visitChildren = function (node, handler) {
        for (var i = 0; i < node.children.length; i++) {
            var child = node.children[i];
            if (handler !== undefined && typeof handler[child.name] === 'function') {
                handler[child.name](child);
            } else {
                this.visit(child);
            }
        }
    };

    this.visit(ast);
    Object.keys(rootStcx.variables).forEach(function(key){
        if(!rootStcx.varRefs[key] && (rootStcx.variables[key].annotations['http://www.w3.org/2005/xpath-functions#private'] || rootStcx.moduleNamespace === '') && rootStcx.variables[key].pos) {
            addWarning('W03', 'Unused variable "' + rootStcx.variables[key].qname.name + '"', rootStcx.variables[key].pos);
        }
    });
    Object.keys(rootStcx.namespaces).forEach(function(uri){
        var namespace = rootStcx.namespaces[uri];
        if(namespace.used === undefined && !namespace.override && namespace.type === 'module') {
            addWarning('W04', 'Unused module "' + uri + '"', namespace.pos);
        }
    });
};

},
{"../tree_ops":11,"./errors":1,"./handlers":2,"./static_context":4}],
6:[function(require,module,exports){
'use strict';

var TreeOps = require('../tree_ops').TreeOps;

var ID_REGEX = /[a-zA-Z_0-9\$]/;

function retrievePrecedingIdentifier(text, pos, regex) {
    regex = regex || ID_REGEX;
    var buf = [];
    for (var i = pos-1; i >= 0; i--) {
        if (regex.test(text[i])) {
            buf.push(text[i]);
        } else {
            break;
        }
    }
    return buf.reverse().join('');
}

function prefixBinarySearch(items, prefix) {
    var startIndex = 0;
    var stopIndex = items.length - 1;
    var middle = Math.floor((stopIndex + startIndex) / 2);
    
    while (stopIndex > startIndex && middle >= 0 && items[middle].indexOf(prefix) !== 0) {
        if (prefix < items[middle]) {
            stopIndex = middle - 1;
        } else if (prefix > items[middle]) {
            startIndex = middle + 1;
        }
        middle = Math.floor((stopIndex + startIndex) / 2);
    }
    while (middle > 0 && items[middle-1].indexOf(prefix) === 0) {
        middle--;
    }
    return middle >= 0 ? middle : 0; // ensure we're not returning a negative index
}

var uriRegex = /[a-zA-Z_0-9\/\.:\-#]/;
var char = '-._A-Za-z0-9:\u00B7\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02ff\u0300-\u037D\u037F-\u1FFF\u200C\u200D\u203f\u2040\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD';
var nameChar = '[' + char + ']';
var varChar = '[' + char + '\\$]';
var nameCharRegExp = new RegExp(nameChar);
var varCharRegExp = new RegExp(varChar);

var varDeclLabels = {
    'LetBinding': 'Let binding',
    'Param': 'Function parameter',
    'QuantifiedExpr': 'Quantified expression binding',
    'VarDeclStatement': 'Local variable',
    'ForBinding': 'For binding',
    'TumblingWindowClause': 'Tumbling window binding',
    'WindowVars': 'Window variable',
    'SlidingWindowClause': 'Sliding window binding',
    'PositionalVar': 'Positional variable',
    'CurrentItem': 'Current item',
    'PreviousItem': 'Previous item',
    'NextItem': 'Next item',
    'CountClause': 'Count binding',
    'GroupingVariable': 'Grouping variable',
    'VarDecl': 'Module variable'
};

var findCompletions = function(prefix, allIdentifiers) {
    allIdentifiers.sort();
    var startIdx = prefixBinarySearch(allIdentifiers, prefix);
    var matches = [];
    for (var i = startIdx; i < allIdentifiers.length && allIdentifiers[i].indexOf(prefix) === 0; i++) {
        matches.push(allIdentifiers[i]);
    }
    return matches;
};


var completePrefix = function(identifier, pos, sctx){
    var idx = identifier.indexOf(':');
    if(idx === -1) {
        var prefixes = [];
        var namespaces = sctx.getNamespaces();
        Object.keys(namespaces).forEach(function(key){
            if(namespaces[key].type === 'module' || key === 'http://www.w3.org/2005/xquery-local-functions') {
                prefixes.push(namespaces[key].prefix);
            }
        });
        var matches = findCompletions(identifier, prefixes);
        var match = function(name) {
            return {
                name: name + ':',
                value: name + ':',
                meta: 'prefix'
            };
        };
        return matches.map(match);
    } else {
        return [];
    }
};

var completeFunction = function(identifier, pos, sctx){
    var names = [];
    var snippets = {};
    var functions = sctx.getFunctions();
    var uri = '';
    var prefix = '';
    var name = identifier;
    var idx = identifier.indexOf(':');
    var defaultNamespace = false;
    if(idx !== -1){
        prefix = identifier.substring(0, idx);
        name = identifier.substring(idx + 1);
        var ns = sctx.getNamespaceByPrefix(prefix);
        if(ns){
            uri = sctx.getNamespaceByPrefix(prefix).uri;
        }
    } else {
        defaultNamespace = true;
        uri = sctx.root.defaultFunctionNamespace;
    }
    Object.keys(functions).forEach(function(key){
        var fn = functions[key];
        var ns = key.substring(0, key.indexOf('#'));
        var name = key.substring(key.indexOf('#') + 1);
        name = name.substring(0, name.indexOf('#'));
        if(ns !== uri) {
            return;
        }
        if(!defaultNamespace){
            name = sctx.getNamespaces()[ns].prefix + ':' + name;
        }
        name += '(';
        var snippet = name;
        snippet += fn.params.map(function(param, index){
            return '${' + (index + 1) + ':\\' + param.split(' ')[0] + '}';
        }).join(', ');
        name += fn.params.join(', ');
        name += ')';
        snippet += ')';
        names.push(name);
        snippets[name] = snippet;
    });
    var matches = findCompletions(identifier, names);
    var match = function(name) {
        return {
            name: name,
            value: name,
            meta: 'function',
            priority: 4,
            identifierRegex: nameCharRegExp,
            snippet: snippets[name]
        };
    };
    return matches.map(match);
};

var completeVariable = function(identifier, pos, sctx){
    var uri = '';
    var prefix = '';
    var idx = identifier.indexOf(':');
    if(idx !== -1){
        prefix = identifier.substring(0, idx);
        uri = sctx.getNamespaceByPrefix(prefix).uri;
    }
    var decls = sctx.getVariables();
    var names = [];
    var types = {};
    Object.keys(decls).forEach(function(key){
        var i = key.indexOf('#');
        var ns = key.substring(0, i);
        var name = key.substring(i+1);
        if(ns !== ''){
            names.push(sctx.getPrefixByNamespace(ns) + ':' + name);
            types[sctx.getPrefixByNamespace(ns) + ':' + name] = decls[key].type;
        } else {
            names.push(name);
            types[name] = decls[key].type;
        }
    });
    
    var matches = findCompletions(identifier, names);
    var match = function(name) {
        return {
            name: '$' + name,
            value: '$' + name,
            meta: varDeclLabels[types[name]],
            priority: 4,
            identifierRegex: varCharRegExp
        };
    };
    return matches.map(match);
};

var completeExpr = function(line, pos, sctx){
    var identifier = retrievePrecedingIdentifier(line, pos.col, nameCharRegExp);
    var before = line.substring(0, pos.col - (identifier.length === 0 ? 0 : identifier.length));
    var isVar = before[before.length - 1] === '$';
    if(isVar) {
        return completeVariable(identifier, pos, sctx);
    } else if(identifier !== '') {
        return completeFunction(identifier, pos, sctx).concat(completePrefix(identifier, pos, sctx));
    } else {
        return completeVariable(identifier, pos, sctx).concat(completeFunction(identifier, pos, sctx)).concat(completePrefix(identifier, pos, sctx));
    }
};

var completeModuleUri = function(line, pos, sctx){
    var identifier = retrievePrecedingIdentifier(line, pos.col, uriRegex);
    var matches = findCompletions(identifier, sctx.getAvailableModuleNamespaces());
    var match = function(uri) {
        return {
            name: uri,
            value: uri,
            meta: 'module',
            priority: 4,
            identifierRegex: uriRegex
        };
    };
    return matches.map(match);
};

exports.complete = function(source, ast, rootSctx, pos){
    var line = source.split('\n')[pos.line];
    var node = TreeOps.findNode(ast, pos);
    var sctx = TreeOps.findNode(rootSctx, pos);
    sctx = sctx ? sctx : rootSctx;
    if(node && node.name === 'URILiteral' && node.getParent && node.getParent.name === 'ModuleImport'){
        return completeModuleUri(line, pos, sctx);
    } else {
        return completeExpr(line, pos, sctx);
    }
};

},
{"../tree_ops":11}],
7:[function(require,module,exports){
exports.StyleChecker = function (ast, source) {
    'use strict';

    var tab = '    ';
    var markers = [];
    
    this.getMarkers = function(){
        return markers;
    };

    this.WS = function(node) {
        var lines = node.value.split('\n');
        lines.forEach(function(line, index){
            var isFirst = index === 0;
            var isLast  = index === (lines.length - 1);

            if(/\r$/.test(line)) {
                markers.push({
                    pos: {
                        sl: node.pos.sl + index,
                        el: node.pos.sl + index,
                        sc: line.length - 1,
                        ec: line.length
                    },
                    type: 'warning',
                    level: 'warning',
                    message: '[SW01] Detected CRLF'
                });
            }
            
            var match = line.match(/\t+/);
            if(match !== null){
                markers.push({
                    pos: {
                        sl: node.pos.sl + index,
                        el: node.pos.sl + index,
                        sc: match.index,
                        ec: match.index + match[0].length
                    },
                    type: 'warning',
                    level: 'warning',
                    message: '[SW02] Tabs detected'
                });
            }

            if((!isFirst) && isLast){
                match = line.match(/^\ +/);
                if(match !== null) {
                    var mod = match[0].length % tab.length;
                    if(mod !== 0) {
                        markers.push({
                            pos: {
                                sl: node.pos.sl + index,
                                el: node.pos.sl + index,
                                sc: match.index,
                                ec: match.index + match[0].length
                            },
                            type: 'warning',
                            level: 'warning',
                            message: '[SW03] Unexcepted indentation of ' + match[0].length
                        });
                    }
                }
            }
        });
        return true;
    };
    
    this.visit = function (node, index) {
        var name = node.name;
        var skip = false;

        if (typeof this[name] === 'function') {
            skip = this[name](node, index) === true;
        }

        if (!skip) {
            this.visitChildren(node);
        }
    };

    this.visitChildren = function (node, handler) {
        for (var i = 0; i < node.children.length; i++) {
            var child = node.children[i];
            if (handler !== undefined && typeof handler[child.name] === 'function') {
                handler[child.name](child);
            } else {
                this.visit(child);
            }
        }
    };

    source.split('\n').forEach(function(line, index){
        var match = line.match(/\ +$/);
        if(match){
            markers.push({
                pos: {
                    sl: index,
                    el: index,
                    sc: match.index,
                    ec: match.index + match[0].length
                },
                type: 'warning',
                level: 'warning',
                message: '[SW04] Trailing whitespace'
            });
        }
    });
    this.visit(ast);
};
},
{}],
8:[function(require,module,exports){
exports.JSONParseTreeHandler = function (code) {
	'use strict';
    var toBeIndex = ['VarDecl', 'FunctionDecl'];
    var list = [
        'OrExpr', 'AndExpr', 'ComparisonExpr', 'StringConcatExpr', 'RangeExpr',
        'UnionExpr', 'IntersectExceptExpr', 'InstanceofExpr', 'TreatExpr', 'CastableExpr', 'CastExpr', 'UnaryExpr', 'ValueExpr',
        'FTContainsExpr', 'SimpleMapExpr', 'PathExpr', 'RelativePathExpr', 'PostfixExpr', 'StepExpr'
    ];

    var ast = null;
    var ptr = null;
    var remains = code;
    var cursor = 0;
    var lineCursor = 0;
    var line = 0;

    function createNode(name) {
        return {
            name: name,
            children: [],
            getParent: null,
            pos: {
                sl: 0,
                sc: 0,
                el: 0,
                ec: 0
            }
        };
    }

    function pushNode(name) { //begin
        var node = createNode(name);
        if (ast === null) {
            ast = node;
            ast.index = [];
            ptr = node;
        } else {
            node.getParent = ptr;
            ptr.children.push(node);
            ptr = ptr.children[ptr.children.length - 1];
        }
    }

    function popNode() {

        if (ptr.children.length > 0) {
            var s = ptr.children[0];
            var e = null;
            for (var i = ptr.children.length - 1; i >= 0; i--) {
                e = ptr.children[i];
                if (e.pos.el !== 0 || e.pos.ec !== 0) {
                    break;
                }
            }
            ptr.pos.sl = s.pos.sl;
            ptr.pos.sc = s.pos.sc;
            ptr.pos.el = e.pos.el;
            ptr.pos.ec = e.pos.ec;
        }
        if (ptr.name === 'FunctionName') {
            ptr.name = 'EQName';
        }
        if (ptr.name === 'EQName' && ptr.value === undefined) {
            ptr.value = ptr.children[0].value;
            ptr.children.pop();
        }
    
        if(toBeIndex.indexOf(ptr.name) !== -1) {
            ast.index.push(ptr);
        }
    
        if (ptr.getParent !== null) {
            ptr = ptr.getParent;
        } else {
        }
        if (ptr.children.length > 0) {
            var lastChild = ptr.children[ptr.children.length - 1];
            if (lastChild.children.length === 1 && list.indexOf(lastChild.name) !== -1) {
                ptr.children[ptr.children.length - 1] = lastChild.children[0];
            }
        }
    }

    this.closeParseTree = function () {
        while (ptr.getParent !== null) {
            popNode();
        }
        popNode();
    };

    this.peek = function () {
        return ptr;
    };

    this.getParseTree = function () {
        return ast;
    };

    this.reset = function () {}; //input

    this.startNonterminal = function (name, begin) {
        pushNode(name, begin);
    };

    this.endNonterminal = function () {//name, end
        popNode();
    };

    this.terminal = function (name, begin, end) {
        name = (name.substring(0, 1) === '\'' && name.substring(name.length - 1) === '\'') ? 'TOKEN' : name;
        pushNode(name, begin);
        setValue(ptr, begin, end);
        popNode();
    };

    this.whitespace = function (begin, end) {
        var name = 'WS';
        pushNode(name, begin);
        setValue(ptr, begin, end);
        popNode();
    };

    function setValue(node, begin, end) {

        var e = end - cursor;
        ptr.value = remains.substring(0, e);
        remains = remains.substring(e);
        cursor = end;

        var sl = line;
        var sc = lineCursor;
        var el = sl + ptr.value.split('\n').length - 1;
        var lastIdx = ptr.value.lastIndexOf('\n');
        var ec = lastIdx === -1 ? sc + ptr.value.length : ptr.value.substring(lastIdx + 1).length;

        line = el;
        lineCursor = ec;

        ptr.pos.sl = sl;
        ptr.pos.sc = sc;
        ptr.pos.el = el;
        ptr.pos.ec = ec;
    }
};
},
{}],
9:[function(require,module,exports){
                                                            var JSONiqParser = exports.JSONiqParser = function JSONiqParser(string, parsingEventHandler)
                                                            {
                                                              init(string, parsingEventHandler);
  var self = this;

  this.ParseException = function(b, e, s, o, x)
  {
    var
      begin = b,
      end = e,
      state = s,
      offending = o,
      expected = x;

    this.getBegin = function() {return begin;};
    this.getEnd = function() {return end;};
    this.getState = function() {return state;};
    this.getExpected = function() {return expected;};
    this.getOffending = function() {return offending;};

    this.getMessage = function()
    {
      return offending < 0 ? "lexical analysis failed" : "syntax error";
    };
  };

  function init(string, parsingEventHandler)
  {
    eventHandler = parsingEventHandler;
    input = string;
    size = string.length;
    reset(0, 0, 0);
  }

  this.getInput = function()
  {
    return input;
  };

  function reset(l, b, e)
  {
            b0 = b; e0 = b;
    l1 = l; b1 = b; e1 = e;
    l2 = 0;
    end = e;
    ex = -1;
    memo = {};
    eventHandler.reset(input);
  }

  this.getOffendingToken = function(e)
  {
    var o = e.getOffending();
    return o >= 0 ? JSONiqParser.TOKEN[o] : null;
  };

  this.getExpectedTokenSet = function(e)
  {
    var expected;
    if (e.getExpected() < 0)
    {
      expected = JSONiqParser.getTokenSet(- e.getState());
    }
    else
    {
      expected = [JSONiqParser.TOKEN[e.getExpected()]];
    }
    return expected;
  };

  this.getErrorMessage = function(e)
  {
    var tokenSet = this.getExpectedTokenSet(e);
    var found = this.getOffendingToken(e);
    var prefix = input.substring(0, e.getBegin());
    var lines = prefix.split("\n");
    var line = lines.length;
    var column = lines[line - 1].length + 1;
    var size = e.getEnd() - e.getBegin();
    return e.getMessage()
         + (found == null ? "" : ", found " + found)
         + "\nwhile expecting "
         + (tokenSet.length == 1 ? tokenSet[0] : ("[" + tokenSet.join(", ") + "]"))
         + "\n"
         + (size == 0 || found != null ? "" : "after successfully scanning " + size + " characters beginning ")
         + "at line " + line + ", column " + column + ":\n..."
         + input.substring(e.getBegin(), Math.min(input.length, e.getBegin() + 64))
         + "...";
  };

  this.parse_XQuery = function()
  {
    eventHandler.startNonterminal("XQuery", e0);
    lookahead1W(278);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Module();
    shift(25);                      // EOF
    eventHandler.endNonterminal("XQuery", e0);
  };

  function parse_Module()
  {
    eventHandler.startNonterminal("Module", e0);
    switch (l1)
    {
    case 170:                       // 'jsoniq'
      lookahead2W(168);             // S^WS | '#' | '(' | '(:' | 'encoding' | 'version'
      break;
    default:
      lk = l1;
    }
    if (lk == 64682                 // 'jsoniq' 'encoding'
     || lk == 137898)               // 'jsoniq' 'version'
    {
      parse_VersionDecl();
    }
    lookahead1W(278);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    switch (l1)
    {
    case 185:                       // 'module'
      lookahead2W(146);             // S^WS | '#' | '(' | '(:' | 'namespace'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 95929:                     // 'module' 'namespace'
      whitespace();
      parse_LibraryModule();
      break;
    default:
      whitespace();
      parse_MainModule();
    }
    eventHandler.endNonterminal("Module", e0);
  }

  function parse_VersionDecl()
  {
    eventHandler.startNonterminal("VersionDecl", e0);
    shift(170);                     // 'jsoniq'
    lookahead1W(120);               // S^WS | '(:' | 'encoding' | 'version'
    switch (l1)
    {
    case 126:                       // 'encoding'
      shift(126);                   // 'encoding'
      lookahead1W(17);              // StringLiteral | S^WS | '(:'
      shift(11);                    // StringLiteral
      break;
    default:
      shift(269);                   // 'version'
      lookahead1W(17);              // StringLiteral | S^WS | '(:'
      shift(11);                    // StringLiteral
      lookahead1W(113);             // S^WS | '(:' | ';' | 'encoding'
      if (l1 == 126)                // 'encoding'
      {
        shift(126);                 // 'encoding'
        lookahead1W(17);            // StringLiteral | S^WS | '(:'
        shift(11);                  // StringLiteral
      }
    }
    lookahead1W(29);                // S^WS | '(:' | ';'
    whitespace();
    parse_Separator();
    eventHandler.endNonterminal("VersionDecl", e0);
  }

  function parse_LibraryModule()
  {
    eventHandler.startNonterminal("LibraryModule", e0);
    parse_ModuleDecl();
    lookahead1W(142);               // S^WS | EOF | '(:' | 'declare' | 'import'
    whitespace();
    parse_Prolog();
    eventHandler.endNonterminal("LibraryModule", e0);
  }

  function parse_ModuleDecl()
  {
    eventHandler.startNonterminal("ModuleDecl", e0);
    shift(185);                     // 'module'
    lookahead1W(64);                // S^WS | '(:' | 'namespace'
    shift(187);                     // 'namespace'
    lookahead1W(240);               // NCName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_NCName();
    lookahead1W(30);                // S^WS | '(:' | '='
    shift(61);                      // '='
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    lookahead1W(29);                // S^WS | '(:' | ';'
    whitespace();
    parse_Separator();
    eventHandler.endNonterminal("ModuleDecl", e0);
  }

  function parse_Prolog()
  {
    eventHandler.startNonterminal("Prolog", e0);
    for (;;)
    {
      lookahead1W(278);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 109:                     // 'declare'
        lookahead2W(207);           // S^WS | '#' | '%' | '(' | '(:' | 'base-uri' | 'boundary-space' | 'collection' |
        break;
      case 155:                     // 'import'
        lookahead2W(169);           // S^WS | '#' | '(' | '(:' | 'module' | 'schema'
        break;
      default:
        lk = l1;
      }
      if (lk != 43117               // 'declare' 'base-uri'
       && lk != 44141               // 'declare' 'boundary-space'
       && lk != 50797               // 'declare' 'construction'
       && lk != 53869               // 'declare' 'copy-namespaces'
       && lk != 54893               // 'declare' 'decimal-format'
       && lk != 56429               // 'declare' 'default'
       && lk != 73325               // 'declare' 'ft-option'
       && lk != 94875               // 'import' 'module'
       && lk != 95853               // 'declare' 'namespace'
       && lk != 106093              // 'declare' 'ordering'
       && lk != 115821              // 'declare' 'revalidation'
       && lk != 117403)             // 'import' 'schema'
      {
        break;
      }
      switch (l1)
      {
      case 109:                     // 'declare'
        lookahead2W(201);           // S^WS | '(:' | 'base-uri' | 'boundary-space' | 'construction' |
        break;
      default:
        lk = l1;
      }
      if (lk == 56429)              // 'declare' 'default'
      {
        lk = memoized(0, e0);
        if (lk == 0)
        {
          var b0A = b0; var e0A = e0; var l1A = l1;
          var b1A = b1; var e1A = e1; var l2A = l2;
          var b2A = b2; var e2A = e2;
          try
          {
            try_DefaultNamespaceDecl();
            lk = -1;
          }
          catch (p1A)
          {
            lk = -2;
          }
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(0, e0, lk);
        }
      }
      switch (lk)
      {
      case -1:
        whitespace();
        parse_DefaultNamespaceDecl();
        break;
      case 95853:                   // 'declare' 'namespace'
        whitespace();
        parse_NamespaceDecl();
        break;
      case 155:                     // 'import'
        whitespace();
        parse_Import();
        break;
      case 73325:                   // 'declare' 'ft-option'
        whitespace();
        parse_FTOptionDecl();
        break;
      default:
        whitespace();
        parse_Setter();
      }
      lookahead1W(29);              // S^WS | '(:' | ';'
      whitespace();
      parse_Separator();
    }
    for (;;)
    {
      lookahead1W(278);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 109:                     // 'declare'
        lookahead2W(202);           // S^WS | '#' | '%' | '(' | '(:' | 'collection' | 'context' | 'function' | 'index' |
        break;
      default:
        lk = l1;
      }
      if (lk != 17005               // 'declare' '%'
       && lk != 49261               // 'declare' 'collection'
       && lk != 52333               // 'declare' 'context'
       && lk != 75373               // 'declare' 'function'
       && lk != 80493               // 'declare' 'index'
       && lk != 83565               // 'declare' 'integrity'
       && lk != 104045              // 'declare' 'option'
       && lk != 134765              // 'declare' 'updating'
       && lk != 137325)             // 'declare' 'variable'
      {
        break;
      }
      switch (l1)
      {
      case 109:                     // 'declare'
        lookahead2W(197);           // S^WS | '%' | '(:' | 'collection' | 'context' | 'function' | 'index' |
        break;
      default:
        lk = l1;
      }
      switch (lk)
      {
      case 52333:                   // 'declare' 'context'
        whitespace();
        parse_ContextItemDecl();
        break;
      case 104045:                  // 'declare' 'option'
        whitespace();
        parse_OptionDecl();
        break;
      default:
        whitespace();
        parse_AnnotatedDecl();
      }
      lookahead1W(29);              // S^WS | '(:' | ';'
      whitespace();
      parse_Separator();
    }
    eventHandler.endNonterminal("Prolog", e0);
  }

  function parse_Separator()
  {
    eventHandler.startNonterminal("Separator", e0);
    shift(54);                      // ';'
    eventHandler.endNonterminal("Separator", e0);
  }

  function parse_Setter()
  {
    eventHandler.startNonterminal("Setter", e0);
    switch (l1)
    {
    case 109:                       // 'declare'
      lookahead2W(194);             // S^WS | '(:' | 'base-uri' | 'boundary-space' | 'construction' |
      break;
    default:
      lk = l1;
    }
    if (lk == 56429)                // 'declare' 'default'
    {
      lk = memoized(1, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_DefaultCollationDecl();
          lk = -2;
        }
        catch (p2A)
        {
          try
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            try_EmptyOrderDecl();
            lk = -6;
          }
          catch (p6A)
          {
            lk = -9;
          }
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(1, e0, lk);
      }
    }
    switch (lk)
    {
    case 44141:                     // 'declare' 'boundary-space'
      parse_BoundarySpaceDecl();
      break;
    case -2:
      parse_DefaultCollationDecl();
      break;
    case 43117:                     // 'declare' 'base-uri'
      parse_BaseURIDecl();
      break;
    case 50797:                     // 'declare' 'construction'
      parse_ConstructionDecl();
      break;
    case 106093:                    // 'declare' 'ordering'
      parse_OrderingModeDecl();
      break;
    case -6:
      parse_EmptyOrderDecl();
      break;
    case 115821:                    // 'declare' 'revalidation'
      parse_RevalidationDecl();
      break;
    case 53869:                     // 'declare' 'copy-namespaces'
      parse_CopyNamespacesDecl();
      break;
    default:
      parse_DecimalFormatDecl();
    }
    eventHandler.endNonterminal("Setter", e0);
  }

  function parse_BoundarySpaceDecl()
  {
    eventHandler.startNonterminal("BoundarySpaceDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(36);                // S^WS | '(:' | 'boundary-space'
    shift(86);                      // 'boundary-space'
    lookahead1W(137);               // S^WS | '(:' | 'preserve' | 'strip'
    switch (l1)
    {
    case 218:                       // 'preserve'
      shift(218);                   // 'preserve'
      break;
    default:
      shift(246);                   // 'strip'
    }
    eventHandler.endNonterminal("BoundarySpaceDecl", e0);
  }

  function parse_DefaultCollationDecl()
  {
    eventHandler.startNonterminal("DefaultCollationDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(49);                // S^WS | '(:' | 'default'
    shift(110);                     // 'default'
    lookahead1W(41);                // S^WS | '(:' | 'collation'
    shift(95);                      // 'collation'
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    eventHandler.endNonterminal("DefaultCollationDecl", e0);
  }

  function try_DefaultCollationDecl()
  {
    shiftT(109);                    // 'declare'
    lookahead1W(49);                // S^WS | '(:' | 'default'
    shiftT(110);                    // 'default'
    lookahead1W(41);                // S^WS | '(:' | 'collation'
    shiftT(95);                     // 'collation'
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shiftT(7);                      // URILiteral
  }

  function parse_BaseURIDecl()
  {
    eventHandler.startNonterminal("BaseURIDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(35);                // S^WS | '(:' | 'base-uri'
    shift(84);                      // 'base-uri'
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    eventHandler.endNonterminal("BaseURIDecl", e0);
  }

  function parse_ConstructionDecl()
  {
    eventHandler.startNonterminal("ConstructionDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(44);                // S^WS | '(:' | 'construction'
    shift(99);                      // 'construction'
    lookahead1W(137);               // S^WS | '(:' | 'preserve' | 'strip'
    switch (l1)
    {
    case 246:                       // 'strip'
      shift(246);                   // 'strip'
      break;
    default:
      shift(218);                   // 'preserve'
    }
    eventHandler.endNonterminal("ConstructionDecl", e0);
  }

  function parse_OrderingModeDecl()
  {
    eventHandler.startNonterminal("OrderingModeDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(71);                // S^WS | '(:' | 'ordering'
    shift(207);                     // 'ordering'
    lookahead1W(135);               // S^WS | '(:' | 'ordered' | 'unordered'
    switch (l1)
    {
    case 206:                       // 'ordered'
      shift(206);                   // 'ordered'
      break;
    default:
      shift(262);                   // 'unordered'
    }
    eventHandler.endNonterminal("OrderingModeDecl", e0);
  }

  function parse_EmptyOrderDecl()
  {
    eventHandler.startNonterminal("EmptyOrderDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(49);                // S^WS | '(:' | 'default'
    shift(110);                     // 'default'
    lookahead1W(70);                // S^WS | '(:' | 'order'
    shift(205);                     // 'order'
    lookahead1W(52);                // S^WS | '(:' | 'empty'
    shift(124);                     // 'empty'
    lookahead1W(125);               // S^WS | '(:' | 'greatest' | 'least'
    switch (l1)
    {
    case 149:                       // 'greatest'
      shift(149);                   // 'greatest'
      break;
    default:
      shift(176);                   // 'least'
    }
    eventHandler.endNonterminal("EmptyOrderDecl", e0);
  }

  function try_EmptyOrderDecl()
  {
    shiftT(109);                    // 'declare'
    lookahead1W(49);                // S^WS | '(:' | 'default'
    shiftT(110);                    // 'default'
    lookahead1W(70);                // S^WS | '(:' | 'order'
    shiftT(205);                    // 'order'
    lookahead1W(52);                // S^WS | '(:' | 'empty'
    shiftT(124);                    // 'empty'
    lookahead1W(125);               // S^WS | '(:' | 'greatest' | 'least'
    switch (l1)
    {
    case 149:                       // 'greatest'
      shiftT(149);                  // 'greatest'
      break;
    default:
      shiftT(176);                  // 'least'
    }
  }

  function parse_CopyNamespacesDecl()
  {
    eventHandler.startNonterminal("CopyNamespacesDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(47);                // S^WS | '(:' | 'copy-namespaces'
    shift(105);                     // 'copy-namespaces'
    lookahead1W(132);               // S^WS | '(:' | 'no-preserve' | 'preserve'
    whitespace();
    parse_PreserveMode();
    lookahead1W(25);                // S^WS | '(:' | ','
    shift(42);                      // ','
    lookahead1W(127);               // S^WS | '(:' | 'inherit' | 'no-inherit'
    whitespace();
    parse_InheritMode();
    eventHandler.endNonterminal("CopyNamespacesDecl", e0);
  }

  function parse_PreserveMode()
  {
    eventHandler.startNonterminal("PreserveMode", e0);
    switch (l1)
    {
    case 218:                       // 'preserve'
      shift(218);                   // 'preserve'
      break;
    default:
      shift(193);                   // 'no-preserve'
    }
    eventHandler.endNonterminal("PreserveMode", e0);
  }

  function parse_InheritMode()
  {
    eventHandler.startNonterminal("InheritMode", e0);
    switch (l1)
    {
    case 159:                       // 'inherit'
      shift(159);                   // 'inherit'
      break;
    default:
      shift(192);                   // 'no-inherit'
    }
    eventHandler.endNonterminal("InheritMode", e0);
  }

  function parse_DecimalFormatDecl()
  {
    eventHandler.startNonterminal("DecimalFormatDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(118);               // S^WS | '(:' | 'decimal-format' | 'default'
    switch (l1)
    {
    case 107:                       // 'decimal-format'
      shift(107);                   // 'decimal-format'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_EQName();
      break;
    default:
      shift(110);                   // 'default'
      lookahead1W(48);              // S^WS | '(:' | 'decimal-format'
      shift(107);                   // 'decimal-format'
    }
    for (;;)
    {
      lookahead1W(204);             // S^WS | '(:' | ';' | 'NaN' | 'decimal-separator' | 'digit' |
      if (l1 == 54)                 // ';'
      {
        break;
      }
      whitespace();
      parse_DFPropertyName();
      lookahead1W(30);              // S^WS | '(:' | '='
      shift(61);                    // '='
      lookahead1W(17);              // StringLiteral | S^WS | '(:'
      shift(11);                    // StringLiteral
    }
    eventHandler.endNonterminal("DecimalFormatDecl", e0);
  }

  function parse_DFPropertyName()
  {
    eventHandler.startNonterminal("DFPropertyName", e0);
    switch (l1)
    {
    case 108:                       // 'decimal-separator'
      shift(108);                   // 'decimal-separator'
      break;
    case 151:                       // 'grouping-separator'
      shift(151);                   // 'grouping-separator'
      break;
    case 158:                       // 'infinity'
      shift(158);                   // 'infinity'
      break;
    case 182:                       // 'minus-sign'
      shift(182);                   // 'minus-sign'
      break;
    case 68:                        // 'NaN'
      shift(68);                    // 'NaN'
      break;
    case 213:                       // 'percent'
      shift(213);                   // 'percent'
      break;
    case 212:                       // 'per-mille'
      shift(212);                   // 'per-mille'
      break;
    case 280:                       // 'zero-digit'
      shift(280);                   // 'zero-digit'
      break;
    case 117:                       // 'digit'
      shift(117);                   // 'digit'
      break;
    default:
      shift(211);                   // 'pattern-separator'
    }
    eventHandler.endNonterminal("DFPropertyName", e0);
  }

  function parse_Import()
  {
    eventHandler.startNonterminal("Import", e0);
    switch (l1)
    {
    case 155:                       // 'import'
      lookahead2W(130);             // S^WS | '(:' | 'module' | 'schema'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 117403:                    // 'import' 'schema'
      parse_SchemaImport();
      break;
    default:
      parse_ModuleImport();
    }
    eventHandler.endNonterminal("Import", e0);
  }

  function parse_SchemaImport()
  {
    eventHandler.startNonterminal("SchemaImport", e0);
    shift(155);                     // 'import'
    lookahead1W(76);                // S^WS | '(:' | 'schema'
    shift(229);                     // 'schema'
    lookahead1W(141);               // URILiteral | S^WS | '(:' | 'default' | 'namespace'
    if (l1 != 7)                    // URILiteral
    {
      whitespace();
      parse_SchemaPrefix();
    }
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    lookahead1W(112);               // S^WS | '(:' | ';' | 'at'
    if (l1 == 82)                   // 'at'
    {
      shift(82);                    // 'at'
      lookahead1W(15);              // URILiteral | S^WS | '(:'
      shift(7);                     // URILiteral
      for (;;)
      {
        lookahead1W(107);           // S^WS | '(:' | ',' | ';'
        if (l1 != 42)               // ','
        {
          break;
        }
        shift(42);                  // ','
        lookahead1W(15);            // URILiteral | S^WS | '(:'
        shift(7);                   // URILiteral
      }
    }
    eventHandler.endNonterminal("SchemaImport", e0);
  }

  function parse_SchemaPrefix()
  {
    eventHandler.startNonterminal("SchemaPrefix", e0);
    switch (l1)
    {
    case 187:                       // 'namespace'
      shift(187);                   // 'namespace'
      lookahead1W(240);             // NCName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_NCName();
      lookahead1W(30);              // S^WS | '(:' | '='
      shift(61);                    // '='
      break;
    default:
      shift(110);                   // 'default'
      lookahead1W(50);              // S^WS | '(:' | 'element'
      shift(122);                   // 'element'
      lookahead1W(64);              // S^WS | '(:' | 'namespace'
      shift(187);                   // 'namespace'
    }
    eventHandler.endNonterminal("SchemaPrefix", e0);
  }

  function parse_ModuleImport()
  {
    eventHandler.startNonterminal("ModuleImport", e0);
    shift(155);                     // 'import'
    lookahead1W(63);                // S^WS | '(:' | 'module'
    shift(185);                     // 'module'
    lookahead1W(93);                // URILiteral | S^WS | '(:' | 'namespace'
    if (l1 == 187)                  // 'namespace'
    {
      shift(187);                   // 'namespace'
      lookahead1W(240);             // NCName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_NCName();
      lookahead1W(30);              // S^WS | '(:' | '='
      shift(61);                    // '='
    }
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    lookahead1W(112);               // S^WS | '(:' | ';' | 'at'
    if (l1 == 82)                   // 'at'
    {
      shift(82);                    // 'at'
      lookahead1W(15);              // URILiteral | S^WS | '(:'
      shift(7);                     // URILiteral
      for (;;)
      {
        lookahead1W(107);           // S^WS | '(:' | ',' | ';'
        if (l1 != 42)               // ','
        {
          break;
        }
        shift(42);                  // ','
        lookahead1W(15);            // URILiteral | S^WS | '(:'
        shift(7);                   // URILiteral
      }
    }
    eventHandler.endNonterminal("ModuleImport", e0);
  }

  function parse_NamespaceDecl()
  {
    eventHandler.startNonterminal("NamespaceDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(64);                // S^WS | '(:' | 'namespace'
    shift(187);                     // 'namespace'
    lookahead1W(240);               // NCName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_NCName();
    lookahead1W(30);                // S^WS | '(:' | '='
    shift(61);                      // '='
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    eventHandler.endNonterminal("NamespaceDecl", e0);
  }

  function parse_DefaultNamespaceDecl()
  {
    eventHandler.startNonterminal("DefaultNamespaceDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(49);                // S^WS | '(:' | 'default'
    shift(110);                     // 'default'
    lookahead1W(119);               // S^WS | '(:' | 'element' | 'function'
    switch (l1)
    {
    case 122:                       // 'element'
      shift(122);                   // 'element'
      break;
    default:
      shift(147);                   // 'function'
    }
    lookahead1W(64);                // S^WS | '(:' | 'namespace'
    shift(187);                     // 'namespace'
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    eventHandler.endNonterminal("DefaultNamespaceDecl", e0);
  }

  function try_DefaultNamespaceDecl()
  {
    shiftT(109);                    // 'declare'
    lookahead1W(49);                // S^WS | '(:' | 'default'
    shiftT(110);                    // 'default'
    lookahead1W(119);               // S^WS | '(:' | 'element' | 'function'
    switch (l1)
    {
    case 122:                       // 'element'
      shiftT(122);                  // 'element'
      break;
    default:
      shiftT(147);                  // 'function'
    }
    lookahead1W(64);                // S^WS | '(:' | 'namespace'
    shiftT(187);                    // 'namespace'
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shiftT(7);                      // URILiteral
  }

  function parse_FTOptionDecl()
  {
    eventHandler.startNonterminal("FTOptionDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(55);                // S^WS | '(:' | 'ft-option'
    shift(143);                     // 'ft-option'
    lookahead1W(84);                // S^WS | '(:' | 'using'
    whitespace();
    parse_FTMatchOptions();
    eventHandler.endNonterminal("FTOptionDecl", e0);
  }

  function parse_AnnotatedDecl()
  {
    eventHandler.startNonterminal("AnnotatedDecl", e0);
    shift(109);                     // 'declare'
    for (;;)
    {
      lookahead1W(192);             // S^WS | '%' | '(:' | 'collection' | 'function' | 'index' | 'integrity' |
      if (l1 != 33                  // '%'
       && l1 != 263)                // 'updating'
      {
        break;
      }
      switch (l1)
      {
      case 263:                     // 'updating'
        whitespace();
        parse_CompatibilityAnnotation();
        break;
      default:
        whitespace();
        parse_Annotation();
      }
    }
    switch (l1)
    {
    case 268:                       // 'variable'
      whitespace();
      parse_VarDecl();
      break;
    case 147:                       // 'function'
      whitespace();
      parse_FunctionDecl();
      break;
    case 96:                        // 'collection'
      whitespace();
      parse_CollectionDecl();
      break;
    case 157:                       // 'index'
      whitespace();
      parse_IndexDecl();
      break;
    default:
      whitespace();
      parse_ICDecl();
    }
    eventHandler.endNonterminal("AnnotatedDecl", e0);
  }

  function parse_CompatibilityAnnotation()
  {
    eventHandler.startNonterminal("CompatibilityAnnotation", e0);
    shift(263);                     // 'updating'
    eventHandler.endNonterminal("CompatibilityAnnotation", e0);
  }

  function parse_Annotation()
  {
    eventHandler.startNonterminal("Annotation", e0);
    shift(33);                      // '%'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_EQName();
    lookahead1W(193);               // S^WS | '%' | '(' | '(:' | 'collection' | 'function' | 'index' | 'integrity' |
    if (l1 == 35)                   // '('
    {
      shift(35);                    // '('
      lookahead1W(190);             // IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral | S^WS | '(:' |
      whitespace();
      parse_Literal();
      for (;;)
      {
        lookahead1W(105);           // S^WS | '(:' | ')' | ','
        if (l1 != 42)               // ','
        {
          break;
        }
        shift(42);                  // ','
        lookahead1W(190);           // IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral | S^WS | '(:' |
        whitespace();
        parse_Literal();
      }
      shift(38);                    // ')'
    }
    eventHandler.endNonterminal("Annotation", e0);
  }

  function try_Annotation()
  {
    shiftT(33);                     // '%'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_EQName();
    lookahead1W(193);               // S^WS | '%' | '(' | '(:' | 'collection' | 'function' | 'index' | 'integrity' |
    if (l1 == 35)                   // '('
    {
      shiftT(35);                   // '('
      lookahead1W(190);             // IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral | S^WS | '(:' |
      try_Literal();
      for (;;)
      {
        lookahead1W(105);           // S^WS | '(:' | ')' | ','
        if (l1 != 42)               // ','
        {
          break;
        }
        shiftT(42);                 // ','
        lookahead1W(190);           // IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral | S^WS | '(:' |
        try_Literal();
      }
      shiftT(38);                   // ')'
    }
  }

  function parse_VarDecl()
  {
    eventHandler.startNonterminal("VarDecl", e0);
    shift(268);                     // 'variable'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    lookahead1W(157);               // S^WS | '(:' | ':=' | 'as' | 'external'
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_TypeDeclaration();
    }
    lookahead1W(110);               // S^WS | '(:' | ':=' | 'external'
    switch (l1)
    {
    case 53:                        // ':='
      shift(53);                    // ':='
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_VarValue();
      break;
    default:
      shift(134);                   // 'external'
      lookahead1W(108);             // S^WS | '(:' | ':=' | ';'
      if (l1 == 53)                 // ':='
      {
        shift(53);                  // ':='
        lookahead1W(267);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        whitespace();
        parse_VarDefaultValue();
      }
    }
    eventHandler.endNonterminal("VarDecl", e0);
  }

  function parse_VarValue()
  {
    eventHandler.startNonterminal("VarValue", e0);
    parse_ExprSingle();
    eventHandler.endNonterminal("VarValue", e0);
  }

  function parse_VarDefaultValue()
  {
    eventHandler.startNonterminal("VarDefaultValue", e0);
    parse_ExprSingle();
    eventHandler.endNonterminal("VarDefaultValue", e0);
  }

  function parse_ContextItemDecl()
  {
    eventHandler.startNonterminal("ContextItemDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(46);                // S^WS | '(:' | 'context'
    shift(102);                     // 'context'
    lookahead1W(58);                // S^WS | '(:' | 'item'
    shift(167);                     // 'item'
    lookahead1W(157);               // S^WS | '(:' | ':=' | 'as' | 'external'
    if (l1 == 80)                   // 'as'
    {
      shift(80);                    // 'as'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_ItemType();
    }
    lookahead1W(110);               // S^WS | '(:' | ':=' | 'external'
    switch (l1)
    {
    case 53:                        // ':='
      shift(53);                    // ':='
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_VarValue();
      break;
    default:
      shift(134);                   // 'external'
      lookahead1W(108);             // S^WS | '(:' | ':=' | ';'
      if (l1 == 53)                 // ':='
      {
        shift(53);                  // ':='
        lookahead1W(267);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        whitespace();
        parse_VarDefaultValue();
      }
    }
    eventHandler.endNonterminal("ContextItemDecl", e0);
  }

  function parse_ParamList()
  {
    eventHandler.startNonterminal("ParamList", e0);
    parse_Param();
    for (;;)
    {
      lookahead1W(105);             // S^WS | '(:' | ')' | ','
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      whitespace();
      parse_Param();
    }
    eventHandler.endNonterminal("ParamList", e0);
  }

  function try_ParamList()
  {
    try_Param();
    for (;;)
    {
      lookahead1W(105);             // S^WS | '(:' | ')' | ','
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      try_Param();
    }
  }

  function parse_Param()
  {
    eventHandler.startNonterminal("Param", e0);
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_EQName();
    lookahead1W(153);               // S^WS | '(:' | ')' | ',' | 'as'
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_TypeDeclaration();
    }
    eventHandler.endNonterminal("Param", e0);
  }

  function try_Param()
  {
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_EQName();
    lookahead1W(153);               // S^WS | '(:' | ')' | ',' | 'as'
    if (l1 == 80)                   // 'as'
    {
      try_TypeDeclaration();
    }
  }

  function parse_FunctionBody()
  {
    eventHandler.startNonterminal("FunctionBody", e0);
    parse_EnclosedExpr();
    eventHandler.endNonterminal("FunctionBody", e0);
  }

  function try_FunctionBody()
  {
    try_EnclosedExpr();
  }

  function parse_EnclosedExpr()
  {
    eventHandler.startNonterminal("EnclosedExpr", e0);
    shift(281);                     // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(287);                     // '}'
    eventHandler.endNonterminal("EnclosedExpr", e0);
  }

  function try_EnclosedExpr()
  {
    shiftT(281);                    // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(287);                    // '}'
  }

  function parse_OptionDecl()
  {
    eventHandler.startNonterminal("OptionDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(69);                // S^WS | '(:' | 'option'
    shift(203);                     // 'option'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_EQName();
    lookahead1W(17);                // StringLiteral | S^WS | '(:'
    shift(11);                      // StringLiteral
    eventHandler.endNonterminal("OptionDecl", e0);
  }

  function parse_Expr()
  {
    eventHandler.startNonterminal("Expr", e0);
    parse_ExprSingle();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_ExprSingle();
    }
    eventHandler.endNonterminal("Expr", e0);
  }

  function try_Expr()
  {
    try_ExprSingle();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_ExprSingle();
    }
  }

  function parse_FLWORExpr()
  {
    eventHandler.startNonterminal("FLWORExpr", e0);
    parse_InitialClause();
    for (;;)
    {
      lookahead1W(195);             // S^WS | '(:' | 'count' | 'for' | 'group' | 'let' | 'order' | 'return' | 'stable' |
      if (l1 == 224)                // 'return'
      {
        break;
      }
      whitespace();
      parse_IntermediateClause();
    }
    whitespace();
    parse_ReturnClause();
    eventHandler.endNonterminal("FLWORExpr", e0);
  }

  function try_FLWORExpr()
  {
    try_InitialClause();
    for (;;)
    {
      lookahead1W(195);             // S^WS | '(:' | 'count' | 'for' | 'group' | 'let' | 'order' | 'return' | 'stable' |
      if (l1 == 224)                // 'return'
      {
        break;
      }
      try_IntermediateClause();
    }
    try_ReturnClause();
  }

  function parse_InitialClause()
  {
    eventHandler.startNonterminal("InitialClause", e0);
    switch (l1)
    {
    case 139:                       // 'for'
      lookahead2W(151);             // S^WS | '$' | '(:' | 'sliding' | 'tumbling'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 16011:                     // 'for' '$'
      parse_ForClause();
      break;
    case 177:                       // 'let'
      parse_LetClause();
      break;
    default:
      parse_WindowClause();
    }
    eventHandler.endNonterminal("InitialClause", e0);
  }

  function try_InitialClause()
  {
    switch (l1)
    {
    case 139:                       // 'for'
      lookahead2W(151);             // S^WS | '$' | '(:' | 'sliding' | 'tumbling'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 16011:                     // 'for' '$'
      try_ForClause();
      break;
    case 177:                       // 'let'
      try_LetClause();
      break;
    default:
      try_WindowClause();
    }
  }

  function parse_IntermediateClause()
  {
    eventHandler.startNonterminal("IntermediateClause", e0);
    switch (l1)
    {
    case 139:                       // 'for'
    case 177:                       // 'let'
      parse_InitialClause();
      break;
    case 272:                       // 'where'
      parse_WhereClause();
      break;
    case 150:                       // 'group'
      parse_GroupByClause();
      break;
    case 106:                       // 'count'
      parse_CountClause();
      break;
    default:
      parse_OrderByClause();
    }
    eventHandler.endNonterminal("IntermediateClause", e0);
  }

  function try_IntermediateClause()
  {
    switch (l1)
    {
    case 139:                       // 'for'
    case 177:                       // 'let'
      try_InitialClause();
      break;
    case 272:                       // 'where'
      try_WhereClause();
      break;
    case 150:                       // 'group'
      try_GroupByClause();
      break;
    case 106:                       // 'count'
      try_CountClause();
      break;
    default:
      try_OrderByClause();
    }
  }

  function parse_ForClause()
  {
    eventHandler.startNonterminal("ForClause", e0);
    shift(139);                     // 'for'
    lookahead1W(21);                // S^WS | '$' | '(:'
    whitespace();
    parse_ForBinding();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      whitespace();
      parse_ForBinding();
    }
    eventHandler.endNonterminal("ForClause", e0);
  }

  function try_ForClause()
  {
    shiftT(139);                    // 'for'
    lookahead1W(21);                // S^WS | '$' | '(:'
    try_ForBinding();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      try_ForBinding();
    }
  }

  function parse_ForBinding()
  {
    eventHandler.startNonterminal("ForBinding", e0);
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    lookahead1W(182);               // S^WS | '(:' | 'allowing' | 'as' | 'at' | 'in' | 'score'
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_TypeDeclaration();
    }
    lookahead1W(173);               // S^WS | '(:' | 'allowing' | 'at' | 'in' | 'score'
    if (l1 == 73)                   // 'allowing'
    {
      whitespace();
      parse_AllowingEmpty();
    }
    lookahead1W(160);               // S^WS | '(:' | 'at' | 'in' | 'score'
    if (l1 == 82)                   // 'at'
    {
      whitespace();
      parse_PositionalVar();
    }
    lookahead1W(126);               // S^WS | '(:' | 'in' | 'score'
    if (l1 == 232)                  // 'score'
    {
      whitespace();
      parse_FTScoreVar();
    }
    lookahead1W(56);                // S^WS | '(:' | 'in'
    shift(156);                     // 'in'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("ForBinding", e0);
  }

  function try_ForBinding()
  {
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
    lookahead1W(182);               // S^WS | '(:' | 'allowing' | 'as' | 'at' | 'in' | 'score'
    if (l1 == 80)                   // 'as'
    {
      try_TypeDeclaration();
    }
    lookahead1W(173);               // S^WS | '(:' | 'allowing' | 'at' | 'in' | 'score'
    if (l1 == 73)                   // 'allowing'
    {
      try_AllowingEmpty();
    }
    lookahead1W(160);               // S^WS | '(:' | 'at' | 'in' | 'score'
    if (l1 == 82)                   // 'at'
    {
      try_PositionalVar();
    }
    lookahead1W(126);               // S^WS | '(:' | 'in' | 'score'
    if (l1 == 232)                  // 'score'
    {
      try_FTScoreVar();
    }
    lookahead1W(56);                // S^WS | '(:' | 'in'
    shiftT(156);                    // 'in'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_AllowingEmpty()
  {
    eventHandler.startNonterminal("AllowingEmpty", e0);
    shift(73);                      // 'allowing'
    lookahead1W(52);                // S^WS | '(:' | 'empty'
    shift(124);                     // 'empty'
    eventHandler.endNonterminal("AllowingEmpty", e0);
  }

  function try_AllowingEmpty()
  {
    shiftT(73);                     // 'allowing'
    lookahead1W(52);                // S^WS | '(:' | 'empty'
    shiftT(124);                    // 'empty'
  }

  function parse_PositionalVar()
  {
    eventHandler.startNonterminal("PositionalVar", e0);
    shift(82);                      // 'at'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    eventHandler.endNonterminal("PositionalVar", e0);
  }

  function try_PositionalVar()
  {
    shiftT(82);                     // 'at'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
  }

  function parse_FTScoreVar()
  {
    eventHandler.startNonterminal("FTScoreVar", e0);
    shift(232);                     // 'score'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    eventHandler.endNonterminal("FTScoreVar", e0);
  }

  function try_FTScoreVar()
  {
    shiftT(232);                    // 'score'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
  }

  function parse_LetClause()
  {
    eventHandler.startNonterminal("LetClause", e0);
    shift(177);                     // 'let'
    lookahead1W(100);               // S^WS | '$' | '(:' | 'score'
    whitespace();
    parse_LetBinding();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(100);             // S^WS | '$' | '(:' | 'score'
      whitespace();
      parse_LetBinding();
    }
    eventHandler.endNonterminal("LetClause", e0);
  }

  function try_LetClause()
  {
    shiftT(177);                    // 'let'
    lookahead1W(100);               // S^WS | '$' | '(:' | 'score'
    try_LetBinding();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(100);             // S^WS | '$' | '(:' | 'score'
      try_LetBinding();
    }
  }

  function parse_LetBinding()
  {
    eventHandler.startNonterminal("LetBinding", e0);
    switch (l1)
    {
    case 31:                        // '$'
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_VarName();
      lookahead1W(109);             // S^WS | '(:' | ':=' | 'as'
      if (l1 == 80)                 // 'as'
      {
        whitespace();
        parse_TypeDeclaration();
      }
      break;
    default:
      parse_FTScoreVar();
    }
    lookahead1W(28);                // S^WS | '(:' | ':='
    shift(53);                      // ':='
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("LetBinding", e0);
  }

  function try_LetBinding()
  {
    switch (l1)
    {
    case 31:                        // '$'
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_VarName();
      lookahead1W(109);             // S^WS | '(:' | ':=' | 'as'
      if (l1 == 80)                 // 'as'
      {
        try_TypeDeclaration();
      }
      break;
    default:
      try_FTScoreVar();
    }
    lookahead1W(28);                // S^WS | '(:' | ':='
    shiftT(53);                     // ':='
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_WindowClause()
  {
    eventHandler.startNonterminal("WindowClause", e0);
    shift(139);                     // 'for'
    lookahead1W(139);               // S^WS | '(:' | 'sliding' | 'tumbling'
    switch (l1)
    {
    case 257:                       // 'tumbling'
      whitespace();
      parse_TumblingWindowClause();
      break;
    default:
      whitespace();
      parse_SlidingWindowClause();
    }
    eventHandler.endNonterminal("WindowClause", e0);
  }

  function try_WindowClause()
  {
    shiftT(139);                    // 'for'
    lookahead1W(139);               // S^WS | '(:' | 'sliding' | 'tumbling'
    switch (l1)
    {
    case 257:                       // 'tumbling'
      try_TumblingWindowClause();
      break;
    default:
      try_SlidingWindowClause();
    }
  }

  function parse_TumblingWindowClause()
  {
    eventHandler.startNonterminal("TumblingWindowClause", e0);
    shift(257);                     // 'tumbling'
    lookahead1W(88);                // S^WS | '(:' | 'window'
    shift(275);                     // 'window'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    lookahead1W(114);               // S^WS | '(:' | 'as' | 'in'
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_TypeDeclaration();
    }
    lookahead1W(56);                // S^WS | '(:' | 'in'
    shift(156);                     // 'in'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    whitespace();
    parse_WindowStartCondition();
    if (l1 == 127                   // 'end'
     || l1 == 202)                  // 'only'
    {
      whitespace();
      parse_WindowEndCondition();
    }
    eventHandler.endNonterminal("TumblingWindowClause", e0);
  }

  function try_TumblingWindowClause()
  {
    shiftT(257);                    // 'tumbling'
    lookahead1W(88);                // S^WS | '(:' | 'window'
    shiftT(275);                    // 'window'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
    lookahead1W(114);               // S^WS | '(:' | 'as' | 'in'
    if (l1 == 80)                   // 'as'
    {
      try_TypeDeclaration();
    }
    lookahead1W(56);                // S^WS | '(:' | 'in'
    shiftT(156);                    // 'in'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
    try_WindowStartCondition();
    if (l1 == 127                   // 'end'
     || l1 == 202)                  // 'only'
    {
      try_WindowEndCondition();
    }
  }

  function parse_SlidingWindowClause()
  {
    eventHandler.startNonterminal("SlidingWindowClause", e0);
    shift(239);                     // 'sliding'
    lookahead1W(88);                // S^WS | '(:' | 'window'
    shift(275);                     // 'window'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    lookahead1W(114);               // S^WS | '(:' | 'as' | 'in'
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_TypeDeclaration();
    }
    lookahead1W(56);                // S^WS | '(:' | 'in'
    shift(156);                     // 'in'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    whitespace();
    parse_WindowStartCondition();
    whitespace();
    parse_WindowEndCondition();
    eventHandler.endNonterminal("SlidingWindowClause", e0);
  }

  function try_SlidingWindowClause()
  {
    shiftT(239);                    // 'sliding'
    lookahead1W(88);                // S^WS | '(:' | 'window'
    shiftT(275);                    // 'window'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
    lookahead1W(114);               // S^WS | '(:' | 'as' | 'in'
    if (l1 == 80)                   // 'as'
    {
      try_TypeDeclaration();
    }
    lookahead1W(56);                // S^WS | '(:' | 'in'
    shiftT(156);                    // 'in'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
    try_WindowStartCondition();
    try_WindowEndCondition();
  }

  function parse_WindowStartCondition()
  {
    eventHandler.startNonterminal("WindowStartCondition", e0);
    shift(242);                     // 'start'
    lookahead1W(181);               // S^WS | '$' | '(:' | 'at' | 'next' | 'previous' | 'when'
    whitespace();
    parse_WindowVars();
    lookahead1W(86);                // S^WS | '(:' | 'when'
    shift(271);                     // 'when'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("WindowStartCondition", e0);
  }

  function try_WindowStartCondition()
  {
    shiftT(242);                    // 'start'
    lookahead1W(181);               // S^WS | '$' | '(:' | 'at' | 'next' | 'previous' | 'when'
    try_WindowVars();
    lookahead1W(86);                // S^WS | '(:' | 'when'
    shiftT(271);                    // 'when'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_WindowEndCondition()
  {
    eventHandler.startNonterminal("WindowEndCondition", e0);
    if (l1 == 202)                  // 'only'
    {
      shift(202);                   // 'only'
    }
    lookahead1W(53);                // S^WS | '(:' | 'end'
    shift(127);                     // 'end'
    lookahead1W(181);               // S^WS | '$' | '(:' | 'at' | 'next' | 'previous' | 'when'
    whitespace();
    parse_WindowVars();
    lookahead1W(86);                // S^WS | '(:' | 'when'
    shift(271);                     // 'when'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("WindowEndCondition", e0);
  }

  function try_WindowEndCondition()
  {
    if (l1 == 202)                  // 'only'
    {
      shiftT(202);                  // 'only'
    }
    lookahead1W(53);                // S^WS | '(:' | 'end'
    shiftT(127);                    // 'end'
    lookahead1W(181);               // S^WS | '$' | '(:' | 'at' | 'next' | 'previous' | 'when'
    try_WindowVars();
    lookahead1W(86);                // S^WS | '(:' | 'when'
    shiftT(271);                    // 'when'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_WindowVars()
  {
    eventHandler.startNonterminal("WindowVars", e0);
    if (l1 == 31)                   // '$'
    {
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_CurrentItem();
    }
    lookahead1W(174);               // S^WS | '(:' | 'at' | 'next' | 'previous' | 'when'
    if (l1 == 82)                   // 'at'
    {
      whitespace();
      parse_PositionalVar();
    }
    lookahead1W(163);               // S^WS | '(:' | 'next' | 'previous' | 'when'
    if (l1 == 219)                  // 'previous'
    {
      shift(219);                   // 'previous'
      lookahead1W(21);              // S^WS | '$' | '(:'
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_PreviousItem();
    }
    lookahead1W(131);               // S^WS | '(:' | 'next' | 'when'
    if (l1 == 190)                  // 'next'
    {
      shift(190);                   // 'next'
      lookahead1W(21);              // S^WS | '$' | '(:'
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_NextItem();
    }
    eventHandler.endNonterminal("WindowVars", e0);
  }

  function try_WindowVars()
  {
    if (l1 == 31)                   // '$'
    {
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_CurrentItem();
    }
    lookahead1W(174);               // S^WS | '(:' | 'at' | 'next' | 'previous' | 'when'
    if (l1 == 82)                   // 'at'
    {
      try_PositionalVar();
    }
    lookahead1W(163);               // S^WS | '(:' | 'next' | 'previous' | 'when'
    if (l1 == 219)                  // 'previous'
    {
      shiftT(219);                  // 'previous'
      lookahead1W(21);              // S^WS | '$' | '(:'
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_PreviousItem();
    }
    lookahead1W(131);               // S^WS | '(:' | 'next' | 'when'
    if (l1 == 190)                  // 'next'
    {
      shiftT(190);                  // 'next'
      lookahead1W(21);              // S^WS | '$' | '(:'
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_NextItem();
    }
  }

  function parse_CurrentItem()
  {
    eventHandler.startNonterminal("CurrentItem", e0);
    parse_EQName();
    eventHandler.endNonterminal("CurrentItem", e0);
  }

  function try_CurrentItem()
  {
    try_EQName();
  }

  function parse_PreviousItem()
  {
    eventHandler.startNonterminal("PreviousItem", e0);
    parse_EQName();
    eventHandler.endNonterminal("PreviousItem", e0);
  }

  function try_PreviousItem()
  {
    try_EQName();
  }

  function parse_NextItem()
  {
    eventHandler.startNonterminal("NextItem", e0);
    parse_EQName();
    eventHandler.endNonterminal("NextItem", e0);
  }

  function try_NextItem()
  {
    try_EQName();
  }

  function parse_CountClause()
  {
    eventHandler.startNonterminal("CountClause", e0);
    shift(106);                     // 'count'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    eventHandler.endNonterminal("CountClause", e0);
  }

  function try_CountClause()
  {
    shiftT(106);                    // 'count'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
  }

  function parse_WhereClause()
  {
    eventHandler.startNonterminal("WhereClause", e0);
    shift(272);                     // 'where'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("WhereClause", e0);
  }

  function try_WhereClause()
  {
    shiftT(272);                    // 'where'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_GroupByClause()
  {
    eventHandler.startNonterminal("GroupByClause", e0);
    shift(150);                     // 'group'
    lookahead1W(37);                // S^WS | '(:' | 'by'
    shift(88);                      // 'by'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_GroupingSpecList();
    eventHandler.endNonterminal("GroupByClause", e0);
  }

  function try_GroupByClause()
  {
    shiftT(150);                    // 'group'
    lookahead1W(37);                // S^WS | '(:' | 'by'
    shiftT(88);                     // 'by'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_GroupingSpecList();
  }

  function parse_GroupingSpecList()
  {
    eventHandler.startNonterminal("GroupingSpecList", e0);
    parse_GroupingSpec();
    for (;;)
    {
      lookahead1W(198);             // S^WS | '(:' | ',' | 'count' | 'for' | 'group' | 'let' | 'order' | 'return' |
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_GroupingSpec();
    }
    eventHandler.endNonterminal("GroupingSpecList", e0);
  }

  function try_GroupingSpecList()
  {
    try_GroupingSpec();
    for (;;)
    {
      lookahead1W(198);             // S^WS | '(:' | ',' | 'count' | 'for' | 'group' | 'let' | 'order' | 'return' |
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_GroupingSpec();
    }
  }

  function parse_GroupingSpec()
  {
    eventHandler.startNonterminal("GroupingSpec", e0);
    switch (l1)
    {
    case 31:                        // '$'
      lookahead2W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      break;
    default:
      lk = l1;
    }
    if (lk == 3103                  // '$' EQName^Token
     || lk == 36383                 // '$' 'after'
     || lk == 37407                 // '$' 'allowing'
     || lk == 37919                 // '$' 'ancestor'
     || lk == 38431                 // '$' 'ancestor-or-self'
     || lk == 38943                 // '$' 'and'
     || lk == 39967                 // '$' 'append'
     || lk == 40479                 // '$' 'array'
     || lk == 40991                 // '$' 'as'
     || lk == 41503                 // '$' 'ascending'
     || lk == 42015                 // '$' 'at'
     || lk == 42527                 // '$' 'attribute'
     || lk == 43039                 // '$' 'base-uri'
     || lk == 43551                 // '$' 'before'
     || lk == 44063                 // '$' 'boundary-space'
     || lk == 44575                 // '$' 'break'
     || lk == 45599                 // '$' 'case'
     || lk == 46111                 // '$' 'cast'
     || lk == 46623                 // '$' 'castable'
     || lk == 47135                 // '$' 'catch'
     || lk == 48159                 // '$' 'child'
     || lk == 48671                 // '$' 'collation'
     || lk == 49695                 // '$' 'comment'
     || lk == 50207                 // '$' 'constraint'
     || lk == 50719                 // '$' 'construction'
     || lk == 52255                 // '$' 'context'
     || lk == 52767                 // '$' 'continue'
     || lk == 53279                 // '$' 'copy'
     || lk == 53791                 // '$' 'copy-namespaces'
     || lk == 54303                 // '$' 'count'
     || lk == 54815                 // '$' 'decimal-format'
     || lk == 55839                 // '$' 'declare'
     || lk == 56351                 // '$' 'default'
     || lk == 56863                 // '$' 'delete'
     || lk == 57375                 // '$' 'descendant'
     || lk == 57887                 // '$' 'descendant-or-self'
     || lk == 58399                 // '$' 'descending'
     || lk == 60959                 // '$' 'div'
     || lk == 61471                 // '$' 'document'
     || lk == 61983                 // '$' 'document-node'
     || lk == 62495                 // '$' 'element'
     || lk == 63007                 // '$' 'else'
     || lk == 63519                 // '$' 'empty'
     || lk == 64031                 // '$' 'empty-sequence'
     || lk == 64543                 // '$' 'encoding'
     || lk == 65055                 // '$' 'end'
     || lk == 66079                 // '$' 'eq'
     || lk == 66591                 // '$' 'every'
     || lk == 67615                 // '$' 'except'
     || lk == 68127                 // '$' 'exit'
     || lk == 68639                 // '$' 'external'
     || lk == 69151                 // '$' 'false'
     || lk == 69663                 // '$' 'first'
     || lk == 70175                 // '$' 'following'
     || lk == 70687                 // '$' 'following-sibling'
     || lk == 71199                 // '$' 'for'
     || lk == 72735                 // '$' 'from'
     || lk == 73247                 // '$' 'ft-option'
     || lk == 75295                 // '$' 'function'
     || lk == 75807                 // '$' 'ge'
     || lk == 76831                 // '$' 'group'
     || lk == 77855                 // '$' 'gt'
     || lk == 78367                 // '$' 'idiv'
     || lk == 78879                 // '$' 'if'
     || lk == 79391                 // '$' 'import'
     || lk == 79903                 // '$' 'in'
     || lk == 80415                 // '$' 'index'
     || lk == 82463                 // '$' 'insert'
     || lk == 82975                 // '$' 'instance'
     || lk == 83487                 // '$' 'integrity'
     || lk == 83999                 // '$' 'intersect'
     || lk == 84511                 // '$' 'into'
     || lk == 85023                 // '$' 'is'
     || lk == 85535                 // '$' 'item'
     || lk == 86047                 // '$' 'json'
     || lk == 86559                 // '$' 'json-item'
     || lk == 87071                 // '$' 'jsoniq'
     || lk == 88607                 // '$' 'last'
     || lk == 89119                 // '$' 'lax'
     || lk == 89631                 // '$' 'le'
     || lk == 90655                 // '$' 'let'
     || lk == 91679                 // '$' 'loop'
     || lk == 92703                 // '$' 'lt'
     || lk == 93727                 // '$' 'mod'
     || lk == 94239                 // '$' 'modify'
     || lk == 94751                 // '$' 'module'
     || lk == 95775                 // '$' 'namespace'
     || lk == 96287                 // '$' 'namespace-node'
     || lk == 96799                 // '$' 'ne'
     || lk == 99359                 // '$' 'node'
     || lk == 99871                 // '$' 'nodes'
     || lk == 100895                // '$' 'null'
     || lk == 101407                // '$' 'object'
     || lk == 103455                // '$' 'only'
     || lk == 103967                // '$' 'option'
     || lk == 104479                // '$' 'or'
     || lk == 104991                // '$' 'order'
     || lk == 105503                // '$' 'ordered'
     || lk == 106015                // '$' 'ordering'
     || lk == 107551                // '$' 'parent'
     || lk == 110623                // '$' 'preceding'
     || lk == 111135                // '$' 'preceding-sibling'
     || lk == 112671                // '$' 'processing-instruction'
     || lk == 113695                // '$' 'rename'
     || lk == 114207                // '$' 'replace'
     || lk == 114719                // '$' 'return'
     || lk == 115231                // '$' 'returning'
     || lk == 115743                // '$' 'revalidation'
     || lk == 116767                // '$' 'satisfies'
     || lk == 117279                // '$' 'schema'
     || lk == 117791                // '$' 'schema-attribute'
     || lk == 118303                // '$' 'schema-element'
     || lk == 118815                // '$' 'score'
     || lk == 119327                // '$' 'select'
     || lk == 119839                // '$' 'self'
     || lk == 122399                // '$' 'sliding'
     || lk == 122911                // '$' 'some'
     || lk == 123423                // '$' 'stable'
     || lk == 123935                // '$' 'start'
     || lk == 125471                // '$' 'strict'
     || lk == 126495                // '$' 'structured-item'
     || lk == 127007                // '$' 'switch'
     || lk == 127519                // '$' 'text'
     || lk == 129567                // '$' 'to'
     || lk == 130079                // '$' 'treat'
     || lk == 130591                // '$' 'true'
     || lk == 131103                // '$' 'try'
     || lk == 131615                // '$' 'tumbling'
     || lk == 132127                // '$' 'type'
     || lk == 132639                // '$' 'typeswitch'
     || lk == 133151                // '$' 'union'
     || lk == 134175                // '$' 'unordered'
     || lk == 134687                // '$' 'updating'
     || lk == 136223                // '$' 'validate'
     || lk == 136735                // '$' 'value'
     || lk == 137247                // '$' 'variable'
     || lk == 137759                // '$' 'version'
     || lk == 139295                // '$' 'where'
     || lk == 139807                // '$' 'while'
     || lk == 141343)               // '$' 'with'
    {
      lk = memoized(2, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_GroupingVariable();
          lookahead1W(206);         // S^WS | '(:' | ',' | ':=' | 'as' | 'collation' | 'count' | 'for' | 'group' |
          if (l1 == 53              // ':='
           || l1 == 80)             // 'as'
          {
            if (l1 == 80)           // 'as'
            {
              try_TypeDeclaration();
            }
            lookahead1W(28);        // S^WS | '(:' | ':='
            shiftT(53);             // ':='
            lookahead1W(267);       // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
            try_ExprSingle();
          }
          if (l1 == 95)             // 'collation'
          {
            shiftT(95);             // 'collation'
            lookahead1W(15);        // URILiteral | S^WS | '(:'
            shiftT(7);              // URILiteral
          }
          lk = -1;
        }
        catch (p1A)
        {
          lk = -2;
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(2, e0, lk);
      }
    }
    switch (lk)
    {
    case -1:
      parse_GroupingVariable();
      lookahead1W(206);             // S^WS | '(:' | ',' | ':=' | 'as' | 'collation' | 'count' | 'for' | 'group' |
      if (l1 == 53                  // ':='
       || l1 == 80)                 // 'as'
      {
        if (l1 == 80)               // 'as'
        {
          whitespace();
          parse_TypeDeclaration();
        }
        lookahead1W(28);            // S^WS | '(:' | ':='
        shift(53);                  // ':='
        lookahead1W(267);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        whitespace();
        parse_ExprSingle();
      }
      if (l1 == 95)                 // 'collation'
      {
        shift(95);                  // 'collation'
        lookahead1W(15);            // URILiteral | S^WS | '(:'
        shift(7);                   // URILiteral
      }
      break;
    default:
      parse_ExprSingle();
    }
    eventHandler.endNonterminal("GroupingSpec", e0);
  }

  function try_GroupingSpec()
  {
    switch (l1)
    {
    case 31:                        // '$'
      lookahead2W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      break;
    default:
      lk = l1;
    }
    if (lk == 3103                  // '$' EQName^Token
     || lk == 36383                 // '$' 'after'
     || lk == 37407                 // '$' 'allowing'
     || lk == 37919                 // '$' 'ancestor'
     || lk == 38431                 // '$' 'ancestor-or-self'
     || lk == 38943                 // '$' 'and'
     || lk == 39967                 // '$' 'append'
     || lk == 40479                 // '$' 'array'
     || lk == 40991                 // '$' 'as'
     || lk == 41503                 // '$' 'ascending'
     || lk == 42015                 // '$' 'at'
     || lk == 42527                 // '$' 'attribute'
     || lk == 43039                 // '$' 'base-uri'
     || lk == 43551                 // '$' 'before'
     || lk == 44063                 // '$' 'boundary-space'
     || lk == 44575                 // '$' 'break'
     || lk == 45599                 // '$' 'case'
     || lk == 46111                 // '$' 'cast'
     || lk == 46623                 // '$' 'castable'
     || lk == 47135                 // '$' 'catch'
     || lk == 48159                 // '$' 'child'
     || lk == 48671                 // '$' 'collation'
     || lk == 49695                 // '$' 'comment'
     || lk == 50207                 // '$' 'constraint'
     || lk == 50719                 // '$' 'construction'
     || lk == 52255                 // '$' 'context'
     || lk == 52767                 // '$' 'continue'
     || lk == 53279                 // '$' 'copy'
     || lk == 53791                 // '$' 'copy-namespaces'
     || lk == 54303                 // '$' 'count'
     || lk == 54815                 // '$' 'decimal-format'
     || lk == 55839                 // '$' 'declare'
     || lk == 56351                 // '$' 'default'
     || lk == 56863                 // '$' 'delete'
     || lk == 57375                 // '$' 'descendant'
     || lk == 57887                 // '$' 'descendant-or-self'
     || lk == 58399                 // '$' 'descending'
     || lk == 60959                 // '$' 'div'
     || lk == 61471                 // '$' 'document'
     || lk == 61983                 // '$' 'document-node'
     || lk == 62495                 // '$' 'element'
     || lk == 63007                 // '$' 'else'
     || lk == 63519                 // '$' 'empty'
     || lk == 64031                 // '$' 'empty-sequence'
     || lk == 64543                 // '$' 'encoding'
     || lk == 65055                 // '$' 'end'
     || lk == 66079                 // '$' 'eq'
     || lk == 66591                 // '$' 'every'
     || lk == 67615                 // '$' 'except'
     || lk == 68127                 // '$' 'exit'
     || lk == 68639                 // '$' 'external'
     || lk == 69151                 // '$' 'false'
     || lk == 69663                 // '$' 'first'
     || lk == 70175                 // '$' 'following'
     || lk == 70687                 // '$' 'following-sibling'
     || lk == 71199                 // '$' 'for'
     || lk == 72735                 // '$' 'from'
     || lk == 73247                 // '$' 'ft-option'
     || lk == 75295                 // '$' 'function'
     || lk == 75807                 // '$' 'ge'
     || lk == 76831                 // '$' 'group'
     || lk == 77855                 // '$' 'gt'
     || lk == 78367                 // '$' 'idiv'
     || lk == 78879                 // '$' 'if'
     || lk == 79391                 // '$' 'import'
     || lk == 79903                 // '$' 'in'
     || lk == 80415                 // '$' 'index'
     || lk == 82463                 // '$' 'insert'
     || lk == 82975                 // '$' 'instance'
     || lk == 83487                 // '$' 'integrity'
     || lk == 83999                 // '$' 'intersect'
     || lk == 84511                 // '$' 'into'
     || lk == 85023                 // '$' 'is'
     || lk == 85535                 // '$' 'item'
     || lk == 86047                 // '$' 'json'
     || lk == 86559                 // '$' 'json-item'
     || lk == 87071                 // '$' 'jsoniq'
     || lk == 88607                 // '$' 'last'
     || lk == 89119                 // '$' 'lax'
     || lk == 89631                 // '$' 'le'
     || lk == 90655                 // '$' 'let'
     || lk == 91679                 // '$' 'loop'
     || lk == 92703                 // '$' 'lt'
     || lk == 93727                 // '$' 'mod'
     || lk == 94239                 // '$' 'modify'
     || lk == 94751                 // '$' 'module'
     || lk == 95775                 // '$' 'namespace'
     || lk == 96287                 // '$' 'namespace-node'
     || lk == 96799                 // '$' 'ne'
     || lk == 99359                 // '$' 'node'
     || lk == 99871                 // '$' 'nodes'
     || lk == 100895                // '$' 'null'
     || lk == 101407                // '$' 'object'
     || lk == 103455                // '$' 'only'
     || lk == 103967                // '$' 'option'
     || lk == 104479                // '$' 'or'
     || lk == 104991                // '$' 'order'
     || lk == 105503                // '$' 'ordered'
     || lk == 106015                // '$' 'ordering'
     || lk == 107551                // '$' 'parent'
     || lk == 110623                // '$' 'preceding'
     || lk == 111135                // '$' 'preceding-sibling'
     || lk == 112671                // '$' 'processing-instruction'
     || lk == 113695                // '$' 'rename'
     || lk == 114207                // '$' 'replace'
     || lk == 114719                // '$' 'return'
     || lk == 115231                // '$' 'returning'
     || lk == 115743                // '$' 'revalidation'
     || lk == 116767                // '$' 'satisfies'
     || lk == 117279                // '$' 'schema'
     || lk == 117791                // '$' 'schema-attribute'
     || lk == 118303                // '$' 'schema-element'
     || lk == 118815                // '$' 'score'
     || lk == 119327                // '$' 'select'
     || lk == 119839                // '$' 'self'
     || lk == 122399                // '$' 'sliding'
     || lk == 122911                // '$' 'some'
     || lk == 123423                // '$' 'stable'
     || lk == 123935                // '$' 'start'
     || lk == 125471                // '$' 'strict'
     || lk == 126495                // '$' 'structured-item'
     || lk == 127007                // '$' 'switch'
     || lk == 127519                // '$' 'text'
     || lk == 129567                // '$' 'to'
     || lk == 130079                // '$' 'treat'
     || lk == 130591                // '$' 'true'
     || lk == 131103                // '$' 'try'
     || lk == 131615                // '$' 'tumbling'
     || lk == 132127                // '$' 'type'
     || lk == 132639                // '$' 'typeswitch'
     || lk == 133151                // '$' 'union'
     || lk == 134175                // '$' 'unordered'
     || lk == 134687                // '$' 'updating'
     || lk == 136223                // '$' 'validate'
     || lk == 136735                // '$' 'value'
     || lk == 137247                // '$' 'variable'
     || lk == 137759                // '$' 'version'
     || lk == 139295                // '$' 'where'
     || lk == 139807                // '$' 'while'
     || lk == 141343)               // '$' 'with'
    {
      lk = memoized(2, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_GroupingVariable();
          lookahead1W(206);         // S^WS | '(:' | ',' | ':=' | 'as' | 'collation' | 'count' | 'for' | 'group' |
          if (l1 == 53              // ':='
           || l1 == 80)             // 'as'
          {
            if (l1 == 80)           // 'as'
            {
              try_TypeDeclaration();
            }
            lookahead1W(28);        // S^WS | '(:' | ':='
            shiftT(53);             // ':='
            lookahead1W(267);       // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
            try_ExprSingle();
          }
          if (l1 == 95)             // 'collation'
          {
            shiftT(95);             // 'collation'
            lookahead1W(15);        // URILiteral | S^WS | '(:'
            shiftT(7);              // URILiteral
          }
          memoize(2, e0A, -1);
          lk = -3;
        }
        catch (p1A)
        {
          lk = -2;
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(2, e0A, -2);
        }
      }
    }
    switch (lk)
    {
    case -1:
      try_GroupingVariable();
      lookahead1W(206);             // S^WS | '(:' | ',' | ':=' | 'as' | 'collation' | 'count' | 'for' | 'group' |
      if (l1 == 53                  // ':='
       || l1 == 80)                 // 'as'
      {
        if (l1 == 80)               // 'as'
        {
          try_TypeDeclaration();
        }
        lookahead1W(28);            // S^WS | '(:' | ':='
        shiftT(53);                 // ':='
        lookahead1W(267);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        try_ExprSingle();
      }
      if (l1 == 95)                 // 'collation'
      {
        shiftT(95);                 // 'collation'
        lookahead1W(15);            // URILiteral | S^WS | '(:'
        shiftT(7);                  // URILiteral
      }
      break;
    case -3:
      break;
    default:
      try_ExprSingle();
    }
  }

  function parse_GroupingVariable()
  {
    eventHandler.startNonterminal("GroupingVariable", e0);
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    eventHandler.endNonterminal("GroupingVariable", e0);
  }

  function try_GroupingVariable()
  {
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
  }

  function parse_OrderByClause()
  {
    eventHandler.startNonterminal("OrderByClause", e0);
    switch (l1)
    {
    case 205:                       // 'order'
      shift(205);                   // 'order'
      lookahead1W(37);              // S^WS | '(:' | 'by'
      shift(88);                    // 'by'
      break;
    default:
      shift(241);                   // 'stable'
      lookahead1W(70);              // S^WS | '(:' | 'order'
      shift(205);                   // 'order'
      lookahead1W(37);              // S^WS | '(:' | 'by'
      shift(88);                    // 'by'
    }
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_OrderSpecList();
    eventHandler.endNonterminal("OrderByClause", e0);
  }

  function try_OrderByClause()
  {
    switch (l1)
    {
    case 205:                       // 'order'
      shiftT(205);                  // 'order'
      lookahead1W(37);              // S^WS | '(:' | 'by'
      shiftT(88);                   // 'by'
      break;
    default:
      shiftT(241);                  // 'stable'
      lookahead1W(70);              // S^WS | '(:' | 'order'
      shiftT(205);                  // 'order'
      lookahead1W(37);              // S^WS | '(:' | 'by'
      shiftT(88);                   // 'by'
    }
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_OrderSpecList();
  }

  function parse_OrderSpecList()
  {
    eventHandler.startNonterminal("OrderSpecList", e0);
    parse_OrderSpec();
    for (;;)
    {
      lookahead1W(198);             // S^WS | '(:' | ',' | 'count' | 'for' | 'group' | 'let' | 'order' | 'return' |
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_OrderSpec();
    }
    eventHandler.endNonterminal("OrderSpecList", e0);
  }

  function try_OrderSpecList()
  {
    try_OrderSpec();
    for (;;)
    {
      lookahead1W(198);             // S^WS | '(:' | ',' | 'count' | 'for' | 'group' | 'let' | 'order' | 'return' |
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_OrderSpec();
    }
  }

  function parse_OrderSpec()
  {
    eventHandler.startNonterminal("OrderSpec", e0);
    parse_ExprSingle();
    whitespace();
    parse_OrderModifier();
    eventHandler.endNonterminal("OrderSpec", e0);
  }

  function try_OrderSpec()
  {
    try_ExprSingle();
    try_OrderModifier();
  }

  function parse_OrderModifier()
  {
    eventHandler.startNonterminal("OrderModifier", e0);
    if (l1 == 81                    // 'ascending'
     || l1 == 114)                  // 'descending'
    {
      switch (l1)
      {
      case 81:                      // 'ascending'
        shift(81);                  // 'ascending'
        break;
      default:
        shift(114);                 // 'descending'
      }
    }
    lookahead1W(203);               // S^WS | '(:' | ',' | 'collation' | 'count' | 'empty' | 'for' | 'group' | 'let' |
    if (l1 == 124)                  // 'empty'
    {
      shift(124);                   // 'empty'
      lookahead1W(125);             // S^WS | '(:' | 'greatest' | 'least'
      switch (l1)
      {
      case 149:                     // 'greatest'
        shift(149);                 // 'greatest'
        break;
      default:
        shift(176);                 // 'least'
      }
    }
    lookahead1W(199);               // S^WS | '(:' | ',' | 'collation' | 'count' | 'for' | 'group' | 'let' | 'order' |
    if (l1 == 95)                   // 'collation'
    {
      shift(95);                    // 'collation'
      lookahead1W(15);              // URILiteral | S^WS | '(:'
      shift(7);                     // URILiteral
    }
    eventHandler.endNonterminal("OrderModifier", e0);
  }

  function try_OrderModifier()
  {
    if (l1 == 81                    // 'ascending'
     || l1 == 114)                  // 'descending'
    {
      switch (l1)
      {
      case 81:                      // 'ascending'
        shiftT(81);                 // 'ascending'
        break;
      default:
        shiftT(114);                // 'descending'
      }
    }
    lookahead1W(203);               // S^WS | '(:' | ',' | 'collation' | 'count' | 'empty' | 'for' | 'group' | 'let' |
    if (l1 == 124)                  // 'empty'
    {
      shiftT(124);                  // 'empty'
      lookahead1W(125);             // S^WS | '(:' | 'greatest' | 'least'
      switch (l1)
      {
      case 149:                     // 'greatest'
        shiftT(149);                // 'greatest'
        break;
      default:
        shiftT(176);                // 'least'
      }
    }
    lookahead1W(199);               // S^WS | '(:' | ',' | 'collation' | 'count' | 'for' | 'group' | 'let' | 'order' |
    if (l1 == 95)                   // 'collation'
    {
      shiftT(95);                   // 'collation'
      lookahead1W(15);              // URILiteral | S^WS | '(:'
      shiftT(7);                    // URILiteral
    }
  }

  function parse_ReturnClause()
  {
    eventHandler.startNonterminal("ReturnClause", e0);
    shift(224);                     // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("ReturnClause", e0);
  }

  function try_ReturnClause()
  {
    shiftT(224);                    // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_QuantifiedExpr()
  {
    eventHandler.startNonterminal("QuantifiedExpr", e0);
    switch (l1)
    {
    case 240:                       // 'some'
      shift(240);                   // 'some'
      break;
    default:
      shift(130);                   // 'every'
    }
    lookahead1W(21);                // S^WS | '$' | '(:'
    whitespace();
    parse_QuantifiedVarDecl();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      whitespace();
      parse_QuantifiedVarDecl();
    }
    shift(228);                     // 'satisfies'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("QuantifiedExpr", e0);
  }

  function try_QuantifiedExpr()
  {
    switch (l1)
    {
    case 240:                       // 'some'
      shiftT(240);                  // 'some'
      break;
    default:
      shiftT(130);                  // 'every'
    }
    lookahead1W(21);                // S^WS | '$' | '(:'
    try_QuantifiedVarDecl();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      try_QuantifiedVarDecl();
    }
    shiftT(228);                    // 'satisfies'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_QuantifiedVarDecl()
  {
    eventHandler.startNonterminal("QuantifiedVarDecl", e0);
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    lookahead1W(114);               // S^WS | '(:' | 'as' | 'in'
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_TypeDeclaration();
    }
    lookahead1W(56);                // S^WS | '(:' | 'in'
    shift(156);                     // 'in'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("QuantifiedVarDecl", e0);
  }

  function try_QuantifiedVarDecl()
  {
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
    lookahead1W(114);               // S^WS | '(:' | 'as' | 'in'
    if (l1 == 80)                   // 'as'
    {
      try_TypeDeclaration();
    }
    lookahead1W(56);                // S^WS | '(:' | 'in'
    shiftT(156);                    // 'in'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_SwitchExpr()
  {
    eventHandler.startNonterminal("SwitchExpr", e0);
    shift(248);                     // 'switch'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(38);                      // ')'
    for (;;)
    {
      lookahead1W(38);              // S^WS | '(:' | 'case'
      whitespace();
      parse_SwitchCaseClause();
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shift(110);                     // 'default'
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shift(224);                     // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("SwitchExpr", e0);
  }

  function try_SwitchExpr()
  {
    shiftT(248);                    // 'switch'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(38);                     // ')'
    for (;;)
    {
      lookahead1W(38);              // S^WS | '(:' | 'case'
      try_SwitchCaseClause();
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shiftT(110);                    // 'default'
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shiftT(224);                    // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_SwitchCaseClause()
  {
    eventHandler.startNonterminal("SwitchCaseClause", e0);
    for (;;)
    {
      shift(89);                    // 'case'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_SwitchCaseOperand();
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shift(224);                     // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("SwitchCaseClause", e0);
  }

  function try_SwitchCaseClause()
  {
    for (;;)
    {
      shiftT(89);                   // 'case'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_SwitchCaseOperand();
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shiftT(224);                    // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_SwitchCaseOperand()
  {
    eventHandler.startNonterminal("SwitchCaseOperand", e0);
    parse_ExprSingle();
    eventHandler.endNonterminal("SwitchCaseOperand", e0);
  }

  function try_SwitchCaseOperand()
  {
    try_ExprSingle();
  }

  function parse_TypeswitchExpr()
  {
    eventHandler.startNonterminal("TypeswitchExpr", e0);
    shift(259);                     // 'typeswitch'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(38);                      // ')'
    for (;;)
    {
      lookahead1W(38);              // S^WS | '(:' | 'case'
      whitespace();
      parse_CaseClause();
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shift(110);                     // 'default'
    lookahead1W(99);                // S^WS | '$' | '(:' | 'return'
    if (l1 == 31)                   // '$'
    {
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_VarName();
    }
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shift(224);                     // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("TypeswitchExpr", e0);
  }

  function try_TypeswitchExpr()
  {
    shiftT(259);                    // 'typeswitch'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(38);                     // ')'
    for (;;)
    {
      lookahead1W(38);              // S^WS | '(:' | 'case'
      try_CaseClause();
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shiftT(110);                    // 'default'
    lookahead1W(99);                // S^WS | '$' | '(:' | 'return'
    if (l1 == 31)                   // '$'
    {
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_VarName();
    }
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shiftT(224);                    // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_CaseClause()
  {
    eventHandler.startNonterminal("CaseClause", e0);
    shift(89);                      // 'case'
    lookahead1W(258);               // EQName^Token | S^WS | '$' | '%' | '(' | '(:' | 'after' | 'allowing' |
    if (l1 == 31)                   // '$'
    {
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_VarName();
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shift(80);                    // 'as'
    }
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_SequenceTypeUnion();
    shift(224);                     // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("CaseClause", e0);
  }

  function try_CaseClause()
  {
    shiftT(89);                     // 'case'
    lookahead1W(258);               // EQName^Token | S^WS | '$' | '%' | '(' | '(:' | 'after' | 'allowing' |
    if (l1 == 31)                   // '$'
    {
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_VarName();
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shiftT(80);                   // 'as'
    }
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_SequenceTypeUnion();
    shiftT(224);                    // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_SequenceTypeUnion()
  {
    eventHandler.startNonterminal("SequenceTypeUnion", e0);
    parse_SequenceType();
    for (;;)
    {
      lookahead1W(138);             // S^WS | '(:' | 'return' | '|'
      if (l1 != 284)                // '|'
      {
        break;
      }
      shift(284);                   // '|'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_SequenceType();
    }
    eventHandler.endNonterminal("SequenceTypeUnion", e0);
  }

  function try_SequenceTypeUnion()
  {
    try_SequenceType();
    for (;;)
    {
      lookahead1W(138);             // S^WS | '(:' | 'return' | '|'
      if (l1 != 284)                // '|'
      {
        break;
      }
      shiftT(284);                  // '|'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_SequenceType();
    }
  }

  function parse_IfExpr()
  {
    eventHandler.startNonterminal("IfExpr", e0);
    shift(154);                     // 'if'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(38);                      // ')'
    lookahead1W(80);                // S^WS | '(:' | 'then'
    shift(250);                     // 'then'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    shift(123);                     // 'else'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("IfExpr", e0);
  }

  function try_IfExpr()
  {
    shiftT(154);                    // 'if'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(38);                     // ')'
    lookahead1W(80);                // S^WS | '(:' | 'then'
    shiftT(250);                    // 'then'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
    shiftT(123);                    // 'else'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_TryCatchExpr()
  {
    eventHandler.startNonterminal("TryCatchExpr", e0);
    parse_TryClause();
    for (;;)
    {
      lookahead1W(39);              // S^WS | '(:' | 'catch'
      whitespace();
      parse_CatchClause();
      lookahead1W(208);             // S^WS | EOF | '(:' | ')' | ',' | ':' | ';' | ']' | 'after' | 'as' | 'ascending' |
      if (l1 != 92)                 // 'catch'
      {
        break;
      }
    }
    eventHandler.endNonterminal("TryCatchExpr", e0);
  }

  function try_TryCatchExpr()
  {
    try_TryClause();
    for (;;)
    {
      lookahead1W(39);              // S^WS | '(:' | 'catch'
      try_CatchClause();
      lookahead1W(208);             // S^WS | EOF | '(:' | ')' | ',' | ':' | ';' | ']' | 'after' | 'as' | 'ascending' |
      if (l1 != 92)                 // 'catch'
      {
        break;
      }
    }
  }

  function parse_TryClause()
  {
    eventHandler.startNonterminal("TryClause", e0);
    shift(256);                     // 'try'
    lookahead1W(90);                // S^WS | '(:' | '{'
    shift(281);                     // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_TryTargetExpr();
    shift(287);                     // '}'
    eventHandler.endNonterminal("TryClause", e0);
  }

  function try_TryClause()
  {
    shiftT(256);                    // 'try'
    lookahead1W(90);                // S^WS | '(:' | '{'
    shiftT(281);                    // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_TryTargetExpr();
    shiftT(287);                    // '}'
  }

  function parse_TryTargetExpr()
  {
    eventHandler.startNonterminal("TryTargetExpr", e0);
    parse_Expr();
    eventHandler.endNonterminal("TryTargetExpr", e0);
  }

  function try_TryTargetExpr()
  {
    try_Expr();
  }

  function parse_CatchClause()
  {
    eventHandler.startNonterminal("CatchClause", e0);
    shift(92);                      // 'catch'
    lookahead1W(249);               // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_CatchErrorList();
    shift(281);                     // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(287);                     // '}'
    eventHandler.endNonterminal("CatchClause", e0);
  }

  function try_CatchClause()
  {
    shiftT(92);                     // 'catch'
    lookahead1W(249);               // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_CatchErrorList();
    shiftT(281);                    // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(287);                    // '}'
  }

  function parse_CatchErrorList()
  {
    eventHandler.startNonterminal("CatchErrorList", e0);
    parse_NameTest();
    for (;;)
    {
      lookahead1W(140);             // S^WS | '(:' | '{' | '|'
      if (l1 != 284)                // '|'
      {
        break;
      }
      shift(284);                   // '|'
      lookahead1W(249);             // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_NameTest();
    }
    eventHandler.endNonterminal("CatchErrorList", e0);
  }

  function try_CatchErrorList()
  {
    try_NameTest();
    for (;;)
    {
      lookahead1W(140);             // S^WS | '(:' | '{' | '|'
      if (l1 != 284)                // '|'
      {
        break;
      }
      shiftT(284);                  // '|'
      lookahead1W(249);             // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_NameTest();
    }
  }

  function parse_OrExpr()
  {
    eventHandler.startNonterminal("OrExpr", e0);
    parse_AndExpr();
    for (;;)
    {
      if (l1 != 204)                // 'or'
      {
        break;
      }
      shift(204);                   // 'or'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_AndExpr();
    }
    eventHandler.endNonterminal("OrExpr", e0);
  }

  function try_OrExpr()
  {
    try_AndExpr();
    for (;;)
    {
      if (l1 != 204)                // 'or'
      {
        break;
      }
      shiftT(204);                  // 'or'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_AndExpr();
    }
  }

  function parse_AndExpr()
  {
    eventHandler.startNonterminal("AndExpr", e0);
    parse_NotExpr();
    for (;;)
    {
      if (l1 != 76)                 // 'and'
      {
        break;
      }
      shift(76);                    // 'and'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_NotExpr();
    }
    eventHandler.endNonterminal("AndExpr", e0);
  }

  function try_AndExpr()
  {
    try_NotExpr();
    for (;;)
    {
      if (l1 != 76)                 // 'and'
      {
        break;
      }
      shiftT(76);                   // 'and'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_NotExpr();
    }
  }

  function parse_NotExpr()
  {
    eventHandler.startNonterminal("NotExpr", e0);
    if (l1 == 196)                  // 'not'
    {
      shift(196);                   // 'not'
    }
    lookahead1W(266);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ComparisonExpr();
    eventHandler.endNonterminal("NotExpr", e0);
  }

  function try_NotExpr()
  {
    if (l1 == 196)                  // 'not'
    {
      shiftT(196);                  // 'not'
    }
    lookahead1W(266);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ComparisonExpr();
  }

  function parse_ComparisonExpr()
  {
    eventHandler.startNonterminal("ComparisonExpr", e0);
    parse_FTContainsExpr();
    if (l1 == 27                    // '!='
     || l1 == 55                    // '<'
     || l1 == 58                    // '<<'
     || l1 == 59                    // '<='
     || l1 == 61                    // '='
     || l1 == 62                    // '>'
     || l1 == 63                    // '>='
     || l1 == 64                    // '>>'
     || l1 == 129                   // 'eq'
     || l1 == 148                   // 'ge'
     || l1 == 152                   // 'gt'
     || l1 == 166                   // 'is'
     || l1 == 175                   // 'le'
     || l1 == 181                   // 'lt'
     || l1 == 189)                  // 'ne'
    {
      switch (l1)
      {
      case 129:                     // 'eq'
      case 148:                     // 'ge'
      case 152:                     // 'gt'
      case 175:                     // 'le'
      case 181:                     // 'lt'
      case 189:                     // 'ne'
        whitespace();
        parse_ValueComp();
        break;
      case 58:                      // '<<'
      case 64:                      // '>>'
      case 166:                     // 'is'
        whitespace();
        parse_NodeComp();
        break;
      default:
        whitespace();
        parse_GeneralComp();
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_FTContainsExpr();
    }
    eventHandler.endNonterminal("ComparisonExpr", e0);
  }

  function try_ComparisonExpr()
  {
    try_FTContainsExpr();
    if (l1 == 27                    // '!='
     || l1 == 55                    // '<'
     || l1 == 58                    // '<<'
     || l1 == 59                    // '<='
     || l1 == 61                    // '='
     || l1 == 62                    // '>'
     || l1 == 63                    // '>='
     || l1 == 64                    // '>>'
     || l1 == 129                   // 'eq'
     || l1 == 148                   // 'ge'
     || l1 == 152                   // 'gt'
     || l1 == 166                   // 'is'
     || l1 == 175                   // 'le'
     || l1 == 181                   // 'lt'
     || l1 == 189)                  // 'ne'
    {
      switch (l1)
      {
      case 129:                     // 'eq'
      case 148:                     // 'ge'
      case 152:                     // 'gt'
      case 175:                     // 'le'
      case 181:                     // 'lt'
      case 189:                     // 'ne'
        try_ValueComp();
        break;
      case 58:                      // '<<'
      case 64:                      // '>>'
      case 166:                     // 'is'
        try_NodeComp();
        break;
      default:
        try_GeneralComp();
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_FTContainsExpr();
    }
  }

  function parse_FTContainsExpr()
  {
    eventHandler.startNonterminal("FTContainsExpr", e0);
    parse_StringConcatExpr();
    if (l1 == 100)                  // 'contains'
    {
      shift(100);                   // 'contains'
      lookahead1W(79);              // S^WS | '(:' | 'text'
      shift(249);                   // 'text'
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      whitespace();
      parse_FTSelection();
      if (l1 == 277)                // 'without'
      {
        whitespace();
        parse_FTIgnoreOption();
      }
    }
    eventHandler.endNonterminal("FTContainsExpr", e0);
  }

  function try_FTContainsExpr()
  {
    try_StringConcatExpr();
    if (l1 == 100)                  // 'contains'
    {
      shiftT(100);                  // 'contains'
      lookahead1W(79);              // S^WS | '(:' | 'text'
      shiftT(249);                  // 'text'
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      try_FTSelection();
      if (l1 == 277)                // 'without'
      {
        try_FTIgnoreOption();
      }
    }
  }

  function parse_StringConcatExpr()
  {
    eventHandler.startNonterminal("StringConcatExpr", e0);
    parse_RangeExpr();
    for (;;)
    {
      if (l1 != 285)                // '||'
      {
        break;
      }
      shift(285);                   // '||'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_RangeExpr();
    }
    eventHandler.endNonterminal("StringConcatExpr", e0);
  }

  function try_StringConcatExpr()
  {
    try_RangeExpr();
    for (;;)
    {
      if (l1 != 285)                // '||'
      {
        break;
      }
      shiftT(285);                  // '||'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_RangeExpr();
    }
  }

  function parse_RangeExpr()
  {
    eventHandler.startNonterminal("RangeExpr", e0);
    parse_AdditiveExpr();
    if (l1 == 253)                  // 'to'
    {
      shift(253);                   // 'to'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_AdditiveExpr();
    }
    eventHandler.endNonterminal("RangeExpr", e0);
  }

  function try_RangeExpr()
  {
    try_AdditiveExpr();
    if (l1 == 253)                  // 'to'
    {
      shiftT(253);                  // 'to'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_AdditiveExpr();
    }
  }

  function parse_AdditiveExpr()
  {
    eventHandler.startNonterminal("AdditiveExpr", e0);
    parse_MultiplicativeExpr();
    for (;;)
    {
      if (l1 != 41                  // '+'
       && l1 != 43)                 // '-'
      {
        break;
      }
      switch (l1)
      {
      case 41:                      // '+'
        shift(41);                  // '+'
        break;
      default:
        shift(43);                  // '-'
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_MultiplicativeExpr();
    }
    eventHandler.endNonterminal("AdditiveExpr", e0);
  }

  function try_AdditiveExpr()
  {
    try_MultiplicativeExpr();
    for (;;)
    {
      if (l1 != 41                  // '+'
       && l1 != 43)                 // '-'
      {
        break;
      }
      switch (l1)
      {
      case 41:                      // '+'
        shiftT(41);                 // '+'
        break;
      default:
        shiftT(43);                 // '-'
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_MultiplicativeExpr();
    }
  }

  function parse_MultiplicativeExpr()
  {
    eventHandler.startNonterminal("MultiplicativeExpr", e0);
    parse_UnionExpr();
    for (;;)
    {
      if (l1 != 39                  // '*'
       && l1 != 119                 // 'div'
       && l1 != 153                 // 'idiv'
       && l1 != 183)                // 'mod'
      {
        break;
      }
      switch (l1)
      {
      case 39:                      // '*'
        shift(39);                  // '*'
        break;
      case 119:                     // 'div'
        shift(119);                 // 'div'
        break;
      case 153:                     // 'idiv'
        shift(153);                 // 'idiv'
        break;
      default:
        shift(183);                 // 'mod'
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_UnionExpr();
    }
    eventHandler.endNonterminal("MultiplicativeExpr", e0);
  }

  function try_MultiplicativeExpr()
  {
    try_UnionExpr();
    for (;;)
    {
      if (l1 != 39                  // '*'
       && l1 != 119                 // 'div'
       && l1 != 153                 // 'idiv'
       && l1 != 183)                // 'mod'
      {
        break;
      }
      switch (l1)
      {
      case 39:                      // '*'
        shiftT(39);                 // '*'
        break;
      case 119:                     // 'div'
        shiftT(119);                // 'div'
        break;
      case 153:                     // 'idiv'
        shiftT(153);                // 'idiv'
        break;
      default:
        shiftT(183);                // 'mod'
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_UnionExpr();
    }
  }

  function parse_UnionExpr()
  {
    eventHandler.startNonterminal("UnionExpr", e0);
    parse_IntersectExceptExpr();
    for (;;)
    {
      if (l1 != 260                 // 'union'
       && l1 != 284)                // '|'
      {
        break;
      }
      switch (l1)
      {
      case 260:                     // 'union'
        shift(260);                 // 'union'
        break;
      default:
        shift(284);                 // '|'
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_IntersectExceptExpr();
    }
    eventHandler.endNonterminal("UnionExpr", e0);
  }

  function try_UnionExpr()
  {
    try_IntersectExceptExpr();
    for (;;)
    {
      if (l1 != 260                 // 'union'
       && l1 != 284)                // '|'
      {
        break;
      }
      switch (l1)
      {
      case 260:                     // 'union'
        shiftT(260);                // 'union'
        break;
      default:
        shiftT(284);                // '|'
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_IntersectExceptExpr();
    }
  }

  function parse_IntersectExceptExpr()
  {
    eventHandler.startNonterminal("IntersectExceptExpr", e0);
    parse_InstanceofExpr();
    for (;;)
    {
      lookahead1W(222);             // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
      if (l1 != 132                 // 'except'
       && l1 != 164)                // 'intersect'
      {
        break;
      }
      switch (l1)
      {
      case 164:                     // 'intersect'
        shift(164);                 // 'intersect'
        break;
      default:
        shift(132);                 // 'except'
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_InstanceofExpr();
    }
    eventHandler.endNonterminal("IntersectExceptExpr", e0);
  }

  function try_IntersectExceptExpr()
  {
    try_InstanceofExpr();
    for (;;)
    {
      lookahead1W(222);             // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
      if (l1 != 132                 // 'except'
       && l1 != 164)                // 'intersect'
      {
        break;
      }
      switch (l1)
      {
      case 164:                     // 'intersect'
        shiftT(164);                // 'intersect'
        break;
      default:
        shiftT(132);                // 'except'
      }
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_InstanceofExpr();
    }
  }

  function parse_InstanceofExpr()
  {
    eventHandler.startNonterminal("InstanceofExpr", e0);
    parse_TreatExpr();
    lookahead1W(223);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 162)                  // 'instance'
    {
      shift(162);                   // 'instance'
      lookahead1W(67);              // S^WS | '(:' | 'of'
      shift(200);                   // 'of'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_SequenceType();
    }
    eventHandler.endNonterminal("InstanceofExpr", e0);
  }

  function try_InstanceofExpr()
  {
    try_TreatExpr();
    lookahead1W(223);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 162)                  // 'instance'
    {
      shiftT(162);                  // 'instance'
      lookahead1W(67);              // S^WS | '(:' | 'of'
      shiftT(200);                  // 'of'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_SequenceType();
    }
  }

  function parse_TreatExpr()
  {
    eventHandler.startNonterminal("TreatExpr", e0);
    parse_CastableExpr();
    lookahead1W(224);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 254)                  // 'treat'
    {
      shift(254);                   // 'treat'
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shift(80);                    // 'as'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_SequenceType();
    }
    eventHandler.endNonterminal("TreatExpr", e0);
  }

  function try_TreatExpr()
  {
    try_CastableExpr();
    lookahead1W(224);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 254)                  // 'treat'
    {
      shiftT(254);                  // 'treat'
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shiftT(80);                   // 'as'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_SequenceType();
    }
  }

  function parse_CastableExpr()
  {
    eventHandler.startNonterminal("CastableExpr", e0);
    parse_CastExpr();
    lookahead1W(225);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 91)                   // 'castable'
    {
      shift(91);                    // 'castable'
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shift(80);                    // 'as'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_SingleType();
    }
    eventHandler.endNonterminal("CastableExpr", e0);
  }

  function try_CastableExpr()
  {
    try_CastExpr();
    lookahead1W(225);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 91)                   // 'castable'
    {
      shiftT(91);                   // 'castable'
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shiftT(80);                   // 'as'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_SingleType();
    }
  }

  function parse_CastExpr()
  {
    eventHandler.startNonterminal("CastExpr", e0);
    parse_UnaryExpr();
    lookahead1W(227);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 90)                   // 'cast'
    {
      shift(90);                    // 'cast'
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shift(80);                    // 'as'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_SingleType();
    }
    eventHandler.endNonterminal("CastExpr", e0);
  }

  function try_CastExpr()
  {
    try_UnaryExpr();
    lookahead1W(227);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 90)                   // 'cast'
    {
      shiftT(90);                   // 'cast'
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shiftT(80);                   // 'as'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_SingleType();
    }
  }

  function parse_UnaryExpr()
  {
    eventHandler.startNonterminal("UnaryExpr", e0);
    for (;;)
    {
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      if (l1 != 41                  // '+'
       && l1 != 43)                 // '-'
      {
        break;
      }
      switch (l1)
      {
      case 43:                      // '-'
        shift(43);                  // '-'
        break;
      default:
        shift(41);                  // '+'
      }
    }
    whitespace();
    parse_ValueExpr();
    eventHandler.endNonterminal("UnaryExpr", e0);
  }

  function try_UnaryExpr()
  {
    for (;;)
    {
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      if (l1 != 41                  // '+'
       && l1 != 43)                 // '-'
      {
        break;
      }
      switch (l1)
      {
      case 43:                      // '-'
        shiftT(43);                 // '-'
        break;
      default:
        shiftT(41);                 // '+'
      }
    }
    try_ValueExpr();
  }

  function parse_ValueExpr()
  {
    eventHandler.startNonterminal("ValueExpr", e0);
    switch (l1)
    {
    case 266:                       // 'validate'
      lookahead2W(188);             // S^WS | '#' | '(' | '(:' | 'lax' | 'strict' | 'type' | '{'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 89354:                     // 'validate' 'lax'
    case 125706:                    // 'validate' 'strict'
    case 132362:                    // 'validate' 'type'
    case 144138:                    // 'validate' '{'
      parse_ValidateExpr();
      break;
    case 36:                        // '(#'
      parse_ExtensionExpr();
      break;
    default:
      parse_SimpleMapExpr();
    }
    eventHandler.endNonterminal("ValueExpr", e0);
  }

  function try_ValueExpr()
  {
    switch (l1)
    {
    case 266:                       // 'validate'
      lookahead2W(188);             // S^WS | '#' | '(' | '(:' | 'lax' | 'strict' | 'type' | '{'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 89354:                     // 'validate' 'lax'
    case 125706:                    // 'validate' 'strict'
    case 132362:                    // 'validate' 'type'
    case 144138:                    // 'validate' '{'
      try_ValidateExpr();
      break;
    case 36:                        // '(#'
      try_ExtensionExpr();
      break;
    default:
      try_SimpleMapExpr();
    }
  }

  function parse_SimpleMapExpr()
  {
    eventHandler.startNonterminal("SimpleMapExpr", e0);
    parse_PathExpr();
    for (;;)
    {
      if (l1 != 26)                 // '!'
      {
        break;
      }
      shift(26);                    // '!'
      lookahead1W(263);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_PathExpr();
    }
    eventHandler.endNonterminal("SimpleMapExpr", e0);
  }

  function try_SimpleMapExpr()
  {
    try_PathExpr();
    for (;;)
    {
      if (l1 != 26)                 // '!'
      {
        break;
      }
      shiftT(26);                   // '!'
      lookahead1W(263);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_PathExpr();
    }
  }

  function parse_GeneralComp()
  {
    eventHandler.startNonterminal("GeneralComp", e0);
    switch (l1)
    {
    case 61:                        // '='
      shift(61);                    // '='
      break;
    case 27:                        // '!='
      shift(27);                    // '!='
      break;
    case 55:                        // '<'
      shift(55);                    // '<'
      break;
    case 59:                        // '<='
      shift(59);                    // '<='
      break;
    case 62:                        // '>'
      shift(62);                    // '>'
      break;
    default:
      shift(63);                    // '>='
    }
    eventHandler.endNonterminal("GeneralComp", e0);
  }

  function try_GeneralComp()
  {
    switch (l1)
    {
    case 61:                        // '='
      shiftT(61);                   // '='
      break;
    case 27:                        // '!='
      shiftT(27);                   // '!='
      break;
    case 55:                        // '<'
      shiftT(55);                   // '<'
      break;
    case 59:                        // '<='
      shiftT(59);                   // '<='
      break;
    case 62:                        // '>'
      shiftT(62);                   // '>'
      break;
    default:
      shiftT(63);                   // '>='
    }
  }

  function parse_ValueComp()
  {
    eventHandler.startNonterminal("ValueComp", e0);
    switch (l1)
    {
    case 129:                       // 'eq'
      shift(129);                   // 'eq'
      break;
    case 189:                       // 'ne'
      shift(189);                   // 'ne'
      break;
    case 181:                       // 'lt'
      shift(181);                   // 'lt'
      break;
    case 175:                       // 'le'
      shift(175);                   // 'le'
      break;
    case 152:                       // 'gt'
      shift(152);                   // 'gt'
      break;
    default:
      shift(148);                   // 'ge'
    }
    eventHandler.endNonterminal("ValueComp", e0);
  }

  function try_ValueComp()
  {
    switch (l1)
    {
    case 129:                       // 'eq'
      shiftT(129);                  // 'eq'
      break;
    case 189:                       // 'ne'
      shiftT(189);                  // 'ne'
      break;
    case 181:                       // 'lt'
      shiftT(181);                  // 'lt'
      break;
    case 175:                       // 'le'
      shiftT(175);                  // 'le'
      break;
    case 152:                       // 'gt'
      shiftT(152);                  // 'gt'
      break;
    default:
      shiftT(148);                  // 'ge'
    }
  }

  function parse_NodeComp()
  {
    eventHandler.startNonterminal("NodeComp", e0);
    switch (l1)
    {
    case 166:                       // 'is'
      shift(166);                   // 'is'
      break;
    case 58:                        // '<<'
      shift(58);                    // '<<'
      break;
    default:
      shift(64);                    // '>>'
    }
    eventHandler.endNonterminal("NodeComp", e0);
  }

  function try_NodeComp()
  {
    switch (l1)
    {
    case 166:                       // 'is'
      shiftT(166);                  // 'is'
      break;
    case 58:                        // '<<'
      shiftT(58);                   // '<<'
      break;
    default:
      shiftT(64);                   // '>>'
    }
  }

  function parse_ValidateExpr()
  {
    eventHandler.startNonterminal("ValidateExpr", e0);
    shift(266);                     // 'validate'
    lookahead1W(175);               // S^WS | '(:' | 'lax' | 'strict' | 'type' | '{'
    if (l1 != 281)                  // '{'
    {
      switch (l1)
      {
      case 258:                     // 'type'
        shift(258);                 // 'type'
        lookahead1W(246);           // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
        whitespace();
        parse_TypeName();
        break;
      default:
        whitespace();
        parse_ValidationMode();
      }
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    shift(281);                     // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(287);                     // '}'
    eventHandler.endNonterminal("ValidateExpr", e0);
  }

  function try_ValidateExpr()
  {
    shiftT(266);                    // 'validate'
    lookahead1W(175);               // S^WS | '(:' | 'lax' | 'strict' | 'type' | '{'
    if (l1 != 281)                  // '{'
    {
      switch (l1)
      {
      case 258:                     // 'type'
        shiftT(258);                // 'type'
        lookahead1W(246);           // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
        try_TypeName();
        break;
      default:
        try_ValidationMode();
      }
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    shiftT(281);                    // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(287);                    // '}'
  }

  function parse_ValidationMode()
  {
    eventHandler.startNonterminal("ValidationMode", e0);
    switch (l1)
    {
    case 174:                       // 'lax'
      shift(174);                   // 'lax'
      break;
    default:
      shift(245);                   // 'strict'
    }
    eventHandler.endNonterminal("ValidationMode", e0);
  }

  function try_ValidationMode()
  {
    switch (l1)
    {
    case 174:                       // 'lax'
      shiftT(174);                  // 'lax'
      break;
    default:
      shiftT(245);                  // 'strict'
    }
  }

  function parse_ExtensionExpr()
  {
    eventHandler.startNonterminal("ExtensionExpr", e0);
    for (;;)
    {
      whitespace();
      parse_Pragma();
      lookahead1W(104);             // S^WS | '(#' | '(:' | '{'
      if (l1 != 36)                 // '(#'
      {
        break;
      }
    }
    shift(281);                     // '{'
    lookahead1W(275);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    if (l1 != 287)                  // '}'
    {
      whitespace();
      parse_Expr();
    }
    shift(287);                     // '}'
    eventHandler.endNonterminal("ExtensionExpr", e0);
  }

  function try_ExtensionExpr()
  {
    for (;;)
    {
      try_Pragma();
      lookahead1W(104);             // S^WS | '(#' | '(:' | '{'
      if (l1 != 36)                 // '(#'
      {
        break;
      }
    }
    shiftT(281);                    // '{'
    lookahead1W(275);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    if (l1 != 287)                  // '}'
    {
      try_Expr();
    }
    shiftT(287);                    // '}'
  }

  function parse_Pragma()
  {
    eventHandler.startNonterminal("Pragma", e0);
    shift(36);                      // '(#'
    lookahead1(243);                // EQName^Token | S | 'after' | 'allowing' | 'ancestor' | 'ancestor-or-self' |
    if (l1 == 21)                   // S
    {
      shift(21);                    // S
    }
    parse_EQName();
    lookahead1(10);                 // S | '#)'
    if (l1 == 21)                   // S
    {
      shift(21);                    // S
      lookahead1(0);                // PragmaContents
      shift(1);                     // PragmaContents
    }
    lookahead1(5);                  // '#)'
    shift(30);                      // '#)'
    eventHandler.endNonterminal("Pragma", e0);
  }

  function try_Pragma()
  {
    shiftT(36);                     // '(#'
    lookahead1(243);                // EQName^Token | S | 'after' | 'allowing' | 'ancestor' | 'ancestor-or-self' |
    if (l1 == 21)                   // S
    {
      shiftT(21);                   // S
    }
    try_EQName();
    lookahead1(10);                 // S | '#)'
    if (l1 == 21)                   // S
    {
      shiftT(21);                   // S
      lookahead1(0);                // PragmaContents
      shiftT(1);                    // PragmaContents
    }
    lookahead1(5);                  // '#)'
    shiftT(30);                     // '#)'
  }

  function parse_PathExpr()
  {
    eventHandler.startNonterminal("PathExpr", e0);
    switch (l1)
    {
    case 47:                        // '/'
      shift(47);                    // '/'
      lookahead1W(289);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 25:                      // EOF
      case 26:                      // '!'
      case 27:                      // '!='
      case 38:                      // ')'
      case 39:                      // '*'
      case 41:                      // '+'
      case 42:                      // ','
      case 43:                      // '-'
      case 50:                      // ':'
      case 54:                      // ';'
      case 58:                      // '<<'
      case 59:                      // '<='
      case 61:                      // '='
      case 62:                      // '>'
      case 63:                      // '>='
      case 64:                      // '>>'
      case 70:                      // ']'
      case 88:                      // 'by'
      case 100:                     // 'contains'
      case 209:                     // 'paragraphs'
      case 237:                     // 'sentences'
      case 252:                     // 'times'
      case 279:                     // 'words'
      case 284:                     // '|'
      case 285:                     // '||'
      case 286:                     // '|}'
      case 287:                     // '}'
        break;
      default:
        whitespace();
        parse_RelativePathExpr();
      }
      break;
    case 48:                        // '//'
      shift(48);                    // '//'
      lookahead1W(260);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_RelativePathExpr();
      break;
    default:
      parse_RelativePathExpr();
    }
    eventHandler.endNonterminal("PathExpr", e0);
  }

  function try_PathExpr()
  {
    switch (l1)
    {
    case 47:                        // '/'
      shiftT(47);                   // '/'
      lookahead1W(289);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 25:                      // EOF
      case 26:                      // '!'
      case 27:                      // '!='
      case 38:                      // ')'
      case 39:                      // '*'
      case 41:                      // '+'
      case 42:                      // ','
      case 43:                      // '-'
      case 50:                      // ':'
      case 54:                      // ';'
      case 58:                      // '<<'
      case 59:                      // '<='
      case 61:                      // '='
      case 62:                      // '>'
      case 63:                      // '>='
      case 64:                      // '>>'
      case 70:                      // ']'
      case 88:                      // 'by'
      case 100:                     // 'contains'
      case 209:                     // 'paragraphs'
      case 237:                     // 'sentences'
      case 252:                     // 'times'
      case 279:                     // 'words'
      case 284:                     // '|'
      case 285:                     // '||'
      case 286:                     // '|}'
      case 287:                     // '}'
        break;
      default:
        try_RelativePathExpr();
      }
      break;
    case 48:                        // '//'
      shiftT(48);                   // '//'
      lookahead1W(260);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_RelativePathExpr();
      break;
    default:
      try_RelativePathExpr();
    }
  }

  function parse_RelativePathExpr()
  {
    eventHandler.startNonterminal("RelativePathExpr", e0);
    parse_PostfixExpr();
    for (;;)
    {
      switch (l1)
      {
      case 26:                      // '!'
        lookahead2W(265);           // Wildcard | EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral |
        break;
      default:
        lk = l1;
      }
      if (lk != 25                  // EOF
       && lk != 27                  // '!='
       && lk != 38                  // ')'
       && lk != 39                  // '*'
       && lk != 41                  // '+'
       && lk != 42                  // ','
       && lk != 43                  // '-'
       && lk != 47                  // '/'
       && lk != 48                  // '//'
       && lk != 50                  // ':'
       && lk != 54                  // ';'
       && lk != 55                  // '<'
       && lk != 58                  // '<<'
       && lk != 59                  // '<='
       && lk != 61                  // '='
       && lk != 62                  // '>'
       && lk != 63                  // '>='
       && lk != 64                  // '>>'
       && lk != 70                  // ']'
       && lk != 71                  // 'after'
       && lk != 76                  // 'and'
       && lk != 80                  // 'as'
       && lk != 81                  // 'ascending'
       && lk != 82                  // 'at'
       && lk != 85                  // 'before'
       && lk != 88                  // 'by'
       && lk != 89                  // 'case'
       && lk != 90                  // 'cast'
       && lk != 91                  // 'castable'
       && lk != 95                  // 'collation'
       && lk != 100                 // 'contains'
       && lk != 106                 // 'count'
       && lk != 110                 // 'default'
       && lk != 114                 // 'descending'
       && lk != 119                 // 'div'
       && lk != 123                 // 'else'
       && lk != 124                 // 'empty'
       && lk != 127                 // 'end'
       && lk != 129                 // 'eq'
       && lk != 132                 // 'except'
       && lk != 139                 // 'for'
       && lk != 148                 // 'ge'
       && lk != 150                 // 'group'
       && lk != 152                 // 'gt'
       && lk != 153                 // 'idiv'
       && lk != 162                 // 'instance'
       && lk != 164                 // 'intersect'
       && lk != 165                 // 'into'
       && lk != 166                 // 'is'
       && lk != 175                 // 'le'
       && lk != 177                 // 'let'
       && lk != 181                 // 'lt'
       && lk != 183                 // 'mod'
       && lk != 184                 // 'modify'
       && lk != 189                 // 'ne'
       && lk != 202                 // 'only'
       && lk != 204                 // 'or'
       && lk != 205                 // 'order'
       && lk != 209                 // 'paragraphs'
       && lk != 224                 // 'return'
       && lk != 228                 // 'satisfies'
       && lk != 237                 // 'sentences'
       && lk != 241                 // 'stable'
       && lk != 242                 // 'start'
       && lk != 252                 // 'times'
       && lk != 253                 // 'to'
       && lk != 254                 // 'treat'
       && lk != 260                 // 'union'
       && lk != 272                 // 'where'
       && lk != 276                 // 'with'
       && lk != 279                 // 'words'
       && lk != 284                 // '|'
       && lk != 285                 // '||'
       && lk != 286                 // '|}'
       && lk != 287                 // '}'
       && lk != 2586                // '!' Wildcard
       && lk != 23578               // '!' '..'
       && lk != 24090               // '!' '/'
       && lk != 24602               // '!' '//'
       && lk != 34330)              // '!' '@'
      {
        lk = memoized(3, e0);
        if (lk == 0)
        {
          var b0A = b0; var e0A = e0; var l1A = l1;
          var b1A = b1; var e1A = e1; var l2A = l2;
          var b2A = b2; var e2A = e2;
          try
          {
            switch (l1)
            {
            case 47:                // '/'
              shiftT(47);           // '/'
              break;
            case 48:                // '//'
              shiftT(48);           // '//'
              break;
            default:
              shiftT(26);           // '!'
            }
            lookahead1W(264);       // Wildcard | EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral |
            try_StepExpr();
            lk = -1;
          }
          catch (p1A)
          {
            lk = -2;
          }
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(3, e0, lk);
        }
      }
      if (lk != -1
       && lk != 47                  // '/'
       && lk != 48                  // '//'
       && lk != 2586                // '!' Wildcard
       && lk != 23578               // '!' '..'
       && lk != 34330)              // '!' '@'
      {
        break;
      }
      switch (l1)
      {
      case 47:                      // '/'
        shift(47);                  // '/'
        break;
      case 48:                      // '//'
        shift(48);                  // '//'
        break;
      default:
        shift(26);                  // '!'
      }
      lookahead1W(264);             // Wildcard | EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral |
      whitespace();
      parse_StepExpr();
    }
    eventHandler.endNonterminal("RelativePathExpr", e0);
  }

  function try_RelativePathExpr()
  {
    try_PostfixExpr();
    for (;;)
    {
      switch (l1)
      {
      case 26:                      // '!'
        lookahead2W(265);           // Wildcard | EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral |
        break;
      default:
        lk = l1;
      }
      if (lk != 25                  // EOF
       && lk != 27                  // '!='
       && lk != 38                  // ')'
       && lk != 39                  // '*'
       && lk != 41                  // '+'
       && lk != 42                  // ','
       && lk != 43                  // '-'
       && lk != 47                  // '/'
       && lk != 48                  // '//'
       && lk != 50                  // ':'
       && lk != 54                  // ';'
       && lk != 55                  // '<'
       && lk != 58                  // '<<'
       && lk != 59                  // '<='
       && lk != 61                  // '='
       && lk != 62                  // '>'
       && lk != 63                  // '>='
       && lk != 64                  // '>>'
       && lk != 70                  // ']'
       && lk != 71                  // 'after'
       && lk != 76                  // 'and'
       && lk != 80                  // 'as'
       && lk != 81                  // 'ascending'
       && lk != 82                  // 'at'
       && lk != 85                  // 'before'
       && lk != 88                  // 'by'
       && lk != 89                  // 'case'
       && lk != 90                  // 'cast'
       && lk != 91                  // 'castable'
       && lk != 95                  // 'collation'
       && lk != 100                 // 'contains'
       && lk != 106                 // 'count'
       && lk != 110                 // 'default'
       && lk != 114                 // 'descending'
       && lk != 119                 // 'div'
       && lk != 123                 // 'else'
       && lk != 124                 // 'empty'
       && lk != 127                 // 'end'
       && lk != 129                 // 'eq'
       && lk != 132                 // 'except'
       && lk != 139                 // 'for'
       && lk != 148                 // 'ge'
       && lk != 150                 // 'group'
       && lk != 152                 // 'gt'
       && lk != 153                 // 'idiv'
       && lk != 162                 // 'instance'
       && lk != 164                 // 'intersect'
       && lk != 165                 // 'into'
       && lk != 166                 // 'is'
       && lk != 175                 // 'le'
       && lk != 177                 // 'let'
       && lk != 181                 // 'lt'
       && lk != 183                 // 'mod'
       && lk != 184                 // 'modify'
       && lk != 189                 // 'ne'
       && lk != 202                 // 'only'
       && lk != 204                 // 'or'
       && lk != 205                 // 'order'
       && lk != 209                 // 'paragraphs'
       && lk != 224                 // 'return'
       && lk != 228                 // 'satisfies'
       && lk != 237                 // 'sentences'
       && lk != 241                 // 'stable'
       && lk != 242                 // 'start'
       && lk != 252                 // 'times'
       && lk != 253                 // 'to'
       && lk != 254                 // 'treat'
       && lk != 260                 // 'union'
       && lk != 272                 // 'where'
       && lk != 276                 // 'with'
       && lk != 279                 // 'words'
       && lk != 284                 // '|'
       && lk != 285                 // '||'
       && lk != 286                 // '|}'
       && lk != 287                 // '}'
       && lk != 2586                // '!' Wildcard
       && lk != 23578               // '!' '..'
       && lk != 24090               // '!' '/'
       && lk != 24602               // '!' '//'
       && lk != 34330)              // '!' '@'
      {
        lk = memoized(3, e0);
        if (lk == 0)
        {
          var b0A = b0; var e0A = e0; var l1A = l1;
          var b1A = b1; var e1A = e1; var l2A = l2;
          var b2A = b2; var e2A = e2;
          try
          {
            switch (l1)
            {
            case 47:                // '/'
              shiftT(47);           // '/'
              break;
            case 48:                // '//'
              shiftT(48);           // '//'
              break;
            default:
              shiftT(26);           // '!'
            }
            lookahead1W(264);       // Wildcard | EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral |
            try_StepExpr();
            memoize(3, e0A, -1);
            continue;
          }
          catch (p1A)
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            memoize(3, e0A, -2);
            break;
          }
        }
      }
      if (lk != -1
       && lk != 47                  // '/'
       && lk != 48                  // '//'
       && lk != 2586                // '!' Wildcard
       && lk != 23578               // '!' '..'
       && lk != 34330)              // '!' '@'
      {
        break;
      }
      switch (l1)
      {
      case 47:                      // '/'
        shiftT(47);                 // '/'
        break;
      case 48:                      // '//'
        shiftT(48);                 // '//'
        break;
      default:
        shiftT(26);                 // '!'
      }
      lookahead1W(264);             // Wildcard | EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral |
      try_StepExpr();
    }
  }

  function parse_StepExpr()
  {
    eventHandler.startNonterminal("StepExpr", e0);
    switch (l1)
    {
    case 83:                        // 'attribute'
      lookahead2W(288);             // EQName^Token | S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' |
      break;
    case 122:                       // 'element'
      lookahead2W(287);             // EQName^Token | S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' |
      break;
    case 187:                       // 'namespace'
    case 220:                       // 'processing-instruction'
      lookahead2W(285);             // NCName^Token | S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' |
      break;
    case 135:                       // 'false'
    case 197:                       // 'null'
    case 255:                       // 'true'
      lookahead2W(237);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '.' |
      break;
    case 97:                        // 'comment'
    case 120:                       // 'document'
    case 206:                       // 'ordered'
    case 249:                       // 'text'
    case 262:                       // 'unordered'
      lookahead2W(239);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' |
      break;
    case 79:                        // 'array'
    case 125:                       // 'empty-sequence'
    case 154:                       // 'if'
    case 167:                       // 'item'
    case 169:                       // 'json-item'
    case 247:                       // 'structured-item'
    case 248:                       // 'switch'
    case 259:                       // 'typeswitch'
      lookahead2W(230);             // S^WS | EOF | '!' | '!=' | '#' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' |
      break;
    case 74:                        // 'ancestor'
    case 75:                        // 'ancestor-or-self'
    case 94:                        // 'child'
    case 112:                       // 'descendant'
    case 113:                       // 'descendant-or-self'
    case 137:                       // 'following'
    case 138:                       // 'following-sibling'
    case 210:                       // 'parent'
    case 216:                       // 'preceding'
    case 217:                       // 'preceding-sibling'
    case 234:                       // 'self'
      lookahead2W(238);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' |
      break;
    case 6:                         // EQName^Token
    case 71:                        // 'after'
    case 73:                        // 'allowing'
    case 76:                        // 'and'
    case 78:                        // 'append'
    case 80:                        // 'as'
    case 81:                        // 'ascending'
    case 82:                        // 'at'
    case 84:                        // 'base-uri'
    case 85:                        // 'before'
    case 86:                        // 'boundary-space'
    case 87:                        // 'break'
    case 89:                        // 'case'
    case 90:                        // 'cast'
    case 91:                        // 'castable'
    case 92:                        // 'catch'
    case 95:                        // 'collation'
    case 98:                        // 'constraint'
    case 99:                        // 'construction'
    case 102:                       // 'context'
    case 103:                       // 'continue'
    case 104:                       // 'copy'
    case 105:                       // 'copy-namespaces'
    case 106:                       // 'count'
    case 107:                       // 'decimal-format'
    case 109:                       // 'declare'
    case 110:                       // 'default'
    case 111:                       // 'delete'
    case 114:                       // 'descending'
    case 119:                       // 'div'
    case 121:                       // 'document-node'
    case 123:                       // 'else'
    case 124:                       // 'empty'
    case 126:                       // 'encoding'
    case 127:                       // 'end'
    case 129:                       // 'eq'
    case 130:                       // 'every'
    case 132:                       // 'except'
    case 133:                       // 'exit'
    case 134:                       // 'external'
    case 136:                       // 'first'
    case 139:                       // 'for'
    case 142:                       // 'from'
    case 143:                       // 'ft-option'
    case 147:                       // 'function'
    case 148:                       // 'ge'
    case 150:                       // 'group'
    case 152:                       // 'gt'
    case 153:                       // 'idiv'
    case 155:                       // 'import'
    case 156:                       // 'in'
    case 157:                       // 'index'
    case 161:                       // 'insert'
    case 162:                       // 'instance'
    case 163:                       // 'integrity'
    case 164:                       // 'intersect'
    case 165:                       // 'into'
    case 166:                       // 'is'
    case 168:                       // 'json'
    case 170:                       // 'jsoniq'
    case 173:                       // 'last'
    case 174:                       // 'lax'
    case 175:                       // 'le'
    case 177:                       // 'let'
    case 179:                       // 'loop'
    case 181:                       // 'lt'
    case 183:                       // 'mod'
    case 184:                       // 'modify'
    case 185:                       // 'module'
    case 188:                       // 'namespace-node'
    case 189:                       // 'ne'
    case 194:                       // 'node'
    case 195:                       // 'nodes'
    case 198:                       // 'object'
    case 202:                       // 'only'
    case 203:                       // 'option'
    case 204:                       // 'or'
    case 205:                       // 'order'
    case 207:                       // 'ordering'
    case 222:                       // 'rename'
    case 223:                       // 'replace'
    case 224:                       // 'return'
    case 225:                       // 'returning'
    case 226:                       // 'revalidation'
    case 228:                       // 'satisfies'
    case 229:                       // 'schema'
    case 230:                       // 'schema-attribute'
    case 231:                       // 'schema-element'
    case 232:                       // 'score'
    case 233:                       // 'select'
    case 239:                       // 'sliding'
    case 240:                       // 'some'
    case 241:                       // 'stable'
    case 242:                       // 'start'
    case 245:                       // 'strict'
    case 253:                       // 'to'
    case 254:                       // 'treat'
    case 256:                       // 'try'
    case 257:                       // 'tumbling'
    case 258:                       // 'type'
    case 260:                       // 'union'
    case 263:                       // 'updating'
    case 266:                       // 'validate'
    case 267:                       // 'value'
    case 268:                       // 'variable'
    case 269:                       // 'version'
    case 272:                       // 'where'
    case 273:                       // 'while'
    case 276:                       // 'with'
      lookahead2W(234);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' |
      break;
    default:
      lk = l1;
    }
    if (lk == 12935                 // 'false' EOF
     || lk == 12997                 // 'null' EOF
     || lk == 13055                 // 'true' EOF
     || lk == 13447                 // 'false' '!'
     || lk == 13509                 // 'null' '!'
     || lk == 13567                 // 'true' '!'
     || lk == 13959                 // 'false' '!='
     || lk == 14021                 // 'null' '!='
     || lk == 14079                 // 'true' '!='
     || lk == 19591                 // 'false' ')'
     || lk == 19653                 // 'null' ')'
     || lk == 19711                 // 'true' ')'
     || lk == 20103                 // 'false' '*'
     || lk == 20165                 // 'null' '*'
     || lk == 20223                 // 'true' '*'
     || lk == 21127                 // 'false' '+'
     || lk == 21189                 // 'null' '+'
     || lk == 21247                 // 'true' '+'
     || lk == 21639                 // 'false' ','
     || lk == 21701                 // 'null' ','
     || lk == 21759                 // 'true' ','
     || lk == 22151                 // 'false' '-'
     || lk == 22213                 // 'null' '-'
     || lk == 22271                 // 'true' '-'
     || lk == 24199                 // 'false' '/'
     || lk == 24261                 // 'null' '/'
     || lk == 24319                 // 'true' '/'
     || lk == 24711                 // 'false' '//'
     || lk == 24773                 // 'null' '//'
     || lk == 24831                 // 'true' '//'
     || lk == 25735                 // 'false' ':'
     || lk == 25797                 // 'null' ':'
     || lk == 25855                 // 'true' ':'
     || lk == 27783                 // 'false' ';'
     || lk == 27845                 // 'null' ';'
     || lk == 27903                 // 'true' ';'
     || lk == 28295                 // 'false' '<'
     || lk == 28357                 // 'null' '<'
     || lk == 28415                 // 'true' '<'
     || lk == 29831                 // 'false' '<<'
     || lk == 29893                 // 'null' '<<'
     || lk == 29951                 // 'true' '<<'
     || lk == 30343                 // 'false' '<='
     || lk == 30405                 // 'null' '<='
     || lk == 30463                 // 'true' '<='
     || lk == 31367                 // 'false' '='
     || lk == 31429                 // 'null' '='
     || lk == 31487                 // 'true' '='
     || lk == 31879                 // 'false' '>'
     || lk == 31941                 // 'null' '>'
     || lk == 31999                 // 'true' '>'
     || lk == 32391                 // 'false' '>='
     || lk == 32453                 // 'null' '>='
     || lk == 32511                 // 'true' '>='
     || lk == 32903                 // 'false' '>>'
     || lk == 32965                 // 'null' '>>'
     || lk == 33023                 // 'true' '>>'
     || lk == 35463                 // 'false' '['
     || lk == 35525                 // 'null' '['
     || lk == 35583                 // 'true' '['
     || lk == 35975                 // 'false' ']'
     || lk == 36037                 // 'null' ']'
     || lk == 36095                 // 'true' ']'
     || lk == 36435                 // 'attribute' 'after'
     || lk == 36474                 // 'element' 'after'
     || lk == 36487                 // 'false' 'after'
     || lk == 36539                 // 'namespace' 'after'
     || lk == 36549                 // 'null' 'after'
     || lk == 36572                 // 'processing-instruction' 'after'
     || lk == 36607                 // 'true' 'after'
     || lk == 38995                 // 'attribute' 'and'
     || lk == 39034                 // 'element' 'and'
     || lk == 39047                 // 'false' 'and'
     || lk == 39099                 // 'namespace' 'and'
     || lk == 39109                 // 'null' 'and'
     || lk == 39132                 // 'processing-instruction' 'and'
     || lk == 39167                 // 'true' 'and'
     || lk == 41043                 // 'attribute' 'as'
     || lk == 41082                 // 'element' 'as'
     || lk == 41095                 // 'false' 'as'
     || lk == 41147                 // 'namespace' 'as'
     || lk == 41157                 // 'null' 'as'
     || lk == 41180                 // 'processing-instruction' 'as'
     || lk == 41215                 // 'true' 'as'
     || lk == 41555                 // 'attribute' 'ascending'
     || lk == 41594                 // 'element' 'ascending'
     || lk == 41607                 // 'false' 'ascending'
     || lk == 41659                 // 'namespace' 'ascending'
     || lk == 41669                 // 'null' 'ascending'
     || lk == 41692                 // 'processing-instruction' 'ascending'
     || lk == 41727                 // 'true' 'ascending'
     || lk == 42067                 // 'attribute' 'at'
     || lk == 42106                 // 'element' 'at'
     || lk == 42119                 // 'false' 'at'
     || lk == 42171                 // 'namespace' 'at'
     || lk == 42181                 // 'null' 'at'
     || lk == 42204                 // 'processing-instruction' 'at'
     || lk == 42239                 // 'true' 'at'
     || lk == 43603                 // 'attribute' 'before'
     || lk == 43642                 // 'element' 'before'
     || lk == 43655                 // 'false' 'before'
     || lk == 43707                 // 'namespace' 'before'
     || lk == 43717                 // 'null' 'before'
     || lk == 43740                 // 'processing-instruction' 'before'
     || lk == 43775                 // 'true' 'before'
     || lk == 45191                 // 'false' 'by'
     || lk == 45253                 // 'null' 'by'
     || lk == 45311                 // 'true' 'by'
     || lk == 45651                 // 'attribute' 'case'
     || lk == 45690                 // 'element' 'case'
     || lk == 45703                 // 'false' 'case'
     || lk == 45755                 // 'namespace' 'case'
     || lk == 45765                 // 'null' 'case'
     || lk == 45788                 // 'processing-instruction' 'case'
     || lk == 45823                 // 'true' 'case'
     || lk == 46163                 // 'attribute' 'cast'
     || lk == 46202                 // 'element' 'cast'
     || lk == 46215                 // 'false' 'cast'
     || lk == 46267                 // 'namespace' 'cast'
     || lk == 46277                 // 'null' 'cast'
     || lk == 46300                 // 'processing-instruction' 'cast'
     || lk == 46335                 // 'true' 'cast'
     || lk == 46675                 // 'attribute' 'castable'
     || lk == 46714                 // 'element' 'castable'
     || lk == 46727                 // 'false' 'castable'
     || lk == 46779                 // 'namespace' 'castable'
     || lk == 46789                 // 'null' 'castable'
     || lk == 46812                 // 'processing-instruction' 'castable'
     || lk == 46847                 // 'true' 'castable'
     || lk == 48723                 // 'attribute' 'collation'
     || lk == 48762                 // 'element' 'collation'
     || lk == 48775                 // 'false' 'collation'
     || lk == 48827                 // 'namespace' 'collation'
     || lk == 48837                 // 'null' 'collation'
     || lk == 48860                 // 'processing-instruction' 'collation'
     || lk == 48895                 // 'true' 'collation'
     || lk == 51335                 // 'false' 'contains'
     || lk == 51397                 // 'null' 'contains'
     || lk == 51455                 // 'true' 'contains'
     || lk == 54355                 // 'attribute' 'count'
     || lk == 54394                 // 'element' 'count'
     || lk == 54407                 // 'false' 'count'
     || lk == 54459                 // 'namespace' 'count'
     || lk == 54469                 // 'null' 'count'
     || lk == 54492                 // 'processing-instruction' 'count'
     || lk == 54527                 // 'true' 'count'
     || lk == 56403                 // 'attribute' 'default'
     || lk == 56442                 // 'element' 'default'
     || lk == 56455                 // 'false' 'default'
     || lk == 56507                 // 'namespace' 'default'
     || lk == 56517                 // 'null' 'default'
     || lk == 56540                 // 'processing-instruction' 'default'
     || lk == 56575                 // 'true' 'default'
     || lk == 58451                 // 'attribute' 'descending'
     || lk == 58490                 // 'element' 'descending'
     || lk == 58503                 // 'false' 'descending'
     || lk == 58555                 // 'namespace' 'descending'
     || lk == 58565                 // 'null' 'descending'
     || lk == 58588                 // 'processing-instruction' 'descending'
     || lk == 58623                 // 'true' 'descending'
     || lk == 61011                 // 'attribute' 'div'
     || lk == 61050                 // 'element' 'div'
     || lk == 61063                 // 'false' 'div'
     || lk == 61115                 // 'namespace' 'div'
     || lk == 61125                 // 'null' 'div'
     || lk == 61148                 // 'processing-instruction' 'div'
     || lk == 61183                 // 'true' 'div'
     || lk == 63059                 // 'attribute' 'else'
     || lk == 63098                 // 'element' 'else'
     || lk == 63111                 // 'false' 'else'
     || lk == 63163                 // 'namespace' 'else'
     || lk == 63173                 // 'null' 'else'
     || lk == 63196                 // 'processing-instruction' 'else'
     || lk == 63231                 // 'true' 'else'
     || lk == 63571                 // 'attribute' 'empty'
     || lk == 63610                 // 'element' 'empty'
     || lk == 63623                 // 'false' 'empty'
     || lk == 63675                 // 'namespace' 'empty'
     || lk == 63685                 // 'null' 'empty'
     || lk == 63708                 // 'processing-instruction' 'empty'
     || lk == 63743                 // 'true' 'empty'
     || lk == 65107                 // 'attribute' 'end'
     || lk == 65146                 // 'element' 'end'
     || lk == 65159                 // 'false' 'end'
     || lk == 65211                 // 'namespace' 'end'
     || lk == 65221                 // 'null' 'end'
     || lk == 65244                 // 'processing-instruction' 'end'
     || lk == 65279                 // 'true' 'end'
     || lk == 66131                 // 'attribute' 'eq'
     || lk == 66170                 // 'element' 'eq'
     || lk == 66183                 // 'false' 'eq'
     || lk == 66235                 // 'namespace' 'eq'
     || lk == 66245                 // 'null' 'eq'
     || lk == 66268                 // 'processing-instruction' 'eq'
     || lk == 66303                 // 'true' 'eq'
     || lk == 67667                 // 'attribute' 'except'
     || lk == 67706                 // 'element' 'except'
     || lk == 67719                 // 'false' 'except'
     || lk == 67771                 // 'namespace' 'except'
     || lk == 67781                 // 'null' 'except'
     || lk == 67804                 // 'processing-instruction' 'except'
     || lk == 67839                 // 'true' 'except'
     || lk == 71251                 // 'attribute' 'for'
     || lk == 71290                 // 'element' 'for'
     || lk == 71303                 // 'false' 'for'
     || lk == 71355                 // 'namespace' 'for'
     || lk == 71365                 // 'null' 'for'
     || lk == 71388                 // 'processing-instruction' 'for'
     || lk == 71423                 // 'true' 'for'
     || lk == 75859                 // 'attribute' 'ge'
     || lk == 75898                 // 'element' 'ge'
     || lk == 75911                 // 'false' 'ge'
     || lk == 75963                 // 'namespace' 'ge'
     || lk == 75973                 // 'null' 'ge'
     || lk == 75996                 // 'processing-instruction' 'ge'
     || lk == 76031                 // 'true' 'ge'
     || lk == 76883                 // 'attribute' 'group'
     || lk == 76922                 // 'element' 'group'
     || lk == 76935                 // 'false' 'group'
     || lk == 76987                 // 'namespace' 'group'
     || lk == 76997                 // 'null' 'group'
     || lk == 77020                 // 'processing-instruction' 'group'
     || lk == 77055                 // 'true' 'group'
     || lk == 77907                 // 'attribute' 'gt'
     || lk == 77946                 // 'element' 'gt'
     || lk == 77959                 // 'false' 'gt'
     || lk == 78011                 // 'namespace' 'gt'
     || lk == 78021                 // 'null' 'gt'
     || lk == 78044                 // 'processing-instruction' 'gt'
     || lk == 78079                 // 'true' 'gt'
     || lk == 78419                 // 'attribute' 'idiv'
     || lk == 78458                 // 'element' 'idiv'
     || lk == 78471                 // 'false' 'idiv'
     || lk == 78523                 // 'namespace' 'idiv'
     || lk == 78533                 // 'null' 'idiv'
     || lk == 78556                 // 'processing-instruction' 'idiv'
     || lk == 78591                 // 'true' 'idiv'
     || lk == 83027                 // 'attribute' 'instance'
     || lk == 83066                 // 'element' 'instance'
     || lk == 83079                 // 'false' 'instance'
     || lk == 83131                 // 'namespace' 'instance'
     || lk == 83141                 // 'null' 'instance'
     || lk == 83164                 // 'processing-instruction' 'instance'
     || lk == 83199                 // 'true' 'instance'
     || lk == 84051                 // 'attribute' 'intersect'
     || lk == 84090                 // 'element' 'intersect'
     || lk == 84103                 // 'false' 'intersect'
     || lk == 84155                 // 'namespace' 'intersect'
     || lk == 84165                 // 'null' 'intersect'
     || lk == 84188                 // 'processing-instruction' 'intersect'
     || lk == 84223                 // 'true' 'intersect'
     || lk == 84563                 // 'attribute' 'into'
     || lk == 84602                 // 'element' 'into'
     || lk == 84615                 // 'false' 'into'
     || lk == 84667                 // 'namespace' 'into'
     || lk == 84677                 // 'null' 'into'
     || lk == 84700                 // 'processing-instruction' 'into'
     || lk == 84735                 // 'true' 'into'
     || lk == 85075                 // 'attribute' 'is'
     || lk == 85114                 // 'element' 'is'
     || lk == 85127                 // 'false' 'is'
     || lk == 85179                 // 'namespace' 'is'
     || lk == 85189                 // 'null' 'is'
     || lk == 85212                 // 'processing-instruction' 'is'
     || lk == 85247                 // 'true' 'is'
     || lk == 89683                 // 'attribute' 'le'
     || lk == 89722                 // 'element' 'le'
     || lk == 89735                 // 'false' 'le'
     || lk == 89787                 // 'namespace' 'le'
     || lk == 89797                 // 'null' 'le'
     || lk == 89820                 // 'processing-instruction' 'le'
     || lk == 89855                 // 'true' 'le'
     || lk == 90707                 // 'attribute' 'let'
     || lk == 90746                 // 'element' 'let'
     || lk == 90759                 // 'false' 'let'
     || lk == 90811                 // 'namespace' 'let'
     || lk == 90821                 // 'null' 'let'
     || lk == 90844                 // 'processing-instruction' 'let'
     || lk == 90879                 // 'true' 'let'
     || lk == 92755                 // 'attribute' 'lt'
     || lk == 92794                 // 'element' 'lt'
     || lk == 92807                 // 'false' 'lt'
     || lk == 92859                 // 'namespace' 'lt'
     || lk == 92869                 // 'null' 'lt'
     || lk == 92892                 // 'processing-instruction' 'lt'
     || lk == 92927                 // 'true' 'lt'
     || lk == 93779                 // 'attribute' 'mod'
     || lk == 93818                 // 'element' 'mod'
     || lk == 93831                 // 'false' 'mod'
     || lk == 93883                 // 'namespace' 'mod'
     || lk == 93893                 // 'null' 'mod'
     || lk == 93916                 // 'processing-instruction' 'mod'
     || lk == 93951                 // 'true' 'mod'
     || lk == 94291                 // 'attribute' 'modify'
     || lk == 94330                 // 'element' 'modify'
     || lk == 94343                 // 'false' 'modify'
     || lk == 94395                 // 'namespace' 'modify'
     || lk == 94405                 // 'null' 'modify'
     || lk == 94428                 // 'processing-instruction' 'modify'
     || lk == 94463                 // 'true' 'modify'
     || lk == 96851                 // 'attribute' 'ne'
     || lk == 96890                 // 'element' 'ne'
     || lk == 96903                 // 'false' 'ne'
     || lk == 96955                 // 'namespace' 'ne'
     || lk == 96965                 // 'null' 'ne'
     || lk == 96988                 // 'processing-instruction' 'ne'
     || lk == 97023                 // 'true' 'ne'
     || lk == 103507                // 'attribute' 'only'
     || lk == 103546                // 'element' 'only'
     || lk == 103559                // 'false' 'only'
     || lk == 103611                // 'namespace' 'only'
     || lk == 103621                // 'null' 'only'
     || lk == 103644                // 'processing-instruction' 'only'
     || lk == 103679                // 'true' 'only'
     || lk == 104531                // 'attribute' 'or'
     || lk == 104570                // 'element' 'or'
     || lk == 104583                // 'false' 'or'
     || lk == 104635                // 'namespace' 'or'
     || lk == 104645                // 'null' 'or'
     || lk == 104668                // 'processing-instruction' 'or'
     || lk == 104703                // 'true' 'or'
     || lk == 105043                // 'attribute' 'order'
     || lk == 105082                // 'element' 'order'
     || lk == 105095                // 'false' 'order'
     || lk == 105147                // 'namespace' 'order'
     || lk == 105157                // 'null' 'order'
     || lk == 105180                // 'processing-instruction' 'order'
     || lk == 105215                // 'true' 'order'
     || lk == 107143                // 'false' 'paragraphs'
     || lk == 107205                // 'null' 'paragraphs'
     || lk == 107263                // 'true' 'paragraphs'
     || lk == 114771                // 'attribute' 'return'
     || lk == 114810                // 'element' 'return'
     || lk == 114823                // 'false' 'return'
     || lk == 114875                // 'namespace' 'return'
     || lk == 114885                // 'null' 'return'
     || lk == 114908                // 'processing-instruction' 'return'
     || lk == 114943                // 'true' 'return'
     || lk == 116819                // 'attribute' 'satisfies'
     || lk == 116858                // 'element' 'satisfies'
     || lk == 116871                // 'false' 'satisfies'
     || lk == 116923                // 'namespace' 'satisfies'
     || lk == 116933                // 'null' 'satisfies'
     || lk == 116956                // 'processing-instruction' 'satisfies'
     || lk == 116991                // 'true' 'satisfies'
     || lk == 121479                // 'false' 'sentences'
     || lk == 121541                // 'null' 'sentences'
     || lk == 121599                // 'true' 'sentences'
     || lk == 123475                // 'attribute' 'stable'
     || lk == 123514                // 'element' 'stable'
     || lk == 123527                // 'false' 'stable'
     || lk == 123579                // 'namespace' 'stable'
     || lk == 123589                // 'null' 'stable'
     || lk == 123612                // 'processing-instruction' 'stable'
     || lk == 123647                // 'true' 'stable'
     || lk == 123987                // 'attribute' 'start'
     || lk == 124026                // 'element' 'start'
     || lk == 124039                // 'false' 'start'
     || lk == 124091                // 'namespace' 'start'
     || lk == 124101                // 'null' 'start'
     || lk == 124124                // 'processing-instruction' 'start'
     || lk == 124159                // 'true' 'start'
     || lk == 129159                // 'false' 'times'
     || lk == 129221                // 'null' 'times'
     || lk == 129279                // 'true' 'times'
     || lk == 129619                // 'attribute' 'to'
     || lk == 129658                // 'element' 'to'
     || lk == 129671                // 'false' 'to'
     || lk == 129723                // 'namespace' 'to'
     || lk == 129733                // 'null' 'to'
     || lk == 129756                // 'processing-instruction' 'to'
     || lk == 129791                // 'true' 'to'
     || lk == 130131                // 'attribute' 'treat'
     || lk == 130170                // 'element' 'treat'
     || lk == 130183                // 'false' 'treat'
     || lk == 130235                // 'namespace' 'treat'
     || lk == 130245                // 'null' 'treat'
     || lk == 130268                // 'processing-instruction' 'treat'
     || lk == 130303                // 'true' 'treat'
     || lk == 133203                // 'attribute' 'union'
     || lk == 133242                // 'element' 'union'
     || lk == 133255                // 'false' 'union'
     || lk == 133307                // 'namespace' 'union'
     || lk == 133317                // 'null' 'union'
     || lk == 133340                // 'processing-instruction' 'union'
     || lk == 133375                // 'true' 'union'
     || lk == 139347                // 'attribute' 'where'
     || lk == 139386                // 'element' 'where'
     || lk == 139399                // 'false' 'where'
     || lk == 139451                // 'namespace' 'where'
     || lk == 139461                // 'null' 'where'
     || lk == 139484                // 'processing-instruction' 'where'
     || lk == 139519                // 'true' 'where'
     || lk == 141395                // 'attribute' 'with'
     || lk == 141434                // 'element' 'with'
     || lk == 141447                // 'false' 'with'
     || lk == 141499                // 'namespace' 'with'
     || lk == 141509                // 'null' 'with'
     || lk == 141532                // 'processing-instruction' 'with'
     || lk == 141567                // 'true' 'with'
     || lk == 142983                // 'false' 'words'
     || lk == 143045                // 'null' 'words'
     || lk == 143103                // 'true' 'words'
     || lk == 145543                // 'false' '|'
     || lk == 145605                // 'null' '|'
     || lk == 145663                // 'true' '|'
     || lk == 146055                // 'false' '||'
     || lk == 146117                // 'null' '||'
     || lk == 146175                // 'true' '||'
     || lk == 146567                // 'false' '|}'
     || lk == 146629                // 'null' '|}'
     || lk == 146687                // 'true' '|}'
     || lk == 147079                // 'false' '}'
     || lk == 147141                // 'null' '}'
     || lk == 147199)               // 'true' '}'
    {
      lk = memoized(4, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_PostfixExpr();
          lk = -1;
        }
        catch (p1A)
        {
          lk = -2;
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(4, e0, lk);
      }
    }
    switch (lk)
    {
    case -1:
    case 8:                         // IntegerLiteral
    case 9:                         // DecimalLiteral
    case 10:                        // DoubleLiteral
    case 11:                        // StringLiteral
    case 31:                        // '$'
    case 32:                        // '$$'
    case 33:                        // '%'
    case 35:                        // '('
    case 55:                        // '<'
    case 56:                        // '<!--'
    case 60:                        // '<?'
    case 69:                        // '['
    case 281:                       // '{'
    case 283:                       // '{|'
    case 3155:                      // 'attribute' EQName^Token
    case 3194:                      // 'element' EQName^Token
    case 9915:                      // 'namespace' NCName^Token
    case 9948:                      // 'processing-instruction' NCName^Token
    case 14854:                     // EQName^Token '#'
    case 14919:                     // 'after' '#'
    case 14921:                     // 'allowing' '#'
    case 14922:                     // 'ancestor' '#'
    case 14923:                     // 'ancestor-or-self' '#'
    case 14924:                     // 'and' '#'
    case 14926:                     // 'append' '#'
    case 14927:                     // 'array' '#'
    case 14928:                     // 'as' '#'
    case 14929:                     // 'ascending' '#'
    case 14930:                     // 'at' '#'
    case 14931:                     // 'attribute' '#'
    case 14932:                     // 'base-uri' '#'
    case 14933:                     // 'before' '#'
    case 14934:                     // 'boundary-space' '#'
    case 14935:                     // 'break' '#'
    case 14937:                     // 'case' '#'
    case 14938:                     // 'cast' '#'
    case 14939:                     // 'castable' '#'
    case 14940:                     // 'catch' '#'
    case 14942:                     // 'child' '#'
    case 14943:                     // 'collation' '#'
    case 14945:                     // 'comment' '#'
    case 14946:                     // 'constraint' '#'
    case 14947:                     // 'construction' '#'
    case 14950:                     // 'context' '#'
    case 14951:                     // 'continue' '#'
    case 14952:                     // 'copy' '#'
    case 14953:                     // 'copy-namespaces' '#'
    case 14954:                     // 'count' '#'
    case 14955:                     // 'decimal-format' '#'
    case 14957:                     // 'declare' '#'
    case 14958:                     // 'default' '#'
    case 14959:                     // 'delete' '#'
    case 14960:                     // 'descendant' '#'
    case 14961:                     // 'descendant-or-self' '#'
    case 14962:                     // 'descending' '#'
    case 14967:                     // 'div' '#'
    case 14968:                     // 'document' '#'
    case 14969:                     // 'document-node' '#'
    case 14970:                     // 'element' '#'
    case 14971:                     // 'else' '#'
    case 14972:                     // 'empty' '#'
    case 14973:                     // 'empty-sequence' '#'
    case 14974:                     // 'encoding' '#'
    case 14975:                     // 'end' '#'
    case 14977:                     // 'eq' '#'
    case 14978:                     // 'every' '#'
    case 14980:                     // 'except' '#'
    case 14981:                     // 'exit' '#'
    case 14982:                     // 'external' '#'
    case 14983:                     // 'false' '#'
    case 14984:                     // 'first' '#'
    case 14985:                     // 'following' '#'
    case 14986:                     // 'following-sibling' '#'
    case 14987:                     // 'for' '#'
    case 14990:                     // 'from' '#'
    case 14991:                     // 'ft-option' '#'
    case 14995:                     // 'function' '#'
    case 14996:                     // 'ge' '#'
    case 14998:                     // 'group' '#'
    case 15000:                     // 'gt' '#'
    case 15001:                     // 'idiv' '#'
    case 15002:                     // 'if' '#'
    case 15003:                     // 'import' '#'
    case 15004:                     // 'in' '#'
    case 15005:                     // 'index' '#'
    case 15009:                     // 'insert' '#'
    case 15010:                     // 'instance' '#'
    case 15011:                     // 'integrity' '#'
    case 15012:                     // 'intersect' '#'
    case 15013:                     // 'into' '#'
    case 15014:                     // 'is' '#'
    case 15015:                     // 'item' '#'
    case 15016:                     // 'json' '#'
    case 15017:                     // 'json-item' '#'
    case 15018:                     // 'jsoniq' '#'
    case 15021:                     // 'last' '#'
    case 15022:                     // 'lax' '#'
    case 15023:                     // 'le' '#'
    case 15025:                     // 'let' '#'
    case 15027:                     // 'loop' '#'
    case 15029:                     // 'lt' '#'
    case 15031:                     // 'mod' '#'
    case 15032:                     // 'modify' '#'
    case 15033:                     // 'module' '#'
    case 15035:                     // 'namespace' '#'
    case 15036:                     // 'namespace-node' '#'
    case 15037:                     // 'ne' '#'
    case 15042:                     // 'node' '#'
    case 15043:                     // 'nodes' '#'
    case 15045:                     // 'null' '#'
    case 15046:                     // 'object' '#'
    case 15050:                     // 'only' '#'
    case 15051:                     // 'option' '#'
    case 15052:                     // 'or' '#'
    case 15053:                     // 'order' '#'
    case 15054:                     // 'ordered' '#'
    case 15055:                     // 'ordering' '#'
    case 15058:                     // 'parent' '#'
    case 15064:                     // 'preceding' '#'
    case 15065:                     // 'preceding-sibling' '#'
    case 15068:                     // 'processing-instruction' '#'
    case 15070:                     // 'rename' '#'
    case 15071:                     // 'replace' '#'
    case 15072:                     // 'return' '#'
    case 15073:                     // 'returning' '#'
    case 15074:                     // 'revalidation' '#'
    case 15076:                     // 'satisfies' '#'
    case 15077:                     // 'schema' '#'
    case 15078:                     // 'schema-attribute' '#'
    case 15079:                     // 'schema-element' '#'
    case 15080:                     // 'score' '#'
    case 15081:                     // 'select' '#'
    case 15082:                     // 'self' '#'
    case 15087:                     // 'sliding' '#'
    case 15088:                     // 'some' '#'
    case 15089:                     // 'stable' '#'
    case 15090:                     // 'start' '#'
    case 15093:                     // 'strict' '#'
    case 15095:                     // 'structured-item' '#'
    case 15096:                     // 'switch' '#'
    case 15097:                     // 'text' '#'
    case 15101:                     // 'to' '#'
    case 15102:                     // 'treat' '#'
    case 15103:                     // 'true' '#'
    case 15104:                     // 'try' '#'
    case 15105:                     // 'tumbling' '#'
    case 15106:                     // 'type' '#'
    case 15107:                     // 'typeswitch' '#'
    case 15108:                     // 'union' '#'
    case 15110:                     // 'unordered' '#'
    case 15111:                     // 'updating' '#'
    case 15114:                     // 'validate' '#'
    case 15115:                     // 'value' '#'
    case 15116:                     // 'variable' '#'
    case 15117:                     // 'version' '#'
    case 15120:                     // 'where' '#'
    case 15121:                     // 'while' '#'
    case 15124:                     // 'with' '#'
    case 17926:                     // EQName^Token '('
    case 17991:                     // 'after' '('
    case 17993:                     // 'allowing' '('
    case 17994:                     // 'ancestor' '('
    case 17995:                     // 'ancestor-or-self' '('
    case 17996:                     // 'and' '('
    case 17998:                     // 'append' '('
    case 18000:                     // 'as' '('
    case 18001:                     // 'ascending' '('
    case 18002:                     // 'at' '('
    case 18004:                     // 'base-uri' '('
    case 18005:                     // 'before' '('
    case 18006:                     // 'boundary-space' '('
    case 18007:                     // 'break' '('
    case 18009:                     // 'case' '('
    case 18010:                     // 'cast' '('
    case 18011:                     // 'castable' '('
    case 18012:                     // 'catch' '('
    case 18014:                     // 'child' '('
    case 18015:                     // 'collation' '('
    case 18018:                     // 'constraint' '('
    case 18019:                     // 'construction' '('
    case 18022:                     // 'context' '('
    case 18023:                     // 'continue' '('
    case 18024:                     // 'copy' '('
    case 18025:                     // 'copy-namespaces' '('
    case 18026:                     // 'count' '('
    case 18027:                     // 'decimal-format' '('
    case 18029:                     // 'declare' '('
    case 18030:                     // 'default' '('
    case 18031:                     // 'delete' '('
    case 18032:                     // 'descendant' '('
    case 18033:                     // 'descendant-or-self' '('
    case 18034:                     // 'descending' '('
    case 18039:                     // 'div' '('
    case 18040:                     // 'document' '('
    case 18043:                     // 'else' '('
    case 18044:                     // 'empty' '('
    case 18046:                     // 'encoding' '('
    case 18047:                     // 'end' '('
    case 18049:                     // 'eq' '('
    case 18050:                     // 'every' '('
    case 18052:                     // 'except' '('
    case 18053:                     // 'exit' '('
    case 18054:                     // 'external' '('
    case 18055:                     // 'false' '('
    case 18056:                     // 'first' '('
    case 18057:                     // 'following' '('
    case 18058:                     // 'following-sibling' '('
    case 18059:                     // 'for' '('
    case 18062:                     // 'from' '('
    case 18063:                     // 'ft-option' '('
    case 18067:                     // 'function' '('
    case 18068:                     // 'ge' '('
    case 18070:                     // 'group' '('
    case 18072:                     // 'gt' '('
    case 18073:                     // 'idiv' '('
    case 18075:                     // 'import' '('
    case 18076:                     // 'in' '('
    case 18077:                     // 'index' '('
    case 18081:                     // 'insert' '('
    case 18082:                     // 'instance' '('
    case 18083:                     // 'integrity' '('
    case 18084:                     // 'intersect' '('
    case 18085:                     // 'into' '('
    case 18086:                     // 'is' '('
    case 18088:                     // 'json' '('
    case 18090:                     // 'jsoniq' '('
    case 18093:                     // 'last' '('
    case 18094:                     // 'lax' '('
    case 18095:                     // 'le' '('
    case 18097:                     // 'let' '('
    case 18099:                     // 'loop' '('
    case 18101:                     // 'lt' '('
    case 18103:                     // 'mod' '('
    case 18104:                     // 'modify' '('
    case 18105:                     // 'module' '('
    case 18107:                     // 'namespace' '('
    case 18109:                     // 'ne' '('
    case 18115:                     // 'nodes' '('
    case 18117:                     // 'null' '('
    case 18118:                     // 'object' '('
    case 18122:                     // 'only' '('
    case 18123:                     // 'option' '('
    case 18124:                     // 'or' '('
    case 18125:                     // 'order' '('
    case 18126:                     // 'ordered' '('
    case 18127:                     // 'ordering' '('
    case 18130:                     // 'parent' '('
    case 18136:                     // 'preceding' '('
    case 18137:                     // 'preceding-sibling' '('
    case 18142:                     // 'rename' '('
    case 18143:                     // 'replace' '('
    case 18144:                     // 'return' '('
    case 18145:                     // 'returning' '('
    case 18146:                     // 'revalidation' '('
    case 18148:                     // 'satisfies' '('
    case 18149:                     // 'schema' '('
    case 18152:                     // 'score' '('
    case 18153:                     // 'select' '('
    case 18154:                     // 'self' '('
    case 18159:                     // 'sliding' '('
    case 18160:                     // 'some' '('
    case 18161:                     // 'stable' '('
    case 18162:                     // 'start' '('
    case 18165:                     // 'strict' '('
    case 18173:                     // 'to' '('
    case 18174:                     // 'treat' '('
    case 18175:                     // 'true' '('
    case 18176:                     // 'try' '('
    case 18177:                     // 'tumbling' '('
    case 18178:                     // 'type' '('
    case 18180:                     // 'union' '('
    case 18182:                     // 'unordered' '('
    case 18183:                     // 'updating' '('
    case 18186:                     // 'validate' '('
    case 18187:                     // 'value' '('
    case 18188:                     // 'variable' '('
    case 18189:                     // 'version' '('
    case 18192:                     // 'where' '('
    case 18193:                     // 'while' '('
    case 18196:                     // 'with' '('
    case 23175:                     // 'false' '.'
    case 23237:                     // 'null' '.'
    case 23295:                     // 'true' '.'
    case 37459:                     // 'attribute' 'allowing'
    case 37498:                     // 'element' 'allowing'
    case 37563:                     // 'namespace' 'allowing'
    case 37596:                     // 'processing-instruction' 'allowing'
    case 37971:                     // 'attribute' 'ancestor'
    case 38010:                     // 'element' 'ancestor'
    case 38075:                     // 'namespace' 'ancestor'
    case 38108:                     // 'processing-instruction' 'ancestor'
    case 38483:                     // 'attribute' 'ancestor-or-self'
    case 38522:                     // 'element' 'ancestor-or-self'
    case 38587:                     // 'namespace' 'ancestor-or-self'
    case 38620:                     // 'processing-instruction' 'ancestor-or-self'
    case 40019:                     // 'attribute' 'append'
    case 40058:                     // 'element' 'append'
    case 40123:                     // 'namespace' 'append'
    case 40156:                     // 'processing-instruction' 'append'
    case 40531:                     // 'attribute' 'array'
    case 40570:                     // 'element' 'array'
    case 42579:                     // 'attribute' 'attribute'
    case 42618:                     // 'element' 'attribute'
    case 42683:                     // 'namespace' 'attribute'
    case 42716:                     // 'processing-instruction' 'attribute'
    case 43091:                     // 'attribute' 'base-uri'
    case 43130:                     // 'element' 'base-uri'
    case 43195:                     // 'namespace' 'base-uri'
    case 43228:                     // 'processing-instruction' 'base-uri'
    case 44115:                     // 'attribute' 'boundary-space'
    case 44154:                     // 'element' 'boundary-space'
    case 44219:                     // 'namespace' 'boundary-space'
    case 44252:                     // 'processing-instruction' 'boundary-space'
    case 44627:                     // 'attribute' 'break'
    case 44666:                     // 'element' 'break'
    case 44731:                     // 'namespace' 'break'
    case 44764:                     // 'processing-instruction' 'break'
    case 47187:                     // 'attribute' 'catch'
    case 47226:                     // 'element' 'catch'
    case 47291:                     // 'namespace' 'catch'
    case 47324:                     // 'processing-instruction' 'catch'
    case 48211:                     // 'attribute' 'child'
    case 48250:                     // 'element' 'child'
    case 48315:                     // 'namespace' 'child'
    case 48348:                     // 'processing-instruction' 'child'
    case 49747:                     // 'attribute' 'comment'
    case 49786:                     // 'element' 'comment'
    case 49851:                     // 'namespace' 'comment'
    case 49884:                     // 'processing-instruction' 'comment'
    case 50259:                     // 'attribute' 'constraint'
    case 50298:                     // 'element' 'constraint'
    case 50363:                     // 'namespace' 'constraint'
    case 50396:                     // 'processing-instruction' 'constraint'
    case 50771:                     // 'attribute' 'construction'
    case 50810:                     // 'element' 'construction'
    case 50875:                     // 'namespace' 'construction'
    case 50908:                     // 'processing-instruction' 'construction'
    case 52307:                     // 'attribute' 'context'
    case 52346:                     // 'element' 'context'
    case 52411:                     // 'namespace' 'context'
    case 52444:                     // 'processing-instruction' 'context'
    case 52819:                     // 'attribute' 'continue'
    case 52858:                     // 'element' 'continue'
    case 52923:                     // 'namespace' 'continue'
    case 52956:                     // 'processing-instruction' 'continue'
    case 53331:                     // 'attribute' 'copy'
    case 53370:                     // 'element' 'copy'
    case 53435:                     // 'namespace' 'copy'
    case 53468:                     // 'processing-instruction' 'copy'
    case 53843:                     // 'attribute' 'copy-namespaces'
    case 53882:                     // 'element' 'copy-namespaces'
    case 53947:                     // 'namespace' 'copy-namespaces'
    case 53980:                     // 'processing-instruction' 'copy-namespaces'
    case 54867:                     // 'attribute' 'decimal-format'
    case 54906:                     // 'element' 'decimal-format'
    case 54971:                     // 'namespace' 'decimal-format'
    case 55004:                     // 'processing-instruction' 'decimal-format'
    case 55891:                     // 'attribute' 'declare'
    case 55930:                     // 'element' 'declare'
    case 55995:                     // 'namespace' 'declare'
    case 56028:                     // 'processing-instruction' 'declare'
    case 56915:                     // 'attribute' 'delete'
    case 56954:                     // 'element' 'delete'
    case 57019:                     // 'namespace' 'delete'
    case 57052:                     // 'processing-instruction' 'delete'
    case 57427:                     // 'attribute' 'descendant'
    case 57466:                     // 'element' 'descendant'
    case 57531:                     // 'namespace' 'descendant'
    case 57564:                     // 'processing-instruction' 'descendant'
    case 57939:                     // 'attribute' 'descendant-or-self'
    case 57978:                     // 'element' 'descendant-or-self'
    case 58043:                     // 'namespace' 'descendant-or-self'
    case 58076:                     // 'processing-instruction' 'descendant-or-self'
    case 61523:                     // 'attribute' 'document'
    case 61562:                     // 'element' 'document'
    case 61627:                     // 'namespace' 'document'
    case 61660:                     // 'processing-instruction' 'document'
    case 62035:                     // 'attribute' 'document-node'
    case 62074:                     // 'element' 'document-node'
    case 62139:                     // 'namespace' 'document-node'
    case 62172:                     // 'processing-instruction' 'document-node'
    case 62547:                     // 'attribute' 'element'
    case 62586:                     // 'element' 'element'
    case 62651:                     // 'namespace' 'element'
    case 62684:                     // 'processing-instruction' 'element'
    case 64083:                     // 'attribute' 'empty-sequence'
    case 64122:                     // 'element' 'empty-sequence'
    case 64187:                     // 'namespace' 'empty-sequence'
    case 64220:                     // 'processing-instruction' 'empty-sequence'
    case 64595:                     // 'attribute' 'encoding'
    case 64634:                     // 'element' 'encoding'
    case 64699:                     // 'namespace' 'encoding'
    case 64732:                     // 'processing-instruction' 'encoding'
    case 66643:                     // 'attribute' 'every'
    case 66682:                     // 'element' 'every'
    case 66747:                     // 'namespace' 'every'
    case 66780:                     // 'processing-instruction' 'every'
    case 68179:                     // 'attribute' 'exit'
    case 68218:                     // 'element' 'exit'
    case 68283:                     // 'namespace' 'exit'
    case 68316:                     // 'processing-instruction' 'exit'
    case 68691:                     // 'attribute' 'external'
    case 68730:                     // 'element' 'external'
    case 68795:                     // 'namespace' 'external'
    case 68828:                     // 'processing-instruction' 'external'
    case 69203:                     // 'attribute' 'false'
    case 69242:                     // 'element' 'false'
    case 69307:                     // 'namespace' 'false'
    case 69340:                     // 'processing-instruction' 'false'
    case 69715:                     // 'attribute' 'first'
    case 69754:                     // 'element' 'first'
    case 69819:                     // 'namespace' 'first'
    case 69852:                     // 'processing-instruction' 'first'
    case 70227:                     // 'attribute' 'following'
    case 70266:                     // 'element' 'following'
    case 70331:                     // 'namespace' 'following'
    case 70364:                     // 'processing-instruction' 'following'
    case 70739:                     // 'attribute' 'following-sibling'
    case 70778:                     // 'element' 'following-sibling'
    case 70843:                     // 'namespace' 'following-sibling'
    case 70876:                     // 'processing-instruction' 'following-sibling'
    case 72787:                     // 'attribute' 'from'
    case 72826:                     // 'element' 'from'
    case 72891:                     // 'namespace' 'from'
    case 72924:                     // 'processing-instruction' 'from'
    case 73299:                     // 'attribute' 'ft-option'
    case 73338:                     // 'element' 'ft-option'
    case 73403:                     // 'namespace' 'ft-option'
    case 73436:                     // 'processing-instruction' 'ft-option'
    case 75347:                     // 'attribute' 'function'
    case 75386:                     // 'element' 'function'
    case 75451:                     // 'namespace' 'function'
    case 75484:                     // 'processing-instruction' 'function'
    case 78931:                     // 'attribute' 'if'
    case 78970:                     // 'element' 'if'
    case 79035:                     // 'namespace' 'if'
    case 79068:                     // 'processing-instruction' 'if'
    case 79443:                     // 'attribute' 'import'
    case 79482:                     // 'element' 'import'
    case 79547:                     // 'namespace' 'import'
    case 79580:                     // 'processing-instruction' 'import'
    case 79955:                     // 'attribute' 'in'
    case 79994:                     // 'element' 'in'
    case 80059:                     // 'namespace' 'in'
    case 80092:                     // 'processing-instruction' 'in'
    case 80467:                     // 'attribute' 'index'
    case 80506:                     // 'element' 'index'
    case 80571:                     // 'namespace' 'index'
    case 80604:                     // 'processing-instruction' 'index'
    case 82515:                     // 'attribute' 'insert'
    case 82554:                     // 'element' 'insert'
    case 82619:                     // 'namespace' 'insert'
    case 82652:                     // 'processing-instruction' 'insert'
    case 83539:                     // 'attribute' 'integrity'
    case 83578:                     // 'element' 'integrity'
    case 83643:                     // 'namespace' 'integrity'
    case 83676:                     // 'processing-instruction' 'integrity'
    case 85587:                     // 'attribute' 'item'
    case 85626:                     // 'element' 'item'
    case 85691:                     // 'namespace' 'item'
    case 85724:                     // 'processing-instruction' 'item'
    case 86099:                     // 'attribute' 'json'
    case 86138:                     // 'element' 'json'
    case 86203:                     // 'namespace' 'json'
    case 86236:                     // 'processing-instruction' 'json'
    case 86611:                     // 'attribute' 'json-item'
    case 86650:                     // 'element' 'json-item'
    case 87123:                     // 'attribute' 'jsoniq'
    case 87162:                     // 'element' 'jsoniq'
    case 87227:                     // 'namespace' 'jsoniq'
    case 87260:                     // 'processing-instruction' 'jsoniq'
    case 88659:                     // 'attribute' 'last'
    case 88698:                     // 'element' 'last'
    case 88763:                     // 'namespace' 'last'
    case 88796:                     // 'processing-instruction' 'last'
    case 89171:                     // 'attribute' 'lax'
    case 89210:                     // 'element' 'lax'
    case 89275:                     // 'namespace' 'lax'
    case 89308:                     // 'processing-instruction' 'lax'
    case 91731:                     // 'attribute' 'loop'
    case 91770:                     // 'element' 'loop'
    case 91835:                     // 'namespace' 'loop'
    case 91868:                     // 'processing-instruction' 'loop'
    case 94803:                     // 'attribute' 'module'
    case 94842:                     // 'element' 'module'
    case 94907:                     // 'namespace' 'module'
    case 94940:                     // 'processing-instruction' 'module'
    case 95827:                     // 'attribute' 'namespace'
    case 95866:                     // 'element' 'namespace'
    case 95931:                     // 'namespace' 'namespace'
    case 95964:                     // 'processing-instruction' 'namespace'
    case 96339:                     // 'attribute' 'namespace-node'
    case 96378:                     // 'element' 'namespace-node'
    case 96443:                     // 'namespace' 'namespace-node'
    case 96476:                     // 'processing-instruction' 'namespace-node'
    case 99411:                     // 'attribute' 'node'
    case 99450:                     // 'element' 'node'
    case 99515:                     // 'namespace' 'node'
    case 99548:                     // 'processing-instruction' 'node'
    case 99923:                     // 'attribute' 'nodes'
    case 99962:                     // 'element' 'nodes'
    case 100027:                    // 'namespace' 'nodes'
    case 100060:                    // 'processing-instruction' 'nodes'
    case 100947:                    // 'attribute' 'null'
    case 100986:                    // 'element' 'null'
    case 101051:                    // 'namespace' 'null'
    case 101084:                    // 'processing-instruction' 'null'
    case 101459:                    // 'attribute' 'object'
    case 101498:                    // 'element' 'object'
    case 101563:                    // 'namespace' 'object'
    case 101596:                    // 'processing-instruction' 'object'
    case 104019:                    // 'attribute' 'option'
    case 104058:                    // 'element' 'option'
    case 104123:                    // 'namespace' 'option'
    case 104156:                    // 'processing-instruction' 'option'
    case 105555:                    // 'attribute' 'ordered'
    case 105594:                    // 'element' 'ordered'
    case 105659:                    // 'namespace' 'ordered'
    case 105692:                    // 'processing-instruction' 'ordered'
    case 106067:                    // 'attribute' 'ordering'
    case 106106:                    // 'element' 'ordering'
    case 106171:                    // 'namespace' 'ordering'
    case 106204:                    // 'processing-instruction' 'ordering'
    case 107603:                    // 'attribute' 'parent'
    case 107642:                    // 'element' 'parent'
    case 107707:                    // 'namespace' 'parent'
    case 107740:                    // 'processing-instruction' 'parent'
    case 110675:                    // 'attribute' 'preceding'
    case 110714:                    // 'element' 'preceding'
    case 110779:                    // 'namespace' 'preceding'
    case 110812:                    // 'processing-instruction' 'preceding'
    case 111187:                    // 'attribute' 'preceding-sibling'
    case 111226:                    // 'element' 'preceding-sibling'
    case 111291:                    // 'namespace' 'preceding-sibling'
    case 111324:                    // 'processing-instruction' 'preceding-sibling'
    case 112723:                    // 'attribute' 'processing-instruction'
    case 112762:                    // 'element' 'processing-instruction'
    case 112827:                    // 'namespace' 'processing-instruction'
    case 112860:                    // 'processing-instruction' 'processing-instruction'
    case 113747:                    // 'attribute' 'rename'
    case 113786:                    // 'element' 'rename'
    case 113851:                    // 'namespace' 'rename'
    case 113884:                    // 'processing-instruction' 'rename'
    case 114259:                    // 'attribute' 'replace'
    case 114298:                    // 'element' 'replace'
    case 114363:                    // 'namespace' 'replace'
    case 114396:                    // 'processing-instruction' 'replace'
    case 115283:                    // 'attribute' 'returning'
    case 115322:                    // 'element' 'returning'
    case 115387:                    // 'namespace' 'returning'
    case 115420:                    // 'processing-instruction' 'returning'
    case 115795:                    // 'attribute' 'revalidation'
    case 115834:                    // 'element' 'revalidation'
    case 115899:                    // 'namespace' 'revalidation'
    case 115932:                    // 'processing-instruction' 'revalidation'
    case 117331:                    // 'attribute' 'schema'
    case 117370:                    // 'element' 'schema'
    case 117435:                    // 'namespace' 'schema'
    case 117468:                    // 'processing-instruction' 'schema'
    case 117843:                    // 'attribute' 'schema-attribute'
    case 117882:                    // 'element' 'schema-attribute'
    case 117947:                    // 'namespace' 'schema-attribute'
    case 117980:                    // 'processing-instruction' 'schema-attribute'
    case 118355:                    // 'attribute' 'schema-element'
    case 118394:                    // 'element' 'schema-element'
    case 118459:                    // 'namespace' 'schema-element'
    case 118492:                    // 'processing-instruction' 'schema-element'
    case 118867:                    // 'attribute' 'score'
    case 118906:                    // 'element' 'score'
    case 118971:                    // 'namespace' 'score'
    case 119004:                    // 'processing-instruction' 'score'
    case 119379:                    // 'attribute' 'select'
    case 119418:                    // 'element' 'select'
    case 119483:                    // 'namespace' 'select'
    case 119516:                    // 'processing-instruction' 'select'
    case 119891:                    // 'attribute' 'self'
    case 119930:                    // 'element' 'self'
    case 119995:                    // 'namespace' 'self'
    case 120028:                    // 'processing-instruction' 'self'
    case 122451:                    // 'attribute' 'sliding'
    case 122490:                    // 'element' 'sliding'
    case 122555:                    // 'namespace' 'sliding'
    case 122588:                    // 'processing-instruction' 'sliding'
    case 122963:                    // 'attribute' 'some'
    case 123002:                    // 'element' 'some'
    case 123067:                    // 'namespace' 'some'
    case 123100:                    // 'processing-instruction' 'some'
    case 125523:                    // 'attribute' 'strict'
    case 125562:                    // 'element' 'strict'
    case 125627:                    // 'namespace' 'strict'
    case 125660:                    // 'processing-instruction' 'strict'
    case 126547:                    // 'attribute' 'structured-item'
    case 126586:                    // 'element' 'structured-item'
    case 127059:                    // 'attribute' 'switch'
    case 127098:                    // 'element' 'switch'
    case 127163:                    // 'namespace' 'switch'
    case 127196:                    // 'processing-instruction' 'switch'
    case 127571:                    // 'attribute' 'text'
    case 127610:                    // 'element' 'text'
    case 127675:                    // 'namespace' 'text'
    case 127708:                    // 'processing-instruction' 'text'
    case 130643:                    // 'attribute' 'true'
    case 130682:                    // 'element' 'true'
    case 130747:                    // 'namespace' 'true'
    case 130780:                    // 'processing-instruction' 'true'
    case 131155:                    // 'attribute' 'try'
    case 131194:                    // 'element' 'try'
    case 131259:                    // 'namespace' 'try'
    case 131292:                    // 'processing-instruction' 'try'
    case 131667:                    // 'attribute' 'tumbling'
    case 131706:                    // 'element' 'tumbling'
    case 131771:                    // 'namespace' 'tumbling'
    case 131804:                    // 'processing-instruction' 'tumbling'
    case 132179:                    // 'attribute' 'type'
    case 132218:                    // 'element' 'type'
    case 132283:                    // 'namespace' 'type'
    case 132316:                    // 'processing-instruction' 'type'
    case 132691:                    // 'attribute' 'typeswitch'
    case 132730:                    // 'element' 'typeswitch'
    case 132795:                    // 'namespace' 'typeswitch'
    case 132828:                    // 'processing-instruction' 'typeswitch'
    case 134227:                    // 'attribute' 'unordered'
    case 134266:                    // 'element' 'unordered'
    case 134331:                    // 'namespace' 'unordered'
    case 134364:                    // 'processing-instruction' 'unordered'
    case 134739:                    // 'attribute' 'updating'
    case 134778:                    // 'element' 'updating'
    case 134843:                    // 'namespace' 'updating'
    case 134876:                    // 'processing-instruction' 'updating'
    case 136275:                    // 'attribute' 'validate'
    case 136314:                    // 'element' 'validate'
    case 136379:                    // 'namespace' 'validate'
    case 136412:                    // 'processing-instruction' 'validate'
    case 136787:                    // 'attribute' 'value'
    case 136826:                    // 'element' 'value'
    case 136891:                    // 'namespace' 'value'
    case 136924:                    // 'processing-instruction' 'value'
    case 137299:                    // 'attribute' 'variable'
    case 137338:                    // 'element' 'variable'
    case 137403:                    // 'namespace' 'variable'
    case 137436:                    // 'processing-instruction' 'variable'
    case 137811:                    // 'attribute' 'version'
    case 137850:                    // 'element' 'version'
    case 137915:                    // 'namespace' 'version'
    case 137948:                    // 'processing-instruction' 'version'
    case 139859:                    // 'attribute' 'while'
    case 139898:                    // 'element' 'while'
    case 139963:                    // 'namespace' 'while'
    case 139996:                    // 'processing-instruction' 'while'
    case 143955:                    // 'attribute' '{'
    case 143969:                    // 'comment' '{'
    case 143992:                    // 'document' '{'
    case 143994:                    // 'element' '{'
    case 144059:                    // 'namespace' '{'
    case 144078:                    // 'ordered' '{'
    case 144092:                    // 'processing-instruction' '{'
    case 144121:                    // 'text' '{'
    case 144134:                    // 'unordered' '{'
      parse_PostfixExpr();
      break;
    default:
      parse_AxisStep();
    }
    eventHandler.endNonterminal("StepExpr", e0);
  }

  function try_StepExpr()
  {
    switch (l1)
    {
    case 83:                        // 'attribute'
      lookahead2W(288);             // EQName^Token | S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' |
      break;
    case 122:                       // 'element'
      lookahead2W(287);             // EQName^Token | S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' |
      break;
    case 187:                       // 'namespace'
    case 220:                       // 'processing-instruction'
      lookahead2W(285);             // NCName^Token | S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' |
      break;
    case 135:                       // 'false'
    case 197:                       // 'null'
    case 255:                       // 'true'
      lookahead2W(237);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '.' |
      break;
    case 97:                        // 'comment'
    case 120:                       // 'document'
    case 206:                       // 'ordered'
    case 249:                       // 'text'
    case 262:                       // 'unordered'
      lookahead2W(239);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' |
      break;
    case 79:                        // 'array'
    case 125:                       // 'empty-sequence'
    case 154:                       // 'if'
    case 167:                       // 'item'
    case 169:                       // 'json-item'
    case 247:                       // 'structured-item'
    case 248:                       // 'switch'
    case 259:                       // 'typeswitch'
      lookahead2W(230);             // S^WS | EOF | '!' | '!=' | '#' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' |
      break;
    case 74:                        // 'ancestor'
    case 75:                        // 'ancestor-or-self'
    case 94:                        // 'child'
    case 112:                       // 'descendant'
    case 113:                       // 'descendant-or-self'
    case 137:                       // 'following'
    case 138:                       // 'following-sibling'
    case 210:                       // 'parent'
    case 216:                       // 'preceding'
    case 217:                       // 'preceding-sibling'
    case 234:                       // 'self'
      lookahead2W(238);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' |
      break;
    case 6:                         // EQName^Token
    case 71:                        // 'after'
    case 73:                        // 'allowing'
    case 76:                        // 'and'
    case 78:                        // 'append'
    case 80:                        // 'as'
    case 81:                        // 'ascending'
    case 82:                        // 'at'
    case 84:                        // 'base-uri'
    case 85:                        // 'before'
    case 86:                        // 'boundary-space'
    case 87:                        // 'break'
    case 89:                        // 'case'
    case 90:                        // 'cast'
    case 91:                        // 'castable'
    case 92:                        // 'catch'
    case 95:                        // 'collation'
    case 98:                        // 'constraint'
    case 99:                        // 'construction'
    case 102:                       // 'context'
    case 103:                       // 'continue'
    case 104:                       // 'copy'
    case 105:                       // 'copy-namespaces'
    case 106:                       // 'count'
    case 107:                       // 'decimal-format'
    case 109:                       // 'declare'
    case 110:                       // 'default'
    case 111:                       // 'delete'
    case 114:                       // 'descending'
    case 119:                       // 'div'
    case 121:                       // 'document-node'
    case 123:                       // 'else'
    case 124:                       // 'empty'
    case 126:                       // 'encoding'
    case 127:                       // 'end'
    case 129:                       // 'eq'
    case 130:                       // 'every'
    case 132:                       // 'except'
    case 133:                       // 'exit'
    case 134:                       // 'external'
    case 136:                       // 'first'
    case 139:                       // 'for'
    case 142:                       // 'from'
    case 143:                       // 'ft-option'
    case 147:                       // 'function'
    case 148:                       // 'ge'
    case 150:                       // 'group'
    case 152:                       // 'gt'
    case 153:                       // 'idiv'
    case 155:                       // 'import'
    case 156:                       // 'in'
    case 157:                       // 'index'
    case 161:                       // 'insert'
    case 162:                       // 'instance'
    case 163:                       // 'integrity'
    case 164:                       // 'intersect'
    case 165:                       // 'into'
    case 166:                       // 'is'
    case 168:                       // 'json'
    case 170:                       // 'jsoniq'
    case 173:                       // 'last'
    case 174:                       // 'lax'
    case 175:                       // 'le'
    case 177:                       // 'let'
    case 179:                       // 'loop'
    case 181:                       // 'lt'
    case 183:                       // 'mod'
    case 184:                       // 'modify'
    case 185:                       // 'module'
    case 188:                       // 'namespace-node'
    case 189:                       // 'ne'
    case 194:                       // 'node'
    case 195:                       // 'nodes'
    case 198:                       // 'object'
    case 202:                       // 'only'
    case 203:                       // 'option'
    case 204:                       // 'or'
    case 205:                       // 'order'
    case 207:                       // 'ordering'
    case 222:                       // 'rename'
    case 223:                       // 'replace'
    case 224:                       // 'return'
    case 225:                       // 'returning'
    case 226:                       // 'revalidation'
    case 228:                       // 'satisfies'
    case 229:                       // 'schema'
    case 230:                       // 'schema-attribute'
    case 231:                       // 'schema-element'
    case 232:                       // 'score'
    case 233:                       // 'select'
    case 239:                       // 'sliding'
    case 240:                       // 'some'
    case 241:                       // 'stable'
    case 242:                       // 'start'
    case 245:                       // 'strict'
    case 253:                       // 'to'
    case 254:                       // 'treat'
    case 256:                       // 'try'
    case 257:                       // 'tumbling'
    case 258:                       // 'type'
    case 260:                       // 'union'
    case 263:                       // 'updating'
    case 266:                       // 'validate'
    case 267:                       // 'value'
    case 268:                       // 'variable'
    case 269:                       // 'version'
    case 272:                       // 'where'
    case 273:                       // 'while'
    case 276:                       // 'with'
      lookahead2W(234);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' |
      break;
    default:
      lk = l1;
    }
    if (lk == 12935                 // 'false' EOF
     || lk == 12997                 // 'null' EOF
     || lk == 13055                 // 'true' EOF
     || lk == 13447                 // 'false' '!'
     || lk == 13509                 // 'null' '!'
     || lk == 13567                 // 'true' '!'
     || lk == 13959                 // 'false' '!='
     || lk == 14021                 // 'null' '!='
     || lk == 14079                 // 'true' '!='
     || lk == 19591                 // 'false' ')'
     || lk == 19653                 // 'null' ')'
     || lk == 19711                 // 'true' ')'
     || lk == 20103                 // 'false' '*'
     || lk == 20165                 // 'null' '*'
     || lk == 20223                 // 'true' '*'
     || lk == 21127                 // 'false' '+'
     || lk == 21189                 // 'null' '+'
     || lk == 21247                 // 'true' '+'
     || lk == 21639                 // 'false' ','
     || lk == 21701                 // 'null' ','
     || lk == 21759                 // 'true' ','
     || lk == 22151                 // 'false' '-'
     || lk == 22213                 // 'null' '-'
     || lk == 22271                 // 'true' '-'
     || lk == 24199                 // 'false' '/'
     || lk == 24261                 // 'null' '/'
     || lk == 24319                 // 'true' '/'
     || lk == 24711                 // 'false' '//'
     || lk == 24773                 // 'null' '//'
     || lk == 24831                 // 'true' '//'
     || lk == 25735                 // 'false' ':'
     || lk == 25797                 // 'null' ':'
     || lk == 25855                 // 'true' ':'
     || lk == 27783                 // 'false' ';'
     || lk == 27845                 // 'null' ';'
     || lk == 27903                 // 'true' ';'
     || lk == 28295                 // 'false' '<'
     || lk == 28357                 // 'null' '<'
     || lk == 28415                 // 'true' '<'
     || lk == 29831                 // 'false' '<<'
     || lk == 29893                 // 'null' '<<'
     || lk == 29951                 // 'true' '<<'
     || lk == 30343                 // 'false' '<='
     || lk == 30405                 // 'null' '<='
     || lk == 30463                 // 'true' '<='
     || lk == 31367                 // 'false' '='
     || lk == 31429                 // 'null' '='
     || lk == 31487                 // 'true' '='
     || lk == 31879                 // 'false' '>'
     || lk == 31941                 // 'null' '>'
     || lk == 31999                 // 'true' '>'
     || lk == 32391                 // 'false' '>='
     || lk == 32453                 // 'null' '>='
     || lk == 32511                 // 'true' '>='
     || lk == 32903                 // 'false' '>>'
     || lk == 32965                 // 'null' '>>'
     || lk == 33023                 // 'true' '>>'
     || lk == 35463                 // 'false' '['
     || lk == 35525                 // 'null' '['
     || lk == 35583                 // 'true' '['
     || lk == 35975                 // 'false' ']'
     || lk == 36037                 // 'null' ']'
     || lk == 36095                 // 'true' ']'
     || lk == 36435                 // 'attribute' 'after'
     || lk == 36474                 // 'element' 'after'
     || lk == 36487                 // 'false' 'after'
     || lk == 36539                 // 'namespace' 'after'
     || lk == 36549                 // 'null' 'after'
     || lk == 36572                 // 'processing-instruction' 'after'
     || lk == 36607                 // 'true' 'after'
     || lk == 38995                 // 'attribute' 'and'
     || lk == 39034                 // 'element' 'and'
     || lk == 39047                 // 'false' 'and'
     || lk == 39099                 // 'namespace' 'and'
     || lk == 39109                 // 'null' 'and'
     || lk == 39132                 // 'processing-instruction' 'and'
     || lk == 39167                 // 'true' 'and'
     || lk == 41043                 // 'attribute' 'as'
     || lk == 41082                 // 'element' 'as'
     || lk == 41095                 // 'false' 'as'
     || lk == 41147                 // 'namespace' 'as'
     || lk == 41157                 // 'null' 'as'
     || lk == 41180                 // 'processing-instruction' 'as'
     || lk == 41215                 // 'true' 'as'
     || lk == 41555                 // 'attribute' 'ascending'
     || lk == 41594                 // 'element' 'ascending'
     || lk == 41607                 // 'false' 'ascending'
     || lk == 41659                 // 'namespace' 'ascending'
     || lk == 41669                 // 'null' 'ascending'
     || lk == 41692                 // 'processing-instruction' 'ascending'
     || lk == 41727                 // 'true' 'ascending'
     || lk == 42067                 // 'attribute' 'at'
     || lk == 42106                 // 'element' 'at'
     || lk == 42119                 // 'false' 'at'
     || lk == 42171                 // 'namespace' 'at'
     || lk == 42181                 // 'null' 'at'
     || lk == 42204                 // 'processing-instruction' 'at'
     || lk == 42239                 // 'true' 'at'
     || lk == 43603                 // 'attribute' 'before'
     || lk == 43642                 // 'element' 'before'
     || lk == 43655                 // 'false' 'before'
     || lk == 43707                 // 'namespace' 'before'
     || lk == 43717                 // 'null' 'before'
     || lk == 43740                 // 'processing-instruction' 'before'
     || lk == 43775                 // 'true' 'before'
     || lk == 45191                 // 'false' 'by'
     || lk == 45253                 // 'null' 'by'
     || lk == 45311                 // 'true' 'by'
     || lk == 45651                 // 'attribute' 'case'
     || lk == 45690                 // 'element' 'case'
     || lk == 45703                 // 'false' 'case'
     || lk == 45755                 // 'namespace' 'case'
     || lk == 45765                 // 'null' 'case'
     || lk == 45788                 // 'processing-instruction' 'case'
     || lk == 45823                 // 'true' 'case'
     || lk == 46163                 // 'attribute' 'cast'
     || lk == 46202                 // 'element' 'cast'
     || lk == 46215                 // 'false' 'cast'
     || lk == 46267                 // 'namespace' 'cast'
     || lk == 46277                 // 'null' 'cast'
     || lk == 46300                 // 'processing-instruction' 'cast'
     || lk == 46335                 // 'true' 'cast'
     || lk == 46675                 // 'attribute' 'castable'
     || lk == 46714                 // 'element' 'castable'
     || lk == 46727                 // 'false' 'castable'
     || lk == 46779                 // 'namespace' 'castable'
     || lk == 46789                 // 'null' 'castable'
     || lk == 46812                 // 'processing-instruction' 'castable'
     || lk == 46847                 // 'true' 'castable'
     || lk == 48723                 // 'attribute' 'collation'
     || lk == 48762                 // 'element' 'collation'
     || lk == 48775                 // 'false' 'collation'
     || lk == 48827                 // 'namespace' 'collation'
     || lk == 48837                 // 'null' 'collation'
     || lk == 48860                 // 'processing-instruction' 'collation'
     || lk == 48895                 // 'true' 'collation'
     || lk == 51335                 // 'false' 'contains'
     || lk == 51397                 // 'null' 'contains'
     || lk == 51455                 // 'true' 'contains'
     || lk == 54355                 // 'attribute' 'count'
     || lk == 54394                 // 'element' 'count'
     || lk == 54407                 // 'false' 'count'
     || lk == 54459                 // 'namespace' 'count'
     || lk == 54469                 // 'null' 'count'
     || lk == 54492                 // 'processing-instruction' 'count'
     || lk == 54527                 // 'true' 'count'
     || lk == 56403                 // 'attribute' 'default'
     || lk == 56442                 // 'element' 'default'
     || lk == 56455                 // 'false' 'default'
     || lk == 56507                 // 'namespace' 'default'
     || lk == 56517                 // 'null' 'default'
     || lk == 56540                 // 'processing-instruction' 'default'
     || lk == 56575                 // 'true' 'default'
     || lk == 58451                 // 'attribute' 'descending'
     || lk == 58490                 // 'element' 'descending'
     || lk == 58503                 // 'false' 'descending'
     || lk == 58555                 // 'namespace' 'descending'
     || lk == 58565                 // 'null' 'descending'
     || lk == 58588                 // 'processing-instruction' 'descending'
     || lk == 58623                 // 'true' 'descending'
     || lk == 61011                 // 'attribute' 'div'
     || lk == 61050                 // 'element' 'div'
     || lk == 61063                 // 'false' 'div'
     || lk == 61115                 // 'namespace' 'div'
     || lk == 61125                 // 'null' 'div'
     || lk == 61148                 // 'processing-instruction' 'div'
     || lk == 61183                 // 'true' 'div'
     || lk == 63059                 // 'attribute' 'else'
     || lk == 63098                 // 'element' 'else'
     || lk == 63111                 // 'false' 'else'
     || lk == 63163                 // 'namespace' 'else'
     || lk == 63173                 // 'null' 'else'
     || lk == 63196                 // 'processing-instruction' 'else'
     || lk == 63231                 // 'true' 'else'
     || lk == 63571                 // 'attribute' 'empty'
     || lk == 63610                 // 'element' 'empty'
     || lk == 63623                 // 'false' 'empty'
     || lk == 63675                 // 'namespace' 'empty'
     || lk == 63685                 // 'null' 'empty'
     || lk == 63708                 // 'processing-instruction' 'empty'
     || lk == 63743                 // 'true' 'empty'
     || lk == 65107                 // 'attribute' 'end'
     || lk == 65146                 // 'element' 'end'
     || lk == 65159                 // 'false' 'end'
     || lk == 65211                 // 'namespace' 'end'
     || lk == 65221                 // 'null' 'end'
     || lk == 65244                 // 'processing-instruction' 'end'
     || lk == 65279                 // 'true' 'end'
     || lk == 66131                 // 'attribute' 'eq'
     || lk == 66170                 // 'element' 'eq'
     || lk == 66183                 // 'false' 'eq'
     || lk == 66235                 // 'namespace' 'eq'
     || lk == 66245                 // 'null' 'eq'
     || lk == 66268                 // 'processing-instruction' 'eq'
     || lk == 66303                 // 'true' 'eq'
     || lk == 67667                 // 'attribute' 'except'
     || lk == 67706                 // 'element' 'except'
     || lk == 67719                 // 'false' 'except'
     || lk == 67771                 // 'namespace' 'except'
     || lk == 67781                 // 'null' 'except'
     || lk == 67804                 // 'processing-instruction' 'except'
     || lk == 67839                 // 'true' 'except'
     || lk == 71251                 // 'attribute' 'for'
     || lk == 71290                 // 'element' 'for'
     || lk == 71303                 // 'false' 'for'
     || lk == 71355                 // 'namespace' 'for'
     || lk == 71365                 // 'null' 'for'
     || lk == 71388                 // 'processing-instruction' 'for'
     || lk == 71423                 // 'true' 'for'
     || lk == 75859                 // 'attribute' 'ge'
     || lk == 75898                 // 'element' 'ge'
     || lk == 75911                 // 'false' 'ge'
     || lk == 75963                 // 'namespace' 'ge'
     || lk == 75973                 // 'null' 'ge'
     || lk == 75996                 // 'processing-instruction' 'ge'
     || lk == 76031                 // 'true' 'ge'
     || lk == 76883                 // 'attribute' 'group'
     || lk == 76922                 // 'element' 'group'
     || lk == 76935                 // 'false' 'group'
     || lk == 76987                 // 'namespace' 'group'
     || lk == 76997                 // 'null' 'group'
     || lk == 77020                 // 'processing-instruction' 'group'
     || lk == 77055                 // 'true' 'group'
     || lk == 77907                 // 'attribute' 'gt'
     || lk == 77946                 // 'element' 'gt'
     || lk == 77959                 // 'false' 'gt'
     || lk == 78011                 // 'namespace' 'gt'
     || lk == 78021                 // 'null' 'gt'
     || lk == 78044                 // 'processing-instruction' 'gt'
     || lk == 78079                 // 'true' 'gt'
     || lk == 78419                 // 'attribute' 'idiv'
     || lk == 78458                 // 'element' 'idiv'
     || lk == 78471                 // 'false' 'idiv'
     || lk == 78523                 // 'namespace' 'idiv'
     || lk == 78533                 // 'null' 'idiv'
     || lk == 78556                 // 'processing-instruction' 'idiv'
     || lk == 78591                 // 'true' 'idiv'
     || lk == 83027                 // 'attribute' 'instance'
     || lk == 83066                 // 'element' 'instance'
     || lk == 83079                 // 'false' 'instance'
     || lk == 83131                 // 'namespace' 'instance'
     || lk == 83141                 // 'null' 'instance'
     || lk == 83164                 // 'processing-instruction' 'instance'
     || lk == 83199                 // 'true' 'instance'
     || lk == 84051                 // 'attribute' 'intersect'
     || lk == 84090                 // 'element' 'intersect'
     || lk == 84103                 // 'false' 'intersect'
     || lk == 84155                 // 'namespace' 'intersect'
     || lk == 84165                 // 'null' 'intersect'
     || lk == 84188                 // 'processing-instruction' 'intersect'
     || lk == 84223                 // 'true' 'intersect'
     || lk == 84563                 // 'attribute' 'into'
     || lk == 84602                 // 'element' 'into'
     || lk == 84615                 // 'false' 'into'
     || lk == 84667                 // 'namespace' 'into'
     || lk == 84677                 // 'null' 'into'
     || lk == 84700                 // 'processing-instruction' 'into'
     || lk == 84735                 // 'true' 'into'
     || lk == 85075                 // 'attribute' 'is'
     || lk == 85114                 // 'element' 'is'
     || lk == 85127                 // 'false' 'is'
     || lk == 85179                 // 'namespace' 'is'
     || lk == 85189                 // 'null' 'is'
     || lk == 85212                 // 'processing-instruction' 'is'
     || lk == 85247                 // 'true' 'is'
     || lk == 89683                 // 'attribute' 'le'
     || lk == 89722                 // 'element' 'le'
     || lk == 89735                 // 'false' 'le'
     || lk == 89787                 // 'namespace' 'le'
     || lk == 89797                 // 'null' 'le'
     || lk == 89820                 // 'processing-instruction' 'le'
     || lk == 89855                 // 'true' 'le'
     || lk == 90707                 // 'attribute' 'let'
     || lk == 90746                 // 'element' 'let'
     || lk == 90759                 // 'false' 'let'
     || lk == 90811                 // 'namespace' 'let'
     || lk == 90821                 // 'null' 'let'
     || lk == 90844                 // 'processing-instruction' 'let'
     || lk == 90879                 // 'true' 'let'
     || lk == 92755                 // 'attribute' 'lt'
     || lk == 92794                 // 'element' 'lt'
     || lk == 92807                 // 'false' 'lt'
     || lk == 92859                 // 'namespace' 'lt'
     || lk == 92869                 // 'null' 'lt'
     || lk == 92892                 // 'processing-instruction' 'lt'
     || lk == 92927                 // 'true' 'lt'
     || lk == 93779                 // 'attribute' 'mod'
     || lk == 93818                 // 'element' 'mod'
     || lk == 93831                 // 'false' 'mod'
     || lk == 93883                 // 'namespace' 'mod'
     || lk == 93893                 // 'null' 'mod'
     || lk == 93916                 // 'processing-instruction' 'mod'
     || lk == 93951                 // 'true' 'mod'
     || lk == 94291                 // 'attribute' 'modify'
     || lk == 94330                 // 'element' 'modify'
     || lk == 94343                 // 'false' 'modify'
     || lk == 94395                 // 'namespace' 'modify'
     || lk == 94405                 // 'null' 'modify'
     || lk == 94428                 // 'processing-instruction' 'modify'
     || lk == 94463                 // 'true' 'modify'
     || lk == 96851                 // 'attribute' 'ne'
     || lk == 96890                 // 'element' 'ne'
     || lk == 96903                 // 'false' 'ne'
     || lk == 96955                 // 'namespace' 'ne'
     || lk == 96965                 // 'null' 'ne'
     || lk == 96988                 // 'processing-instruction' 'ne'
     || lk == 97023                 // 'true' 'ne'
     || lk == 103507                // 'attribute' 'only'
     || lk == 103546                // 'element' 'only'
     || lk == 103559                // 'false' 'only'
     || lk == 103611                // 'namespace' 'only'
     || lk == 103621                // 'null' 'only'
     || lk == 103644                // 'processing-instruction' 'only'
     || lk == 103679                // 'true' 'only'
     || lk == 104531                // 'attribute' 'or'
     || lk == 104570                // 'element' 'or'
     || lk == 104583                // 'false' 'or'
     || lk == 104635                // 'namespace' 'or'
     || lk == 104645                // 'null' 'or'
     || lk == 104668                // 'processing-instruction' 'or'
     || lk == 104703                // 'true' 'or'
     || lk == 105043                // 'attribute' 'order'
     || lk == 105082                // 'element' 'order'
     || lk == 105095                // 'false' 'order'
     || lk == 105147                // 'namespace' 'order'
     || lk == 105157                // 'null' 'order'
     || lk == 105180                // 'processing-instruction' 'order'
     || lk == 105215                // 'true' 'order'
     || lk == 107143                // 'false' 'paragraphs'
     || lk == 107205                // 'null' 'paragraphs'
     || lk == 107263                // 'true' 'paragraphs'
     || lk == 114771                // 'attribute' 'return'
     || lk == 114810                // 'element' 'return'
     || lk == 114823                // 'false' 'return'
     || lk == 114875                // 'namespace' 'return'
     || lk == 114885                // 'null' 'return'
     || lk == 114908                // 'processing-instruction' 'return'
     || lk == 114943                // 'true' 'return'
     || lk == 116819                // 'attribute' 'satisfies'
     || lk == 116858                // 'element' 'satisfies'
     || lk == 116871                // 'false' 'satisfies'
     || lk == 116923                // 'namespace' 'satisfies'
     || lk == 116933                // 'null' 'satisfies'
     || lk == 116956                // 'processing-instruction' 'satisfies'
     || lk == 116991                // 'true' 'satisfies'
     || lk == 121479                // 'false' 'sentences'
     || lk == 121541                // 'null' 'sentences'
     || lk == 121599                // 'true' 'sentences'
     || lk == 123475                // 'attribute' 'stable'
     || lk == 123514                // 'element' 'stable'
     || lk == 123527                // 'false' 'stable'
     || lk == 123579                // 'namespace' 'stable'
     || lk == 123589                // 'null' 'stable'
     || lk == 123612                // 'processing-instruction' 'stable'
     || lk == 123647                // 'true' 'stable'
     || lk == 123987                // 'attribute' 'start'
     || lk == 124026                // 'element' 'start'
     || lk == 124039                // 'false' 'start'
     || lk == 124091                // 'namespace' 'start'
     || lk == 124101                // 'null' 'start'
     || lk == 124124                // 'processing-instruction' 'start'
     || lk == 124159                // 'true' 'start'
     || lk == 129159                // 'false' 'times'
     || lk == 129221                // 'null' 'times'
     || lk == 129279                // 'true' 'times'
     || lk == 129619                // 'attribute' 'to'
     || lk == 129658                // 'element' 'to'
     || lk == 129671                // 'false' 'to'
     || lk == 129723                // 'namespace' 'to'
     || lk == 129733                // 'null' 'to'
     || lk == 129756                // 'processing-instruction' 'to'
     || lk == 129791                // 'true' 'to'
     || lk == 130131                // 'attribute' 'treat'
     || lk == 130170                // 'element' 'treat'
     || lk == 130183                // 'false' 'treat'
     || lk == 130235                // 'namespace' 'treat'
     || lk == 130245                // 'null' 'treat'
     || lk == 130268                // 'processing-instruction' 'treat'
     || lk == 130303                // 'true' 'treat'
     || lk == 133203                // 'attribute' 'union'
     || lk == 133242                // 'element' 'union'
     || lk == 133255                // 'false' 'union'
     || lk == 133307                // 'namespace' 'union'
     || lk == 133317                // 'null' 'union'
     || lk == 133340                // 'processing-instruction' 'union'
     || lk == 133375                // 'true' 'union'
     || lk == 139347                // 'attribute' 'where'
     || lk == 139386                // 'element' 'where'
     || lk == 139399                // 'false' 'where'
     || lk == 139451                // 'namespace' 'where'
     || lk == 139461                // 'null' 'where'
     || lk == 139484                // 'processing-instruction' 'where'
     || lk == 139519                // 'true' 'where'
     || lk == 141395                // 'attribute' 'with'
     || lk == 141434                // 'element' 'with'
     || lk == 141447                // 'false' 'with'
     || lk == 141499                // 'namespace' 'with'
     || lk == 141509                // 'null' 'with'
     || lk == 141532                // 'processing-instruction' 'with'
     || lk == 141567                // 'true' 'with'
     || lk == 142983                // 'false' 'words'
     || lk == 143045                // 'null' 'words'
     || lk == 143103                // 'true' 'words'
     || lk == 145543                // 'false' '|'
     || lk == 145605                // 'null' '|'
     || lk == 145663                // 'true' '|'
     || lk == 146055                // 'false' '||'
     || lk == 146117                // 'null' '||'
     || lk == 146175                // 'true' '||'
     || lk == 146567                // 'false' '|}'
     || lk == 146629                // 'null' '|}'
     || lk == 146687                // 'true' '|}'
     || lk == 147079                // 'false' '}'
     || lk == 147141                // 'null' '}'
     || lk == 147199)               // 'true' '}'
    {
      lk = memoized(4, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_PostfixExpr();
          memoize(4, e0A, -1);
          lk = -3;
        }
        catch (p1A)
        {
          lk = -2;
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(4, e0A, -2);
        }
      }
    }
    switch (lk)
    {
    case -1:
    case 8:                         // IntegerLiteral
    case 9:                         // DecimalLiteral
    case 10:                        // DoubleLiteral
    case 11:                        // StringLiteral
    case 31:                        // '$'
    case 32:                        // '$$'
    case 33:                        // '%'
    case 35:                        // '('
    case 55:                        // '<'
    case 56:                        // '<!--'
    case 60:                        // '<?'
    case 69:                        // '['
    case 281:                       // '{'
    case 283:                       // '{|'
    case 3155:                      // 'attribute' EQName^Token
    case 3194:                      // 'element' EQName^Token
    case 9915:                      // 'namespace' NCName^Token
    case 9948:                      // 'processing-instruction' NCName^Token
    case 14854:                     // EQName^Token '#'
    case 14919:                     // 'after' '#'
    case 14921:                     // 'allowing' '#'
    case 14922:                     // 'ancestor' '#'
    case 14923:                     // 'ancestor-or-self' '#'
    case 14924:                     // 'and' '#'
    case 14926:                     // 'append' '#'
    case 14927:                     // 'array' '#'
    case 14928:                     // 'as' '#'
    case 14929:                     // 'ascending' '#'
    case 14930:                     // 'at' '#'
    case 14931:                     // 'attribute' '#'
    case 14932:                     // 'base-uri' '#'
    case 14933:                     // 'before' '#'
    case 14934:                     // 'boundary-space' '#'
    case 14935:                     // 'break' '#'
    case 14937:                     // 'case' '#'
    case 14938:                     // 'cast' '#'
    case 14939:                     // 'castable' '#'
    case 14940:                     // 'catch' '#'
    case 14942:                     // 'child' '#'
    case 14943:                     // 'collation' '#'
    case 14945:                     // 'comment' '#'
    case 14946:                     // 'constraint' '#'
    case 14947:                     // 'construction' '#'
    case 14950:                     // 'context' '#'
    case 14951:                     // 'continue' '#'
    case 14952:                     // 'copy' '#'
    case 14953:                     // 'copy-namespaces' '#'
    case 14954:                     // 'count' '#'
    case 14955:                     // 'decimal-format' '#'
    case 14957:                     // 'declare' '#'
    case 14958:                     // 'default' '#'
    case 14959:                     // 'delete' '#'
    case 14960:                     // 'descendant' '#'
    case 14961:                     // 'descendant-or-self' '#'
    case 14962:                     // 'descending' '#'
    case 14967:                     // 'div' '#'
    case 14968:                     // 'document' '#'
    case 14969:                     // 'document-node' '#'
    case 14970:                     // 'element' '#'
    case 14971:                     // 'else' '#'
    case 14972:                     // 'empty' '#'
    case 14973:                     // 'empty-sequence' '#'
    case 14974:                     // 'encoding' '#'
    case 14975:                     // 'end' '#'
    case 14977:                     // 'eq' '#'
    case 14978:                     // 'every' '#'
    case 14980:                     // 'except' '#'
    case 14981:                     // 'exit' '#'
    case 14982:                     // 'external' '#'
    case 14983:                     // 'false' '#'
    case 14984:                     // 'first' '#'
    case 14985:                     // 'following' '#'
    case 14986:                     // 'following-sibling' '#'
    case 14987:                     // 'for' '#'
    case 14990:                     // 'from' '#'
    case 14991:                     // 'ft-option' '#'
    case 14995:                     // 'function' '#'
    case 14996:                     // 'ge' '#'
    case 14998:                     // 'group' '#'
    case 15000:                     // 'gt' '#'
    case 15001:                     // 'idiv' '#'
    case 15002:                     // 'if' '#'
    case 15003:                     // 'import' '#'
    case 15004:                     // 'in' '#'
    case 15005:                     // 'index' '#'
    case 15009:                     // 'insert' '#'
    case 15010:                     // 'instance' '#'
    case 15011:                     // 'integrity' '#'
    case 15012:                     // 'intersect' '#'
    case 15013:                     // 'into' '#'
    case 15014:                     // 'is' '#'
    case 15015:                     // 'item' '#'
    case 15016:                     // 'json' '#'
    case 15017:                     // 'json-item' '#'
    case 15018:                     // 'jsoniq' '#'
    case 15021:                     // 'last' '#'
    case 15022:                     // 'lax' '#'
    case 15023:                     // 'le' '#'
    case 15025:                     // 'let' '#'
    case 15027:                     // 'loop' '#'
    case 15029:                     // 'lt' '#'
    case 15031:                     // 'mod' '#'
    case 15032:                     // 'modify' '#'
    case 15033:                     // 'module' '#'
    case 15035:                     // 'namespace' '#'
    case 15036:                     // 'namespace-node' '#'
    case 15037:                     // 'ne' '#'
    case 15042:                     // 'node' '#'
    case 15043:                     // 'nodes' '#'
    case 15045:                     // 'null' '#'
    case 15046:                     // 'object' '#'
    case 15050:                     // 'only' '#'
    case 15051:                     // 'option' '#'
    case 15052:                     // 'or' '#'
    case 15053:                     // 'order' '#'
    case 15054:                     // 'ordered' '#'
    case 15055:                     // 'ordering' '#'
    case 15058:                     // 'parent' '#'
    case 15064:                     // 'preceding' '#'
    case 15065:                     // 'preceding-sibling' '#'
    case 15068:                     // 'processing-instruction' '#'
    case 15070:                     // 'rename' '#'
    case 15071:                     // 'replace' '#'
    case 15072:                     // 'return' '#'
    case 15073:                     // 'returning' '#'
    case 15074:                     // 'revalidation' '#'
    case 15076:                     // 'satisfies' '#'
    case 15077:                     // 'schema' '#'
    case 15078:                     // 'schema-attribute' '#'
    case 15079:                     // 'schema-element' '#'
    case 15080:                     // 'score' '#'
    case 15081:                     // 'select' '#'
    case 15082:                     // 'self' '#'
    case 15087:                     // 'sliding' '#'
    case 15088:                     // 'some' '#'
    case 15089:                     // 'stable' '#'
    case 15090:                     // 'start' '#'
    case 15093:                     // 'strict' '#'
    case 15095:                     // 'structured-item' '#'
    case 15096:                     // 'switch' '#'
    case 15097:                     // 'text' '#'
    case 15101:                     // 'to' '#'
    case 15102:                     // 'treat' '#'
    case 15103:                     // 'true' '#'
    case 15104:                     // 'try' '#'
    case 15105:                     // 'tumbling' '#'
    case 15106:                     // 'type' '#'
    case 15107:                     // 'typeswitch' '#'
    case 15108:                     // 'union' '#'
    case 15110:                     // 'unordered' '#'
    case 15111:                     // 'updating' '#'
    case 15114:                     // 'validate' '#'
    case 15115:                     // 'value' '#'
    case 15116:                     // 'variable' '#'
    case 15117:                     // 'version' '#'
    case 15120:                     // 'where' '#'
    case 15121:                     // 'while' '#'
    case 15124:                     // 'with' '#'
    case 17926:                     // EQName^Token '('
    case 17991:                     // 'after' '('
    case 17993:                     // 'allowing' '('
    case 17994:                     // 'ancestor' '('
    case 17995:                     // 'ancestor-or-self' '('
    case 17996:                     // 'and' '('
    case 17998:                     // 'append' '('
    case 18000:                     // 'as' '('
    case 18001:                     // 'ascending' '('
    case 18002:                     // 'at' '('
    case 18004:                     // 'base-uri' '('
    case 18005:                     // 'before' '('
    case 18006:                     // 'boundary-space' '('
    case 18007:                     // 'break' '('
    case 18009:                     // 'case' '('
    case 18010:                     // 'cast' '('
    case 18011:                     // 'castable' '('
    case 18012:                     // 'catch' '('
    case 18014:                     // 'child' '('
    case 18015:                     // 'collation' '('
    case 18018:                     // 'constraint' '('
    case 18019:                     // 'construction' '('
    case 18022:                     // 'context' '('
    case 18023:                     // 'continue' '('
    case 18024:                     // 'copy' '('
    case 18025:                     // 'copy-namespaces' '('
    case 18026:                     // 'count' '('
    case 18027:                     // 'decimal-format' '('
    case 18029:                     // 'declare' '('
    case 18030:                     // 'default' '('
    case 18031:                     // 'delete' '('
    case 18032:                     // 'descendant' '('
    case 18033:                     // 'descendant-or-self' '('
    case 18034:                     // 'descending' '('
    case 18039:                     // 'div' '('
    case 18040:                     // 'document' '('
    case 18043:                     // 'else' '('
    case 18044:                     // 'empty' '('
    case 18046:                     // 'encoding' '('
    case 18047:                     // 'end' '('
    case 18049:                     // 'eq' '('
    case 18050:                     // 'every' '('
    case 18052:                     // 'except' '('
    case 18053:                     // 'exit' '('
    case 18054:                     // 'external' '('
    case 18055:                     // 'false' '('
    case 18056:                     // 'first' '('
    case 18057:                     // 'following' '('
    case 18058:                     // 'following-sibling' '('
    case 18059:                     // 'for' '('
    case 18062:                     // 'from' '('
    case 18063:                     // 'ft-option' '('
    case 18067:                     // 'function' '('
    case 18068:                     // 'ge' '('
    case 18070:                     // 'group' '('
    case 18072:                     // 'gt' '('
    case 18073:                     // 'idiv' '('
    case 18075:                     // 'import' '('
    case 18076:                     // 'in' '('
    case 18077:                     // 'index' '('
    case 18081:                     // 'insert' '('
    case 18082:                     // 'instance' '('
    case 18083:                     // 'integrity' '('
    case 18084:                     // 'intersect' '('
    case 18085:                     // 'into' '('
    case 18086:                     // 'is' '('
    case 18088:                     // 'json' '('
    case 18090:                     // 'jsoniq' '('
    case 18093:                     // 'last' '('
    case 18094:                     // 'lax' '('
    case 18095:                     // 'le' '('
    case 18097:                     // 'let' '('
    case 18099:                     // 'loop' '('
    case 18101:                     // 'lt' '('
    case 18103:                     // 'mod' '('
    case 18104:                     // 'modify' '('
    case 18105:                     // 'module' '('
    case 18107:                     // 'namespace' '('
    case 18109:                     // 'ne' '('
    case 18115:                     // 'nodes' '('
    case 18117:                     // 'null' '('
    case 18118:                     // 'object' '('
    case 18122:                     // 'only' '('
    case 18123:                     // 'option' '('
    case 18124:                     // 'or' '('
    case 18125:                     // 'order' '('
    case 18126:                     // 'ordered' '('
    case 18127:                     // 'ordering' '('
    case 18130:                     // 'parent' '('
    case 18136:                     // 'preceding' '('
    case 18137:                     // 'preceding-sibling' '('
    case 18142:                     // 'rename' '('
    case 18143:                     // 'replace' '('
    case 18144:                     // 'return' '('
    case 18145:                     // 'returning' '('
    case 18146:                     // 'revalidation' '('
    case 18148:                     // 'satisfies' '('
    case 18149:                     // 'schema' '('
    case 18152:                     // 'score' '('
    case 18153:                     // 'select' '('
    case 18154:                     // 'self' '('
    case 18159:                     // 'sliding' '('
    case 18160:                     // 'some' '('
    case 18161:                     // 'stable' '('
    case 18162:                     // 'start' '('
    case 18165:                     // 'strict' '('
    case 18173:                     // 'to' '('
    case 18174:                     // 'treat' '('
    case 18175:                     // 'true' '('
    case 18176:                     // 'try' '('
    case 18177:                     // 'tumbling' '('
    case 18178:                     // 'type' '('
    case 18180:                     // 'union' '('
    case 18182:                     // 'unordered' '('
    case 18183:                     // 'updating' '('
    case 18186:                     // 'validate' '('
    case 18187:                     // 'value' '('
    case 18188:                     // 'variable' '('
    case 18189:                     // 'version' '('
    case 18192:                     // 'where' '('
    case 18193:                     // 'while' '('
    case 18196:                     // 'with' '('
    case 23175:                     // 'false' '.'
    case 23237:                     // 'null' '.'
    case 23295:                     // 'true' '.'
    case 37459:                     // 'attribute' 'allowing'
    case 37498:                     // 'element' 'allowing'
    case 37563:                     // 'namespace' 'allowing'
    case 37596:                     // 'processing-instruction' 'allowing'
    case 37971:                     // 'attribute' 'ancestor'
    case 38010:                     // 'element' 'ancestor'
    case 38075:                     // 'namespace' 'ancestor'
    case 38108:                     // 'processing-instruction' 'ancestor'
    case 38483:                     // 'attribute' 'ancestor-or-self'
    case 38522:                     // 'element' 'ancestor-or-self'
    case 38587:                     // 'namespace' 'ancestor-or-self'
    case 38620:                     // 'processing-instruction' 'ancestor-or-self'
    case 40019:                     // 'attribute' 'append'
    case 40058:                     // 'element' 'append'
    case 40123:                     // 'namespace' 'append'
    case 40156:                     // 'processing-instruction' 'append'
    case 40531:                     // 'attribute' 'array'
    case 40570:                     // 'element' 'array'
    case 42579:                     // 'attribute' 'attribute'
    case 42618:                     // 'element' 'attribute'
    case 42683:                     // 'namespace' 'attribute'
    case 42716:                     // 'processing-instruction' 'attribute'
    case 43091:                     // 'attribute' 'base-uri'
    case 43130:                     // 'element' 'base-uri'
    case 43195:                     // 'namespace' 'base-uri'
    case 43228:                     // 'processing-instruction' 'base-uri'
    case 44115:                     // 'attribute' 'boundary-space'
    case 44154:                     // 'element' 'boundary-space'
    case 44219:                     // 'namespace' 'boundary-space'
    case 44252:                     // 'processing-instruction' 'boundary-space'
    case 44627:                     // 'attribute' 'break'
    case 44666:                     // 'element' 'break'
    case 44731:                     // 'namespace' 'break'
    case 44764:                     // 'processing-instruction' 'break'
    case 47187:                     // 'attribute' 'catch'
    case 47226:                     // 'element' 'catch'
    case 47291:                     // 'namespace' 'catch'
    case 47324:                     // 'processing-instruction' 'catch'
    case 48211:                     // 'attribute' 'child'
    case 48250:                     // 'element' 'child'
    case 48315:                     // 'namespace' 'child'
    case 48348:                     // 'processing-instruction' 'child'
    case 49747:                     // 'attribute' 'comment'
    case 49786:                     // 'element' 'comment'
    case 49851:                     // 'namespace' 'comment'
    case 49884:                     // 'processing-instruction' 'comment'
    case 50259:                     // 'attribute' 'constraint'
    case 50298:                     // 'element' 'constraint'
    case 50363:                     // 'namespace' 'constraint'
    case 50396:                     // 'processing-instruction' 'constraint'
    case 50771:                     // 'attribute' 'construction'
    case 50810:                     // 'element' 'construction'
    case 50875:                     // 'namespace' 'construction'
    case 50908:                     // 'processing-instruction' 'construction'
    case 52307:                     // 'attribute' 'context'
    case 52346:                     // 'element' 'context'
    case 52411:                     // 'namespace' 'context'
    case 52444:                     // 'processing-instruction' 'context'
    case 52819:                     // 'attribute' 'continue'
    case 52858:                     // 'element' 'continue'
    case 52923:                     // 'namespace' 'continue'
    case 52956:                     // 'processing-instruction' 'continue'
    case 53331:                     // 'attribute' 'copy'
    case 53370:                     // 'element' 'copy'
    case 53435:                     // 'namespace' 'copy'
    case 53468:                     // 'processing-instruction' 'copy'
    case 53843:                     // 'attribute' 'copy-namespaces'
    case 53882:                     // 'element' 'copy-namespaces'
    case 53947:                     // 'namespace' 'copy-namespaces'
    case 53980:                     // 'processing-instruction' 'copy-namespaces'
    case 54867:                     // 'attribute' 'decimal-format'
    case 54906:                     // 'element' 'decimal-format'
    case 54971:                     // 'namespace' 'decimal-format'
    case 55004:                     // 'processing-instruction' 'decimal-format'
    case 55891:                     // 'attribute' 'declare'
    case 55930:                     // 'element' 'declare'
    case 55995:                     // 'namespace' 'declare'
    case 56028:                     // 'processing-instruction' 'declare'
    case 56915:                     // 'attribute' 'delete'
    case 56954:                     // 'element' 'delete'
    case 57019:                     // 'namespace' 'delete'
    case 57052:                     // 'processing-instruction' 'delete'
    case 57427:                     // 'attribute' 'descendant'
    case 57466:                     // 'element' 'descendant'
    case 57531:                     // 'namespace' 'descendant'
    case 57564:                     // 'processing-instruction' 'descendant'
    case 57939:                     // 'attribute' 'descendant-or-self'
    case 57978:                     // 'element' 'descendant-or-self'
    case 58043:                     // 'namespace' 'descendant-or-self'
    case 58076:                     // 'processing-instruction' 'descendant-or-self'
    case 61523:                     // 'attribute' 'document'
    case 61562:                     // 'element' 'document'
    case 61627:                     // 'namespace' 'document'
    case 61660:                     // 'processing-instruction' 'document'
    case 62035:                     // 'attribute' 'document-node'
    case 62074:                     // 'element' 'document-node'
    case 62139:                     // 'namespace' 'document-node'
    case 62172:                     // 'processing-instruction' 'document-node'
    case 62547:                     // 'attribute' 'element'
    case 62586:                     // 'element' 'element'
    case 62651:                     // 'namespace' 'element'
    case 62684:                     // 'processing-instruction' 'element'
    case 64083:                     // 'attribute' 'empty-sequence'
    case 64122:                     // 'element' 'empty-sequence'
    case 64187:                     // 'namespace' 'empty-sequence'
    case 64220:                     // 'processing-instruction' 'empty-sequence'
    case 64595:                     // 'attribute' 'encoding'
    case 64634:                     // 'element' 'encoding'
    case 64699:                     // 'namespace' 'encoding'
    case 64732:                     // 'processing-instruction' 'encoding'
    case 66643:                     // 'attribute' 'every'
    case 66682:                     // 'element' 'every'
    case 66747:                     // 'namespace' 'every'
    case 66780:                     // 'processing-instruction' 'every'
    case 68179:                     // 'attribute' 'exit'
    case 68218:                     // 'element' 'exit'
    case 68283:                     // 'namespace' 'exit'
    case 68316:                     // 'processing-instruction' 'exit'
    case 68691:                     // 'attribute' 'external'
    case 68730:                     // 'element' 'external'
    case 68795:                     // 'namespace' 'external'
    case 68828:                     // 'processing-instruction' 'external'
    case 69203:                     // 'attribute' 'false'
    case 69242:                     // 'element' 'false'
    case 69307:                     // 'namespace' 'false'
    case 69340:                     // 'processing-instruction' 'false'
    case 69715:                     // 'attribute' 'first'
    case 69754:                     // 'element' 'first'
    case 69819:                     // 'namespace' 'first'
    case 69852:                     // 'processing-instruction' 'first'
    case 70227:                     // 'attribute' 'following'
    case 70266:                     // 'element' 'following'
    case 70331:                     // 'namespace' 'following'
    case 70364:                     // 'processing-instruction' 'following'
    case 70739:                     // 'attribute' 'following-sibling'
    case 70778:                     // 'element' 'following-sibling'
    case 70843:                     // 'namespace' 'following-sibling'
    case 70876:                     // 'processing-instruction' 'following-sibling'
    case 72787:                     // 'attribute' 'from'
    case 72826:                     // 'element' 'from'
    case 72891:                     // 'namespace' 'from'
    case 72924:                     // 'processing-instruction' 'from'
    case 73299:                     // 'attribute' 'ft-option'
    case 73338:                     // 'element' 'ft-option'
    case 73403:                     // 'namespace' 'ft-option'
    case 73436:                     // 'processing-instruction' 'ft-option'
    case 75347:                     // 'attribute' 'function'
    case 75386:                     // 'element' 'function'
    case 75451:                     // 'namespace' 'function'
    case 75484:                     // 'processing-instruction' 'function'
    case 78931:                     // 'attribute' 'if'
    case 78970:                     // 'element' 'if'
    case 79035:                     // 'namespace' 'if'
    case 79068:                     // 'processing-instruction' 'if'
    case 79443:                     // 'attribute' 'import'
    case 79482:                     // 'element' 'import'
    case 79547:                     // 'namespace' 'import'
    case 79580:                     // 'processing-instruction' 'import'
    case 79955:                     // 'attribute' 'in'
    case 79994:                     // 'element' 'in'
    case 80059:                     // 'namespace' 'in'
    case 80092:                     // 'processing-instruction' 'in'
    case 80467:                     // 'attribute' 'index'
    case 80506:                     // 'element' 'index'
    case 80571:                     // 'namespace' 'index'
    case 80604:                     // 'processing-instruction' 'index'
    case 82515:                     // 'attribute' 'insert'
    case 82554:                     // 'element' 'insert'
    case 82619:                     // 'namespace' 'insert'
    case 82652:                     // 'processing-instruction' 'insert'
    case 83539:                     // 'attribute' 'integrity'
    case 83578:                     // 'element' 'integrity'
    case 83643:                     // 'namespace' 'integrity'
    case 83676:                     // 'processing-instruction' 'integrity'
    case 85587:                     // 'attribute' 'item'
    case 85626:                     // 'element' 'item'
    case 85691:                     // 'namespace' 'item'
    case 85724:                     // 'processing-instruction' 'item'
    case 86099:                     // 'attribute' 'json'
    case 86138:                     // 'element' 'json'
    case 86203:                     // 'namespace' 'json'
    case 86236:                     // 'processing-instruction' 'json'
    case 86611:                     // 'attribute' 'json-item'
    case 86650:                     // 'element' 'json-item'
    case 87123:                     // 'attribute' 'jsoniq'
    case 87162:                     // 'element' 'jsoniq'
    case 87227:                     // 'namespace' 'jsoniq'
    case 87260:                     // 'processing-instruction' 'jsoniq'
    case 88659:                     // 'attribute' 'last'
    case 88698:                     // 'element' 'last'
    case 88763:                     // 'namespace' 'last'
    case 88796:                     // 'processing-instruction' 'last'
    case 89171:                     // 'attribute' 'lax'
    case 89210:                     // 'element' 'lax'
    case 89275:                     // 'namespace' 'lax'
    case 89308:                     // 'processing-instruction' 'lax'
    case 91731:                     // 'attribute' 'loop'
    case 91770:                     // 'element' 'loop'
    case 91835:                     // 'namespace' 'loop'
    case 91868:                     // 'processing-instruction' 'loop'
    case 94803:                     // 'attribute' 'module'
    case 94842:                     // 'element' 'module'
    case 94907:                     // 'namespace' 'module'
    case 94940:                     // 'processing-instruction' 'module'
    case 95827:                     // 'attribute' 'namespace'
    case 95866:                     // 'element' 'namespace'
    case 95931:                     // 'namespace' 'namespace'
    case 95964:                     // 'processing-instruction' 'namespace'
    case 96339:                     // 'attribute' 'namespace-node'
    case 96378:                     // 'element' 'namespace-node'
    case 96443:                     // 'namespace' 'namespace-node'
    case 96476:                     // 'processing-instruction' 'namespace-node'
    case 99411:                     // 'attribute' 'node'
    case 99450:                     // 'element' 'node'
    case 99515:                     // 'namespace' 'node'
    case 99548:                     // 'processing-instruction' 'node'
    case 99923:                     // 'attribute' 'nodes'
    case 99962:                     // 'element' 'nodes'
    case 100027:                    // 'namespace' 'nodes'
    case 100060:                    // 'processing-instruction' 'nodes'
    case 100947:                    // 'attribute' 'null'
    case 100986:                    // 'element' 'null'
    case 101051:                    // 'namespace' 'null'
    case 101084:                    // 'processing-instruction' 'null'
    case 101459:                    // 'attribute' 'object'
    case 101498:                    // 'element' 'object'
    case 101563:                    // 'namespace' 'object'
    case 101596:                    // 'processing-instruction' 'object'
    case 104019:                    // 'attribute' 'option'
    case 104058:                    // 'element' 'option'
    case 104123:                    // 'namespace' 'option'
    case 104156:                    // 'processing-instruction' 'option'
    case 105555:                    // 'attribute' 'ordered'
    case 105594:                    // 'element' 'ordered'
    case 105659:                    // 'namespace' 'ordered'
    case 105692:                    // 'processing-instruction' 'ordered'
    case 106067:                    // 'attribute' 'ordering'
    case 106106:                    // 'element' 'ordering'
    case 106171:                    // 'namespace' 'ordering'
    case 106204:                    // 'processing-instruction' 'ordering'
    case 107603:                    // 'attribute' 'parent'
    case 107642:                    // 'element' 'parent'
    case 107707:                    // 'namespace' 'parent'
    case 107740:                    // 'processing-instruction' 'parent'
    case 110675:                    // 'attribute' 'preceding'
    case 110714:                    // 'element' 'preceding'
    case 110779:                    // 'namespace' 'preceding'
    case 110812:                    // 'processing-instruction' 'preceding'
    case 111187:                    // 'attribute' 'preceding-sibling'
    case 111226:                    // 'element' 'preceding-sibling'
    case 111291:                    // 'namespace' 'preceding-sibling'
    case 111324:                    // 'processing-instruction' 'preceding-sibling'
    case 112723:                    // 'attribute' 'processing-instruction'
    case 112762:                    // 'element' 'processing-instruction'
    case 112827:                    // 'namespace' 'processing-instruction'
    case 112860:                    // 'processing-instruction' 'processing-instruction'
    case 113747:                    // 'attribute' 'rename'
    case 113786:                    // 'element' 'rename'
    case 113851:                    // 'namespace' 'rename'
    case 113884:                    // 'processing-instruction' 'rename'
    case 114259:                    // 'attribute' 'replace'
    case 114298:                    // 'element' 'replace'
    case 114363:                    // 'namespace' 'replace'
    case 114396:                    // 'processing-instruction' 'replace'
    case 115283:                    // 'attribute' 'returning'
    case 115322:                    // 'element' 'returning'
    case 115387:                    // 'namespace' 'returning'
    case 115420:                    // 'processing-instruction' 'returning'
    case 115795:                    // 'attribute' 'revalidation'
    case 115834:                    // 'element' 'revalidation'
    case 115899:                    // 'namespace' 'revalidation'
    case 115932:                    // 'processing-instruction' 'revalidation'
    case 117331:                    // 'attribute' 'schema'
    case 117370:                    // 'element' 'schema'
    case 117435:                    // 'namespace' 'schema'
    case 117468:                    // 'processing-instruction' 'schema'
    case 117843:                    // 'attribute' 'schema-attribute'
    case 117882:                    // 'element' 'schema-attribute'
    case 117947:                    // 'namespace' 'schema-attribute'
    case 117980:                    // 'processing-instruction' 'schema-attribute'
    case 118355:                    // 'attribute' 'schema-element'
    case 118394:                    // 'element' 'schema-element'
    case 118459:                    // 'namespace' 'schema-element'
    case 118492:                    // 'processing-instruction' 'schema-element'
    case 118867:                    // 'attribute' 'score'
    case 118906:                    // 'element' 'score'
    case 118971:                    // 'namespace' 'score'
    case 119004:                    // 'processing-instruction' 'score'
    case 119379:                    // 'attribute' 'select'
    case 119418:                    // 'element' 'select'
    case 119483:                    // 'namespace' 'select'
    case 119516:                    // 'processing-instruction' 'select'
    case 119891:                    // 'attribute' 'self'
    case 119930:                    // 'element' 'self'
    case 119995:                    // 'namespace' 'self'
    case 120028:                    // 'processing-instruction' 'self'
    case 122451:                    // 'attribute' 'sliding'
    case 122490:                    // 'element' 'sliding'
    case 122555:                    // 'namespace' 'sliding'
    case 122588:                    // 'processing-instruction' 'sliding'
    case 122963:                    // 'attribute' 'some'
    case 123002:                    // 'element' 'some'
    case 123067:                    // 'namespace' 'some'
    case 123100:                    // 'processing-instruction' 'some'
    case 125523:                    // 'attribute' 'strict'
    case 125562:                    // 'element' 'strict'
    case 125627:                    // 'namespace' 'strict'
    case 125660:                    // 'processing-instruction' 'strict'
    case 126547:                    // 'attribute' 'structured-item'
    case 126586:                    // 'element' 'structured-item'
    case 127059:                    // 'attribute' 'switch'
    case 127098:                    // 'element' 'switch'
    case 127163:                    // 'namespace' 'switch'
    case 127196:                    // 'processing-instruction' 'switch'
    case 127571:                    // 'attribute' 'text'
    case 127610:                    // 'element' 'text'
    case 127675:                    // 'namespace' 'text'
    case 127708:                    // 'processing-instruction' 'text'
    case 130643:                    // 'attribute' 'true'
    case 130682:                    // 'element' 'true'
    case 130747:                    // 'namespace' 'true'
    case 130780:                    // 'processing-instruction' 'true'
    case 131155:                    // 'attribute' 'try'
    case 131194:                    // 'element' 'try'
    case 131259:                    // 'namespace' 'try'
    case 131292:                    // 'processing-instruction' 'try'
    case 131667:                    // 'attribute' 'tumbling'
    case 131706:                    // 'element' 'tumbling'
    case 131771:                    // 'namespace' 'tumbling'
    case 131804:                    // 'processing-instruction' 'tumbling'
    case 132179:                    // 'attribute' 'type'
    case 132218:                    // 'element' 'type'
    case 132283:                    // 'namespace' 'type'
    case 132316:                    // 'processing-instruction' 'type'
    case 132691:                    // 'attribute' 'typeswitch'
    case 132730:                    // 'element' 'typeswitch'
    case 132795:                    // 'namespace' 'typeswitch'
    case 132828:                    // 'processing-instruction' 'typeswitch'
    case 134227:                    // 'attribute' 'unordered'
    case 134266:                    // 'element' 'unordered'
    case 134331:                    // 'namespace' 'unordered'
    case 134364:                    // 'processing-instruction' 'unordered'
    case 134739:                    // 'attribute' 'updating'
    case 134778:                    // 'element' 'updating'
    case 134843:                    // 'namespace' 'updating'
    case 134876:                    // 'processing-instruction' 'updating'
    case 136275:                    // 'attribute' 'validate'
    case 136314:                    // 'element' 'validate'
    case 136379:                    // 'namespace' 'validate'
    case 136412:                    // 'processing-instruction' 'validate'
    case 136787:                    // 'attribute' 'value'
    case 136826:                    // 'element' 'value'
    case 136891:                    // 'namespace' 'value'
    case 136924:                    // 'processing-instruction' 'value'
    case 137299:                    // 'attribute' 'variable'
    case 137338:                    // 'element' 'variable'
    case 137403:                    // 'namespace' 'variable'
    case 137436:                    // 'processing-instruction' 'variable'
    case 137811:                    // 'attribute' 'version'
    case 137850:                    // 'element' 'version'
    case 137915:                    // 'namespace' 'version'
    case 137948:                    // 'processing-instruction' 'version'
    case 139859:                    // 'attribute' 'while'
    case 139898:                    // 'element' 'while'
    case 139963:                    // 'namespace' 'while'
    case 139996:                    // 'processing-instruction' 'while'
    case 143955:                    // 'attribute' '{'
    case 143969:                    // 'comment' '{'
    case 143992:                    // 'document' '{'
    case 143994:                    // 'element' '{'
    case 144059:                    // 'namespace' '{'
    case 144078:                    // 'ordered' '{'
    case 144092:                    // 'processing-instruction' '{'
    case 144121:                    // 'text' '{'
    case 144134:                    // 'unordered' '{'
      try_PostfixExpr();
      break;
    case -3:
      break;
    default:
      try_AxisStep();
    }
  }

  function parse_AxisStep()
  {
    eventHandler.startNonterminal("AxisStep", e0);
    switch (l1)
    {
    case 74:                        // 'ancestor'
    case 75:                        // 'ancestor-or-self'
    case 210:                       // 'parent'
    case 216:                       // 'preceding'
    case 217:                       // 'preceding-sibling'
      lookahead2W(232);             // S^WS | EOF | '!' | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' | ':' |
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 46:                        // '..'
    case 26698:                     // 'ancestor' '::'
    case 26699:                     // 'ancestor-or-self' '::'
    case 26834:                     // 'parent' '::'
    case 26840:                     // 'preceding' '::'
    case 26841:                     // 'preceding-sibling' '::'
      parse_ReverseStep();
      break;
    default:
      parse_ForwardStep();
    }
    lookahead1W(228);               // S^WS | EOF | '!' | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' | ':' |
    whitespace();
    parse_PredicateList();
    eventHandler.endNonterminal("AxisStep", e0);
  }

  function try_AxisStep()
  {
    switch (l1)
    {
    case 74:                        // 'ancestor'
    case 75:                        // 'ancestor-or-self'
    case 210:                       // 'parent'
    case 216:                       // 'preceding'
    case 217:                       // 'preceding-sibling'
      lookahead2W(232);             // S^WS | EOF | '!' | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' | ':' |
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 46:                        // '..'
    case 26698:                     // 'ancestor' '::'
    case 26699:                     // 'ancestor-or-self' '::'
    case 26834:                     // 'parent' '::'
    case 26840:                     // 'preceding' '::'
    case 26841:                     // 'preceding-sibling' '::'
      try_ReverseStep();
      break;
    default:
      try_ForwardStep();
    }
    lookahead1W(228);               // S^WS | EOF | '!' | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' | ':' |
    try_PredicateList();
  }

  function parse_ForwardStep()
  {
    eventHandler.startNonterminal("ForwardStep", e0);
    switch (l1)
    {
    case 83:                        // 'attribute'
      lookahead2W(236);             // S^WS | EOF | '!' | '!=' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' |
      break;
    case 94:                        // 'child'
    case 112:                       // 'descendant'
    case 113:                       // 'descendant-or-self'
    case 137:                       // 'following'
    case 138:                       // 'following-sibling'
    case 234:                       // 'self'
      lookahead2W(232);             // S^WS | EOF | '!' | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' | ':' |
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 26707:                     // 'attribute' '::'
    case 26718:                     // 'child' '::'
    case 26736:                     // 'descendant' '::'
    case 26737:                     // 'descendant-or-self' '::'
    case 26761:                     // 'following' '::'
    case 26762:                     // 'following-sibling' '::'
    case 26858:                     // 'self' '::'
      parse_ForwardAxis();
      lookahead1W(249);             // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_NodeTest();
      break;
    default:
      parse_AbbrevForwardStep();
    }
    eventHandler.endNonterminal("ForwardStep", e0);
  }

  function try_ForwardStep()
  {
    switch (l1)
    {
    case 83:                        // 'attribute'
      lookahead2W(236);             // S^WS | EOF | '!' | '!=' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' |
      break;
    case 94:                        // 'child'
    case 112:                       // 'descendant'
    case 113:                       // 'descendant-or-self'
    case 137:                       // 'following'
    case 138:                       // 'following-sibling'
    case 234:                       // 'self'
      lookahead2W(232);             // S^WS | EOF | '!' | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' | ':' |
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 26707:                     // 'attribute' '::'
    case 26718:                     // 'child' '::'
    case 26736:                     // 'descendant' '::'
    case 26737:                     // 'descendant-or-self' '::'
    case 26761:                     // 'following' '::'
    case 26762:                     // 'following-sibling' '::'
    case 26858:                     // 'self' '::'
      try_ForwardAxis();
      lookahead1W(249);             // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_NodeTest();
      break;
    default:
      try_AbbrevForwardStep();
    }
  }

  function parse_ForwardAxis()
  {
    eventHandler.startNonterminal("ForwardAxis", e0);
    switch (l1)
    {
    case 94:                        // 'child'
      shift(94);                    // 'child'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    case 112:                       // 'descendant'
      shift(112);                   // 'descendant'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    case 83:                        // 'attribute'
      shift(83);                    // 'attribute'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    case 234:                       // 'self'
      shift(234);                   // 'self'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    case 113:                       // 'descendant-or-self'
      shift(113);                   // 'descendant-or-self'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    case 138:                       // 'following-sibling'
      shift(138);                   // 'following-sibling'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    default:
      shift(137);                   // 'following'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
    }
    eventHandler.endNonterminal("ForwardAxis", e0);
  }

  function try_ForwardAxis()
  {
    switch (l1)
    {
    case 94:                        // 'child'
      shiftT(94);                   // 'child'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    case 112:                       // 'descendant'
      shiftT(112);                  // 'descendant'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    case 83:                        // 'attribute'
      shiftT(83);                   // 'attribute'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    case 234:                       // 'self'
      shiftT(234);                  // 'self'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    case 113:                       // 'descendant-or-self'
      shiftT(113);                  // 'descendant-or-self'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    case 138:                       // 'following-sibling'
      shiftT(138);                  // 'following-sibling'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    default:
      shiftT(137);                  // 'following'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
    }
  }

  function parse_AbbrevForwardStep()
  {
    eventHandler.startNonterminal("AbbrevForwardStep", e0);
    if (l1 == 67)                   // '@'
    {
      shift(67);                    // '@'
    }
    lookahead1W(249);               // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_NodeTest();
    eventHandler.endNonterminal("AbbrevForwardStep", e0);
  }

  function try_AbbrevForwardStep()
  {
    if (l1 == 67)                   // '@'
    {
      shiftT(67);                   // '@'
    }
    lookahead1W(249);               // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_NodeTest();
  }

  function parse_ReverseStep()
  {
    eventHandler.startNonterminal("ReverseStep", e0);
    switch (l1)
    {
    case 46:                        // '..'
      parse_AbbrevReverseStep();
      break;
    default:
      parse_ReverseAxis();
      lookahead1W(249);             // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_NodeTest();
    }
    eventHandler.endNonterminal("ReverseStep", e0);
  }

  function try_ReverseStep()
  {
    switch (l1)
    {
    case 46:                        // '..'
      try_AbbrevReverseStep();
      break;
    default:
      try_ReverseAxis();
      lookahead1W(249);             // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_NodeTest();
    }
  }

  function parse_ReverseAxis()
  {
    eventHandler.startNonterminal("ReverseAxis", e0);
    switch (l1)
    {
    case 210:                       // 'parent'
      shift(210);                   // 'parent'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    case 74:                        // 'ancestor'
      shift(74);                    // 'ancestor'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    case 217:                       // 'preceding-sibling'
      shift(217);                   // 'preceding-sibling'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    case 216:                       // 'preceding'
      shift(216);                   // 'preceding'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
      break;
    default:
      shift(75);                    // 'ancestor-or-self'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shift(52);                    // '::'
    }
    eventHandler.endNonterminal("ReverseAxis", e0);
  }

  function try_ReverseAxis()
  {
    switch (l1)
    {
    case 210:                       // 'parent'
      shiftT(210);                  // 'parent'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    case 74:                        // 'ancestor'
      shiftT(74);                   // 'ancestor'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    case 217:                       // 'preceding-sibling'
      shiftT(217);                  // 'preceding-sibling'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    case 216:                       // 'preceding'
      shiftT(216);                  // 'preceding'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
      break;
    default:
      shiftT(75);                   // 'ancestor-or-self'
      lookahead1W(27);              // S^WS | '(:' | '::'
      shiftT(52);                   // '::'
    }
  }

  function parse_AbbrevReverseStep()
  {
    eventHandler.startNonterminal("AbbrevReverseStep", e0);
    shift(46);                      // '..'
    eventHandler.endNonterminal("AbbrevReverseStep", e0);
  }

  function try_AbbrevReverseStep()
  {
    shiftT(46);                     // '..'
  }

  function parse_NodeTest()
  {
    eventHandler.startNonterminal("NodeTest", e0);
    switch (l1)
    {
    case 83:                        // 'attribute'
    case 97:                        // 'comment'
    case 121:                       // 'document-node'
    case 122:                       // 'element'
    case 188:                       // 'namespace-node'
    case 194:                       // 'node'
    case 220:                       // 'processing-instruction'
    case 230:                       // 'schema-attribute'
    case 231:                       // 'schema-element'
    case 249:                       // 'text'
      lookahead2W(231);             // S^WS | EOF | '!' | '!=' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' |
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 18003:                     // 'attribute' '('
    case 18017:                     // 'comment' '('
    case 18041:                     // 'document-node' '('
    case 18042:                     // 'element' '('
    case 18108:                     // 'namespace-node' '('
    case 18114:                     // 'node' '('
    case 18140:                     // 'processing-instruction' '('
    case 18150:                     // 'schema-attribute' '('
    case 18151:                     // 'schema-element' '('
    case 18169:                     // 'text' '('
      parse_KindTest();
      break;
    default:
      parse_NameTest();
    }
    eventHandler.endNonterminal("NodeTest", e0);
  }

  function try_NodeTest()
  {
    switch (l1)
    {
    case 83:                        // 'attribute'
    case 97:                        // 'comment'
    case 121:                       // 'document-node'
    case 122:                       // 'element'
    case 188:                       // 'namespace-node'
    case 194:                       // 'node'
    case 220:                       // 'processing-instruction'
    case 230:                       // 'schema-attribute'
    case 231:                       // 'schema-element'
    case 249:                       // 'text'
      lookahead2W(231);             // S^WS | EOF | '!' | '!=' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' |
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 18003:                     // 'attribute' '('
    case 18017:                     // 'comment' '('
    case 18041:                     // 'document-node' '('
    case 18042:                     // 'element' '('
    case 18108:                     // 'namespace-node' '('
    case 18114:                     // 'node' '('
    case 18140:                     // 'processing-instruction' '('
    case 18150:                     // 'schema-attribute' '('
    case 18151:                     // 'schema-element' '('
    case 18169:                     // 'text' '('
      try_KindTest();
      break;
    default:
      try_NameTest();
    }
  }

  function parse_NameTest()
  {
    eventHandler.startNonterminal("NameTest", e0);
    switch (l1)
    {
    case 5:                         // Wildcard
      shift(5);                     // Wildcard
      break;
    default:
      parse_EQName();
    }
    eventHandler.endNonterminal("NameTest", e0);
  }

  function try_NameTest()
  {
    switch (l1)
    {
    case 5:                         // Wildcard
      shiftT(5);                    // Wildcard
      break;
    default:
      try_EQName();
    }
  }

  function parse_PostfixExpr()
  {
    eventHandler.startNonterminal("PostfixExpr", e0);
    parse_PrimaryExpr();
    for (;;)
    {
      lookahead1W(235);             // S^WS | EOF | '!' | '!=' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '.' | '/' |
      if (l1 != 35                  // '('
       && l1 != 45                  // '.'
       && l1 != 69)                 // '['
      {
        break;
      }
      switch (l1)
      {
      case 69:                      // '['
        lookahead2W(273);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      default:
        lk = l1;
      }
      if (lk == 35397)              // '[' '['
      {
        lk = memoized(5, e0);
        if (lk == 0)
        {
          var b0A = b0; var e0A = e0; var l1A = l1;
          var b1A = b1; var e1A = e1; var l2A = l2;
          var b2A = b2; var e2A = e2;
          try
          {
            try_Predicate();
            lk = -1;
          }
          catch (p1A)
          {
            lk = -4;
          }
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(5, e0, lk);
        }
      }
      switch (lk)
      {
      case 35:                      // '('
        whitespace();
        parse_ArgumentList();
        break;
      case 45:                      // '.'
        whitespace();
        parse_ObjectLookup();
        break;
      case -4:
        whitespace();
        parse_ArrayLookup();
        break;
      case 35909:                   // '[' ']'
        whitespace();
        parse_ArrayUnboxing();
        break;
      default:
        whitespace();
        parse_Predicate();
      }
    }
    eventHandler.endNonterminal("PostfixExpr", e0);
  }

  function try_PostfixExpr()
  {
    try_PrimaryExpr();
    for (;;)
    {
      lookahead1W(235);             // S^WS | EOF | '!' | '!=' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '.' | '/' |
      if (l1 != 35                  // '('
       && l1 != 45                  // '.'
       && l1 != 69)                 // '['
      {
        break;
      }
      switch (l1)
      {
      case 69:                      // '['
        lookahead2W(273);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      default:
        lk = l1;
      }
      if (lk == 35397)              // '[' '['
      {
        lk = memoized(5, e0);
        if (lk == 0)
        {
          var b0A = b0; var e0A = e0; var l1A = l1;
          var b1A = b1; var e1A = e1; var l2A = l2;
          var b2A = b2; var e2A = e2;
          try
          {
            try_Predicate();
            memoize(5, e0A, -1);
            lk = -6;
          }
          catch (p1A)
          {
            lk = -4;
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            memoize(5, e0A, -4);
          }
        }
      }
      switch (lk)
      {
      case 35:                      // '('
        try_ArgumentList();
        break;
      case 45:                      // '.'
        try_ObjectLookup();
        break;
      case -4:
        try_ArrayLookup();
        break;
      case 35909:                   // '[' ']'
        try_ArrayUnboxing();
        break;
      case -6:
        break;
      default:
        try_Predicate();
      }
    }
  }

  function parse_ObjectLookup()
  {
    eventHandler.startNonterminal("ObjectLookup", e0);
    shift(45);                      // '.'
    lookahead1W(251);               // StringLiteral | NCName^Token | S^WS | '$' | '$$' | '(' | '(:' | 'after' |
    switch (l1)
    {
    case 11:                        // StringLiteral
      shift(11);                    // StringLiteral
      break;
    case 35:                        // '('
      whitespace();
      parse_ParenthesizedExpr();
      break;
    case 31:                        // '$'
      whitespace();
      parse_VarRef();
      break;
    case 32:                        // '$$'
      whitespace();
      parse_ContextItemExpr();
      break;
    default:
      whitespace();
      parse_NCName();
    }
    eventHandler.endNonterminal("ObjectLookup", e0);
  }

  function try_ObjectLookup()
  {
    shiftT(45);                     // '.'
    lookahead1W(251);               // StringLiteral | NCName^Token | S^WS | '$' | '$$' | '(' | '(:' | 'after' |
    switch (l1)
    {
    case 11:                        // StringLiteral
      shiftT(11);                   // StringLiteral
      break;
    case 35:                        // '('
      try_ParenthesizedExpr();
      break;
    case 31:                        // '$'
      try_VarRef();
      break;
    case 32:                        // '$$'
      try_ContextItemExpr();
      break;
    default:
      try_NCName();
    }
  }

  function parse_ArrayLookup()
  {
    eventHandler.startNonterminal("ArrayLookup", e0);
    shift(69);                      // '['
    lookahead1W(31);                // S^WS | '(:' | '['
    shift(69);                      // '['
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(70);                      // ']'
    lookahead1W(32);                // S^WS | '(:' | ']'
    shift(70);                      // ']'
    eventHandler.endNonterminal("ArrayLookup", e0);
  }

  function try_ArrayLookup()
  {
    shiftT(69);                     // '['
    lookahead1W(31);                // S^WS | '(:' | '['
    shiftT(69);                     // '['
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(70);                     // ']'
    lookahead1W(32);                // S^WS | '(:' | ']'
    shiftT(70);                     // ']'
  }

  function parse_ArrayUnboxing()
  {
    eventHandler.startNonterminal("ArrayUnboxing", e0);
    shift(69);                      // '['
    lookahead1W(32);                // S^WS | '(:' | ']'
    shift(70);                      // ']'
    eventHandler.endNonterminal("ArrayUnboxing", e0);
  }

  function try_ArrayUnboxing()
  {
    shiftT(69);                     // '['
    lookahead1W(32);                // S^WS | '(:' | ']'
    shiftT(70);                     // ']'
  }

  function parse_ArgumentList()
  {
    eventHandler.startNonterminal("ArgumentList", e0);
    shift(35);                      // '('
    lookahead1W(280);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    if (l1 != 38)                   // ')'
    {
      whitespace();
      parse_Argument();
      for (;;)
      {
        lookahead1W(105);           // S^WS | '(:' | ')' | ','
        if (l1 != 42)               // ','
        {
          break;
        }
        shift(42);                  // ','
        lookahead1W(272);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        whitespace();
        parse_Argument();
      }
    }
    shift(38);                      // ')'
    eventHandler.endNonterminal("ArgumentList", e0);
  }

  function try_ArgumentList()
  {
    shiftT(35);                     // '('
    lookahead1W(280);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    if (l1 != 38)                   // ')'
    {
      try_Argument();
      for (;;)
      {
        lookahead1W(105);           // S^WS | '(:' | ')' | ','
        if (l1 != 42)               // ','
        {
          break;
        }
        shiftT(42);                 // ','
        lookahead1W(272);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        try_Argument();
      }
    }
    shiftT(38);                     // ')'
  }

  function parse_PredicateList()
  {
    eventHandler.startNonterminal("PredicateList", e0);
    for (;;)
    {
      lookahead1W(228);             // S^WS | EOF | '!' | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' | ':' |
      if (l1 != 69)                 // '['
      {
        break;
      }
      whitespace();
      parse_Predicate();
    }
    eventHandler.endNonterminal("PredicateList", e0);
  }

  function try_PredicateList()
  {
    for (;;)
    {
      lookahead1W(228);             // S^WS | EOF | '!' | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | '/' | '//' | ':' |
      if (l1 != 69)                 // '['
      {
        break;
      }
      try_Predicate();
    }
  }

  function parse_Predicate()
  {
    eventHandler.startNonterminal("Predicate", e0);
    shift(69);                      // '['
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(70);                      // ']'
    eventHandler.endNonterminal("Predicate", e0);
  }

  function try_Predicate()
  {
    shiftT(69);                     // '['
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(70);                     // ']'
  }

  function parse_Literal()
  {
    eventHandler.startNonterminal("Literal", e0);
    switch (l1)
    {
    case 11:                        // StringLiteral
      shift(11);                    // StringLiteral
      break;
    case 135:                       // 'false'
    case 255:                       // 'true'
      parse_BooleanLiteral();
      break;
    case 197:                       // 'null'
      parse_NullLiteral();
      break;
    default:
      parse_NumericLiteral();
    }
    eventHandler.endNonterminal("Literal", e0);
  }

  function try_Literal()
  {
    switch (l1)
    {
    case 11:                        // StringLiteral
      shiftT(11);                   // StringLiteral
      break;
    case 135:                       // 'false'
    case 255:                       // 'true'
      try_BooleanLiteral();
      break;
    case 197:                       // 'null'
      try_NullLiteral();
      break;
    default:
      try_NumericLiteral();
    }
  }

  function parse_BooleanLiteral()
  {
    eventHandler.startNonterminal("BooleanLiteral", e0);
    switch (l1)
    {
    case 255:                       // 'true'
      shift(255);                   // 'true'
      break;
    default:
      shift(135);                   // 'false'
    }
    eventHandler.endNonterminal("BooleanLiteral", e0);
  }

  function try_BooleanLiteral()
  {
    switch (l1)
    {
    case 255:                       // 'true'
      shiftT(255);                  // 'true'
      break;
    default:
      shiftT(135);                  // 'false'
    }
  }

  function parse_NullLiteral()
  {
    eventHandler.startNonterminal("NullLiteral", e0);
    shift(197);                     // 'null'
    eventHandler.endNonterminal("NullLiteral", e0);
  }

  function try_NullLiteral()
  {
    shiftT(197);                    // 'null'
  }

  function parse_NumericLiteral()
  {
    eventHandler.startNonterminal("NumericLiteral", e0);
    switch (l1)
    {
    case 8:                         // IntegerLiteral
      shift(8);                     // IntegerLiteral
      break;
    case 9:                         // DecimalLiteral
      shift(9);                     // DecimalLiteral
      break;
    default:
      shift(10);                    // DoubleLiteral
    }
    eventHandler.endNonterminal("NumericLiteral", e0);
  }

  function try_NumericLiteral()
  {
    switch (l1)
    {
    case 8:                         // IntegerLiteral
      shiftT(8);                    // IntegerLiteral
      break;
    case 9:                         // DecimalLiteral
      shiftT(9);                    // DecimalLiteral
      break;
    default:
      shiftT(10);                   // DoubleLiteral
    }
  }

  function parse_VarRef()
  {
    eventHandler.startNonterminal("VarRef", e0);
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    eventHandler.endNonterminal("VarRef", e0);
  }

  function try_VarRef()
  {
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
  }

  function parse_VarName()
  {
    eventHandler.startNonterminal("VarName", e0);
    parse_EQName();
    eventHandler.endNonterminal("VarName", e0);
  }

  function try_VarName()
  {
    try_EQName();
  }

  function parse_ParenthesizedExpr()
  {
    eventHandler.startNonterminal("ParenthesizedExpr", e0);
    shift(35);                      // '('
    lookahead1W(270);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    if (l1 != 38)                   // ')'
    {
      whitespace();
      parse_Expr();
    }
    shift(38);                      // ')'
    eventHandler.endNonterminal("ParenthesizedExpr", e0);
  }

  function try_ParenthesizedExpr()
  {
    shiftT(35);                     // '('
    lookahead1W(270);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    if (l1 != 38)                   // ')'
    {
      try_Expr();
    }
    shiftT(38);                     // ')'
  }

  function parse_ContextItemExpr()
  {
    eventHandler.startNonterminal("ContextItemExpr", e0);
    shift(32);                      // '$$'
    eventHandler.endNonterminal("ContextItemExpr", e0);
  }

  function try_ContextItemExpr()
  {
    shiftT(32);                     // '$$'
  }

  function parse_OrderedExpr()
  {
    eventHandler.startNonterminal("OrderedExpr", e0);
    shift(206);                     // 'ordered'
    lookahead1W(90);                // S^WS | '(:' | '{'
    shift(281);                     // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(287);                     // '}'
    eventHandler.endNonterminal("OrderedExpr", e0);
  }

  function try_OrderedExpr()
  {
    shiftT(206);                    // 'ordered'
    lookahead1W(90);                // S^WS | '(:' | '{'
    shiftT(281);                    // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(287);                    // '}'
  }

  function parse_UnorderedExpr()
  {
    eventHandler.startNonterminal("UnorderedExpr", e0);
    shift(262);                     // 'unordered'
    lookahead1W(90);                // S^WS | '(:' | '{'
    shift(281);                     // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(287);                     // '}'
    eventHandler.endNonterminal("UnorderedExpr", e0);
  }

  function try_UnorderedExpr()
  {
    shiftT(262);                    // 'unordered'
    lookahead1W(90);                // S^WS | '(:' | '{'
    shiftT(281);                    // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(287);                    // '}'
  }

  function parse_FunctionCall()
  {
    eventHandler.startNonterminal("FunctionCall", e0);
    parse_FunctionName();
    lookahead1W(22);                // S^WS | '(' | '(:'
    whitespace();
    parse_ArgumentList();
    eventHandler.endNonterminal("FunctionCall", e0);
  }

  function try_FunctionCall()
  {
    try_FunctionName();
    lookahead1W(22);                // S^WS | '(' | '(:'
    try_ArgumentList();
  }

  function parse_Argument()
  {
    eventHandler.startNonterminal("Argument", e0);
    switch (l1)
    {
    case 65:                        // '?'
      parse_ArgumentPlaceholder();
      break;
    default:
      parse_ExprSingle();
    }
    eventHandler.endNonterminal("Argument", e0);
  }

  function try_Argument()
  {
    switch (l1)
    {
    case 65:                        // '?'
      try_ArgumentPlaceholder();
      break;
    default:
      try_ExprSingle();
    }
  }

  function parse_ArgumentPlaceholder()
  {
    eventHandler.startNonterminal("ArgumentPlaceholder", e0);
    shift(65);                      // '?'
    eventHandler.endNonterminal("ArgumentPlaceholder", e0);
  }

  function try_ArgumentPlaceholder()
  {
    shiftT(65);                     // '?'
  }

  function parse_Constructor()
  {
    eventHandler.startNonterminal("Constructor", e0);
    switch (l1)
    {
    case 55:                        // '<'
    case 56:                        // '<!--'
    case 60:                        // '<?'
      parse_DirectConstructor();
      break;
    default:
      parse_ComputedConstructor();
    }
    eventHandler.endNonterminal("Constructor", e0);
  }

  function try_Constructor()
  {
    switch (l1)
    {
    case 55:                        // '<'
    case 56:                        // '<!--'
    case 60:                        // '<?'
      try_DirectConstructor();
      break;
    default:
      try_ComputedConstructor();
    }
  }

  function parse_DirectConstructor()
  {
    eventHandler.startNonterminal("DirectConstructor", e0);
    switch (l1)
    {
    case 55:                        // '<'
      parse_DirElemConstructor();
      break;
    case 56:                        // '<!--'
      parse_DirCommentConstructor();
      break;
    default:
      parse_DirPIConstructor();
    }
    eventHandler.endNonterminal("DirectConstructor", e0);
  }

  function try_DirectConstructor()
  {
    switch (l1)
    {
    case 55:                        // '<'
      try_DirElemConstructor();
      break;
    case 56:                        // '<!--'
      try_DirCommentConstructor();
      break;
    default:
      try_DirPIConstructor();
    }
  }

  function parse_DirElemConstructor()
  {
    eventHandler.startNonterminal("DirElemConstructor", e0);
    shift(55);                      // '<'
    lookahead1(4);                  // QName
    shift(20);                      // QName
    parse_DirAttributeList();
    switch (l1)
    {
    case 49:                        // '/>'
      shift(49);                    // '/>'
      break;
    default:
      shift(62);                    // '>'
      for (;;)
      {
        lookahead1(196);            // CDataSection | PredefinedEntityRef | ElementContentChar | CharRef | '<' |
        if (l1 == 57)               // '</'
        {
          break;
        }
        parse_DirElemContent();
      }
      shift(57);                    // '</'
      lookahead1(4);                // QName
      shift(20);                    // QName
      lookahead1(12);               // S | '>'
      if (l1 == 21)                 // S
      {
        shift(21);                  // S
      }
      lookahead1(8);                // '>'
      shift(62);                    // '>'
    }
    eventHandler.endNonterminal("DirElemConstructor", e0);
  }

  function try_DirElemConstructor()
  {
    shiftT(55);                     // '<'
    lookahead1(4);                  // QName
    shiftT(20);                     // QName
    try_DirAttributeList();
    switch (l1)
    {
    case 49:                        // '/>'
      shiftT(49);                   // '/>'
      break;
    default:
      shiftT(62);                   // '>'
      for (;;)
      {
        lookahead1(196);            // CDataSection | PredefinedEntityRef | ElementContentChar | CharRef | '<' |
        if (l1 == 57)               // '</'
        {
          break;
        }
        try_DirElemContent();
      }
      shiftT(57);                   // '</'
      lookahead1(4);                // QName
      shiftT(20);                   // QName
      lookahead1(12);               // S | '>'
      if (l1 == 21)                 // S
      {
        shiftT(21);                 // S
      }
      lookahead1(8);                // '>'
      shiftT(62);                   // '>'
    }
  }

  function parse_DirAttributeList()
  {
    eventHandler.startNonterminal("DirAttributeList", e0);
    for (;;)
    {
      lookahead1(19);               // S | '/>' | '>'
      if (l1 != 21)                 // S
      {
        break;
      }
      shift(21);                    // S
      lookahead1(94);               // QName | S | '/>' | '>'
      if (l1 == 20)                 // QName
      {
        shift(20);                  // QName
        lookahead1(11);             // S | '='
        if (l1 == 21)               // S
        {
          shift(21);                // S
        }
        lookahead1(7);              // '='
        shift(61);                  // '='
        lookahead1(18);             // S | '"' | "'"
        if (l1 == 21)               // S
        {
          shift(21);                // S
        }
        parse_DirAttributeValue();
      }
    }
    eventHandler.endNonterminal("DirAttributeList", e0);
  }

  function try_DirAttributeList()
  {
    for (;;)
    {
      lookahead1(19);               // S | '/>' | '>'
      if (l1 != 21)                 // S
      {
        break;
      }
      shiftT(21);                   // S
      lookahead1(94);               // QName | S | '/>' | '>'
      if (l1 == 20)                 // QName
      {
        shiftT(20);                 // QName
        lookahead1(11);             // S | '='
        if (l1 == 21)               // S
        {
          shiftT(21);               // S
        }
        lookahead1(7);              // '='
        shiftT(61);                 // '='
        lookahead1(18);             // S | '"' | "'"
        if (l1 == 21)               // S
        {
          shiftT(21);               // S
        }
        try_DirAttributeValue();
      }
    }
  }

  function parse_DirAttributeValue()
  {
    eventHandler.startNonterminal("DirAttributeValue", e0);
    lookahead1(14);                 // '"' | "'"
    switch (l1)
    {
    case 28:                        // '"'
      shift(28);                    // '"'
      for (;;)
      {
        lookahead1(185);            // PredefinedEntityRef | EscapeQuot | QuotAttrContentChar | CharRef | '"' | '{' |
        if (l1 == 28)               // '"'
        {
          break;
        }
        switch (l1)
        {
        case 13:                    // EscapeQuot
          shift(13);                // EscapeQuot
          break;
        default:
          parse_QuotAttrValueContent();
        }
      }
      shift(28);                    // '"'
      break;
    default:
      shift(34);                    // "'"
      for (;;)
      {
        lookahead1(186);            // PredefinedEntityRef | EscapeApos | AposAttrContentChar | CharRef | "'" | '{' |
        if (l1 == 34)               // "'"
        {
          break;
        }
        switch (l1)
        {
        case 14:                    // EscapeApos
          shift(14);                // EscapeApos
          break;
        default:
          parse_AposAttrValueContent();
        }
      }
      shift(34);                    // "'"
    }
    eventHandler.endNonterminal("DirAttributeValue", e0);
  }

  function try_DirAttributeValue()
  {
    lookahead1(14);                 // '"' | "'"
    switch (l1)
    {
    case 28:                        // '"'
      shiftT(28);                   // '"'
      for (;;)
      {
        lookahead1(185);            // PredefinedEntityRef | EscapeQuot | QuotAttrContentChar | CharRef | '"' | '{' |
        if (l1 == 28)               // '"'
        {
          break;
        }
        switch (l1)
        {
        case 13:                    // EscapeQuot
          shiftT(13);               // EscapeQuot
          break;
        default:
          try_QuotAttrValueContent();
        }
      }
      shiftT(28);                   // '"'
      break;
    default:
      shiftT(34);                   // "'"
      for (;;)
      {
        lookahead1(186);            // PredefinedEntityRef | EscapeApos | AposAttrContentChar | CharRef | "'" | '{' |
        if (l1 == 34)               // "'"
        {
          break;
        }
        switch (l1)
        {
        case 14:                    // EscapeApos
          shiftT(14);               // EscapeApos
          break;
        default:
          try_AposAttrValueContent();
        }
      }
      shiftT(34);                   // "'"
    }
  }

  function parse_QuotAttrValueContent()
  {
    eventHandler.startNonterminal("QuotAttrValueContent", e0);
    switch (l1)
    {
    case 16:                        // QuotAttrContentChar
      shift(16);                    // QuotAttrContentChar
      break;
    default:
      parse_CommonContent();
    }
    eventHandler.endNonterminal("QuotAttrValueContent", e0);
  }

  function try_QuotAttrValueContent()
  {
    switch (l1)
    {
    case 16:                        // QuotAttrContentChar
      shiftT(16);                   // QuotAttrContentChar
      break;
    default:
      try_CommonContent();
    }
  }

  function parse_AposAttrValueContent()
  {
    eventHandler.startNonterminal("AposAttrValueContent", e0);
    switch (l1)
    {
    case 17:                        // AposAttrContentChar
      shift(17);                    // AposAttrContentChar
      break;
    default:
      parse_CommonContent();
    }
    eventHandler.endNonterminal("AposAttrValueContent", e0);
  }

  function try_AposAttrValueContent()
  {
    switch (l1)
    {
    case 17:                        // AposAttrContentChar
      shiftT(17);                   // AposAttrContentChar
      break;
    default:
      try_CommonContent();
    }
  }

  function parse_DirElemContent()
  {
    eventHandler.startNonterminal("DirElemContent", e0);
    switch (l1)
    {
    case 55:                        // '<'
    case 56:                        // '<!--'
    case 60:                        // '<?'
      parse_DirectConstructor();
      break;
    case 4:                         // CDataSection
      shift(4);                     // CDataSection
      break;
    case 15:                        // ElementContentChar
      shift(15);                    // ElementContentChar
      break;
    default:
      parse_CommonContent();
    }
    eventHandler.endNonterminal("DirElemContent", e0);
  }

  function try_DirElemContent()
  {
    switch (l1)
    {
    case 55:                        // '<'
    case 56:                        // '<!--'
    case 60:                        // '<?'
      try_DirectConstructor();
      break;
    case 4:                         // CDataSection
      shiftT(4);                    // CDataSection
      break;
    case 15:                        // ElementContentChar
      shiftT(15);                   // ElementContentChar
      break;
    default:
      try_CommonContent();
    }
  }

  function parse_DirCommentConstructor()
  {
    eventHandler.startNonterminal("DirCommentConstructor", e0);
    shift(56);                      // '<!--'
    lookahead1(1);                  // DirCommentContents
    shift(2);                       // DirCommentContents
    lookahead1(6);                  // '-->'
    shift(44);                      // '-->'
    eventHandler.endNonterminal("DirCommentConstructor", e0);
  }

  function try_DirCommentConstructor()
  {
    shiftT(56);                     // '<!--'
    lookahead1(1);                  // DirCommentContents
    shiftT(2);                      // DirCommentContents
    lookahead1(6);                  // '-->'
    shiftT(44);                     // '-->'
  }

  function parse_DirPIConstructor()
  {
    eventHandler.startNonterminal("DirPIConstructor", e0);
    shift(60);                      // '<?'
    lookahead1(3);                  // PITarget
    shift(18);                      // PITarget
    lookahead1(13);                 // S | '?>'
    if (l1 == 21)                   // S
    {
      shift(21);                    // S
      lookahead1(2);                // DirPIContents
      shift(3);                     // DirPIContents
    }
    lookahead1(9);                  // '?>'
    shift(66);                      // '?>'
    eventHandler.endNonterminal("DirPIConstructor", e0);
  }

  function try_DirPIConstructor()
  {
    shiftT(60);                     // '<?'
    lookahead1(3);                  // PITarget
    shiftT(18);                     // PITarget
    lookahead1(13);                 // S | '?>'
    if (l1 == 21)                   // S
    {
      shiftT(21);                   // S
      lookahead1(2);                // DirPIContents
      shiftT(3);                    // DirPIContents
    }
    lookahead1(9);                  // '?>'
    shiftT(66);                     // '?>'
  }

  function parse_ComputedConstructor()
  {
    eventHandler.startNonterminal("ComputedConstructor", e0);
    switch (l1)
    {
    case 120:                       // 'document'
      parse_CompDocConstructor();
      break;
    case 122:                       // 'element'
      parse_CompElemConstructor();
      break;
    case 83:                        // 'attribute'
      parse_CompAttrConstructor();
      break;
    case 187:                       // 'namespace'
      parse_CompNamespaceConstructor();
      break;
    case 249:                       // 'text'
      parse_CompTextConstructor();
      break;
    case 97:                        // 'comment'
      parse_CompCommentConstructor();
      break;
    default:
      parse_CompPIConstructor();
    }
    eventHandler.endNonterminal("ComputedConstructor", e0);
  }

  function try_ComputedConstructor()
  {
    switch (l1)
    {
    case 120:                       // 'document'
      try_CompDocConstructor();
      break;
    case 122:                       // 'element'
      try_CompElemConstructor();
      break;
    case 83:                        // 'attribute'
      try_CompAttrConstructor();
      break;
    case 187:                       // 'namespace'
      try_CompNamespaceConstructor();
      break;
    case 249:                       // 'text'
      try_CompTextConstructor();
      break;
    case 97:                        // 'comment'
      try_CompCommentConstructor();
      break;
    default:
      try_CompPIConstructor();
    }
  }

  function parse_CompElemConstructor()
  {
    eventHandler.startNonterminal("CompElemConstructor", e0);
    shift(122);                     // 'element'
    lookahead1W(250);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    switch (l1)
    {
    case 281:                       // '{'
      shift(281);                   // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_Expr();
      shift(287);                   // '}'
      break;
    default:
      whitespace();
      parse_EQName();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    shift(281);                     // '{'
    lookahead1W(281);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    if (l1 != 287)                  // '}'
    {
      whitespace();
      parse_ContentExpr();
    }
    shift(287);                     // '}'
    eventHandler.endNonterminal("CompElemConstructor", e0);
  }

  function try_CompElemConstructor()
  {
    shiftT(122);                    // 'element'
    lookahead1W(250);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    switch (l1)
    {
    case 281:                       // '{'
      shiftT(281);                  // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_Expr();
      shiftT(287);                  // '}'
      break;
    default:
      try_EQName();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    shiftT(281);                    // '{'
    lookahead1W(281);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    if (l1 != 287)                  // '}'
    {
      try_ContentExpr();
    }
    shiftT(287);                    // '}'
  }

  function parse_CompNamespaceConstructor()
  {
    eventHandler.startNonterminal("CompNamespaceConstructor", e0);
    shift(187);                     // 'namespace'
    lookahead1W(242);               // NCName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    switch (l1)
    {
    case 281:                       // '{'
      shift(281);                   // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_PrefixExpr();
      shift(287);                   // '}'
      break;
    default:
      whitespace();
      parse_Prefix();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    shift(281);                     // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_URIExpr();
    shift(287);                     // '}'
    eventHandler.endNonterminal("CompNamespaceConstructor", e0);
  }

  function try_CompNamespaceConstructor()
  {
    shiftT(187);                    // 'namespace'
    lookahead1W(242);               // NCName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    switch (l1)
    {
    case 281:                       // '{'
      shiftT(281);                  // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_PrefixExpr();
      shiftT(287);                  // '}'
      break;
    default:
      try_Prefix();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    shiftT(281);                    // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_URIExpr();
    shiftT(287);                    // '}'
  }

  function parse_Prefix()
  {
    eventHandler.startNonterminal("Prefix", e0);
    parse_NCName();
    eventHandler.endNonterminal("Prefix", e0);
  }

  function try_Prefix()
  {
    try_NCName();
  }

  function parse_PrefixExpr()
  {
    eventHandler.startNonterminal("PrefixExpr", e0);
    parse_Expr();
    eventHandler.endNonterminal("PrefixExpr", e0);
  }

  function try_PrefixExpr()
  {
    try_Expr();
  }

  function parse_URIExpr()
  {
    eventHandler.startNonterminal("URIExpr", e0);
    parse_Expr();
    eventHandler.endNonterminal("URIExpr", e0);
  }

  function try_URIExpr()
  {
    try_Expr();
  }

  function parse_FunctionItemExpr()
  {
    eventHandler.startNonterminal("FunctionItemExpr", e0);
    switch (l1)
    {
    case 147:                       // 'function'
      lookahead2W(95);              // S^WS | '#' | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 33:                        // '%'
    case 18067:                     // 'function' '('
      parse_InlineFunctionExpr();
      break;
    default:
      parse_NamedFunctionRef();
    }
    eventHandler.endNonterminal("FunctionItemExpr", e0);
  }

  function try_FunctionItemExpr()
  {
    switch (l1)
    {
    case 147:                       // 'function'
      lookahead2W(95);              // S^WS | '#' | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 33:                        // '%'
    case 18067:                     // 'function' '('
      try_InlineFunctionExpr();
      break;
    default:
      try_NamedFunctionRef();
    }
  }

  function parse_NamedFunctionRef()
  {
    eventHandler.startNonterminal("NamedFunctionRef", e0);
    parse_EQName();
    lookahead1W(20);                // S^WS | '#' | '(:'
    shift(29);                      // '#'
    lookahead1W(16);                // IntegerLiteral | S^WS | '(:'
    shift(8);                       // IntegerLiteral
    eventHandler.endNonterminal("NamedFunctionRef", e0);
  }

  function try_NamedFunctionRef()
  {
    try_EQName();
    lookahead1W(20);                // S^WS | '#' | '(:'
    shiftT(29);                     // '#'
    lookahead1W(16);                // IntegerLiteral | S^WS | '(:'
    shiftT(8);                      // IntegerLiteral
  }

  function parse_InlineFunctionExpr()
  {
    eventHandler.startNonterminal("InlineFunctionExpr", e0);
    for (;;)
    {
      lookahead1W(101);             // S^WS | '%' | '(:' | 'function'
      if (l1 != 33)                 // '%'
      {
        break;
      }
      whitespace();
      parse_Annotation();
    }
    shift(147);                     // 'function'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(98);                // S^WS | '$' | '(:' | ')'
    if (l1 == 31)                   // '$'
    {
      whitespace();
      parse_ParamList();
    }
    shift(38);                      // ')'
    lookahead1W(115);               // S^WS | '(:' | 'as' | '{'
    if (l1 == 80)                   // 'as'
    {
      shift(80);                    // 'as'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_SequenceType();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    whitespace();
    parse_FunctionBody();
    eventHandler.endNonterminal("InlineFunctionExpr", e0);
  }

  function try_InlineFunctionExpr()
  {
    for (;;)
    {
      lookahead1W(101);             // S^WS | '%' | '(:' | 'function'
      if (l1 != 33)                 // '%'
      {
        break;
      }
      try_Annotation();
    }
    shiftT(147);                    // 'function'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(98);                // S^WS | '$' | '(:' | ')'
    if (l1 == 31)                   // '$'
    {
      try_ParamList();
    }
    shiftT(38);                     // ')'
    lookahead1W(115);               // S^WS | '(:' | 'as' | '{'
    if (l1 == 80)                   // 'as'
    {
      shiftT(80);                   // 'as'
      lookahead1W(254);             // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_SequenceType();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    try_FunctionBody();
  }

  function parse_SingleType()
  {
    eventHandler.startNonterminal("SingleType", e0);
    parse_SimpleTypeName();
    lookahead1W(226);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 65)                   // '?'
    {
      shift(65);                    // '?'
    }
    eventHandler.endNonterminal("SingleType", e0);
  }

  function try_SingleType()
  {
    try_SimpleTypeName();
    lookahead1W(226);               // S^WS | EOF | '!=' | '(:' | ')' | '*' | '+' | ',' | '-' | ':' | ';' | '<' | '<<' |
    if (l1 == 65)                   // '?'
    {
      shiftT(65);                   // '?'
    }
  }

  function parse_TypeDeclaration()
  {
    eventHandler.startNonterminal("TypeDeclaration", e0);
    shift(80);                      // 'as'
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_SequenceType();
    eventHandler.endNonterminal("TypeDeclaration", e0);
  }

  function try_TypeDeclaration()
  {
    shiftT(80);                     // 'as'
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_SequenceType();
  }

  function parse_SequenceType()
  {
    eventHandler.startNonterminal("SequenceType", e0);
    switch (l1)
    {
    case 35:                        // '('
      lookahead2W(259);             // EQName^Token | S^WS | '%' | '(' | '(:' | ')' | 'after' | 'allowing' |
      break;
    case 125:                       // 'empty-sequence'
      lookahead2W(233);             // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 18045:                     // 'empty-sequence' '('
    case 19491:                     // '(' ')'
      if (l1 == 125)                // 'empty-sequence'
      {
        shift(125);                 // 'empty-sequence'
      }
      lookahead1W(22);              // S^WS | '(' | '(:'
      shift(35);                    // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shift(38);                    // ')'
      break;
    default:
      parse_ItemType();
      lookahead1W(229);             // S^WS | EOF | '!=' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' | ';' |
      switch (l1)
      {
      case 40:                      // '*'
      case 41:                      // '+'
      case 65:                      // '?'
        whitespace();
        parse_OccurrenceIndicator();
        break;
      default:
        break;
      }
    }
    eventHandler.endNonterminal("SequenceType", e0);
  }

  function try_SequenceType()
  {
    switch (l1)
    {
    case 35:                        // '('
      lookahead2W(259);             // EQName^Token | S^WS | '%' | '(' | '(:' | ')' | 'after' | 'allowing' |
      break;
    case 125:                       // 'empty-sequence'
      lookahead2W(233);             // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 18045:                     // 'empty-sequence' '('
    case 19491:                     // '(' ')'
      if (l1 == 125)                // 'empty-sequence'
      {
        shiftT(125);                // 'empty-sequence'
      }
      lookahead1W(22);              // S^WS | '(' | '(:'
      shiftT(35);                   // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shiftT(38);                   // ')'
      break;
    default:
      try_ItemType();
      lookahead1W(229);             // S^WS | EOF | '!=' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' | ';' |
      switch (l1)
      {
      case 40:                      // '*'
      case 41:                      // '+'
      case 65:                      // '?'
        try_OccurrenceIndicator();
        break;
      default:
        break;
      }
    }
  }

  function parse_OccurrenceIndicator()
  {
    eventHandler.startNonterminal("OccurrenceIndicator", e0);
    switch (l1)
    {
    case 65:                        // '?'
      shift(65);                    // '?'
      break;
    case 40:                        // '*'
      shift(40);                    // '*'
      break;
    default:
      shift(41);                    // '+'
    }
    eventHandler.endNonterminal("OccurrenceIndicator", e0);
  }

  function try_OccurrenceIndicator()
  {
    switch (l1)
    {
    case 65:                        // '?'
      shiftT(65);                   // '?'
      break;
    case 40:                        // '*'
      shiftT(40);                   // '*'
      break;
    default:
      shiftT(41);                   // '+'
    }
  }

  function parse_ItemType()
  {
    eventHandler.startNonterminal("ItemType", e0);
    switch (l1)
    {
    case 79:                        // 'array'
    case 83:                        // 'attribute'
    case 97:                        // 'comment'
    case 121:                       // 'document-node'
    case 122:                       // 'element'
    case 147:                       // 'function'
    case 167:                       // 'item'
    case 169:                       // 'json-item'
    case 188:                       // 'namespace-node'
    case 194:                       // 'node'
    case 198:                       // 'object'
    case 220:                       // 'processing-instruction'
    case 230:                       // 'schema-attribute'
    case 231:                       // 'schema-element'
    case 247:                       // 'structured-item'
    case 249:                       // 'text'
      lookahead2W(233);             // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
      break;
    default:
      lk = l1;
    }
    if (lk == 12879                 // 'array' EOF
     || lk == 12969                 // 'json-item' EOF
     || lk == 12998                 // 'object' EOF
     || lk == 13047                 // 'structured-item' EOF
     || lk == 13903                 // 'array' '!='
     || lk == 13993                 // 'json-item' '!='
     || lk == 14022                 // 'object' '!='
     || lk == 14071                 // 'structured-item' '!='
     || lk == 19535                 // 'array' ')'
     || lk == 19625                 // 'json-item' ')'
     || lk == 19654                 // 'object' ')'
     || lk == 19703                 // 'structured-item' ')'
     || lk == 20047                 // 'array' '*'
     || lk == 20137                 // 'json-item' '*'
     || lk == 20166                 // 'object' '*'
     || lk == 20215                 // 'structured-item' '*'
     || lk == 20559                 // 'array' '*'
     || lk == 20649                 // 'json-item' '*'
     || lk == 20678                 // 'object' '*'
     || lk == 20727                 // 'structured-item' '*'
     || lk == 21071                 // 'array' '+'
     || lk == 21161                 // 'json-item' '+'
     || lk == 21190                 // 'object' '+'
     || lk == 21239                 // 'structured-item' '+'
     || lk == 21583                 // 'array' ','
     || lk == 21673                 // 'json-item' ','
     || lk == 21702                 // 'object' ','
     || lk == 21751                 // 'structured-item' ','
     || lk == 22095                 // 'array' '-'
     || lk == 22185                 // 'json-item' '-'
     || lk == 22214                 // 'object' '-'
     || lk == 22263                 // 'structured-item' '-'
     || lk == 25679                 // 'array' ':'
     || lk == 25769                 // 'json-item' ':'
     || lk == 25798                 // 'object' ':'
     || lk == 25847                 // 'structured-item' ':'
     || lk == 27215                 // 'array' ':='
     || lk == 27305                 // 'json-item' ':='
     || lk == 27334                 // 'object' ':='
     || lk == 27383                 // 'structured-item' ':='
     || lk == 27727                 // 'array' ';'
     || lk == 27817                 // 'json-item' ';'
     || lk == 27846                 // 'object' ';'
     || lk == 27895                 // 'structured-item' ';'
     || lk == 28239                 // 'array' '<'
     || lk == 28329                 // 'json-item' '<'
     || lk == 28358                 // 'object' '<'
     || lk == 28407                 // 'structured-item' '<'
     || lk == 29775                 // 'array' '<<'
     || lk == 29865                 // 'json-item' '<<'
     || lk == 29894                 // 'object' '<<'
     || lk == 29943                 // 'structured-item' '<<'
     || lk == 30287                 // 'array' '<='
     || lk == 30377                 // 'json-item' '<='
     || lk == 30406                 // 'object' '<='
     || lk == 30455                 // 'structured-item' '<='
     || lk == 31311                 // 'array' '='
     || lk == 31401                 // 'json-item' '='
     || lk == 31430                 // 'object' '='
     || lk == 31479                 // 'structured-item' '='
     || lk == 31823                 // 'array' '>'
     || lk == 31913                 // 'json-item' '>'
     || lk == 31942                 // 'object' '>'
     || lk == 31991                 // 'structured-item' '>'
     || lk == 32335                 // 'array' '>='
     || lk == 32425                 // 'json-item' '>='
     || lk == 32454                 // 'object' '>='
     || lk == 32503                 // 'structured-item' '>='
     || lk == 32847                 // 'array' '>>'
     || lk == 32937                 // 'json-item' '>>'
     || lk == 32966                 // 'object' '>>'
     || lk == 33015                 // 'structured-item' '>>'
     || lk == 33359                 // 'array' '?'
     || lk == 33449                 // 'json-item' '?'
     || lk == 33478                 // 'object' '?'
     || lk == 33527                 // 'structured-item' '?'
     || lk == 35919                 // 'array' ']'
     || lk == 36009                 // 'json-item' ']'
     || lk == 36038                 // 'object' ']'
     || lk == 36087                 // 'structured-item' ']'
     || lk == 36431                 // 'array' 'after'
     || lk == 36521                 // 'json-item' 'after'
     || lk == 36550                 // 'object' 'after'
     || lk == 36599                 // 'structured-item' 'after'
     || lk == 37455                 // 'array' 'allowing'
     || lk == 37545                 // 'json-item' 'allowing'
     || lk == 37574                 // 'object' 'allowing'
     || lk == 37623                 // 'structured-item' 'allowing'
     || lk == 38991                 // 'array' 'and'
     || lk == 39081                 // 'json-item' 'and'
     || lk == 39110                 // 'object' 'and'
     || lk == 39159                 // 'structured-item' 'and'
     || lk == 41039                 // 'array' 'as'
     || lk == 41129                 // 'json-item' 'as'
     || lk == 41158                 // 'object' 'as'
     || lk == 41207                 // 'structured-item' 'as'
     || lk == 41551                 // 'array' 'ascending'
     || lk == 41641                 // 'json-item' 'ascending'
     || lk == 41670                 // 'object' 'ascending'
     || lk == 41719                 // 'structured-item' 'ascending'
     || lk == 42063                 // 'array' 'at'
     || lk == 42153                 // 'json-item' 'at'
     || lk == 42182                 // 'object' 'at'
     || lk == 42231                 // 'structured-item' 'at'
     || lk == 43599                 // 'array' 'before'
     || lk == 43689                 // 'json-item' 'before'
     || lk == 43718                 // 'object' 'before'
     || lk == 43767                 // 'structured-item' 'before'
     || lk == 45647                 // 'array' 'case'
     || lk == 45737                 // 'json-item' 'case'
     || lk == 45766                 // 'object' 'case'
     || lk == 45815                 // 'structured-item' 'case'
     || lk == 48719                 // 'array' 'collation'
     || lk == 48809                 // 'json-item' 'collation'
     || lk == 48838                 // 'object' 'collation'
     || lk == 48887                 // 'structured-item' 'collation'
     || lk == 51279                 // 'array' 'contains'
     || lk == 51369                 // 'json-item' 'contains'
     || lk == 51398                 // 'object' 'contains'
     || lk == 51447                 // 'structured-item' 'contains'
     || lk == 54351                 // 'array' 'count'
     || lk == 54441                 // 'json-item' 'count'
     || lk == 54470                 // 'object' 'count'
     || lk == 54519                 // 'structured-item' 'count'
     || lk == 56399                 // 'array' 'default'
     || lk == 56489                 // 'json-item' 'default'
     || lk == 56518                 // 'object' 'default'
     || lk == 56567                 // 'structured-item' 'default'
     || lk == 58447                 // 'array' 'descending'
     || lk == 58537                 // 'json-item' 'descending'
     || lk == 58566                 // 'object' 'descending'
     || lk == 58615                 // 'structured-item' 'descending'
     || lk == 61007                 // 'array' 'div'
     || lk == 61097                 // 'json-item' 'div'
     || lk == 61126                 // 'object' 'div'
     || lk == 61175                 // 'structured-item' 'div'
     || lk == 63055                 // 'array' 'else'
     || lk == 63145                 // 'json-item' 'else'
     || lk == 63174                 // 'object' 'else'
     || lk == 63223                 // 'structured-item' 'else'
     || lk == 63567                 // 'array' 'empty'
     || lk == 63657                 // 'json-item' 'empty'
     || lk == 63686                 // 'object' 'empty'
     || lk == 63735                 // 'structured-item' 'empty'
     || lk == 65103                 // 'array' 'end'
     || lk == 65193                 // 'json-item' 'end'
     || lk == 65222                 // 'object' 'end'
     || lk == 65271                 // 'structured-item' 'end'
     || lk == 66127                 // 'array' 'eq'
     || lk == 66217                 // 'json-item' 'eq'
     || lk == 66246                 // 'object' 'eq'
     || lk == 66295                 // 'structured-item' 'eq'
     || lk == 67663                 // 'array' 'except'
     || lk == 67753                 // 'json-item' 'except'
     || lk == 67782                 // 'object' 'except'
     || lk == 67831                 // 'structured-item' 'except'
     || lk == 68687                 // 'array' 'external'
     || lk == 68777                 // 'json-item' 'external'
     || lk == 68806                 // 'object' 'external'
     || lk == 68855                 // 'structured-item' 'external'
     || lk == 71247                 // 'array' 'for'
     || lk == 71337                 // 'json-item' 'for'
     || lk == 71366                 // 'object' 'for'
     || lk == 71415                 // 'structured-item' 'for'
     || lk == 75855                 // 'array' 'ge'
     || lk == 75945                 // 'json-item' 'ge'
     || lk == 75974                 // 'object' 'ge'
     || lk == 76023                 // 'structured-item' 'ge'
     || lk == 76879                 // 'array' 'group'
     || lk == 76969                 // 'json-item' 'group'
     || lk == 76998                 // 'object' 'group'
     || lk == 77047                 // 'structured-item' 'group'
     || lk == 77903                 // 'array' 'gt'
     || lk == 77993                 // 'json-item' 'gt'
     || lk == 78022                 // 'object' 'gt'
     || lk == 78071                 // 'structured-item' 'gt'
     || lk == 78415                 // 'array' 'idiv'
     || lk == 78505                 // 'json-item' 'idiv'
     || lk == 78534                 // 'object' 'idiv'
     || lk == 78583                 // 'structured-item' 'idiv'
     || lk == 79951                 // 'array' 'in'
     || lk == 80041                 // 'json-item' 'in'
     || lk == 80070                 // 'object' 'in'
     || lk == 80119                 // 'structured-item' 'in'
     || lk == 83023                 // 'array' 'instance'
     || lk == 83113                 // 'json-item' 'instance'
     || lk == 83142                 // 'object' 'instance'
     || lk == 83191                 // 'structured-item' 'instance'
     || lk == 84047                 // 'array' 'intersect'
     || lk == 84137                 // 'json-item' 'intersect'
     || lk == 84166                 // 'object' 'intersect'
     || lk == 84215                 // 'structured-item' 'intersect'
     || lk == 84559                 // 'array' 'into'
     || lk == 84649                 // 'json-item' 'into'
     || lk == 84678                 // 'object' 'into'
     || lk == 84727                 // 'structured-item' 'into'
     || lk == 85071                 // 'array' 'is'
     || lk == 85161                 // 'json-item' 'is'
     || lk == 85190                 // 'object' 'is'
     || lk == 85239                 // 'structured-item' 'is'
     || lk == 89679                 // 'array' 'le'
     || lk == 89769                 // 'json-item' 'le'
     || lk == 89798                 // 'object' 'le'
     || lk == 89847                 // 'structured-item' 'le'
     || lk == 90703                 // 'array' 'let'
     || lk == 90793                 // 'json-item' 'let'
     || lk == 90822                 // 'object' 'let'
     || lk == 90871                 // 'structured-item' 'let'
     || lk == 92751                 // 'array' 'lt'
     || lk == 92841                 // 'json-item' 'lt'
     || lk == 92870                 // 'object' 'lt'
     || lk == 92919                 // 'structured-item' 'lt'
     || lk == 93775                 // 'array' 'mod'
     || lk == 93865                 // 'json-item' 'mod'
     || lk == 93894                 // 'object' 'mod'
     || lk == 93943                 // 'structured-item' 'mod'
     || lk == 94287                 // 'array' 'modify'
     || lk == 94377                 // 'json-item' 'modify'
     || lk == 94406                 // 'object' 'modify'
     || lk == 94455                 // 'structured-item' 'modify'
     || lk == 96847                 // 'array' 'ne'
     || lk == 96937                 // 'json-item' 'ne'
     || lk == 96966                 // 'object' 'ne'
     || lk == 97015                 // 'structured-item' 'ne'
     || lk == 103503                // 'array' 'only'
     || lk == 103593                // 'json-item' 'only'
     || lk == 103622                // 'object' 'only'
     || lk == 103671                // 'structured-item' 'only'
     || lk == 104527                // 'array' 'or'
     || lk == 104617                // 'json-item' 'or'
     || lk == 104646                // 'object' 'or'
     || lk == 104695                // 'structured-item' 'or'
     || lk == 105039                // 'array' 'order'
     || lk == 105129                // 'json-item' 'order'
     || lk == 105158                // 'object' 'order'
     || lk == 105207                // 'structured-item' 'order'
     || lk == 107087                // 'array' 'paragraphs'
     || lk == 107177                // 'json-item' 'paragraphs'
     || lk == 107206                // 'object' 'paragraphs'
     || lk == 107255                // 'structured-item' 'paragraphs'
     || lk == 114767                // 'array' 'return'
     || lk == 114857                // 'json-item' 'return'
     || lk == 114886                // 'object' 'return'
     || lk == 114935                // 'structured-item' 'return'
     || lk == 116815                // 'array' 'satisfies'
     || lk == 116905                // 'json-item' 'satisfies'
     || lk == 116934                // 'object' 'satisfies'
     || lk == 116983                // 'structured-item' 'satisfies'
     || lk == 118863                // 'array' 'score'
     || lk == 118953                // 'json-item' 'score'
     || lk == 118982                // 'object' 'score'
     || lk == 119031                // 'structured-item' 'score'
     || lk == 121423                // 'array' 'sentences'
     || lk == 121513                // 'json-item' 'sentences'
     || lk == 121542                // 'object' 'sentences'
     || lk == 121591                // 'structured-item' 'sentences'
     || lk == 123471                // 'array' 'stable'
     || lk == 123561                // 'json-item' 'stable'
     || lk == 123590                // 'object' 'stable'
     || lk == 123639                // 'structured-item' 'stable'
     || lk == 123983                // 'array' 'start'
     || lk == 124073                // 'json-item' 'start'
     || lk == 124102                // 'object' 'start'
     || lk == 124151                // 'structured-item' 'start'
     || lk == 129103                // 'array' 'times'
     || lk == 129193                // 'json-item' 'times'
     || lk == 129222                // 'object' 'times'
     || lk == 129271                // 'structured-item' 'times'
     || lk == 129615                // 'array' 'to'
     || lk == 129705                // 'json-item' 'to'
     || lk == 129734                // 'object' 'to'
     || lk == 129783                // 'structured-item' 'to'
     || lk == 133199                // 'array' 'union'
     || lk == 133289                // 'json-item' 'union'
     || lk == 133318                // 'object' 'union'
     || lk == 133367                // 'structured-item' 'union'
     || lk == 139343                // 'array' 'where'
     || lk == 139433                // 'json-item' 'where'
     || lk == 139462                // 'object' 'where'
     || lk == 139511                // 'structured-item' 'where'
     || lk == 141391                // 'array' 'with'
     || lk == 141481                // 'json-item' 'with'
     || lk == 141510                // 'object' 'with'
     || lk == 141559                // 'structured-item' 'with'
     || lk == 142927                // 'array' 'words'
     || lk == 143017                // 'json-item' 'words'
     || lk == 143046                // 'object' 'words'
     || lk == 143095                // 'structured-item' 'words'
     || lk == 143951                // 'array' '{'
     || lk == 144041                // 'json-item' '{'
     || lk == 144070                // 'object' '{'
     || lk == 144119                // 'structured-item' '{'
     || lk == 145487                // 'array' '|'
     || lk == 145577                // 'json-item' '|'
     || lk == 145606                // 'object' '|'
     || lk == 145655                // 'structured-item' '|'
     || lk == 145999                // 'array' '||'
     || lk == 146089                // 'json-item' '||'
     || lk == 146118                // 'object' '||'
     || lk == 146167                // 'structured-item' '||'
     || lk == 146511                // 'array' '|}'
     || lk == 146601                // 'json-item' '|}'
     || lk == 146630                // 'object' '|}'
     || lk == 146679                // 'structured-item' '|}'
     || lk == 147023                // 'array' '}'
     || lk == 147113                // 'json-item' '}'
     || lk == 147142                // 'object' '}'
     || lk == 147191)               // 'structured-item' '}'
    {
      lk = memoized(6, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_AtomicOrUnionType();
          lk = -4;
        }
        catch (p4A)
        {
          try
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            try_JSONTest();
            lk = -6;
          }
          catch (p6A)
          {
            lk = -7;
          }
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(6, e0, lk);
      }
    }
    switch (lk)
    {
    case 18003:                     // 'attribute' '('
    case 18017:                     // 'comment' '('
    case 18041:                     // 'document-node' '('
    case 18042:                     // 'element' '('
    case 18108:                     // 'namespace-node' '('
    case 18114:                     // 'node' '('
    case 18140:                     // 'processing-instruction' '('
    case 18150:                     // 'schema-attribute' '('
    case 18151:                     // 'schema-element' '('
    case 18169:                     // 'text' '('
      parse_KindTest();
      break;
    case 18087:                     // 'item' '('
      shift(167);                   // 'item'
      lookahead1W(22);              // S^WS | '(' | '(:'
      shift(35);                    // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shift(38);                    // ')'
      break;
    case 33:                        // '%'
    case 18067:                     // 'function' '('
      parse_FunctionTest();
      break;
    case 35:                        // '('
      parse_ParenthesizedItemType();
      break;
    case -6:
    case 17999:                     // 'array' '('
    case 18089:                     // 'json-item' '('
    case 18118:                     // 'object' '('
      parse_JSONTest();
      break;
    case -7:
    case 18167:                     // 'structured-item' '('
      parse_StructuredItemTest();
      break;
    default:
      parse_AtomicOrUnionType();
    }
    eventHandler.endNonterminal("ItemType", e0);
  }

  function try_ItemType()
  {
    switch (l1)
    {
    case 79:                        // 'array'
    case 83:                        // 'attribute'
    case 97:                        // 'comment'
    case 121:                       // 'document-node'
    case 122:                       // 'element'
    case 147:                       // 'function'
    case 167:                       // 'item'
    case 169:                       // 'json-item'
    case 188:                       // 'namespace-node'
    case 194:                       // 'node'
    case 198:                       // 'object'
    case 220:                       // 'processing-instruction'
    case 230:                       // 'schema-attribute'
    case 231:                       // 'schema-element'
    case 247:                       // 'structured-item'
    case 249:                       // 'text'
      lookahead2W(233);             // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
      break;
    default:
      lk = l1;
    }
    if (lk == 12879                 // 'array' EOF
     || lk == 12969                 // 'json-item' EOF
     || lk == 12998                 // 'object' EOF
     || lk == 13047                 // 'structured-item' EOF
     || lk == 13903                 // 'array' '!='
     || lk == 13993                 // 'json-item' '!='
     || lk == 14022                 // 'object' '!='
     || lk == 14071                 // 'structured-item' '!='
     || lk == 19535                 // 'array' ')'
     || lk == 19625                 // 'json-item' ')'
     || lk == 19654                 // 'object' ')'
     || lk == 19703                 // 'structured-item' ')'
     || lk == 20047                 // 'array' '*'
     || lk == 20137                 // 'json-item' '*'
     || lk == 20166                 // 'object' '*'
     || lk == 20215                 // 'structured-item' '*'
     || lk == 20559                 // 'array' '*'
     || lk == 20649                 // 'json-item' '*'
     || lk == 20678                 // 'object' '*'
     || lk == 20727                 // 'structured-item' '*'
     || lk == 21071                 // 'array' '+'
     || lk == 21161                 // 'json-item' '+'
     || lk == 21190                 // 'object' '+'
     || lk == 21239                 // 'structured-item' '+'
     || lk == 21583                 // 'array' ','
     || lk == 21673                 // 'json-item' ','
     || lk == 21702                 // 'object' ','
     || lk == 21751                 // 'structured-item' ','
     || lk == 22095                 // 'array' '-'
     || lk == 22185                 // 'json-item' '-'
     || lk == 22214                 // 'object' '-'
     || lk == 22263                 // 'structured-item' '-'
     || lk == 25679                 // 'array' ':'
     || lk == 25769                 // 'json-item' ':'
     || lk == 25798                 // 'object' ':'
     || lk == 25847                 // 'structured-item' ':'
     || lk == 27215                 // 'array' ':='
     || lk == 27305                 // 'json-item' ':='
     || lk == 27334                 // 'object' ':='
     || lk == 27383                 // 'structured-item' ':='
     || lk == 27727                 // 'array' ';'
     || lk == 27817                 // 'json-item' ';'
     || lk == 27846                 // 'object' ';'
     || lk == 27895                 // 'structured-item' ';'
     || lk == 28239                 // 'array' '<'
     || lk == 28329                 // 'json-item' '<'
     || lk == 28358                 // 'object' '<'
     || lk == 28407                 // 'structured-item' '<'
     || lk == 29775                 // 'array' '<<'
     || lk == 29865                 // 'json-item' '<<'
     || lk == 29894                 // 'object' '<<'
     || lk == 29943                 // 'structured-item' '<<'
     || lk == 30287                 // 'array' '<='
     || lk == 30377                 // 'json-item' '<='
     || lk == 30406                 // 'object' '<='
     || lk == 30455                 // 'structured-item' '<='
     || lk == 31311                 // 'array' '='
     || lk == 31401                 // 'json-item' '='
     || lk == 31430                 // 'object' '='
     || lk == 31479                 // 'structured-item' '='
     || lk == 31823                 // 'array' '>'
     || lk == 31913                 // 'json-item' '>'
     || lk == 31942                 // 'object' '>'
     || lk == 31991                 // 'structured-item' '>'
     || lk == 32335                 // 'array' '>='
     || lk == 32425                 // 'json-item' '>='
     || lk == 32454                 // 'object' '>='
     || lk == 32503                 // 'structured-item' '>='
     || lk == 32847                 // 'array' '>>'
     || lk == 32937                 // 'json-item' '>>'
     || lk == 32966                 // 'object' '>>'
     || lk == 33015                 // 'structured-item' '>>'
     || lk == 33359                 // 'array' '?'
     || lk == 33449                 // 'json-item' '?'
     || lk == 33478                 // 'object' '?'
     || lk == 33527                 // 'structured-item' '?'
     || lk == 35919                 // 'array' ']'
     || lk == 36009                 // 'json-item' ']'
     || lk == 36038                 // 'object' ']'
     || lk == 36087                 // 'structured-item' ']'
     || lk == 36431                 // 'array' 'after'
     || lk == 36521                 // 'json-item' 'after'
     || lk == 36550                 // 'object' 'after'
     || lk == 36599                 // 'structured-item' 'after'
     || lk == 37455                 // 'array' 'allowing'
     || lk == 37545                 // 'json-item' 'allowing'
     || lk == 37574                 // 'object' 'allowing'
     || lk == 37623                 // 'structured-item' 'allowing'
     || lk == 38991                 // 'array' 'and'
     || lk == 39081                 // 'json-item' 'and'
     || lk == 39110                 // 'object' 'and'
     || lk == 39159                 // 'structured-item' 'and'
     || lk == 41039                 // 'array' 'as'
     || lk == 41129                 // 'json-item' 'as'
     || lk == 41158                 // 'object' 'as'
     || lk == 41207                 // 'structured-item' 'as'
     || lk == 41551                 // 'array' 'ascending'
     || lk == 41641                 // 'json-item' 'ascending'
     || lk == 41670                 // 'object' 'ascending'
     || lk == 41719                 // 'structured-item' 'ascending'
     || lk == 42063                 // 'array' 'at'
     || lk == 42153                 // 'json-item' 'at'
     || lk == 42182                 // 'object' 'at'
     || lk == 42231                 // 'structured-item' 'at'
     || lk == 43599                 // 'array' 'before'
     || lk == 43689                 // 'json-item' 'before'
     || lk == 43718                 // 'object' 'before'
     || lk == 43767                 // 'structured-item' 'before'
     || lk == 45647                 // 'array' 'case'
     || lk == 45737                 // 'json-item' 'case'
     || lk == 45766                 // 'object' 'case'
     || lk == 45815                 // 'structured-item' 'case'
     || lk == 48719                 // 'array' 'collation'
     || lk == 48809                 // 'json-item' 'collation'
     || lk == 48838                 // 'object' 'collation'
     || lk == 48887                 // 'structured-item' 'collation'
     || lk == 51279                 // 'array' 'contains'
     || lk == 51369                 // 'json-item' 'contains'
     || lk == 51398                 // 'object' 'contains'
     || lk == 51447                 // 'structured-item' 'contains'
     || lk == 54351                 // 'array' 'count'
     || lk == 54441                 // 'json-item' 'count'
     || lk == 54470                 // 'object' 'count'
     || lk == 54519                 // 'structured-item' 'count'
     || lk == 56399                 // 'array' 'default'
     || lk == 56489                 // 'json-item' 'default'
     || lk == 56518                 // 'object' 'default'
     || lk == 56567                 // 'structured-item' 'default'
     || lk == 58447                 // 'array' 'descending'
     || lk == 58537                 // 'json-item' 'descending'
     || lk == 58566                 // 'object' 'descending'
     || lk == 58615                 // 'structured-item' 'descending'
     || lk == 61007                 // 'array' 'div'
     || lk == 61097                 // 'json-item' 'div'
     || lk == 61126                 // 'object' 'div'
     || lk == 61175                 // 'structured-item' 'div'
     || lk == 63055                 // 'array' 'else'
     || lk == 63145                 // 'json-item' 'else'
     || lk == 63174                 // 'object' 'else'
     || lk == 63223                 // 'structured-item' 'else'
     || lk == 63567                 // 'array' 'empty'
     || lk == 63657                 // 'json-item' 'empty'
     || lk == 63686                 // 'object' 'empty'
     || lk == 63735                 // 'structured-item' 'empty'
     || lk == 65103                 // 'array' 'end'
     || lk == 65193                 // 'json-item' 'end'
     || lk == 65222                 // 'object' 'end'
     || lk == 65271                 // 'structured-item' 'end'
     || lk == 66127                 // 'array' 'eq'
     || lk == 66217                 // 'json-item' 'eq'
     || lk == 66246                 // 'object' 'eq'
     || lk == 66295                 // 'structured-item' 'eq'
     || lk == 67663                 // 'array' 'except'
     || lk == 67753                 // 'json-item' 'except'
     || lk == 67782                 // 'object' 'except'
     || lk == 67831                 // 'structured-item' 'except'
     || lk == 68687                 // 'array' 'external'
     || lk == 68777                 // 'json-item' 'external'
     || lk == 68806                 // 'object' 'external'
     || lk == 68855                 // 'structured-item' 'external'
     || lk == 71247                 // 'array' 'for'
     || lk == 71337                 // 'json-item' 'for'
     || lk == 71366                 // 'object' 'for'
     || lk == 71415                 // 'structured-item' 'for'
     || lk == 75855                 // 'array' 'ge'
     || lk == 75945                 // 'json-item' 'ge'
     || lk == 75974                 // 'object' 'ge'
     || lk == 76023                 // 'structured-item' 'ge'
     || lk == 76879                 // 'array' 'group'
     || lk == 76969                 // 'json-item' 'group'
     || lk == 76998                 // 'object' 'group'
     || lk == 77047                 // 'structured-item' 'group'
     || lk == 77903                 // 'array' 'gt'
     || lk == 77993                 // 'json-item' 'gt'
     || lk == 78022                 // 'object' 'gt'
     || lk == 78071                 // 'structured-item' 'gt'
     || lk == 78415                 // 'array' 'idiv'
     || lk == 78505                 // 'json-item' 'idiv'
     || lk == 78534                 // 'object' 'idiv'
     || lk == 78583                 // 'structured-item' 'idiv'
     || lk == 79951                 // 'array' 'in'
     || lk == 80041                 // 'json-item' 'in'
     || lk == 80070                 // 'object' 'in'
     || lk == 80119                 // 'structured-item' 'in'
     || lk == 83023                 // 'array' 'instance'
     || lk == 83113                 // 'json-item' 'instance'
     || lk == 83142                 // 'object' 'instance'
     || lk == 83191                 // 'structured-item' 'instance'
     || lk == 84047                 // 'array' 'intersect'
     || lk == 84137                 // 'json-item' 'intersect'
     || lk == 84166                 // 'object' 'intersect'
     || lk == 84215                 // 'structured-item' 'intersect'
     || lk == 84559                 // 'array' 'into'
     || lk == 84649                 // 'json-item' 'into'
     || lk == 84678                 // 'object' 'into'
     || lk == 84727                 // 'structured-item' 'into'
     || lk == 85071                 // 'array' 'is'
     || lk == 85161                 // 'json-item' 'is'
     || lk == 85190                 // 'object' 'is'
     || lk == 85239                 // 'structured-item' 'is'
     || lk == 89679                 // 'array' 'le'
     || lk == 89769                 // 'json-item' 'le'
     || lk == 89798                 // 'object' 'le'
     || lk == 89847                 // 'structured-item' 'le'
     || lk == 90703                 // 'array' 'let'
     || lk == 90793                 // 'json-item' 'let'
     || lk == 90822                 // 'object' 'let'
     || lk == 90871                 // 'structured-item' 'let'
     || lk == 92751                 // 'array' 'lt'
     || lk == 92841                 // 'json-item' 'lt'
     || lk == 92870                 // 'object' 'lt'
     || lk == 92919                 // 'structured-item' 'lt'
     || lk == 93775                 // 'array' 'mod'
     || lk == 93865                 // 'json-item' 'mod'
     || lk == 93894                 // 'object' 'mod'
     || lk == 93943                 // 'structured-item' 'mod'
     || lk == 94287                 // 'array' 'modify'
     || lk == 94377                 // 'json-item' 'modify'
     || lk == 94406                 // 'object' 'modify'
     || lk == 94455                 // 'structured-item' 'modify'
     || lk == 96847                 // 'array' 'ne'
     || lk == 96937                 // 'json-item' 'ne'
     || lk == 96966                 // 'object' 'ne'
     || lk == 97015                 // 'structured-item' 'ne'
     || lk == 103503                // 'array' 'only'
     || lk == 103593                // 'json-item' 'only'
     || lk == 103622                // 'object' 'only'
     || lk == 103671                // 'structured-item' 'only'
     || lk == 104527                // 'array' 'or'
     || lk == 104617                // 'json-item' 'or'
     || lk == 104646                // 'object' 'or'
     || lk == 104695                // 'structured-item' 'or'
     || lk == 105039                // 'array' 'order'
     || lk == 105129                // 'json-item' 'order'
     || lk == 105158                // 'object' 'order'
     || lk == 105207                // 'structured-item' 'order'
     || lk == 107087                // 'array' 'paragraphs'
     || lk == 107177                // 'json-item' 'paragraphs'
     || lk == 107206                // 'object' 'paragraphs'
     || lk == 107255                // 'structured-item' 'paragraphs'
     || lk == 114767                // 'array' 'return'
     || lk == 114857                // 'json-item' 'return'
     || lk == 114886                // 'object' 'return'
     || lk == 114935                // 'structured-item' 'return'
     || lk == 116815                // 'array' 'satisfies'
     || lk == 116905                // 'json-item' 'satisfies'
     || lk == 116934                // 'object' 'satisfies'
     || lk == 116983                // 'structured-item' 'satisfies'
     || lk == 118863                // 'array' 'score'
     || lk == 118953                // 'json-item' 'score'
     || lk == 118982                // 'object' 'score'
     || lk == 119031                // 'structured-item' 'score'
     || lk == 121423                // 'array' 'sentences'
     || lk == 121513                // 'json-item' 'sentences'
     || lk == 121542                // 'object' 'sentences'
     || lk == 121591                // 'structured-item' 'sentences'
     || lk == 123471                // 'array' 'stable'
     || lk == 123561                // 'json-item' 'stable'
     || lk == 123590                // 'object' 'stable'
     || lk == 123639                // 'structured-item' 'stable'
     || lk == 123983                // 'array' 'start'
     || lk == 124073                // 'json-item' 'start'
     || lk == 124102                // 'object' 'start'
     || lk == 124151                // 'structured-item' 'start'
     || lk == 129103                // 'array' 'times'
     || lk == 129193                // 'json-item' 'times'
     || lk == 129222                // 'object' 'times'
     || lk == 129271                // 'structured-item' 'times'
     || lk == 129615                // 'array' 'to'
     || lk == 129705                // 'json-item' 'to'
     || lk == 129734                // 'object' 'to'
     || lk == 129783                // 'structured-item' 'to'
     || lk == 133199                // 'array' 'union'
     || lk == 133289                // 'json-item' 'union'
     || lk == 133318                // 'object' 'union'
     || lk == 133367                // 'structured-item' 'union'
     || lk == 139343                // 'array' 'where'
     || lk == 139433                // 'json-item' 'where'
     || lk == 139462                // 'object' 'where'
     || lk == 139511                // 'structured-item' 'where'
     || lk == 141391                // 'array' 'with'
     || lk == 141481                // 'json-item' 'with'
     || lk == 141510                // 'object' 'with'
     || lk == 141559                // 'structured-item' 'with'
     || lk == 142927                // 'array' 'words'
     || lk == 143017                // 'json-item' 'words'
     || lk == 143046                // 'object' 'words'
     || lk == 143095                // 'structured-item' 'words'
     || lk == 143951                // 'array' '{'
     || lk == 144041                // 'json-item' '{'
     || lk == 144070                // 'object' '{'
     || lk == 144119                // 'structured-item' '{'
     || lk == 145487                // 'array' '|'
     || lk == 145577                // 'json-item' '|'
     || lk == 145606                // 'object' '|'
     || lk == 145655                // 'structured-item' '|'
     || lk == 145999                // 'array' '||'
     || lk == 146089                // 'json-item' '||'
     || lk == 146118                // 'object' '||'
     || lk == 146167                // 'structured-item' '||'
     || lk == 146511                // 'array' '|}'
     || lk == 146601                // 'json-item' '|}'
     || lk == 146630                // 'object' '|}'
     || lk == 146679                // 'structured-item' '|}'
     || lk == 147023                // 'array' '}'
     || lk == 147113                // 'json-item' '}'
     || lk == 147142                // 'object' '}'
     || lk == 147191)               // 'structured-item' '}'
    {
      lk = memoized(6, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_AtomicOrUnionType();
          memoize(6, e0A, -4);
          lk = -8;
        }
        catch (p4A)
        {
          try
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            try_JSONTest();
            memoize(6, e0A, -6);
            lk = -8;
          }
          catch (p6A)
          {
            lk = -7;
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            memoize(6, e0A, -7);
          }
        }
      }
    }
    switch (lk)
    {
    case 18003:                     // 'attribute' '('
    case 18017:                     // 'comment' '('
    case 18041:                     // 'document-node' '('
    case 18042:                     // 'element' '('
    case 18108:                     // 'namespace-node' '('
    case 18114:                     // 'node' '('
    case 18140:                     // 'processing-instruction' '('
    case 18150:                     // 'schema-attribute' '('
    case 18151:                     // 'schema-element' '('
    case 18169:                     // 'text' '('
      try_KindTest();
      break;
    case 18087:                     // 'item' '('
      shiftT(167);                  // 'item'
      lookahead1W(22);              // S^WS | '(' | '(:'
      shiftT(35);                   // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shiftT(38);                   // ')'
      break;
    case 33:                        // '%'
    case 18067:                     // 'function' '('
      try_FunctionTest();
      break;
    case 35:                        // '('
      try_ParenthesizedItemType();
      break;
    case -6:
    case 17999:                     // 'array' '('
    case 18089:                     // 'json-item' '('
    case 18118:                     // 'object' '('
      try_JSONTest();
      break;
    case -7:
    case 18167:                     // 'structured-item' '('
      try_StructuredItemTest();
      break;
    case -8:
      break;
    default:
      try_AtomicOrUnionType();
    }
  }

  function parse_JSONTest()
  {
    eventHandler.startNonterminal("JSONTest", e0);
    switch (l1)
    {
    case 169:                       // 'json-item'
      parse_JSONItemTest();
      break;
    case 198:                       // 'object'
      parse_JSONObjectTest();
      break;
    default:
      parse_JSONArrayTest();
    }
    eventHandler.endNonterminal("JSONTest", e0);
  }

  function try_JSONTest()
  {
    switch (l1)
    {
    case 169:                       // 'json-item'
      try_JSONItemTest();
      break;
    case 198:                       // 'object'
      try_JSONObjectTest();
      break;
    default:
      try_JSONArrayTest();
    }
  }

  function parse_StructuredItemTest()
  {
    eventHandler.startNonterminal("StructuredItemTest", e0);
    shift(247);                     // 'structured-item'
    lookahead1W(233);               // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
    if (l1 == 35)                   // '('
    {
      shift(35);                    // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shift(38);                    // ')'
    }
    eventHandler.endNonterminal("StructuredItemTest", e0);
  }

  function try_StructuredItemTest()
  {
    shiftT(247);                    // 'structured-item'
    lookahead1W(233);               // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
    if (l1 == 35)                   // '('
    {
      shiftT(35);                   // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shiftT(38);                   // ')'
    }
  }

  function parse_JSONItemTest()
  {
    eventHandler.startNonterminal("JSONItemTest", e0);
    shift(169);                     // 'json-item'
    lookahead1W(233);               // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
    if (l1 == 35)                   // '('
    {
      shift(35);                    // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shift(38);                    // ')'
    }
    eventHandler.endNonterminal("JSONItemTest", e0);
  }

  function try_JSONItemTest()
  {
    shiftT(169);                    // 'json-item'
    lookahead1W(233);               // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
    if (l1 == 35)                   // '('
    {
      shiftT(35);                   // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shiftT(38);                   // ')'
    }
  }

  function parse_JSONObjectTest()
  {
    eventHandler.startNonterminal("JSONObjectTest", e0);
    shift(198);                     // 'object'
    lookahead1W(233);               // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
    if (l1 == 35)                   // '('
    {
      shift(35);                    // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shift(38);                    // ')'
    }
    eventHandler.endNonterminal("JSONObjectTest", e0);
  }

  function try_JSONObjectTest()
  {
    shiftT(198);                    // 'object'
    lookahead1W(233);               // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
    if (l1 == 35)                   // '('
    {
      shiftT(35);                   // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shiftT(38);                   // ')'
    }
  }

  function parse_JSONArrayTest()
  {
    eventHandler.startNonterminal("JSONArrayTest", e0);
    shift(79);                      // 'array'
    lookahead1W(233);               // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
    if (l1 == 35)                   // '('
    {
      shift(35);                    // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shift(38);                    // ')'
    }
    eventHandler.endNonterminal("JSONArrayTest", e0);
  }

  function try_JSONArrayTest()
  {
    shiftT(79);                     // 'array'
    lookahead1W(233);               // S^WS | EOF | '!=' | '(' | '(:' | ')' | '*' | '*' | '+' | ',' | '-' | ':' | ':=' |
    if (l1 == 35)                   // '('
    {
      shiftT(35);                   // '('
      lookahead1W(23);              // S^WS | '(:' | ')'
      shiftT(38);                   // ')'
    }
  }

  function parse_AtomicOrUnionType()
  {
    eventHandler.startNonterminal("AtomicOrUnionType", e0);
    parse_EQName();
    eventHandler.endNonterminal("AtomicOrUnionType", e0);
  }

  function try_AtomicOrUnionType()
  {
    try_EQName();
  }

  function parse_KindTest()
  {
    eventHandler.startNonterminal("KindTest", e0);
    switch (l1)
    {
    case 121:                       // 'document-node'
      parse_DocumentTest();
      break;
    case 122:                       // 'element'
      parse_ElementTest();
      break;
    case 83:                        // 'attribute'
      parse_AttributeTest();
      break;
    case 231:                       // 'schema-element'
      parse_SchemaElementTest();
      break;
    case 230:                       // 'schema-attribute'
      parse_SchemaAttributeTest();
      break;
    case 220:                       // 'processing-instruction'
      parse_PITest();
      break;
    case 97:                        // 'comment'
      parse_CommentTest();
      break;
    case 249:                       // 'text'
      parse_TextTest();
      break;
    case 188:                       // 'namespace-node'
      parse_NamespaceNodeTest();
      break;
    default:
      parse_AnyKindTest();
    }
    eventHandler.endNonterminal("KindTest", e0);
  }

  function try_KindTest()
  {
    switch (l1)
    {
    case 121:                       // 'document-node'
      try_DocumentTest();
      break;
    case 122:                       // 'element'
      try_ElementTest();
      break;
    case 83:                        // 'attribute'
      try_AttributeTest();
      break;
    case 231:                       // 'schema-element'
      try_SchemaElementTest();
      break;
    case 230:                       // 'schema-attribute'
      try_SchemaAttributeTest();
      break;
    case 220:                       // 'processing-instruction'
      try_PITest();
      break;
    case 97:                        // 'comment'
      try_CommentTest();
      break;
    case 249:                       // 'text'
      try_TextTest();
      break;
    case 188:                       // 'namespace-node'
      try_NamespaceNodeTest();
      break;
    default:
      try_AnyKindTest();
    }
  }

  function parse_AnyKindTest()
  {
    eventHandler.startNonterminal("AnyKindTest", e0);
    shift(194);                     // 'node'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("AnyKindTest", e0);
  }

  function try_AnyKindTest()
  {
    shiftT(194);                    // 'node'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_DocumentTest()
  {
    eventHandler.startNonterminal("DocumentTest", e0);
    shift(121);                     // 'document-node'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(154);               // S^WS | '(:' | ')' | 'element' | 'schema-element'
    if (l1 != 38)                   // ')'
    {
      switch (l1)
      {
      case 122:                     // 'element'
        whitespace();
        parse_ElementTest();
        break;
      default:
        whitespace();
        parse_SchemaElementTest();
      }
    }
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("DocumentTest", e0);
  }

  function try_DocumentTest()
  {
    shiftT(121);                    // 'document-node'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(154);               // S^WS | '(:' | ')' | 'element' | 'schema-element'
    if (l1 != 38)                   // ')'
    {
      switch (l1)
      {
      case 122:                     // 'element'
        try_ElementTest();
        break;
      default:
        try_SchemaElementTest();
      }
    }
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_TextTest()
  {
    eventHandler.startNonterminal("TextTest", e0);
    shift(249);                     // 'text'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("TextTest", e0);
  }

  function try_TextTest()
  {
    shiftT(249);                    // 'text'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_CommentTest()
  {
    eventHandler.startNonterminal("CommentTest", e0);
    shift(97);                      // 'comment'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("CommentTest", e0);
  }

  function try_CommentTest()
  {
    shiftT(97);                     // 'comment'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_NamespaceNodeTest()
  {
    eventHandler.startNonterminal("NamespaceNodeTest", e0);
    shift(188);                     // 'namespace-node'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("NamespaceNodeTest", e0);
  }

  function try_NamespaceNodeTest()
  {
    shiftT(188);                    // 'namespace-node'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_PITest()
  {
    eventHandler.startNonterminal("PITest", e0);
    shift(220);                     // 'processing-instruction'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(244);               // StringLiteral | NCName^Token | S^WS | '(:' | ')' | 'after' | 'allowing' |
    if (l1 != 38)                   // ')'
    {
      switch (l1)
      {
      case 11:                      // StringLiteral
        shift(11);                  // StringLiteral
        break;
      default:
        whitespace();
        parse_NCName();
      }
    }
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("PITest", e0);
  }

  function try_PITest()
  {
    shiftT(220);                    // 'processing-instruction'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(244);               // StringLiteral | NCName^Token | S^WS | '(:' | ')' | 'after' | 'allowing' |
    if (l1 != 38)                   // ')'
    {
      switch (l1)
      {
      case 11:                      // StringLiteral
        shiftT(11);                 // StringLiteral
        break;
      default:
        try_NCName();
      }
    }
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_AttributeTest()
  {
    eventHandler.startNonterminal("AttributeTest", e0);
    shift(83);                      // 'attribute'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(255);               // EQName^Token | S^WS | '(:' | ')' | '*' | 'after' | 'allowing' | 'ancestor' |
    if (l1 != 38)                   // ')'
    {
      whitespace();
      parse_AttribNameOrWildcard();
      lookahead1W(105);             // S^WS | '(:' | ')' | ','
      if (l1 == 42)                 // ','
      {
        shift(42);                  // ','
        lookahead1W(246);           // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
        whitespace();
        parse_TypeName();
      }
    }
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("AttributeTest", e0);
  }

  function try_AttributeTest()
  {
    shiftT(83);                     // 'attribute'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(255);               // EQName^Token | S^WS | '(:' | ')' | '*' | 'after' | 'allowing' | 'ancestor' |
    if (l1 != 38)                   // ')'
    {
      try_AttribNameOrWildcard();
      lookahead1W(105);             // S^WS | '(:' | ')' | ','
      if (l1 == 42)                 // ','
      {
        shiftT(42);                 // ','
        lookahead1W(246);           // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
        try_TypeName();
      }
    }
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_AttribNameOrWildcard()
  {
    eventHandler.startNonterminal("AttribNameOrWildcard", e0);
    switch (l1)
    {
    case 39:                        // '*'
      shift(39);                    // '*'
      break;
    default:
      parse_AttributeName();
    }
    eventHandler.endNonterminal("AttribNameOrWildcard", e0);
  }

  function try_AttribNameOrWildcard()
  {
    switch (l1)
    {
    case 39:                        // '*'
      shiftT(39);                   // '*'
      break;
    default:
      try_AttributeName();
    }
  }

  function parse_SchemaAttributeTest()
  {
    eventHandler.startNonterminal("SchemaAttributeTest", e0);
    shift(230);                     // 'schema-attribute'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_AttributeDeclaration();
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("SchemaAttributeTest", e0);
  }

  function try_SchemaAttributeTest()
  {
    shiftT(230);                    // 'schema-attribute'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_AttributeDeclaration();
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_AttributeDeclaration()
  {
    eventHandler.startNonterminal("AttributeDeclaration", e0);
    parse_AttributeName();
    eventHandler.endNonterminal("AttributeDeclaration", e0);
  }

  function try_AttributeDeclaration()
  {
    try_AttributeName();
  }

  function parse_ElementTest()
  {
    eventHandler.startNonterminal("ElementTest", e0);
    shift(122);                     // 'element'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(255);               // EQName^Token | S^WS | '(:' | ')' | '*' | 'after' | 'allowing' | 'ancestor' |
    if (l1 != 38)                   // ')'
    {
      whitespace();
      parse_ElementNameOrWildcard();
      lookahead1W(105);             // S^WS | '(:' | ')' | ','
      if (l1 == 42)                 // ','
      {
        shift(42);                  // ','
        lookahead1W(246);           // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
        whitespace();
        parse_TypeName();
        lookahead1W(106);           // S^WS | '(:' | ')' | '?'
        if (l1 == 65)               // '?'
        {
          shift(65);                // '?'
        }
      }
    }
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("ElementTest", e0);
  }

  function try_ElementTest()
  {
    shiftT(122);                    // 'element'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(255);               // EQName^Token | S^WS | '(:' | ')' | '*' | 'after' | 'allowing' | 'ancestor' |
    if (l1 != 38)                   // ')'
    {
      try_ElementNameOrWildcard();
      lookahead1W(105);             // S^WS | '(:' | ')' | ','
      if (l1 == 42)                 // ','
      {
        shiftT(42);                 // ','
        lookahead1W(246);           // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
        try_TypeName();
        lookahead1W(106);           // S^WS | '(:' | ')' | '?'
        if (l1 == 65)               // '?'
        {
          shiftT(65);               // '?'
        }
      }
    }
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_ElementNameOrWildcard()
  {
    eventHandler.startNonterminal("ElementNameOrWildcard", e0);
    switch (l1)
    {
    case 39:                        // '*'
      shift(39);                    // '*'
      break;
    default:
      parse_ElementName();
    }
    eventHandler.endNonterminal("ElementNameOrWildcard", e0);
  }

  function try_ElementNameOrWildcard()
  {
    switch (l1)
    {
    case 39:                        // '*'
      shiftT(39);                   // '*'
      break;
    default:
      try_ElementName();
    }
  }

  function parse_SchemaElementTest()
  {
    eventHandler.startNonterminal("SchemaElementTest", e0);
    shift(231);                     // 'schema-element'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_ElementDeclaration();
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("SchemaElementTest", e0);
  }

  function try_SchemaElementTest()
  {
    shiftT(231);                    // 'schema-element'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_ElementDeclaration();
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_ElementDeclaration()
  {
    eventHandler.startNonterminal("ElementDeclaration", e0);
    parse_ElementName();
    eventHandler.endNonterminal("ElementDeclaration", e0);
  }

  function try_ElementDeclaration()
  {
    try_ElementName();
  }

  function parse_AttributeName()
  {
    eventHandler.startNonterminal("AttributeName", e0);
    parse_EQName();
    eventHandler.endNonterminal("AttributeName", e0);
  }

  function try_AttributeName()
  {
    try_EQName();
  }

  function parse_ElementName()
  {
    eventHandler.startNonterminal("ElementName", e0);
    parse_EQName();
    eventHandler.endNonterminal("ElementName", e0);
  }

  function try_ElementName()
  {
    try_EQName();
  }

  function parse_SimpleTypeName()
  {
    eventHandler.startNonterminal("SimpleTypeName", e0);
    parse_TypeName();
    eventHandler.endNonterminal("SimpleTypeName", e0);
  }

  function try_SimpleTypeName()
  {
    try_TypeName();
  }

  function parse_TypeName()
  {
    eventHandler.startNonterminal("TypeName", e0);
    parse_EQName();
    eventHandler.endNonterminal("TypeName", e0);
  }

  function try_TypeName()
  {
    try_EQName();
  }

  function parse_FunctionTest()
  {
    eventHandler.startNonterminal("FunctionTest", e0);
    for (;;)
    {
      lookahead1W(101);             // S^WS | '%' | '(:' | 'function'
      if (l1 != 33)                 // '%'
      {
        break;
      }
      whitespace();
      parse_Annotation();
    }
    switch (l1)
    {
    case 147:                       // 'function'
      lookahead2W(22);              // S^WS | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    lk = memoized(7, e0);
    if (lk == 0)
    {
      var b0A = b0; var e0A = e0; var l1A = l1;
      var b1A = b1; var e1A = e1; var l2A = l2;
      var b2A = b2; var e2A = e2;
      try
      {
        try_AnyFunctionTest();
        lk = -1;
      }
      catch (p1A)
      {
        lk = -2;
      }
      b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
      b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
      b2 = b2A; e2 = e2A; end = e2A; }}
      memoize(7, e0, lk);
    }
    switch (lk)
    {
    case -1:
      whitespace();
      parse_AnyFunctionTest();
      break;
    default:
      whitespace();
      parse_TypedFunctionTest();
    }
    eventHandler.endNonterminal("FunctionTest", e0);
  }

  function try_FunctionTest()
  {
    for (;;)
    {
      lookahead1W(101);             // S^WS | '%' | '(:' | 'function'
      if (l1 != 33)                 // '%'
      {
        break;
      }
      try_Annotation();
    }
    switch (l1)
    {
    case 147:                       // 'function'
      lookahead2W(22);              // S^WS | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    lk = memoized(7, e0);
    if (lk == 0)
    {
      var b0A = b0; var e0A = e0; var l1A = l1;
      var b1A = b1; var e1A = e1; var l2A = l2;
      var b2A = b2; var e2A = e2;
      try
      {
        try_AnyFunctionTest();
        memoize(7, e0A, -1);
        lk = -3;
      }
      catch (p1A)
      {
        lk = -2;
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(7, e0A, -2);
      }
    }
    switch (lk)
    {
    case -1:
      try_AnyFunctionTest();
      break;
    case -3:
      break;
    default:
      try_TypedFunctionTest();
    }
  }

  function parse_AnyFunctionTest()
  {
    eventHandler.startNonterminal("AnyFunctionTest", e0);
    shift(147);                     // 'function'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(24);                // S^WS | '(:' | '*'
    shift(39);                      // '*'
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("AnyFunctionTest", e0);
  }

  function try_AnyFunctionTest()
  {
    shiftT(147);                    // 'function'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(24);                // S^WS | '(:' | '*'
    shiftT(39);                     // '*'
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_TypedFunctionTest()
  {
    eventHandler.startNonterminal("TypedFunctionTest", e0);
    shift(147);                     // 'function'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(259);               // EQName^Token | S^WS | '%' | '(' | '(:' | ')' | 'after' | 'allowing' |
    if (l1 != 38)                   // ')'
    {
      whitespace();
      parse_SequenceType();
      for (;;)
      {
        lookahead1W(105);           // S^WS | '(:' | ')' | ','
        if (l1 != 42)               // ','
        {
          break;
        }
        shift(42);                  // ','
        lookahead1W(254);           // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
        whitespace();
        parse_SequenceType();
      }
    }
    shift(38);                      // ')'
    lookahead1W(33);                // S^WS | '(:' | 'as'
    shift(80);                      // 'as'
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_SequenceType();
    eventHandler.endNonterminal("TypedFunctionTest", e0);
  }

  function try_TypedFunctionTest()
  {
    shiftT(147);                    // 'function'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(259);               // EQName^Token | S^WS | '%' | '(' | '(:' | ')' | 'after' | 'allowing' |
    if (l1 != 38)                   // ')'
    {
      try_SequenceType();
      for (;;)
      {
        lookahead1W(105);           // S^WS | '(:' | ')' | ','
        if (l1 != 42)               // ','
        {
          break;
        }
        shiftT(42);                 // ','
        lookahead1W(254);           // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
        try_SequenceType();
      }
    }
    shiftT(38);                     // ')'
    lookahead1W(33);                // S^WS | '(:' | 'as'
    shiftT(80);                     // 'as'
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_SequenceType();
  }

  function parse_ParenthesizedItemType()
  {
    eventHandler.startNonterminal("ParenthesizedItemType", e0);
    shift(35);                      // '('
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_ItemType();
    lookahead1W(23);                // S^WS | '(:' | ')'
    shift(38);                      // ')'
    eventHandler.endNonterminal("ParenthesizedItemType", e0);
  }

  function try_ParenthesizedItemType()
  {
    shiftT(35);                     // '('
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_ItemType();
    lookahead1W(23);                // S^WS | '(:' | ')'
    shiftT(38);                     // ')'
  }

  function parse_RevalidationDecl()
  {
    eventHandler.startNonterminal("RevalidationDecl", e0);
    shift(109);                     // 'declare'
    lookahead1W(75);                // S^WS | '(:' | 'revalidation'
    shift(226);                     // 'revalidation'
    lookahead1W(162);               // S^WS | '(:' | 'lax' | 'skip' | 'strict'
    switch (l1)
    {
    case 245:                       // 'strict'
      shift(245);                   // 'strict'
      break;
    case 174:                       // 'lax'
      shift(174);                   // 'lax'
      break;
    default:
      shift(238);                   // 'skip'
    }
    eventHandler.endNonterminal("RevalidationDecl", e0);
  }

  function parse_InsertExprTargetChoice()
  {
    eventHandler.startNonterminal("InsertExprTargetChoice", e0);
    switch (l1)
    {
    case 71:                        // 'after'
      shift(71);                    // 'after'
      break;
    case 85:                        // 'before'
      shift(85);                    // 'before'
      break;
    default:
      if (l1 == 80)                 // 'as'
      {
        shift(80);                  // 'as'
        lookahead1W(123);           // S^WS | '(:' | 'first' | 'last'
        switch (l1)
        {
        case 136:                   // 'first'
          shift(136);               // 'first'
          break;
        default:
          shift(173);               // 'last'
        }
      }
      lookahead1W(57);              // S^WS | '(:' | 'into'
      shift(165);                   // 'into'
    }
    eventHandler.endNonterminal("InsertExprTargetChoice", e0);
  }

  function try_InsertExprTargetChoice()
  {
    switch (l1)
    {
    case 71:                        // 'after'
      shiftT(71);                   // 'after'
      break;
    case 85:                        // 'before'
      shiftT(85);                   // 'before'
      break;
    default:
      if (l1 == 80)                 // 'as'
      {
        shiftT(80);                 // 'as'
        lookahead1W(123);           // S^WS | '(:' | 'first' | 'last'
        switch (l1)
        {
        case 136:                   // 'first'
          shiftT(136);              // 'first'
          break;
        default:
          shiftT(173);              // 'last'
        }
      }
      lookahead1W(57);              // S^WS | '(:' | 'into'
      shiftT(165);                  // 'into'
    }
  }

  function parse_InsertExpr()
  {
    eventHandler.startNonterminal("InsertExpr", e0);
    shift(161);                     // 'insert'
    lookahead1W(133);               // S^WS | '(:' | 'node' | 'nodes'
    switch (l1)
    {
    case 194:                       // 'node'
      shift(194);                   // 'node'
      break;
    default:
      shift(195);                   // 'nodes'
    }
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_SourceExpr();
    whitespace();
    parse_InsertExprTargetChoice();
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_TargetExpr();
    eventHandler.endNonterminal("InsertExpr", e0);
  }

  function try_InsertExpr()
  {
    shiftT(161);                    // 'insert'
    lookahead1W(133);               // S^WS | '(:' | 'node' | 'nodes'
    switch (l1)
    {
    case 194:                       // 'node'
      shiftT(194);                  // 'node'
      break;
    default:
      shiftT(195);                  // 'nodes'
    }
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_SourceExpr();
    try_InsertExprTargetChoice();
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_TargetExpr();
  }

  function parse_DeleteExpr()
  {
    eventHandler.startNonterminal("DeleteExpr", e0);
    shift(111);                     // 'delete'
    lookahead1W(133);               // S^WS | '(:' | 'node' | 'nodes'
    switch (l1)
    {
    case 194:                       // 'node'
      shift(194);                   // 'node'
      break;
    default:
      shift(195);                   // 'nodes'
    }
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_TargetExpr();
    eventHandler.endNonterminal("DeleteExpr", e0);
  }

  function try_DeleteExpr()
  {
    shiftT(111);                    // 'delete'
    lookahead1W(133);               // S^WS | '(:' | 'node' | 'nodes'
    switch (l1)
    {
    case 194:                       // 'node'
      shiftT(194);                  // 'node'
      break;
    default:
      shiftT(195);                  // 'nodes'
    }
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_TargetExpr();
  }

  function parse_ReplaceExpr()
  {
    eventHandler.startNonterminal("ReplaceExpr", e0);
    shift(223);                     // 'replace'
    lookahead1W(134);               // S^WS | '(:' | 'node' | 'value'
    if (l1 == 267)                  // 'value'
    {
      shift(267);                   // 'value'
      lookahead1W(67);              // S^WS | '(:' | 'of'
      shift(200);                   // 'of'
    }
    lookahead1W(65);                // S^WS | '(:' | 'node'
    shift(194);                     // 'node'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_TargetExpr();
    shift(276);                     // 'with'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("ReplaceExpr", e0);
  }

  function try_ReplaceExpr()
  {
    shiftT(223);                    // 'replace'
    lookahead1W(134);               // S^WS | '(:' | 'node' | 'value'
    if (l1 == 267)                  // 'value'
    {
      shiftT(267);                  // 'value'
      lookahead1W(67);              // S^WS | '(:' | 'of'
      shiftT(200);                  // 'of'
    }
    lookahead1W(65);                // S^WS | '(:' | 'node'
    shiftT(194);                    // 'node'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_TargetExpr();
    shiftT(276);                    // 'with'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_RenameExpr()
  {
    eventHandler.startNonterminal("RenameExpr", e0);
    shift(222);                     // 'rename'
    lookahead1W(65);                // S^WS | '(:' | 'node'
    shift(194);                     // 'node'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_TargetExpr();
    shift(80);                      // 'as'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_NewNameExpr();
    eventHandler.endNonterminal("RenameExpr", e0);
  }

  function try_RenameExpr()
  {
    shiftT(222);                    // 'rename'
    lookahead1W(65);                // S^WS | '(:' | 'node'
    shiftT(194);                    // 'node'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_TargetExpr();
    shiftT(80);                     // 'as'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_NewNameExpr();
  }

  function parse_SourceExpr()
  {
    eventHandler.startNonterminal("SourceExpr", e0);
    parse_ExprSingle();
    eventHandler.endNonterminal("SourceExpr", e0);
  }

  function try_SourceExpr()
  {
    try_ExprSingle();
  }

  function parse_TargetExpr()
  {
    eventHandler.startNonterminal("TargetExpr", e0);
    parse_ExprSingle();
    eventHandler.endNonterminal("TargetExpr", e0);
  }

  function try_TargetExpr()
  {
    try_ExprSingle();
  }

  function parse_NewNameExpr()
  {
    eventHandler.startNonterminal("NewNameExpr", e0);
    parse_ExprSingle();
    eventHandler.endNonterminal("NewNameExpr", e0);
  }

  function try_NewNameExpr()
  {
    try_ExprSingle();
  }

  function parse_TransformExpr()
  {
    eventHandler.startNonterminal("TransformExpr", e0);
    shift(104);                     // 'copy'
    lookahead1W(21);                // S^WS | '$' | '(:'
    whitespace();
    parse_TransformSpec();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      whitespace();
      parse_TransformSpec();
    }
    shift(184);                     // 'modify'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    shift(224);                     // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("TransformExpr", e0);
  }

  function try_TransformExpr()
  {
    shiftT(104);                    // 'copy'
    lookahead1W(21);                // S^WS | '$' | '(:'
    try_TransformSpec();
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      try_TransformSpec();
    }
    shiftT(184);                    // 'modify'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
    shiftT(224);                    // 'return'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_TransformSpec()
  {
    eventHandler.startNonterminal("TransformSpec", e0);
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    lookahead1W(28);                // S^WS | '(:' | ':='
    shift(53);                      // ':='
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("TransformSpec", e0);
  }

  function try_TransformSpec()
  {
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
    lookahead1W(28);                // S^WS | '(:' | ':='
    shiftT(53);                     // ':='
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_FTSelection()
  {
    eventHandler.startNonterminal("FTSelection", e0);
    parse_FTOr();
    for (;;)
    {
      lookahead1W(212);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      switch (l1)
      {
      case 82:                      // 'at'
        lookahead2W(161);           // S^WS | '(:' | 'end' | 'position' | 'start'
        break;
      default:
        lk = l1;
      }
      if (lk != 116                 // 'different'
       && lk != 118                 // 'distance'
       && lk != 128                 // 'entire'
       && lk != 206                 // 'ordered'
       && lk != 227                 // 'same'
       && lk != 275                 // 'window'
       && lk != 65106               // 'at' 'end'
       && lk != 123986)             // 'at' 'start'
      {
        break;
      }
      whitespace();
      parse_FTPosFilter();
    }
    eventHandler.endNonterminal("FTSelection", e0);
  }

  function try_FTSelection()
  {
    try_FTOr();
    for (;;)
    {
      lookahead1W(212);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      switch (l1)
      {
      case 82:                      // 'at'
        lookahead2W(161);           // S^WS | '(:' | 'end' | 'position' | 'start'
        break;
      default:
        lk = l1;
      }
      if (lk != 116                 // 'different'
       && lk != 118                 // 'distance'
       && lk != 128                 // 'entire'
       && lk != 206                 // 'ordered'
       && lk != 227                 // 'same'
       && lk != 275                 // 'window'
       && lk != 65106               // 'at' 'end'
       && lk != 123986)             // 'at' 'start'
      {
        break;
      }
      try_FTPosFilter();
    }
  }

  function parse_FTWeight()
  {
    eventHandler.startNonterminal("FTWeight", e0);
    shift(270);                     // 'weight'
    lookahead1W(90);                // S^WS | '(:' | '{'
    shift(281);                     // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(287);                     // '}'
    eventHandler.endNonterminal("FTWeight", e0);
  }

  function try_FTWeight()
  {
    shiftT(270);                    // 'weight'
    lookahead1W(90);                // S^WS | '(:' | '{'
    shiftT(281);                    // '{'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(287);                    // '}'
  }

  function parse_FTOr()
  {
    eventHandler.startNonterminal("FTOr", e0);
    parse_FTAnd();
    for (;;)
    {
      if (l1 != 146)                // 'ftor'
      {
        break;
      }
      shift(146);                   // 'ftor'
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      whitespace();
      parse_FTAnd();
    }
    eventHandler.endNonterminal("FTOr", e0);
  }

  function try_FTOr()
  {
    try_FTAnd();
    for (;;)
    {
      if (l1 != 146)                // 'ftor'
      {
        break;
      }
      shiftT(146);                  // 'ftor'
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      try_FTAnd();
    }
  }

  function parse_FTAnd()
  {
    eventHandler.startNonterminal("FTAnd", e0);
    parse_FTMildNot();
    for (;;)
    {
      if (l1 != 144)                // 'ftand'
      {
        break;
      }
      shift(144);                   // 'ftand'
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      whitespace();
      parse_FTMildNot();
    }
    eventHandler.endNonterminal("FTAnd", e0);
  }

  function try_FTAnd()
  {
    try_FTMildNot();
    for (;;)
    {
      if (l1 != 144)                // 'ftand'
      {
        break;
      }
      shiftT(144);                  // 'ftand'
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      try_FTMildNot();
    }
  }

  function parse_FTMildNot()
  {
    eventHandler.startNonterminal("FTMildNot", e0);
    parse_FTUnaryNot();
    for (;;)
    {
      lookahead1W(213);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 != 196)                // 'not'
      {
        break;
      }
      shift(196);                   // 'not'
      lookahead1W(56);              // S^WS | '(:' | 'in'
      shift(156);                   // 'in'
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      whitespace();
      parse_FTUnaryNot();
    }
    eventHandler.endNonterminal("FTMildNot", e0);
  }

  function try_FTMildNot()
  {
    try_FTUnaryNot();
    for (;;)
    {
      lookahead1W(213);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 != 196)                // 'not'
      {
        break;
      }
      shiftT(196);                  // 'not'
      lookahead1W(56);              // S^WS | '(:' | 'in'
      shiftT(156);                  // 'in'
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      try_FTUnaryNot();
    }
  }

  function parse_FTUnaryNot()
  {
    eventHandler.startNonterminal("FTUnaryNot", e0);
    if (l1 == 145)                  // 'ftnot'
    {
      shift(145);                   // 'ftnot'
    }
    lookahead1W(164);               // StringLiteral | S^WS | '(' | '(#' | '(:' | '{'
    whitespace();
    parse_FTPrimaryWithOptions();
    eventHandler.endNonterminal("FTUnaryNot", e0);
  }

  function try_FTUnaryNot()
  {
    if (l1 == 145)                  // 'ftnot'
    {
      shiftT(145);                  // 'ftnot'
    }
    lookahead1W(164);               // StringLiteral | S^WS | '(' | '(#' | '(:' | '{'
    try_FTPrimaryWithOptions();
  }

  function parse_FTPrimaryWithOptions()
  {
    eventHandler.startNonterminal("FTPrimaryWithOptions", e0);
    parse_FTPrimary();
    lookahead1W(214);               // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
    if (l1 == 265)                  // 'using'
    {
      whitespace();
      parse_FTMatchOptions();
    }
    if (l1 == 270)                  // 'weight'
    {
      whitespace();
      parse_FTWeight();
    }
    eventHandler.endNonterminal("FTPrimaryWithOptions", e0);
  }

  function try_FTPrimaryWithOptions()
  {
    try_FTPrimary();
    lookahead1W(214);               // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
    if (l1 == 265)                  // 'using'
    {
      try_FTMatchOptions();
    }
    if (l1 == 270)                  // 'weight'
    {
      try_FTWeight();
    }
  }

  function parse_FTPrimary()
  {
    eventHandler.startNonterminal("FTPrimary", e0);
    switch (l1)
    {
    case 35:                        // '('
      shift(35);                    // '('
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      whitespace();
      parse_FTSelection();
      shift(38);                    // ')'
      break;
    case 36:                        // '(#'
      parse_FTExtensionSelection();
      break;
    default:
      parse_FTWords();
      lookahead1W(215);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 == 199)                // 'occurs'
      {
        whitespace();
        parse_FTTimes();
      }
    }
    eventHandler.endNonterminal("FTPrimary", e0);
  }

  function try_FTPrimary()
  {
    switch (l1)
    {
    case 35:                        // '('
      shiftT(35);                   // '('
      lookahead1W(177);             // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{'
      try_FTSelection();
      shiftT(38);                   // ')'
      break;
    case 36:                        // '(#'
      try_FTExtensionSelection();
      break;
    default:
      try_FTWords();
      lookahead1W(215);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 == 199)                // 'occurs'
      {
        try_FTTimes();
      }
    }
  }

  function parse_FTWords()
  {
    eventHandler.startNonterminal("FTWords", e0);
    parse_FTWordsValue();
    lookahead1W(221);               // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
    if (l1 == 72                    // 'all'
     || l1 == 77                    // 'any'
     || l1 == 214)                  // 'phrase'
    {
      whitespace();
      parse_FTAnyallOption();
    }
    eventHandler.endNonterminal("FTWords", e0);
  }

  function try_FTWords()
  {
    try_FTWordsValue();
    lookahead1W(221);               // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
    if (l1 == 72                    // 'all'
     || l1 == 77                    // 'any'
     || l1 == 214)                  // 'phrase'
    {
      try_FTAnyallOption();
    }
  }

  function parse_FTWordsValue()
  {
    eventHandler.startNonterminal("FTWordsValue", e0);
    switch (l1)
    {
    case 11:                        // StringLiteral
      shift(11);                    // StringLiteral
      break;
    default:
      shift(281);                   // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_Expr();
      shift(287);                   // '}'
    }
    eventHandler.endNonterminal("FTWordsValue", e0);
  }

  function try_FTWordsValue()
  {
    switch (l1)
    {
    case 11:                        // StringLiteral
      shiftT(11);                   // StringLiteral
      break;
    default:
      shiftT(281);                  // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_Expr();
      shiftT(287);                  // '}'
    }
  }

  function parse_FTExtensionSelection()
  {
    eventHandler.startNonterminal("FTExtensionSelection", e0);
    for (;;)
    {
      whitespace();
      parse_Pragma();
      lookahead1W(104);             // S^WS | '(#' | '(:' | '{'
      if (l1 != 36)                 // '(#'
      {
        break;
      }
    }
    shift(281);                     // '{'
    lookahead1W(184);               // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{' | '}'
    if (l1 != 287)                  // '}'
    {
      whitespace();
      parse_FTSelection();
    }
    shift(287);                     // '}'
    eventHandler.endNonterminal("FTExtensionSelection", e0);
  }

  function try_FTExtensionSelection()
  {
    for (;;)
    {
      try_Pragma();
      lookahead1W(104);             // S^WS | '(#' | '(:' | '{'
      if (l1 != 36)                 // '(#'
      {
        break;
      }
    }
    shiftT(281);                    // '{'
    lookahead1W(184);               // StringLiteral | S^WS | '(' | '(#' | '(:' | 'ftnot' | '{' | '}'
    if (l1 != 287)                  // '}'
    {
      try_FTSelection();
    }
    shiftT(287);                    // '}'
  }

  function parse_FTAnyallOption()
  {
    eventHandler.startNonterminal("FTAnyallOption", e0);
    switch (l1)
    {
    case 77:                        // 'any'
      shift(77);                    // 'any'
      lookahead1W(218);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 == 278)                // 'word'
      {
        shift(278);                 // 'word'
      }
      break;
    case 72:                        // 'all'
      shift(72);                    // 'all'
      lookahead1W(219);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 == 279)                // 'words'
      {
        shift(279);                 // 'words'
      }
      break;
    default:
      shift(214);                   // 'phrase'
    }
    eventHandler.endNonterminal("FTAnyallOption", e0);
  }

  function try_FTAnyallOption()
  {
    switch (l1)
    {
    case 77:                        // 'any'
      shiftT(77);                   // 'any'
      lookahead1W(218);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 == 278)                // 'word'
      {
        shiftT(278);                // 'word'
      }
      break;
    case 72:                        // 'all'
      shiftT(72);                   // 'all'
      lookahead1W(219);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 == 279)                // 'words'
      {
        shiftT(279);                // 'words'
      }
      break;
    default:
      shiftT(214);                  // 'phrase'
    }
  }

  function parse_FTTimes()
  {
    eventHandler.startNonterminal("FTTimes", e0);
    shift(199);                     // 'occurs'
    lookahead1W(159);               // S^WS | '(:' | 'at' | 'exactly' | 'from'
    whitespace();
    parse_FTRange();
    shift(252);                     // 'times'
    eventHandler.endNonterminal("FTTimes", e0);
  }

  function try_FTTimes()
  {
    shiftT(199);                    // 'occurs'
    lookahead1W(159);               // S^WS | '(:' | 'at' | 'exactly' | 'from'
    try_FTRange();
    shiftT(252);                    // 'times'
  }

  function parse_FTRange()
  {
    eventHandler.startNonterminal("FTRange", e0);
    switch (l1)
    {
    case 131:                       // 'exactly'
      shift(131);                   // 'exactly'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_AdditiveExpr();
      break;
    case 82:                        // 'at'
      shift(82);                    // 'at'
      lookahead1W(129);             // S^WS | '(:' | 'least' | 'most'
      switch (l1)
      {
      case 176:                     // 'least'
        shift(176);                 // 'least'
        lookahead1W(266);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        whitespace();
        parse_AdditiveExpr();
        break;
      default:
        shift(186);                 // 'most'
        lookahead1W(266);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        whitespace();
        parse_AdditiveExpr();
      }
      break;
    default:
      shift(142);                   // 'from'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_AdditiveExpr();
      shift(253);                   // 'to'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_AdditiveExpr();
    }
    eventHandler.endNonterminal("FTRange", e0);
  }

  function try_FTRange()
  {
    switch (l1)
    {
    case 131:                       // 'exactly'
      shiftT(131);                  // 'exactly'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_AdditiveExpr();
      break;
    case 82:                        // 'at'
      shiftT(82);                   // 'at'
      lookahead1W(129);             // S^WS | '(:' | 'least' | 'most'
      switch (l1)
      {
      case 176:                     // 'least'
        shiftT(176);                // 'least'
        lookahead1W(266);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        try_AdditiveExpr();
        break;
      default:
        shiftT(186);                // 'most'
        lookahead1W(266);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        try_AdditiveExpr();
      }
      break;
    default:
      shiftT(142);                  // 'from'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_AdditiveExpr();
      shiftT(253);                  // 'to'
      lookahead1W(266);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_AdditiveExpr();
    }
  }

  function parse_FTPosFilter()
  {
    eventHandler.startNonterminal("FTPosFilter", e0);
    switch (l1)
    {
    case 206:                       // 'ordered'
      parse_FTOrder();
      break;
    case 275:                       // 'window'
      parse_FTWindow();
      break;
    case 118:                       // 'distance'
      parse_FTDistance();
      break;
    case 116:                       // 'different'
    case 227:                       // 'same'
      parse_FTScope();
      break;
    default:
      parse_FTContent();
    }
    eventHandler.endNonterminal("FTPosFilter", e0);
  }

  function try_FTPosFilter()
  {
    switch (l1)
    {
    case 206:                       // 'ordered'
      try_FTOrder();
      break;
    case 275:                       // 'window'
      try_FTWindow();
      break;
    case 118:                       // 'distance'
      try_FTDistance();
      break;
    case 116:                       // 'different'
    case 227:                       // 'same'
      try_FTScope();
      break;
    default:
      try_FTContent();
    }
  }

  function parse_FTOrder()
  {
    eventHandler.startNonterminal("FTOrder", e0);
    shift(206);                     // 'ordered'
    eventHandler.endNonterminal("FTOrder", e0);
  }

  function try_FTOrder()
  {
    shiftT(206);                    // 'ordered'
  }

  function parse_FTWindow()
  {
    eventHandler.startNonterminal("FTWindow", e0);
    shift(275);                     // 'window'
    lookahead1W(266);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_AdditiveExpr();
    whitespace();
    parse_FTUnit();
    eventHandler.endNonterminal("FTWindow", e0);
  }

  function try_FTWindow()
  {
    shiftT(275);                    // 'window'
    lookahead1W(266);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_AdditiveExpr();
    try_FTUnit();
  }

  function parse_FTDistance()
  {
    eventHandler.startNonterminal("FTDistance", e0);
    shift(118);                     // 'distance'
    lookahead1W(159);               // S^WS | '(:' | 'at' | 'exactly' | 'from'
    whitespace();
    parse_FTRange();
    whitespace();
    parse_FTUnit();
    eventHandler.endNonterminal("FTDistance", e0);
  }

  function try_FTDistance()
  {
    shiftT(118);                    // 'distance'
    lookahead1W(159);               // S^WS | '(:' | 'at' | 'exactly' | 'from'
    try_FTRange();
    try_FTUnit();
  }

  function parse_FTUnit()
  {
    eventHandler.startNonterminal("FTUnit", e0);
    switch (l1)
    {
    case 279:                       // 'words'
      shift(279);                   // 'words'
      break;
    case 237:                       // 'sentences'
      shift(237);                   // 'sentences'
      break;
    default:
      shift(209);                   // 'paragraphs'
    }
    eventHandler.endNonterminal("FTUnit", e0);
  }

  function try_FTUnit()
  {
    switch (l1)
    {
    case 279:                       // 'words'
      shiftT(279);                  // 'words'
      break;
    case 237:                       // 'sentences'
      shiftT(237);                  // 'sentences'
      break;
    default:
      shiftT(209);                  // 'paragraphs'
    }
  }

  function parse_FTScope()
  {
    eventHandler.startNonterminal("FTScope", e0);
    switch (l1)
    {
    case 227:                       // 'same'
      shift(227);                   // 'same'
      break;
    default:
      shift(116);                   // 'different'
    }
    lookahead1W(136);               // S^WS | '(:' | 'paragraph' | 'sentence'
    whitespace();
    parse_FTBigUnit();
    eventHandler.endNonterminal("FTScope", e0);
  }

  function try_FTScope()
  {
    switch (l1)
    {
    case 227:                       // 'same'
      shiftT(227);                  // 'same'
      break;
    default:
      shiftT(116);                  // 'different'
    }
    lookahead1W(136);               // S^WS | '(:' | 'paragraph' | 'sentence'
    try_FTBigUnit();
  }

  function parse_FTBigUnit()
  {
    eventHandler.startNonterminal("FTBigUnit", e0);
    switch (l1)
    {
    case 236:                       // 'sentence'
      shift(236);                   // 'sentence'
      break;
    default:
      shift(208);                   // 'paragraph'
    }
    eventHandler.endNonterminal("FTBigUnit", e0);
  }

  function try_FTBigUnit()
  {
    switch (l1)
    {
    case 236:                       // 'sentence'
      shiftT(236);                  // 'sentence'
      break;
    default:
      shiftT(208);                  // 'paragraph'
    }
  }

  function parse_FTContent()
  {
    eventHandler.startNonterminal("FTContent", e0);
    switch (l1)
    {
    case 82:                        // 'at'
      shift(82);                    // 'at'
      lookahead1W(121);             // S^WS | '(:' | 'end' | 'start'
      switch (l1)
      {
      case 242:                     // 'start'
        shift(242);                 // 'start'
        break;
      default:
        shift(127);                 // 'end'
      }
      break;
    default:
      shift(128);                   // 'entire'
      lookahead1W(45);              // S^WS | '(:' | 'content'
      shift(101);                   // 'content'
    }
    eventHandler.endNonterminal("FTContent", e0);
  }

  function try_FTContent()
  {
    switch (l1)
    {
    case 82:                        // 'at'
      shiftT(82);                   // 'at'
      lookahead1W(121);             // S^WS | '(:' | 'end' | 'start'
      switch (l1)
      {
      case 242:                     // 'start'
        shiftT(242);                // 'start'
        break;
      default:
        shiftT(127);                // 'end'
      }
      break;
    default:
      shiftT(128);                  // 'entire'
      lookahead1W(45);              // S^WS | '(:' | 'content'
      shiftT(101);                  // 'content'
    }
  }

  function parse_FTMatchOptions()
  {
    eventHandler.startNonterminal("FTMatchOptions", e0);
    for (;;)
    {
      shift(265);                   // 'using'
      lookahead1W(205);             // S^WS | '(:' | 'case' | 'diacritics' | 'language' | 'lowercase' | 'no' |
      whitespace();
      parse_FTMatchOption();
      lookahead1W(214);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 != 265)                // 'using'
      {
        break;
      }
    }
    eventHandler.endNonterminal("FTMatchOptions", e0);
  }

  function try_FTMatchOptions()
  {
    for (;;)
    {
      shiftT(265);                  // 'using'
      lookahead1W(205);             // S^WS | '(:' | 'case' | 'diacritics' | 'language' | 'lowercase' | 'no' |
      try_FTMatchOption();
      lookahead1W(214);             // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
      if (l1 != 265)                // 'using'
      {
        break;
      }
    }
  }

  function parse_FTMatchOption()
  {
    eventHandler.startNonterminal("FTMatchOption", e0);
    switch (l1)
    {
    case 191:                       // 'no'
      lookahead2W(176);             // S^WS | '(:' | 'stemming' | 'stop' | 'thesaurus' | 'wildcards'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 172:                       // 'language'
      parse_FTLanguageOption();
      break;
    case 274:                       // 'wildcards'
    case 140479:                    // 'no' 'wildcards'
      parse_FTWildCardOption();
      break;
    case 251:                       // 'thesaurus'
    case 128703:                    // 'no' 'thesaurus'
      parse_FTThesaurusOption();
      break;
    case 243:                       // 'stemming'
    case 124607:                    // 'no' 'stemming'
      parse_FTStemOption();
      break;
    case 115:                       // 'diacritics'
      parse_FTDiacriticsOption();
      break;
    case 244:                       // 'stop'
    case 125119:                    // 'no' 'stop'
      parse_FTStopWordOption();
      break;
    case 203:                       // 'option'
      parse_FTExtensionOption();
      break;
    default:
      parse_FTCaseOption();
    }
    eventHandler.endNonterminal("FTMatchOption", e0);
  }

  function try_FTMatchOption()
  {
    switch (l1)
    {
    case 191:                       // 'no'
      lookahead2W(176);             // S^WS | '(:' | 'stemming' | 'stop' | 'thesaurus' | 'wildcards'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 172:                       // 'language'
      try_FTLanguageOption();
      break;
    case 274:                       // 'wildcards'
    case 140479:                    // 'no' 'wildcards'
      try_FTWildCardOption();
      break;
    case 251:                       // 'thesaurus'
    case 128703:                    // 'no' 'thesaurus'
      try_FTThesaurusOption();
      break;
    case 243:                       // 'stemming'
    case 124607:                    // 'no' 'stemming'
      try_FTStemOption();
      break;
    case 115:                       // 'diacritics'
      try_FTDiacriticsOption();
      break;
    case 244:                       // 'stop'
    case 125119:                    // 'no' 'stop'
      try_FTStopWordOption();
      break;
    case 203:                       // 'option'
      try_FTExtensionOption();
      break;
    default:
      try_FTCaseOption();
    }
  }

  function parse_FTCaseOption()
  {
    eventHandler.startNonterminal("FTCaseOption", e0);
    switch (l1)
    {
    case 89:                        // 'case'
      shift(89);                    // 'case'
      lookahead1W(128);             // S^WS | '(:' | 'insensitive' | 'sensitive'
      switch (l1)
      {
      case 160:                     // 'insensitive'
        shift(160);                 // 'insensitive'
        break;
      default:
        shift(235);                 // 'sensitive'
      }
      break;
    case 180:                       // 'lowercase'
      shift(180);                   // 'lowercase'
      break;
    default:
      shift(264);                   // 'uppercase'
    }
    eventHandler.endNonterminal("FTCaseOption", e0);
  }

  function try_FTCaseOption()
  {
    switch (l1)
    {
    case 89:                        // 'case'
      shiftT(89);                   // 'case'
      lookahead1W(128);             // S^WS | '(:' | 'insensitive' | 'sensitive'
      switch (l1)
      {
      case 160:                     // 'insensitive'
        shiftT(160);                // 'insensitive'
        break;
      default:
        shiftT(235);                // 'sensitive'
      }
      break;
    case 180:                       // 'lowercase'
      shiftT(180);                  // 'lowercase'
      break;
    default:
      shiftT(264);                  // 'uppercase'
    }
  }

  function parse_FTDiacriticsOption()
  {
    eventHandler.startNonterminal("FTDiacriticsOption", e0);
    shift(115);                     // 'diacritics'
    lookahead1W(128);               // S^WS | '(:' | 'insensitive' | 'sensitive'
    switch (l1)
    {
    case 160:                       // 'insensitive'
      shift(160);                   // 'insensitive'
      break;
    default:
      shift(235);                   // 'sensitive'
    }
    eventHandler.endNonterminal("FTDiacriticsOption", e0);
  }

  function try_FTDiacriticsOption()
  {
    shiftT(115);                    // 'diacritics'
    lookahead1W(128);               // S^WS | '(:' | 'insensitive' | 'sensitive'
    switch (l1)
    {
    case 160:                       // 'insensitive'
      shiftT(160);                  // 'insensitive'
      break;
    default:
      shiftT(235);                  // 'sensitive'
    }
  }

  function parse_FTStemOption()
  {
    eventHandler.startNonterminal("FTStemOption", e0);
    switch (l1)
    {
    case 243:                       // 'stemming'
      shift(243);                   // 'stemming'
      break;
    default:
      shift(191);                   // 'no'
      lookahead1W(77);              // S^WS | '(:' | 'stemming'
      shift(243);                   // 'stemming'
    }
    eventHandler.endNonterminal("FTStemOption", e0);
  }

  function try_FTStemOption()
  {
    switch (l1)
    {
    case 243:                       // 'stemming'
      shiftT(243);                  // 'stemming'
      break;
    default:
      shiftT(191);                  // 'no'
      lookahead1W(77);              // S^WS | '(:' | 'stemming'
      shiftT(243);                  // 'stemming'
    }
  }

  function parse_FTThesaurusOption()
  {
    eventHandler.startNonterminal("FTThesaurusOption", e0);
    switch (l1)
    {
    case 251:                       // 'thesaurus'
      shift(251);                   // 'thesaurus'
      lookahead1W(152);             // S^WS | '(' | '(:' | 'at' | 'default'
      switch (l1)
      {
      case 82:                      // 'at'
        whitespace();
        parse_FTThesaurusID();
        break;
      case 110:                     // 'default'
        shift(110);                 // 'default'
        break;
      default:
        shift(35);                  // '('
        lookahead1W(116);           // S^WS | '(:' | 'at' | 'default'
        switch (l1)
        {
        case 82:                    // 'at'
          whitespace();
          parse_FTThesaurusID();
          break;
        default:
          shift(110);               // 'default'
        }
        for (;;)
        {
          lookahead1W(105);         // S^WS | '(:' | ')' | ','
          if (l1 != 42)             // ','
          {
            break;
          }
          shift(42);                // ','
          lookahead1W(34);          // S^WS | '(:' | 'at'
          whitespace();
          parse_FTThesaurusID();
        }
        shift(38);                  // ')'
      }
      break;
    default:
      shift(191);                   // 'no'
      lookahead1W(81);              // S^WS | '(:' | 'thesaurus'
      shift(251);                   // 'thesaurus'
    }
    eventHandler.endNonterminal("FTThesaurusOption", e0);
  }

  function try_FTThesaurusOption()
  {
    switch (l1)
    {
    case 251:                       // 'thesaurus'
      shiftT(251);                  // 'thesaurus'
      lookahead1W(152);             // S^WS | '(' | '(:' | 'at' | 'default'
      switch (l1)
      {
      case 82:                      // 'at'
        try_FTThesaurusID();
        break;
      case 110:                     // 'default'
        shiftT(110);                // 'default'
        break;
      default:
        shiftT(35);                 // '('
        lookahead1W(116);           // S^WS | '(:' | 'at' | 'default'
        switch (l1)
        {
        case 82:                    // 'at'
          try_FTThesaurusID();
          break;
        default:
          shiftT(110);              // 'default'
        }
        for (;;)
        {
          lookahead1W(105);         // S^WS | '(:' | ')' | ','
          if (l1 != 42)             // ','
          {
            break;
          }
          shiftT(42);               // ','
          lookahead1W(34);          // S^WS | '(:' | 'at'
          try_FTThesaurusID();
        }
        shiftT(38);                 // ')'
      }
      break;
    default:
      shiftT(191);                  // 'no'
      lookahead1W(81);              // S^WS | '(:' | 'thesaurus'
      shiftT(251);                  // 'thesaurus'
    }
  }

  function parse_FTThesaurusID()
  {
    eventHandler.startNonterminal("FTThesaurusID", e0);
    shift(82);                      // 'at'
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    lookahead1W(220);               // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
    if (l1 == 221)                  // 'relationship'
    {
      shift(221);                   // 'relationship'
      lookahead1W(17);              // StringLiteral | S^WS | '(:'
      shift(11);                    // StringLiteral
    }
    lookahead1W(216);               // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
    switch (l1)
    {
    case 82:                        // 'at'
      lookahead2W(183);             // S^WS | '(:' | 'end' | 'least' | 'most' | 'position' | 'start'
      break;
    default:
      lk = l1;
    }
    if (lk == 131                   // 'exactly'
     || lk == 142                   // 'from'
     || lk == 90194                 // 'at' 'least'
     || lk == 95314)                // 'at' 'most'
    {
      whitespace();
      parse_FTLiteralRange();
      lookahead1W(61);              // S^WS | '(:' | 'levels'
      shift(178);                   // 'levels'
    }
    eventHandler.endNonterminal("FTThesaurusID", e0);
  }

  function try_FTThesaurusID()
  {
    shiftT(82);                     // 'at'
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shiftT(7);                      // URILiteral
    lookahead1W(220);               // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
    if (l1 == 221)                  // 'relationship'
    {
      shiftT(221);                  // 'relationship'
      lookahead1W(17);              // StringLiteral | S^WS | '(:'
      shiftT(11);                   // StringLiteral
    }
    lookahead1W(216);               // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
    switch (l1)
    {
    case 82:                        // 'at'
      lookahead2W(183);             // S^WS | '(:' | 'end' | 'least' | 'most' | 'position' | 'start'
      break;
    default:
      lk = l1;
    }
    if (lk == 131                   // 'exactly'
     || lk == 142                   // 'from'
     || lk == 90194                 // 'at' 'least'
     || lk == 95314)                // 'at' 'most'
    {
      try_FTLiteralRange();
      lookahead1W(61);              // S^WS | '(:' | 'levels'
      shiftT(178);                  // 'levels'
    }
  }

  function parse_FTLiteralRange()
  {
    eventHandler.startNonterminal("FTLiteralRange", e0);
    switch (l1)
    {
    case 131:                       // 'exactly'
      shift(131);                   // 'exactly'
      lookahead1W(16);              // IntegerLiteral | S^WS | '(:'
      shift(8);                     // IntegerLiteral
      break;
    case 82:                        // 'at'
      shift(82);                    // 'at'
      lookahead1W(129);             // S^WS | '(:' | 'least' | 'most'
      switch (l1)
      {
      case 176:                     // 'least'
        shift(176);                 // 'least'
        lookahead1W(16);            // IntegerLiteral | S^WS | '(:'
        shift(8);                   // IntegerLiteral
        break;
      default:
        shift(186);                 // 'most'
        lookahead1W(16);            // IntegerLiteral | S^WS | '(:'
        shift(8);                   // IntegerLiteral
      }
      break;
    default:
      shift(142);                   // 'from'
      lookahead1W(16);              // IntegerLiteral | S^WS | '(:'
      shift(8);                     // IntegerLiteral
      lookahead1W(82);              // S^WS | '(:' | 'to'
      shift(253);                   // 'to'
      lookahead1W(16);              // IntegerLiteral | S^WS | '(:'
      shift(8);                     // IntegerLiteral
    }
    eventHandler.endNonterminal("FTLiteralRange", e0);
  }

  function try_FTLiteralRange()
  {
    switch (l1)
    {
    case 131:                       // 'exactly'
      shiftT(131);                  // 'exactly'
      lookahead1W(16);              // IntegerLiteral | S^WS | '(:'
      shiftT(8);                    // IntegerLiteral
      break;
    case 82:                        // 'at'
      shiftT(82);                   // 'at'
      lookahead1W(129);             // S^WS | '(:' | 'least' | 'most'
      switch (l1)
      {
      case 176:                     // 'least'
        shiftT(176);                // 'least'
        lookahead1W(16);            // IntegerLiteral | S^WS | '(:'
        shiftT(8);                  // IntegerLiteral
        break;
      default:
        shiftT(186);                // 'most'
        lookahead1W(16);            // IntegerLiteral | S^WS | '(:'
        shiftT(8);                  // IntegerLiteral
      }
      break;
    default:
      shiftT(142);                  // 'from'
      lookahead1W(16);              // IntegerLiteral | S^WS | '(:'
      shiftT(8);                    // IntegerLiteral
      lookahead1W(82);              // S^WS | '(:' | 'to'
      shiftT(253);                  // 'to'
      lookahead1W(16);              // IntegerLiteral | S^WS | '(:'
      shiftT(8);                    // IntegerLiteral
    }
  }

  function parse_FTStopWordOption()
  {
    eventHandler.startNonterminal("FTStopWordOption", e0);
    switch (l1)
    {
    case 244:                       // 'stop'
      shift(244);                   // 'stop'
      lookahead1W(89);              // S^WS | '(:' | 'words'
      shift(279);                   // 'words'
      lookahead1W(152);             // S^WS | '(' | '(:' | 'at' | 'default'
      switch (l1)
      {
      case 110:                     // 'default'
        shift(110);                 // 'default'
        for (;;)
        {
          lookahead1W(217);         // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
          if (l1 != 132             // 'except'
           && l1 != 260)            // 'union'
          {
            break;
          }
          whitespace();
          parse_FTStopWordsInclExcl();
        }
        break;
      default:
        whitespace();
        parse_FTStopWords();
        for (;;)
        {
          lookahead1W(217);         // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
          if (l1 != 132             // 'except'
           && l1 != 260)            // 'union'
          {
            break;
          }
          whitespace();
          parse_FTStopWordsInclExcl();
        }
      }
      break;
    default:
      shift(191);                   // 'no'
      lookahead1W(78);              // S^WS | '(:' | 'stop'
      shift(244);                   // 'stop'
      lookahead1W(89);              // S^WS | '(:' | 'words'
      shift(279);                   // 'words'
    }
    eventHandler.endNonterminal("FTStopWordOption", e0);
  }

  function try_FTStopWordOption()
  {
    switch (l1)
    {
    case 244:                       // 'stop'
      shiftT(244);                  // 'stop'
      lookahead1W(89);              // S^WS | '(:' | 'words'
      shiftT(279);                  // 'words'
      lookahead1W(152);             // S^WS | '(' | '(:' | 'at' | 'default'
      switch (l1)
      {
      case 110:                     // 'default'
        shiftT(110);                // 'default'
        for (;;)
        {
          lookahead1W(217);         // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
          if (l1 != 132             // 'except'
           && l1 != 260)            // 'union'
          {
            break;
          }
          try_FTStopWordsInclExcl();
        }
        break;
      default:
        try_FTStopWords();
        for (;;)
        {
          lookahead1W(217);         // S^WS | EOF | '!=' | '(:' | ')' | ',' | ':' | ';' | '<' | '<<' | '<=' | '=' |
          if (l1 != 132             // 'except'
           && l1 != 260)            // 'union'
          {
            break;
          }
          try_FTStopWordsInclExcl();
        }
      }
      break;
    default:
      shiftT(191);                  // 'no'
      lookahead1W(78);              // S^WS | '(:' | 'stop'
      shiftT(244);                  // 'stop'
      lookahead1W(89);              // S^WS | '(:' | 'words'
      shiftT(279);                  // 'words'
    }
  }

  function parse_FTStopWords()
  {
    eventHandler.startNonterminal("FTStopWords", e0);
    switch (l1)
    {
    case 82:                        // 'at'
      shift(82);                    // 'at'
      lookahead1W(15);              // URILiteral | S^WS | '(:'
      shift(7);                     // URILiteral
      break;
    default:
      shift(35);                    // '('
      lookahead1W(17);              // StringLiteral | S^WS | '(:'
      shift(11);                    // StringLiteral
      for (;;)
      {
        lookahead1W(105);           // S^WS | '(:' | ')' | ','
        if (l1 != 42)               // ','
        {
          break;
        }
        shift(42);                  // ','
        lookahead1W(17);            // StringLiteral | S^WS | '(:'
        shift(11);                  // StringLiteral
      }
      shift(38);                    // ')'
    }
    eventHandler.endNonterminal("FTStopWords", e0);
  }

  function try_FTStopWords()
  {
    switch (l1)
    {
    case 82:                        // 'at'
      shiftT(82);                   // 'at'
      lookahead1W(15);              // URILiteral | S^WS | '(:'
      shiftT(7);                    // URILiteral
      break;
    default:
      shiftT(35);                   // '('
      lookahead1W(17);              // StringLiteral | S^WS | '(:'
      shiftT(11);                   // StringLiteral
      for (;;)
      {
        lookahead1W(105);           // S^WS | '(:' | ')' | ','
        if (l1 != 42)               // ','
        {
          break;
        }
        shiftT(42);                 // ','
        lookahead1W(17);            // StringLiteral | S^WS | '(:'
        shiftT(11);                 // StringLiteral
      }
      shiftT(38);                   // ')'
    }
  }

  function parse_FTStopWordsInclExcl()
  {
    eventHandler.startNonterminal("FTStopWordsInclExcl", e0);
    switch (l1)
    {
    case 260:                       // 'union'
      shift(260);                   // 'union'
      break;
    default:
      shift(132);                   // 'except'
    }
    lookahead1W(103);               // S^WS | '(' | '(:' | 'at'
    whitespace();
    parse_FTStopWords();
    eventHandler.endNonterminal("FTStopWordsInclExcl", e0);
  }

  function try_FTStopWordsInclExcl()
  {
    switch (l1)
    {
    case 260:                       // 'union'
      shiftT(260);                  // 'union'
      break;
    default:
      shiftT(132);                  // 'except'
    }
    lookahead1W(103);               // S^WS | '(' | '(:' | 'at'
    try_FTStopWords();
  }

  function parse_FTLanguageOption()
  {
    eventHandler.startNonterminal("FTLanguageOption", e0);
    shift(172);                     // 'language'
    lookahead1W(17);                // StringLiteral | S^WS | '(:'
    shift(11);                      // StringLiteral
    eventHandler.endNonterminal("FTLanguageOption", e0);
  }

  function try_FTLanguageOption()
  {
    shiftT(172);                    // 'language'
    lookahead1W(17);                // StringLiteral | S^WS | '(:'
    shiftT(11);                     // StringLiteral
  }

  function parse_FTWildCardOption()
  {
    eventHandler.startNonterminal("FTWildCardOption", e0);
    switch (l1)
    {
    case 274:                       // 'wildcards'
      shift(274);                   // 'wildcards'
      break;
    default:
      shift(191);                   // 'no'
      lookahead1W(87);              // S^WS | '(:' | 'wildcards'
      shift(274);                   // 'wildcards'
    }
    eventHandler.endNonterminal("FTWildCardOption", e0);
  }

  function try_FTWildCardOption()
  {
    switch (l1)
    {
    case 274:                       // 'wildcards'
      shiftT(274);                  // 'wildcards'
      break;
    default:
      shiftT(191);                  // 'no'
      lookahead1W(87);              // S^WS | '(:' | 'wildcards'
      shiftT(274);                  // 'wildcards'
    }
  }

  function parse_FTExtensionOption()
  {
    eventHandler.startNonterminal("FTExtensionOption", e0);
    shift(203);                     // 'option'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_EQName();
    lookahead1W(17);                // StringLiteral | S^WS | '(:'
    shift(11);                      // StringLiteral
    eventHandler.endNonterminal("FTExtensionOption", e0);
  }

  function try_FTExtensionOption()
  {
    shiftT(203);                    // 'option'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_EQName();
    lookahead1W(17);                // StringLiteral | S^WS | '(:'
    shiftT(11);                     // StringLiteral
  }

  function parse_FTIgnoreOption()
  {
    eventHandler.startNonterminal("FTIgnoreOption", e0);
    shift(277);                     // 'without'
    lookahead1W(45);                // S^WS | '(:' | 'content'
    shift(101);                     // 'content'
    lookahead1W(266);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_UnionExpr();
    eventHandler.endNonterminal("FTIgnoreOption", e0);
  }

  function try_FTIgnoreOption()
  {
    shiftT(277);                    // 'without'
    lookahead1W(45);                // S^WS | '(:' | 'content'
    shiftT(101);                    // 'content'
    lookahead1W(266);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_UnionExpr();
  }

  function parse_CollectionDecl()
  {
    eventHandler.startNonterminal("CollectionDecl", e0);
    shift(96);                      // 'collection'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_EQName();
    lookahead1W(111);               // S^WS | '(:' | ';' | 'as'
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_CollectionTypeDecl();
    }
    eventHandler.endNonterminal("CollectionDecl", e0);
  }

  function parse_CollectionTypeDecl()
  {
    eventHandler.startNonterminal("CollectionTypeDecl", e0);
    shift(80);                      // 'as'
    lookahead1W(200);               // S^WS | '(:' | 'attribute' | 'comment' | 'document-node' | 'element' |
    whitespace();
    parse_KindTest();
    lookahead1W(171);               // S^WS | '(:' | '*' | '+' | ';' | '?'
    if (l1 != 54)                   // ';'
    {
      whitespace();
      parse_OccurrenceIndicator();
    }
    eventHandler.endNonterminal("CollectionTypeDecl", e0);
  }

  function parse_IndexName()
  {
    eventHandler.startNonterminal("IndexName", e0);
    parse_EQName();
    eventHandler.endNonterminal("IndexName", e0);
  }

  function parse_IndexDomainExpr()
  {
    eventHandler.startNonterminal("IndexDomainExpr", e0);
    parse_PathExpr();
    eventHandler.endNonterminal("IndexDomainExpr", e0);
  }

  function parse_IndexKeySpec()
  {
    eventHandler.startNonterminal("IndexKeySpec", e0);
    parse_IndexKeyExpr();
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_IndexKeyTypeDecl();
    }
    lookahead1W(156);               // S^WS | '(:' | ',' | ';' | 'collation'
    if (l1 == 95)                   // 'collation'
    {
      whitespace();
      parse_IndexKeyCollation();
    }
    eventHandler.endNonterminal("IndexKeySpec", e0);
  }

  function parse_IndexKeyExpr()
  {
    eventHandler.startNonterminal("IndexKeyExpr", e0);
    parse_PathExpr();
    eventHandler.endNonterminal("IndexKeyExpr", e0);
  }

  function parse_IndexKeyTypeDecl()
  {
    eventHandler.startNonterminal("IndexKeyTypeDecl", e0);
    shift(80);                      // 'as'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_AtomicType();
    lookahead1W(189);               // S^WS | '(:' | '*' | '+' | ',' | ';' | '?' | 'collation'
    if (l1 == 40                    // '*'
     || l1 == 41                    // '+'
     || l1 == 65)                   // '?'
    {
      whitespace();
      parse_OccurrenceIndicator();
    }
    eventHandler.endNonterminal("IndexKeyTypeDecl", e0);
  }

  function parse_AtomicType()
  {
    eventHandler.startNonterminal("AtomicType", e0);
    parse_EQName();
    eventHandler.endNonterminal("AtomicType", e0);
  }

  function parse_IndexKeyCollation()
  {
    eventHandler.startNonterminal("IndexKeyCollation", e0);
    shift(95);                      // 'collation'
    lookahead1W(15);                // URILiteral | S^WS | '(:'
    shift(7);                       // URILiteral
    eventHandler.endNonterminal("IndexKeyCollation", e0);
  }

  function parse_IndexDecl()
  {
    eventHandler.startNonterminal("IndexDecl", e0);
    shift(157);                     // 'index'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_IndexName();
    lookahead1W(68);                // S^WS | '(:' | 'on'
    shift(201);                     // 'on'
    lookahead1W(66);                // S^WS | '(:' | 'nodes'
    shift(195);                     // 'nodes'
    lookahead1W(263);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_IndexDomainExpr();
    shift(88);                      // 'by'
    lookahead1W(263);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_IndexKeySpec();
    for (;;)
    {
      lookahead1W(107);             // S^WS | '(:' | ',' | ';'
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(263);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_IndexKeySpec();
    }
    eventHandler.endNonterminal("IndexDecl", e0);
  }

  function parse_ICDecl()
  {
    eventHandler.startNonterminal("ICDecl", e0);
    shift(163);                     // 'integrity'
    lookahead1W(43);                // S^WS | '(:' | 'constraint'
    shift(98);                      // 'constraint'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_EQName();
    lookahead1W(124);               // S^WS | '(:' | 'foreign' | 'on'
    switch (l1)
    {
    case 201:                       // 'on'
      whitespace();
      parse_ICCollection();
      break;
    default:
      whitespace();
      parse_ICForeignKey();
    }
    eventHandler.endNonterminal("ICDecl", e0);
  }

  function parse_ICCollection()
  {
    eventHandler.startNonterminal("ICCollection", e0);
    shift(201);                     // 'on'
    lookahead1W(42);                // S^WS | '(:' | 'collection'
    shift(96);                      // 'collection'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_EQName();
    lookahead1W(150);               // S^WS | '$' | '(:' | 'foreach' | 'node'
    switch (l1)
    {
    case 31:                        // '$'
      whitespace();
      parse_ICCollSequence();
      break;
    case 194:                       // 'node'
      whitespace();
      parse_ICCollSequenceUnique();
      break;
    default:
      whitespace();
      parse_ICCollNode();
    }
    eventHandler.endNonterminal("ICCollection", e0);
  }

  function parse_ICCollSequence()
  {
    eventHandler.startNonterminal("ICCollSequence", e0);
    parse_VarRef();
    lookahead1W(40);                // S^WS | '(:' | 'check'
    shift(93);                      // 'check'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("ICCollSequence", e0);
  }

  function parse_ICCollSequenceUnique()
  {
    eventHandler.startNonterminal("ICCollSequenceUnique", e0);
    shift(194);                     // 'node'
    lookahead1W(21);                // S^WS | '$' | '(:'
    whitespace();
    parse_VarRef();
    lookahead1W(40);                // S^WS | '(:' | 'check'
    shift(93);                      // 'check'
    lookahead1W(83);                // S^WS | '(:' | 'unique'
    shift(261);                     // 'unique'
    lookahead1W(60);                // S^WS | '(:' | 'key'
    shift(171);                     // 'key'
    lookahead1W(263);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_PathExpr();
    eventHandler.endNonterminal("ICCollSequenceUnique", e0);
  }

  function parse_ICCollNode()
  {
    eventHandler.startNonterminal("ICCollNode", e0);
    shift(140);                     // 'foreach'
    lookahead1W(65);                // S^WS | '(:' | 'node'
    shift(194);                     // 'node'
    lookahead1W(21);                // S^WS | '$' | '(:'
    whitespace();
    parse_VarRef();
    lookahead1W(40);                // S^WS | '(:' | 'check'
    shift(93);                      // 'check'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("ICCollNode", e0);
  }

  function parse_ICForeignKey()
  {
    eventHandler.startNonterminal("ICForeignKey", e0);
    shift(141);                     // 'foreign'
    lookahead1W(60);                // S^WS | '(:' | 'key'
    shift(171);                     // 'key'
    lookahead1W(54);                // S^WS | '(:' | 'from'
    whitespace();
    parse_ICForeignKeySource();
    whitespace();
    parse_ICForeignKeyTarget();
    eventHandler.endNonterminal("ICForeignKey", e0);
  }

  function parse_ICForeignKeySource()
  {
    eventHandler.startNonterminal("ICForeignKeySource", e0);
    shift(142);                     // 'from'
    lookahead1W(42);                // S^WS | '(:' | 'collection'
    whitespace();
    parse_ICForeignKeyValues();
    eventHandler.endNonterminal("ICForeignKeySource", e0);
  }

  function parse_ICForeignKeyTarget()
  {
    eventHandler.startNonterminal("ICForeignKeyTarget", e0);
    shift(253);                     // 'to'
    lookahead1W(42);                // S^WS | '(:' | 'collection'
    whitespace();
    parse_ICForeignKeyValues();
    eventHandler.endNonterminal("ICForeignKeyTarget", e0);
  }

  function parse_ICForeignKeyValues()
  {
    eventHandler.startNonterminal("ICForeignKeyValues", e0);
    shift(96);                      // 'collection'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_EQName();
    lookahead1W(65);                // S^WS | '(:' | 'node'
    shift(194);                     // 'node'
    lookahead1W(21);                // S^WS | '$' | '(:'
    whitespace();
    parse_VarRef();
    lookahead1W(60);                // S^WS | '(:' | 'key'
    shift(171);                     // 'key'
    lookahead1W(263);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_PathExpr();
    eventHandler.endNonterminal("ICForeignKeyValues", e0);
  }

  function try_Comment()
  {
    shiftT(37);                     // '(:'
    for (;;)
    {
      lookahead1(92);               // CommentContents | '(:' | ':)'
      if (l1 == 51)                 // ':)'
      {
        break;
      }
      switch (l1)
      {
      case 24:                      // CommentContents
        shiftT(24);                 // CommentContents
        break;
      default:
        try_Comment();
      }
    }
    shiftT(51);                     // ':)'
  }

  function try_Whitespace()
  {
    switch (l1)
    {
    case 22:                        // S^WS
      shiftT(22);                   // S^WS
      break;
    default:
      try_Comment();
    }
  }

  function parse_EQName()
  {
    eventHandler.startNonterminal("EQName", e0);
    lookahead1(241);                // EQName^Token | 'after' | 'allowing' | 'ancestor' | 'ancestor-or-self' | 'and' |
    switch (l1)
    {
    case 83:                        // 'attribute'
      shift(83);                    // 'attribute'
      break;
    case 97:                        // 'comment'
      shift(97);                    // 'comment'
      break;
    case 121:                       // 'document-node'
      shift(121);                   // 'document-node'
      break;
    case 122:                       // 'element'
      shift(122);                   // 'element'
      break;
    case 125:                       // 'empty-sequence'
      shift(125);                   // 'empty-sequence'
      break;
    case 147:                       // 'function'
      shift(147);                   // 'function'
      break;
    case 154:                       // 'if'
      shift(154);                   // 'if'
      break;
    case 167:                       // 'item'
      shift(167);                   // 'item'
      break;
    case 188:                       // 'namespace-node'
      shift(188);                   // 'namespace-node'
      break;
    case 194:                       // 'node'
      shift(194);                   // 'node'
      break;
    case 220:                       // 'processing-instruction'
      shift(220);                   // 'processing-instruction'
      break;
    case 230:                       // 'schema-attribute'
      shift(230);                   // 'schema-attribute'
      break;
    case 231:                       // 'schema-element'
      shift(231);                   // 'schema-element'
      break;
    case 248:                       // 'switch'
      shift(248);                   // 'switch'
      break;
    case 249:                       // 'text'
      shift(249);                   // 'text'
      break;
    case 259:                       // 'typeswitch'
      shift(259);                   // 'typeswitch'
      break;
    case 79:                        // 'array'
      shift(79);                    // 'array'
      break;
    case 169:                       // 'json-item'
      shift(169);                   // 'json-item'
      break;
    case 247:                       // 'structured-item'
      shift(247);                   // 'structured-item'
      break;
    default:
      parse_FunctionName();
    }
    eventHandler.endNonterminal("EQName", e0);
  }

  function try_EQName()
  {
    lookahead1(241);                // EQName^Token | 'after' | 'allowing' | 'ancestor' | 'ancestor-or-self' | 'and' |
    switch (l1)
    {
    case 83:                        // 'attribute'
      shiftT(83);                   // 'attribute'
      break;
    case 97:                        // 'comment'
      shiftT(97);                   // 'comment'
      break;
    case 121:                       // 'document-node'
      shiftT(121);                  // 'document-node'
      break;
    case 122:                       // 'element'
      shiftT(122);                  // 'element'
      break;
    case 125:                       // 'empty-sequence'
      shiftT(125);                  // 'empty-sequence'
      break;
    case 147:                       // 'function'
      shiftT(147);                  // 'function'
      break;
    case 154:                       // 'if'
      shiftT(154);                  // 'if'
      break;
    case 167:                       // 'item'
      shiftT(167);                  // 'item'
      break;
    case 188:                       // 'namespace-node'
      shiftT(188);                  // 'namespace-node'
      break;
    case 194:                       // 'node'
      shiftT(194);                  // 'node'
      break;
    case 220:                       // 'processing-instruction'
      shiftT(220);                  // 'processing-instruction'
      break;
    case 230:                       // 'schema-attribute'
      shiftT(230);                  // 'schema-attribute'
      break;
    case 231:                       // 'schema-element'
      shiftT(231);                  // 'schema-element'
      break;
    case 248:                       // 'switch'
      shiftT(248);                  // 'switch'
      break;
    case 249:                       // 'text'
      shiftT(249);                  // 'text'
      break;
    case 259:                       // 'typeswitch'
      shiftT(259);                  // 'typeswitch'
      break;
    case 79:                        // 'array'
      shiftT(79);                   // 'array'
      break;
    case 169:                       // 'json-item'
      shiftT(169);                  // 'json-item'
      break;
    case 247:                       // 'structured-item'
      shiftT(247);                  // 'structured-item'
      break;
    default:
      try_FunctionName();
    }
  }

  function parse_FunctionName()
  {
    eventHandler.startNonterminal("FunctionName", e0);
    switch (l1)
    {
    case 6:                         // EQName^Token
      shift(6);                     // EQName^Token
      break;
    case 71:                        // 'after'
      shift(71);                    // 'after'
      break;
    case 74:                        // 'ancestor'
      shift(74);                    // 'ancestor'
      break;
    case 75:                        // 'ancestor-or-self'
      shift(75);                    // 'ancestor-or-self'
      break;
    case 76:                        // 'and'
      shift(76);                    // 'and'
      break;
    case 80:                        // 'as'
      shift(80);                    // 'as'
      break;
    case 81:                        // 'ascending'
      shift(81);                    // 'ascending'
      break;
    case 85:                        // 'before'
      shift(85);                    // 'before'
      break;
    case 89:                        // 'case'
      shift(89);                    // 'case'
      break;
    case 90:                        // 'cast'
      shift(90);                    // 'cast'
      break;
    case 91:                        // 'castable'
      shift(91);                    // 'castable'
      break;
    case 94:                        // 'child'
      shift(94);                    // 'child'
      break;
    case 95:                        // 'collation'
      shift(95);                    // 'collation'
      break;
    case 104:                       // 'copy'
      shift(104);                   // 'copy'
      break;
    case 106:                       // 'count'
      shift(106);                   // 'count'
      break;
    case 109:                       // 'declare'
      shift(109);                   // 'declare'
      break;
    case 110:                       // 'default'
      shift(110);                   // 'default'
      break;
    case 111:                       // 'delete'
      shift(111);                   // 'delete'
      break;
    case 112:                       // 'descendant'
      shift(112);                   // 'descendant'
      break;
    case 113:                       // 'descendant-or-self'
      shift(113);                   // 'descendant-or-self'
      break;
    case 114:                       // 'descending'
      shift(114);                   // 'descending'
      break;
    case 119:                       // 'div'
      shift(119);                   // 'div'
      break;
    case 120:                       // 'document'
      shift(120);                   // 'document'
      break;
    case 123:                       // 'else'
      shift(123);                   // 'else'
      break;
    case 124:                       // 'empty'
      shift(124);                   // 'empty'
      break;
    case 127:                       // 'end'
      shift(127);                   // 'end'
      break;
    case 129:                       // 'eq'
      shift(129);                   // 'eq'
      break;
    case 130:                       // 'every'
      shift(130);                   // 'every'
      break;
    case 132:                       // 'except'
      shift(132);                   // 'except'
      break;
    case 136:                       // 'first'
      shift(136);                   // 'first'
      break;
    case 137:                       // 'following'
      shift(137);                   // 'following'
      break;
    case 138:                       // 'following-sibling'
      shift(138);                   // 'following-sibling'
      break;
    case 139:                       // 'for'
      shift(139);                   // 'for'
      break;
    case 148:                       // 'ge'
      shift(148);                   // 'ge'
      break;
    case 150:                       // 'group'
      shift(150);                   // 'group'
      break;
    case 152:                       // 'gt'
      shift(152);                   // 'gt'
      break;
    case 153:                       // 'idiv'
      shift(153);                   // 'idiv'
      break;
    case 155:                       // 'import'
      shift(155);                   // 'import'
      break;
    case 161:                       // 'insert'
      shift(161);                   // 'insert'
      break;
    case 162:                       // 'instance'
      shift(162);                   // 'instance'
      break;
    case 164:                       // 'intersect'
      shift(164);                   // 'intersect'
      break;
    case 165:                       // 'into'
      shift(165);                   // 'into'
      break;
    case 166:                       // 'is'
      shift(166);                   // 'is'
      break;
    case 173:                       // 'last'
      shift(173);                   // 'last'
      break;
    case 175:                       // 'le'
      shift(175);                   // 'le'
      break;
    case 177:                       // 'let'
      shift(177);                   // 'let'
      break;
    case 181:                       // 'lt'
      shift(181);                   // 'lt'
      break;
    case 183:                       // 'mod'
      shift(183);                   // 'mod'
      break;
    case 184:                       // 'modify'
      shift(184);                   // 'modify'
      break;
    case 185:                       // 'module'
      shift(185);                   // 'module'
      break;
    case 187:                       // 'namespace'
      shift(187);                   // 'namespace'
      break;
    case 189:                       // 'ne'
      shift(189);                   // 'ne'
      break;
    case 202:                       // 'only'
      shift(202);                   // 'only'
      break;
    case 204:                       // 'or'
      shift(204);                   // 'or'
      break;
    case 205:                       // 'order'
      shift(205);                   // 'order'
      break;
    case 206:                       // 'ordered'
      shift(206);                   // 'ordered'
      break;
    case 210:                       // 'parent'
      shift(210);                   // 'parent'
      break;
    case 216:                       // 'preceding'
      shift(216);                   // 'preceding'
      break;
    case 217:                       // 'preceding-sibling'
      shift(217);                   // 'preceding-sibling'
      break;
    case 222:                       // 'rename'
      shift(222);                   // 'rename'
      break;
    case 223:                       // 'replace'
      shift(223);                   // 'replace'
      break;
    case 224:                       // 'return'
      shift(224);                   // 'return'
      break;
    case 228:                       // 'satisfies'
      shift(228);                   // 'satisfies'
      break;
    case 234:                       // 'self'
      shift(234);                   // 'self'
      break;
    case 240:                       // 'some'
      shift(240);                   // 'some'
      break;
    case 241:                       // 'stable'
      shift(241);                   // 'stable'
      break;
    case 242:                       // 'start'
      shift(242);                   // 'start'
      break;
    case 253:                       // 'to'
      shift(253);                   // 'to'
      break;
    case 254:                       // 'treat'
      shift(254);                   // 'treat'
      break;
    case 256:                       // 'try'
      shift(256);                   // 'try'
      break;
    case 260:                       // 'union'
      shift(260);                   // 'union'
      break;
    case 262:                       // 'unordered'
      shift(262);                   // 'unordered'
      break;
    case 266:                       // 'validate'
      shift(266);                   // 'validate'
      break;
    case 272:                       // 'where'
      shift(272);                   // 'where'
      break;
    case 276:                       // 'with'
      shift(276);                   // 'with'
      break;
    case 170:                       // 'jsoniq'
      shift(170);                   // 'jsoniq'
      break;
    case 73:                        // 'allowing'
      shift(73);                    // 'allowing'
      break;
    case 82:                        // 'at'
      shift(82);                    // 'at'
      break;
    case 84:                        // 'base-uri'
      shift(84);                    // 'base-uri'
      break;
    case 86:                        // 'boundary-space'
      shift(86);                    // 'boundary-space'
      break;
    case 87:                        // 'break'
      shift(87);                    // 'break'
      break;
    case 92:                        // 'catch'
      shift(92);                    // 'catch'
      break;
    case 99:                        // 'construction'
      shift(99);                    // 'construction'
      break;
    case 102:                       // 'context'
      shift(102);                   // 'context'
      break;
    case 103:                       // 'continue'
      shift(103);                   // 'continue'
      break;
    case 105:                       // 'copy-namespaces'
      shift(105);                   // 'copy-namespaces'
      break;
    case 107:                       // 'decimal-format'
      shift(107);                   // 'decimal-format'
      break;
    case 126:                       // 'encoding'
      shift(126);                   // 'encoding'
      break;
    case 133:                       // 'exit'
      shift(133);                   // 'exit'
      break;
    case 134:                       // 'external'
      shift(134);                   // 'external'
      break;
    case 143:                       // 'ft-option'
      shift(143);                   // 'ft-option'
      break;
    case 156:                       // 'in'
      shift(156);                   // 'in'
      break;
    case 157:                       // 'index'
      shift(157);                   // 'index'
      break;
    case 163:                       // 'integrity'
      shift(163);                   // 'integrity'
      break;
    case 174:                       // 'lax'
      shift(174);                   // 'lax'
      break;
    case 195:                       // 'nodes'
      shift(195);                   // 'nodes'
      break;
    case 203:                       // 'option'
      shift(203);                   // 'option'
      break;
    case 207:                       // 'ordering'
      shift(207);                   // 'ordering'
      break;
    case 226:                       // 'revalidation'
      shift(226);                   // 'revalidation'
      break;
    case 229:                       // 'schema'
      shift(229);                   // 'schema'
      break;
    case 232:                       // 'score'
      shift(232);                   // 'score'
      break;
    case 239:                       // 'sliding'
      shift(239);                   // 'sliding'
      break;
    case 245:                       // 'strict'
      shift(245);                   // 'strict'
      break;
    case 257:                       // 'tumbling'
      shift(257);                   // 'tumbling'
      break;
    case 258:                       // 'type'
      shift(258);                   // 'type'
      break;
    case 263:                       // 'updating'
      shift(263);                   // 'updating'
      break;
    case 267:                       // 'value'
      shift(267);                   // 'value'
      break;
    case 268:                       // 'variable'
      shift(268);                   // 'variable'
      break;
    case 269:                       // 'version'
      shift(269);                   // 'version'
      break;
    case 273:                       // 'while'
      shift(273);                   // 'while'
      break;
    case 98:                        // 'constraint'
      shift(98);                    // 'constraint'
      break;
    case 179:                       // 'loop'
      shift(179);                   // 'loop'
      break;
    case 225:                       // 'returning'
      shift(225);                   // 'returning'
      break;
    case 78:                        // 'append'
      shift(78);                    // 'append'
      break;
    case 135:                       // 'false'
      shift(135);                   // 'false'
      break;
    case 142:                       // 'from'
      shift(142);                   // 'from'
      break;
    case 197:                       // 'null'
      shift(197);                   // 'null'
      break;
    case 168:                       // 'json'
      shift(168);                   // 'json'
      break;
    case 198:                       // 'object'
      shift(198);                   // 'object'
      break;
    case 233:                       // 'select'
      shift(233);                   // 'select'
      break;
    default:
      shift(255);                   // 'true'
    }
    eventHandler.endNonterminal("FunctionName", e0);
  }

  function try_FunctionName()
  {
    switch (l1)
    {
    case 6:                         // EQName^Token
      shiftT(6);                    // EQName^Token
      break;
    case 71:                        // 'after'
      shiftT(71);                   // 'after'
      break;
    case 74:                        // 'ancestor'
      shiftT(74);                   // 'ancestor'
      break;
    case 75:                        // 'ancestor-or-self'
      shiftT(75);                   // 'ancestor-or-self'
      break;
    case 76:                        // 'and'
      shiftT(76);                   // 'and'
      break;
    case 80:                        // 'as'
      shiftT(80);                   // 'as'
      break;
    case 81:                        // 'ascending'
      shiftT(81);                   // 'ascending'
      break;
    case 85:                        // 'before'
      shiftT(85);                   // 'before'
      break;
    case 89:                        // 'case'
      shiftT(89);                   // 'case'
      break;
    case 90:                        // 'cast'
      shiftT(90);                   // 'cast'
      break;
    case 91:                        // 'castable'
      shiftT(91);                   // 'castable'
      break;
    case 94:                        // 'child'
      shiftT(94);                   // 'child'
      break;
    case 95:                        // 'collation'
      shiftT(95);                   // 'collation'
      break;
    case 104:                       // 'copy'
      shiftT(104);                  // 'copy'
      break;
    case 106:                       // 'count'
      shiftT(106);                  // 'count'
      break;
    case 109:                       // 'declare'
      shiftT(109);                  // 'declare'
      break;
    case 110:                       // 'default'
      shiftT(110);                  // 'default'
      break;
    case 111:                       // 'delete'
      shiftT(111);                  // 'delete'
      break;
    case 112:                       // 'descendant'
      shiftT(112);                  // 'descendant'
      break;
    case 113:                       // 'descendant-or-self'
      shiftT(113);                  // 'descendant-or-self'
      break;
    case 114:                       // 'descending'
      shiftT(114);                  // 'descending'
      break;
    case 119:                       // 'div'
      shiftT(119);                  // 'div'
      break;
    case 120:                       // 'document'
      shiftT(120);                  // 'document'
      break;
    case 123:                       // 'else'
      shiftT(123);                  // 'else'
      break;
    case 124:                       // 'empty'
      shiftT(124);                  // 'empty'
      break;
    case 127:                       // 'end'
      shiftT(127);                  // 'end'
      break;
    case 129:                       // 'eq'
      shiftT(129);                  // 'eq'
      break;
    case 130:                       // 'every'
      shiftT(130);                  // 'every'
      break;
    case 132:                       // 'except'
      shiftT(132);                  // 'except'
      break;
    case 136:                       // 'first'
      shiftT(136);                  // 'first'
      break;
    case 137:                       // 'following'
      shiftT(137);                  // 'following'
      break;
    case 138:                       // 'following-sibling'
      shiftT(138);                  // 'following-sibling'
      break;
    case 139:                       // 'for'
      shiftT(139);                  // 'for'
      break;
    case 148:                       // 'ge'
      shiftT(148);                  // 'ge'
      break;
    case 150:                       // 'group'
      shiftT(150);                  // 'group'
      break;
    case 152:                       // 'gt'
      shiftT(152);                  // 'gt'
      break;
    case 153:                       // 'idiv'
      shiftT(153);                  // 'idiv'
      break;
    case 155:                       // 'import'
      shiftT(155);                  // 'import'
      break;
    case 161:                       // 'insert'
      shiftT(161);                  // 'insert'
      break;
    case 162:                       // 'instance'
      shiftT(162);                  // 'instance'
      break;
    case 164:                       // 'intersect'
      shiftT(164);                  // 'intersect'
      break;
    case 165:                       // 'into'
      shiftT(165);                  // 'into'
      break;
    case 166:                       // 'is'
      shiftT(166);                  // 'is'
      break;
    case 173:                       // 'last'
      shiftT(173);                  // 'last'
      break;
    case 175:                       // 'le'
      shiftT(175);                  // 'le'
      break;
    case 177:                       // 'let'
      shiftT(177);                  // 'let'
      break;
    case 181:                       // 'lt'
      shiftT(181);                  // 'lt'
      break;
    case 183:                       // 'mod'
      shiftT(183);                  // 'mod'
      break;
    case 184:                       // 'modify'
      shiftT(184);                  // 'modify'
      break;
    case 185:                       // 'module'
      shiftT(185);                  // 'module'
      break;
    case 187:                       // 'namespace'
      shiftT(187);                  // 'namespace'
      break;
    case 189:                       // 'ne'
      shiftT(189);                  // 'ne'
      break;
    case 202:                       // 'only'
      shiftT(202);                  // 'only'
      break;
    case 204:                       // 'or'
      shiftT(204);                  // 'or'
      break;
    case 205:                       // 'order'
      shiftT(205);                  // 'order'
      break;
    case 206:                       // 'ordered'
      shiftT(206);                  // 'ordered'
      break;
    case 210:                       // 'parent'
      shiftT(210);                  // 'parent'
      break;
    case 216:                       // 'preceding'
      shiftT(216);                  // 'preceding'
      break;
    case 217:                       // 'preceding-sibling'
      shiftT(217);                  // 'preceding-sibling'
      break;
    case 222:                       // 'rename'
      shiftT(222);                  // 'rename'
      break;
    case 223:                       // 'replace'
      shiftT(223);                  // 'replace'
      break;
    case 224:                       // 'return'
      shiftT(224);                  // 'return'
      break;
    case 228:                       // 'satisfies'
      shiftT(228);                  // 'satisfies'
      break;
    case 234:                       // 'self'
      shiftT(234);                  // 'self'
      break;
    case 240:                       // 'some'
      shiftT(240);                  // 'some'
      break;
    case 241:                       // 'stable'
      shiftT(241);                  // 'stable'
      break;
    case 242:                       // 'start'
      shiftT(242);                  // 'start'
      break;
    case 253:                       // 'to'
      shiftT(253);                  // 'to'
      break;
    case 254:                       // 'treat'
      shiftT(254);                  // 'treat'
      break;
    case 256:                       // 'try'
      shiftT(256);                  // 'try'
      break;
    case 260:                       // 'union'
      shiftT(260);                  // 'union'
      break;
    case 262:                       // 'unordered'
      shiftT(262);                  // 'unordered'
      break;
    case 266:                       // 'validate'
      shiftT(266);                  // 'validate'
      break;
    case 272:                       // 'where'
      shiftT(272);                  // 'where'
      break;
    case 276:                       // 'with'
      shiftT(276);                  // 'with'
      break;
    case 170:                       // 'jsoniq'
      shiftT(170);                  // 'jsoniq'
      break;
    case 73:                        // 'allowing'
      shiftT(73);                   // 'allowing'
      break;
    case 82:                        // 'at'
      shiftT(82);                   // 'at'
      break;
    case 84:                        // 'base-uri'
      shiftT(84);                   // 'base-uri'
      break;
    case 86:                        // 'boundary-space'
      shiftT(86);                   // 'boundary-space'
      break;
    case 87:                        // 'break'
      shiftT(87);                   // 'break'
      break;
    case 92:                        // 'catch'
      shiftT(92);                   // 'catch'
      break;
    case 99:                        // 'construction'
      shiftT(99);                   // 'construction'
      break;
    case 102:                       // 'context'
      shiftT(102);                  // 'context'
      break;
    case 103:                       // 'continue'
      shiftT(103);                  // 'continue'
      break;
    case 105:                       // 'copy-namespaces'
      shiftT(105);                  // 'copy-namespaces'
      break;
    case 107:                       // 'decimal-format'
      shiftT(107);                  // 'decimal-format'
      break;
    case 126:                       // 'encoding'
      shiftT(126);                  // 'encoding'
      break;
    case 133:                       // 'exit'
      shiftT(133);                  // 'exit'
      break;
    case 134:                       // 'external'
      shiftT(134);                  // 'external'
      break;
    case 143:                       // 'ft-option'
      shiftT(143);                  // 'ft-option'
      break;
    case 156:                       // 'in'
      shiftT(156);                  // 'in'
      break;
    case 157:                       // 'index'
      shiftT(157);                  // 'index'
      break;
    case 163:                       // 'integrity'
      shiftT(163);                  // 'integrity'
      break;
    case 174:                       // 'lax'
      shiftT(174);                  // 'lax'
      break;
    case 195:                       // 'nodes'
      shiftT(195);                  // 'nodes'
      break;
    case 203:                       // 'option'
      shiftT(203);                  // 'option'
      break;
    case 207:                       // 'ordering'
      shiftT(207);                  // 'ordering'
      break;
    case 226:                       // 'revalidation'
      shiftT(226);                  // 'revalidation'
      break;
    case 229:                       // 'schema'
      shiftT(229);                  // 'schema'
      break;
    case 232:                       // 'score'
      shiftT(232);                  // 'score'
      break;
    case 239:                       // 'sliding'
      shiftT(239);                  // 'sliding'
      break;
    case 245:                       // 'strict'
      shiftT(245);                  // 'strict'
      break;
    case 257:                       // 'tumbling'
      shiftT(257);                  // 'tumbling'
      break;
    case 258:                       // 'type'
      shiftT(258);                  // 'type'
      break;
    case 263:                       // 'updating'
      shiftT(263);                  // 'updating'
      break;
    case 267:                       // 'value'
      shiftT(267);                  // 'value'
      break;
    case 268:                       // 'variable'
      shiftT(268);                  // 'variable'
      break;
    case 269:                       // 'version'
      shiftT(269);                  // 'version'
      break;
    case 273:                       // 'while'
      shiftT(273);                  // 'while'
      break;
    case 98:                        // 'constraint'
      shiftT(98);                   // 'constraint'
      break;
    case 179:                       // 'loop'
      shiftT(179);                  // 'loop'
      break;
    case 225:                       // 'returning'
      shiftT(225);                  // 'returning'
      break;
    case 78:                        // 'append'
      shiftT(78);                   // 'append'
      break;
    case 135:                       // 'false'
      shiftT(135);                  // 'false'
      break;
    case 142:                       // 'from'
      shiftT(142);                  // 'from'
      break;
    case 197:                       // 'null'
      shiftT(197);                  // 'null'
      break;
    case 168:                       // 'json'
      shiftT(168);                  // 'json'
      break;
    case 198:                       // 'object'
      shiftT(198);                  // 'object'
      break;
    case 233:                       // 'select'
      shiftT(233);                  // 'select'
      break;
    default:
      shiftT(255);                  // 'true'
    }
  }

  function parse_NCName()
  {
    eventHandler.startNonterminal("NCName", e0);
    switch (l1)
    {
    case 19:                        // NCName^Token
      shift(19);                    // NCName^Token
      break;
    case 71:                        // 'after'
      shift(71);                    // 'after'
      break;
    case 76:                        // 'and'
      shift(76);                    // 'and'
      break;
    case 80:                        // 'as'
      shift(80);                    // 'as'
      break;
    case 81:                        // 'ascending'
      shift(81);                    // 'ascending'
      break;
    case 85:                        // 'before'
      shift(85);                    // 'before'
      break;
    case 89:                        // 'case'
      shift(89);                    // 'case'
      break;
    case 90:                        // 'cast'
      shift(90);                    // 'cast'
      break;
    case 91:                        // 'castable'
      shift(91);                    // 'castable'
      break;
    case 95:                        // 'collation'
      shift(95);                    // 'collation'
      break;
    case 106:                       // 'count'
      shift(106);                   // 'count'
      break;
    case 110:                       // 'default'
      shift(110);                   // 'default'
      break;
    case 114:                       // 'descending'
      shift(114);                   // 'descending'
      break;
    case 119:                       // 'div'
      shift(119);                   // 'div'
      break;
    case 123:                       // 'else'
      shift(123);                   // 'else'
      break;
    case 124:                       // 'empty'
      shift(124);                   // 'empty'
      break;
    case 127:                       // 'end'
      shift(127);                   // 'end'
      break;
    case 129:                       // 'eq'
      shift(129);                   // 'eq'
      break;
    case 132:                       // 'except'
      shift(132);                   // 'except'
      break;
    case 139:                       // 'for'
      shift(139);                   // 'for'
      break;
    case 148:                       // 'ge'
      shift(148);                   // 'ge'
      break;
    case 150:                       // 'group'
      shift(150);                   // 'group'
      break;
    case 152:                       // 'gt'
      shift(152);                   // 'gt'
      break;
    case 153:                       // 'idiv'
      shift(153);                   // 'idiv'
      break;
    case 162:                       // 'instance'
      shift(162);                   // 'instance'
      break;
    case 164:                       // 'intersect'
      shift(164);                   // 'intersect'
      break;
    case 165:                       // 'into'
      shift(165);                   // 'into'
      break;
    case 166:                       // 'is'
      shift(166);                   // 'is'
      break;
    case 175:                       // 'le'
      shift(175);                   // 'le'
      break;
    case 177:                       // 'let'
      shift(177);                   // 'let'
      break;
    case 181:                       // 'lt'
      shift(181);                   // 'lt'
      break;
    case 183:                       // 'mod'
      shift(183);                   // 'mod'
      break;
    case 184:                       // 'modify'
      shift(184);                   // 'modify'
      break;
    case 189:                       // 'ne'
      shift(189);                   // 'ne'
      break;
    case 202:                       // 'only'
      shift(202);                   // 'only'
      break;
    case 204:                       // 'or'
      shift(204);                   // 'or'
      break;
    case 205:                       // 'order'
      shift(205);                   // 'order'
      break;
    case 224:                       // 'return'
      shift(224);                   // 'return'
      break;
    case 228:                       // 'satisfies'
      shift(228);                   // 'satisfies'
      break;
    case 241:                       // 'stable'
      shift(241);                   // 'stable'
      break;
    case 242:                       // 'start'
      shift(242);                   // 'start'
      break;
    case 253:                       // 'to'
      shift(253);                   // 'to'
      break;
    case 254:                       // 'treat'
      shift(254);                   // 'treat'
      break;
    case 260:                       // 'union'
      shift(260);                   // 'union'
      break;
    case 272:                       // 'where'
      shift(272);                   // 'where'
      break;
    case 276:                       // 'with'
      shift(276);                   // 'with'
      break;
    case 74:                        // 'ancestor'
      shift(74);                    // 'ancestor'
      break;
    case 75:                        // 'ancestor-or-self'
      shift(75);                    // 'ancestor-or-self'
      break;
    case 83:                        // 'attribute'
      shift(83);                    // 'attribute'
      break;
    case 94:                        // 'child'
      shift(94);                    // 'child'
      break;
    case 97:                        // 'comment'
      shift(97);                    // 'comment'
      break;
    case 104:                       // 'copy'
      shift(104);                   // 'copy'
      break;
    case 109:                       // 'declare'
      shift(109);                   // 'declare'
      break;
    case 111:                       // 'delete'
      shift(111);                   // 'delete'
      break;
    case 112:                       // 'descendant'
      shift(112);                   // 'descendant'
      break;
    case 113:                       // 'descendant-or-self'
      shift(113);                   // 'descendant-or-self'
      break;
    case 120:                       // 'document'
      shift(120);                   // 'document'
      break;
    case 121:                       // 'document-node'
      shift(121);                   // 'document-node'
      break;
    case 122:                       // 'element'
      shift(122);                   // 'element'
      break;
    case 125:                       // 'empty-sequence'
      shift(125);                   // 'empty-sequence'
      break;
    case 130:                       // 'every'
      shift(130);                   // 'every'
      break;
    case 136:                       // 'first'
      shift(136);                   // 'first'
      break;
    case 137:                       // 'following'
      shift(137);                   // 'following'
      break;
    case 138:                       // 'following-sibling'
      shift(138);                   // 'following-sibling'
      break;
    case 147:                       // 'function'
      shift(147);                   // 'function'
      break;
    case 154:                       // 'if'
      shift(154);                   // 'if'
      break;
    case 155:                       // 'import'
      shift(155);                   // 'import'
      break;
    case 161:                       // 'insert'
      shift(161);                   // 'insert'
      break;
    case 167:                       // 'item'
      shift(167);                   // 'item'
      break;
    case 173:                       // 'last'
      shift(173);                   // 'last'
      break;
    case 185:                       // 'module'
      shift(185);                   // 'module'
      break;
    case 187:                       // 'namespace'
      shift(187);                   // 'namespace'
      break;
    case 188:                       // 'namespace-node'
      shift(188);                   // 'namespace-node'
      break;
    case 194:                       // 'node'
      shift(194);                   // 'node'
      break;
    case 206:                       // 'ordered'
      shift(206);                   // 'ordered'
      break;
    case 210:                       // 'parent'
      shift(210);                   // 'parent'
      break;
    case 216:                       // 'preceding'
      shift(216);                   // 'preceding'
      break;
    case 217:                       // 'preceding-sibling'
      shift(217);                   // 'preceding-sibling'
      break;
    case 220:                       // 'processing-instruction'
      shift(220);                   // 'processing-instruction'
      break;
    case 222:                       // 'rename'
      shift(222);                   // 'rename'
      break;
    case 223:                       // 'replace'
      shift(223);                   // 'replace'
      break;
    case 230:                       // 'schema-attribute'
      shift(230);                   // 'schema-attribute'
      break;
    case 231:                       // 'schema-element'
      shift(231);                   // 'schema-element'
      break;
    case 234:                       // 'self'
      shift(234);                   // 'self'
      break;
    case 240:                       // 'some'
      shift(240);                   // 'some'
      break;
    case 248:                       // 'switch'
      shift(248);                   // 'switch'
      break;
    case 249:                       // 'text'
      shift(249);                   // 'text'
      break;
    case 256:                       // 'try'
      shift(256);                   // 'try'
      break;
    case 259:                       // 'typeswitch'
      shift(259);                   // 'typeswitch'
      break;
    case 262:                       // 'unordered'
      shift(262);                   // 'unordered'
      break;
    case 266:                       // 'validate'
      shift(266);                   // 'validate'
      break;
    case 268:                       // 'variable'
      shift(268);                   // 'variable'
      break;
    case 170:                       // 'jsoniq'
      shift(170);                   // 'jsoniq'
      break;
    case 73:                        // 'allowing'
      shift(73);                    // 'allowing'
      break;
    case 82:                        // 'at'
      shift(82);                    // 'at'
      break;
    case 84:                        // 'base-uri'
      shift(84);                    // 'base-uri'
      break;
    case 86:                        // 'boundary-space'
      shift(86);                    // 'boundary-space'
      break;
    case 87:                        // 'break'
      shift(87);                    // 'break'
      break;
    case 92:                        // 'catch'
      shift(92);                    // 'catch'
      break;
    case 99:                        // 'construction'
      shift(99);                    // 'construction'
      break;
    case 102:                       // 'context'
      shift(102);                   // 'context'
      break;
    case 103:                       // 'continue'
      shift(103);                   // 'continue'
      break;
    case 105:                       // 'copy-namespaces'
      shift(105);                   // 'copy-namespaces'
      break;
    case 107:                       // 'decimal-format'
      shift(107);                   // 'decimal-format'
      break;
    case 126:                       // 'encoding'
      shift(126);                   // 'encoding'
      break;
    case 133:                       // 'exit'
      shift(133);                   // 'exit'
      break;
    case 134:                       // 'external'
      shift(134);                   // 'external'
      break;
    case 143:                       // 'ft-option'
      shift(143);                   // 'ft-option'
      break;
    case 156:                       // 'in'
      shift(156);                   // 'in'
      break;
    case 157:                       // 'index'
      shift(157);                   // 'index'
      break;
    case 163:                       // 'integrity'
      shift(163);                   // 'integrity'
      break;
    case 174:                       // 'lax'
      shift(174);                   // 'lax'
      break;
    case 195:                       // 'nodes'
      shift(195);                   // 'nodes'
      break;
    case 203:                       // 'option'
      shift(203);                   // 'option'
      break;
    case 207:                       // 'ordering'
      shift(207);                   // 'ordering'
      break;
    case 226:                       // 'revalidation'
      shift(226);                   // 'revalidation'
      break;
    case 229:                       // 'schema'
      shift(229);                   // 'schema'
      break;
    case 232:                       // 'score'
      shift(232);                   // 'score'
      break;
    case 239:                       // 'sliding'
      shift(239);                   // 'sliding'
      break;
    case 245:                       // 'strict'
      shift(245);                   // 'strict'
      break;
    case 257:                       // 'tumbling'
      shift(257);                   // 'tumbling'
      break;
    case 258:                       // 'type'
      shift(258);                   // 'type'
      break;
    case 263:                       // 'updating'
      shift(263);                   // 'updating'
      break;
    case 267:                       // 'value'
      shift(267);                   // 'value'
      break;
    case 269:                       // 'version'
      shift(269);                   // 'version'
      break;
    case 273:                       // 'while'
      shift(273);                   // 'while'
      break;
    case 98:                        // 'constraint'
      shift(98);                    // 'constraint'
      break;
    case 179:                       // 'loop'
      shift(179);                   // 'loop'
      break;
    case 225:                       // 'returning'
      shift(225);                   // 'returning'
      break;
    case 78:                        // 'append'
      shift(78);                    // 'append'
      break;
    case 135:                       // 'false'
      shift(135);                   // 'false'
      break;
    case 142:                       // 'from'
      shift(142);                   // 'from'
      break;
    case 197:                       // 'null'
      shift(197);                   // 'null'
      break;
    case 168:                       // 'json'
      shift(168);                   // 'json'
      break;
    case 198:                       // 'object'
      shift(198);                   // 'object'
      break;
    case 233:                       // 'select'
      shift(233);                   // 'select'
      break;
    default:
      shift(255);                   // 'true'
    }
    eventHandler.endNonterminal("NCName", e0);
  }

  function try_NCName()
  {
    switch (l1)
    {
    case 19:                        // NCName^Token
      shiftT(19);                   // NCName^Token
      break;
    case 71:                        // 'after'
      shiftT(71);                   // 'after'
      break;
    case 76:                        // 'and'
      shiftT(76);                   // 'and'
      break;
    case 80:                        // 'as'
      shiftT(80);                   // 'as'
      break;
    case 81:                        // 'ascending'
      shiftT(81);                   // 'ascending'
      break;
    case 85:                        // 'before'
      shiftT(85);                   // 'before'
      break;
    case 89:                        // 'case'
      shiftT(89);                   // 'case'
      break;
    case 90:                        // 'cast'
      shiftT(90);                   // 'cast'
      break;
    case 91:                        // 'castable'
      shiftT(91);                   // 'castable'
      break;
    case 95:                        // 'collation'
      shiftT(95);                   // 'collation'
      break;
    case 106:                       // 'count'
      shiftT(106);                  // 'count'
      break;
    case 110:                       // 'default'
      shiftT(110);                  // 'default'
      break;
    case 114:                       // 'descending'
      shiftT(114);                  // 'descending'
      break;
    case 119:                       // 'div'
      shiftT(119);                  // 'div'
      break;
    case 123:                       // 'else'
      shiftT(123);                  // 'else'
      break;
    case 124:                       // 'empty'
      shiftT(124);                  // 'empty'
      break;
    case 127:                       // 'end'
      shiftT(127);                  // 'end'
      break;
    case 129:                       // 'eq'
      shiftT(129);                  // 'eq'
      break;
    case 132:                       // 'except'
      shiftT(132);                  // 'except'
      break;
    case 139:                       // 'for'
      shiftT(139);                  // 'for'
      break;
    case 148:                       // 'ge'
      shiftT(148);                  // 'ge'
      break;
    case 150:                       // 'group'
      shiftT(150);                  // 'group'
      break;
    case 152:                       // 'gt'
      shiftT(152);                  // 'gt'
      break;
    case 153:                       // 'idiv'
      shiftT(153);                  // 'idiv'
      break;
    case 162:                       // 'instance'
      shiftT(162);                  // 'instance'
      break;
    case 164:                       // 'intersect'
      shiftT(164);                  // 'intersect'
      break;
    case 165:                       // 'into'
      shiftT(165);                  // 'into'
      break;
    case 166:                       // 'is'
      shiftT(166);                  // 'is'
      break;
    case 175:                       // 'le'
      shiftT(175);                  // 'le'
      break;
    case 177:                       // 'let'
      shiftT(177);                  // 'let'
      break;
    case 181:                       // 'lt'
      shiftT(181);                  // 'lt'
      break;
    case 183:                       // 'mod'
      shiftT(183);                  // 'mod'
      break;
    case 184:                       // 'modify'
      shiftT(184);                  // 'modify'
      break;
    case 189:                       // 'ne'
      shiftT(189);                  // 'ne'
      break;
    case 202:                       // 'only'
      shiftT(202);                  // 'only'
      break;
    case 204:                       // 'or'
      shiftT(204);                  // 'or'
      break;
    case 205:                       // 'order'
      shiftT(205);                  // 'order'
      break;
    case 224:                       // 'return'
      shiftT(224);                  // 'return'
      break;
    case 228:                       // 'satisfies'
      shiftT(228);                  // 'satisfies'
      break;
    case 241:                       // 'stable'
      shiftT(241);                  // 'stable'
      break;
    case 242:                       // 'start'
      shiftT(242);                  // 'start'
      break;
    case 253:                       // 'to'
      shiftT(253);                  // 'to'
      break;
    case 254:                       // 'treat'
      shiftT(254);                  // 'treat'
      break;
    case 260:                       // 'union'
      shiftT(260);                  // 'union'
      break;
    case 272:                       // 'where'
      shiftT(272);                  // 'where'
      break;
    case 276:                       // 'with'
      shiftT(276);                  // 'with'
      break;
    case 74:                        // 'ancestor'
      shiftT(74);                   // 'ancestor'
      break;
    case 75:                        // 'ancestor-or-self'
      shiftT(75);                   // 'ancestor-or-self'
      break;
    case 83:                        // 'attribute'
      shiftT(83);                   // 'attribute'
      break;
    case 94:                        // 'child'
      shiftT(94);                   // 'child'
      break;
    case 97:                        // 'comment'
      shiftT(97);                   // 'comment'
      break;
    case 104:                       // 'copy'
      shiftT(104);                  // 'copy'
      break;
    case 109:                       // 'declare'
      shiftT(109);                  // 'declare'
      break;
    case 111:                       // 'delete'
      shiftT(111);                  // 'delete'
      break;
    case 112:                       // 'descendant'
      shiftT(112);                  // 'descendant'
      break;
    case 113:                       // 'descendant-or-self'
      shiftT(113);                  // 'descendant-or-self'
      break;
    case 120:                       // 'document'
      shiftT(120);                  // 'document'
      break;
    case 121:                       // 'document-node'
      shiftT(121);                  // 'document-node'
      break;
    case 122:                       // 'element'
      shiftT(122);                  // 'element'
      break;
    case 125:                       // 'empty-sequence'
      shiftT(125);                  // 'empty-sequence'
      break;
    case 130:                       // 'every'
      shiftT(130);                  // 'every'
      break;
    case 136:                       // 'first'
      shiftT(136);                  // 'first'
      break;
    case 137:                       // 'following'
      shiftT(137);                  // 'following'
      break;
    case 138:                       // 'following-sibling'
      shiftT(138);                  // 'following-sibling'
      break;
    case 147:                       // 'function'
      shiftT(147);                  // 'function'
      break;
    case 154:                       // 'if'
      shiftT(154);                  // 'if'
      break;
    case 155:                       // 'import'
      shiftT(155);                  // 'import'
      break;
    case 161:                       // 'insert'
      shiftT(161);                  // 'insert'
      break;
    case 167:                       // 'item'
      shiftT(167);                  // 'item'
      break;
    case 173:                       // 'last'
      shiftT(173);                  // 'last'
      break;
    case 185:                       // 'module'
      shiftT(185);                  // 'module'
      break;
    case 187:                       // 'namespace'
      shiftT(187);                  // 'namespace'
      break;
    case 188:                       // 'namespace-node'
      shiftT(188);                  // 'namespace-node'
      break;
    case 194:                       // 'node'
      shiftT(194);                  // 'node'
      break;
    case 206:                       // 'ordered'
      shiftT(206);                  // 'ordered'
      break;
    case 210:                       // 'parent'
      shiftT(210);                  // 'parent'
      break;
    case 216:                       // 'preceding'
      shiftT(216);                  // 'preceding'
      break;
    case 217:                       // 'preceding-sibling'
      shiftT(217);                  // 'preceding-sibling'
      break;
    case 220:                       // 'processing-instruction'
      shiftT(220);                  // 'processing-instruction'
      break;
    case 222:                       // 'rename'
      shiftT(222);                  // 'rename'
      break;
    case 223:                       // 'replace'
      shiftT(223);                  // 'replace'
      break;
    case 230:                       // 'schema-attribute'
      shiftT(230);                  // 'schema-attribute'
      break;
    case 231:                       // 'schema-element'
      shiftT(231);                  // 'schema-element'
      break;
    case 234:                       // 'self'
      shiftT(234);                  // 'self'
      break;
    case 240:                       // 'some'
      shiftT(240);                  // 'some'
      break;
    case 248:                       // 'switch'
      shiftT(248);                  // 'switch'
      break;
    case 249:                       // 'text'
      shiftT(249);                  // 'text'
      break;
    case 256:                       // 'try'
      shiftT(256);                  // 'try'
      break;
    case 259:                       // 'typeswitch'
      shiftT(259);                  // 'typeswitch'
      break;
    case 262:                       // 'unordered'
      shiftT(262);                  // 'unordered'
      break;
    case 266:                       // 'validate'
      shiftT(266);                  // 'validate'
      break;
    case 268:                       // 'variable'
      shiftT(268);                  // 'variable'
      break;
    case 170:                       // 'jsoniq'
      shiftT(170);                  // 'jsoniq'
      break;
    case 73:                        // 'allowing'
      shiftT(73);                   // 'allowing'
      break;
    case 82:                        // 'at'
      shiftT(82);                   // 'at'
      break;
    case 84:                        // 'base-uri'
      shiftT(84);                   // 'base-uri'
      break;
    case 86:                        // 'boundary-space'
      shiftT(86);                   // 'boundary-space'
      break;
    case 87:                        // 'break'
      shiftT(87);                   // 'break'
      break;
    case 92:                        // 'catch'
      shiftT(92);                   // 'catch'
      break;
    case 99:                        // 'construction'
      shiftT(99);                   // 'construction'
      break;
    case 102:                       // 'context'
      shiftT(102);                  // 'context'
      break;
    case 103:                       // 'continue'
      shiftT(103);                  // 'continue'
      break;
    case 105:                       // 'copy-namespaces'
      shiftT(105);                  // 'copy-namespaces'
      break;
    case 107:                       // 'decimal-format'
      shiftT(107);                  // 'decimal-format'
      break;
    case 126:                       // 'encoding'
      shiftT(126);                  // 'encoding'
      break;
    case 133:                       // 'exit'
      shiftT(133);                  // 'exit'
      break;
    case 134:                       // 'external'
      shiftT(134);                  // 'external'
      break;
    case 143:                       // 'ft-option'
      shiftT(143);                  // 'ft-option'
      break;
    case 156:                       // 'in'
      shiftT(156);                  // 'in'
      break;
    case 157:                       // 'index'
      shiftT(157);                  // 'index'
      break;
    case 163:                       // 'integrity'
      shiftT(163);                  // 'integrity'
      break;
    case 174:                       // 'lax'
      shiftT(174);                  // 'lax'
      break;
    case 195:                       // 'nodes'
      shiftT(195);                  // 'nodes'
      break;
    case 203:                       // 'option'
      shiftT(203);                  // 'option'
      break;
    case 207:                       // 'ordering'
      shiftT(207);                  // 'ordering'
      break;
    case 226:                       // 'revalidation'
      shiftT(226);                  // 'revalidation'
      break;
    case 229:                       // 'schema'
      shiftT(229);                  // 'schema'
      break;
    case 232:                       // 'score'
      shiftT(232);                  // 'score'
      break;
    case 239:                       // 'sliding'
      shiftT(239);                  // 'sliding'
      break;
    case 245:                       // 'strict'
      shiftT(245);                  // 'strict'
      break;
    case 257:                       // 'tumbling'
      shiftT(257);                  // 'tumbling'
      break;
    case 258:                       // 'type'
      shiftT(258);                  // 'type'
      break;
    case 263:                       // 'updating'
      shiftT(263);                  // 'updating'
      break;
    case 267:                       // 'value'
      shiftT(267);                  // 'value'
      break;
    case 269:                       // 'version'
      shiftT(269);                  // 'version'
      break;
    case 273:                       // 'while'
      shiftT(273);                  // 'while'
      break;
    case 98:                        // 'constraint'
      shiftT(98);                   // 'constraint'
      break;
    case 179:                       // 'loop'
      shiftT(179);                  // 'loop'
      break;
    case 225:                       // 'returning'
      shiftT(225);                  // 'returning'
      break;
    case 78:                        // 'append'
      shiftT(78);                   // 'append'
      break;
    case 135:                       // 'false'
      shiftT(135);                  // 'false'
      break;
    case 142:                       // 'from'
      shiftT(142);                  // 'from'
      break;
    case 197:                       // 'null'
      shiftT(197);                  // 'null'
      break;
    case 168:                       // 'json'
      shiftT(168);                  // 'json'
      break;
    case 198:                       // 'object'
      shiftT(198);                  // 'object'
      break;
    case 233:                       // 'select'
      shiftT(233);                  // 'select'
      break;
    default:
      shiftT(255);                  // 'true'
    }
  }

  function parse_MainModule()
  {
    eventHandler.startNonterminal("MainModule", e0);
    parse_Prolog();
    whitespace();
    parse_Program();
    eventHandler.endNonterminal("MainModule", e0);
  }

  function parse_Program()
  {
    eventHandler.startNonterminal("Program", e0);
    parse_StatementsAndOptionalExpr();
    eventHandler.endNonterminal("Program", e0);
  }

  function parse_Statements()
  {
    eventHandler.startNonterminal("Statements", e0);
    for (;;)
    {
      lookahead1W(284);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 35:                      // '('
        lookahead2W(270);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 36:                      // '(#'
        lookahead2(243);            // EQName^Token | S | 'after' | 'allowing' | 'ancestor' | 'ancestor-or-self' |
        break;
      case 47:                      // '/'
        lookahead2W(286);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 48:                      // '//'
        lookahead2W(260);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 55:                      // '<'
        lookahead2(4);              // QName
        break;
      case 56:                      // '<!--'
        lookahead2(1);              // DirCommentContents
        break;
      case 60:                      // '<?'
        lookahead2(3);              // PITarget
        break;
      case 69:                      // '['
        lookahead2W(273);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 78:                      // 'append'
        lookahead2W(269);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 133:                     // 'exit'
        lookahead2W(147);           // S^WS | '#' | '(' | '(:' | 'returning'
        break;
      case 139:                     // 'for'
        lookahead2W(179);           // S^WS | '#' | '$' | '(' | '(:' | 'sliding' | 'tumbling'
        break;
      case 161:                     // 'insert'
        lookahead2W(276);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 177:                     // 'let'
        lookahead2W(166);           // S^WS | '#' | '$' | '(' | '(:' | 'score'
        break;
      case 187:                     // 'namespace'
        lookahead2W(247);           // NCName^Token | S^WS | '#' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
        break;
      case 220:                     // 'processing-instruction'
        lookahead2W(245);           // NCName^Token | S^WS | '#' | '(:' | 'after' | 'allowing' | 'ancestor' |
        break;
      case 223:                     // 'replace'
        lookahead2W(170);           // S^WS | '#' | '(' | '(:' | 'node' | 'value'
        break;
      case 266:                     // 'validate'
        lookahead2W(188);           // S^WS | '#' | '(' | '(:' | 'lax' | 'strict' | 'type' | '{'
        break;
      case 281:                     // '{'
        lookahead2W(283);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 283:                     // '{|'
        lookahead2W(274);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 31:                      // '$'
      case 33:                      // '%'
        lookahead2W(246);           // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
        break;
      case 83:                      // 'attribute'
      case 122:                     // 'element'
        lookahead2W(253);           // EQName^Token | S^WS | '#' | '(:' | 'after' | 'allowing' | 'ancestor' |
        break;
      case 87:                      // 'break'
      case 103:                     // 'continue'
        lookahead2W(145);           // S^WS | '#' | '(' | '(:' | 'loop'
        break;
      case 97:                      // 'comment'
      case 249:                     // 'text'
        lookahead2W(97);            // S^WS | '#' | '(:' | '{'
        break;
      case 111:                     // 'delete'
      case 222:                     // 'rename'
        lookahead2W(261);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 41:                      // '+'
      case 43:                      // '-'
      case 196:                     // 'not'
        lookahead2W(266);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 135:                     // 'false'
      case 197:                     // 'null'
      case 255:                     // 'true'
        lookahead2W(211);           // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | '*' | '+' | ',' | '-' | '.' | '/' |
        break;
      case 104:                     // 'copy'
      case 130:                     // 'every'
      case 240:                     // 'some'
      case 268:                     // 'variable'
        lookahead2W(143);           // S^WS | '#' | '$' | '(' | '(:'
        break;
      case 120:                     // 'document'
      case 206:                     // 'ordered'
      case 256:                     // 'try'
      case 262:                     // 'unordered'
        lookahead2W(148);           // S^WS | '#' | '(' | '(:' | '{'
        break;
      case 8:                       // IntegerLiteral
      case 9:                       // DecimalLiteral
      case 10:                      // DoubleLiteral
      case 11:                      // StringLiteral
      case 32:                      // '$$'
        lookahead2W(210);           // S^WS | EOF | '!' | '!=' | '(' | '(:' | '*' | '+' | ',' | '-' | '.' | '/' | '//' |
        break;
      case 79:                      // 'array'
      case 121:                     // 'document-node'
      case 125:                     // 'empty-sequence'
      case 167:                     // 'item'
      case 169:                     // 'json-item'
      case 188:                     // 'namespace-node'
      case 194:                     // 'node'
      case 230:                     // 'schema-attribute'
      case 231:                     // 'schema-element'
      case 247:                     // 'structured-item'
        lookahead2W(20);            // S^WS | '#' | '(:'
        break;
      case 6:                       // EQName^Token
      case 71:                      // 'after'
      case 73:                      // 'allowing'
      case 74:                      // 'ancestor'
      case 75:                      // 'ancestor-or-self'
      case 76:                      // 'and'
      case 80:                      // 'as'
      case 81:                      // 'ascending'
      case 82:                      // 'at'
      case 84:                      // 'base-uri'
      case 85:                      // 'before'
      case 86:                      // 'boundary-space'
      case 89:                      // 'case'
      case 90:                      // 'cast'
      case 91:                      // 'castable'
      case 92:                      // 'catch'
      case 94:                      // 'child'
      case 95:                      // 'collation'
      case 98:                      // 'constraint'
      case 99:                      // 'construction'
      case 102:                     // 'context'
      case 105:                     // 'copy-namespaces'
      case 106:                     // 'count'
      case 107:                     // 'decimal-format'
      case 109:                     // 'declare'
      case 110:                     // 'default'
      case 112:                     // 'descendant'
      case 113:                     // 'descendant-or-self'
      case 114:                     // 'descending'
      case 119:                     // 'div'
      case 123:                     // 'else'
      case 124:                     // 'empty'
      case 126:                     // 'encoding'
      case 127:                     // 'end'
      case 129:                     // 'eq'
      case 132:                     // 'except'
      case 134:                     // 'external'
      case 136:                     // 'first'
      case 137:                     // 'following'
      case 138:                     // 'following-sibling'
      case 142:                     // 'from'
      case 143:                     // 'ft-option'
      case 147:                     // 'function'
      case 148:                     // 'ge'
      case 150:                     // 'group'
      case 152:                     // 'gt'
      case 153:                     // 'idiv'
      case 154:                     // 'if'
      case 155:                     // 'import'
      case 156:                     // 'in'
      case 157:                     // 'index'
      case 162:                     // 'instance'
      case 163:                     // 'integrity'
      case 164:                     // 'intersect'
      case 165:                     // 'into'
      case 166:                     // 'is'
      case 168:                     // 'json'
      case 170:                     // 'jsoniq'
      case 173:                     // 'last'
      case 174:                     // 'lax'
      case 175:                     // 'le'
      case 179:                     // 'loop'
      case 181:                     // 'lt'
      case 183:                     // 'mod'
      case 184:                     // 'modify'
      case 185:                     // 'module'
      case 189:                     // 'ne'
      case 195:                     // 'nodes'
      case 198:                     // 'object'
      case 202:                     // 'only'
      case 203:                     // 'option'
      case 204:                     // 'or'
      case 205:                     // 'order'
      case 207:                     // 'ordering'
      case 210:                     // 'parent'
      case 216:                     // 'preceding'
      case 217:                     // 'preceding-sibling'
      case 224:                     // 'return'
      case 225:                     // 'returning'
      case 226:                     // 'revalidation'
      case 228:                     // 'satisfies'
      case 229:                     // 'schema'
      case 232:                     // 'score'
      case 233:                     // 'select'
      case 234:                     // 'self'
      case 239:                     // 'sliding'
      case 241:                     // 'stable'
      case 242:                     // 'start'
      case 245:                     // 'strict'
      case 248:                     // 'switch'
      case 253:                     // 'to'
      case 254:                     // 'treat'
      case 257:                     // 'tumbling'
      case 258:                     // 'type'
      case 259:                     // 'typeswitch'
      case 260:                     // 'union'
      case 263:                     // 'updating'
      case 267:                     // 'value'
      case 269:                     // 'version'
      case 272:                     // 'where'
      case 273:                     // 'while'
      case 276:                     // 'with'
        lookahead2W(95);            // S^WS | '#' | '(' | '(:'
        break;
      default:
        lk = l1;
      }
      if (lk != 25                  // EOF
       && lk != 54                  // ';'
       && lk != 287                 // '}'
       && lk != 12808               // IntegerLiteral EOF
       && lk != 12809               // DecimalLiteral EOF
       && lk != 12810               // DoubleLiteral EOF
       && lk != 12811               // StringLiteral EOF
       && lk != 12832               // '$$' EOF
       && lk != 12847               // '/' EOF
       && lk != 12935               // 'false' EOF
       && lk != 12997               // 'null' EOF
       && lk != 13055               // 'true' EOF
       && lk != 16140               // 'variable' '$'
       && lk != 21512               // IntegerLiteral ','
       && lk != 21513               // DecimalLiteral ','
       && lk != 21514               // DoubleLiteral ','
       && lk != 21515               // StringLiteral ','
       && lk != 21536               // '$$' ','
       && lk != 21551               // '/' ','
       && lk != 21639               // 'false' ','
       && lk != 21701               // 'null' ','
       && lk != 21759               // 'true' ','
       && lk != 27656               // IntegerLiteral ';'
       && lk != 27657               // DecimalLiteral ';'
       && lk != 27658               // DoubleLiteral ';'
       && lk != 27659               // StringLiteral ';'
       && lk != 27680               // '$$' ';'
       && lk != 27695               // '/' ';'
       && lk != 27783               // 'false' ';'
       && lk != 27845               // 'null' ';'
       && lk != 27903               // 'true' ';'
       && lk != 91735               // 'break' 'loop'
       && lk != 91751               // 'continue' 'loop'
       && lk != 115333              // 'exit' 'returning'
       && lk != 146952              // IntegerLiteral '}'
       && lk != 146953              // DecimalLiteral '}'
       && lk != 146954              // DoubleLiteral '}'
       && lk != 146955              // StringLiteral '}'
       && lk != 146976              // '$$' '}'
       && lk != 146991              // '/' '}'
       && lk != 147079              // 'false' '}'
       && lk != 147141              // 'null' '}'
       && lk != 147199)             // 'true' '}'
      {
        lk = memoized(8, e0);
        if (lk == 0)
        {
          var b0A = b0; var e0A = e0; var l1A = l1;
          var b1A = b1; var e1A = e1; var l2A = l2;
          var b2A = b2; var e2A = e2;
          try
          {
            try_Statement();
            lk = -1;
          }
          catch (p1A)
          {
            lk = -2;
          }
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(8, e0, lk);
        }
      }
      if (lk != -1
       && lk != 54                  // ';'
       && lk != 16140               // 'variable' '$'
       && lk != 27656               // IntegerLiteral ';'
       && lk != 27657               // DecimalLiteral ';'
       && lk != 27658               // DoubleLiteral ';'
       && lk != 27659               // StringLiteral ';'
       && lk != 27680               // '$$' ';'
       && lk != 27695               // '/' ';'
       && lk != 27783               // 'false' ';'
       && lk != 27845               // 'null' ';'
       && lk != 27903               // 'true' ';'
       && lk != 91735               // 'break' 'loop'
       && lk != 91751               // 'continue' 'loop'
       && lk != 115333)             // 'exit' 'returning'
      {
        break;
      }
      whitespace();
      parse_Statement();
    }
    eventHandler.endNonterminal("Statements", e0);
  }

  function try_Statements()
  {
    for (;;)
    {
      lookahead1W(284);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 35:                      // '('
        lookahead2W(270);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 36:                      // '(#'
        lookahead2(243);            // EQName^Token | S | 'after' | 'allowing' | 'ancestor' | 'ancestor-or-self' |
        break;
      case 47:                      // '/'
        lookahead2W(286);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 48:                      // '//'
        lookahead2W(260);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 55:                      // '<'
        lookahead2(4);              // QName
        break;
      case 56:                      // '<!--'
        lookahead2(1);              // DirCommentContents
        break;
      case 60:                      // '<?'
        lookahead2(3);              // PITarget
        break;
      case 69:                      // '['
        lookahead2W(273);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 78:                      // 'append'
        lookahead2W(269);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 133:                     // 'exit'
        lookahead2W(147);           // S^WS | '#' | '(' | '(:' | 'returning'
        break;
      case 139:                     // 'for'
        lookahead2W(179);           // S^WS | '#' | '$' | '(' | '(:' | 'sliding' | 'tumbling'
        break;
      case 161:                     // 'insert'
        lookahead2W(276);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 177:                     // 'let'
        lookahead2W(166);           // S^WS | '#' | '$' | '(' | '(:' | 'score'
        break;
      case 187:                     // 'namespace'
        lookahead2W(247);           // NCName^Token | S^WS | '#' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
        break;
      case 220:                     // 'processing-instruction'
        lookahead2W(245);           // NCName^Token | S^WS | '#' | '(:' | 'after' | 'allowing' | 'ancestor' |
        break;
      case 223:                     // 'replace'
        lookahead2W(170);           // S^WS | '#' | '(' | '(:' | 'node' | 'value'
        break;
      case 266:                     // 'validate'
        lookahead2W(188);           // S^WS | '#' | '(' | '(:' | 'lax' | 'strict' | 'type' | '{'
        break;
      case 281:                     // '{'
        lookahead2W(283);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 283:                     // '{|'
        lookahead2W(274);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 31:                      // '$'
      case 33:                      // '%'
        lookahead2W(246);           // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
        break;
      case 83:                      // 'attribute'
      case 122:                     // 'element'
        lookahead2W(253);           // EQName^Token | S^WS | '#' | '(:' | 'after' | 'allowing' | 'ancestor' |
        break;
      case 87:                      // 'break'
      case 103:                     // 'continue'
        lookahead2W(145);           // S^WS | '#' | '(' | '(:' | 'loop'
        break;
      case 97:                      // 'comment'
      case 249:                     // 'text'
        lookahead2W(97);            // S^WS | '#' | '(:' | '{'
        break;
      case 111:                     // 'delete'
      case 222:                     // 'rename'
        lookahead2W(261);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 41:                      // '+'
      case 43:                      // '-'
      case 196:                     // 'not'
        lookahead2W(266);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      case 135:                     // 'false'
      case 197:                     // 'null'
      case 255:                     // 'true'
        lookahead2W(211);           // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | '*' | '+' | ',' | '-' | '.' | '/' |
        break;
      case 104:                     // 'copy'
      case 130:                     // 'every'
      case 240:                     // 'some'
      case 268:                     // 'variable'
        lookahead2W(143);           // S^WS | '#' | '$' | '(' | '(:'
        break;
      case 120:                     // 'document'
      case 206:                     // 'ordered'
      case 256:                     // 'try'
      case 262:                     // 'unordered'
        lookahead2W(148);           // S^WS | '#' | '(' | '(:' | '{'
        break;
      case 8:                       // IntegerLiteral
      case 9:                       // DecimalLiteral
      case 10:                      // DoubleLiteral
      case 11:                      // StringLiteral
      case 32:                      // '$$'
        lookahead2W(210);           // S^WS | EOF | '!' | '!=' | '(' | '(:' | '*' | '+' | ',' | '-' | '.' | '/' | '//' |
        break;
      case 79:                      // 'array'
      case 121:                     // 'document-node'
      case 125:                     // 'empty-sequence'
      case 167:                     // 'item'
      case 169:                     // 'json-item'
      case 188:                     // 'namespace-node'
      case 194:                     // 'node'
      case 230:                     // 'schema-attribute'
      case 231:                     // 'schema-element'
      case 247:                     // 'structured-item'
        lookahead2W(20);            // S^WS | '#' | '(:'
        break;
      case 6:                       // EQName^Token
      case 71:                      // 'after'
      case 73:                      // 'allowing'
      case 74:                      // 'ancestor'
      case 75:                      // 'ancestor-or-self'
      case 76:                      // 'and'
      case 80:                      // 'as'
      case 81:                      // 'ascending'
      case 82:                      // 'at'
      case 84:                      // 'base-uri'
      case 85:                      // 'before'
      case 86:                      // 'boundary-space'
      case 89:                      // 'case'
      case 90:                      // 'cast'
      case 91:                      // 'castable'
      case 92:                      // 'catch'
      case 94:                      // 'child'
      case 95:                      // 'collation'
      case 98:                      // 'constraint'
      case 99:                      // 'construction'
      case 102:                     // 'context'
      case 105:                     // 'copy-namespaces'
      case 106:                     // 'count'
      case 107:                     // 'decimal-format'
      case 109:                     // 'declare'
      case 110:                     // 'default'
      case 112:                     // 'descendant'
      case 113:                     // 'descendant-or-self'
      case 114:                     // 'descending'
      case 119:                     // 'div'
      case 123:                     // 'else'
      case 124:                     // 'empty'
      case 126:                     // 'encoding'
      case 127:                     // 'end'
      case 129:                     // 'eq'
      case 132:                     // 'except'
      case 134:                     // 'external'
      case 136:                     // 'first'
      case 137:                     // 'following'
      case 138:                     // 'following-sibling'
      case 142:                     // 'from'
      case 143:                     // 'ft-option'
      case 147:                     // 'function'
      case 148:                     // 'ge'
      case 150:                     // 'group'
      case 152:                     // 'gt'
      case 153:                     // 'idiv'
      case 154:                     // 'if'
      case 155:                     // 'import'
      case 156:                     // 'in'
      case 157:                     // 'index'
      case 162:                     // 'instance'
      case 163:                     // 'integrity'
      case 164:                     // 'intersect'
      case 165:                     // 'into'
      case 166:                     // 'is'
      case 168:                     // 'json'
      case 170:                     // 'jsoniq'
      case 173:                     // 'last'
      case 174:                     // 'lax'
      case 175:                     // 'le'
      case 179:                     // 'loop'
      case 181:                     // 'lt'
      case 183:                     // 'mod'
      case 184:                     // 'modify'
      case 185:                     // 'module'
      case 189:                     // 'ne'
      case 195:                     // 'nodes'
      case 198:                     // 'object'
      case 202:                     // 'only'
      case 203:                     // 'option'
      case 204:                     // 'or'
      case 205:                     // 'order'
      case 207:                     // 'ordering'
      case 210:                     // 'parent'
      case 216:                     // 'preceding'
      case 217:                     // 'preceding-sibling'
      case 224:                     // 'return'
      case 225:                     // 'returning'
      case 226:                     // 'revalidation'
      case 228:                     // 'satisfies'
      case 229:                     // 'schema'
      case 232:                     // 'score'
      case 233:                     // 'select'
      case 234:                     // 'self'
      case 239:                     // 'sliding'
      case 241:                     // 'stable'
      case 242:                     // 'start'
      case 245:                     // 'strict'
      case 248:                     // 'switch'
      case 253:                     // 'to'
      case 254:                     // 'treat'
      case 257:                     // 'tumbling'
      case 258:                     // 'type'
      case 259:                     // 'typeswitch'
      case 260:                     // 'union'
      case 263:                     // 'updating'
      case 267:                     // 'value'
      case 269:                     // 'version'
      case 272:                     // 'where'
      case 273:                     // 'while'
      case 276:                     // 'with'
        lookahead2W(95);            // S^WS | '#' | '(' | '(:'
        break;
      default:
        lk = l1;
      }
      if (lk != 25                  // EOF
       && lk != 54                  // ';'
       && lk != 287                 // '}'
       && lk != 12808               // IntegerLiteral EOF
       && lk != 12809               // DecimalLiteral EOF
       && lk != 12810               // DoubleLiteral EOF
       && lk != 12811               // StringLiteral EOF
       && lk != 12832               // '$$' EOF
       && lk != 12847               // '/' EOF
       && lk != 12935               // 'false' EOF
       && lk != 12997               // 'null' EOF
       && lk != 13055               // 'true' EOF
       && lk != 16140               // 'variable' '$'
       && lk != 21512               // IntegerLiteral ','
       && lk != 21513               // DecimalLiteral ','
       && lk != 21514               // DoubleLiteral ','
       && lk != 21515               // StringLiteral ','
       && lk != 21536               // '$$' ','
       && lk != 21551               // '/' ','
       && lk != 21639               // 'false' ','
       && lk != 21701               // 'null' ','
       && lk != 21759               // 'true' ','
       && lk != 27656               // IntegerLiteral ';'
       && lk != 27657               // DecimalLiteral ';'
       && lk != 27658               // DoubleLiteral ';'
       && lk != 27659               // StringLiteral ';'
       && lk != 27680               // '$$' ';'
       && lk != 27695               // '/' ';'
       && lk != 27783               // 'false' ';'
       && lk != 27845               // 'null' ';'
       && lk != 27903               // 'true' ';'
       && lk != 91735               // 'break' 'loop'
       && lk != 91751               // 'continue' 'loop'
       && lk != 115333              // 'exit' 'returning'
       && lk != 146952              // IntegerLiteral '}'
       && lk != 146953              // DecimalLiteral '}'
       && lk != 146954              // DoubleLiteral '}'
       && lk != 146955              // StringLiteral '}'
       && lk != 146976              // '$$' '}'
       && lk != 146991              // '/' '}'
       && lk != 147079              // 'false' '}'
       && lk != 147141              // 'null' '}'
       && lk != 147199)             // 'true' '}'
      {
        lk = memoized(8, e0);
        if (lk == 0)
        {
          var b0A = b0; var e0A = e0; var l1A = l1;
          var b1A = b1; var e1A = e1; var l2A = l2;
          var b2A = b2; var e2A = e2;
          try
          {
            try_Statement();
            memoize(8, e0A, -1);
            continue;
          }
          catch (p1A)
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            memoize(8, e0A, -2);
            break;
          }
        }
      }
      if (lk != -1
       && lk != 54                  // ';'
       && lk != 16140               // 'variable' '$'
       && lk != 27656               // IntegerLiteral ';'
       && lk != 27657               // DecimalLiteral ';'
       && lk != 27658               // DoubleLiteral ';'
       && lk != 27659               // StringLiteral ';'
       && lk != 27680               // '$$' ';'
       && lk != 27695               // '/' ';'
       && lk != 27783               // 'false' ';'
       && lk != 27845               // 'null' ';'
       && lk != 27903               // 'true' ';'
       && lk != 91735               // 'break' 'loop'
       && lk != 91751               // 'continue' 'loop'
       && lk != 115333)             // 'exit' 'returning'
      {
        break;
      }
      try_Statement();
    }
  }

  function parse_StatementsAndExpr()
  {
    eventHandler.startNonterminal("StatementsAndExpr", e0);
    parse_Statements();
    whitespace();
    parse_Expr();
    eventHandler.endNonterminal("StatementsAndExpr", e0);
  }

  function try_StatementsAndExpr()
  {
    try_Statements();
    try_Expr();
  }

  function parse_StatementsAndOptionalExpr()
  {
    eventHandler.startNonterminal("StatementsAndOptionalExpr", e0);
    parse_Statements();
    if (l1 != 25                    // EOF
     && l1 != 287)                  // '}'
    {
      whitespace();
      parse_Expr();
    }
    eventHandler.endNonterminal("StatementsAndOptionalExpr", e0);
  }

  function try_StatementsAndOptionalExpr()
  {
    try_Statements();
    if (l1 != 25                    // EOF
     && l1 != 287)                  // '}'
    {
      try_Expr();
    }
  }

  function parse_Statement()
  {
    eventHandler.startNonterminal("Statement", e0);
    switch (l1)
    {
    case 133:                       // 'exit'
      lookahead2W(147);             // S^WS | '#' | '(' | '(:' | 'returning'
      break;
    case 139:                       // 'for'
      lookahead2W(179);             // S^WS | '#' | '$' | '(' | '(:' | 'sliding' | 'tumbling'
      break;
    case 177:                       // 'let'
      lookahead2W(166);             // S^WS | '#' | '$' | '(' | '(:' | 'score'
      break;
    case 256:                       // 'try'
      lookahead2W(148);             // S^WS | '#' | '(' | '(:' | '{'
      break;
    case 268:                       // 'variable'
      lookahead2W(143);             // S^WS | '#' | '$' | '(' | '(:'
      break;
    case 281:                       // '{'
      lookahead2W(283);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 31:                        // '$'
    case 33:                        // '%'
      lookahead2W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      break;
    case 87:                        // 'break'
    case 103:                       // 'continue'
      lookahead2W(145);             // S^WS | '#' | '(' | '(:' | 'loop'
      break;
    case 154:                       // 'if'
    case 248:                       // 'switch'
    case 259:                       // 'typeswitch'
    case 273:                       // 'while'
      lookahead2W(95);              // S^WS | '#' | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    if (lk != 6                     // EQName^Token
     && lk != 8                     // IntegerLiteral
     && lk != 9                     // DecimalLiteral
     && lk != 10                    // DoubleLiteral
     && lk != 11                    // StringLiteral
     && lk != 32                    // '$$'
     && lk != 35                    // '('
     && lk != 36                    // '(#'
     && lk != 41                    // '+'
     && lk != 43                    // '-'
     && lk != 47                    // '/'
     && lk != 48                    // '//'
     && lk != 54                    // ';'
     && lk != 55                    // '<'
     && lk != 56                    // '<!--'
     && lk != 60                    // '<?'
     && lk != 69                    // '['
     && lk != 71                    // 'after'
     && lk != 73                    // 'allowing'
     && lk != 74                    // 'ancestor'
     && lk != 75                    // 'ancestor-or-self'
     && lk != 76                    // 'and'
     && lk != 78                    // 'append'
     && lk != 79                    // 'array'
     && lk != 80                    // 'as'
     && lk != 81                    // 'ascending'
     && lk != 82                    // 'at'
     && lk != 83                    // 'attribute'
     && lk != 84                    // 'base-uri'
     && lk != 85                    // 'before'
     && lk != 86                    // 'boundary-space'
     && lk != 89                    // 'case'
     && lk != 90                    // 'cast'
     && lk != 91                    // 'castable'
     && lk != 92                    // 'catch'
     && lk != 94                    // 'child'
     && lk != 95                    // 'collation'
     && lk != 97                    // 'comment'
     && lk != 98                    // 'constraint'
     && lk != 99                    // 'construction'
     && lk != 102                   // 'context'
     && lk != 104                   // 'copy'
     && lk != 105                   // 'copy-namespaces'
     && lk != 106                   // 'count'
     && lk != 107                   // 'decimal-format'
     && lk != 109                   // 'declare'
     && lk != 110                   // 'default'
     && lk != 111                   // 'delete'
     && lk != 112                   // 'descendant'
     && lk != 113                   // 'descendant-or-self'
     && lk != 114                   // 'descending'
     && lk != 119                   // 'div'
     && lk != 120                   // 'document'
     && lk != 121                   // 'document-node'
     && lk != 122                   // 'element'
     && lk != 123                   // 'else'
     && lk != 124                   // 'empty'
     && lk != 125                   // 'empty-sequence'
     && lk != 126                   // 'encoding'
     && lk != 127                   // 'end'
     && lk != 129                   // 'eq'
     && lk != 130                   // 'every'
     && lk != 132                   // 'except'
     && lk != 134                   // 'external'
     && lk != 135                   // 'false'
     && lk != 136                   // 'first'
     && lk != 137                   // 'following'
     && lk != 138                   // 'following-sibling'
     && lk != 142                   // 'from'
     && lk != 143                   // 'ft-option'
     && lk != 147                   // 'function'
     && lk != 148                   // 'ge'
     && lk != 150                   // 'group'
     && lk != 152                   // 'gt'
     && lk != 153                   // 'idiv'
     && lk != 155                   // 'import'
     && lk != 156                   // 'in'
     && lk != 157                   // 'index'
     && lk != 161                   // 'insert'
     && lk != 162                   // 'instance'
     && lk != 163                   // 'integrity'
     && lk != 164                   // 'intersect'
     && lk != 165                   // 'into'
     && lk != 166                   // 'is'
     && lk != 167                   // 'item'
     && lk != 168                   // 'json'
     && lk != 169                   // 'json-item'
     && lk != 170                   // 'jsoniq'
     && lk != 173                   // 'last'
     && lk != 174                   // 'lax'
     && lk != 175                   // 'le'
     && lk != 179                   // 'loop'
     && lk != 181                   // 'lt'
     && lk != 183                   // 'mod'
     && lk != 184                   // 'modify'
     && lk != 185                   // 'module'
     && lk != 187                   // 'namespace'
     && lk != 188                   // 'namespace-node'
     && lk != 189                   // 'ne'
     && lk != 194                   // 'node'
     && lk != 195                   // 'nodes'
     && lk != 196                   // 'not'
     && lk != 197                   // 'null'
     && lk != 198                   // 'object'
     && lk != 202                   // 'only'
     && lk != 203                   // 'option'
     && lk != 204                   // 'or'
     && lk != 205                   // 'order'
     && lk != 206                   // 'ordered'
     && lk != 207                   // 'ordering'
     && lk != 210                   // 'parent'
     && lk != 216                   // 'preceding'
     && lk != 217                   // 'preceding-sibling'
     && lk != 220                   // 'processing-instruction'
     && lk != 222                   // 'rename'
     && lk != 223                   // 'replace'
     && lk != 224                   // 'return'
     && lk != 225                   // 'returning'
     && lk != 226                   // 'revalidation'
     && lk != 228                   // 'satisfies'
     && lk != 229                   // 'schema'
     && lk != 230                   // 'schema-attribute'
     && lk != 231                   // 'schema-element'
     && lk != 232                   // 'score'
     && lk != 233                   // 'select'
     && lk != 234                   // 'self'
     && lk != 239                   // 'sliding'
     && lk != 240                   // 'some'
     && lk != 241                   // 'stable'
     && lk != 242                   // 'start'
     && lk != 245                   // 'strict'
     && lk != 247                   // 'structured-item'
     && lk != 249                   // 'text'
     && lk != 253                   // 'to'
     && lk != 254                   // 'treat'
     && lk != 255                   // 'true'
     && lk != 257                   // 'tumbling'
     && lk != 258                   // 'type'
     && lk != 260                   // 'union'
     && lk != 262                   // 'unordered'
     && lk != 263                   // 'updating'
     && lk != 266                   // 'validate'
     && lk != 267                   // 'value'
     && lk != 269                   // 'version'
     && lk != 272                   // 'where'
     && lk != 276                   // 'with'
     && lk != 283                   // '{|'
     && lk != 10009                 // '{' NCName^Token
     && lk != 14935                 // 'break' '#'
     && lk != 14951                 // 'continue' '#'
     && lk != 14981                 // 'exit' '#'
     && lk != 14987                 // 'for' '#'
     && lk != 15002                 // 'if' '#'
     && lk != 15025                 // 'let' '#'
     && lk != 15096                 // 'switch' '#'
     && lk != 15104                 // 'try' '#'
     && lk != 15107                 // 'typeswitch' '#'
     && lk != 15116                 // 'variable' '#'
     && lk != 15121                 // 'while' '#'
     && lk != 16011                 // 'for' '$'
     && lk != 16049                 // 'let' '$'
     && lk != 16140                 // 'variable' '$'
     && lk != 18007                 // 'break' '('
     && lk != 18023                 // 'continue' '('
     && lk != 18053                 // 'exit' '('
     && lk != 18059                 // 'for' '('
     && lk != 18074                 // 'if' '('
     && lk != 18097                 // 'let' '('
     && lk != 18168                 // 'switch' '('
     && lk != 18176                 // 'try' '('
     && lk != 18179                 // 'typeswitch' '('
     && lk != 18188                 // 'variable' '('
     && lk != 91735                 // 'break' 'loop'
     && lk != 91751                 // 'continue' 'loop'
     && lk != 115333                // 'exit' 'returning'
     && lk != 118961                // 'let' 'score'
     && lk != 122507                // 'for' 'sliding'
     && lk != 131723                // 'for' 'tumbling'
     && lk != 144128                // 'try' '{'
     && lk != 147225)               // '{' '}'
    {
      lk = memoized(9, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_ApplyStatement();
          lk = -1;
        }
        catch (p1A)
        {
          try
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            try_AssignStatement();
            lk = -2;
          }
          catch (p2A)
          {
            try
            {
              b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
              b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
              b2 = b2A; e2 = e2A; end = e2A; }}
              try_BlockStatement();
              lk = -3;
            }
            catch (p3A)
            {
              try
              {
                b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                b2 = b2A; e2 = e2A; end = e2A; }}
                try_VarDeclStatement();
                lk = -12;
              }
              catch (p12A)
              {
                lk = -13;
              }
            }
          }
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(9, e0, lk);
      }
    }
    switch (lk)
    {
    case -2:
      parse_AssignStatement();
      break;
    case -3:
      parse_BlockStatement();
      break;
    case 91735:                     // 'break' 'loop'
      parse_BreakStatement();
      break;
    case 91751:                     // 'continue' 'loop'
      parse_ContinueStatement();
      break;
    case 115333:                    // 'exit' 'returning'
      parse_ExitStatement();
      break;
    case 16011:                     // 'for' '$'
    case 16049:                     // 'let' '$'
    case 118961:                    // 'let' 'score'
    case 122507:                    // 'for' 'sliding'
    case 131723:                    // 'for' 'tumbling'
      parse_FLWORStatement();
      break;
    case 18074:                     // 'if' '('
      parse_IfStatement();
      break;
    case 18168:                     // 'switch' '('
      parse_SwitchStatement();
      break;
    case 144128:                    // 'try' '{'
      parse_TryCatchStatement();
      break;
    case 18179:                     // 'typeswitch' '('
      parse_TypeswitchStatement();
      break;
    case -12:
    case 16140:                     // 'variable' '$'
      parse_VarDeclStatement();
      break;
    case -13:
      parse_WhileStatement();
      break;
    case 54:                        // ';'
      parse_VoidStatement();
      break;
    default:
      parse_ApplyStatement();
    }
    eventHandler.endNonterminal("Statement", e0);
  }

  function try_Statement()
  {
    switch (l1)
    {
    case 133:                       // 'exit'
      lookahead2W(147);             // S^WS | '#' | '(' | '(:' | 'returning'
      break;
    case 139:                       // 'for'
      lookahead2W(179);             // S^WS | '#' | '$' | '(' | '(:' | 'sliding' | 'tumbling'
      break;
    case 177:                       // 'let'
      lookahead2W(166);             // S^WS | '#' | '$' | '(' | '(:' | 'score'
      break;
    case 256:                       // 'try'
      lookahead2W(148);             // S^WS | '#' | '(' | '(:' | '{'
      break;
    case 268:                       // 'variable'
      lookahead2W(143);             // S^WS | '#' | '$' | '(' | '(:'
      break;
    case 281:                       // '{'
      lookahead2W(283);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 31:                        // '$'
    case 33:                        // '%'
      lookahead2W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      break;
    case 87:                        // 'break'
    case 103:                       // 'continue'
      lookahead2W(145);             // S^WS | '#' | '(' | '(:' | 'loop'
      break;
    case 154:                       // 'if'
    case 248:                       // 'switch'
    case 259:                       // 'typeswitch'
    case 273:                       // 'while'
      lookahead2W(95);              // S^WS | '#' | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    if (lk != 6                     // EQName^Token
     && lk != 8                     // IntegerLiteral
     && lk != 9                     // DecimalLiteral
     && lk != 10                    // DoubleLiteral
     && lk != 11                    // StringLiteral
     && lk != 32                    // '$$'
     && lk != 35                    // '('
     && lk != 36                    // '(#'
     && lk != 41                    // '+'
     && lk != 43                    // '-'
     && lk != 47                    // '/'
     && lk != 48                    // '//'
     && lk != 54                    // ';'
     && lk != 55                    // '<'
     && lk != 56                    // '<!--'
     && lk != 60                    // '<?'
     && lk != 69                    // '['
     && lk != 71                    // 'after'
     && lk != 73                    // 'allowing'
     && lk != 74                    // 'ancestor'
     && lk != 75                    // 'ancestor-or-self'
     && lk != 76                    // 'and'
     && lk != 78                    // 'append'
     && lk != 79                    // 'array'
     && lk != 80                    // 'as'
     && lk != 81                    // 'ascending'
     && lk != 82                    // 'at'
     && lk != 83                    // 'attribute'
     && lk != 84                    // 'base-uri'
     && lk != 85                    // 'before'
     && lk != 86                    // 'boundary-space'
     && lk != 89                    // 'case'
     && lk != 90                    // 'cast'
     && lk != 91                    // 'castable'
     && lk != 92                    // 'catch'
     && lk != 94                    // 'child'
     && lk != 95                    // 'collation'
     && lk != 97                    // 'comment'
     && lk != 98                    // 'constraint'
     && lk != 99                    // 'construction'
     && lk != 102                   // 'context'
     && lk != 104                   // 'copy'
     && lk != 105                   // 'copy-namespaces'
     && lk != 106                   // 'count'
     && lk != 107                   // 'decimal-format'
     && lk != 109                   // 'declare'
     && lk != 110                   // 'default'
     && lk != 111                   // 'delete'
     && lk != 112                   // 'descendant'
     && lk != 113                   // 'descendant-or-self'
     && lk != 114                   // 'descending'
     && lk != 119                   // 'div'
     && lk != 120                   // 'document'
     && lk != 121                   // 'document-node'
     && lk != 122                   // 'element'
     && lk != 123                   // 'else'
     && lk != 124                   // 'empty'
     && lk != 125                   // 'empty-sequence'
     && lk != 126                   // 'encoding'
     && lk != 127                   // 'end'
     && lk != 129                   // 'eq'
     && lk != 130                   // 'every'
     && lk != 132                   // 'except'
     && lk != 134                   // 'external'
     && lk != 135                   // 'false'
     && lk != 136                   // 'first'
     && lk != 137                   // 'following'
     && lk != 138                   // 'following-sibling'
     && lk != 142                   // 'from'
     && lk != 143                   // 'ft-option'
     && lk != 147                   // 'function'
     && lk != 148                   // 'ge'
     && lk != 150                   // 'group'
     && lk != 152                   // 'gt'
     && lk != 153                   // 'idiv'
     && lk != 155                   // 'import'
     && lk != 156                   // 'in'
     && lk != 157                   // 'index'
     && lk != 161                   // 'insert'
     && lk != 162                   // 'instance'
     && lk != 163                   // 'integrity'
     && lk != 164                   // 'intersect'
     && lk != 165                   // 'into'
     && lk != 166                   // 'is'
     && lk != 167                   // 'item'
     && lk != 168                   // 'json'
     && lk != 169                   // 'json-item'
     && lk != 170                   // 'jsoniq'
     && lk != 173                   // 'last'
     && lk != 174                   // 'lax'
     && lk != 175                   // 'le'
     && lk != 179                   // 'loop'
     && lk != 181                   // 'lt'
     && lk != 183                   // 'mod'
     && lk != 184                   // 'modify'
     && lk != 185                   // 'module'
     && lk != 187                   // 'namespace'
     && lk != 188                   // 'namespace-node'
     && lk != 189                   // 'ne'
     && lk != 194                   // 'node'
     && lk != 195                   // 'nodes'
     && lk != 196                   // 'not'
     && lk != 197                   // 'null'
     && lk != 198                   // 'object'
     && lk != 202                   // 'only'
     && lk != 203                   // 'option'
     && lk != 204                   // 'or'
     && lk != 205                   // 'order'
     && lk != 206                   // 'ordered'
     && lk != 207                   // 'ordering'
     && lk != 210                   // 'parent'
     && lk != 216                   // 'preceding'
     && lk != 217                   // 'preceding-sibling'
     && lk != 220                   // 'processing-instruction'
     && lk != 222                   // 'rename'
     && lk != 223                   // 'replace'
     && lk != 224                   // 'return'
     && lk != 225                   // 'returning'
     && lk != 226                   // 'revalidation'
     && lk != 228                   // 'satisfies'
     && lk != 229                   // 'schema'
     && lk != 230                   // 'schema-attribute'
     && lk != 231                   // 'schema-element'
     && lk != 232                   // 'score'
     && lk != 233                   // 'select'
     && lk != 234                   // 'self'
     && lk != 239                   // 'sliding'
     && lk != 240                   // 'some'
     && lk != 241                   // 'stable'
     && lk != 242                   // 'start'
     && lk != 245                   // 'strict'
     && lk != 247                   // 'structured-item'
     && lk != 249                   // 'text'
     && lk != 253                   // 'to'
     && lk != 254                   // 'treat'
     && lk != 255                   // 'true'
     && lk != 257                   // 'tumbling'
     && lk != 258                   // 'type'
     && lk != 260                   // 'union'
     && lk != 262                   // 'unordered'
     && lk != 263                   // 'updating'
     && lk != 266                   // 'validate'
     && lk != 267                   // 'value'
     && lk != 269                   // 'version'
     && lk != 272                   // 'where'
     && lk != 276                   // 'with'
     && lk != 283                   // '{|'
     && lk != 10009                 // '{' NCName^Token
     && lk != 14935                 // 'break' '#'
     && lk != 14951                 // 'continue' '#'
     && lk != 14981                 // 'exit' '#'
     && lk != 14987                 // 'for' '#'
     && lk != 15002                 // 'if' '#'
     && lk != 15025                 // 'let' '#'
     && lk != 15096                 // 'switch' '#'
     && lk != 15104                 // 'try' '#'
     && lk != 15107                 // 'typeswitch' '#'
     && lk != 15116                 // 'variable' '#'
     && lk != 15121                 // 'while' '#'
     && lk != 16011                 // 'for' '$'
     && lk != 16049                 // 'let' '$'
     && lk != 16140                 // 'variable' '$'
     && lk != 18007                 // 'break' '('
     && lk != 18023                 // 'continue' '('
     && lk != 18053                 // 'exit' '('
     && lk != 18059                 // 'for' '('
     && lk != 18074                 // 'if' '('
     && lk != 18097                 // 'let' '('
     && lk != 18168                 // 'switch' '('
     && lk != 18176                 // 'try' '('
     && lk != 18179                 // 'typeswitch' '('
     && lk != 18188                 // 'variable' '('
     && lk != 91735                 // 'break' 'loop'
     && lk != 91751                 // 'continue' 'loop'
     && lk != 115333                // 'exit' 'returning'
     && lk != 118961                // 'let' 'score'
     && lk != 122507                // 'for' 'sliding'
     && lk != 131723                // 'for' 'tumbling'
     && lk != 144128                // 'try' '{'
     && lk != 147225)               // '{' '}'
    {
      lk = memoized(9, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_ApplyStatement();
          memoize(9, e0A, -1);
          lk = -15;
        }
        catch (p1A)
        {
          try
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            try_AssignStatement();
            memoize(9, e0A, -2);
            lk = -15;
          }
          catch (p2A)
          {
            try
            {
              b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
              b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
              b2 = b2A; e2 = e2A; end = e2A; }}
              try_BlockStatement();
              memoize(9, e0A, -3);
              lk = -15;
            }
            catch (p3A)
            {
              try
              {
                b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                b2 = b2A; e2 = e2A; end = e2A; }}
                try_VarDeclStatement();
                memoize(9, e0A, -12);
                lk = -15;
              }
              catch (p12A)
              {
                lk = -13;
                b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                b2 = b2A; e2 = e2A; end = e2A; }}
                memoize(9, e0A, -13);
              }
            }
          }
        }
      }
    }
    switch (lk)
    {
    case -2:
      try_AssignStatement();
      break;
    case -3:
      try_BlockStatement();
      break;
    case 91735:                     // 'break' 'loop'
      try_BreakStatement();
      break;
    case 91751:                     // 'continue' 'loop'
      try_ContinueStatement();
      break;
    case 115333:                    // 'exit' 'returning'
      try_ExitStatement();
      break;
    case 16011:                     // 'for' '$'
    case 16049:                     // 'let' '$'
    case 118961:                    // 'let' 'score'
    case 122507:                    // 'for' 'sliding'
    case 131723:                    // 'for' 'tumbling'
      try_FLWORStatement();
      break;
    case 18074:                     // 'if' '('
      try_IfStatement();
      break;
    case 18168:                     // 'switch' '('
      try_SwitchStatement();
      break;
    case 144128:                    // 'try' '{'
      try_TryCatchStatement();
      break;
    case 18179:                     // 'typeswitch' '('
      try_TypeswitchStatement();
      break;
    case -12:
    case 16140:                     // 'variable' '$'
      try_VarDeclStatement();
      break;
    case -13:
      try_WhileStatement();
      break;
    case 54:                        // ';'
      try_VoidStatement();
      break;
    case -15:
      break;
    default:
      try_ApplyStatement();
    }
  }

  function parse_ApplyStatement()
  {
    eventHandler.startNonterminal("ApplyStatement", e0);
    parse_ExprSimple();
    shift(54);                      // ';'
    eventHandler.endNonterminal("ApplyStatement", e0);
  }

  function try_ApplyStatement()
  {
    try_ExprSimple();
    shiftT(54);                     // ';'
  }

  function parse_AssignStatement()
  {
    eventHandler.startNonterminal("AssignStatement", e0);
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    lookahead1W(28);                // S^WS | '(:' | ':='
    shift(53);                      // ':='
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    shift(54);                      // ';'
    eventHandler.endNonterminal("AssignStatement", e0);
  }

  function try_AssignStatement()
  {
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
    lookahead1W(28);                // S^WS | '(:' | ':='
    shiftT(53);                     // ':='
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
    shiftT(54);                     // ';'
  }

  function parse_BlockStatement()
  {
    eventHandler.startNonterminal("BlockStatement", e0);
    shift(281);                     // '{'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    lookahead1W(281);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statements();
    shift(287);                     // '}'
    eventHandler.endNonterminal("BlockStatement", e0);
  }

  function try_BlockStatement()
  {
    shiftT(281);                    // '{'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
    lookahead1W(281);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statements();
    shiftT(287);                    // '}'
  }

  function parse_BreakStatement()
  {
    eventHandler.startNonterminal("BreakStatement", e0);
    shift(87);                      // 'break'
    lookahead1W(62);                // S^WS | '(:' | 'loop'
    shift(179);                     // 'loop'
    lookahead1W(29);                // S^WS | '(:' | ';'
    shift(54);                      // ';'
    eventHandler.endNonterminal("BreakStatement", e0);
  }

  function try_BreakStatement()
  {
    shiftT(87);                     // 'break'
    lookahead1W(62);                // S^WS | '(:' | 'loop'
    shiftT(179);                    // 'loop'
    lookahead1W(29);                // S^WS | '(:' | ';'
    shiftT(54);                     // ';'
  }

  function parse_ContinueStatement()
  {
    eventHandler.startNonterminal("ContinueStatement", e0);
    shift(103);                     // 'continue'
    lookahead1W(62);                // S^WS | '(:' | 'loop'
    shift(179);                     // 'loop'
    lookahead1W(29);                // S^WS | '(:' | ';'
    shift(54);                      // ';'
    eventHandler.endNonterminal("ContinueStatement", e0);
  }

  function try_ContinueStatement()
  {
    shiftT(103);                    // 'continue'
    lookahead1W(62);                // S^WS | '(:' | 'loop'
    shiftT(179);                    // 'loop'
    lookahead1W(29);                // S^WS | '(:' | ';'
    shiftT(54);                     // ';'
  }

  function parse_ExitStatement()
  {
    eventHandler.startNonterminal("ExitStatement", e0);
    shift(133);                     // 'exit'
    lookahead1W(74);                // S^WS | '(:' | 'returning'
    shift(225);                     // 'returning'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    shift(54);                      // ';'
    eventHandler.endNonterminal("ExitStatement", e0);
  }

  function try_ExitStatement()
  {
    shiftT(133);                    // 'exit'
    lookahead1W(74);                // S^WS | '(:' | 'returning'
    shiftT(225);                    // 'returning'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
    shiftT(54);                     // ';'
  }

  function parse_FLWORStatement()
  {
    eventHandler.startNonterminal("FLWORStatement", e0);
    parse_InitialClause();
    for (;;)
    {
      lookahead1W(195);             // S^WS | '(:' | 'count' | 'for' | 'group' | 'let' | 'order' | 'return' | 'stable' |
      if (l1 == 224)                // 'return'
      {
        break;
      }
      whitespace();
      parse_IntermediateClause();
    }
    whitespace();
    parse_ReturnStatement();
    eventHandler.endNonterminal("FLWORStatement", e0);
  }

  function try_FLWORStatement()
  {
    try_InitialClause();
    for (;;)
    {
      lookahead1W(195);             // S^WS | '(:' | 'count' | 'for' | 'group' | 'let' | 'order' | 'return' | 'stable' |
      if (l1 == 224)                // 'return'
      {
        break;
      }
      try_IntermediateClause();
    }
    try_ReturnStatement();
  }

  function parse_ReturnStatement()
  {
    eventHandler.startNonterminal("ReturnStatement", e0);
    shift(224);                     // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    eventHandler.endNonterminal("ReturnStatement", e0);
  }

  function try_ReturnStatement()
  {
    shiftT(224);                    // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
  }

  function parse_IfStatement()
  {
    eventHandler.startNonterminal("IfStatement", e0);
    shift(154);                     // 'if'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(38);                      // ')'
    lookahead1W(80);                // S^WS | '(:' | 'then'
    shift(250);                     // 'then'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    lookahead1W(51);                // S^WS | '(:' | 'else'
    shift(123);                     // 'else'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    eventHandler.endNonterminal("IfStatement", e0);
  }

  function try_IfStatement()
  {
    shiftT(154);                    // 'if'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(38);                     // ')'
    lookahead1W(80);                // S^WS | '(:' | 'then'
    shiftT(250);                    // 'then'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
    lookahead1W(51);                // S^WS | '(:' | 'else'
    shiftT(123);                    // 'else'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
  }

  function parse_SwitchStatement()
  {
    eventHandler.startNonterminal("SwitchStatement", e0);
    shift(248);                     // 'switch'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(38);                      // ')'
    for (;;)
    {
      lookahead1W(38);              // S^WS | '(:' | 'case'
      whitespace();
      parse_SwitchCaseStatement();
      lookahead1W(117);             // S^WS | '(:' | 'case' | 'default'
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shift(110);                     // 'default'
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shift(224);                     // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    eventHandler.endNonterminal("SwitchStatement", e0);
  }

  function try_SwitchStatement()
  {
    shiftT(248);                    // 'switch'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(38);                     // ')'
    for (;;)
    {
      lookahead1W(38);              // S^WS | '(:' | 'case'
      try_SwitchCaseStatement();
      lookahead1W(117);             // S^WS | '(:' | 'case' | 'default'
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shiftT(110);                    // 'default'
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shiftT(224);                    // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
  }

  function parse_SwitchCaseStatement()
  {
    eventHandler.startNonterminal("SwitchCaseStatement", e0);
    for (;;)
    {
      shift(89);                    // 'case'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_SwitchCaseOperand();
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shift(224);                     // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    eventHandler.endNonterminal("SwitchCaseStatement", e0);
  }

  function try_SwitchCaseStatement()
  {
    for (;;)
    {
      shiftT(89);                   // 'case'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_SwitchCaseOperand();
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shiftT(224);                    // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
  }

  function parse_TryCatchStatement()
  {
    eventHandler.startNonterminal("TryCatchStatement", e0);
    shift(256);                     // 'try'
    lookahead1W(90);                // S^WS | '(:' | '{'
    whitespace();
    parse_BlockStatement();
    for (;;)
    {
      lookahead1W(39);              // S^WS | '(:' | 'catch'
      shift(92);                    // 'catch'
      lookahead1W(249);             // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_CatchErrorList();
      whitespace();
      parse_BlockStatement();
      lookahead1W(284);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 92:                      // 'catch'
        lookahead2W(256);           // Wildcard | EQName^Token | S^WS | '#' | '(' | '(:' | 'after' | 'allowing' |
        break;
      default:
        lk = l1;
      }
      if (lk != 2652                // 'catch' Wildcard
       && lk != 3164                // 'catch' EQName^Token
       && lk != 36444               // 'catch' 'after'
       && lk != 37468               // 'catch' 'allowing'
       && lk != 37980               // 'catch' 'ancestor'
       && lk != 38492               // 'catch' 'ancestor-or-self'
       && lk != 39004               // 'catch' 'and'
       && lk != 40028               // 'catch' 'append'
       && lk != 40540               // 'catch' 'array'
       && lk != 41052               // 'catch' 'as'
       && lk != 41564               // 'catch' 'ascending'
       && lk != 42076               // 'catch' 'at'
       && lk != 42588               // 'catch' 'attribute'
       && lk != 43100               // 'catch' 'base-uri'
       && lk != 43612               // 'catch' 'before'
       && lk != 44124               // 'catch' 'boundary-space'
       && lk != 44636               // 'catch' 'break'
       && lk != 45660               // 'catch' 'case'
       && lk != 46172               // 'catch' 'cast'
       && lk != 46684               // 'catch' 'castable'
       && lk != 47196               // 'catch' 'catch'
       && lk != 48220               // 'catch' 'child'
       && lk != 48732               // 'catch' 'collation'
       && lk != 49756               // 'catch' 'comment'
       && lk != 50268               // 'catch' 'constraint'
       && lk != 50780               // 'catch' 'construction'
       && lk != 52316               // 'catch' 'context'
       && lk != 52828               // 'catch' 'continue'
       && lk != 53340               // 'catch' 'copy'
       && lk != 53852               // 'catch' 'copy-namespaces'
       && lk != 54364               // 'catch' 'count'
       && lk != 54876               // 'catch' 'decimal-format'
       && lk != 55900               // 'catch' 'declare'
       && lk != 56412               // 'catch' 'default'
       && lk != 56924               // 'catch' 'delete'
       && lk != 57436               // 'catch' 'descendant'
       && lk != 57948               // 'catch' 'descendant-or-self'
       && lk != 58460               // 'catch' 'descending'
       && lk != 61020               // 'catch' 'div'
       && lk != 61532               // 'catch' 'document'
       && lk != 62044               // 'catch' 'document-node'
       && lk != 62556               // 'catch' 'element'
       && lk != 63068               // 'catch' 'else'
       && lk != 63580               // 'catch' 'empty'
       && lk != 64092               // 'catch' 'empty-sequence'
       && lk != 64604               // 'catch' 'encoding'
       && lk != 65116               // 'catch' 'end'
       && lk != 66140               // 'catch' 'eq'
       && lk != 66652               // 'catch' 'every'
       && lk != 67676               // 'catch' 'except'
       && lk != 68188               // 'catch' 'exit'
       && lk != 68700               // 'catch' 'external'
       && lk != 69212               // 'catch' 'false'
       && lk != 69724               // 'catch' 'first'
       && lk != 70236               // 'catch' 'following'
       && lk != 70748               // 'catch' 'following-sibling'
       && lk != 71260               // 'catch' 'for'
       && lk != 72796               // 'catch' 'from'
       && lk != 73308               // 'catch' 'ft-option'
       && lk != 75356               // 'catch' 'function'
       && lk != 75868               // 'catch' 'ge'
       && lk != 76892               // 'catch' 'group'
       && lk != 77916               // 'catch' 'gt'
       && lk != 78428               // 'catch' 'idiv'
       && lk != 78940               // 'catch' 'if'
       && lk != 79452               // 'catch' 'import'
       && lk != 79964               // 'catch' 'in'
       && lk != 80476               // 'catch' 'index'
       && lk != 82524               // 'catch' 'insert'
       && lk != 83036               // 'catch' 'instance'
       && lk != 83548               // 'catch' 'integrity'
       && lk != 84060               // 'catch' 'intersect'
       && lk != 84572               // 'catch' 'into'
       && lk != 85084               // 'catch' 'is'
       && lk != 85596               // 'catch' 'item'
       && lk != 86108               // 'catch' 'json'
       && lk != 86620               // 'catch' 'json-item'
       && lk != 87132               // 'catch' 'jsoniq'
       && lk != 88668               // 'catch' 'last'
       && lk != 89180               // 'catch' 'lax'
       && lk != 89692               // 'catch' 'le'
       && lk != 90716               // 'catch' 'let'
       && lk != 91740               // 'catch' 'loop'
       && lk != 92764               // 'catch' 'lt'
       && lk != 93788               // 'catch' 'mod'
       && lk != 94300               // 'catch' 'modify'
       && lk != 94812               // 'catch' 'module'
       && lk != 95836               // 'catch' 'namespace'
       && lk != 96348               // 'catch' 'namespace-node'
       && lk != 96860               // 'catch' 'ne'
       && lk != 99420               // 'catch' 'node'
       && lk != 99932               // 'catch' 'nodes'
       && lk != 100956              // 'catch' 'null'
       && lk != 101468              // 'catch' 'object'
       && lk != 103516              // 'catch' 'only'
       && lk != 104028              // 'catch' 'option'
       && lk != 104540              // 'catch' 'or'
       && lk != 105052              // 'catch' 'order'
       && lk != 105564              // 'catch' 'ordered'
       && lk != 106076              // 'catch' 'ordering'
       && lk != 107612              // 'catch' 'parent'
       && lk != 110684              // 'catch' 'preceding'
       && lk != 111196              // 'catch' 'preceding-sibling'
       && lk != 112732              // 'catch' 'processing-instruction'
       && lk != 113756              // 'catch' 'rename'
       && lk != 114268              // 'catch' 'replace'
       && lk != 114780              // 'catch' 'return'
       && lk != 115292              // 'catch' 'returning'
       && lk != 115804              // 'catch' 'revalidation'
       && lk != 116828              // 'catch' 'satisfies'
       && lk != 117340              // 'catch' 'schema'
       && lk != 117852              // 'catch' 'schema-attribute'
       && lk != 118364              // 'catch' 'schema-element'
       && lk != 118876              // 'catch' 'score'
       && lk != 119388              // 'catch' 'select'
       && lk != 119900              // 'catch' 'self'
       && lk != 122460              // 'catch' 'sliding'
       && lk != 122972              // 'catch' 'some'
       && lk != 123484              // 'catch' 'stable'
       && lk != 123996              // 'catch' 'start'
       && lk != 125532              // 'catch' 'strict'
       && lk != 126556              // 'catch' 'structured-item'
       && lk != 127068              // 'catch' 'switch'
       && lk != 127580              // 'catch' 'text'
       && lk != 129628              // 'catch' 'to'
       && lk != 130140              // 'catch' 'treat'
       && lk != 130652              // 'catch' 'true'
       && lk != 131164              // 'catch' 'try'
       && lk != 131676              // 'catch' 'tumbling'
       && lk != 132188              // 'catch' 'type'
       && lk != 132700              // 'catch' 'typeswitch'
       && lk != 133212              // 'catch' 'union'
       && lk != 134236              // 'catch' 'unordered'
       && lk != 134748              // 'catch' 'updating'
       && lk != 136284              // 'catch' 'validate'
       && lk != 136796              // 'catch' 'value'
       && lk != 137308              // 'catch' 'variable'
       && lk != 137820              // 'catch' 'version'
       && lk != 139356              // 'catch' 'where'
       && lk != 139868              // 'catch' 'while'
       && lk != 141404)             // 'catch' 'with'
      {
        break;
      }
    }
    eventHandler.endNonterminal("TryCatchStatement", e0);
  }

  function try_TryCatchStatement()
  {
    shiftT(256);                    // 'try'
    lookahead1W(90);                // S^WS | '(:' | '{'
    try_BlockStatement();
    for (;;)
    {
      lookahead1W(39);              // S^WS | '(:' | 'catch'
      shiftT(92);                   // 'catch'
      lookahead1W(249);             // Wildcard | EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_CatchErrorList();
      try_BlockStatement();
      lookahead1W(284);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 92:                      // 'catch'
        lookahead2W(256);           // Wildcard | EQName^Token | S^WS | '#' | '(' | '(:' | 'after' | 'allowing' |
        break;
      default:
        lk = l1;
      }
      if (lk != 2652                // 'catch' Wildcard
       && lk != 3164                // 'catch' EQName^Token
       && lk != 36444               // 'catch' 'after'
       && lk != 37468               // 'catch' 'allowing'
       && lk != 37980               // 'catch' 'ancestor'
       && lk != 38492               // 'catch' 'ancestor-or-self'
       && lk != 39004               // 'catch' 'and'
       && lk != 40028               // 'catch' 'append'
       && lk != 40540               // 'catch' 'array'
       && lk != 41052               // 'catch' 'as'
       && lk != 41564               // 'catch' 'ascending'
       && lk != 42076               // 'catch' 'at'
       && lk != 42588               // 'catch' 'attribute'
       && lk != 43100               // 'catch' 'base-uri'
       && lk != 43612               // 'catch' 'before'
       && lk != 44124               // 'catch' 'boundary-space'
       && lk != 44636               // 'catch' 'break'
       && lk != 45660               // 'catch' 'case'
       && lk != 46172               // 'catch' 'cast'
       && lk != 46684               // 'catch' 'castable'
       && lk != 47196               // 'catch' 'catch'
       && lk != 48220               // 'catch' 'child'
       && lk != 48732               // 'catch' 'collation'
       && lk != 49756               // 'catch' 'comment'
       && lk != 50268               // 'catch' 'constraint'
       && lk != 50780               // 'catch' 'construction'
       && lk != 52316               // 'catch' 'context'
       && lk != 52828               // 'catch' 'continue'
       && lk != 53340               // 'catch' 'copy'
       && lk != 53852               // 'catch' 'copy-namespaces'
       && lk != 54364               // 'catch' 'count'
       && lk != 54876               // 'catch' 'decimal-format'
       && lk != 55900               // 'catch' 'declare'
       && lk != 56412               // 'catch' 'default'
       && lk != 56924               // 'catch' 'delete'
       && lk != 57436               // 'catch' 'descendant'
       && lk != 57948               // 'catch' 'descendant-or-self'
       && lk != 58460               // 'catch' 'descending'
       && lk != 61020               // 'catch' 'div'
       && lk != 61532               // 'catch' 'document'
       && lk != 62044               // 'catch' 'document-node'
       && lk != 62556               // 'catch' 'element'
       && lk != 63068               // 'catch' 'else'
       && lk != 63580               // 'catch' 'empty'
       && lk != 64092               // 'catch' 'empty-sequence'
       && lk != 64604               // 'catch' 'encoding'
       && lk != 65116               // 'catch' 'end'
       && lk != 66140               // 'catch' 'eq'
       && lk != 66652               // 'catch' 'every'
       && lk != 67676               // 'catch' 'except'
       && lk != 68188               // 'catch' 'exit'
       && lk != 68700               // 'catch' 'external'
       && lk != 69212               // 'catch' 'false'
       && lk != 69724               // 'catch' 'first'
       && lk != 70236               // 'catch' 'following'
       && lk != 70748               // 'catch' 'following-sibling'
       && lk != 71260               // 'catch' 'for'
       && lk != 72796               // 'catch' 'from'
       && lk != 73308               // 'catch' 'ft-option'
       && lk != 75356               // 'catch' 'function'
       && lk != 75868               // 'catch' 'ge'
       && lk != 76892               // 'catch' 'group'
       && lk != 77916               // 'catch' 'gt'
       && lk != 78428               // 'catch' 'idiv'
       && lk != 78940               // 'catch' 'if'
       && lk != 79452               // 'catch' 'import'
       && lk != 79964               // 'catch' 'in'
       && lk != 80476               // 'catch' 'index'
       && lk != 82524               // 'catch' 'insert'
       && lk != 83036               // 'catch' 'instance'
       && lk != 83548               // 'catch' 'integrity'
       && lk != 84060               // 'catch' 'intersect'
       && lk != 84572               // 'catch' 'into'
       && lk != 85084               // 'catch' 'is'
       && lk != 85596               // 'catch' 'item'
       && lk != 86108               // 'catch' 'json'
       && lk != 86620               // 'catch' 'json-item'
       && lk != 87132               // 'catch' 'jsoniq'
       && lk != 88668               // 'catch' 'last'
       && lk != 89180               // 'catch' 'lax'
       && lk != 89692               // 'catch' 'le'
       && lk != 90716               // 'catch' 'let'
       && lk != 91740               // 'catch' 'loop'
       && lk != 92764               // 'catch' 'lt'
       && lk != 93788               // 'catch' 'mod'
       && lk != 94300               // 'catch' 'modify'
       && lk != 94812               // 'catch' 'module'
       && lk != 95836               // 'catch' 'namespace'
       && lk != 96348               // 'catch' 'namespace-node'
       && lk != 96860               // 'catch' 'ne'
       && lk != 99420               // 'catch' 'node'
       && lk != 99932               // 'catch' 'nodes'
       && lk != 100956              // 'catch' 'null'
       && lk != 101468              // 'catch' 'object'
       && lk != 103516              // 'catch' 'only'
       && lk != 104028              // 'catch' 'option'
       && lk != 104540              // 'catch' 'or'
       && lk != 105052              // 'catch' 'order'
       && lk != 105564              // 'catch' 'ordered'
       && lk != 106076              // 'catch' 'ordering'
       && lk != 107612              // 'catch' 'parent'
       && lk != 110684              // 'catch' 'preceding'
       && lk != 111196              // 'catch' 'preceding-sibling'
       && lk != 112732              // 'catch' 'processing-instruction'
       && lk != 113756              // 'catch' 'rename'
       && lk != 114268              // 'catch' 'replace'
       && lk != 114780              // 'catch' 'return'
       && lk != 115292              // 'catch' 'returning'
       && lk != 115804              // 'catch' 'revalidation'
       && lk != 116828              // 'catch' 'satisfies'
       && lk != 117340              // 'catch' 'schema'
       && lk != 117852              // 'catch' 'schema-attribute'
       && lk != 118364              // 'catch' 'schema-element'
       && lk != 118876              // 'catch' 'score'
       && lk != 119388              // 'catch' 'select'
       && lk != 119900              // 'catch' 'self'
       && lk != 122460              // 'catch' 'sliding'
       && lk != 122972              // 'catch' 'some'
       && lk != 123484              // 'catch' 'stable'
       && lk != 123996              // 'catch' 'start'
       && lk != 125532              // 'catch' 'strict'
       && lk != 126556              // 'catch' 'structured-item'
       && lk != 127068              // 'catch' 'switch'
       && lk != 127580              // 'catch' 'text'
       && lk != 129628              // 'catch' 'to'
       && lk != 130140              // 'catch' 'treat'
       && lk != 130652              // 'catch' 'true'
       && lk != 131164              // 'catch' 'try'
       && lk != 131676              // 'catch' 'tumbling'
       && lk != 132188              // 'catch' 'type'
       && lk != 132700              // 'catch' 'typeswitch'
       && lk != 133212              // 'catch' 'union'
       && lk != 134236              // 'catch' 'unordered'
       && lk != 134748              // 'catch' 'updating'
       && lk != 136284              // 'catch' 'validate'
       && lk != 136796              // 'catch' 'value'
       && lk != 137308              // 'catch' 'variable'
       && lk != 137820              // 'catch' 'version'
       && lk != 139356              // 'catch' 'where'
       && lk != 139868              // 'catch' 'while'
       && lk != 141404)             // 'catch' 'with'
      {
        break;
      }
    }
  }

  function parse_TypeswitchStatement()
  {
    eventHandler.startNonterminal("TypeswitchStatement", e0);
    shift(259);                     // 'typeswitch'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(38);                      // ')'
    for (;;)
    {
      lookahead1W(38);              // S^WS | '(:' | 'case'
      whitespace();
      parse_CaseStatement();
      lookahead1W(117);             // S^WS | '(:' | 'case' | 'default'
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shift(110);                     // 'default'
    lookahead1W(99);                // S^WS | '$' | '(:' | 'return'
    if (l1 == 31)                   // '$'
    {
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_VarName();
    }
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shift(224);                     // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    eventHandler.endNonterminal("TypeswitchStatement", e0);
  }

  function try_TypeswitchStatement()
  {
    shiftT(259);                    // 'typeswitch'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(38);                     // ')'
    for (;;)
    {
      lookahead1W(38);              // S^WS | '(:' | 'case'
      try_CaseStatement();
      lookahead1W(117);             // S^WS | '(:' | 'case' | 'default'
      if (l1 != 89)                 // 'case'
      {
        break;
      }
    }
    shiftT(110);                    // 'default'
    lookahead1W(99);                // S^WS | '$' | '(:' | 'return'
    if (l1 == 31)                   // '$'
    {
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_VarName();
    }
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shiftT(224);                    // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
  }

  function parse_CaseStatement()
  {
    eventHandler.startNonterminal("CaseStatement", e0);
    shift(89);                      // 'case'
    lookahead1W(258);               // EQName^Token | S^WS | '$' | '%' | '(' | '(:' | 'after' | 'allowing' |
    if (l1 == 31)                   // '$'
    {
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_VarName();
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shift(80);                    // 'as'
    }
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_SequenceType();
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shift(224);                     // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    eventHandler.endNonterminal("CaseStatement", e0);
  }

  function try_CaseStatement()
  {
    shiftT(89);                     // 'case'
    lookahead1W(258);               // EQName^Token | S^WS | '$' | '%' | '(' | '(:' | 'after' | 'allowing' |
    if (l1 == 31)                   // '$'
    {
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_VarName();
      lookahead1W(33);              // S^WS | '(:' | 'as'
      shiftT(80);                   // 'as'
    }
    lookahead1W(254);               // EQName^Token | S^WS | '%' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_SequenceType();
    lookahead1W(73);                // S^WS | '(:' | 'return'
    shiftT(224);                    // 'return'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
  }

  function parse_VarDeclStatement()
  {
    eventHandler.startNonterminal("VarDeclStatement", e0);
    for (;;)
    {
      lookahead1W(102);             // S^WS | '%' | '(:' | 'variable'
      if (l1 != 33)                 // '%'
      {
        break;
      }
      whitespace();
      parse_Annotation();
    }
    shift(268);                     // 'variable'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shift(31);                      // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    whitespace();
    parse_VarName();
    lookahead1W(172);               // S^WS | '(:' | ',' | ':=' | ';' | 'as'
    if (l1 == 80)                   // 'as'
    {
      whitespace();
      parse_TypeDeclaration();
    }
    lookahead1W(155);               // S^WS | '(:' | ',' | ':=' | ';'
    if (l1 == 53)                   // ':='
    {
      shift(53);                    // ':='
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_ExprSingle();
    }
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shift(42);                    // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      shift(31);                    // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      whitespace();
      parse_VarName();
      lookahead1W(172);             // S^WS | '(:' | ',' | ':=' | ';' | 'as'
      if (l1 == 80)                 // 'as'
      {
        whitespace();
        parse_TypeDeclaration();
      }
      lookahead1W(155);             // S^WS | '(:' | ',' | ':=' | ';'
      if (l1 == 53)                 // ':='
      {
        shift(53);                  // ':='
        lookahead1W(267);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        whitespace();
        parse_ExprSingle();
      }
    }
    shift(54);                      // ';'
    eventHandler.endNonterminal("VarDeclStatement", e0);
  }

  function try_VarDeclStatement()
  {
    for (;;)
    {
      lookahead1W(102);             // S^WS | '%' | '(:' | 'variable'
      if (l1 != 33)                 // '%'
      {
        break;
      }
      try_Annotation();
    }
    shiftT(268);                    // 'variable'
    lookahead1W(21);                // S^WS | '$' | '(:'
    shiftT(31);                     // '$'
    lookahead1W(246);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    try_VarName();
    lookahead1W(172);               // S^WS | '(:' | ',' | ':=' | ';' | 'as'
    if (l1 == 80)                   // 'as'
    {
      try_TypeDeclaration();
    }
    lookahead1W(155);               // S^WS | '(:' | ',' | ':=' | ';'
    if (l1 == 53)                   // ':='
    {
      shiftT(53);                   // ':='
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_ExprSingle();
    }
    for (;;)
    {
      if (l1 != 42)                 // ','
      {
        break;
      }
      shiftT(42);                   // ','
      lookahead1W(21);              // S^WS | '$' | '(:'
      shiftT(31);                   // '$'
      lookahead1W(246);             // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
      try_VarName();
      lookahead1W(172);             // S^WS | '(:' | ',' | ':=' | ';' | 'as'
      if (l1 == 80)                 // 'as'
      {
        try_TypeDeclaration();
      }
      lookahead1W(155);             // S^WS | '(:' | ',' | ':=' | ';'
      if (l1 == 53)                 // ':='
      {
        shiftT(53);                 // ':='
        lookahead1W(267);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        try_ExprSingle();
      }
    }
    shiftT(54);                     // ';'
  }

  function parse_WhileStatement()
  {
    eventHandler.startNonterminal("WhileStatement", e0);
    shift(273);                     // 'while'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shift(35);                      // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Expr();
    shift(38);                      // ')'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_Statement();
    eventHandler.endNonterminal("WhileStatement", e0);
  }

  function try_WhileStatement()
  {
    shiftT(273);                    // 'while'
    lookahead1W(22);                // S^WS | '(' | '(:'
    shiftT(35);                     // '('
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Expr();
    shiftT(38);                     // ')'
    lookahead1W(271);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_Statement();
  }

  function parse_VoidStatement()
  {
    eventHandler.startNonterminal("VoidStatement", e0);
    shift(54);                      // ';'
    eventHandler.endNonterminal("VoidStatement", e0);
  }

  function try_VoidStatement()
  {
    shiftT(54);                     // ';'
  }

  function parse_ExprSingle()
  {
    eventHandler.startNonterminal("ExprSingle", e0);
    switch (l1)
    {
    case 139:                       // 'for'
      lookahead2W(179);             // S^WS | '#' | '$' | '(' | '(:' | 'sliding' | 'tumbling'
      break;
    case 177:                       // 'let'
      lookahead2W(166);             // S^WS | '#' | '$' | '(' | '(:' | 'score'
      break;
    case 256:                       // 'try'
      lookahead2W(148);             // S^WS | '#' | '(' | '(:' | '{'
      break;
    case 154:                       // 'if'
    case 248:                       // 'switch'
    case 259:                       // 'typeswitch'
      lookahead2W(95);              // S^WS | '#' | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 16011:                     // 'for' '$'
    case 16049:                     // 'let' '$'
    case 118961:                    // 'let' 'score'
    case 122507:                    // 'for' 'sliding'
    case 131723:                    // 'for' 'tumbling'
      parse_FLWORExpr();
      break;
    case 18074:                     // 'if' '('
      parse_IfExpr();
      break;
    case 18168:                     // 'switch' '('
      parse_SwitchExpr();
      break;
    case 144128:                    // 'try' '{'
      parse_TryCatchExpr();
      break;
    case 18179:                     // 'typeswitch' '('
      parse_TypeswitchExpr();
      break;
    default:
      parse_ExprSimple();
    }
    eventHandler.endNonterminal("ExprSingle", e0);
  }

  function try_ExprSingle()
  {
    switch (l1)
    {
    case 139:                       // 'for'
      lookahead2W(179);             // S^WS | '#' | '$' | '(' | '(:' | 'sliding' | 'tumbling'
      break;
    case 177:                       // 'let'
      lookahead2W(166);             // S^WS | '#' | '$' | '(' | '(:' | 'score'
      break;
    case 256:                       // 'try'
      lookahead2W(148);             // S^WS | '#' | '(' | '(:' | '{'
      break;
    case 154:                       // 'if'
    case 248:                       // 'switch'
    case 259:                       // 'typeswitch'
      lookahead2W(95);              // S^WS | '#' | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    switch (lk)
    {
    case 16011:                     // 'for' '$'
    case 16049:                     // 'let' '$'
    case 118961:                    // 'let' 'score'
    case 122507:                    // 'for' 'sliding'
    case 131723:                    // 'for' 'tumbling'
      try_FLWORExpr();
      break;
    case 18074:                     // 'if' '('
      try_IfExpr();
      break;
    case 18168:                     // 'switch' '('
      try_SwitchExpr();
      break;
    case 144128:                    // 'try' '{'
      try_TryCatchExpr();
      break;
    case 18179:                     // 'typeswitch' '('
      try_TypeswitchExpr();
      break;
    default:
      try_ExprSimple();
    }
  }

  function parse_ExprSimple()
  {
    eventHandler.startNonterminal("ExprSimple", e0);
    switch (l1)
    {
    case 78:                        // 'append'
      lookahead2W(269);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 161:                       // 'insert'
      lookahead2W(276);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 223:                       // 'replace'
      lookahead2W(170);             // S^WS | '#' | '(' | '(:' | 'node' | 'value'
      break;
    case 111:                       // 'delete'
    case 222:                       // 'rename'
      lookahead2W(261);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 104:                       // 'copy'
    case 130:                       // 'every'
    case 240:                       // 'some'
      lookahead2W(143);             // S^WS | '#' | '$' | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    if (lk == 17998                 // 'append' '('
     || lk == 18031                 // 'delete' '('
     || lk == 18081                 // 'insert' '('
     || lk == 18142                 // 'rename' '('
     || lk == 99439                 // 'delete' 'node'
     || lk == 99489                 // 'insert' 'node'
     || lk == 99550                 // 'rename' 'node'
     || lk == 99951                 // 'delete' 'nodes'
     || lk == 100001                // 'insert' 'nodes'
     || lk == 136927)               // 'replace' 'value'
    {
      lk = memoized(10, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_OrExpr();
          lk = -2;
        }
        catch (p2A)
        {
          try
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            try_InsertExpr();
            lk = -3;
          }
          catch (p3A)
          {
            try
            {
              b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
              b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
              b2 = b2A; e2 = e2A; end = e2A; }}
              try_DeleteExpr();
              lk = -4;
            }
            catch (p4A)
            {
              try
              {
                b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                b2 = b2A; e2 = e2A; end = e2A; }}
                try_RenameExpr();
                lk = -5;
              }
              catch (p5A)
              {
                try
                {
                  b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                  b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                  b2 = b2A; e2 = e2A; end = e2A; }}
                  try_ReplaceExpr();
                  lk = -6;
                }
                catch (p6A)
                {
                  try
                  {
                    b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                    b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                    b2 = b2A; e2 = e2A; end = e2A; }}
                    try_JSONDeleteExpr();
                    lk = -8;
                  }
                  catch (p8A)
                  {
                    try
                    {
                      b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                      b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                      b2 = b2A; e2 = e2A; end = e2A; }}
                      try_JSONInsertExpr();
                      lk = -9;
                    }
                    catch (p9A)
                    {
                      try
                      {
                        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                        b2 = b2A; e2 = e2A; end = e2A; }}
                        try_JSONRenameExpr();
                        lk = -10;
                      }
                      catch (p10A)
                      {
                        try
                        {
                          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                          b2 = b2A; e2 = e2A; end = e2A; }}
                          try_JSONReplaceExpr();
                          lk = -11;
                        }
                        catch (p11A)
                        {
                          lk = -12;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(10, e0, lk);
      }
    }
    switch (lk)
    {
    case 16002:                     // 'every' '$'
    case 16112:                     // 'some' '$'
      parse_QuantifiedExpr();
      break;
    case -3:
      parse_InsertExpr();
      break;
    case -4:
      parse_DeleteExpr();
      break;
    case -5:
      parse_RenameExpr();
      break;
    case -6:
    case 99551:                     // 'replace' 'node'
      parse_ReplaceExpr();
      break;
    case 15976:                     // 'copy' '$'
      parse_TransformExpr();
      break;
    case -8:
    case 3183:                      // 'delete' EQName^Token
    case 4207:                      // 'delete' IntegerLiteral
    case 4719:                      // 'delete' DecimalLiteral
    case 5231:                      // 'delete' DoubleLiteral
    case 5743:                      // 'delete' StringLiteral
    case 15983:                     // 'delete' '$'
    case 16495:                     // 'delete' '$$'
    case 17007:                     // 'delete' '%'
    case 28271:                     // 'delete' '<'
    case 28783:                     // 'delete' '<!--'
    case 30831:                     // 'delete' '<?'
    case 35439:                     // 'delete' '['
    case 36463:                     // 'delete' 'after'
    case 37487:                     // 'delete' 'allowing'
    case 37999:                     // 'delete' 'ancestor'
    case 38511:                     // 'delete' 'ancestor-or-self'
    case 39023:                     // 'delete' 'and'
    case 40047:                     // 'delete' 'append'
    case 40559:                     // 'delete' 'array'
    case 41071:                     // 'delete' 'as'
    case 41583:                     // 'delete' 'ascending'
    case 42095:                     // 'delete' 'at'
    case 42607:                     // 'delete' 'attribute'
    case 43119:                     // 'delete' 'base-uri'
    case 43631:                     // 'delete' 'before'
    case 44143:                     // 'delete' 'boundary-space'
    case 44655:                     // 'delete' 'break'
    case 45679:                     // 'delete' 'case'
    case 46191:                     // 'delete' 'cast'
    case 46703:                     // 'delete' 'castable'
    case 47215:                     // 'delete' 'catch'
    case 48239:                     // 'delete' 'child'
    case 48751:                     // 'delete' 'collation'
    case 49775:                     // 'delete' 'comment'
    case 50287:                     // 'delete' 'constraint'
    case 50799:                     // 'delete' 'construction'
    case 52335:                     // 'delete' 'context'
    case 52847:                     // 'delete' 'continue'
    case 53359:                     // 'delete' 'copy'
    case 53871:                     // 'delete' 'copy-namespaces'
    case 54383:                     // 'delete' 'count'
    case 54895:                     // 'delete' 'decimal-format'
    case 55919:                     // 'delete' 'declare'
    case 56431:                     // 'delete' 'default'
    case 56943:                     // 'delete' 'delete'
    case 57455:                     // 'delete' 'descendant'
    case 57967:                     // 'delete' 'descendant-or-self'
    case 58479:                     // 'delete' 'descending'
    case 61039:                     // 'delete' 'div'
    case 61551:                     // 'delete' 'document'
    case 62063:                     // 'delete' 'document-node'
    case 62575:                     // 'delete' 'element'
    case 63087:                     // 'delete' 'else'
    case 63599:                     // 'delete' 'empty'
    case 64111:                     // 'delete' 'empty-sequence'
    case 64623:                     // 'delete' 'encoding'
    case 65135:                     // 'delete' 'end'
    case 66159:                     // 'delete' 'eq'
    case 66671:                     // 'delete' 'every'
    case 67695:                     // 'delete' 'except'
    case 68207:                     // 'delete' 'exit'
    case 68719:                     // 'delete' 'external'
    case 69231:                     // 'delete' 'false'
    case 69743:                     // 'delete' 'first'
    case 70255:                     // 'delete' 'following'
    case 70767:                     // 'delete' 'following-sibling'
    case 71279:                     // 'delete' 'for'
    case 72815:                     // 'delete' 'from'
    case 73327:                     // 'delete' 'ft-option'
    case 75375:                     // 'delete' 'function'
    case 75887:                     // 'delete' 'ge'
    case 76911:                     // 'delete' 'group'
    case 77935:                     // 'delete' 'gt'
    case 78447:                     // 'delete' 'idiv'
    case 78959:                     // 'delete' 'if'
    case 79471:                     // 'delete' 'import'
    case 79983:                     // 'delete' 'in'
    case 80495:                     // 'delete' 'index'
    case 82543:                     // 'delete' 'insert'
    case 83055:                     // 'delete' 'instance'
    case 83567:                     // 'delete' 'integrity'
    case 84079:                     // 'delete' 'intersect'
    case 84591:                     // 'delete' 'into'
    case 85103:                     // 'delete' 'is'
    case 85615:                     // 'delete' 'item'
    case 86127:                     // 'delete' 'json'
    case 86639:                     // 'delete' 'json-item'
    case 87151:                     // 'delete' 'jsoniq'
    case 88687:                     // 'delete' 'last'
    case 89199:                     // 'delete' 'lax'
    case 89711:                     // 'delete' 'le'
    case 90735:                     // 'delete' 'let'
    case 91759:                     // 'delete' 'loop'
    case 92783:                     // 'delete' 'lt'
    case 93807:                     // 'delete' 'mod'
    case 94319:                     // 'delete' 'modify'
    case 94831:                     // 'delete' 'module'
    case 95855:                     // 'delete' 'namespace'
    case 96367:                     // 'delete' 'namespace-node'
    case 96879:                     // 'delete' 'ne'
    case 100975:                    // 'delete' 'null'
    case 101487:                    // 'delete' 'object'
    case 103535:                    // 'delete' 'only'
    case 104047:                    // 'delete' 'option'
    case 104559:                    // 'delete' 'or'
    case 105071:                    // 'delete' 'order'
    case 105583:                    // 'delete' 'ordered'
    case 106095:                    // 'delete' 'ordering'
    case 107631:                    // 'delete' 'parent'
    case 110703:                    // 'delete' 'preceding'
    case 111215:                    // 'delete' 'preceding-sibling'
    case 112751:                    // 'delete' 'processing-instruction'
    case 113775:                    // 'delete' 'rename'
    case 114287:                    // 'delete' 'replace'
    case 114799:                    // 'delete' 'return'
    case 115311:                    // 'delete' 'returning'
    case 115823:                    // 'delete' 'revalidation'
    case 116847:                    // 'delete' 'satisfies'
    case 117359:                    // 'delete' 'schema'
    case 117871:                    // 'delete' 'schema-attribute'
    case 118383:                    // 'delete' 'schema-element'
    case 118895:                    // 'delete' 'score'
    case 119407:                    // 'delete' 'select'
    case 119919:                    // 'delete' 'self'
    case 122479:                    // 'delete' 'sliding'
    case 122991:                    // 'delete' 'some'
    case 123503:                    // 'delete' 'stable'
    case 124015:                    // 'delete' 'start'
    case 125551:                    // 'delete' 'strict'
    case 126575:                    // 'delete' 'structured-item'
    case 127087:                    // 'delete' 'switch'
    case 127599:                    // 'delete' 'text'
    case 129647:                    // 'delete' 'to'
    case 130159:                    // 'delete' 'treat'
    case 130671:                    // 'delete' 'true'
    case 131183:                    // 'delete' 'try'
    case 131695:                    // 'delete' 'tumbling'
    case 132207:                    // 'delete' 'type'
    case 132719:                    // 'delete' 'typeswitch'
    case 133231:                    // 'delete' 'union'
    case 134255:                    // 'delete' 'unordered'
    case 134767:                    // 'delete' 'updating'
    case 136303:                    // 'delete' 'validate'
    case 136815:                    // 'delete' 'value'
    case 137327:                    // 'delete' 'variable'
    case 137839:                    // 'delete' 'version'
    case 139375:                    // 'delete' 'where'
    case 139887:                    // 'delete' 'while'
    case 141423:                    // 'delete' 'with'
    case 143983:                    // 'delete' '{'
    case 145007:                    // 'delete' '{|'
      parse_JSONDeleteExpr();
      break;
    case -9:
    case 3233:                      // 'insert' EQName^Token
    case 4257:                      // 'insert' IntegerLiteral
    case 4769:                      // 'insert' DecimalLiteral
    case 5281:                      // 'insert' DoubleLiteral
    case 5793:                      // 'insert' StringLiteral
    case 9889:                      // 'insert' NCName^Token
    case 16033:                     // 'insert' '$'
    case 16545:                     // 'insert' '$$'
    case 17057:                     // 'insert' '%'
    case 18593:                     // 'insert' '(#'
    case 21153:                     // 'insert' '+'
    case 22177:                     // 'insert' '-'
    case 24225:                     // 'insert' '/'
    case 24737:                     // 'insert' '//'
    case 28321:                     // 'insert' '<'
    case 28833:                     // 'insert' '<!--'
    case 30881:                     // 'insert' '<?'
    case 35489:                     // 'insert' '['
    case 36513:                     // 'insert' 'after'
    case 37537:                     // 'insert' 'allowing'
    case 38049:                     // 'insert' 'ancestor'
    case 38561:                     // 'insert' 'ancestor-or-self'
    case 39073:                     // 'insert' 'and'
    case 40097:                     // 'insert' 'append'
    case 40609:                     // 'insert' 'array'
    case 41121:                     // 'insert' 'as'
    case 41633:                     // 'insert' 'ascending'
    case 42145:                     // 'insert' 'at'
    case 42657:                     // 'insert' 'attribute'
    case 43169:                     // 'insert' 'base-uri'
    case 43681:                     // 'insert' 'before'
    case 44193:                     // 'insert' 'boundary-space'
    case 44705:                     // 'insert' 'break'
    case 45729:                     // 'insert' 'case'
    case 46241:                     // 'insert' 'cast'
    case 46753:                     // 'insert' 'castable'
    case 47265:                     // 'insert' 'catch'
    case 48289:                     // 'insert' 'child'
    case 48801:                     // 'insert' 'collation'
    case 49825:                     // 'insert' 'comment'
    case 50337:                     // 'insert' 'constraint'
    case 50849:                     // 'insert' 'construction'
    case 52385:                     // 'insert' 'context'
    case 52897:                     // 'insert' 'continue'
    case 53409:                     // 'insert' 'copy'
    case 53921:                     // 'insert' 'copy-namespaces'
    case 54433:                     // 'insert' 'count'
    case 54945:                     // 'insert' 'decimal-format'
    case 55969:                     // 'insert' 'declare'
    case 56481:                     // 'insert' 'default'
    case 56993:                     // 'insert' 'delete'
    case 57505:                     // 'insert' 'descendant'
    case 58017:                     // 'insert' 'descendant-or-self'
    case 58529:                     // 'insert' 'descending'
    case 61089:                     // 'insert' 'div'
    case 61601:                     // 'insert' 'document'
    case 62113:                     // 'insert' 'document-node'
    case 62625:                     // 'insert' 'element'
    case 63137:                     // 'insert' 'else'
    case 63649:                     // 'insert' 'empty'
    case 64161:                     // 'insert' 'empty-sequence'
    case 64673:                     // 'insert' 'encoding'
    case 65185:                     // 'insert' 'end'
    case 66209:                     // 'insert' 'eq'
    case 66721:                     // 'insert' 'every'
    case 67745:                     // 'insert' 'except'
    case 68257:                     // 'insert' 'exit'
    case 68769:                     // 'insert' 'external'
    case 69281:                     // 'insert' 'false'
    case 69793:                     // 'insert' 'first'
    case 70305:                     // 'insert' 'following'
    case 70817:                     // 'insert' 'following-sibling'
    case 71329:                     // 'insert' 'for'
    case 72865:                     // 'insert' 'from'
    case 73377:                     // 'insert' 'ft-option'
    case 75425:                     // 'insert' 'function'
    case 75937:                     // 'insert' 'ge'
    case 76961:                     // 'insert' 'group'
    case 77985:                     // 'insert' 'gt'
    case 78497:                     // 'insert' 'idiv'
    case 79009:                     // 'insert' 'if'
    case 79521:                     // 'insert' 'import'
    case 80033:                     // 'insert' 'in'
    case 80545:                     // 'insert' 'index'
    case 82593:                     // 'insert' 'insert'
    case 83105:                     // 'insert' 'instance'
    case 83617:                     // 'insert' 'integrity'
    case 84129:                     // 'insert' 'intersect'
    case 84641:                     // 'insert' 'into'
    case 85153:                     // 'insert' 'is'
    case 85665:                     // 'insert' 'item'
    case 86177:                     // 'insert' 'json'
    case 86689:                     // 'insert' 'json-item'
    case 87201:                     // 'insert' 'jsoniq'
    case 88737:                     // 'insert' 'last'
    case 89249:                     // 'insert' 'lax'
    case 89761:                     // 'insert' 'le'
    case 90785:                     // 'insert' 'let'
    case 91809:                     // 'insert' 'loop'
    case 92833:                     // 'insert' 'lt'
    case 93857:                     // 'insert' 'mod'
    case 94369:                     // 'insert' 'modify'
    case 94881:                     // 'insert' 'module'
    case 95905:                     // 'insert' 'namespace'
    case 96417:                     // 'insert' 'namespace-node'
    case 96929:                     // 'insert' 'ne'
    case 100513:                    // 'insert' 'not'
    case 101025:                    // 'insert' 'null'
    case 101537:                    // 'insert' 'object'
    case 103585:                    // 'insert' 'only'
    case 104097:                    // 'insert' 'option'
    case 104609:                    // 'insert' 'or'
    case 105121:                    // 'insert' 'order'
    case 105633:                    // 'insert' 'ordered'
    case 106145:                    // 'insert' 'ordering'
    case 107681:                    // 'insert' 'parent'
    case 110753:                    // 'insert' 'preceding'
    case 111265:                    // 'insert' 'preceding-sibling'
    case 112801:                    // 'insert' 'processing-instruction'
    case 113825:                    // 'insert' 'rename'
    case 114337:                    // 'insert' 'replace'
    case 114849:                    // 'insert' 'return'
    case 115361:                    // 'insert' 'returning'
    case 115873:                    // 'insert' 'revalidation'
    case 116897:                    // 'insert' 'satisfies'
    case 117409:                    // 'insert' 'schema'
    case 117921:                    // 'insert' 'schema-attribute'
    case 118433:                    // 'insert' 'schema-element'
    case 118945:                    // 'insert' 'score'
    case 119457:                    // 'insert' 'select'
    case 119969:                    // 'insert' 'self'
    case 122529:                    // 'insert' 'sliding'
    case 123041:                    // 'insert' 'some'
    case 123553:                    // 'insert' 'stable'
    case 124065:                    // 'insert' 'start'
    case 125601:                    // 'insert' 'strict'
    case 126625:                    // 'insert' 'structured-item'
    case 127137:                    // 'insert' 'switch'
    case 127649:                    // 'insert' 'text'
    case 129697:                    // 'insert' 'to'
    case 130209:                    // 'insert' 'treat'
    case 130721:                    // 'insert' 'true'
    case 131233:                    // 'insert' 'try'
    case 131745:                    // 'insert' 'tumbling'
    case 132257:                    // 'insert' 'type'
    case 132769:                    // 'insert' 'typeswitch'
    case 133281:                    // 'insert' 'union'
    case 134305:                    // 'insert' 'unordered'
    case 134817:                    // 'insert' 'updating'
    case 136353:                    // 'insert' 'validate'
    case 136865:                    // 'insert' 'value'
    case 137377:                    // 'insert' 'variable'
    case 137889:                    // 'insert' 'version'
    case 139425:                    // 'insert' 'where'
    case 139937:                    // 'insert' 'while'
    case 141473:                    // 'insert' 'with'
    case 144033:                    // 'insert' '{'
    case 145057:                    // 'insert' '{|'
      parse_JSONInsertExpr();
      break;
    case -10:
    case 3294:                      // 'rename' EQName^Token
    case 4318:                      // 'rename' IntegerLiteral
    case 4830:                      // 'rename' DecimalLiteral
    case 5342:                      // 'rename' DoubleLiteral
    case 5854:                      // 'rename' StringLiteral
    case 16094:                     // 'rename' '$'
    case 16606:                     // 'rename' '$$'
    case 17118:                     // 'rename' '%'
    case 28382:                     // 'rename' '<'
    case 28894:                     // 'rename' '<!--'
    case 30942:                     // 'rename' '<?'
    case 35550:                     // 'rename' '['
    case 36574:                     // 'rename' 'after'
    case 37598:                     // 'rename' 'allowing'
    case 38110:                     // 'rename' 'ancestor'
    case 38622:                     // 'rename' 'ancestor-or-self'
    case 39134:                     // 'rename' 'and'
    case 40158:                     // 'rename' 'append'
    case 40670:                     // 'rename' 'array'
    case 41182:                     // 'rename' 'as'
    case 41694:                     // 'rename' 'ascending'
    case 42206:                     // 'rename' 'at'
    case 42718:                     // 'rename' 'attribute'
    case 43230:                     // 'rename' 'base-uri'
    case 43742:                     // 'rename' 'before'
    case 44254:                     // 'rename' 'boundary-space'
    case 44766:                     // 'rename' 'break'
    case 45790:                     // 'rename' 'case'
    case 46302:                     // 'rename' 'cast'
    case 46814:                     // 'rename' 'castable'
    case 47326:                     // 'rename' 'catch'
    case 48350:                     // 'rename' 'child'
    case 48862:                     // 'rename' 'collation'
    case 49886:                     // 'rename' 'comment'
    case 50398:                     // 'rename' 'constraint'
    case 50910:                     // 'rename' 'construction'
    case 52446:                     // 'rename' 'context'
    case 52958:                     // 'rename' 'continue'
    case 53470:                     // 'rename' 'copy'
    case 53982:                     // 'rename' 'copy-namespaces'
    case 54494:                     // 'rename' 'count'
    case 55006:                     // 'rename' 'decimal-format'
    case 56030:                     // 'rename' 'declare'
    case 56542:                     // 'rename' 'default'
    case 57054:                     // 'rename' 'delete'
    case 57566:                     // 'rename' 'descendant'
    case 58078:                     // 'rename' 'descendant-or-self'
    case 58590:                     // 'rename' 'descending'
    case 61150:                     // 'rename' 'div'
    case 61662:                     // 'rename' 'document'
    case 62174:                     // 'rename' 'document-node'
    case 62686:                     // 'rename' 'element'
    case 63198:                     // 'rename' 'else'
    case 63710:                     // 'rename' 'empty'
    case 64222:                     // 'rename' 'empty-sequence'
    case 64734:                     // 'rename' 'encoding'
    case 65246:                     // 'rename' 'end'
    case 66270:                     // 'rename' 'eq'
    case 66782:                     // 'rename' 'every'
    case 67806:                     // 'rename' 'except'
    case 68318:                     // 'rename' 'exit'
    case 68830:                     // 'rename' 'external'
    case 69342:                     // 'rename' 'false'
    case 69854:                     // 'rename' 'first'
    case 70366:                     // 'rename' 'following'
    case 70878:                     // 'rename' 'following-sibling'
    case 71390:                     // 'rename' 'for'
    case 72926:                     // 'rename' 'from'
    case 73438:                     // 'rename' 'ft-option'
    case 75486:                     // 'rename' 'function'
    case 75998:                     // 'rename' 'ge'
    case 77022:                     // 'rename' 'group'
    case 78046:                     // 'rename' 'gt'
    case 78558:                     // 'rename' 'idiv'
    case 79070:                     // 'rename' 'if'
    case 79582:                     // 'rename' 'import'
    case 80094:                     // 'rename' 'in'
    case 80606:                     // 'rename' 'index'
    case 82654:                     // 'rename' 'insert'
    case 83166:                     // 'rename' 'instance'
    case 83678:                     // 'rename' 'integrity'
    case 84190:                     // 'rename' 'intersect'
    case 84702:                     // 'rename' 'into'
    case 85214:                     // 'rename' 'is'
    case 85726:                     // 'rename' 'item'
    case 86238:                     // 'rename' 'json'
    case 86750:                     // 'rename' 'json-item'
    case 87262:                     // 'rename' 'jsoniq'
    case 88798:                     // 'rename' 'last'
    case 89310:                     // 'rename' 'lax'
    case 89822:                     // 'rename' 'le'
    case 90846:                     // 'rename' 'let'
    case 91870:                     // 'rename' 'loop'
    case 92894:                     // 'rename' 'lt'
    case 93918:                     // 'rename' 'mod'
    case 94430:                     // 'rename' 'modify'
    case 94942:                     // 'rename' 'module'
    case 95966:                     // 'rename' 'namespace'
    case 96478:                     // 'rename' 'namespace-node'
    case 96990:                     // 'rename' 'ne'
    case 100062:                    // 'rename' 'nodes'
    case 101086:                    // 'rename' 'null'
    case 101598:                    // 'rename' 'object'
    case 103646:                    // 'rename' 'only'
    case 104158:                    // 'rename' 'option'
    case 104670:                    // 'rename' 'or'
    case 105182:                    // 'rename' 'order'
    case 105694:                    // 'rename' 'ordered'
    case 106206:                    // 'rename' 'ordering'
    case 107742:                    // 'rename' 'parent'
    case 110814:                    // 'rename' 'preceding'
    case 111326:                    // 'rename' 'preceding-sibling'
    case 112862:                    // 'rename' 'processing-instruction'
    case 113886:                    // 'rename' 'rename'
    case 114398:                    // 'rename' 'replace'
    case 114910:                    // 'rename' 'return'
    case 115422:                    // 'rename' 'returning'
    case 115934:                    // 'rename' 'revalidation'
    case 116958:                    // 'rename' 'satisfies'
    case 117470:                    // 'rename' 'schema'
    case 117982:                    // 'rename' 'schema-attribute'
    case 118494:                    // 'rename' 'schema-element'
    case 119006:                    // 'rename' 'score'
    case 119518:                    // 'rename' 'select'
    case 120030:                    // 'rename' 'self'
    case 122590:                    // 'rename' 'sliding'
    case 123102:                    // 'rename' 'some'
    case 123614:                    // 'rename' 'stable'
    case 124126:                    // 'rename' 'start'
    case 125662:                    // 'rename' 'strict'
    case 126686:                    // 'rename' 'structured-item'
    case 127198:                    // 'rename' 'switch'
    case 127710:                    // 'rename' 'text'
    case 129758:                    // 'rename' 'to'
    case 130270:                    // 'rename' 'treat'
    case 130782:                    // 'rename' 'true'
    case 131294:                    // 'rename' 'try'
    case 131806:                    // 'rename' 'tumbling'
    case 132318:                    // 'rename' 'type'
    case 132830:                    // 'rename' 'typeswitch'
    case 133342:                    // 'rename' 'union'
    case 134366:                    // 'rename' 'unordered'
    case 134878:                    // 'rename' 'updating'
    case 136414:                    // 'rename' 'validate'
    case 136926:                    // 'rename' 'value'
    case 137438:                    // 'rename' 'variable'
    case 137950:                    // 'rename' 'version'
    case 139486:                    // 'rename' 'where'
    case 139998:                    // 'rename' 'while'
    case 141534:                    // 'rename' 'with'
    case 144094:                    // 'rename' '{'
    case 145118:                    // 'rename' '{|'
      parse_JSONRenameExpr();
      break;
    case -11:
      parse_JSONReplaceExpr();
      break;
    case -12:
    case 3150:                      // 'append' EQName^Token
    case 4174:                      // 'append' IntegerLiteral
    case 4686:                      // 'append' DecimalLiteral
    case 5198:                      // 'append' DoubleLiteral
    case 5710:                      // 'append' StringLiteral
    case 15950:                     // 'append' '$'
    case 16462:                     // 'append' '$$'
    case 16974:                     // 'append' '%'
    case 18510:                     // 'append' '(#'
    case 21070:                     // 'append' '+'
    case 22094:                     // 'append' '-'
    case 24142:                     // 'append' '/'
    case 24654:                     // 'append' '//'
    case 28238:                     // 'append' '<'
    case 28750:                     // 'append' '<!--'
    case 30798:                     // 'append' '<?'
    case 35406:                     // 'append' '['
    case 36430:                     // 'append' 'after'
    case 37454:                     // 'append' 'allowing'
    case 37966:                     // 'append' 'ancestor'
    case 38478:                     // 'append' 'ancestor-or-self'
    case 38990:                     // 'append' 'and'
    case 40014:                     // 'append' 'append'
    case 40526:                     // 'append' 'array'
    case 41038:                     // 'append' 'as'
    case 41550:                     // 'append' 'ascending'
    case 42062:                     // 'append' 'at'
    case 42574:                     // 'append' 'attribute'
    case 43086:                     // 'append' 'base-uri'
    case 43598:                     // 'append' 'before'
    case 44110:                     // 'append' 'boundary-space'
    case 44622:                     // 'append' 'break'
    case 45646:                     // 'append' 'case'
    case 46158:                     // 'append' 'cast'
    case 46670:                     // 'append' 'castable'
    case 47182:                     // 'append' 'catch'
    case 48206:                     // 'append' 'child'
    case 48718:                     // 'append' 'collation'
    case 49742:                     // 'append' 'comment'
    case 50254:                     // 'append' 'constraint'
    case 50766:                     // 'append' 'construction'
    case 52302:                     // 'append' 'context'
    case 52814:                     // 'append' 'continue'
    case 53326:                     // 'append' 'copy'
    case 53838:                     // 'append' 'copy-namespaces'
    case 54350:                     // 'append' 'count'
    case 54862:                     // 'append' 'decimal-format'
    case 55886:                     // 'append' 'declare'
    case 56398:                     // 'append' 'default'
    case 56910:                     // 'append' 'delete'
    case 57422:                     // 'append' 'descendant'
    case 57934:                     // 'append' 'descendant-or-self'
    case 58446:                     // 'append' 'descending'
    case 61006:                     // 'append' 'div'
    case 61518:                     // 'append' 'document'
    case 62030:                     // 'append' 'document-node'
    case 62542:                     // 'append' 'element'
    case 63054:                     // 'append' 'else'
    case 63566:                     // 'append' 'empty'
    case 64078:                     // 'append' 'empty-sequence'
    case 64590:                     // 'append' 'encoding'
    case 65102:                     // 'append' 'end'
    case 66126:                     // 'append' 'eq'
    case 66638:                     // 'append' 'every'
    case 67662:                     // 'append' 'except'
    case 68174:                     // 'append' 'exit'
    case 68686:                     // 'append' 'external'
    case 69198:                     // 'append' 'false'
    case 69710:                     // 'append' 'first'
    case 70222:                     // 'append' 'following'
    case 70734:                     // 'append' 'following-sibling'
    case 71246:                     // 'append' 'for'
    case 72782:                     // 'append' 'from'
    case 73294:                     // 'append' 'ft-option'
    case 75342:                     // 'append' 'function'
    case 75854:                     // 'append' 'ge'
    case 76878:                     // 'append' 'group'
    case 77902:                     // 'append' 'gt'
    case 78414:                     // 'append' 'idiv'
    case 78926:                     // 'append' 'if'
    case 79438:                     // 'append' 'import'
    case 79950:                     // 'append' 'in'
    case 80462:                     // 'append' 'index'
    case 82510:                     // 'append' 'insert'
    case 83022:                     // 'append' 'instance'
    case 83534:                     // 'append' 'integrity'
    case 84046:                     // 'append' 'intersect'
    case 84558:                     // 'append' 'into'
    case 85070:                     // 'append' 'is'
    case 85582:                     // 'append' 'item'
    case 86094:                     // 'append' 'json'
    case 86606:                     // 'append' 'json-item'
    case 87118:                     // 'append' 'jsoniq'
    case 88654:                     // 'append' 'last'
    case 89166:                     // 'append' 'lax'
    case 89678:                     // 'append' 'le'
    case 90702:                     // 'append' 'let'
    case 91726:                     // 'append' 'loop'
    case 92750:                     // 'append' 'lt'
    case 93774:                     // 'append' 'mod'
    case 94286:                     // 'append' 'modify'
    case 94798:                     // 'append' 'module'
    case 95822:                     // 'append' 'namespace'
    case 96334:                     // 'append' 'namespace-node'
    case 96846:                     // 'append' 'ne'
    case 99406:                     // 'append' 'node'
    case 99918:                     // 'append' 'nodes'
    case 100430:                    // 'append' 'not'
    case 100942:                    // 'append' 'null'
    case 101454:                    // 'append' 'object'
    case 103502:                    // 'append' 'only'
    case 104014:                    // 'append' 'option'
    case 104526:                    // 'append' 'or'
    case 105038:                    // 'append' 'order'
    case 105550:                    // 'append' 'ordered'
    case 106062:                    // 'append' 'ordering'
    case 107598:                    // 'append' 'parent'
    case 110670:                    // 'append' 'preceding'
    case 111182:                    // 'append' 'preceding-sibling'
    case 112718:                    // 'append' 'processing-instruction'
    case 113742:                    // 'append' 'rename'
    case 114254:                    // 'append' 'replace'
    case 114766:                    // 'append' 'return'
    case 115278:                    // 'append' 'returning'
    case 115790:                    // 'append' 'revalidation'
    case 116814:                    // 'append' 'satisfies'
    case 117326:                    // 'append' 'schema'
    case 117838:                    // 'append' 'schema-attribute'
    case 118350:                    // 'append' 'schema-element'
    case 118862:                    // 'append' 'score'
    case 119374:                    // 'append' 'select'
    case 119886:                    // 'append' 'self'
    case 122446:                    // 'append' 'sliding'
    case 122958:                    // 'append' 'some'
    case 123470:                    // 'append' 'stable'
    case 123982:                    // 'append' 'start'
    case 125518:                    // 'append' 'strict'
    case 126542:                    // 'append' 'structured-item'
    case 127054:                    // 'append' 'switch'
    case 127566:                    // 'append' 'text'
    case 129614:                    // 'append' 'to'
    case 130126:                    // 'append' 'treat'
    case 130638:                    // 'append' 'true'
    case 131150:                    // 'append' 'try'
    case 131662:                    // 'append' 'tumbling'
    case 132174:                    // 'append' 'type'
    case 132686:                    // 'append' 'typeswitch'
    case 133198:                    // 'append' 'union'
    case 134222:                    // 'append' 'unordered'
    case 134734:                    // 'append' 'updating'
    case 136270:                    // 'append' 'validate'
    case 136782:                    // 'append' 'value'
    case 137294:                    // 'append' 'variable'
    case 137806:                    // 'append' 'version'
    case 139342:                    // 'append' 'where'
    case 139854:                    // 'append' 'while'
    case 141390:                    // 'append' 'with'
    case 143950:                    // 'append' '{'
    case 144974:                    // 'append' '{|'
      parse_JSONAppendExpr();
      break;
    default:
      parse_OrExpr();
    }
    eventHandler.endNonterminal("ExprSimple", e0);
  }

  function try_ExprSimple()
  {
    switch (l1)
    {
    case 78:                        // 'append'
      lookahead2W(269);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 161:                       // 'insert'
      lookahead2W(276);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 223:                       // 'replace'
      lookahead2W(170);             // S^WS | '#' | '(' | '(:' | 'node' | 'value'
      break;
    case 111:                       // 'delete'
    case 222:                       // 'rename'
      lookahead2W(261);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 104:                       // 'copy'
    case 130:                       // 'every'
    case 240:                       // 'some'
      lookahead2W(143);             // S^WS | '#' | '$' | '(' | '(:'
      break;
    default:
      lk = l1;
    }
    if (lk == 17998                 // 'append' '('
     || lk == 18031                 // 'delete' '('
     || lk == 18081                 // 'insert' '('
     || lk == 18142                 // 'rename' '('
     || lk == 99439                 // 'delete' 'node'
     || lk == 99489                 // 'insert' 'node'
     || lk == 99550                 // 'rename' 'node'
     || lk == 99951                 // 'delete' 'nodes'
     || lk == 100001                // 'insert' 'nodes'
     || lk == 136927)               // 'replace' 'value'
    {
      lk = memoized(10, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          try_OrExpr();
          memoize(10, e0A, -2);
          lk = -13;
        }
        catch (p2A)
        {
          try
          {
            b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
            b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
            b2 = b2A; e2 = e2A; end = e2A; }}
            try_InsertExpr();
            memoize(10, e0A, -3);
            lk = -13;
          }
          catch (p3A)
          {
            try
            {
              b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
              b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
              b2 = b2A; e2 = e2A; end = e2A; }}
              try_DeleteExpr();
              memoize(10, e0A, -4);
              lk = -13;
            }
            catch (p4A)
            {
              try
              {
                b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                b2 = b2A; e2 = e2A; end = e2A; }}
                try_RenameExpr();
                memoize(10, e0A, -5);
                lk = -13;
              }
              catch (p5A)
              {
                try
                {
                  b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                  b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                  b2 = b2A; e2 = e2A; end = e2A; }}
                  try_ReplaceExpr();
                  memoize(10, e0A, -6);
                  lk = -13;
                }
                catch (p6A)
                {
                  try
                  {
                    b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                    b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                    b2 = b2A; e2 = e2A; end = e2A; }}
                    try_JSONDeleteExpr();
                    memoize(10, e0A, -8);
                    lk = -13;
                  }
                  catch (p8A)
                  {
                    try
                    {
                      b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                      b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                      b2 = b2A; e2 = e2A; end = e2A; }}
                      try_JSONInsertExpr();
                      memoize(10, e0A, -9);
                      lk = -13;
                    }
                    catch (p9A)
                    {
                      try
                      {
                        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                        b2 = b2A; e2 = e2A; end = e2A; }}
                        try_JSONRenameExpr();
                        memoize(10, e0A, -10);
                        lk = -13;
                      }
                      catch (p10A)
                      {
                        try
                        {
                          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                          b2 = b2A; e2 = e2A; end = e2A; }}
                          try_JSONReplaceExpr();
                          memoize(10, e0A, -11);
                          lk = -13;
                        }
                        catch (p11A)
                        {
                          lk = -12;
                          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
                          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
                          b2 = b2A; e2 = e2A; end = e2A; }}
                          memoize(10, e0A, -12);
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    switch (lk)
    {
    case 16002:                     // 'every' '$'
    case 16112:                     // 'some' '$'
      try_QuantifiedExpr();
      break;
    case -3:
      try_InsertExpr();
      break;
    case -4:
      try_DeleteExpr();
      break;
    case -5:
      try_RenameExpr();
      break;
    case -6:
    case 99551:                     // 'replace' 'node'
      try_ReplaceExpr();
      break;
    case 15976:                     // 'copy' '$'
      try_TransformExpr();
      break;
    case -8:
    case 3183:                      // 'delete' EQName^Token
    case 4207:                      // 'delete' IntegerLiteral
    case 4719:                      // 'delete' DecimalLiteral
    case 5231:                      // 'delete' DoubleLiteral
    case 5743:                      // 'delete' StringLiteral
    case 15983:                     // 'delete' '$'
    case 16495:                     // 'delete' '$$'
    case 17007:                     // 'delete' '%'
    case 28271:                     // 'delete' '<'
    case 28783:                     // 'delete' '<!--'
    case 30831:                     // 'delete' '<?'
    case 35439:                     // 'delete' '['
    case 36463:                     // 'delete' 'after'
    case 37487:                     // 'delete' 'allowing'
    case 37999:                     // 'delete' 'ancestor'
    case 38511:                     // 'delete' 'ancestor-or-self'
    case 39023:                     // 'delete' 'and'
    case 40047:                     // 'delete' 'append'
    case 40559:                     // 'delete' 'array'
    case 41071:                     // 'delete' 'as'
    case 41583:                     // 'delete' 'ascending'
    case 42095:                     // 'delete' 'at'
    case 42607:                     // 'delete' 'attribute'
    case 43119:                     // 'delete' 'base-uri'
    case 43631:                     // 'delete' 'before'
    case 44143:                     // 'delete' 'boundary-space'
    case 44655:                     // 'delete' 'break'
    case 45679:                     // 'delete' 'case'
    case 46191:                     // 'delete' 'cast'
    case 46703:                     // 'delete' 'castable'
    case 47215:                     // 'delete' 'catch'
    case 48239:                     // 'delete' 'child'
    case 48751:                     // 'delete' 'collation'
    case 49775:                     // 'delete' 'comment'
    case 50287:                     // 'delete' 'constraint'
    case 50799:                     // 'delete' 'construction'
    case 52335:                     // 'delete' 'context'
    case 52847:                     // 'delete' 'continue'
    case 53359:                     // 'delete' 'copy'
    case 53871:                     // 'delete' 'copy-namespaces'
    case 54383:                     // 'delete' 'count'
    case 54895:                     // 'delete' 'decimal-format'
    case 55919:                     // 'delete' 'declare'
    case 56431:                     // 'delete' 'default'
    case 56943:                     // 'delete' 'delete'
    case 57455:                     // 'delete' 'descendant'
    case 57967:                     // 'delete' 'descendant-or-self'
    case 58479:                     // 'delete' 'descending'
    case 61039:                     // 'delete' 'div'
    case 61551:                     // 'delete' 'document'
    case 62063:                     // 'delete' 'document-node'
    case 62575:                     // 'delete' 'element'
    case 63087:                     // 'delete' 'else'
    case 63599:                     // 'delete' 'empty'
    case 64111:                     // 'delete' 'empty-sequence'
    case 64623:                     // 'delete' 'encoding'
    case 65135:                     // 'delete' 'end'
    case 66159:                     // 'delete' 'eq'
    case 66671:                     // 'delete' 'every'
    case 67695:                     // 'delete' 'except'
    case 68207:                     // 'delete' 'exit'
    case 68719:                     // 'delete' 'external'
    case 69231:                     // 'delete' 'false'
    case 69743:                     // 'delete' 'first'
    case 70255:                     // 'delete' 'following'
    case 70767:                     // 'delete' 'following-sibling'
    case 71279:                     // 'delete' 'for'
    case 72815:                     // 'delete' 'from'
    case 73327:                     // 'delete' 'ft-option'
    case 75375:                     // 'delete' 'function'
    case 75887:                     // 'delete' 'ge'
    case 76911:                     // 'delete' 'group'
    case 77935:                     // 'delete' 'gt'
    case 78447:                     // 'delete' 'idiv'
    case 78959:                     // 'delete' 'if'
    case 79471:                     // 'delete' 'import'
    case 79983:                     // 'delete' 'in'
    case 80495:                     // 'delete' 'index'
    case 82543:                     // 'delete' 'insert'
    case 83055:                     // 'delete' 'instance'
    case 83567:                     // 'delete' 'integrity'
    case 84079:                     // 'delete' 'intersect'
    case 84591:                     // 'delete' 'into'
    case 85103:                     // 'delete' 'is'
    case 85615:                     // 'delete' 'item'
    case 86127:                     // 'delete' 'json'
    case 86639:                     // 'delete' 'json-item'
    case 87151:                     // 'delete' 'jsoniq'
    case 88687:                     // 'delete' 'last'
    case 89199:                     // 'delete' 'lax'
    case 89711:                     // 'delete' 'le'
    case 90735:                     // 'delete' 'let'
    case 91759:                     // 'delete' 'loop'
    case 92783:                     // 'delete' 'lt'
    case 93807:                     // 'delete' 'mod'
    case 94319:                     // 'delete' 'modify'
    case 94831:                     // 'delete' 'module'
    case 95855:                     // 'delete' 'namespace'
    case 96367:                     // 'delete' 'namespace-node'
    case 96879:                     // 'delete' 'ne'
    case 100975:                    // 'delete' 'null'
    case 101487:                    // 'delete' 'object'
    case 103535:                    // 'delete' 'only'
    case 104047:                    // 'delete' 'option'
    case 104559:                    // 'delete' 'or'
    case 105071:                    // 'delete' 'order'
    case 105583:                    // 'delete' 'ordered'
    case 106095:                    // 'delete' 'ordering'
    case 107631:                    // 'delete' 'parent'
    case 110703:                    // 'delete' 'preceding'
    case 111215:                    // 'delete' 'preceding-sibling'
    case 112751:                    // 'delete' 'processing-instruction'
    case 113775:                    // 'delete' 'rename'
    case 114287:                    // 'delete' 'replace'
    case 114799:                    // 'delete' 'return'
    case 115311:                    // 'delete' 'returning'
    case 115823:                    // 'delete' 'revalidation'
    case 116847:                    // 'delete' 'satisfies'
    case 117359:                    // 'delete' 'schema'
    case 117871:                    // 'delete' 'schema-attribute'
    case 118383:                    // 'delete' 'schema-element'
    case 118895:                    // 'delete' 'score'
    case 119407:                    // 'delete' 'select'
    case 119919:                    // 'delete' 'self'
    case 122479:                    // 'delete' 'sliding'
    case 122991:                    // 'delete' 'some'
    case 123503:                    // 'delete' 'stable'
    case 124015:                    // 'delete' 'start'
    case 125551:                    // 'delete' 'strict'
    case 126575:                    // 'delete' 'structured-item'
    case 127087:                    // 'delete' 'switch'
    case 127599:                    // 'delete' 'text'
    case 129647:                    // 'delete' 'to'
    case 130159:                    // 'delete' 'treat'
    case 130671:                    // 'delete' 'true'
    case 131183:                    // 'delete' 'try'
    case 131695:                    // 'delete' 'tumbling'
    case 132207:                    // 'delete' 'type'
    case 132719:                    // 'delete' 'typeswitch'
    case 133231:                    // 'delete' 'union'
    case 134255:                    // 'delete' 'unordered'
    case 134767:                    // 'delete' 'updating'
    case 136303:                    // 'delete' 'validate'
    case 136815:                    // 'delete' 'value'
    case 137327:                    // 'delete' 'variable'
    case 137839:                    // 'delete' 'version'
    case 139375:                    // 'delete' 'where'
    case 139887:                    // 'delete' 'while'
    case 141423:                    // 'delete' 'with'
    case 143983:                    // 'delete' '{'
    case 145007:                    // 'delete' '{|'
      try_JSONDeleteExpr();
      break;
    case -9:
    case 3233:                      // 'insert' EQName^Token
    case 4257:                      // 'insert' IntegerLiteral
    case 4769:                      // 'insert' DecimalLiteral
    case 5281:                      // 'insert' DoubleLiteral
    case 5793:                      // 'insert' StringLiteral
    case 9889:                      // 'insert' NCName^Token
    case 16033:                     // 'insert' '$'
    case 16545:                     // 'insert' '$$'
    case 17057:                     // 'insert' '%'
    case 18593:                     // 'insert' '(#'
    case 21153:                     // 'insert' '+'
    case 22177:                     // 'insert' '-'
    case 24225:                     // 'insert' '/'
    case 24737:                     // 'insert' '//'
    case 28321:                     // 'insert' '<'
    case 28833:                     // 'insert' '<!--'
    case 30881:                     // 'insert' '<?'
    case 35489:                     // 'insert' '['
    case 36513:                     // 'insert' 'after'
    case 37537:                     // 'insert' 'allowing'
    case 38049:                     // 'insert' 'ancestor'
    case 38561:                     // 'insert' 'ancestor-or-self'
    case 39073:                     // 'insert' 'and'
    case 40097:                     // 'insert' 'append'
    case 40609:                     // 'insert' 'array'
    case 41121:                     // 'insert' 'as'
    case 41633:                     // 'insert' 'ascending'
    case 42145:                     // 'insert' 'at'
    case 42657:                     // 'insert' 'attribute'
    case 43169:                     // 'insert' 'base-uri'
    case 43681:                     // 'insert' 'before'
    case 44193:                     // 'insert' 'boundary-space'
    case 44705:                     // 'insert' 'break'
    case 45729:                     // 'insert' 'case'
    case 46241:                     // 'insert' 'cast'
    case 46753:                     // 'insert' 'castable'
    case 47265:                     // 'insert' 'catch'
    case 48289:                     // 'insert' 'child'
    case 48801:                     // 'insert' 'collation'
    case 49825:                     // 'insert' 'comment'
    case 50337:                     // 'insert' 'constraint'
    case 50849:                     // 'insert' 'construction'
    case 52385:                     // 'insert' 'context'
    case 52897:                     // 'insert' 'continue'
    case 53409:                     // 'insert' 'copy'
    case 53921:                     // 'insert' 'copy-namespaces'
    case 54433:                     // 'insert' 'count'
    case 54945:                     // 'insert' 'decimal-format'
    case 55969:                     // 'insert' 'declare'
    case 56481:                     // 'insert' 'default'
    case 56993:                     // 'insert' 'delete'
    case 57505:                     // 'insert' 'descendant'
    case 58017:                     // 'insert' 'descendant-or-self'
    case 58529:                     // 'insert' 'descending'
    case 61089:                     // 'insert' 'div'
    case 61601:                     // 'insert' 'document'
    case 62113:                     // 'insert' 'document-node'
    case 62625:                     // 'insert' 'element'
    case 63137:                     // 'insert' 'else'
    case 63649:                     // 'insert' 'empty'
    case 64161:                     // 'insert' 'empty-sequence'
    case 64673:                     // 'insert' 'encoding'
    case 65185:                     // 'insert' 'end'
    case 66209:                     // 'insert' 'eq'
    case 66721:                     // 'insert' 'every'
    case 67745:                     // 'insert' 'except'
    case 68257:                     // 'insert' 'exit'
    case 68769:                     // 'insert' 'external'
    case 69281:                     // 'insert' 'false'
    case 69793:                     // 'insert' 'first'
    case 70305:                     // 'insert' 'following'
    case 70817:                     // 'insert' 'following-sibling'
    case 71329:                     // 'insert' 'for'
    case 72865:                     // 'insert' 'from'
    case 73377:                     // 'insert' 'ft-option'
    case 75425:                     // 'insert' 'function'
    case 75937:                     // 'insert' 'ge'
    case 76961:                     // 'insert' 'group'
    case 77985:                     // 'insert' 'gt'
    case 78497:                     // 'insert' 'idiv'
    case 79009:                     // 'insert' 'if'
    case 79521:                     // 'insert' 'import'
    case 80033:                     // 'insert' 'in'
    case 80545:                     // 'insert' 'index'
    case 82593:                     // 'insert' 'insert'
    case 83105:                     // 'insert' 'instance'
    case 83617:                     // 'insert' 'integrity'
    case 84129:                     // 'insert' 'intersect'
    case 84641:                     // 'insert' 'into'
    case 85153:                     // 'insert' 'is'
    case 85665:                     // 'insert' 'item'
    case 86177:                     // 'insert' 'json'
    case 86689:                     // 'insert' 'json-item'
    case 87201:                     // 'insert' 'jsoniq'
    case 88737:                     // 'insert' 'last'
    case 89249:                     // 'insert' 'lax'
    case 89761:                     // 'insert' 'le'
    case 90785:                     // 'insert' 'let'
    case 91809:                     // 'insert' 'loop'
    case 92833:                     // 'insert' 'lt'
    case 93857:                     // 'insert' 'mod'
    case 94369:                     // 'insert' 'modify'
    case 94881:                     // 'insert' 'module'
    case 95905:                     // 'insert' 'namespace'
    case 96417:                     // 'insert' 'namespace-node'
    case 96929:                     // 'insert' 'ne'
    case 100513:                    // 'insert' 'not'
    case 101025:                    // 'insert' 'null'
    case 101537:                    // 'insert' 'object'
    case 103585:                    // 'insert' 'only'
    case 104097:                    // 'insert' 'option'
    case 104609:                    // 'insert' 'or'
    case 105121:                    // 'insert' 'order'
    case 105633:                    // 'insert' 'ordered'
    case 106145:                    // 'insert' 'ordering'
    case 107681:                    // 'insert' 'parent'
    case 110753:                    // 'insert' 'preceding'
    case 111265:                    // 'insert' 'preceding-sibling'
    case 112801:                    // 'insert' 'processing-instruction'
    case 113825:                    // 'insert' 'rename'
    case 114337:                    // 'insert' 'replace'
    case 114849:                    // 'insert' 'return'
    case 115361:                    // 'insert' 'returning'
    case 115873:                    // 'insert' 'revalidation'
    case 116897:                    // 'insert' 'satisfies'
    case 117409:                    // 'insert' 'schema'
    case 117921:                    // 'insert' 'schema-attribute'
    case 118433:                    // 'insert' 'schema-element'
    case 118945:                    // 'insert' 'score'
    case 119457:                    // 'insert' 'select'
    case 119969:                    // 'insert' 'self'
    case 122529:                    // 'insert' 'sliding'
    case 123041:                    // 'insert' 'some'
    case 123553:                    // 'insert' 'stable'
    case 124065:                    // 'insert' 'start'
    case 125601:                    // 'insert' 'strict'
    case 126625:                    // 'insert' 'structured-item'
    case 127137:                    // 'insert' 'switch'
    case 127649:                    // 'insert' 'text'
    case 129697:                    // 'insert' 'to'
    case 130209:                    // 'insert' 'treat'
    case 130721:                    // 'insert' 'true'
    case 131233:                    // 'insert' 'try'
    case 131745:                    // 'insert' 'tumbling'
    case 132257:                    // 'insert' 'type'
    case 132769:                    // 'insert' 'typeswitch'
    case 133281:                    // 'insert' 'union'
    case 134305:                    // 'insert' 'unordered'
    case 134817:                    // 'insert' 'updating'
    case 136353:                    // 'insert' 'validate'
    case 136865:                    // 'insert' 'value'
    case 137377:                    // 'insert' 'variable'
    case 137889:                    // 'insert' 'version'
    case 139425:                    // 'insert' 'where'
    case 139937:                    // 'insert' 'while'
    case 141473:                    // 'insert' 'with'
    case 144033:                    // 'insert' '{'
    case 145057:                    // 'insert' '{|'
      try_JSONInsertExpr();
      break;
    case -10:
    case 3294:                      // 'rename' EQName^Token
    case 4318:                      // 'rename' IntegerLiteral
    case 4830:                      // 'rename' DecimalLiteral
    case 5342:                      // 'rename' DoubleLiteral
    case 5854:                      // 'rename' StringLiteral
    case 16094:                     // 'rename' '$'
    case 16606:                     // 'rename' '$$'
    case 17118:                     // 'rename' '%'
    case 28382:                     // 'rename' '<'
    case 28894:                     // 'rename' '<!--'
    case 30942:                     // 'rename' '<?'
    case 35550:                     // 'rename' '['
    case 36574:                     // 'rename' 'after'
    case 37598:                     // 'rename' 'allowing'
    case 38110:                     // 'rename' 'ancestor'
    case 38622:                     // 'rename' 'ancestor-or-self'
    case 39134:                     // 'rename' 'and'
    case 40158:                     // 'rename' 'append'
    case 40670:                     // 'rename' 'array'
    case 41182:                     // 'rename' 'as'
    case 41694:                     // 'rename' 'ascending'
    case 42206:                     // 'rename' 'at'
    case 42718:                     // 'rename' 'attribute'
    case 43230:                     // 'rename' 'base-uri'
    case 43742:                     // 'rename' 'before'
    case 44254:                     // 'rename' 'boundary-space'
    case 44766:                     // 'rename' 'break'
    case 45790:                     // 'rename' 'case'
    case 46302:                     // 'rename' 'cast'
    case 46814:                     // 'rename' 'castable'
    case 47326:                     // 'rename' 'catch'
    case 48350:                     // 'rename' 'child'
    case 48862:                     // 'rename' 'collation'
    case 49886:                     // 'rename' 'comment'
    case 50398:                     // 'rename' 'constraint'
    case 50910:                     // 'rename' 'construction'
    case 52446:                     // 'rename' 'context'
    case 52958:                     // 'rename' 'continue'
    case 53470:                     // 'rename' 'copy'
    case 53982:                     // 'rename' 'copy-namespaces'
    case 54494:                     // 'rename' 'count'
    case 55006:                     // 'rename' 'decimal-format'
    case 56030:                     // 'rename' 'declare'
    case 56542:                     // 'rename' 'default'
    case 57054:                     // 'rename' 'delete'
    case 57566:                     // 'rename' 'descendant'
    case 58078:                     // 'rename' 'descendant-or-self'
    case 58590:                     // 'rename' 'descending'
    case 61150:                     // 'rename' 'div'
    case 61662:                     // 'rename' 'document'
    case 62174:                     // 'rename' 'document-node'
    case 62686:                     // 'rename' 'element'
    case 63198:                     // 'rename' 'else'
    case 63710:                     // 'rename' 'empty'
    case 64222:                     // 'rename' 'empty-sequence'
    case 64734:                     // 'rename' 'encoding'
    case 65246:                     // 'rename' 'end'
    case 66270:                     // 'rename' 'eq'
    case 66782:                     // 'rename' 'every'
    case 67806:                     // 'rename' 'except'
    case 68318:                     // 'rename' 'exit'
    case 68830:                     // 'rename' 'external'
    case 69342:                     // 'rename' 'false'
    case 69854:                     // 'rename' 'first'
    case 70366:                     // 'rename' 'following'
    case 70878:                     // 'rename' 'following-sibling'
    case 71390:                     // 'rename' 'for'
    case 72926:                     // 'rename' 'from'
    case 73438:                     // 'rename' 'ft-option'
    case 75486:                     // 'rename' 'function'
    case 75998:                     // 'rename' 'ge'
    case 77022:                     // 'rename' 'group'
    case 78046:                     // 'rename' 'gt'
    case 78558:                     // 'rename' 'idiv'
    case 79070:                     // 'rename' 'if'
    case 79582:                     // 'rename' 'import'
    case 80094:                     // 'rename' 'in'
    case 80606:                     // 'rename' 'index'
    case 82654:                     // 'rename' 'insert'
    case 83166:                     // 'rename' 'instance'
    case 83678:                     // 'rename' 'integrity'
    case 84190:                     // 'rename' 'intersect'
    case 84702:                     // 'rename' 'into'
    case 85214:                     // 'rename' 'is'
    case 85726:                     // 'rename' 'item'
    case 86238:                     // 'rename' 'json'
    case 86750:                     // 'rename' 'json-item'
    case 87262:                     // 'rename' 'jsoniq'
    case 88798:                     // 'rename' 'last'
    case 89310:                     // 'rename' 'lax'
    case 89822:                     // 'rename' 'le'
    case 90846:                     // 'rename' 'let'
    case 91870:                     // 'rename' 'loop'
    case 92894:                     // 'rename' 'lt'
    case 93918:                     // 'rename' 'mod'
    case 94430:                     // 'rename' 'modify'
    case 94942:                     // 'rename' 'module'
    case 95966:                     // 'rename' 'namespace'
    case 96478:                     // 'rename' 'namespace-node'
    case 96990:                     // 'rename' 'ne'
    case 100062:                    // 'rename' 'nodes'
    case 101086:                    // 'rename' 'null'
    case 101598:                    // 'rename' 'object'
    case 103646:                    // 'rename' 'only'
    case 104158:                    // 'rename' 'option'
    case 104670:                    // 'rename' 'or'
    case 105182:                    // 'rename' 'order'
    case 105694:                    // 'rename' 'ordered'
    case 106206:                    // 'rename' 'ordering'
    case 107742:                    // 'rename' 'parent'
    case 110814:                    // 'rename' 'preceding'
    case 111326:                    // 'rename' 'preceding-sibling'
    case 112862:                    // 'rename' 'processing-instruction'
    case 113886:                    // 'rename' 'rename'
    case 114398:                    // 'rename' 'replace'
    case 114910:                    // 'rename' 'return'
    case 115422:                    // 'rename' 'returning'
    case 115934:                    // 'rename' 'revalidation'
    case 116958:                    // 'rename' 'satisfies'
    case 117470:                    // 'rename' 'schema'
    case 117982:                    // 'rename' 'schema-attribute'
    case 118494:                    // 'rename' 'schema-element'
    case 119006:                    // 'rename' 'score'
    case 119518:                    // 'rename' 'select'
    case 120030:                    // 'rename' 'self'
    case 122590:                    // 'rename' 'sliding'
    case 123102:                    // 'rename' 'some'
    case 123614:                    // 'rename' 'stable'
    case 124126:                    // 'rename' 'start'
    case 125662:                    // 'rename' 'strict'
    case 126686:                    // 'rename' 'structured-item'
    case 127198:                    // 'rename' 'switch'
    case 127710:                    // 'rename' 'text'
    case 129758:                    // 'rename' 'to'
    case 130270:                    // 'rename' 'treat'
    case 130782:                    // 'rename' 'true'
    case 131294:                    // 'rename' 'try'
    case 131806:                    // 'rename' 'tumbling'
    case 132318:                    // 'rename' 'type'
    case 132830:                    // 'rename' 'typeswitch'
    case 133342:                    // 'rename' 'union'
    case 134366:                    // 'rename' 'unordered'
    case 134878:                    // 'rename' 'updating'
    case 136414:                    // 'rename' 'validate'
    case 136926:                    // 'rename' 'value'
    case 137438:                    // 'rename' 'variable'
    case 137950:                    // 'rename' 'version'
    case 139486:                    // 'rename' 'where'
    case 139998:                    // 'rename' 'while'
    case 141534:                    // 'rename' 'with'
    case 144094:                    // 'rename' '{'
    case 145118:                    // 'rename' '{|'
      try_JSONRenameExpr();
      break;
    case -11:
      try_JSONReplaceExpr();
      break;
    case -12:
    case 3150:                      // 'append' EQName^Token
    case 4174:                      // 'append' IntegerLiteral
    case 4686:                      // 'append' DecimalLiteral
    case 5198:                      // 'append' DoubleLiteral
    case 5710:                      // 'append' StringLiteral
    case 15950:                     // 'append' '$'
    case 16462:                     // 'append' '$$'
    case 16974:                     // 'append' '%'
    case 18510:                     // 'append' '(#'
    case 21070:                     // 'append' '+'
    case 22094:                     // 'append' '-'
    case 24142:                     // 'append' '/'
    case 24654:                     // 'append' '//'
    case 28238:                     // 'append' '<'
    case 28750:                     // 'append' '<!--'
    case 30798:                     // 'append' '<?'
    case 35406:                     // 'append' '['
    case 36430:                     // 'append' 'after'
    case 37454:                     // 'append' 'allowing'
    case 37966:                     // 'append' 'ancestor'
    case 38478:                     // 'append' 'ancestor-or-self'
    case 38990:                     // 'append' 'and'
    case 40014:                     // 'append' 'append'
    case 40526:                     // 'append' 'array'
    case 41038:                     // 'append' 'as'
    case 41550:                     // 'append' 'ascending'
    case 42062:                     // 'append' 'at'
    case 42574:                     // 'append' 'attribute'
    case 43086:                     // 'append' 'base-uri'
    case 43598:                     // 'append' 'before'
    case 44110:                     // 'append' 'boundary-space'
    case 44622:                     // 'append' 'break'
    case 45646:                     // 'append' 'case'
    case 46158:                     // 'append' 'cast'
    case 46670:                     // 'append' 'castable'
    case 47182:                     // 'append' 'catch'
    case 48206:                     // 'append' 'child'
    case 48718:                     // 'append' 'collation'
    case 49742:                     // 'append' 'comment'
    case 50254:                     // 'append' 'constraint'
    case 50766:                     // 'append' 'construction'
    case 52302:                     // 'append' 'context'
    case 52814:                     // 'append' 'continue'
    case 53326:                     // 'append' 'copy'
    case 53838:                     // 'append' 'copy-namespaces'
    case 54350:                     // 'append' 'count'
    case 54862:                     // 'append' 'decimal-format'
    case 55886:                     // 'append' 'declare'
    case 56398:                     // 'append' 'default'
    case 56910:                     // 'append' 'delete'
    case 57422:                     // 'append' 'descendant'
    case 57934:                     // 'append' 'descendant-or-self'
    case 58446:                     // 'append' 'descending'
    case 61006:                     // 'append' 'div'
    case 61518:                     // 'append' 'document'
    case 62030:                     // 'append' 'document-node'
    case 62542:                     // 'append' 'element'
    case 63054:                     // 'append' 'else'
    case 63566:                     // 'append' 'empty'
    case 64078:                     // 'append' 'empty-sequence'
    case 64590:                     // 'append' 'encoding'
    case 65102:                     // 'append' 'end'
    case 66126:                     // 'append' 'eq'
    case 66638:                     // 'append' 'every'
    case 67662:                     // 'append' 'except'
    case 68174:                     // 'append' 'exit'
    case 68686:                     // 'append' 'external'
    case 69198:                     // 'append' 'false'
    case 69710:                     // 'append' 'first'
    case 70222:                     // 'append' 'following'
    case 70734:                     // 'append' 'following-sibling'
    case 71246:                     // 'append' 'for'
    case 72782:                     // 'append' 'from'
    case 73294:                     // 'append' 'ft-option'
    case 75342:                     // 'append' 'function'
    case 75854:                     // 'append' 'ge'
    case 76878:                     // 'append' 'group'
    case 77902:                     // 'append' 'gt'
    case 78414:                     // 'append' 'idiv'
    case 78926:                     // 'append' 'if'
    case 79438:                     // 'append' 'import'
    case 79950:                     // 'append' 'in'
    case 80462:                     // 'append' 'index'
    case 82510:                     // 'append' 'insert'
    case 83022:                     // 'append' 'instance'
    case 83534:                     // 'append' 'integrity'
    case 84046:                     // 'append' 'intersect'
    case 84558:                     // 'append' 'into'
    case 85070:                     // 'append' 'is'
    case 85582:                     // 'append' 'item'
    case 86094:                     // 'append' 'json'
    case 86606:                     // 'append' 'json-item'
    case 87118:                     // 'append' 'jsoniq'
    case 88654:                     // 'append' 'last'
    case 89166:                     // 'append' 'lax'
    case 89678:                     // 'append' 'le'
    case 90702:                     // 'append' 'let'
    case 91726:                     // 'append' 'loop'
    case 92750:                     // 'append' 'lt'
    case 93774:                     // 'append' 'mod'
    case 94286:                     // 'append' 'modify'
    case 94798:                     // 'append' 'module'
    case 95822:                     // 'append' 'namespace'
    case 96334:                     // 'append' 'namespace-node'
    case 96846:                     // 'append' 'ne'
    case 99406:                     // 'append' 'node'
    case 99918:                     // 'append' 'nodes'
    case 100430:                    // 'append' 'not'
    case 100942:                    // 'append' 'null'
    case 101454:                    // 'append' 'object'
    case 103502:                    // 'append' 'only'
    case 104014:                    // 'append' 'option'
    case 104526:                    // 'append' 'or'
    case 105038:                    // 'append' 'order'
    case 105550:                    // 'append' 'ordered'
    case 106062:                    // 'append' 'ordering'
    case 107598:                    // 'append' 'parent'
    case 110670:                    // 'append' 'preceding'
    case 111182:                    // 'append' 'preceding-sibling'
    case 112718:                    // 'append' 'processing-instruction'
    case 113742:                    // 'append' 'rename'
    case 114254:                    // 'append' 'replace'
    case 114766:                    // 'append' 'return'
    case 115278:                    // 'append' 'returning'
    case 115790:                    // 'append' 'revalidation'
    case 116814:                    // 'append' 'satisfies'
    case 117326:                    // 'append' 'schema'
    case 117838:                    // 'append' 'schema-attribute'
    case 118350:                    // 'append' 'schema-element'
    case 118862:                    // 'append' 'score'
    case 119374:                    // 'append' 'select'
    case 119886:                    // 'append' 'self'
    case 122446:                    // 'append' 'sliding'
    case 122958:                    // 'append' 'some'
    case 123470:                    // 'append' 'stable'
    case 123982:                    // 'append' 'start'
    case 125518:                    // 'append' 'strict'
    case 126542:                    // 'append' 'structured-item'
    case 127054:                    // 'append' 'switch'
    case 127566:                    // 'append' 'text'
    case 129614:                    // 'append' 'to'
    case 130126:                    // 'append' 'treat'
    case 130638:                    // 'append' 'true'
    case 131150:                    // 'append' 'try'
    case 131662:                    // 'append' 'tumbling'
    case 132174:                    // 'append' 'type'
    case 132686:                    // 'append' 'typeswitch'
    case 133198:                    // 'append' 'union'
    case 134222:                    // 'append' 'unordered'
    case 134734:                    // 'append' 'updating'
    case 136270:                    // 'append' 'validate'
    case 136782:                    // 'append' 'value'
    case 137294:                    // 'append' 'variable'
    case 137806:                    // 'append' 'version'
    case 139342:                    // 'append' 'where'
    case 139854:                    // 'append' 'while'
    case 141390:                    // 'append' 'with'
    case 143950:                    // 'append' '{'
    case 144974:                    // 'append' '{|'
      try_JSONAppendExpr();
      break;
    case -13:
      break;
    default:
      try_OrExpr();
    }
  }

  function parse_JSONDeleteExpr()
  {
    eventHandler.startNonterminal("JSONDeleteExpr", e0);
    shift(111);                     // 'delete'
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    switch (l1)
    {
    case 168:                       // 'json'
      lookahead2W(261);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 18088)                // 'json' '('
    {
      lk = memoized(11, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(168);              // 'json'
          lk = -1;
        }
        catch (p1A)
        {
          lk = -2;
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(11, e0, lk);
      }
    }
    if (lk == -1
     || lk == 3240                  // 'json' EQName^Token
     || lk == 4264                  // 'json' IntegerLiteral
     || lk == 4776                  // 'json' DecimalLiteral
     || lk == 5288                  // 'json' DoubleLiteral
     || lk == 5800                  // 'json' StringLiteral
     || lk == 16040                 // 'json' '$'
     || lk == 16552                 // 'json' '$$'
     || lk == 17064                 // 'json' '%'
     || lk == 28328                 // 'json' '<'
     || lk == 28840                 // 'json' '<!--'
     || lk == 30888                 // 'json' '<?'
     || lk == 35496                 // 'json' '['
     || lk == 36520                 // 'json' 'after'
     || lk == 37544                 // 'json' 'allowing'
     || lk == 38056                 // 'json' 'ancestor'
     || lk == 38568                 // 'json' 'ancestor-or-self'
     || lk == 39080                 // 'json' 'and'
     || lk == 40104                 // 'json' 'append'
     || lk == 40616                 // 'json' 'array'
     || lk == 41128                 // 'json' 'as'
     || lk == 41640                 // 'json' 'ascending'
     || lk == 42152                 // 'json' 'at'
     || lk == 42664                 // 'json' 'attribute'
     || lk == 43176                 // 'json' 'base-uri'
     || lk == 43688                 // 'json' 'before'
     || lk == 44200                 // 'json' 'boundary-space'
     || lk == 44712                 // 'json' 'break'
     || lk == 45736                 // 'json' 'case'
     || lk == 46248                 // 'json' 'cast'
     || lk == 46760                 // 'json' 'castable'
     || lk == 47272                 // 'json' 'catch'
     || lk == 48296                 // 'json' 'child'
     || lk == 48808                 // 'json' 'collation'
     || lk == 49832                 // 'json' 'comment'
     || lk == 50344                 // 'json' 'constraint'
     || lk == 50856                 // 'json' 'construction'
     || lk == 52392                 // 'json' 'context'
     || lk == 52904                 // 'json' 'continue'
     || lk == 53416                 // 'json' 'copy'
     || lk == 53928                 // 'json' 'copy-namespaces'
     || lk == 54440                 // 'json' 'count'
     || lk == 54952                 // 'json' 'decimal-format'
     || lk == 55976                 // 'json' 'declare'
     || lk == 56488                 // 'json' 'default'
     || lk == 57000                 // 'json' 'delete'
     || lk == 57512                 // 'json' 'descendant'
     || lk == 58024                 // 'json' 'descendant-or-self'
     || lk == 58536                 // 'json' 'descending'
     || lk == 61096                 // 'json' 'div'
     || lk == 61608                 // 'json' 'document'
     || lk == 62120                 // 'json' 'document-node'
     || lk == 62632                 // 'json' 'element'
     || lk == 63144                 // 'json' 'else'
     || lk == 63656                 // 'json' 'empty'
     || lk == 64168                 // 'json' 'empty-sequence'
     || lk == 64680                 // 'json' 'encoding'
     || lk == 65192                 // 'json' 'end'
     || lk == 66216                 // 'json' 'eq'
     || lk == 66728                 // 'json' 'every'
     || lk == 67752                 // 'json' 'except'
     || lk == 68264                 // 'json' 'exit'
     || lk == 68776                 // 'json' 'external'
     || lk == 69288                 // 'json' 'false'
     || lk == 69800                 // 'json' 'first'
     || lk == 70312                 // 'json' 'following'
     || lk == 70824                 // 'json' 'following-sibling'
     || lk == 71336                 // 'json' 'for'
     || lk == 72872                 // 'json' 'from'
     || lk == 73384                 // 'json' 'ft-option'
     || lk == 75432                 // 'json' 'function'
     || lk == 75944                 // 'json' 'ge'
     || lk == 76968                 // 'json' 'group'
     || lk == 77992                 // 'json' 'gt'
     || lk == 78504                 // 'json' 'idiv'
     || lk == 79016                 // 'json' 'if'
     || lk == 79528                 // 'json' 'import'
     || lk == 80040                 // 'json' 'in'
     || lk == 80552                 // 'json' 'index'
     || lk == 82600                 // 'json' 'insert'
     || lk == 83112                 // 'json' 'instance'
     || lk == 83624                 // 'json' 'integrity'
     || lk == 84136                 // 'json' 'intersect'
     || lk == 84648                 // 'json' 'into'
     || lk == 85160                 // 'json' 'is'
     || lk == 85672                 // 'json' 'item'
     || lk == 86184                 // 'json' 'json'
     || lk == 86696                 // 'json' 'json-item'
     || lk == 87208                 // 'json' 'jsoniq'
     || lk == 88744                 // 'json' 'last'
     || lk == 89256                 // 'json' 'lax'
     || lk == 89768                 // 'json' 'le'
     || lk == 90792                 // 'json' 'let'
     || lk == 91816                 // 'json' 'loop'
     || lk == 92840                 // 'json' 'lt'
     || lk == 93864                 // 'json' 'mod'
     || lk == 94376                 // 'json' 'modify'
     || lk == 94888                 // 'json' 'module'
     || lk == 95912                 // 'json' 'namespace'
     || lk == 96424                 // 'json' 'namespace-node'
     || lk == 96936                 // 'json' 'ne'
     || lk == 99496                 // 'json' 'node'
     || lk == 100008                // 'json' 'nodes'
     || lk == 101032                // 'json' 'null'
     || lk == 101544                // 'json' 'object'
     || lk == 103592                // 'json' 'only'
     || lk == 104104                // 'json' 'option'
     || lk == 104616                // 'json' 'or'
     || lk == 105128                // 'json' 'order'
     || lk == 105640                // 'json' 'ordered'
     || lk == 106152                // 'json' 'ordering'
     || lk == 107688                // 'json' 'parent'
     || lk == 110760                // 'json' 'preceding'
     || lk == 111272                // 'json' 'preceding-sibling'
     || lk == 112808                // 'json' 'processing-instruction'
     || lk == 113832                // 'json' 'rename'
     || lk == 114344                // 'json' 'replace'
     || lk == 114856                // 'json' 'return'
     || lk == 115368                // 'json' 'returning'
     || lk == 115880                // 'json' 'revalidation'
     || lk == 116904                // 'json' 'satisfies'
     || lk == 117416                // 'json' 'schema'
     || lk == 117928                // 'json' 'schema-attribute'
     || lk == 118440                // 'json' 'schema-element'
     || lk == 118952                // 'json' 'score'
     || lk == 119464                // 'json' 'select'
     || lk == 119976                // 'json' 'self'
     || lk == 122536                // 'json' 'sliding'
     || lk == 123048                // 'json' 'some'
     || lk == 123560                // 'json' 'stable'
     || lk == 124072                // 'json' 'start'
     || lk == 125608                // 'json' 'strict'
     || lk == 126632                // 'json' 'structured-item'
     || lk == 127144                // 'json' 'switch'
     || lk == 127656                // 'json' 'text'
     || lk == 129704                // 'json' 'to'
     || lk == 130216                // 'json' 'treat'
     || lk == 130728                // 'json' 'true'
     || lk == 131240                // 'json' 'try'
     || lk == 131752                // 'json' 'tumbling'
     || lk == 132264                // 'json' 'type'
     || lk == 132776                // 'json' 'typeswitch'
     || lk == 133288                // 'json' 'union'
     || lk == 134312                // 'json' 'unordered'
     || lk == 134824                // 'json' 'updating'
     || lk == 136360                // 'json' 'validate'
     || lk == 136872                // 'json' 'value'
     || lk == 137384                // 'json' 'variable'
     || lk == 137896                // 'json' 'version'
     || lk == 139432                // 'json' 'where'
     || lk == 139944                // 'json' 'while'
     || lk == 141480                // 'json' 'with'
     || lk == 144040                // 'json' '{'
     || lk == 145064)               // 'json' '{|'
    {
      shift(168);                   // 'json'
    }
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_PostfixExpr();
    eventHandler.endNonterminal("JSONDeleteExpr", e0);
  }

  function try_JSONDeleteExpr()
  {
    shiftT(111);                    // 'delete'
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    switch (l1)
    {
    case 168:                       // 'json'
      lookahead2W(261);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 18088)                // 'json' '('
    {
      lk = memoized(11, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(168);              // 'json'
          memoize(11, e0A, -1);
        }
        catch (p1A)
        {
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(11, e0A, -2);
        }
        lk = -2;
      }
    }
    if (lk == -1
     || lk == 3240                  // 'json' EQName^Token
     || lk == 4264                  // 'json' IntegerLiteral
     || lk == 4776                  // 'json' DecimalLiteral
     || lk == 5288                  // 'json' DoubleLiteral
     || lk == 5800                  // 'json' StringLiteral
     || lk == 16040                 // 'json' '$'
     || lk == 16552                 // 'json' '$$'
     || lk == 17064                 // 'json' '%'
     || lk == 28328                 // 'json' '<'
     || lk == 28840                 // 'json' '<!--'
     || lk == 30888                 // 'json' '<?'
     || lk == 35496                 // 'json' '['
     || lk == 36520                 // 'json' 'after'
     || lk == 37544                 // 'json' 'allowing'
     || lk == 38056                 // 'json' 'ancestor'
     || lk == 38568                 // 'json' 'ancestor-or-self'
     || lk == 39080                 // 'json' 'and'
     || lk == 40104                 // 'json' 'append'
     || lk == 40616                 // 'json' 'array'
     || lk == 41128                 // 'json' 'as'
     || lk == 41640                 // 'json' 'ascending'
     || lk == 42152                 // 'json' 'at'
     || lk == 42664                 // 'json' 'attribute'
     || lk == 43176                 // 'json' 'base-uri'
     || lk == 43688                 // 'json' 'before'
     || lk == 44200                 // 'json' 'boundary-space'
     || lk == 44712                 // 'json' 'break'
     || lk == 45736                 // 'json' 'case'
     || lk == 46248                 // 'json' 'cast'
     || lk == 46760                 // 'json' 'castable'
     || lk == 47272                 // 'json' 'catch'
     || lk == 48296                 // 'json' 'child'
     || lk == 48808                 // 'json' 'collation'
     || lk == 49832                 // 'json' 'comment'
     || lk == 50344                 // 'json' 'constraint'
     || lk == 50856                 // 'json' 'construction'
     || lk == 52392                 // 'json' 'context'
     || lk == 52904                 // 'json' 'continue'
     || lk == 53416                 // 'json' 'copy'
     || lk == 53928                 // 'json' 'copy-namespaces'
     || lk == 54440                 // 'json' 'count'
     || lk == 54952                 // 'json' 'decimal-format'
     || lk == 55976                 // 'json' 'declare'
     || lk == 56488                 // 'json' 'default'
     || lk == 57000                 // 'json' 'delete'
     || lk == 57512                 // 'json' 'descendant'
     || lk == 58024                 // 'json' 'descendant-or-self'
     || lk == 58536                 // 'json' 'descending'
     || lk == 61096                 // 'json' 'div'
     || lk == 61608                 // 'json' 'document'
     || lk == 62120                 // 'json' 'document-node'
     || lk == 62632                 // 'json' 'element'
     || lk == 63144                 // 'json' 'else'
     || lk == 63656                 // 'json' 'empty'
     || lk == 64168                 // 'json' 'empty-sequence'
     || lk == 64680                 // 'json' 'encoding'
     || lk == 65192                 // 'json' 'end'
     || lk == 66216                 // 'json' 'eq'
     || lk == 66728                 // 'json' 'every'
     || lk == 67752                 // 'json' 'except'
     || lk == 68264                 // 'json' 'exit'
     || lk == 68776                 // 'json' 'external'
     || lk == 69288                 // 'json' 'false'
     || lk == 69800                 // 'json' 'first'
     || lk == 70312                 // 'json' 'following'
     || lk == 70824                 // 'json' 'following-sibling'
     || lk == 71336                 // 'json' 'for'
     || lk == 72872                 // 'json' 'from'
     || lk == 73384                 // 'json' 'ft-option'
     || lk == 75432                 // 'json' 'function'
     || lk == 75944                 // 'json' 'ge'
     || lk == 76968                 // 'json' 'group'
     || lk == 77992                 // 'json' 'gt'
     || lk == 78504                 // 'json' 'idiv'
     || lk == 79016                 // 'json' 'if'
     || lk == 79528                 // 'json' 'import'
     || lk == 80040                 // 'json' 'in'
     || lk == 80552                 // 'json' 'index'
     || lk == 82600                 // 'json' 'insert'
     || lk == 83112                 // 'json' 'instance'
     || lk == 83624                 // 'json' 'integrity'
     || lk == 84136                 // 'json' 'intersect'
     || lk == 84648                 // 'json' 'into'
     || lk == 85160                 // 'json' 'is'
     || lk == 85672                 // 'json' 'item'
     || lk == 86184                 // 'json' 'json'
     || lk == 86696                 // 'json' 'json-item'
     || lk == 87208                 // 'json' 'jsoniq'
     || lk == 88744                 // 'json' 'last'
     || lk == 89256                 // 'json' 'lax'
     || lk == 89768                 // 'json' 'le'
     || lk == 90792                 // 'json' 'let'
     || lk == 91816                 // 'json' 'loop'
     || lk == 92840                 // 'json' 'lt'
     || lk == 93864                 // 'json' 'mod'
     || lk == 94376                 // 'json' 'modify'
     || lk == 94888                 // 'json' 'module'
     || lk == 95912                 // 'json' 'namespace'
     || lk == 96424                 // 'json' 'namespace-node'
     || lk == 96936                 // 'json' 'ne'
     || lk == 99496                 // 'json' 'node'
     || lk == 100008                // 'json' 'nodes'
     || lk == 101032                // 'json' 'null'
     || lk == 101544                // 'json' 'object'
     || lk == 103592                // 'json' 'only'
     || lk == 104104                // 'json' 'option'
     || lk == 104616                // 'json' 'or'
     || lk == 105128                // 'json' 'order'
     || lk == 105640                // 'json' 'ordered'
     || lk == 106152                // 'json' 'ordering'
     || lk == 107688                // 'json' 'parent'
     || lk == 110760                // 'json' 'preceding'
     || lk == 111272                // 'json' 'preceding-sibling'
     || lk == 112808                // 'json' 'processing-instruction'
     || lk == 113832                // 'json' 'rename'
     || lk == 114344                // 'json' 'replace'
     || lk == 114856                // 'json' 'return'
     || lk == 115368                // 'json' 'returning'
     || lk == 115880                // 'json' 'revalidation'
     || lk == 116904                // 'json' 'satisfies'
     || lk == 117416                // 'json' 'schema'
     || lk == 117928                // 'json' 'schema-attribute'
     || lk == 118440                // 'json' 'schema-element'
     || lk == 118952                // 'json' 'score'
     || lk == 119464                // 'json' 'select'
     || lk == 119976                // 'json' 'self'
     || lk == 122536                // 'json' 'sliding'
     || lk == 123048                // 'json' 'some'
     || lk == 123560                // 'json' 'stable'
     || lk == 124072                // 'json' 'start'
     || lk == 125608                // 'json' 'strict'
     || lk == 126632                // 'json' 'structured-item'
     || lk == 127144                // 'json' 'switch'
     || lk == 127656                // 'json' 'text'
     || lk == 129704                // 'json' 'to'
     || lk == 130216                // 'json' 'treat'
     || lk == 130728                // 'json' 'true'
     || lk == 131240                // 'json' 'try'
     || lk == 131752                // 'json' 'tumbling'
     || lk == 132264                // 'json' 'type'
     || lk == 132776                // 'json' 'typeswitch'
     || lk == 133288                // 'json' 'union'
     || lk == 134312                // 'json' 'unordered'
     || lk == 134824                // 'json' 'updating'
     || lk == 136360                // 'json' 'validate'
     || lk == 136872                // 'json' 'value'
     || lk == 137384                // 'json' 'variable'
     || lk == 137896                // 'json' 'version'
     || lk == 139432                // 'json' 'where'
     || lk == 139944                // 'json' 'while'
     || lk == 141480                // 'json' 'with'
     || lk == 144040                // 'json' '{'
     || lk == 145064)               // 'json' '{|'
    {
      shiftT(168);                  // 'json'
    }
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_PostfixExpr();
  }

  function parse_JSONInsertExpr()
  {
    eventHandler.startNonterminal("JSONInsertExpr", e0);
    switch (l1)
    {
    case 161:                       // 'insert'
      lookahead2W(268);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk != 9889)                 // 'insert' NCName^Token
    {
      lk = memoized(12, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(161);              // 'insert'
          lookahead1W(267);         // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
          switch (l1)
          {
          case 168:                 // 'json'
            lookahead2W(269);       // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
            break;
          default:
            lk = l1;
          }
          if (lk == 18088)          // 'json' '('
          {
            lk = memoized(13, e0);
            if (lk == 0)
            {
              var b0B = b0; var e0B = e0; var l1B = l1;
              var b1B = b1; var e1B = e1; var l2B = l2;
              var b2B = b2; var e2B = e2;
              try
              {
                shiftT(168);        // 'json'
                memoize(13, e0B, -1);
              }
              catch (p1B)
              {
                b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
                b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
                b2 = b2B; e2 = e2B; end = e2B; }}
                memoize(13, e0B, -2);
              }
              lk = -2;
            }
          }
          if (lk == -1
           || lk == 3240            // 'json' EQName^Token
           || lk == 4264            // 'json' IntegerLiteral
           || lk == 4776            // 'json' DecimalLiteral
           || lk == 5288            // 'json' DoubleLiteral
           || lk == 5800            // 'json' StringLiteral
           || lk == 16040           // 'json' '$'
           || lk == 16552           // 'json' '$$'
           || lk == 17064           // 'json' '%'
           || lk == 18600           // 'json' '(#'
           || lk == 21160           // 'json' '+'
           || lk == 22184           // 'json' '-'
           || lk == 24232           // 'json' '/'
           || lk == 24744           // 'json' '//'
           || lk == 28328           // 'json' '<'
           || lk == 28840           // 'json' '<!--'
           || lk == 30888           // 'json' '<?'
           || lk == 35496           // 'json' '['
           || lk == 36520           // 'json' 'after'
           || lk == 37544           // 'json' 'allowing'
           || lk == 38056           // 'json' 'ancestor'
           || lk == 38568           // 'json' 'ancestor-or-self'
           || lk == 39080           // 'json' 'and'
           || lk == 40104           // 'json' 'append'
           || lk == 40616           // 'json' 'array'
           || lk == 41128           // 'json' 'as'
           || lk == 41640           // 'json' 'ascending'
           || lk == 42152           // 'json' 'at'
           || lk == 42664           // 'json' 'attribute'
           || lk == 43176           // 'json' 'base-uri'
           || lk == 43688           // 'json' 'before'
           || lk == 44200           // 'json' 'boundary-space'
           || lk == 44712           // 'json' 'break'
           || lk == 45736           // 'json' 'case'
           || lk == 46248           // 'json' 'cast'
           || lk == 46760           // 'json' 'castable'
           || lk == 47272           // 'json' 'catch'
           || lk == 48296           // 'json' 'child'
           || lk == 48808           // 'json' 'collation'
           || lk == 49832           // 'json' 'comment'
           || lk == 50344           // 'json' 'constraint'
           || lk == 50856           // 'json' 'construction'
           || lk == 52392           // 'json' 'context'
           || lk == 52904           // 'json' 'continue'
           || lk == 53416           // 'json' 'copy'
           || lk == 53928           // 'json' 'copy-namespaces'
           || lk == 54440           // 'json' 'count'
           || lk == 54952           // 'json' 'decimal-format'
           || lk == 55976           // 'json' 'declare'
           || lk == 56488           // 'json' 'default'
           || lk == 57000           // 'json' 'delete'
           || lk == 57512           // 'json' 'descendant'
           || lk == 58024           // 'json' 'descendant-or-self'
           || lk == 58536           // 'json' 'descending'
           || lk == 61096           // 'json' 'div'
           || lk == 61608           // 'json' 'document'
           || lk == 62120           // 'json' 'document-node'
           || lk == 62632           // 'json' 'element'
           || lk == 63144           // 'json' 'else'
           || lk == 63656           // 'json' 'empty'
           || lk == 64168           // 'json' 'empty-sequence'
           || lk == 64680           // 'json' 'encoding'
           || lk == 65192           // 'json' 'end'
           || lk == 66216           // 'json' 'eq'
           || lk == 66728           // 'json' 'every'
           || lk == 67752           // 'json' 'except'
           || lk == 68264           // 'json' 'exit'
           || lk == 68776           // 'json' 'external'
           || lk == 69288           // 'json' 'false'
           || lk == 69800           // 'json' 'first'
           || lk == 70312           // 'json' 'following'
           || lk == 70824           // 'json' 'following-sibling'
           || lk == 71336           // 'json' 'for'
           || lk == 72872           // 'json' 'from'
           || lk == 73384           // 'json' 'ft-option'
           || lk == 75432           // 'json' 'function'
           || lk == 75944           // 'json' 'ge'
           || lk == 76968           // 'json' 'group'
           || lk == 77992           // 'json' 'gt'
           || lk == 78504           // 'json' 'idiv'
           || lk == 79016           // 'json' 'if'
           || lk == 79528           // 'json' 'import'
           || lk == 80040           // 'json' 'in'
           || lk == 80552           // 'json' 'index'
           || lk == 82600           // 'json' 'insert'
           || lk == 83112           // 'json' 'instance'
           || lk == 83624           // 'json' 'integrity'
           || lk == 84136           // 'json' 'intersect'
           || lk == 84648           // 'json' 'into'
           || lk == 85160           // 'json' 'is'
           || lk == 85672           // 'json' 'item'
           || lk == 86184           // 'json' 'json'
           || lk == 86696           // 'json' 'json-item'
           || lk == 87208           // 'json' 'jsoniq'
           || lk == 88744           // 'json' 'last'
           || lk == 89256           // 'json' 'lax'
           || lk == 89768           // 'json' 'le'
           || lk == 90792           // 'json' 'let'
           || lk == 91816           // 'json' 'loop'
           || lk == 92840           // 'json' 'lt'
           || lk == 93864           // 'json' 'mod'
           || lk == 94376           // 'json' 'modify'
           || lk == 94888           // 'json' 'module'
           || lk == 95912           // 'json' 'namespace'
           || lk == 96424           // 'json' 'namespace-node'
           || lk == 96936           // 'json' 'ne'
           || lk == 99496           // 'json' 'node'
           || lk == 100008          // 'json' 'nodes'
           || lk == 100520          // 'json' 'not'
           || lk == 101032          // 'json' 'null'
           || lk == 101544          // 'json' 'object'
           || lk == 103592          // 'json' 'only'
           || lk == 104104          // 'json' 'option'
           || lk == 104616          // 'json' 'or'
           || lk == 105128          // 'json' 'order'
           || lk == 105640          // 'json' 'ordered'
           || lk == 106152          // 'json' 'ordering'
           || lk == 107688          // 'json' 'parent'
           || lk == 110760          // 'json' 'preceding'
           || lk == 111272          // 'json' 'preceding-sibling'
           || lk == 112808          // 'json' 'processing-instruction'
           || lk == 113832          // 'json' 'rename'
           || lk == 114344          // 'json' 'replace'
           || lk == 114856          // 'json' 'return'
           || lk == 115368          // 'json' 'returning'
           || lk == 115880          // 'json' 'revalidation'
           || lk == 116904          // 'json' 'satisfies'
           || lk == 117416          // 'json' 'schema'
           || lk == 117928          // 'json' 'schema-attribute'
           || lk == 118440          // 'json' 'schema-element'
           || lk == 118952          // 'json' 'score'
           || lk == 119464          // 'json' 'select'
           || lk == 119976          // 'json' 'self'
           || lk == 122536          // 'json' 'sliding'
           || lk == 123048          // 'json' 'some'
           || lk == 123560          // 'json' 'stable'
           || lk == 124072          // 'json' 'start'
           || lk == 125608          // 'json' 'strict'
           || lk == 126632          // 'json' 'structured-item'
           || lk == 127144          // 'json' 'switch'
           || lk == 127656          // 'json' 'text'
           || lk == 129704          // 'json' 'to'
           || lk == 130216          // 'json' 'treat'
           || lk == 130728          // 'json' 'true'
           || lk == 131240          // 'json' 'try'
           || lk == 131752          // 'json' 'tumbling'
           || lk == 132264          // 'json' 'type'
           || lk == 132776          // 'json' 'typeswitch'
           || lk == 133288          // 'json' 'union'
           || lk == 134312          // 'json' 'unordered'
           || lk == 134824          // 'json' 'updating'
           || lk == 136360          // 'json' 'validate'
           || lk == 136872          // 'json' 'value'
           || lk == 137384          // 'json' 'variable'
           || lk == 137896          // 'json' 'version'
           || lk == 139432          // 'json' 'where'
           || lk == 139944          // 'json' 'while'
           || lk == 141480          // 'json' 'with'
           || lk == 144040          // 'json' '{'
           || lk == 145064)         // 'json' '{|'
          {
            shiftT(168);            // 'json'
          }
          lookahead1W(267);         // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
          try_ExprSingle();
          shiftT(165);              // 'into'
          lookahead1W(267);         // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
          try_ExprSingle();
          switch (l1)
          {
          case 82:                  // 'at'
            lookahead2W(72);        // S^WS | '(:' | 'position'
            break;
          default:
            lk = l1;
          }
          if (lk == 110162)         // 'at' 'position'
          {
            lk = memoized(14, e0);
            if (lk == 0)
            {
              var b0B = b0; var e0B = e0; var l1B = l1;
              var b1B = b1; var e1B = e1; var l2B = l2;
              var b2B = b2; var e2B = e2;
              try
              {
                shiftT(82);         // 'at'
                lookahead1W(72);    // S^WS | '(:' | 'position'
                shiftT(215);        // 'position'
                lookahead1W(267);   // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
                try_ExprSingle();
                memoize(14, e0B, -1);
              }
              catch (p1B)
              {
                b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
                b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
                b2 = b2B; e2 = e2B; end = e2B; }}
                memoize(14, e0B, -2);
              }
              lk = -2;
            }
          }
          if (lk == -1)
          {
            shiftT(82);             // 'at'
            lookahead1W(72);        // S^WS | '(:' | 'position'
            shiftT(215);            // 'position'
            lookahead1W(267);       // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
            try_ExprSingle();
          }
          lk = -1;
        }
        catch (p1A)
        {
          lk = -2;
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(12, e0, lk);
      }
    }
    switch (lk)
    {
    case -1:
      shift(161);                   // 'insert'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 168:                     // 'json'
        lookahead2W(269);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      default:
        lk = l1;
      }
      if (lk == 18088)              // 'json' '('
      {
        lk = memoized(13, e0);
        if (lk == 0)
        {
          var b0B = b0; var e0B = e0; var l1B = l1;
          var b1B = b1; var e1B = e1; var l2B = l2;
          var b2B = b2; var e2B = e2;
          try
          {
            shiftT(168);            // 'json'
            lk = -1;
          }
          catch (p1B)
          {
            lk = -2;
          }
          b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
          b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
          b2 = b2B; e2 = e2B; end = e2B; }}
          memoize(13, e0, lk);
        }
      }
      if (lk == -1
       || lk == 3240                // 'json' EQName^Token
       || lk == 4264                // 'json' IntegerLiteral
       || lk == 4776                // 'json' DecimalLiteral
       || lk == 5288                // 'json' DoubleLiteral
       || lk == 5800                // 'json' StringLiteral
       || lk == 16040               // 'json' '$'
       || lk == 16552               // 'json' '$$'
       || lk == 17064               // 'json' '%'
       || lk == 18600               // 'json' '(#'
       || lk == 21160               // 'json' '+'
       || lk == 22184               // 'json' '-'
       || lk == 24232               // 'json' '/'
       || lk == 24744               // 'json' '//'
       || lk == 28328               // 'json' '<'
       || lk == 28840               // 'json' '<!--'
       || lk == 30888               // 'json' '<?'
       || lk == 35496               // 'json' '['
       || lk == 36520               // 'json' 'after'
       || lk == 37544               // 'json' 'allowing'
       || lk == 38056               // 'json' 'ancestor'
       || lk == 38568               // 'json' 'ancestor-or-self'
       || lk == 39080               // 'json' 'and'
       || lk == 40104               // 'json' 'append'
       || lk == 40616               // 'json' 'array'
       || lk == 41128               // 'json' 'as'
       || lk == 41640               // 'json' 'ascending'
       || lk == 42152               // 'json' 'at'
       || lk == 42664               // 'json' 'attribute'
       || lk == 43176               // 'json' 'base-uri'
       || lk == 43688               // 'json' 'before'
       || lk == 44200               // 'json' 'boundary-space'
       || lk == 44712               // 'json' 'break'
       || lk == 45736               // 'json' 'case'
       || lk == 46248               // 'json' 'cast'
       || lk == 46760               // 'json' 'castable'
       || lk == 47272               // 'json' 'catch'
       || lk == 48296               // 'json' 'child'
       || lk == 48808               // 'json' 'collation'
       || lk == 49832               // 'json' 'comment'
       || lk == 50344               // 'json' 'constraint'
       || lk == 50856               // 'json' 'construction'
       || lk == 52392               // 'json' 'context'
       || lk == 52904               // 'json' 'continue'
       || lk == 53416               // 'json' 'copy'
       || lk == 53928               // 'json' 'copy-namespaces'
       || lk == 54440               // 'json' 'count'
       || lk == 54952               // 'json' 'decimal-format'
       || lk == 55976               // 'json' 'declare'
       || lk == 56488               // 'json' 'default'
       || lk == 57000               // 'json' 'delete'
       || lk == 57512               // 'json' 'descendant'
       || lk == 58024               // 'json' 'descendant-or-self'
       || lk == 58536               // 'json' 'descending'
       || lk == 61096               // 'json' 'div'
       || lk == 61608               // 'json' 'document'
       || lk == 62120               // 'json' 'document-node'
       || lk == 62632               // 'json' 'element'
       || lk == 63144               // 'json' 'else'
       || lk == 63656               // 'json' 'empty'
       || lk == 64168               // 'json' 'empty-sequence'
       || lk == 64680               // 'json' 'encoding'
       || lk == 65192               // 'json' 'end'
       || lk == 66216               // 'json' 'eq'
       || lk == 66728               // 'json' 'every'
       || lk == 67752               // 'json' 'except'
       || lk == 68264               // 'json' 'exit'
       || lk == 68776               // 'json' 'external'
       || lk == 69288               // 'json' 'false'
       || lk == 69800               // 'json' 'first'
       || lk == 70312               // 'json' 'following'
       || lk == 70824               // 'json' 'following-sibling'
       || lk == 71336               // 'json' 'for'
       || lk == 72872               // 'json' 'from'
       || lk == 73384               // 'json' 'ft-option'
       || lk == 75432               // 'json' 'function'
       || lk == 75944               // 'json' 'ge'
       || lk == 76968               // 'json' 'group'
       || lk == 77992               // 'json' 'gt'
       || lk == 78504               // 'json' 'idiv'
       || lk == 79016               // 'json' 'if'
       || lk == 79528               // 'json' 'import'
       || lk == 80040               // 'json' 'in'
       || lk == 80552               // 'json' 'index'
       || lk == 82600               // 'json' 'insert'
       || lk == 83112               // 'json' 'instance'
       || lk == 83624               // 'json' 'integrity'
       || lk == 84136               // 'json' 'intersect'
       || lk == 84648               // 'json' 'into'
       || lk == 85160               // 'json' 'is'
       || lk == 85672               // 'json' 'item'
       || lk == 86184               // 'json' 'json'
       || lk == 86696               // 'json' 'json-item'
       || lk == 87208               // 'json' 'jsoniq'
       || lk == 88744               // 'json' 'last'
       || lk == 89256               // 'json' 'lax'
       || lk == 89768               // 'json' 'le'
       || lk == 90792               // 'json' 'let'
       || lk == 91816               // 'json' 'loop'
       || lk == 92840               // 'json' 'lt'
       || lk == 93864               // 'json' 'mod'
       || lk == 94376               // 'json' 'modify'
       || lk == 94888               // 'json' 'module'
       || lk == 95912               // 'json' 'namespace'
       || lk == 96424               // 'json' 'namespace-node'
       || lk == 96936               // 'json' 'ne'
       || lk == 99496               // 'json' 'node'
       || lk == 100008              // 'json' 'nodes'
       || lk == 100520              // 'json' 'not'
       || lk == 101032              // 'json' 'null'
       || lk == 101544              // 'json' 'object'
       || lk == 103592              // 'json' 'only'
       || lk == 104104              // 'json' 'option'
       || lk == 104616              // 'json' 'or'
       || lk == 105128              // 'json' 'order'
       || lk == 105640              // 'json' 'ordered'
       || lk == 106152              // 'json' 'ordering'
       || lk == 107688              // 'json' 'parent'
       || lk == 110760              // 'json' 'preceding'
       || lk == 111272              // 'json' 'preceding-sibling'
       || lk == 112808              // 'json' 'processing-instruction'
       || lk == 113832              // 'json' 'rename'
       || lk == 114344              // 'json' 'replace'
       || lk == 114856              // 'json' 'return'
       || lk == 115368              // 'json' 'returning'
       || lk == 115880              // 'json' 'revalidation'
       || lk == 116904              // 'json' 'satisfies'
       || lk == 117416              // 'json' 'schema'
       || lk == 117928              // 'json' 'schema-attribute'
       || lk == 118440              // 'json' 'schema-element'
       || lk == 118952              // 'json' 'score'
       || lk == 119464              // 'json' 'select'
       || lk == 119976              // 'json' 'self'
       || lk == 122536              // 'json' 'sliding'
       || lk == 123048              // 'json' 'some'
       || lk == 123560              // 'json' 'stable'
       || lk == 124072              // 'json' 'start'
       || lk == 125608              // 'json' 'strict'
       || lk == 126632              // 'json' 'structured-item'
       || lk == 127144              // 'json' 'switch'
       || lk == 127656              // 'json' 'text'
       || lk == 129704              // 'json' 'to'
       || lk == 130216              // 'json' 'treat'
       || lk == 130728              // 'json' 'true'
       || lk == 131240              // 'json' 'try'
       || lk == 131752              // 'json' 'tumbling'
       || lk == 132264              // 'json' 'type'
       || lk == 132776              // 'json' 'typeswitch'
       || lk == 133288              // 'json' 'union'
       || lk == 134312              // 'json' 'unordered'
       || lk == 134824              // 'json' 'updating'
       || lk == 136360              // 'json' 'validate'
       || lk == 136872              // 'json' 'value'
       || lk == 137384              // 'json' 'variable'
       || lk == 137896              // 'json' 'version'
       || lk == 139432              // 'json' 'where'
       || lk == 139944              // 'json' 'while'
       || lk == 141480              // 'json' 'with'
       || lk == 144040              // 'json' '{'
       || lk == 145064)             // 'json' '{|'
      {
        shift(168);                 // 'json'
      }
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_ExprSingle();
      shift(165);                   // 'into'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_ExprSingle();
      switch (l1)
      {
      case 82:                      // 'at'
        lookahead2W(72);            // S^WS | '(:' | 'position'
        break;
      default:
        lk = l1;
      }
      if (lk == 110162)             // 'at' 'position'
      {
        lk = memoized(14, e0);
        if (lk == 0)
        {
          var b0B = b0; var e0B = e0; var l1B = l1;
          var b1B = b1; var e1B = e1; var l2B = l2;
          var b2B = b2; var e2B = e2;
          try
          {
            shiftT(82);             // 'at'
            lookahead1W(72);        // S^WS | '(:' | 'position'
            shiftT(215);            // 'position'
            lookahead1W(267);       // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
            try_ExprSingle();
            lk = -1;
          }
          catch (p1B)
          {
            lk = -2;
          }
          b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
          b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
          b2 = b2B; e2 = e2B; end = e2B; }}
          memoize(14, e0, lk);
        }
      }
      if (lk == -1)
      {
        shift(82);                  // 'at'
        lookahead1W(72);            // S^WS | '(:' | 'position'
        shift(215);                 // 'position'
        lookahead1W(267);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        whitespace();
        parse_ExprSingle();
      }
      break;
    default:
      shift(161);                   // 'insert'
      lookahead1W(268);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 168:                     // 'json'
        lookahead2W(282);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      default:
        lk = l1;
      }
      if (lk == 18088)              // 'json' '('
      {
        lk = memoized(15, e0);
        if (lk == 0)
        {
          var b0B = b0; var e0B = e0; var l1B = l1;
          var b1B = b1; var e1B = e1; var l2B = l2;
          var b2B = b2; var e2B = e2;
          try
          {
            shiftT(168);            // 'json'
            lk = -1;
          }
          catch (p1B)
          {
            lk = -2;
          }
          b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
          b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
          b2 = b2B; e2 = e2B; end = e2B; }}
          memoize(15, e0, lk);
        }
      }
      if (lk == -1
       || lk == 3240                // 'json' EQName^Token
       || lk == 4264                // 'json' IntegerLiteral
       || lk == 4776                // 'json' DecimalLiteral
       || lk == 5288                // 'json' DoubleLiteral
       || lk == 5800                // 'json' StringLiteral
       || lk == 9896                // 'json' NCName^Token
       || lk == 16040               // 'json' '$'
       || lk == 16552               // 'json' '$$'
       || lk == 17064               // 'json' '%'
       || lk == 18600               // 'json' '(#'
       || lk == 21160               // 'json' '+'
       || lk == 22184               // 'json' '-'
       || lk == 24232               // 'json' '/'
       || lk == 24744               // 'json' '//'
       || lk == 28328               // 'json' '<'
       || lk == 28840               // 'json' '<!--'
       || lk == 30888               // 'json' '<?'
       || lk == 35496               // 'json' '['
       || lk == 36520               // 'json' 'after'
       || lk == 37544               // 'json' 'allowing'
       || lk == 38056               // 'json' 'ancestor'
       || lk == 38568               // 'json' 'ancestor-or-self'
       || lk == 39080               // 'json' 'and'
       || lk == 40104               // 'json' 'append'
       || lk == 40616               // 'json' 'array'
       || lk == 41128               // 'json' 'as'
       || lk == 41640               // 'json' 'ascending'
       || lk == 42152               // 'json' 'at'
       || lk == 42664               // 'json' 'attribute'
       || lk == 43176               // 'json' 'base-uri'
       || lk == 43688               // 'json' 'before'
       || lk == 44200               // 'json' 'boundary-space'
       || lk == 44712               // 'json' 'break'
       || lk == 45736               // 'json' 'case'
       || lk == 46248               // 'json' 'cast'
       || lk == 46760               // 'json' 'castable'
       || lk == 47272               // 'json' 'catch'
       || lk == 48296               // 'json' 'child'
       || lk == 48808               // 'json' 'collation'
       || lk == 49832               // 'json' 'comment'
       || lk == 50344               // 'json' 'constraint'
       || lk == 50856               // 'json' 'construction'
       || lk == 52392               // 'json' 'context'
       || lk == 52904               // 'json' 'continue'
       || lk == 53416               // 'json' 'copy'
       || lk == 53928               // 'json' 'copy-namespaces'
       || lk == 54440               // 'json' 'count'
       || lk == 54952               // 'json' 'decimal-format'
       || lk == 55976               // 'json' 'declare'
       || lk == 56488               // 'json' 'default'
       || lk == 57000               // 'json' 'delete'
       || lk == 57512               // 'json' 'descendant'
       || lk == 58024               // 'json' 'descendant-or-self'
       || lk == 58536               // 'json' 'descending'
       || lk == 61096               // 'json' 'div'
       || lk == 61608               // 'json' 'document'
       || lk == 62120               // 'json' 'document-node'
       || lk == 62632               // 'json' 'element'
       || lk == 63144               // 'json' 'else'
       || lk == 63656               // 'json' 'empty'
       || lk == 64168               // 'json' 'empty-sequence'
       || lk == 64680               // 'json' 'encoding'
       || lk == 65192               // 'json' 'end'
       || lk == 66216               // 'json' 'eq'
       || lk == 66728               // 'json' 'every'
       || lk == 67752               // 'json' 'except'
       || lk == 68264               // 'json' 'exit'
       || lk == 68776               // 'json' 'external'
       || lk == 69288               // 'json' 'false'
       || lk == 69800               // 'json' 'first'
       || lk == 70312               // 'json' 'following'
       || lk == 70824               // 'json' 'following-sibling'
       || lk == 71336               // 'json' 'for'
       || lk == 72872               // 'json' 'from'
       || lk == 73384               // 'json' 'ft-option'
       || lk == 75432               // 'json' 'function'
       || lk == 75944               // 'json' 'ge'
       || lk == 76968               // 'json' 'group'
       || lk == 77992               // 'json' 'gt'
       || lk == 78504               // 'json' 'idiv'
       || lk == 79016               // 'json' 'if'
       || lk == 79528               // 'json' 'import'
       || lk == 80040               // 'json' 'in'
       || lk == 80552               // 'json' 'index'
       || lk == 82600               // 'json' 'insert'
       || lk == 83112               // 'json' 'instance'
       || lk == 83624               // 'json' 'integrity'
       || lk == 84136               // 'json' 'intersect'
       || lk == 84648               // 'json' 'into'
       || lk == 85160               // 'json' 'is'
       || lk == 85672               // 'json' 'item'
       || lk == 86184               // 'json' 'json'
       || lk == 86696               // 'json' 'json-item'
       || lk == 87208               // 'json' 'jsoniq'
       || lk == 88744               // 'json' 'last'
       || lk == 89256               // 'json' 'lax'
       || lk == 89768               // 'json' 'le'
       || lk == 90792               // 'json' 'let'
       || lk == 91816               // 'json' 'loop'
       || lk == 92840               // 'json' 'lt'
       || lk == 93864               // 'json' 'mod'
       || lk == 94376               // 'json' 'modify'
       || lk == 94888               // 'json' 'module'
       || lk == 95912               // 'json' 'namespace'
       || lk == 96424               // 'json' 'namespace-node'
       || lk == 96936               // 'json' 'ne'
       || lk == 99496               // 'json' 'node'
       || lk == 100008              // 'json' 'nodes'
       || lk == 100520              // 'json' 'not'
       || lk == 101032              // 'json' 'null'
       || lk == 101544              // 'json' 'object'
       || lk == 103592              // 'json' 'only'
       || lk == 104104              // 'json' 'option'
       || lk == 104616              // 'json' 'or'
       || lk == 105128              // 'json' 'order'
       || lk == 105640              // 'json' 'ordered'
       || lk == 106152              // 'json' 'ordering'
       || lk == 107688              // 'json' 'parent'
       || lk == 110760              // 'json' 'preceding'
       || lk == 111272              // 'json' 'preceding-sibling'
       || lk == 112808              // 'json' 'processing-instruction'
       || lk == 113832              // 'json' 'rename'
       || lk == 114344              // 'json' 'replace'
       || lk == 114856              // 'json' 'return'
       || lk == 115368              // 'json' 'returning'
       || lk == 115880              // 'json' 'revalidation'
       || lk == 116904              // 'json' 'satisfies'
       || lk == 117416              // 'json' 'schema'
       || lk == 117928              // 'json' 'schema-attribute'
       || lk == 118440              // 'json' 'schema-element'
       || lk == 118952              // 'json' 'score'
       || lk == 119464              // 'json' 'select'
       || lk == 119976              // 'json' 'self'
       || lk == 122536              // 'json' 'sliding'
       || lk == 123048              // 'json' 'some'
       || lk == 123560              // 'json' 'stable'
       || lk == 124072              // 'json' 'start'
       || lk == 125608              // 'json' 'strict'
       || lk == 126632              // 'json' 'structured-item'
       || lk == 127144              // 'json' 'switch'
       || lk == 127656              // 'json' 'text'
       || lk == 129704              // 'json' 'to'
       || lk == 130216              // 'json' 'treat'
       || lk == 130728              // 'json' 'true'
       || lk == 131240              // 'json' 'try'
       || lk == 131752              // 'json' 'tumbling'
       || lk == 132264              // 'json' 'type'
       || lk == 132776              // 'json' 'typeswitch'
       || lk == 133288              // 'json' 'union'
       || lk == 134312              // 'json' 'unordered'
       || lk == 134824              // 'json' 'updating'
       || lk == 136360              // 'json' 'validate'
       || lk == 136872              // 'json' 'value'
       || lk == 137384              // 'json' 'variable'
       || lk == 137896              // 'json' 'version'
       || lk == 139432              // 'json' 'where'
       || lk == 139944              // 'json' 'while'
       || lk == 141480              // 'json' 'with'
       || lk == 144040              // 'json' '{'
       || lk == 145064)             // 'json' '{|'
      {
        shift(168);                 // 'json'
      }
      lookahead1W(268);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_PairConstructorList();
      shift(165);                   // 'into'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_ExprSingle();
    }
    eventHandler.endNonterminal("JSONInsertExpr", e0);
  }

  function try_JSONInsertExpr()
  {
    switch (l1)
    {
    case 161:                       // 'insert'
      lookahead2W(268);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk != 9889)                 // 'insert' NCName^Token
    {
      lk = memoized(12, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(161);              // 'insert'
          lookahead1W(267);         // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
          switch (l1)
          {
          case 168:                 // 'json'
            lookahead2W(269);       // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
            break;
          default:
            lk = l1;
          }
          if (lk == 18088)          // 'json' '('
          {
            lk = memoized(13, e0);
            if (lk == 0)
            {
              var b0B = b0; var e0B = e0; var l1B = l1;
              var b1B = b1; var e1B = e1; var l2B = l2;
              var b2B = b2; var e2B = e2;
              try
              {
                shiftT(168);        // 'json'
                memoize(13, e0B, -1);
              }
              catch (p1B)
              {
                b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
                b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
                b2 = b2B; e2 = e2B; end = e2B; }}
                memoize(13, e0B, -2);
              }
              lk = -2;
            }
          }
          if (lk == -1
           || lk == 3240            // 'json' EQName^Token
           || lk == 4264            // 'json' IntegerLiteral
           || lk == 4776            // 'json' DecimalLiteral
           || lk == 5288            // 'json' DoubleLiteral
           || lk == 5800            // 'json' StringLiteral
           || lk == 16040           // 'json' '$'
           || lk == 16552           // 'json' '$$'
           || lk == 17064           // 'json' '%'
           || lk == 18600           // 'json' '(#'
           || lk == 21160           // 'json' '+'
           || lk == 22184           // 'json' '-'
           || lk == 24232           // 'json' '/'
           || lk == 24744           // 'json' '//'
           || lk == 28328           // 'json' '<'
           || lk == 28840           // 'json' '<!--'
           || lk == 30888           // 'json' '<?'
           || lk == 35496           // 'json' '['
           || lk == 36520           // 'json' 'after'
           || lk == 37544           // 'json' 'allowing'
           || lk == 38056           // 'json' 'ancestor'
           || lk == 38568           // 'json' 'ancestor-or-self'
           || lk == 39080           // 'json' 'and'
           || lk == 40104           // 'json' 'append'
           || lk == 40616           // 'json' 'array'
           || lk == 41128           // 'json' 'as'
           || lk == 41640           // 'json' 'ascending'
           || lk == 42152           // 'json' 'at'
           || lk == 42664           // 'json' 'attribute'
           || lk == 43176           // 'json' 'base-uri'
           || lk == 43688           // 'json' 'before'
           || lk == 44200           // 'json' 'boundary-space'
           || lk == 44712           // 'json' 'break'
           || lk == 45736           // 'json' 'case'
           || lk == 46248           // 'json' 'cast'
           || lk == 46760           // 'json' 'castable'
           || lk == 47272           // 'json' 'catch'
           || lk == 48296           // 'json' 'child'
           || lk == 48808           // 'json' 'collation'
           || lk == 49832           // 'json' 'comment'
           || lk == 50344           // 'json' 'constraint'
           || lk == 50856           // 'json' 'construction'
           || lk == 52392           // 'json' 'context'
           || lk == 52904           // 'json' 'continue'
           || lk == 53416           // 'json' 'copy'
           || lk == 53928           // 'json' 'copy-namespaces'
           || lk == 54440           // 'json' 'count'
           || lk == 54952           // 'json' 'decimal-format'
           || lk == 55976           // 'json' 'declare'
           || lk == 56488           // 'json' 'default'
           || lk == 57000           // 'json' 'delete'
           || lk == 57512           // 'json' 'descendant'
           || lk == 58024           // 'json' 'descendant-or-self'
           || lk == 58536           // 'json' 'descending'
           || lk == 61096           // 'json' 'div'
           || lk == 61608           // 'json' 'document'
           || lk == 62120           // 'json' 'document-node'
           || lk == 62632           // 'json' 'element'
           || lk == 63144           // 'json' 'else'
           || lk == 63656           // 'json' 'empty'
           || lk == 64168           // 'json' 'empty-sequence'
           || lk == 64680           // 'json' 'encoding'
           || lk == 65192           // 'json' 'end'
           || lk == 66216           // 'json' 'eq'
           || lk == 66728           // 'json' 'every'
           || lk == 67752           // 'json' 'except'
           || lk == 68264           // 'json' 'exit'
           || lk == 68776           // 'json' 'external'
           || lk == 69288           // 'json' 'false'
           || lk == 69800           // 'json' 'first'
           || lk == 70312           // 'json' 'following'
           || lk == 70824           // 'json' 'following-sibling'
           || lk == 71336           // 'json' 'for'
           || lk == 72872           // 'json' 'from'
           || lk == 73384           // 'json' 'ft-option'
           || lk == 75432           // 'json' 'function'
           || lk == 75944           // 'json' 'ge'
           || lk == 76968           // 'json' 'group'
           || lk == 77992           // 'json' 'gt'
           || lk == 78504           // 'json' 'idiv'
           || lk == 79016           // 'json' 'if'
           || lk == 79528           // 'json' 'import'
           || lk == 80040           // 'json' 'in'
           || lk == 80552           // 'json' 'index'
           || lk == 82600           // 'json' 'insert'
           || lk == 83112           // 'json' 'instance'
           || lk == 83624           // 'json' 'integrity'
           || lk == 84136           // 'json' 'intersect'
           || lk == 84648           // 'json' 'into'
           || lk == 85160           // 'json' 'is'
           || lk == 85672           // 'json' 'item'
           || lk == 86184           // 'json' 'json'
           || lk == 86696           // 'json' 'json-item'
           || lk == 87208           // 'json' 'jsoniq'
           || lk == 88744           // 'json' 'last'
           || lk == 89256           // 'json' 'lax'
           || lk == 89768           // 'json' 'le'
           || lk == 90792           // 'json' 'let'
           || lk == 91816           // 'json' 'loop'
           || lk == 92840           // 'json' 'lt'
           || lk == 93864           // 'json' 'mod'
           || lk == 94376           // 'json' 'modify'
           || lk == 94888           // 'json' 'module'
           || lk == 95912           // 'json' 'namespace'
           || lk == 96424           // 'json' 'namespace-node'
           || lk == 96936           // 'json' 'ne'
           || lk == 99496           // 'json' 'node'
           || lk == 100008          // 'json' 'nodes'
           || lk == 100520          // 'json' 'not'
           || lk == 101032          // 'json' 'null'
           || lk == 101544          // 'json' 'object'
           || lk == 103592          // 'json' 'only'
           || lk == 104104          // 'json' 'option'
           || lk == 104616          // 'json' 'or'
           || lk == 105128          // 'json' 'order'
           || lk == 105640          // 'json' 'ordered'
           || lk == 106152          // 'json' 'ordering'
           || lk == 107688          // 'json' 'parent'
           || lk == 110760          // 'json' 'preceding'
           || lk == 111272          // 'json' 'preceding-sibling'
           || lk == 112808          // 'json' 'processing-instruction'
           || lk == 113832          // 'json' 'rename'
           || lk == 114344          // 'json' 'replace'
           || lk == 114856          // 'json' 'return'
           || lk == 115368          // 'json' 'returning'
           || lk == 115880          // 'json' 'revalidation'
           || lk == 116904          // 'json' 'satisfies'
           || lk == 117416          // 'json' 'schema'
           || lk == 117928          // 'json' 'schema-attribute'
           || lk == 118440          // 'json' 'schema-element'
           || lk == 118952          // 'json' 'score'
           || lk == 119464          // 'json' 'select'
           || lk == 119976          // 'json' 'self'
           || lk == 122536          // 'json' 'sliding'
           || lk == 123048          // 'json' 'some'
           || lk == 123560          // 'json' 'stable'
           || lk == 124072          // 'json' 'start'
           || lk == 125608          // 'json' 'strict'
           || lk == 126632          // 'json' 'structured-item'
           || lk == 127144          // 'json' 'switch'
           || lk == 127656          // 'json' 'text'
           || lk == 129704          // 'json' 'to'
           || lk == 130216          // 'json' 'treat'
           || lk == 130728          // 'json' 'true'
           || lk == 131240          // 'json' 'try'
           || lk == 131752          // 'json' 'tumbling'
           || lk == 132264          // 'json' 'type'
           || lk == 132776          // 'json' 'typeswitch'
           || lk == 133288          // 'json' 'union'
           || lk == 134312          // 'json' 'unordered'
           || lk == 134824          // 'json' 'updating'
           || lk == 136360          // 'json' 'validate'
           || lk == 136872          // 'json' 'value'
           || lk == 137384          // 'json' 'variable'
           || lk == 137896          // 'json' 'version'
           || lk == 139432          // 'json' 'where'
           || lk == 139944          // 'json' 'while'
           || lk == 141480          // 'json' 'with'
           || lk == 144040          // 'json' '{'
           || lk == 145064)         // 'json' '{|'
          {
            shiftT(168);            // 'json'
          }
          lookahead1W(267);         // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
          try_ExprSingle();
          shiftT(165);              // 'into'
          lookahead1W(267);         // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
          try_ExprSingle();
          switch (l1)
          {
          case 82:                  // 'at'
            lookahead2W(72);        // S^WS | '(:' | 'position'
            break;
          default:
            lk = l1;
          }
          if (lk == 110162)         // 'at' 'position'
          {
            lk = memoized(14, e0);
            if (lk == 0)
            {
              var b0B = b0; var e0B = e0; var l1B = l1;
              var b1B = b1; var e1B = e1; var l2B = l2;
              var b2B = b2; var e2B = e2;
              try
              {
                shiftT(82);         // 'at'
                lookahead1W(72);    // S^WS | '(:' | 'position'
                shiftT(215);        // 'position'
                lookahead1W(267);   // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
                try_ExprSingle();
                memoize(14, e0B, -1);
              }
              catch (p1B)
              {
                b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
                b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
                b2 = b2B; e2 = e2B; end = e2B; }}
                memoize(14, e0B, -2);
              }
              lk = -2;
            }
          }
          if (lk == -1)
          {
            shiftT(82);             // 'at'
            lookahead1W(72);        // S^WS | '(:' | 'position'
            shiftT(215);            // 'position'
            lookahead1W(267);       // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
            try_ExprSingle();
          }
          memoize(12, e0A, -1);
          lk = -3;
        }
        catch (p1A)
        {
          lk = -2;
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(12, e0A, -2);
        }
      }
    }
    switch (lk)
    {
    case -1:
      shiftT(161);                  // 'insert'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 168:                     // 'json'
        lookahead2W(269);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      default:
        lk = l1;
      }
      if (lk == 18088)              // 'json' '('
      {
        lk = memoized(13, e0);
        if (lk == 0)
        {
          var b0B = b0; var e0B = e0; var l1B = l1;
          var b1B = b1; var e1B = e1; var l2B = l2;
          var b2B = b2; var e2B = e2;
          try
          {
            shiftT(168);            // 'json'
            memoize(13, e0B, -1);
          }
          catch (p1B)
          {
            b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
            b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
            b2 = b2B; e2 = e2B; end = e2B; }}
            memoize(13, e0B, -2);
          }
          lk = -2;
        }
      }
      if (lk == -1
       || lk == 3240                // 'json' EQName^Token
       || lk == 4264                // 'json' IntegerLiteral
       || lk == 4776                // 'json' DecimalLiteral
       || lk == 5288                // 'json' DoubleLiteral
       || lk == 5800                // 'json' StringLiteral
       || lk == 16040               // 'json' '$'
       || lk == 16552               // 'json' '$$'
       || lk == 17064               // 'json' '%'
       || lk == 18600               // 'json' '(#'
       || lk == 21160               // 'json' '+'
       || lk == 22184               // 'json' '-'
       || lk == 24232               // 'json' '/'
       || lk == 24744               // 'json' '//'
       || lk == 28328               // 'json' '<'
       || lk == 28840               // 'json' '<!--'
       || lk == 30888               // 'json' '<?'
       || lk == 35496               // 'json' '['
       || lk == 36520               // 'json' 'after'
       || lk == 37544               // 'json' 'allowing'
       || lk == 38056               // 'json' 'ancestor'
       || lk == 38568               // 'json' 'ancestor-or-self'
       || lk == 39080               // 'json' 'and'
       || lk == 40104               // 'json' 'append'
       || lk == 40616               // 'json' 'array'
       || lk == 41128               // 'json' 'as'
       || lk == 41640               // 'json' 'ascending'
       || lk == 42152               // 'json' 'at'
       || lk == 42664               // 'json' 'attribute'
       || lk == 43176               // 'json' 'base-uri'
       || lk == 43688               // 'json' 'before'
       || lk == 44200               // 'json' 'boundary-space'
       || lk == 44712               // 'json' 'break'
       || lk == 45736               // 'json' 'case'
       || lk == 46248               // 'json' 'cast'
       || lk == 46760               // 'json' 'castable'
       || lk == 47272               // 'json' 'catch'
       || lk == 48296               // 'json' 'child'
       || lk == 48808               // 'json' 'collation'
       || lk == 49832               // 'json' 'comment'
       || lk == 50344               // 'json' 'constraint'
       || lk == 50856               // 'json' 'construction'
       || lk == 52392               // 'json' 'context'
       || lk == 52904               // 'json' 'continue'
       || lk == 53416               // 'json' 'copy'
       || lk == 53928               // 'json' 'copy-namespaces'
       || lk == 54440               // 'json' 'count'
       || lk == 54952               // 'json' 'decimal-format'
       || lk == 55976               // 'json' 'declare'
       || lk == 56488               // 'json' 'default'
       || lk == 57000               // 'json' 'delete'
       || lk == 57512               // 'json' 'descendant'
       || lk == 58024               // 'json' 'descendant-or-self'
       || lk == 58536               // 'json' 'descending'
       || lk == 61096               // 'json' 'div'
       || lk == 61608               // 'json' 'document'
       || lk == 62120               // 'json' 'document-node'
       || lk == 62632               // 'json' 'element'
       || lk == 63144               // 'json' 'else'
       || lk == 63656               // 'json' 'empty'
       || lk == 64168               // 'json' 'empty-sequence'
       || lk == 64680               // 'json' 'encoding'
       || lk == 65192               // 'json' 'end'
       || lk == 66216               // 'json' 'eq'
       || lk == 66728               // 'json' 'every'
       || lk == 67752               // 'json' 'except'
       || lk == 68264               // 'json' 'exit'
       || lk == 68776               // 'json' 'external'
       || lk == 69288               // 'json' 'false'
       || lk == 69800               // 'json' 'first'
       || lk == 70312               // 'json' 'following'
       || lk == 70824               // 'json' 'following-sibling'
       || lk == 71336               // 'json' 'for'
       || lk == 72872               // 'json' 'from'
       || lk == 73384               // 'json' 'ft-option'
       || lk == 75432               // 'json' 'function'
       || lk == 75944               // 'json' 'ge'
       || lk == 76968               // 'json' 'group'
       || lk == 77992               // 'json' 'gt'
       || lk == 78504               // 'json' 'idiv'
       || lk == 79016               // 'json' 'if'
       || lk == 79528               // 'json' 'import'
       || lk == 80040               // 'json' 'in'
       || lk == 80552               // 'json' 'index'
       || lk == 82600               // 'json' 'insert'
       || lk == 83112               // 'json' 'instance'
       || lk == 83624               // 'json' 'integrity'
       || lk == 84136               // 'json' 'intersect'
       || lk == 84648               // 'json' 'into'
       || lk == 85160               // 'json' 'is'
       || lk == 85672               // 'json' 'item'
       || lk == 86184               // 'json' 'json'
       || lk == 86696               // 'json' 'json-item'
       || lk == 87208               // 'json' 'jsoniq'
       || lk == 88744               // 'json' 'last'
       || lk == 89256               // 'json' 'lax'
       || lk == 89768               // 'json' 'le'
       || lk == 90792               // 'json' 'let'
       || lk == 91816               // 'json' 'loop'
       || lk == 92840               // 'json' 'lt'
       || lk == 93864               // 'json' 'mod'
       || lk == 94376               // 'json' 'modify'
       || lk == 94888               // 'json' 'module'
       || lk == 95912               // 'json' 'namespace'
       || lk == 96424               // 'json' 'namespace-node'
       || lk == 96936               // 'json' 'ne'
       || lk == 99496               // 'json' 'node'
       || lk == 100008              // 'json' 'nodes'
       || lk == 100520              // 'json' 'not'
       || lk == 101032              // 'json' 'null'
       || lk == 101544              // 'json' 'object'
       || lk == 103592              // 'json' 'only'
       || lk == 104104              // 'json' 'option'
       || lk == 104616              // 'json' 'or'
       || lk == 105128              // 'json' 'order'
       || lk == 105640              // 'json' 'ordered'
       || lk == 106152              // 'json' 'ordering'
       || lk == 107688              // 'json' 'parent'
       || lk == 110760              // 'json' 'preceding'
       || lk == 111272              // 'json' 'preceding-sibling'
       || lk == 112808              // 'json' 'processing-instruction'
       || lk == 113832              // 'json' 'rename'
       || lk == 114344              // 'json' 'replace'
       || lk == 114856              // 'json' 'return'
       || lk == 115368              // 'json' 'returning'
       || lk == 115880              // 'json' 'revalidation'
       || lk == 116904              // 'json' 'satisfies'
       || lk == 117416              // 'json' 'schema'
       || lk == 117928              // 'json' 'schema-attribute'
       || lk == 118440              // 'json' 'schema-element'
       || lk == 118952              // 'json' 'score'
       || lk == 119464              // 'json' 'select'
       || lk == 119976              // 'json' 'self'
       || lk == 122536              // 'json' 'sliding'
       || lk == 123048              // 'json' 'some'
       || lk == 123560              // 'json' 'stable'
       || lk == 124072              // 'json' 'start'
       || lk == 125608              // 'json' 'strict'
       || lk == 126632              // 'json' 'structured-item'
       || lk == 127144              // 'json' 'switch'
       || lk == 127656              // 'json' 'text'
       || lk == 129704              // 'json' 'to'
       || lk == 130216              // 'json' 'treat'
       || lk == 130728              // 'json' 'true'
       || lk == 131240              // 'json' 'try'
       || lk == 131752              // 'json' 'tumbling'
       || lk == 132264              // 'json' 'type'
       || lk == 132776              // 'json' 'typeswitch'
       || lk == 133288              // 'json' 'union'
       || lk == 134312              // 'json' 'unordered'
       || lk == 134824              // 'json' 'updating'
       || lk == 136360              // 'json' 'validate'
       || lk == 136872              // 'json' 'value'
       || lk == 137384              // 'json' 'variable'
       || lk == 137896              // 'json' 'version'
       || lk == 139432              // 'json' 'where'
       || lk == 139944              // 'json' 'while'
       || lk == 141480              // 'json' 'with'
       || lk == 144040              // 'json' '{'
       || lk == 145064)             // 'json' '{|'
      {
        shiftT(168);                // 'json'
      }
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_ExprSingle();
      shiftT(165);                  // 'into'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_ExprSingle();
      switch (l1)
      {
      case 82:                      // 'at'
        lookahead2W(72);            // S^WS | '(:' | 'position'
        break;
      default:
        lk = l1;
      }
      if (lk == 110162)             // 'at' 'position'
      {
        lk = memoized(14, e0);
        if (lk == 0)
        {
          var b0B = b0; var e0B = e0; var l1B = l1;
          var b1B = b1; var e1B = e1; var l2B = l2;
          var b2B = b2; var e2B = e2;
          try
          {
            shiftT(82);             // 'at'
            lookahead1W(72);        // S^WS | '(:' | 'position'
            shiftT(215);            // 'position'
            lookahead1W(267);       // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
            try_ExprSingle();
            memoize(14, e0B, -1);
          }
          catch (p1B)
          {
            b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
            b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
            b2 = b2B; e2 = e2B; end = e2B; }}
            memoize(14, e0B, -2);
          }
          lk = -2;
        }
      }
      if (lk == -1)
      {
        shiftT(82);                 // 'at'
        lookahead1W(72);            // S^WS | '(:' | 'position'
        shiftT(215);                // 'position'
        lookahead1W(267);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        try_ExprSingle();
      }
      break;
    case -3:
      break;
    default:
      shiftT(161);                  // 'insert'
      lookahead1W(268);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      switch (l1)
      {
      case 168:                     // 'json'
        lookahead2W(282);           // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
        break;
      default:
        lk = l1;
      }
      if (lk == 18088)              // 'json' '('
      {
        lk = memoized(15, e0);
        if (lk == 0)
        {
          var b0B = b0; var e0B = e0; var l1B = l1;
          var b1B = b1; var e1B = e1; var l2B = l2;
          var b2B = b2; var e2B = e2;
          try
          {
            shiftT(168);            // 'json'
            memoize(15, e0B, -1);
          }
          catch (p1B)
          {
            b0 = b0B; e0 = e0B; l1 = l1B; if (l1 == 0) {end = e0B;} else {
            b1 = b1B; e1 = e1B; l2 = l2B; if (l2 == 0) {end = e1B;} else {
            b2 = b2B; e2 = e2B; end = e2B; }}
            memoize(15, e0B, -2);
          }
          lk = -2;
        }
      }
      if (lk == -1
       || lk == 3240                // 'json' EQName^Token
       || lk == 4264                // 'json' IntegerLiteral
       || lk == 4776                // 'json' DecimalLiteral
       || lk == 5288                // 'json' DoubleLiteral
       || lk == 5800                // 'json' StringLiteral
       || lk == 9896                // 'json' NCName^Token
       || lk == 16040               // 'json' '$'
       || lk == 16552               // 'json' '$$'
       || lk == 17064               // 'json' '%'
       || lk == 18600               // 'json' '(#'
       || lk == 21160               // 'json' '+'
       || lk == 22184               // 'json' '-'
       || lk == 24232               // 'json' '/'
       || lk == 24744               // 'json' '//'
       || lk == 28328               // 'json' '<'
       || lk == 28840               // 'json' '<!--'
       || lk == 30888               // 'json' '<?'
       || lk == 35496               // 'json' '['
       || lk == 36520               // 'json' 'after'
       || lk == 37544               // 'json' 'allowing'
       || lk == 38056               // 'json' 'ancestor'
       || lk == 38568               // 'json' 'ancestor-or-self'
       || lk == 39080               // 'json' 'and'
       || lk == 40104               // 'json' 'append'
       || lk == 40616               // 'json' 'array'
       || lk == 41128               // 'json' 'as'
       || lk == 41640               // 'json' 'ascending'
       || lk == 42152               // 'json' 'at'
       || lk == 42664               // 'json' 'attribute'
       || lk == 43176               // 'json' 'base-uri'
       || lk == 43688               // 'json' 'before'
       || lk == 44200               // 'json' 'boundary-space'
       || lk == 44712               // 'json' 'break'
       || lk == 45736               // 'json' 'case'
       || lk == 46248               // 'json' 'cast'
       || lk == 46760               // 'json' 'castable'
       || lk == 47272               // 'json' 'catch'
       || lk == 48296               // 'json' 'child'
       || lk == 48808               // 'json' 'collation'
       || lk == 49832               // 'json' 'comment'
       || lk == 50344               // 'json' 'constraint'
       || lk == 50856               // 'json' 'construction'
       || lk == 52392               // 'json' 'context'
       || lk == 52904               // 'json' 'continue'
       || lk == 53416               // 'json' 'copy'
       || lk == 53928               // 'json' 'copy-namespaces'
       || lk == 54440               // 'json' 'count'
       || lk == 54952               // 'json' 'decimal-format'
       || lk == 55976               // 'json' 'declare'
       || lk == 56488               // 'json' 'default'
       || lk == 57000               // 'json' 'delete'
       || lk == 57512               // 'json' 'descendant'
       || lk == 58024               // 'json' 'descendant-or-self'
       || lk == 58536               // 'json' 'descending'
       || lk == 61096               // 'json' 'div'
       || lk == 61608               // 'json' 'document'
       || lk == 62120               // 'json' 'document-node'
       || lk == 62632               // 'json' 'element'
       || lk == 63144               // 'json' 'else'
       || lk == 63656               // 'json' 'empty'
       || lk == 64168               // 'json' 'empty-sequence'
       || lk == 64680               // 'json' 'encoding'
       || lk == 65192               // 'json' 'end'
       || lk == 66216               // 'json' 'eq'
       || lk == 66728               // 'json' 'every'
       || lk == 67752               // 'json' 'except'
       || lk == 68264               // 'json' 'exit'
       || lk == 68776               // 'json' 'external'
       || lk == 69288               // 'json' 'false'
       || lk == 69800               // 'json' 'first'
       || lk == 70312               // 'json' 'following'
       || lk == 70824               // 'json' 'following-sibling'
       || lk == 71336               // 'json' 'for'
       || lk == 72872               // 'json' 'from'
       || lk == 73384               // 'json' 'ft-option'
       || lk == 75432               // 'json' 'function'
       || lk == 75944               // 'json' 'ge'
       || lk == 76968               // 'json' 'group'
       || lk == 77992               // 'json' 'gt'
       || lk == 78504               // 'json' 'idiv'
       || lk == 79016               // 'json' 'if'
       || lk == 79528               // 'json' 'import'
       || lk == 80040               // 'json' 'in'
       || lk == 80552               // 'json' 'index'
       || lk == 82600               // 'json' 'insert'
       || lk == 83112               // 'json' 'instance'
       || lk == 83624               // 'json' 'integrity'
       || lk == 84136               // 'json' 'intersect'
       || lk == 84648               // 'json' 'into'
       || lk == 85160               // 'json' 'is'
       || lk == 85672               // 'json' 'item'
       || lk == 86184               // 'json' 'json'
       || lk == 86696               // 'json' 'json-item'
       || lk == 87208               // 'json' 'jsoniq'
       || lk == 88744               // 'json' 'last'
       || lk == 89256               // 'json' 'lax'
       || lk == 89768               // 'json' 'le'
       || lk == 90792               // 'json' 'let'
       || lk == 91816               // 'json' 'loop'
       || lk == 92840               // 'json' 'lt'
       || lk == 93864               // 'json' 'mod'
       || lk == 94376               // 'json' 'modify'
       || lk == 94888               // 'json' 'module'
       || lk == 95912               // 'json' 'namespace'
       || lk == 96424               // 'json' 'namespace-node'
       || lk == 96936               // 'json' 'ne'
       || lk == 99496               // 'json' 'node'
       || lk == 100008              // 'json' 'nodes'
       || lk == 100520              // 'json' 'not'
       || lk == 101032              // 'json' 'null'
       || lk == 101544              // 'json' 'object'
       || lk == 103592              // 'json' 'only'
       || lk == 104104              // 'json' 'option'
       || lk == 104616              // 'json' 'or'
       || lk == 105128              // 'json' 'order'
       || lk == 105640              // 'json' 'ordered'
       || lk == 106152              // 'json' 'ordering'
       || lk == 107688              // 'json' 'parent'
       || lk == 110760              // 'json' 'preceding'
       || lk == 111272              // 'json' 'preceding-sibling'
       || lk == 112808              // 'json' 'processing-instruction'
       || lk == 113832              // 'json' 'rename'
       || lk == 114344              // 'json' 'replace'
       || lk == 114856              // 'json' 'return'
       || lk == 115368              // 'json' 'returning'
       || lk == 115880              // 'json' 'revalidation'
       || lk == 116904              // 'json' 'satisfies'
       || lk == 117416              // 'json' 'schema'
       || lk == 117928              // 'json' 'schema-attribute'
       || lk == 118440              // 'json' 'schema-element'
       || lk == 118952              // 'json' 'score'
       || lk == 119464              // 'json' 'select'
       || lk == 119976              // 'json' 'self'
       || lk == 122536              // 'json' 'sliding'
       || lk == 123048              // 'json' 'some'
       || lk == 123560              // 'json' 'stable'
       || lk == 124072              // 'json' 'start'
       || lk == 125608              // 'json' 'strict'
       || lk == 126632              // 'json' 'structured-item'
       || lk == 127144              // 'json' 'switch'
       || lk == 127656              // 'json' 'text'
       || lk == 129704              // 'json' 'to'
       || lk == 130216              // 'json' 'treat'
       || lk == 130728              // 'json' 'true'
       || lk == 131240              // 'json' 'try'
       || lk == 131752              // 'json' 'tumbling'
       || lk == 132264              // 'json' 'type'
       || lk == 132776              // 'json' 'typeswitch'
       || lk == 133288              // 'json' 'union'
       || lk == 134312              // 'json' 'unordered'
       || lk == 134824              // 'json' 'updating'
       || lk == 136360              // 'json' 'validate'
       || lk == 136872              // 'json' 'value'
       || lk == 137384              // 'json' 'variable'
       || lk == 137896              // 'json' 'version'
       || lk == 139432              // 'json' 'where'
       || lk == 139944              // 'json' 'while'
       || lk == 141480              // 'json' 'with'
       || lk == 144040              // 'json' '{'
       || lk == 145064)             // 'json' '{|'
      {
        shiftT(168);                // 'json'
      }
      lookahead1W(268);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_PairConstructorList();
      shiftT(165);                  // 'into'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_ExprSingle();
    }
  }

  function parse_JSONRenameExpr()
  {
    eventHandler.startNonterminal("JSONRenameExpr", e0);
    shift(222);                     // 'rename'
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    switch (l1)
    {
    case 168:                       // 'json'
      lookahead2W(261);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 18088)                // 'json' '('
    {
      lk = memoized(16, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(168);              // 'json'
          lk = -1;
        }
        catch (p1A)
        {
          lk = -2;
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(16, e0, lk);
      }
    }
    if (lk == -1
     || lk == 3240                  // 'json' EQName^Token
     || lk == 4264                  // 'json' IntegerLiteral
     || lk == 4776                  // 'json' DecimalLiteral
     || lk == 5288                  // 'json' DoubleLiteral
     || lk == 5800                  // 'json' StringLiteral
     || lk == 16040                 // 'json' '$'
     || lk == 16552                 // 'json' '$$'
     || lk == 17064                 // 'json' '%'
     || lk == 28328                 // 'json' '<'
     || lk == 28840                 // 'json' '<!--'
     || lk == 30888                 // 'json' '<?'
     || lk == 35496                 // 'json' '['
     || lk == 36520                 // 'json' 'after'
     || lk == 37544                 // 'json' 'allowing'
     || lk == 38056                 // 'json' 'ancestor'
     || lk == 38568                 // 'json' 'ancestor-or-self'
     || lk == 39080                 // 'json' 'and'
     || lk == 40104                 // 'json' 'append'
     || lk == 40616                 // 'json' 'array'
     || lk == 41128                 // 'json' 'as'
     || lk == 41640                 // 'json' 'ascending'
     || lk == 42152                 // 'json' 'at'
     || lk == 42664                 // 'json' 'attribute'
     || lk == 43176                 // 'json' 'base-uri'
     || lk == 43688                 // 'json' 'before'
     || lk == 44200                 // 'json' 'boundary-space'
     || lk == 44712                 // 'json' 'break'
     || lk == 45736                 // 'json' 'case'
     || lk == 46248                 // 'json' 'cast'
     || lk == 46760                 // 'json' 'castable'
     || lk == 47272                 // 'json' 'catch'
     || lk == 48296                 // 'json' 'child'
     || lk == 48808                 // 'json' 'collation'
     || lk == 49832                 // 'json' 'comment'
     || lk == 50344                 // 'json' 'constraint'
     || lk == 50856                 // 'json' 'construction'
     || lk == 52392                 // 'json' 'context'
     || lk == 52904                 // 'json' 'continue'
     || lk == 53416                 // 'json' 'copy'
     || lk == 53928                 // 'json' 'copy-namespaces'
     || lk == 54440                 // 'json' 'count'
     || lk == 54952                 // 'json' 'decimal-format'
     || lk == 55976                 // 'json' 'declare'
     || lk == 56488                 // 'json' 'default'
     || lk == 57000                 // 'json' 'delete'
     || lk == 57512                 // 'json' 'descendant'
     || lk == 58024                 // 'json' 'descendant-or-self'
     || lk == 58536                 // 'json' 'descending'
     || lk == 61096                 // 'json' 'div'
     || lk == 61608                 // 'json' 'document'
     || lk == 62120                 // 'json' 'document-node'
     || lk == 62632                 // 'json' 'element'
     || lk == 63144                 // 'json' 'else'
     || lk == 63656                 // 'json' 'empty'
     || lk == 64168                 // 'json' 'empty-sequence'
     || lk == 64680                 // 'json' 'encoding'
     || lk == 65192                 // 'json' 'end'
     || lk == 66216                 // 'json' 'eq'
     || lk == 66728                 // 'json' 'every'
     || lk == 67752                 // 'json' 'except'
     || lk == 68264                 // 'json' 'exit'
     || lk == 68776                 // 'json' 'external'
     || lk == 69288                 // 'json' 'false'
     || lk == 69800                 // 'json' 'first'
     || lk == 70312                 // 'json' 'following'
     || lk == 70824                 // 'json' 'following-sibling'
     || lk == 71336                 // 'json' 'for'
     || lk == 72872                 // 'json' 'from'
     || lk == 73384                 // 'json' 'ft-option'
     || lk == 75432                 // 'json' 'function'
     || lk == 75944                 // 'json' 'ge'
     || lk == 76968                 // 'json' 'group'
     || lk == 77992                 // 'json' 'gt'
     || lk == 78504                 // 'json' 'idiv'
     || lk == 79016                 // 'json' 'if'
     || lk == 79528                 // 'json' 'import'
     || lk == 80040                 // 'json' 'in'
     || lk == 80552                 // 'json' 'index'
     || lk == 82600                 // 'json' 'insert'
     || lk == 83112                 // 'json' 'instance'
     || lk == 83624                 // 'json' 'integrity'
     || lk == 84136                 // 'json' 'intersect'
     || lk == 84648                 // 'json' 'into'
     || lk == 85160                 // 'json' 'is'
     || lk == 85672                 // 'json' 'item'
     || lk == 86184                 // 'json' 'json'
     || lk == 86696                 // 'json' 'json-item'
     || lk == 87208                 // 'json' 'jsoniq'
     || lk == 88744                 // 'json' 'last'
     || lk == 89256                 // 'json' 'lax'
     || lk == 89768                 // 'json' 'le'
     || lk == 90792                 // 'json' 'let'
     || lk == 91816                 // 'json' 'loop'
     || lk == 92840                 // 'json' 'lt'
     || lk == 93864                 // 'json' 'mod'
     || lk == 94376                 // 'json' 'modify'
     || lk == 94888                 // 'json' 'module'
     || lk == 95912                 // 'json' 'namespace'
     || lk == 96424                 // 'json' 'namespace-node'
     || lk == 96936                 // 'json' 'ne'
     || lk == 99496                 // 'json' 'node'
     || lk == 100008                // 'json' 'nodes'
     || lk == 101032                // 'json' 'null'
     || lk == 101544                // 'json' 'object'
     || lk == 103592                // 'json' 'only'
     || lk == 104104                // 'json' 'option'
     || lk == 104616                // 'json' 'or'
     || lk == 105128                // 'json' 'order'
     || lk == 105640                // 'json' 'ordered'
     || lk == 106152                // 'json' 'ordering'
     || lk == 107688                // 'json' 'parent'
     || lk == 110760                // 'json' 'preceding'
     || lk == 111272                // 'json' 'preceding-sibling'
     || lk == 112808                // 'json' 'processing-instruction'
     || lk == 113832                // 'json' 'rename'
     || lk == 114344                // 'json' 'replace'
     || lk == 114856                // 'json' 'return'
     || lk == 115368                // 'json' 'returning'
     || lk == 115880                // 'json' 'revalidation'
     || lk == 116904                // 'json' 'satisfies'
     || lk == 117416                // 'json' 'schema'
     || lk == 117928                // 'json' 'schema-attribute'
     || lk == 118440                // 'json' 'schema-element'
     || lk == 118952                // 'json' 'score'
     || lk == 119464                // 'json' 'select'
     || lk == 119976                // 'json' 'self'
     || lk == 122536                // 'json' 'sliding'
     || lk == 123048                // 'json' 'some'
     || lk == 123560                // 'json' 'stable'
     || lk == 124072                // 'json' 'start'
     || lk == 125608                // 'json' 'strict'
     || lk == 126632                // 'json' 'structured-item'
     || lk == 127144                // 'json' 'switch'
     || lk == 127656                // 'json' 'text'
     || lk == 129704                // 'json' 'to'
     || lk == 130216                // 'json' 'treat'
     || lk == 130728                // 'json' 'true'
     || lk == 131240                // 'json' 'try'
     || lk == 131752                // 'json' 'tumbling'
     || lk == 132264                // 'json' 'type'
     || lk == 132776                // 'json' 'typeswitch'
     || lk == 133288                // 'json' 'union'
     || lk == 134312                // 'json' 'unordered'
     || lk == 134824                // 'json' 'updating'
     || lk == 136360                // 'json' 'validate'
     || lk == 136872                // 'json' 'value'
     || lk == 137384                // 'json' 'variable'
     || lk == 137896                // 'json' 'version'
     || lk == 139432                // 'json' 'where'
     || lk == 139944                // 'json' 'while'
     || lk == 141480                // 'json' 'with'
     || lk == 144040                // 'json' '{'
     || lk == 145064)               // 'json' '{|'
    {
      shift(168);                   // 'json'
    }
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_PostfixExpr();
    shift(80);                      // 'as'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("JSONRenameExpr", e0);
  }

  function try_JSONRenameExpr()
  {
    shiftT(222);                    // 'rename'
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    switch (l1)
    {
    case 168:                       // 'json'
      lookahead2W(261);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 18088)                // 'json' '('
    {
      lk = memoized(16, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(168);              // 'json'
          memoize(16, e0A, -1);
        }
        catch (p1A)
        {
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(16, e0A, -2);
        }
        lk = -2;
      }
    }
    if (lk == -1
     || lk == 3240                  // 'json' EQName^Token
     || lk == 4264                  // 'json' IntegerLiteral
     || lk == 4776                  // 'json' DecimalLiteral
     || lk == 5288                  // 'json' DoubleLiteral
     || lk == 5800                  // 'json' StringLiteral
     || lk == 16040                 // 'json' '$'
     || lk == 16552                 // 'json' '$$'
     || lk == 17064                 // 'json' '%'
     || lk == 28328                 // 'json' '<'
     || lk == 28840                 // 'json' '<!--'
     || lk == 30888                 // 'json' '<?'
     || lk == 35496                 // 'json' '['
     || lk == 36520                 // 'json' 'after'
     || lk == 37544                 // 'json' 'allowing'
     || lk == 38056                 // 'json' 'ancestor'
     || lk == 38568                 // 'json' 'ancestor-or-self'
     || lk == 39080                 // 'json' 'and'
     || lk == 40104                 // 'json' 'append'
     || lk == 40616                 // 'json' 'array'
     || lk == 41128                 // 'json' 'as'
     || lk == 41640                 // 'json' 'ascending'
     || lk == 42152                 // 'json' 'at'
     || lk == 42664                 // 'json' 'attribute'
     || lk == 43176                 // 'json' 'base-uri'
     || lk == 43688                 // 'json' 'before'
     || lk == 44200                 // 'json' 'boundary-space'
     || lk == 44712                 // 'json' 'break'
     || lk == 45736                 // 'json' 'case'
     || lk == 46248                 // 'json' 'cast'
     || lk == 46760                 // 'json' 'castable'
     || lk == 47272                 // 'json' 'catch'
     || lk == 48296                 // 'json' 'child'
     || lk == 48808                 // 'json' 'collation'
     || lk == 49832                 // 'json' 'comment'
     || lk == 50344                 // 'json' 'constraint'
     || lk == 50856                 // 'json' 'construction'
     || lk == 52392                 // 'json' 'context'
     || lk == 52904                 // 'json' 'continue'
     || lk == 53416                 // 'json' 'copy'
     || lk == 53928                 // 'json' 'copy-namespaces'
     || lk == 54440                 // 'json' 'count'
     || lk == 54952                 // 'json' 'decimal-format'
     || lk == 55976                 // 'json' 'declare'
     || lk == 56488                 // 'json' 'default'
     || lk == 57000                 // 'json' 'delete'
     || lk == 57512                 // 'json' 'descendant'
     || lk == 58024                 // 'json' 'descendant-or-self'
     || lk == 58536                 // 'json' 'descending'
     || lk == 61096                 // 'json' 'div'
     || lk == 61608                 // 'json' 'document'
     || lk == 62120                 // 'json' 'document-node'
     || lk == 62632                 // 'json' 'element'
     || lk == 63144                 // 'json' 'else'
     || lk == 63656                 // 'json' 'empty'
     || lk == 64168                 // 'json' 'empty-sequence'
     || lk == 64680                 // 'json' 'encoding'
     || lk == 65192                 // 'json' 'end'
     || lk == 66216                 // 'json' 'eq'
     || lk == 66728                 // 'json' 'every'
     || lk == 67752                 // 'json' 'except'
     || lk == 68264                 // 'json' 'exit'
     || lk == 68776                 // 'json' 'external'
     || lk == 69288                 // 'json' 'false'
     || lk == 69800                 // 'json' 'first'
     || lk == 70312                 // 'json' 'following'
     || lk == 70824                 // 'json' 'following-sibling'
     || lk == 71336                 // 'json' 'for'
     || lk == 72872                 // 'json' 'from'
     || lk == 73384                 // 'json' 'ft-option'
     || lk == 75432                 // 'json' 'function'
     || lk == 75944                 // 'json' 'ge'
     || lk == 76968                 // 'json' 'group'
     || lk == 77992                 // 'json' 'gt'
     || lk == 78504                 // 'json' 'idiv'
     || lk == 79016                 // 'json' 'if'
     || lk == 79528                 // 'json' 'import'
     || lk == 80040                 // 'json' 'in'
     || lk == 80552                 // 'json' 'index'
     || lk == 82600                 // 'json' 'insert'
     || lk == 83112                 // 'json' 'instance'
     || lk == 83624                 // 'json' 'integrity'
     || lk == 84136                 // 'json' 'intersect'
     || lk == 84648                 // 'json' 'into'
     || lk == 85160                 // 'json' 'is'
     || lk == 85672                 // 'json' 'item'
     || lk == 86184                 // 'json' 'json'
     || lk == 86696                 // 'json' 'json-item'
     || lk == 87208                 // 'json' 'jsoniq'
     || lk == 88744                 // 'json' 'last'
     || lk == 89256                 // 'json' 'lax'
     || lk == 89768                 // 'json' 'le'
     || lk == 90792                 // 'json' 'let'
     || lk == 91816                 // 'json' 'loop'
     || lk == 92840                 // 'json' 'lt'
     || lk == 93864                 // 'json' 'mod'
     || lk == 94376                 // 'json' 'modify'
     || lk == 94888                 // 'json' 'module'
     || lk == 95912                 // 'json' 'namespace'
     || lk == 96424                 // 'json' 'namespace-node'
     || lk == 96936                 // 'json' 'ne'
     || lk == 99496                 // 'json' 'node'
     || lk == 100008                // 'json' 'nodes'
     || lk == 101032                // 'json' 'null'
     || lk == 101544                // 'json' 'object'
     || lk == 103592                // 'json' 'only'
     || lk == 104104                // 'json' 'option'
     || lk == 104616                // 'json' 'or'
     || lk == 105128                // 'json' 'order'
     || lk == 105640                // 'json' 'ordered'
     || lk == 106152                // 'json' 'ordering'
     || lk == 107688                // 'json' 'parent'
     || lk == 110760                // 'json' 'preceding'
     || lk == 111272                // 'json' 'preceding-sibling'
     || lk == 112808                // 'json' 'processing-instruction'
     || lk == 113832                // 'json' 'rename'
     || lk == 114344                // 'json' 'replace'
     || lk == 114856                // 'json' 'return'
     || lk == 115368                // 'json' 'returning'
     || lk == 115880                // 'json' 'revalidation'
     || lk == 116904                // 'json' 'satisfies'
     || lk == 117416                // 'json' 'schema'
     || lk == 117928                // 'json' 'schema-attribute'
     || lk == 118440                // 'json' 'schema-element'
     || lk == 118952                // 'json' 'score'
     || lk == 119464                // 'json' 'select'
     || lk == 119976                // 'json' 'self'
     || lk == 122536                // 'json' 'sliding'
     || lk == 123048                // 'json' 'some'
     || lk == 123560                // 'json' 'stable'
     || lk == 124072                // 'json' 'start'
     || lk == 125608                // 'json' 'strict'
     || lk == 126632                // 'json' 'structured-item'
     || lk == 127144                // 'json' 'switch'
     || lk == 127656                // 'json' 'text'
     || lk == 129704                // 'json' 'to'
     || lk == 130216                // 'json' 'treat'
     || lk == 130728                // 'json' 'true'
     || lk == 131240                // 'json' 'try'
     || lk == 131752                // 'json' 'tumbling'
     || lk == 132264                // 'json' 'type'
     || lk == 132776                // 'json' 'typeswitch'
     || lk == 133288                // 'json' 'union'
     || lk == 134312                // 'json' 'unordered'
     || lk == 134824                // 'json' 'updating'
     || lk == 136360                // 'json' 'validate'
     || lk == 136872                // 'json' 'value'
     || lk == 137384                // 'json' 'variable'
     || lk == 137896                // 'json' 'version'
     || lk == 139432                // 'json' 'where'
     || lk == 139944                // 'json' 'while'
     || lk == 141480                // 'json' 'with'
     || lk == 144040                // 'json' '{'
     || lk == 145064)               // 'json' '{|'
    {
      shiftT(168);                  // 'json'
    }
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_PostfixExpr();
    shiftT(80);                     // 'as'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_JSONReplaceExpr()
  {
    eventHandler.startNonterminal("JSONReplaceExpr", e0);
    shift(223);                     // 'replace'
    lookahead1W(85);                // S^WS | '(:' | 'value'
    shift(267);                     // 'value'
    lookahead1W(67);                // S^WS | '(:' | 'of'
    shift(200);                     // 'of'
    lookahead1W(59);                // S^WS | '(:' | 'json'
    shift(168);                     // 'json'
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_PostfixExpr();
    shift(276);                     // 'with'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("JSONReplaceExpr", e0);
  }

  function try_JSONReplaceExpr()
  {
    shiftT(223);                    // 'replace'
    lookahead1W(85);                // S^WS | '(:' | 'value'
    shiftT(267);                    // 'value'
    lookahead1W(67);                // S^WS | '(:' | 'of'
    shiftT(200);                    // 'of'
    lookahead1W(59);                // S^WS | '(:' | 'json'
    shiftT(168);                    // 'json'
    lookahead1W(260);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_PostfixExpr();
    shiftT(276);                    // 'with'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_JSONAppendExpr()
  {
    eventHandler.startNonterminal("JSONAppendExpr", e0);
    shift(78);                      // 'append'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    switch (l1)
    {
    case 168:                       // 'json'
      lookahead2W(269);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 18088)                // 'json' '('
    {
      lk = memoized(17, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(168);              // 'json'
          lk = -1;
        }
        catch (p1A)
        {
          lk = -2;
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(17, e0, lk);
      }
    }
    if (lk == -1
     || lk == 3240                  // 'json' EQName^Token
     || lk == 4264                  // 'json' IntegerLiteral
     || lk == 4776                  // 'json' DecimalLiteral
     || lk == 5288                  // 'json' DoubleLiteral
     || lk == 5800                  // 'json' StringLiteral
     || lk == 16040                 // 'json' '$'
     || lk == 16552                 // 'json' '$$'
     || lk == 17064                 // 'json' '%'
     || lk == 18600                 // 'json' '(#'
     || lk == 21160                 // 'json' '+'
     || lk == 22184                 // 'json' '-'
     || lk == 24232                 // 'json' '/'
     || lk == 24744                 // 'json' '//'
     || lk == 28328                 // 'json' '<'
     || lk == 28840                 // 'json' '<!--'
     || lk == 30888                 // 'json' '<?'
     || lk == 35496                 // 'json' '['
     || lk == 36520                 // 'json' 'after'
     || lk == 37544                 // 'json' 'allowing'
     || lk == 38056                 // 'json' 'ancestor'
     || lk == 38568                 // 'json' 'ancestor-or-self'
     || lk == 39080                 // 'json' 'and'
     || lk == 40104                 // 'json' 'append'
     || lk == 40616                 // 'json' 'array'
     || lk == 41128                 // 'json' 'as'
     || lk == 41640                 // 'json' 'ascending'
     || lk == 42152                 // 'json' 'at'
     || lk == 42664                 // 'json' 'attribute'
     || lk == 43176                 // 'json' 'base-uri'
     || lk == 43688                 // 'json' 'before'
     || lk == 44200                 // 'json' 'boundary-space'
     || lk == 44712                 // 'json' 'break'
     || lk == 45736                 // 'json' 'case'
     || lk == 46248                 // 'json' 'cast'
     || lk == 46760                 // 'json' 'castable'
     || lk == 47272                 // 'json' 'catch'
     || lk == 48296                 // 'json' 'child'
     || lk == 48808                 // 'json' 'collation'
     || lk == 49832                 // 'json' 'comment'
     || lk == 50344                 // 'json' 'constraint'
     || lk == 50856                 // 'json' 'construction'
     || lk == 52392                 // 'json' 'context'
     || lk == 52904                 // 'json' 'continue'
     || lk == 53416                 // 'json' 'copy'
     || lk == 53928                 // 'json' 'copy-namespaces'
     || lk == 54440                 // 'json' 'count'
     || lk == 54952                 // 'json' 'decimal-format'
     || lk == 55976                 // 'json' 'declare'
     || lk == 56488                 // 'json' 'default'
     || lk == 57000                 // 'json' 'delete'
     || lk == 57512                 // 'json' 'descendant'
     || lk == 58024                 // 'json' 'descendant-or-self'
     || lk == 58536                 // 'json' 'descending'
     || lk == 61096                 // 'json' 'div'
     || lk == 61608                 // 'json' 'document'
     || lk == 62120                 // 'json' 'document-node'
     || lk == 62632                 // 'json' 'element'
     || lk == 63144                 // 'json' 'else'
     || lk == 63656                 // 'json' 'empty'
     || lk == 64168                 // 'json' 'empty-sequence'
     || lk == 64680                 // 'json' 'encoding'
     || lk == 65192                 // 'json' 'end'
     || lk == 66216                 // 'json' 'eq'
     || lk == 66728                 // 'json' 'every'
     || lk == 67752                 // 'json' 'except'
     || lk == 68264                 // 'json' 'exit'
     || lk == 68776                 // 'json' 'external'
     || lk == 69288                 // 'json' 'false'
     || lk == 69800                 // 'json' 'first'
     || lk == 70312                 // 'json' 'following'
     || lk == 70824                 // 'json' 'following-sibling'
     || lk == 71336                 // 'json' 'for'
     || lk == 72872                 // 'json' 'from'
     || lk == 73384                 // 'json' 'ft-option'
     || lk == 75432                 // 'json' 'function'
     || lk == 75944                 // 'json' 'ge'
     || lk == 76968                 // 'json' 'group'
     || lk == 77992                 // 'json' 'gt'
     || lk == 78504                 // 'json' 'idiv'
     || lk == 79016                 // 'json' 'if'
     || lk == 79528                 // 'json' 'import'
     || lk == 80040                 // 'json' 'in'
     || lk == 80552                 // 'json' 'index'
     || lk == 82600                 // 'json' 'insert'
     || lk == 83112                 // 'json' 'instance'
     || lk == 83624                 // 'json' 'integrity'
     || lk == 84136                 // 'json' 'intersect'
     || lk == 84648                 // 'json' 'into'
     || lk == 85160                 // 'json' 'is'
     || lk == 85672                 // 'json' 'item'
     || lk == 86184                 // 'json' 'json'
     || lk == 86696                 // 'json' 'json-item'
     || lk == 87208                 // 'json' 'jsoniq'
     || lk == 88744                 // 'json' 'last'
     || lk == 89256                 // 'json' 'lax'
     || lk == 89768                 // 'json' 'le'
     || lk == 90792                 // 'json' 'let'
     || lk == 91816                 // 'json' 'loop'
     || lk == 92840                 // 'json' 'lt'
     || lk == 93864                 // 'json' 'mod'
     || lk == 94376                 // 'json' 'modify'
     || lk == 94888                 // 'json' 'module'
     || lk == 95912                 // 'json' 'namespace'
     || lk == 96424                 // 'json' 'namespace-node'
     || lk == 96936                 // 'json' 'ne'
     || lk == 99496                 // 'json' 'node'
     || lk == 100008                // 'json' 'nodes'
     || lk == 100520                // 'json' 'not'
     || lk == 101032                // 'json' 'null'
     || lk == 101544                // 'json' 'object'
     || lk == 103592                // 'json' 'only'
     || lk == 104104                // 'json' 'option'
     || lk == 104616                // 'json' 'or'
     || lk == 105128                // 'json' 'order'
     || lk == 105640                // 'json' 'ordered'
     || lk == 106152                // 'json' 'ordering'
     || lk == 107688                // 'json' 'parent'
     || lk == 110760                // 'json' 'preceding'
     || lk == 111272                // 'json' 'preceding-sibling'
     || lk == 112808                // 'json' 'processing-instruction'
     || lk == 113832                // 'json' 'rename'
     || lk == 114344                // 'json' 'replace'
     || lk == 114856                // 'json' 'return'
     || lk == 115368                // 'json' 'returning'
     || lk == 115880                // 'json' 'revalidation'
     || lk == 116904                // 'json' 'satisfies'
     || lk == 117416                // 'json' 'schema'
     || lk == 117928                // 'json' 'schema-attribute'
     || lk == 118440                // 'json' 'schema-element'
     || lk == 118952                // 'json' 'score'
     || lk == 119464                // 'json' 'select'
     || lk == 119976                // 'json' 'self'
     || lk == 122536                // 'json' 'sliding'
     || lk == 123048                // 'json' 'some'
     || lk == 123560                // 'json' 'stable'
     || lk == 124072                // 'json' 'start'
     || lk == 125608                // 'json' 'strict'
     || lk == 126632                // 'json' 'structured-item'
     || lk == 127144                // 'json' 'switch'
     || lk == 127656                // 'json' 'text'
     || lk == 129704                // 'json' 'to'
     || lk == 130216                // 'json' 'treat'
     || lk == 130728                // 'json' 'true'
     || lk == 131240                // 'json' 'try'
     || lk == 131752                // 'json' 'tumbling'
     || lk == 132264                // 'json' 'type'
     || lk == 132776                // 'json' 'typeswitch'
     || lk == 133288                // 'json' 'union'
     || lk == 134312                // 'json' 'unordered'
     || lk == 134824                // 'json' 'updating'
     || lk == 136360                // 'json' 'validate'
     || lk == 136872                // 'json' 'value'
     || lk == 137384                // 'json' 'variable'
     || lk == 137896                // 'json' 'version'
     || lk == 139432                // 'json' 'where'
     || lk == 139944                // 'json' 'while'
     || lk == 141480                // 'json' 'with'
     || lk == 144040                // 'json' '{'
     || lk == 145064)               // 'json' '{|'
    {
      shift(168);                   // 'json'
    }
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    shift(165);                     // 'into'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    whitespace();
    parse_ExprSingle();
    eventHandler.endNonterminal("JSONAppendExpr", e0);
  }

  function try_JSONAppendExpr()
  {
    shiftT(78);                     // 'append'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    switch (l1)
    {
    case 168:                       // 'json'
      lookahead2W(269);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 18088)                // 'json' '('
    {
      lk = memoized(17, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(168);              // 'json'
          memoize(17, e0A, -1);
        }
        catch (p1A)
        {
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(17, e0A, -2);
        }
        lk = -2;
      }
    }
    if (lk == -1
     || lk == 3240                  // 'json' EQName^Token
     || lk == 4264                  // 'json' IntegerLiteral
     || lk == 4776                  // 'json' DecimalLiteral
     || lk == 5288                  // 'json' DoubleLiteral
     || lk == 5800                  // 'json' StringLiteral
     || lk == 16040                 // 'json' '$'
     || lk == 16552                 // 'json' '$$'
     || lk == 17064                 // 'json' '%'
     || lk == 18600                 // 'json' '(#'
     || lk == 21160                 // 'json' '+'
     || lk == 22184                 // 'json' '-'
     || lk == 24232                 // 'json' '/'
     || lk == 24744                 // 'json' '//'
     || lk == 28328                 // 'json' '<'
     || lk == 28840                 // 'json' '<!--'
     || lk == 30888                 // 'json' '<?'
     || lk == 35496                 // 'json' '['
     || lk == 36520                 // 'json' 'after'
     || lk == 37544                 // 'json' 'allowing'
     || lk == 38056                 // 'json' 'ancestor'
     || lk == 38568                 // 'json' 'ancestor-or-self'
     || lk == 39080                 // 'json' 'and'
     || lk == 40104                 // 'json' 'append'
     || lk == 40616                 // 'json' 'array'
     || lk == 41128                 // 'json' 'as'
     || lk == 41640                 // 'json' 'ascending'
     || lk == 42152                 // 'json' 'at'
     || lk == 42664                 // 'json' 'attribute'
     || lk == 43176                 // 'json' 'base-uri'
     || lk == 43688                 // 'json' 'before'
     || lk == 44200                 // 'json' 'boundary-space'
     || lk == 44712                 // 'json' 'break'
     || lk == 45736                 // 'json' 'case'
     || lk == 46248                 // 'json' 'cast'
     || lk == 46760                 // 'json' 'castable'
     || lk == 47272                 // 'json' 'catch'
     || lk == 48296                 // 'json' 'child'
     || lk == 48808                 // 'json' 'collation'
     || lk == 49832                 // 'json' 'comment'
     || lk == 50344                 // 'json' 'constraint'
     || lk == 50856                 // 'json' 'construction'
     || lk == 52392                 // 'json' 'context'
     || lk == 52904                 // 'json' 'continue'
     || lk == 53416                 // 'json' 'copy'
     || lk == 53928                 // 'json' 'copy-namespaces'
     || lk == 54440                 // 'json' 'count'
     || lk == 54952                 // 'json' 'decimal-format'
     || lk == 55976                 // 'json' 'declare'
     || lk == 56488                 // 'json' 'default'
     || lk == 57000                 // 'json' 'delete'
     || lk == 57512                 // 'json' 'descendant'
     || lk == 58024                 // 'json' 'descendant-or-self'
     || lk == 58536                 // 'json' 'descending'
     || lk == 61096                 // 'json' 'div'
     || lk == 61608                 // 'json' 'document'
     || lk == 62120                 // 'json' 'document-node'
     || lk == 62632                 // 'json' 'element'
     || lk == 63144                 // 'json' 'else'
     || lk == 63656                 // 'json' 'empty'
     || lk == 64168                 // 'json' 'empty-sequence'
     || lk == 64680                 // 'json' 'encoding'
     || lk == 65192                 // 'json' 'end'
     || lk == 66216                 // 'json' 'eq'
     || lk == 66728                 // 'json' 'every'
     || lk == 67752                 // 'json' 'except'
     || lk == 68264                 // 'json' 'exit'
     || lk == 68776                 // 'json' 'external'
     || lk == 69288                 // 'json' 'false'
     || lk == 69800                 // 'json' 'first'
     || lk == 70312                 // 'json' 'following'
     || lk == 70824                 // 'json' 'following-sibling'
     || lk == 71336                 // 'json' 'for'
     || lk == 72872                 // 'json' 'from'
     || lk == 73384                 // 'json' 'ft-option'
     || lk == 75432                 // 'json' 'function'
     || lk == 75944                 // 'json' 'ge'
     || lk == 76968                 // 'json' 'group'
     || lk == 77992                 // 'json' 'gt'
     || lk == 78504                 // 'json' 'idiv'
     || lk == 79016                 // 'json' 'if'
     || lk == 79528                 // 'json' 'import'
     || lk == 80040                 // 'json' 'in'
     || lk == 80552                 // 'json' 'index'
     || lk == 82600                 // 'json' 'insert'
     || lk == 83112                 // 'json' 'instance'
     || lk == 83624                 // 'json' 'integrity'
     || lk == 84136                 // 'json' 'intersect'
     || lk == 84648                 // 'json' 'into'
     || lk == 85160                 // 'json' 'is'
     || lk == 85672                 // 'json' 'item'
     || lk == 86184                 // 'json' 'json'
     || lk == 86696                 // 'json' 'json-item'
     || lk == 87208                 // 'json' 'jsoniq'
     || lk == 88744                 // 'json' 'last'
     || lk == 89256                 // 'json' 'lax'
     || lk == 89768                 // 'json' 'le'
     || lk == 90792                 // 'json' 'let'
     || lk == 91816                 // 'json' 'loop'
     || lk == 92840                 // 'json' 'lt'
     || lk == 93864                 // 'json' 'mod'
     || lk == 94376                 // 'json' 'modify'
     || lk == 94888                 // 'json' 'module'
     || lk == 95912                 // 'json' 'namespace'
     || lk == 96424                 // 'json' 'namespace-node'
     || lk == 96936                 // 'json' 'ne'
     || lk == 99496                 // 'json' 'node'
     || lk == 100008                // 'json' 'nodes'
     || lk == 100520                // 'json' 'not'
     || lk == 101032                // 'json' 'null'
     || lk == 101544                // 'json' 'object'
     || lk == 103592                // 'json' 'only'
     || lk == 104104                // 'json' 'option'
     || lk == 104616                // 'json' 'or'
     || lk == 105128                // 'json' 'order'
     || lk == 105640                // 'json' 'ordered'
     || lk == 106152                // 'json' 'ordering'
     || lk == 107688                // 'json' 'parent'
     || lk == 110760                // 'json' 'preceding'
     || lk == 111272                // 'json' 'preceding-sibling'
     || lk == 112808                // 'json' 'processing-instruction'
     || lk == 113832                // 'json' 'rename'
     || lk == 114344                // 'json' 'replace'
     || lk == 114856                // 'json' 'return'
     || lk == 115368                // 'json' 'returning'
     || lk == 115880                // 'json' 'revalidation'
     || lk == 116904                // 'json' 'satisfies'
     || lk == 117416                // 'json' 'schema'
     || lk == 117928                // 'json' 'schema-attribute'
     || lk == 118440                // 'json' 'schema-element'
     || lk == 118952                // 'json' 'score'
     || lk == 119464                // 'json' 'select'
     || lk == 119976                // 'json' 'self'
     || lk == 122536                // 'json' 'sliding'
     || lk == 123048                // 'json' 'some'
     || lk == 123560                // 'json' 'stable'
     || lk == 124072                // 'json' 'start'
     || lk == 125608                // 'json' 'strict'
     || lk == 126632                // 'json' 'structured-item'
     || lk == 127144                // 'json' 'switch'
     || lk == 127656                // 'json' 'text'
     || lk == 129704                // 'json' 'to'
     || lk == 130216                // 'json' 'treat'
     || lk == 130728                // 'json' 'true'
     || lk == 131240                // 'json' 'try'
     || lk == 131752                // 'json' 'tumbling'
     || lk == 132264                // 'json' 'type'
     || lk == 132776                // 'json' 'typeswitch'
     || lk == 133288                // 'json' 'union'
     || lk == 134312                // 'json' 'unordered'
     || lk == 134824                // 'json' 'updating'
     || lk == 136360                // 'json' 'validate'
     || lk == 136872                // 'json' 'value'
     || lk == 137384                // 'json' 'variable'
     || lk == 137896                // 'json' 'version'
     || lk == 139432                // 'json' 'where'
     || lk == 139944                // 'json' 'while'
     || lk == 141480                // 'json' 'with'
     || lk == 144040                // 'json' '{'
     || lk == 145064)               // 'json' '{|'
    {
      shiftT(168);                  // 'json'
    }
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
    shiftT(165);                    // 'into'
    lookahead1W(267);               // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
    try_ExprSingle();
  }

  function parse_CommonContent()
  {
    eventHandler.startNonterminal("CommonContent", e0);
    switch (l1)
    {
    case 12:                        // PredefinedEntityRef
      shift(12);                    // PredefinedEntityRef
      break;
    case 23:                        // CharRef
      shift(23);                    // CharRef
      break;
    case 282:                       // '{{'
      shift(282);                   // '{{'
      break;
    case 288:                       // '}}'
      shift(288);                   // '}}'
      break;
    default:
      parse_BlockExpr();
    }
    eventHandler.endNonterminal("CommonContent", e0);
  }

  function try_CommonContent()
  {
    switch (l1)
    {
    case 12:                        // PredefinedEntityRef
      shiftT(12);                   // PredefinedEntityRef
      break;
    case 23:                        // CharRef
      shiftT(23);                   // CharRef
      break;
    case 282:                       // '{{'
      shiftT(282);                  // '{{'
      break;
    case 288:                       // '}}'
      shiftT(288);                  // '}}'
      break;
    default:
      try_BlockExpr();
    }
  }

  function parse_ContentExpr()
  {
    eventHandler.startNonterminal("ContentExpr", e0);
    parse_StatementsAndExpr();
    eventHandler.endNonterminal("ContentExpr", e0);
  }

  function try_ContentExpr()
  {
    try_StatementsAndExpr();
  }

  function parse_CompDocConstructor()
  {
    eventHandler.startNonterminal("CompDocConstructor", e0);
    shift(120);                     // 'document'
    lookahead1W(90);                // S^WS | '(:' | '{'
    whitespace();
    parse_BlockExpr();
    eventHandler.endNonterminal("CompDocConstructor", e0);
  }

  function try_CompDocConstructor()
  {
    shiftT(120);                    // 'document'
    lookahead1W(90);                // S^WS | '(:' | '{'
    try_BlockExpr();
  }

  function parse_CompAttrConstructor()
  {
    eventHandler.startNonterminal("CompAttrConstructor", e0);
    shift(83);                      // 'attribute'
    lookahead1W(250);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    switch (l1)
    {
    case 281:                       // '{'
      shift(281);                   // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_Expr();
      shift(287);                   // '}'
      break;
    default:
      whitespace();
      parse_EQName();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    switch (l1)
    {
    case 281:                       // '{'
      lookahead2W(281);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 147225)               // '{' '}'
    {
      lk = memoized(18, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(281);              // '{'
          lookahead1W(91);          // S^WS | '(:' | '}'
          shiftT(287);              // '}'
          lk = -1;
        }
        catch (p1A)
        {
          lk = -2;
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(18, e0, lk);
      }
    }
    switch (lk)
    {
    case -1:
      shift(281);                   // '{'
      lookahead1W(91);              // S^WS | '(:' | '}'
      shift(287);                   // '}'
      break;
    default:
      whitespace();
      parse_BlockExpr();
    }
    eventHandler.endNonterminal("CompAttrConstructor", e0);
  }

  function try_CompAttrConstructor()
  {
    shiftT(83);                     // 'attribute'
    lookahead1W(250);               // EQName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    switch (l1)
    {
    case 281:                       // '{'
      shiftT(281);                  // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_Expr();
      shiftT(287);                  // '}'
      break;
    default:
      try_EQName();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    switch (l1)
    {
    case 281:                       // '{'
      lookahead2W(281);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 147225)               // '{' '}'
    {
      lk = memoized(18, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(281);              // '{'
          lookahead1W(91);          // S^WS | '(:' | '}'
          shiftT(287);              // '}'
          memoize(18, e0A, -1);
          lk = -3;
        }
        catch (p1A)
        {
          lk = -2;
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(18, e0A, -2);
        }
      }
    }
    switch (lk)
    {
    case -1:
      shiftT(281);                  // '{'
      lookahead1W(91);              // S^WS | '(:' | '}'
      shiftT(287);                  // '}'
      break;
    case -3:
      break;
    default:
      try_BlockExpr();
    }
  }

  function parse_CompPIConstructor()
  {
    eventHandler.startNonterminal("CompPIConstructor", e0);
    shift(220);                     // 'processing-instruction'
    lookahead1W(242);               // NCName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    switch (l1)
    {
    case 281:                       // '{'
      shift(281);                   // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      whitespace();
      parse_Expr();
      shift(287);                   // '}'
      break;
    default:
      whitespace();
      parse_NCName();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    switch (l1)
    {
    case 281:                       // '{'
      lookahead2W(281);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 147225)               // '{' '}'
    {
      lk = memoized(19, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(281);              // '{'
          lookahead1W(91);          // S^WS | '(:' | '}'
          shiftT(287);              // '}'
          lk = -1;
        }
        catch (p1A)
        {
          lk = -2;
        }
        b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
        b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
        b2 = b2A; e2 = e2A; end = e2A; }}
        memoize(19, e0, lk);
      }
    }
    switch (lk)
    {
    case -1:
      shift(281);                   // '{'
      lookahead1W(91);              // S^WS | '(:' | '}'
      shift(287);                   // '}'
      break;
    default:
      whitespace();
      parse_BlockExpr();
    }
    eventHandler.endNonterminal("CompPIConstructor", e0);
  }

  function try_CompPIConstructor()
  {
    shiftT(220);                    // 'processing-instruction'
    lookahead1W(242);               // NCName^Token | S^WS | '(:' | 'after' | 'allowing' | 'ancestor' |
    switch (l1)
    {
    case 281:                       // '{'
      shiftT(281);                  // '{'
      lookahead1W(267);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      try_Expr();
      shiftT(287);                  // '}'
      break;
    default:
      try_NCName();
    }
    lookahead1W(90);                // S^WS | '(:' | '{'
    switch (l1)
    {
    case 281:                       // '{'
      lookahead2W(281);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    default:
      lk = l1;
    }
    if (lk == 147225)               // '{' '}'
    {
      lk = memoized(19, e0);
      if (lk == 0)
      {
        var b0A = b0; var e0A = e0; var l1A = l1;
        var b1A = b1; var e1A = e1; var l2A = l2;
        var b2A = b2; var e2A = e2;
        try
        {
          shiftT(281);              // '{'
          lookahead1W(91);          // S^WS | '(:' | '}'
          shiftT(287);              // '}'
          memoize(19, e0A, -1);
          lk = -3;
        }
        catch (p1A)
        {
          lk = -2;
          b0 = b0A; e0 = e0A; l1 = l1A; if (l1 == 0) {end = e0A;} else {
          b1 = b1A; e1 = e1A; l2 = l2A; if (l2 == 0) {end = e1A;} else {
          b2 = b2A; e2 = e2A; end = e2A; }}
          memoize(19, e0A, -2);
        }
      }
    }
    switch (lk)
    {
    case -1:
      shiftT(281);                  // '{'
      lookahead1W(91);              // S^WS | '(:' | '}'
      shiftT(287);                  // '}'
      break;
    case -3:
      break;
    default:
      try_BlockExpr();
    }
  }

  function parse_CompCommentConstructor()
  {
    eventHandler.startNonterminal("CompCommentConstructor", e0);
    shift(97);                      // 'comment'
    lookahead1W(90);                // S^WS | '(:' | '{'
    whitespace();
    parse_BlockExpr();
    eventHandler.endNonterminal("CompCommentConstructor", e0);
  }

  function try_CompCommentConstructor()
  {
    shiftT(97);                     // 'comment'
    lookahead1W(90);                // S^WS | '(:' | '{'
    try_BlockExpr();
  }

  function parse_CompTextConstructor()
  {
    eventHandler.startNonterminal("CompTextConstructor", e0);
    shift(249);                     // 'text'
    lookahead1W(90);                // S^WS | '(:' | '{'
    whitespace();
    parse_BlockExpr();
    eventHandler.endNonterminal("CompTextConstructor", e0);
  }

  function try_CompTextConstructor()
  {
    shiftT(249);                    // 'text'
    lookahead1W(90);                // S^WS | '(:' | '{'
    try_BlockExpr();
  }

  function parse_PrimaryExpr()
  {
    eventHandler.startNonterminal("PrimaryExpr", e0);
    switch (l1)
    {
    case 187:                       // 'namespace'
      lookahead2W(247);             // NCName^Token | S^WS | '#' | '(' | '(:' | 'after' | 'allowing' | 'ancestor' |
      break;
    case 220:                       // 'processing-instruction'
      lookahead2W(245);             // NCName^Token | S^WS | '#' | '(:' | 'after' | 'allowing' | 'ancestor' |
      break;
    case 281:                       // '{'
      lookahead2W(283);             // EQName^Token | IntegerLiteral | DecimalLiteral | DoubleLiteral | StringLiteral |
      break;
    case 83:                        // 'attribute'
    case 122:                       // 'element'
      lookahead2W(253);             // EQName^Token | S^WS | '#' | '(:' | 'after' | 'allowing' | 'ancestor' |
      break;
    case 97:                        // 'comment'
    case 249:                       // 'text'
      lookahead2W(97);              // S^WS | '#' | '(:' | '{'
      break;
    case 120:                       // 'document'
    case 206:                       // 'ordered'
    case 262:                       // 'unordered'
      lookahead2W(148);             // S^WS | '#' | '(' | '(:' | '{'
      break;
    case 135:                       // 'false'
    case 197:                       // 'null'
    case 255:                       // 'true'
      lookahead2W(237);             // S^WS | EOF | '!' | '!=' | '#' | '(' | '(:' | ')' | '*' | '+' | ',' | '-' | '.' |
      break;
    case 6:                         // EQName^Token
    case 71:                        // 'after'
    case 73:                        // 'allowing'
    case 74:                        // 'ancestor'
    case 75:                        // 'ancestor-or-self'
    case 76:                        // 'and'
    case 78:                        // 'append'
    case 80:                        // 'as'
    case 81:                        // 'ascending'
    case 82:                        // 'at'
    case 84:                        // 'base-uri'
    case 85:                        // 'before'
    case 86:                        // 'boundary-space'
    case 87:                        // 'break'
    case 89:                        // 'case'
    case 90:                        // 'cast'
    case 91:                        // 'castable'
    case 92:                        // 'catch'
    case 94:                        // 'child'
    case 95:                        // 'collation'
    case 98:                        // 'constraint'
    case 99:                        // 'construction'
    case 102:                       // 'context'
    case 103:                       // 'continue'
    case 104:                       // 'copy'
    case 105:                       // 'copy-namespaces'
    case 106:                       // 'count'
    case 107:                       // 'decimal-format'
    case 109:                       // 'declare'
    case 110:                       // 'default'
    case 111:                       // 'delete'
    case 112:                       // 'descendant'
    case 113:                       // 'descendant-or-self'
    case 114:                       // 'descending'
    case 119:                       // 'div'
    case 123:                       // 'else'
    case 124:                       // 'empty'
    case 126:                       // 'encoding'
    case 127:                       // 'end'
    case 129:                       // 'eq'
    case 130:                       // 'every'
    case 132:                       // 'except'
    case 133:                       // 'exit'
    case 134:                       // 'external'
    case 136:                       // 'first'
    case 137:                       // 'following'
    case 138:                       // 'following-sibling'
    case 139:                       // 'for'
    case 142:                       // 'from'
    case 143:                       // 'ft-option'
    case 148:                       // 'ge'
    case 150:                       // 'group'
    case 152:                       // 'gt'
    case 153:                       // 'idiv'
    case 155:                       // 'import'
    case 156:                       // 'in'
    case 157:                       // 'index'
    case 161:                       // 'insert'
    case 162:                       // 'instance'
    case 163:                       // 'integrity'
    case 164:                       // 'intersect'
    case 165:                       // 'into'
    case 166:                       // 'is'
    case 168:                       // 'json'
    case 170:                       // 'jsoniq'
    case 173:                       // 'last'
    case 174:                       // 'lax'
    case 175:                       // 'le'
    case 177:                       // 'let'
    case 179:                       // 'loop'
    case 181:                       // 'lt'
    case 183:                       // 'mod'
    case 184:                       // 'modify'
    case 185:                       // 'module'
    case 189:                       // 'ne'
    case 195:                       // 'nodes'
    case 198:                       // 'object'
    case 202:                       // 'only'
    case 203:                       // 'option'
    case 204:                       // 'or'
    case 205:                       // 'order'
    case 207:                       // 'ordering'
    case 210:                       // 'parent'
    case 216:                       // 'preceding'
    case 217:                       // 'preceding-sibling'
    case 222:                       // 'rename'
    case 223:                       // 'replace'
    case 224:                       // 'return'
    case 225:                       // 'returning'
    case 226:                       // 'revalidation'
    case 228:                       // 'satisfies'
    case 229:                       // 'schema'
    case 232:                       // 'score'
    case 233:                       // 'select'
    case 234:                       // 'self'
    case 239:                       // 'sliding'
    case 240:                       // 'some'
    case 241:                       // 'stable'
    case 242:                       // 'start'
    case 245:                       // 'strict'
    case 253:                       // 'to'
    case 254:                       // 'treat'
    case 256:                       // 'try'
    case 257:                       // 'tumbling'
    case 258:                       // 'type'
    case 260:                       // 'union'
    case 263:                       // 'updating'
    case 266:                       // 'validate'
    case 267:                       // 'value'
    case 268:                       // 'variable'
    case 269:                       // 'version'
    case 272:                       // 'where'
    case 273:                       // 'while'
    case 276:                       // 'with'
      lookahead2W(95