(function(){"Alchemy.js is a graph drawing application for the web.\nCopyright (C) 2014  GraphAlchemist, Inc.\n\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU Affero General Public License as published by\nthe Free Software Foundation, either version 3 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU Affero General Public License for more details.\n\nYou should have received a copy of the GNU Affero General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.\nlets";var a,b,c,d,e,f,g,h,i,j,k,l,m,n,o=[].slice,p=function(a,b){return function(){return a.apply(b,arguments)}};b=function(){function b(b){null==b&&(b=null),this.a=this,this.version="#VERSION#",this.api=new a(this),this.get=this.api.get,this.create=this.api.create,this.set=this.api.set,this.filter=this.api.filter,this.forceLayout=this.api.force,this.drawing={DrawEdge:d(this),DrawEdges:e(this),DrawNode:f(this),DrawNodes:g(this),NodeUtils:this.NodeUtils(this)},this.controlDash=this.controlDash(this),this.stats=this.stats(this),this.search=this.search(this),this.layout=k,this.clustering=c,this.models={Node:this.Node(this),Edge:this.Edge(this)},this.utils={warnings:new n(this)},this.filters=this.filters(this),this.exports=this.exports(this),this.visControls={},this.styles={},this.editor={},this.log={},this.state={interactions:"default",layout:"default"},this.startGraph=this.startGraph(this),this.updateGraph=this.updateGraph(this),this.generateLayout=this.generateLayout(this),this.svgStyles=this.svgStyles(this),this.interactions=this.interactions(this),this.plugins=this.plugins(this),this._nodes={},this._edges={},this.getNodes=this.get.getNodes,this.getEdges=this.get.getEdges,this.allNodes=this.get.allNodes,this.allEdges=this.get.allEdges,b&&this.begin(b)}return b.prototype.begin=function(a){var c;switch(c=this.setConf(a),typeof this.conf.dataSource){case"string":d3.json(this.a.conf.dataSource,this.a.startGraph);break;case"object":this.a.startGraph(this.a.conf.dataSource)}return this.plugins.init(),b.prototype.instances.push(this),this},b.prototype.setConf=function(a){var b,c;null!=a.theme&&(a=_.merge(_.cloneDeep(this.defaults),this.a.themes[""+a.theme]));for(b in a)switch(c=a[b],b){case"clusterColors":a.clusterColours=c;break;case"backgroundColor":a.backgroundColour=c;break;case"nodeColor":a[nodeColour]=c}return this.a.conf=_.merge(_.cloneDeep(this.defaults),a)},b.prototype.instances=[],b.prototype.getInst=function(a){var c;return c=parseInt(d3.select(a).attr("alchInst")),b.prototype.instances[c]},b}(),m="undefined"!=typeof exports&&null!==exports?exports:this,m.Alchemy=b,m.alchemy={begin:function(a){return m.alchemy=new b(a)}},a=function(){function a(a){this.a=a,this.get=this.Get(a,this),this.create=this.Create(a,this),this.set=this.Set(a,this),this.remove=l.remove,this.force=this.Force(a,this),this.filter=this.Filter(a,this),this.search=this.Search(a,this),this._el=[],this._elType=null,this._makeChain=function(a,b){var c,d,e;for(this.__proto__=[].__proto__,b.__proto__=[].__proto__;this.length;)this.pop();for(;b.length;)b.pop();for(d=0,e=a.length;e>d;d++)c=a[d],this.push(c);return Array.prototype.push.apply(b,this._el),_.extend(b,this)}}return a}(),a.prototype.Create=function(a,c){return{a:a,api:c,nodes:function(){var a,c,d,e,f,g,h;for(d=arguments[0],e=2<=arguments.length?o.call(arguments,1):[],a=this.a,f=function(b){var c;return a._nodes[b.id]?console.warn("A node with the id "+b.id+" already exists.\nConsider using the @a.get.nodes() method to \nretrieve the node and then using the Node methods."):(c=new a.models.Node(b),a._nodes[b.id]=c,[c])},e=_.uniq(_.flatten(arguments)),g=0,h=e.length;h>g;g++)c=e[g],f(c);return this.a.initial?(this.a.index=b.prototype.Index(this.a),this.a.updateGraph()):void 0},edges:function(){var a,c,d,e,f;return d=arguments[0],e=2<=arguments.length?o.call(arguments,1):[],a=this.a,f=function(b){var c,d;return b.id&&!a._edges[b.id]?(c=new a.models.Edge(b),a._edges[b.id]=[c],[c]):b.id&&a._edges[b.id]?console.warn("An edge with that id "+someEdgeMap.id+" already exists.\nConsider using the @a.get.edge() method to \nretrieve the edge and then using the Edge methods.\nNote: id's are not required for edges.  Alchemy will create\nan unlimited number of edges for the same source and target node.\nSimply omit 'id' when creating the edge."):(d=a._edges[""+b.source+"-"+b.target],d?(c=new a.models.Edge(b,d.length),d.push(c),[c]):(c=new a.models.Edge(b,0),a._edges[""+b.source+"-"+b.target]=[c],[c]))},c=_.uniq(_.flatten(arguments)),_.each(c,function(a){return f(a)}),this.a.initial?(this.a.index=b.prototype.Index(this.a),this.a.updateGraph()):void 0}}},a.prototype.Filter=function(a,b){var c,d;return c=a,d=function(a){return _.each(b._el,function(c){var d;return d=function(){return"edge"===b._elType,"node"===b._elType?"_nodeType":void 0}(),c[d]===a?c.toggleHidden():void 0})},d.nodes=function(a){var b;return b=c.elements.nodes.val,_.each(b,function(b){return b._nodeType===a?b.toggleHidden():void 0})},d.edges=function(a){var b;return b=c.elements.edges.flat,_.each(b,function(b){return b._edgeType===a?b.toggleHidden():void 0})},d},a.prototype.Force=function(a){var b;return b=a,{toggle:function(){return b.force.alpha()>0?b.force.stop():b.force.resume()},start:function(){return b.force.start()},stop:function(){return b.force.stop()}}},a.prototype.Get=function(a,b){return{a:a,api:b,nodes:function(){var a,b,c,d,e,f;return d=arguments[0],e=2<=arguments.length?o.call(arguments,1):[],f=[],null!=d&&(c=_.flatten(arguments),b=_.map(c,function(a){return String(a)}),a=this.a,f=function(a){return _.filter(a._nodes,function(a,c){return _.contains(b,c)?a:void 0})}(a)),this.api._elType="node",this.api._el=f,this.api._makeChain(f,this)},edges:function(){var a,b,c,d,e;return d=arguments[0],e=2<=arguments.length?o.call(arguments,1):[],c=[],null!=d&&(b=_.map(arguments,function(a){return String(a)}),a=this.a,c=function(a){return _.flatten(_.filter(a._edges,function(a,c){return _.contains(b,c)?a:void 0}))}(a)),this.api._elType="edge",this.api._el=c,this.api._makeChain(c,this)},all:function(){var a,b;return a=this.a,b=this.api._elType,this.api._el=function(b){switch(b){case"node":return a.elements.nodes.val;case"edge":return a.elements.edges.flat}}(b),this.api._makeChain(this.api._el,this)},elState:function(a){var b;return b=_.filter(this.api._el,function(b){return b._state===a}),this.api._el=b,this.api._makeChain(b,this)},state:function(){return null!=this.a.state.key?this.a.state.key:void 0},type:function(a){var b;return b=_.filter(this.api._el,function(b){return b._nodeType===a||b._edgeType===a}),this.api._el=b,this.api._makeChain(b,this)},activeNodes:function(){return _.filter(this.a._nodes,function(a){return"active"===a._state?a:void 0})},activeEdges:function(){return _.filter(this.a.get.allEdges(),function(a){return"active"===a._state?a:void 0})},state:function(){return null!=this.a.state.key?this.a.state.key:void 0},clusters:function(){var a,b;return a=this.a.layout._clustering.clusterMap,b={},_.each(a,function(a,c){return b[c]=_.select(this.a.get.allNodes(),function(a){return a.getProperties()[this.a.conf.clusterKey]===c})}),b},clusterColours:function(){var a,b;return b=this.a.layout._clustering.clusterMap,a={},_.each(b,function(b,c){return a[c]=this.a.conf.clusterColours[b%this.a.conf.clusterColours.length]}),a},allEdges:function(){return this.a.elements.nodes.flat},allNodes:function(a){return null!=a?_.filter(this.a._nodes,function(b){return b._nodeType===a?b:void 0}):this.a.elements.nodes.val},getNodes:function(){var a,b,c;return b=arguments[0],c=2<=arguments.length?o.call(arguments,1):[],a=this.a,c.push(b),_.map(c,function(b){return a._nodes[b]})},getEdges:function(a,b){var c,d;return null==a&&(a=null),null==b&&(b=null),c=this.a,null!=a&&null!=b?(d=""+a+"-"+b,this.a._edges[d]):null!=a&&null==b?this.a._nodes[a]._adjacentEdges:void 0}}},l={remove:function(){return _.each(this._el,function(a){return a.remove()})}},a.prototype.Search=function(a,b){var c,d;return c=a,d=function(a){var d;return a=function(){return"contains"===c.conf.searchMethod?a:"begins"===c.conf.searchMethod?"^"+a:void 0}(),d=new RegExp(a,"i"),_.filter(b._el,function(a){return d.test(a._properties.caption)})},d.nodes=function(a){var b;return a=function(){return"contains"===c.conf.searchMethod?a:"begins"===c.conf.searchMethod?"^"+a:void 0}(),b=new RegExp(a,"i"),_.filter(c._nodes,function(a){return b.test(a._properties.caption)})},d.edges=function(a){var b;return a=function(){return"contains"===c.conf.searchMethod?a:"begins"===c.conf.searchMethod?"^"+a:void 0}(),b=new RegExp(a,"i"),_.filter(c.elements.edges.flat,function(a){return b.test(a._properties.caption)})},d},a.prototype.Set=function(a,b){return{a:a,api:b,state:function(a,b){return this.a.state.key=b}}},c=function(){function a(a){var b,c,d,e,f,g,h,i;this.a=a,d=this.a._nodes,c=this.a.conf,b=this,this.clusterKey=c.clusterKey,this.identifyClusters(this.a),e=-500,i=function(a){var b,c;return b=d[a.source.id]._properties[this.clusterKey],c=d[a.target.id]._properties[this.clusterKey],b===c?.15:0},f=function(){return.7},h=function(a){return d=a.self.a._nodes,d[a.source.id]._properties.root||d[a.target.id]._properties.root?300:d[a.source.id]._properties[this.clusterKey]===d[a.target.id]._properties[this.clusterKey]?10:600},g=function(a){return 8*a},this.layout={charge:e,linkStrength:function(a){return i(a)},friction:function(){return f()},linkDistancefn:function(a){return h(a)},gravity:function(a){return g(a)}}}return a.prototype.identifyClusters=function(a){var b,c,d;return c=a.elements.nodes.val,b=_.uniq(_.map(c,function(b){return b.getProperties()[a.conf.clusterKey]})),this.clusterMap=_.zipObject(b,function(){d=[];for(var a=0,c=b.length;c>=0?c>=a:a>=c;c>=0?a++:a--)d.push(a);return d}.apply(this))},a.prototype.getClusterColour=function(a){var b;return b=this.clusterMap[a]%this.a.conf.clusterColours.length,this.a.conf.clusterColours[b]},a.prototype.edgeGradient=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o;for(c=this.a.vis.select(""+this.a.conf.divSelector+" svg"),b={},j=this.a._nodes,n=_.map(a,function(a){return a._d3}),l=0,m=n.length;m>l;l++)if(d=n[l],!j[d.source.id]._properties.root&&!j[d.target.id]._properties.root&&j[d.source.id]._properties[this.clusterKey]!==j[d.target.id]._properties[this.clusterKey]&&j[d.target.id]._properties[this.clusterKey]!==j[d.source.id]._properties[this.clusterKey]){if(h=j[d.source.id]._properties[this.clusterKey]+"-"+j[d.target.id]._properties[this.clusterKey],h in b)continue;h in b||(k=this.getClusterColour(j[d.target.id]._properties[this.clusterKey]),e=this.getClusterColour(j[d.source.id]._properties[this.clusterKey]),b[h]={startColour:k,endColour:e})}o=[];for(i in b)g="cluster-gradient-"+i,f=c.append("svg:linearGradient").attr("id",g),f.append("svg:stop").attr("offset","0%").attr("stop-color",b[i].startColour),o.push(f.append("svg:stop").attr("offset","100%").attr("stop-color",b[i].endColour));return o},a}(),b.prototype.clusterControls={init:function(){var a;return a="<input class='form-control form-inline' id='cluster-key' placeholder=\"Cluster Key\"></input>",this.a.dash.select("#clustering-container").append("div").attr("id","cluster-key-container").attr("class","property form-inline form-group").html(a).style("display","none"),this.a.dash.select("#cluster_control_header").on("click",function(){var a,b;return b=this.a.dash.select("#cluster-key-container"),a=b.style("display")}),element.style("display",function(){return"block"===display?"none":"block"}),"none"===this.a.dash.select("#cluster-key-container").style("display")?this.a.dash.select("#cluster-arrow").attr("class","fa fa-2x fa-caret-right"):this.a.dash.select("#cluster-arrow").attr("class","fa fa-2x fa-caret-down"),this.a.dash.select("#cluster-key").on("keydown",function(){return"Enter"===d3.event.keyIdentifier?(this.a.conf.cluster=!0,this.a.conf.clusterKey=this.value,this.a.generateLayout()):void 0})}},b.prototype.controlDash=function(a){var b;return b=a,{init:function(){var a;return this.dashIsShown()?(a=b.conf.divSelector,b.dash=d3.select(""+a).append("div").attr("id","control-dash-wrapper").attr("class","col-md-4 initial"),b.dash.append("i").attr("id","dash-toggle").attr("class","fa fa-flask col-md-offset-12"),b.dash.append("div").attr("id","control-dash").attr("class","col-md-12"),b.dash.select("#dash-toggle").on("click",b.interactions.toggleControlDash),b.controlDash.zoomCtrl(),b.controlDash.search(),b.controlDash.filters(),b.controlDash.stats(),b.controlDash.clustering(),b.controlDash.exports()):void 0},search:function(){return b.conf.search?(b.dash.select("#control-dash").append("div").attr("id","search").html("<div class='input-group'>\n    <input class='form-control' placeholder='Search'>\n    <i class='input-group-addon search-icon'><span class='fa fa-search fa-1x'></span></i>\n</div> "),b.search.init()):void 0},zoomCtrl:function(){return b.conf.zoomControls?(b.dash.select("#control-dash-wrapper").append("div").attr("id","zoom-controls").attr("class","col-md-offset-12").html("<button id='zoom-reset'  class='btn btn-defualt btn-primary'><i class='fa fa-crosshairs fa-lg'></i></button> <button id='zoom-in'  class='btn btn-defualt btn-primary'><i class='fa fa-plus'></i></button> <button id='zoom-out' class='btn btn-default btn-primary'><i class='fa fa-minus'></i></button>"),b.dash.select("#zoom-in").on("click",function(){return b.interactions.clickZoom("in")}),b.dash.select("#zoom-out").on("click",function(){return b.interactions.clickZoom("out")}),b.dash.select("#zoom-reset").on("click",function(){return b.interactions.clickZoom("reset")})):void 0},filters:function(){return b.conf.nodeFilters||b.conf.edgeFilters?(b.dash.select("#control-dash").append("div").attr("id","filters"),b.filters.init()):void 0},stats:function(){var a;return b.conf.nodeStats||b.conf.edgeStats?(a='<div id = "stats-header" data-toggle="collapse" data-target="#stats #all-stats">\n<h3>\n    Statistics\n</h3>\n<span class = "fa fa-caret-right fa-2x"></span>\n</div>\n<div id="all-stats" class="collapse">\n    <ul class = "list-group" id="node-stats"></ul>\n    <ul class = "list-group" id="rel-stats"></ul>  \n</div>',b.dash.select("#control-dash").append("div").attr("id","stats").html(a).select("#stats-header").on("click",function(){return b.dash.select("#all-stats").classed("in")?b.dash.select("#stats-header>span").attr("class","fa fa-2x fa-caret-right"):b.dash.select("#stats-header>span").attr("class","fa fa-2x fa-caret-down")}),b.stats.init()):void 0},exports:function(){var a;return b.conf.exportSVG?(a='<div id="exports-header" data-toggle="collapse" data-target="#all-exports" style="padding:10px;">\n    <h3>\n        Exports\n    </h3>\n    <span class="fa fa-caret-right fa-2x"></span>\n</div>\n<div id="all-exports" class="collapse"></div>',b.dash.select("#control-dash").append("div").attr("id","exports").attr("style","padding: 0.5em 1em; border-bottom: thin dashed #E89619; color: white;").html(a).select("#exports-header"),b.exports.init()):void 0},clustering:function(){var a;return b.conf.clusterControl?(a='<div id="clustering-container">\n    <div id="cluster_control_header" data-toggle="collapse" data-target="#clustering #cluster-options">\n         <h3>Clustering</h3>\n        <span id="cluster-arrow" class="fa fa-2x fa-caret-right"></span>\n    </div>\n</div>',b.dash.select("#control-dash").append("div").attr("id","clustering").html(a).select("#cluster_control_header"),b.clusterControls.init()):void 0},dashIsShown:function(){var a;return a=b.conf,a.showEditor||a.captionToggle||a.toggleRootNodes||a.removeElement||a.clusterControl||a.nodeStats||a.edgeStats||a.edgeFilters||a.nodeFilters||a.edgesToggle||a.nodesToggle||a.search||a.exportSVG}}},b.prototype.filters=function(){return function(a){var b;return b=a,{init:function(){var a,c,d,e,f,g,h,i,j,k,l,m;if(b.filters.show(),b.conf.edgeFilters&&b.filters.showEdgeFilters(),b.conf.nodeFilters&&b.filters.showNodeFilters(),b.conf.nodeTypes){for(e=Object.keys(b.conf.nodeTypes),g="",m=b.conf.nodeTypes[e],i=0,k=m.length;k>i;i++)f=m[i],a=f.replace("_"," "),g+="<li class='list-group-item nodeType' role='menuitem' id='li-"+f+"' name="+f+">"+a+"</li>";b.dash.select("#node-dropdown").html(g)}if(b.conf.edgeTypes){for(h=_.isPlainObject(b.conf.edgeTypes)?_.values(b.conf.edgeTypes)[0]:b.conf.edgeTypes,d="",j=0,l=h.length;l>j;j++)c=h[j],a=c.replace("_"," "),d+="<li class='list-group-item edgeType' role='menuitem' id='li-"+c+"' name="+c+">"+a+"</li>";b.dash.select("#rel-dropdown").html(d)}return b.conf.captionsToggle&&b.filters.captionsToggle(),b.conf.edgesToggle&&b.filters.edgesToggle(),b.conf.nodesToggle&&b.filters.nodesToggle(),b.filters.update()},show:function(){var a;return a='<div id = "filter-header" data-toggle="collapse" data-target="#filters form">\n    <h3>Filters</h3>\n    <span class = "fa fa-2x fa-caret-right"></span>\n</div>\n    <form class="form-inline collapse">\n    </form>',b.dash.select("#control-dash #filters").html(a),b.dash.selectAll("#filter-header").on("click",function(){return b.dash.select("#filters>form").classed("in")?b.dash.select("#filter-header>span").attr("class","fa fa-2x fa-caret-right"):b.dash.select("#filter-header>span").attr("class","fa fa-2x fa-caret-down")}),b.dash.select("#filters form")},showEdgeFilters:function(){var a;return a='<div id="filter-rel-header" data-target = "#rel-dropdown" data-toggle="collapse">\n    <h4>\n        Edge Types\n    </h4>\n    <span class="fa fa-lg fa-caret-right"></span>\n</div>\n<ul id="rel-dropdown" class="collapse list-group" role="menu">\n</ul>',b.dash.select("#filters form").append("div").attr("id","filter-relationships").html(a),b.dash.select("#filter-rel-header").on("click",function(){return b.dash.select("#rel-dropdown").classed("in")?b.dash.select("#filter-rel-header>span").attr("class","fa fa-lg fa-caret-right"):b.dash.select("#filter-rel-header>span").attr("class","fa fa-lg fa-caret-down")})},showNodeFilters:function(){var a;return a='<div id="filter-node-header" data-target = "#node-dropdown" data-toggle="collapse">\n    <h4>\n        Node Types\n    </h4>\n    <span class="fa fa-lg fa-caret-right"></span>\n</div>\n<ul id="node-dropdown" class="collapse list-group" role="menu">\n</ul>',b.dash.select("#filters form").append("div").attr("id","filter-nodes").html(a),b.dash.select("#filter-node-header").on("click",function(){return b.dash.select("#node-dropdown").classed("in")?b.dash.select("#filter-node-header>span").attr("class","fa fa-lg fa-caret-right"):b.dash.select("#filter-node-header>span").attr("class","fa fa-lg fa-caret-down")})},captionsToggle:function(){return b.dash.select("#filters form").append("li").attr({id:"toggle-captions","class":"list-group-item active-label toggle"}).html("Show Captions").on("click",function(){var a;return a=b.dash.select("g text").attr("style"),"display: block"===a?b.dash.selectAll("g text").attr("style","display: none"):b.dash.selectAll("g text").attr("style","display: block")})},edgesToggle:function(){return b.dash.select("#filters form").append("li").attr({id:"toggle-edges","class":"list-group-item active-label toggle"}).html("Toggle Edges").on("click",function(){return _.contains(_.pluck(_.flatten(_.values(b._edges)),"_state"),"active")?_.each(_.values(b._edges),function(a){return _.each(a,function(a){return"active"===a._state?a.toggleHidden():void 0})}):_.each(_.values(b._edges),function(a){return _.each(a,function(a){var c,d;return c=b._nodes[a._properties.source],d=b._nodes[a._properties.target],"active"===c._state&&"active"===d._state?a.toggleHidden():void 0})})})},nodesToggle:function(){return b.dash.select("#filters form").append("li").attr({id:"toggle-nodes","class":"list-group-item active-label toggle"}).html("Toggle Nodes").on("click",function(){var a;return a=_.values(b._nodes),_.contains(_.pluck(a,"_state"),"active")?_.each(a,function(a){return b.conf.toggleRootNodes&&a._d3.root?void 0:"active"===a._state?a.toggleHidden():void 0}):_.each(_.values(b._nodes),function(a){return b.conf.toggleRootNodes&&a._d3.root?void 0:a.toggleHidden()})})},update:function(){return b.dash.selectAll(".nodeType, .edgeType").on("click",function(){var a,c;return a=d3.select(this),c=a.attr("name"),b.vis.selectAll("."+c).each(function(a){var c,d,e,f;return null!=b._nodes[a.id]?(d=b._nodes[a.id],d.toggleHidden()):(c=b._edges[a.id][0],e=b._nodes[c._properties.source],f=b._nodes[c._properties.target],"active"===e._state&&"active"===f._state?c.toggleHidden():void 0)}),b.stats.nodeStats()})}}}}(this),b.prototype.Index=function(a){var b,c,d,e;return b=a,d={nodes:{val:function(){return _.values(b._nodes)}()},edges:{val:function(){return _.values(b._edges)}()}},e=d.nodes,c=d.edges,d.edges.flat=function(){return _.flatten(c.val)}(),d.nodes.d3=function(){return _.map(e.val,function(a){return a._d3})}(),d.edges.d3=function(){return _.map(c.flat,function(a){return a._d3})}(),b.initial&&(d.nodes.svg=function(){return b.vis.selectAll("g.node")}(),d.edges.svg=function(){return b.vis.selectAll("g.edge")}()),b.elements=d,function(){return b.elements.nodes.svg=function(){return b.vis.selectAll("g.node")}(),b.elements.edges.svg=function(){return b.vis.selectAll("g.edge")}()}},b.prototype.interactions=function(a){var c;return c=a,{edgeClick:function(a){var b;if(!d3.event.defaultPrevented)return d3.event.stopPropagation(),b=a.self,"function"==typeof c.conf.edgeClick&&c.conf.edgeClick(b),"hidden"!==b._state?(b._state="highlighted"===b._state?"selected":"active",b.setStyles()):void 0},edgeMouseOver:function(a){var b;return b=a.self,"hidden"!==b._state?("selected"!==b._state&&(b._state="highlighted"),b.setStyles()):void 0},edgeMouseOut:function(a){var b;return b=a.self,"hidden"!==b._state?("selected"!==b._state&&(b._state="active"),b.setStyles()):void 0},nodeMouseOver:function(a){var b;if(b=a.self,"hidden"!==b._state){if("selected"!==b._state&&(b._state="highlighted",b.setStyles()),"function"==typeof c.conf.nodeMouseOver)return c.conf.nodeMouseOver(b);if("number"==typeof c.conf.nodeMouseOver)return b.properties[c.conf.nodeMouseOver]}},nodeMouseOut:function(a){var b;return b=a.self,c=b.a,"hidden"!==b._state&&("selected"!==b._state&&(b._state="active",b.setStyles()),null!=c.conf.nodeMouseOut&&"function"==typeof c.conf.nodeMouseOut)?c.conf.nodeMouseOut(a):void 0},nodeClick:function(a){var b;if(!d3.event.defaultPrevented)return d3.event.stopPropagation(),b=a.self,"function"==typeof c.conf.nodeClick&&c.conf.nodeClick(b),"hidden"!==b._state?(b._state=function(){return"selected"===b._state?"active":"selected"}(),b.setStyles()):void 0},zoom:function(a){return null==this._zoomBehavior&&(this._zoomBehavior=d3.behavior.zoom()),this._zoomBehavior.scaleExtent(a).on("zoom",function(){return c=b.prototype.getInst(this),c.vis.attr("transform","translate("+d3.event.translate+") scale("+d3.event.scale+")")})},clickZoom:function(a){var b,d,e,f;return f=c.vis.attr("transform").match(/(-*\d+\.*\d*)/g).map(function(a){return parseFloat(a)}),d=f[0],e=f[1],b=f[2],c.vis.attr("transform",function(){return"in"===a?(b<c.conf.scaleExtent[1]&&(b+=.2),"translate("+d+","+e+") scale("+b+")"):"out"===a?(b>c.conf.scaleExtent[0]&&(b-=.2),"translate("+d+","+e+") scale("+b+")"):"reset"===a?"translate(0,0) scale(1)":console.log("error")}),null==this._zoomBehavior&&(this._zoomBehavior=d3.behavior.zoom()),this._zoomBehavior.scale(b).translate([d,e])},toggleControlDash:function(){var a;return a=c.dash.classed("off-canvas")||c.dash.classed("initial"),c.dash.classed({"off-canvas":!a,initial:!1,"on-canvas":a})},nodeDragStarted:function(a){return d3.event.preventDefault,d3.event.sourceEvent.stopPropagation(),d3.select(this).classed("dragging",!0),a.fixed=!0},nodeDragged:function(a){var b,d;return c=a.self.a,a.x+=d3.event.dx,a.y+=d3.event.dy,a.px+=d3.event.dx,a.py+=d3.event.dy,d=d3.select(this),d.attr("transform","translate("+a.x+", "+a.y+")"),b=a.self._adjacentEdges,_.each(b,function(a){var b;return b=c.vis.select("#edge-"+a.id+"-"+a._index),c._drawEdges.updateEdge(b.data()[0])})},nodeDragended:function(a){return c=a.self.a,d3.select(this).classed({dragging:!1}),c.conf.forceLocked?void 0:c.force.start()},nodeDoubleClick:function(){return null},deselectAll:function(){var a;return c=b.prototype.getInst(this),(null!=(a=d3.event)?a.defaultPrevented:0)?void 0:(c.conf.showEditor===!0&&c.modifyElements.nodeEditorClear(),_.each(c._nodes,function(a){return a._state="active",a.setStyles()}),_.each(c._edges,function(a){return _.each(a,function(a){return a._state="active",a.setStyles()})}),c.conf.deselectAll?c.conf.deselectAll():void 0)}}},k=function(){function a(a){this.tick=p(this.tick,this),this.linkStrength=p(this.linkStrength,this),this.gravity=p(this.gravity,this);var b,c,d;this.a=b=a,c=this.a.conf,d=this.a._nodes,this.k=Math.sqrt(Math.log(_.size(this.a._nodes))/(c.graphWidth()*c.graphHeight())),this._clustering=new this.a.clustering(this.a),this.d3NodeInternals=b.elements.nodes.d3,c.cluster?(this._charge=function(){return this._clustering.layout.charge},this._linkStrength=function(a){return this._clustering.layout.linkStrength(a)}):(this._charge=function(){return-10/this.k},this._linkStrength=function(a){return d[a.source.id].getProperties("root")||d[a.target.id].getProperties("root")?1:.9}),c.cluster?this._linkDistancefn=function(a){return this._clustering.layout.linkDistancefn(a)}:"default"===c.linkDistancefn?this._linkDistancefn=function(){return 1/(50*this.k)}:"number"==typeof c.linkDistancefn?this._linkDistancefn=function(){return c.linkDistancefn}:"function"==typeof c.linkDistancefn&&(this._linkDistancefn=function(a){return c.linkDistancefn(a)})}return a.prototype.gravity=function(){return this.a.conf.cluster?this._clustering.layout.gravity(this.k):50*this.k},a.prototype.linkStrength=function(a){return this._linkStrength(a)},a.prototype.friction=function(){return.9},a.prototype.collide=function(a){var b,c,d,e,f,g;return b=this.a.conf,g=2*(a.radius+a["stroke-width"])+b.nodeOverlap,c=a.x-g,d=a.x+g,e=a.y-g,f=a.y+g,function(h,i,j,k,l){var m,n,o;return h.point&&h.point!==a&&(n=a.x-Math.abs(h.point.x),o=a.y-h.point.y,m=Math.sqrt(n*n+o*o),g=g,g>m&&(m=(m-g)/m*b.alpha,a.x-=n*=m,a.y-=o*=m,h.point.x+=n,h.point.y+=o)),i>d||c>k||j>f||e>l}},a.prototype.tick=function(){var a,b,c,d,e,f,g,h;if(a=this.a,d=a.elements.nodes.svg,b=a.elements.edges.svg,a.conf.collisionDetection)for(e=d3.geom.quadtree(this.d3NodeInternals),h=this.d3NodeInternals,f=0,g=h.length;g>f;f++)c=h[f],e.visit(this.collide(c));return d.attr("transform",function(a){return"translate("+a.x+","+a.y+")"}),this.drawEdge=a.drawing.DrawEdge,this.drawEdge.styleText(b),this.drawEdge.styleLink(b)},a.prototype.positionRootNodes=function(){var a,b,c,d,e,f,g,h,i,j;if(a=this.a.conf,b={width:a.graphWidth(),height:a.graphHeight()},e=_.filter(this.a.elements.nodes.val,function(a){return a.getProperties("root")}),1!==e.length){for(j=[],c=f=0,g=e.length;g>f;c=++f)d=e[c],d._d3.x=b.width/Math.sqrt(e.length*(c+1)),d._d3.y=b.height/2,j.push(d._d3.fixed=!0);return j}d=e[0],h=[b.width/2,b.width/2],d._d3.x=h[0],d._d3.px=h[1],i=[b.height/2,b.height/2],d._d3.y=i[0],d._d3.py=i[1],d._d3.fixed=!0},a.prototype.chargeDistance=function(){return 500},a.prototype.linkDistancefn=function(a){return this._linkDistancefn(a)},a.prototype.charge=function(){return this._charge()},a}(),b.prototype.generateLayout=function(a){var b;return b=a,function(a){var c;return null==a&&(a=!1),c=b.conf,b.layout=new k(b),b.force=d3.layout.force().size([c.graphWidth(),c.graphHeight()]).theta(1).gravity(b.layout.gravity()).friction(b.layout.friction()).nodes(b.elements.nodes.d3).links(b.elements.edges.d3).linkDistance(function(a){return b.layout.linkDistancefn(a)}).linkStrength(function(a){return b.layout.linkStrength(a)}).charge(b.layout.charge()).chargeDistance(b.layout.chargeDistance())}},b.prototype.search=function(a){var b;return b=a,{init:function(){var a;return a=b.dash.select("#search input"),a.on("keyup",function(){var c;return c=a[0][0].value.toLowerCase(),b.vis.selectAll(".node").classed("inactive",!1),b.vis.selectAll("text").attr("style",function(){return""!==c?"display: inline;":void 0}),b.vis.selectAll(".node").classed("inactive",function(a){var d,e;switch(d=d3.select(this).text(),b.conf.searchMethod){case"contains":e=d.toLowerCase().indexOf(c)<0;break;case"begins":e=0!==d.toLowerCase().indexOf(c)}return e?b.vis.selectAll("[source-target*='"+a.id+"']").classed("inactive",e):b.vis.selectAll("[source-target*='"+a.id+"']").classed("inactive",function(a){var c,d,e;return c=[a.source.id,a.target.id],d=b.vis.select("#node-"+c[0]).classed("inactive"),e=b.vis.select("#node-"+c[1]).classed("inactive"),e||d}),e})})}}},b.prototype.startGraph=function(a){var c;return c=a,function(a){var d,e,f,g,h,i;if(d=c.conf,d3.select(d.divSelector).empty()&&console.warn(c.utils.warnings.divWarning()),a||(a={nodes:[],edges:[]},c.utils.warnings.dataWarning()),null==a.edges&&(a.edges=[]),c.create.nodes(a.nodes),a.edges.forEach(function(a){return c.create.edges(a)}),c.vis=d3.select(d.divSelector).attr("style","width:"+d.graphWidth()+"px; height:"+d.graphHeight()+"px; background:"+d.backgroundColour+";").append("svg").attr("xmlns","http://www.w3.org/2000/svg").attr("xlink","http://www.w3.org/1999/xlink").attr("pointer-events","all").attr("style","background:"+d.backgroundColour+";").attr("alchInst",b.prototype.instances.length-1).on("click",c.interactions.deselectAll).call(c.interactions.zoom(d.scaleExtent)).on("dblclick.zoom",null).append("g").attr("transform","translate("+d.initialTranslate+") scale("+d.initialScale+")"),c.interactions.zoom().scale(d.initialScale),c.interactions.zoom().translate(d.initialTranslate),c.index=b.prototype.Index(c),c.generateLayout(),c.controlDash.init(),e=c.elements.edges.d3,f=c.elements.nodes.d3,c.layout.positionRootNodes(),c.force.start(),d.forceLocked)for(;c.force.alpha()>.005;)c.force.tick();return c._drawEdges=c.drawing.DrawEdges,c._drawNodes=c.drawing.DrawNodes,c._drawEdges.createEdge(e),c._drawNodes.createNode(f),c.index(),c.elements.nodes.svg.attr("transform",function(a){return"translate("+a.x+", "+a.y+")"}),console.log(Date()+" completed initial computation"),d.forceLocked||c.force.on("tick",c.layout.tick).start(),null!=d.afterLoad&&("function"==typeof d.afterLoad?d.afterLoad():"string"==typeof d.afterLoad&&(c[d.afterLoad]=!0)),d.cluster&&(g=d3.select(""+c.conf.divSelector+" svg").append("svg:defs")),d.nodeStats&&c.stats.nodeStats(),d.showEditor&&(h=new c.editor.Editor,i=new c.editor.Interactions,d3.select("body").on("keydown",i.deleteSelected),h.startEditor()),c.initial=!0}},b.prototype.stats=function(a){var b;return b=a,{init:function(){return b.stats.update()},nodeStats:function(){var a,c,d,e,f,g,h,i,j,k,l,m,n,o;if(f=[],c=b.get.allNodes().length,a=b.get.activeNodes().length,e=c-a,j="<li class = 'list-group-item gen_node_stat'>Number of nodes: <span class='badge'>"+c+"</span></li> <li class = 'list-group-item gen_node_stat'>Number of active nodes: <span class='badge'>"+a+"</span></li> <li class = 'list-group-item gen_node_stat'>Number of inactive nodes: <span class='badge'>"+e+"</span></li></br>",b.conf.nodeTypes){for(h=Object.keys(b.conf.nodeTypes),l="",o=b.conf.nodeTypes[h],m=0,n=o.length;n>m;m++)k=o[m],d=k.replace("_"," "),i=b.vis.selectAll("g.node."+k)[0].length,l+="<li class = 'list-group-item nodeType' id='li-"+k+"' name = "+d+">Number of <strong style='text-transform: uppercase'>"+d+"</strong> nodes: <span class='badge'>"+i+"</span></li>",f.push([""+k,i]);j+=l}return g="<li id='node-stats-graph' class='list-group-item'></li>",j+=g,b.dash.select("#node-stats").html(j),this.insertSVG("node",f)},edgeStats:function(){var a,c,d,e,f,g,h,i,j,k,l,m,n;if(e=[],c=b.get.allEdges().length,a=b.get.activeEdges().length,l=c-a,i="<li class = 'list-group-item gen_edge_stat'>Number of relationships: <span class='badge'>"+c+"</span></li> <li class = 'list-group-item gen_edge_stat'>Number of active relationships: <span class='badge'>"+a+"</span></li> <li class = 'list-group-item gen_edge_stat'>Number of inactive relationships: <span class='badge'>"+l+"</span></li></br>",b.conf.edgeTypes){for(g=_.values(alchemy.conf.edgeTypes)[0],k="",m=0,n=g.length;n>m;m++)j=g[m],j&&(d=j.replace("_"," "),h=_.filter(b.get.allEdges(),function(a){return a._edgeType===j?a:void 0
}).length,k+="<li class = 'list-group-item edgeType' id='li-"+j+"' name = "+d+">Number of <strong style='text-transform: uppercase'>"+d+"</strong> relationships: <span class='badge'>"+h+"</span></li>",e.push([""+d,h]));i+=k}return f="<li id='node-stats-graph' class='list-group-item'></li>",i+=f,b.dash.select("#rel-stats").html(i),this.insertSVG("edge",e)},insertSVG:function(a,c){var d,e,f,g,h,i,j,k;return null===c?b.dash.select("#"+a+"-stats-graph").html("<br><h4 class='no-data'>There are no "+a+"Types listed in your conf.</h4>"):(k=.25*b.conf.graphWidth(),g=250,i=k/4,f=d3.scale.category20(),d=d3.svg.arc().outerRadius(i-10).innerRadius(i/2),h=d3.layout.pie().sort(null).value(function(a){return a[1]}),j=b.dash.select("#"+a+"-stats-graph").append("svg").append("g").style({width:k,height:g}).attr("transform","translate("+k/2+","+g/2+")"),e=j.selectAll(".arc").data(h(c)).enter().append("g").classed("arc",!0).on("mouseover",function(a,d){return b.dash.select("#"+c[d][0]+"-stat").classed("hidden",!1)}).on("mouseout",function(a,d){return b.dash.select("#"+c[d][0]+"-stat").classed("hidden",!0)}),e.append("path").attr("d",d).attr("stroke",function(a,b){return f(b)}).attr("stroke-width",2).attr("fill-opacity","0.3"),e.append("text").attr("transform",function(a){return"translate("+d.centroid(a)+")"}).attr("id",function(a,b){return""+c[b][0]+"-stat"}).attr("dy",".35em").classed("hidden",!0).text(function(a,b){return c[b][0]}))},update:function(){return b.conf.nodeStats&&this.nodeStats(),b.conf.edgeStats?this.edgeStats():void 0}}},b.prototype.updateGraph=function(a){var b;return b=a,function(){for(b.generateLayout(),b._drawEdges.createEdge(b.elements.edges.d3),b._drawNodes.createNode(b.elements.nodes.d3),b.index(),b.layout.positionRootNodes(),b.force.start();b.force.alpha()>.005;)b.force.tick();return b.force.on("tick",b.layout.tick).start(),b.elements.nodes.svg.attr("transform",function(a){return"translate("+a.x+", "+a.y+")"})}},b.prototype.defaults={plugins:null,renderer:"svg",graphWidth:function(){return d3.select(this.divSelector).node().parentElement.clientWidth},graphHeight:function(){return"BODY"===d3.select(this.divSelector).node().parentElement.nodeName?window.innerHeight:d3.select(this.divSelector).node().parentElement.clientHeight},alpha:.5,collisionDetection:!0,nodeOverlap:25,fixNodes:!1,fixRootNodes:!1,forceLocked:!0,linkDistancefn:"default",nodePositions:null,showEditor:!1,captionToggle:!1,toggleRootNodes:!1,removeElement:!1,cluster:!1,clusterKey:"cluster",clusterColours:d3.shuffle(["#DD79FF","#FFFC00","#00FF30","#5168FF","#00C0FF","#FF004B","#00CDCD","#f83f00","#f800df","#ff8d8f","#ffcd00","#184fff","#ff7e00"]),clusterControl:!1,nodeStats:!1,edgeStats:!1,edgeFilters:!1,nodeFilters:!1,edgesToggle:!1,nodesToggle:!1,zoomControls:!1,nodeCaption:"caption",nodeCaptionsOnByDefault:!1,nodeStyle:{all:{radius:10,color:"#68B9FE",borderColor:"#127DC1",borderWidth:function(a,b){return b/3},captionColor:"#FFFFFF",captionBackground:null,captionSize:12,selected:{color:"#FFFFFF",borderColor:"#349FE3"},highlighted:{color:"#EEEEFF"},hidden:{color:"none",borderColor:"none"}}},nodeColour:null,nodeMouseOver:"caption",nodeRadius:10,nodeTypes:null,rootNodes:"root",rootNodeRadius:15,nodeClick:null,nodePadding:0,edgeCaption:"caption",edgeCaptionsOnByDefault:!1,edgeStyle:{all:{width:4,color:"#CCC",opacity:.2,directed:!0,curved:!0,selected:{opacity:1},highlighted:{opacity:1},hidden:{opacity:0}}},edgeTypes:null,curvedEdges:!1,edgeWidth:function(){return 4},edgeOverlayWidth:20,directedEdges:!1,edgeArrowSize:5,edgeClick:null,search:!1,searchMethod:"contains",backgroundColour:"#000000",theme:null,afterLoad:"afterLoad",divSelector:"#alchemy",dataSource:null,initialScale:1,initialTranslate:[0,0],scaleExtent:[.5,2.4],exportSVG:!1,dataWarning:"default",warningMessage:"There be no data!  What's going on?"},d=function(a){return{a:a,createLink:function(a){var b;return b=this.a.conf,a.append("path").attr("class","edge-line").attr("id",function(a){return"path-"+a.id}),a.filter(function(a){return null!=a.caption}).append("text").append("textPath").classed("textpath",!0)},triangle:function(a){var b,c,d;return d=a.target.x-a.source.x,b=a.target.y-a.source.y,c=Math.sqrt(b*b+d*d),[d,b,c]},edgeData:function(a){var b,c,d,e,f,g,h,i;return i=this.triangle(a),h=i[0],e=i[1],f=i[2],d=a["stroke-width"],b=2,g=a.source.radius+a.source["stroke-width"]-d/2+b,c=f-g-1.5*b,{edgeAngle:Math.atan2(e,h)/Math.PI*180,edgeLength:c}},edgeAngle:function(a){var b,c;return c=a.target.x-a.source.x,b=a.target.y-a.source.y,Math.atan2(b,c)/Math.PI*180},edgeStyle:function(a){var b,c,d,e,f;return c=this.a.conf,d=this.a._edges[a.id][a.pos],f=this.a.svgStyles.edge.populate(d),e=this.a._nodes,this.a.conf.cluster&&(b=this.a.layout._clustering,f.stroke=function(a){var d,f,g,h,i,j;return d=c.clusterKey,i=e[a.source.id]._properties,j=e[a.target.id]._properties,i.root||j.root?(h=i.root?j[d]:i[d],""+b.getClusterColour(h)):i[d]===j[d]?(h=i[d],""+b.getClusterColour(h)):i[d]!==j[d]?(g=""+i[d]+"-"+j[d],f="cluster-gradient-"+g,"url(#"+f+")"):void 0}(a)),f},edgeWalk:function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U;return e=this.a,K=function(a){return a*a},I=a.source,R=a.target,e.conf.curvedEdges?(F=1.7*e.conf.edgeWidth(),i=.6*e.conf.edgeWidth(),H=i/2,C=2.4*H,B=e.conf.directedEdges?2*C:1e-4,T=a.source.x-a.target.x,U=a.source.y-a.target.y,p=Math.sqrt(K(T)+K(U)),P=0,Q=0,N=a.source.radius,v=p,w=0,t=a.target.radius,n=v-P,G=(N+F)/(t+B+F),D=-n*G/(1-G),g=1.5,f=g*C*2/N,L=Math.cos(f)*(N+F),M=Math.sin(f)*(N+F),z=M/(L-D),A=M-z*L,E=v,b=1+K(z),c=2*(z*A-E),d=K(A)+K(E)-K(t+B+F),q=(-c-Math.sqrt(K(c)-4*b*d))/(2*b),r=(q-D)*z,x=-L/M,j=M+K(L)/M,y=-(q-v)/r,k=r+(q-v)*q/r,l=(j-k)/(y-x),m=x*l+j,h=Math.sqrt(K(l-L)+K(m-M)),O=function(a){var b,c,d;return d=0>a?-1:1,b=d*Math.sqrt(K(a)/(1+K(x))),c=x*b,""+(L+b)+", "+(M+c)},u=function(a){var b,c,d;return d=0>a?-1:1,b=d*Math.sqrt(K(a)/(1+K(y))),c=y*b,""+(q+b)+", "+(r+c)},s=function(a){var b,c,d;return d=0>a?-1:1,b=d*Math.sqrt(K(a)/(1+K(1/y))),c=b/y,""+(q+b)+", "+(r-c)},e.conf.directedEdges?"M "+O(-H)+" L "+O(H)+" A "+(h-H)+", "+(h-H)+" 0 0 0 "+u(-H)+" L "+u(-C)+" L "+s(B)+" L "+u(C)+" L "+u(H)+" A "+(h+H)+", "+(h+H)+" 0 0 1 "+O(-H)+" Z":"M "+O(-H)+" A "+(h-H)+", "+(h-H)+" 0 0 0 "+u(-H)):(F=e.conf.nodePadding,J=I.radius+F+I["stroke-width"]/2,S=R.radius+F+R["stroke-width"]/2,T=a.source.x-a.target.x,U=a.source.y-a.target.y,o=Math.sqrt(K(T)+K(U)),e.conf.directedEdges?(B=2.4*e.conf.edgeWidth(),"M "+J+" 0 L "+(o-S-B)+" 0 l 0 2 l "+B/2+" -2 l "+-B/2+" -2 L "+(o-S-B)+" 0"):"M "+J+" 0 L "+(o-S)+" 0")},styleLink:function(a){var b,c,d;return b=this.a,c=b.conf,d=b.drawing.DrawEdge,a.each(function(a){var c,e;return e=d3.select(this),c=d.edgeData(a),e.attr("transform","translate("+a.source.x+", "+a.source.y+") rotate("+d.edgeAngle(a)+")"),e.select(".edge-line").attr("d",function(){return d.edgeWalk(a)}()).attr("stroke-width",function(){return b.conf.edgeWidth}()).style(d.edgeStyle(a))})},classEdge:function(a){return a.classed("active",!0)},styleText:function(a){var b;return b=this.a.conf,a.select("text").each(function(a){var c,d,e,f,g;return f=a.source.x-a.target.x,g=a.source.y-a.target.y,e=Math.sqrt(Math.pow(f,2)+Math.pow(g,2)),c=e/2,d=2*-a["stroke-width"],d3.select(this).attr("dx",""+c).attr("dy",""+d).select(".textpath").text(a.caption).attr("xlink:xlink:href","#path-"+a.source.id+"-"+a.target.id).style("display",function(){return b.edgeCaptionsOnByDefault?"block":void 0})})},setInteractions:function(a){var b;return b=this.a.interactions,a.on("click",b.edgeClick).on("mouseover",function(a){return b.edgeMouseOver(a)}).on("mouseout",function(a){return b.edgeMouseOut(a)})}}},e=function(a){return{a:a,createEdge:function(a){var b,c;return c=this.a.drawing.DrawEdge,b=this.a.vis.selectAll("g.edge").data(a),b.enter().append("g").attr("id",function(a){return"edge-"+a.id+"-"+a.pos}).attr("class",function(a){return"edge "+a.edgeType}).attr("source-target",function(a){return""+a.source.id+"-"+a.target.id}),c.createLink(b),c.classEdge(b),c.styleLink(b),c.styleText(b),c.setInteractions(b),b.exit().remove()},updateEdge:function(a){var b,c;return b=this.a.drawing.DrawEdge,c=this.a.vis.select("#edge-"+a.id+"-"+a.pos),b.classEdge(c),b.styleLink(c),b.styleText(c),b.setInteractions(c)}}},f=function(a){return{a:a,styleText:function(a){var b,c,d;return b=this.a.conf,d=this.a.drawing.NodeUtils,c=this.a._nodes,a.selectAll("text").attr("dy",function(a){return c[a.id].getProperties().root?b.rootNodeRadius/2:2*b.nodeRadius-5}).attr("visibility",function(a){return"hidden"===c[a.id]._state?"hidden":"visible"}).text(function(a){return d.nodeText(a)}).style("display",function(){return b.nodeCaptionsOnByDefault?"block":void 0})},createNode:function(a){return a=_.difference(a,a.select("circle").data()),a.__proto__=d3.select().__proto__,a.append("circle").attr("id",function(a){return"circle-"+a.id}),a.append("svg:text").attr("id",function(a){return"text-"+a.id})},styleNode:function(a){var b;return b=this.a.drawing.NodeUtils,a.selectAll("circle").attr("r",function(a){return"function"==typeof a.radius?a.radius():a.radius}).each(function(a){return d3.select(this).style(b.nodeStyle(a))})},setInteractions:function(a){var b,c,d,e,f,g,h;return b=this.a.conf,c=this.a.interactions,e="editor"===this.a.get.state("interactions"),d=d3.behavior.drag().origin(Object).on("dragstart",null).on("drag",null).on("dragend",null),e?(f=new this.a.editor.Interactions,a.on("mouseup",function(a){return f.nodeMouseUp(a)}).on("mouseover",function(a){return f.nodeMouseOver(a)}).on("mouseout",function(a){return f.nodeMouseOut(a)}).on("dblclick",function(a){return c.nodeDoubleClick(a)}).on("click",function(a){return f.nodeClick(a)})):(a.on("mouseup",null).on("mouseover",function(a){return c.nodeMouseOver(a)}).on("mouseout",function(a){return c.nodeMouseOut(a)}).on("dblclick",function(a){return c.nodeDoubleClick(a)}).on("click",function(a){return c.nodeClick(a)}),d=d3.behavior.drag().origin(Object).on("dragstart",c.nodeDragStarted).on("drag",c.nodeDragged).on("dragend",c.nodeDragended),b.fixNodes||(g=a.filter(function(a){return a.root!==!0}),g.call(d)),b.fixRootNodes?void 0:(h=a.filter(function(a){return a.root===!0}),h.call(d)))}}},g=function(a){return{a:a,createNode:function(a){var b,c;return b=this.a.drawing.DrawNode,c=this.a.vis.selectAll("g.node").data(a,function(a){return a.id}),c.enter().append("g").attr("class",function(a){var b;return b=a.self._nodeType,"node "+b+" active"}).attr("id",function(a){return"node-"+a.id}).classed("root",function(a){return a.root}),b.createNode(c),b.styleNode(c),b.styleText(c),b.setInteractions(c),c.exit().remove()},updateNode:function(a){var b,c;return b=this.a.drawing.DrawNode,c=this.a.vis.select("#node-"+a.id),b.styleNode(c),b.styleText(c),b.setInteractions(c)}}},b.prototype.NodeUtils=function(a){var b;return b=a,{nodeStyle:function(a){var c,d;return c=b.conf,d=a.self,c.cluster&&"hidden"!==d._state&&(a.fill=function(){var a,e,f,g,h,i,j;return e=b.layout._clustering,j=d.getProperties(),a=e.clusterMap,i=c.clusterKey,h=c.clusterColours,g=a[j[i]]%h.length,f=h[g],""+f}(a),a.stroke=a.fill),a},nodeText:function(a){var c,d,e;return d=b.conf,e=b._nodes[a.id]._properties,d.nodeCaption&&"string"==typeof d.nodeCaption?null!=e[d.nodeCaption]?e[d.nodeCaption]:"":d.nodeCaption&&"function"==typeof d.nodeCaption?(c=d.nodeCaption(e),(void 0===c||"undefined"===String(c))&&(b.log.caption="At least one caption returned undefined",d.caption=!1),c):void 0}}},b.prototype.svgStyles=function(a){return{a:a,node:{a:this.a,populate:function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;return b=this.a.conf,d=_.omit(b.nodeStyle.all,"selected","highlighted","hidden"),c=a,m=function(a){return"function"==typeof a?a:function(){return a}},g=_.keys(b.nodeTypes)[0],f=a.getProperties()[g],void 0===b.nodeStyle[f]&&(f="all"),n=_.assign(_.cloneDeep(d),b.nodeStyle[f]),k=_.assign(n,b.nodeStyle[f][a._state]),h=m(k.radius),e=m(k.color),i=m(k.borderColor),j=m(k.borderWidth),l={},l.radius=h(c),l.fill=e(c),l.stroke=i(c),l["stroke-width"]=j(c,h(c)),l}},edge:{a:this.a,populate:function(a){var b,c,d,e,f,g,h,i,j,k;return c=this.a.conf,d=_.omit(c.edgeStyle.all,"selected","highlighted","hidden"),i=function(a){return"function"==typeof a?a:function(){return a}},e=a._edgeType,void 0===c.edgeStyle[e]&&(e="all"),j=_.assign(_.cloneDeep(d),c.edgeStyle[e]),g=_.assign(j,c.edgeStyle[e][a._state]),k=i(g.width),b=i(g.color),f=i(g.opacity),h={stroke:b(a),"stroke-width":k(a),opacity:f(a),fill:"none"}},update:function(a){var b,c,d,e,f,g,h;return c=this.a.conf,e=a._style,g=function(a){return"function"==typeof a?a:function(){return a}},h=g(e.width),b=g(e.color),d=g(e.opacity),f={stroke:b(a),"stroke-width":h(a),opacity:d(a),fill:"none"}}}}},h=function(){function a(){this.nodeEditor=p(this.nodeEditor,this),this.startEditor=p(this.startEditor,this),this.utils=new alchemy.editor.Utils}return a.prototype.editorContainerHTML='<div id="editor-header" data-toggle="collapse" data-target="#editor #element-options">\n    <h3>Editor</h3><span class="fa fa-2x fa-caret-right"></span>\n</div>\n<div id="element-options" class="collapse">\n    <ul class="list-group"> \n        <li class="list-group-item" id="remove">Remove Selected</li> \n        <li class="list-group-item" id="editor-interactions">Editor mode enabled, click to disable editor interactions</li>\n    </ul>\n</div>',a.prototype.elementEditorHTML=function(a){return"<h4>"+a+' Editor</h4>\n<form id="add-property-form">\n    <div id="add-property">\n        <input class="form-control" id="add-prop-key" placeholder="New Property Name">\n        <input class="form-control" id="add-prop-value" placeholder="New Property Value">\n    </div>\n    <input id="add-prop-submit" type="submit" value="Add Property" placeholder="add a property to this node">\n</form>\n<form id="properties-list">\n    <input id="update-properties" type="submit" value="Update Properties">\n</form>'},a.prototype.startEditor=function(){var a,b,c,d,e;return a=alchemy.conf.divSelector,d=this.editorContainerHTML,b=alchemy.dash.select("#control-dash").append("div").attr("id","editor").html(d),b.select("#editor-header").on("click",function(){return alchemy.dash.select("#element-options").classed("in")?alchemy.dash.select("#editor-header>span").attr("class","fa fa-2x fa-caret-right"):alchemy.dash.select("#editor-header>span").attr("class","fa fa-2x fa-caret-down")}),c=b.select("#element-options ul #editor-interactions").on("click",function(){return d3.select(this).attr("class",function(){return"editor"===alchemy.get.state()?(alchemy.set.state("interactions","default"),"inactive list-group-item"):(alchemy.set.state("interactions","editor"),"active list-group-item")}).html(function(){return"editor"===alchemy.get.state()?"Disable Editor Interactions":"Enable Editor Interactions"})}),b.select("#element-options ul #remove").on("click",function(){return alchemy.editor.remove()}),e=this.utils,c.on("click",function(){return alchemy.dash.select("#editor-interactions").classed("active")?(e.disableEditor(),alchemy.dash.select("#editor-interactions").classed({active:!1,inactive:!0}).html("Editor mode disabled, click to enable editor interactions")):(e.enableEditor(),alchemy.dash.select("#editor-interactions").classed({active:!0,inactive:!1}).html("Editor mode enabled, click to disable editor interactions"))})},a.prototype.nodeEditor=function(a){var b,c,d,e,f,g,h,i,j,k,l,m;c=alchemy.conf.divSelector,d=alchemy.dash.select("#control-dash #editor"),i=d.select("#element-options"),f=this.elementEditorHTML("Node"),e=i.append("div").attr("id","node-editor").html(f),e.attr("class",function(){var a;return a=alchemy.dash.select("#editor-interactions").classed("active"),a?"enabled":"hidden"}),b=d.select("#node-editor form #add-property"),b.select("#node-add-prop-key").attr("placeholder","New Property Name").attr("value",null),b.select("#node-add-prop-value").attr("placeholder","New Property Value").attr("value",null),alchemy.dash.select("#add-property-form").on("submit",function(){var a,b;return event.preventDefault(),a=alchemy.dash.select("#add-prop-key").property("value"),a=a.replace(/\s/g,"_"),b=alchemy.dash.select("#add-prop-value").property("value"),l(a,b,!0),alchemy.dash.selectAll("#add-property .edited-property").classed({"edited-property":!1}),this.reset()}),g=alchemy._nodes[a.id].getProperties(),alchemy.vis.select("#node-"+a.id).classed({editing:!0}),k=d.select("#node-editor #properties-list");for(j in g)m=g[j],h=k.append("div").attr("id","node-"+j).attr("class","property form-inline form-group"),h.append("label").attr("for","node-"+j+"-input").attr("class","form-control property-name").text(""+j),h.append("input").attr("id","node-"+j+"-input").attr("class","form-control property-value").attr("value",""+m);return alchemy.dash.select("#properties-list").on("submit",function(){var a,b,c,d,e,f,g;for(event.preventDefault(),b=alchemy.dash.selectAll(".edited-property"),g=b[0],e=0,f=g.length;f>e;e++)j=g[e],c=alchemy.dash.select(j),a=c.select("label").text(),d=c.select("input").attr("value"),l(a,d,!1);return alchemy.dash.selectAll("#node-properties-list .edited-property").classed({"edited-property":!1}),this.reset()}),d3.selectAll("#add-prop-key, #add-prop-value, .property").on("keydown",function(){return 13===d3.event.keyCode&&event.preventDefault(),d3.select(this).classed({"edited-property":!0})}),l=function(b,c,d){var e,f;return f=a.id,""!==b&&""!==c?(alchemy._nodes[f].setProperty(""+b,""+c),e=alchemy._drawNodes,e.updateNode(alchemy.viz.select("#node-"+f)),d===!0?(alchemy.dash.select("#node-add-prop-key").attr("value","property added/updated to key: "+b),alchemy.dash.select("#node-add-prop-value").attr("value","property at "+b+" updated to: "+c)):alchemy.dash.select("#node-"+b+"-input").attr("value","property at "+b+" updated to: "+c)):d===!0?(alchemy.dash.select("#node-add-prop-key").attr("value","null or invalid input"),alchemy.dash.select("#node-add-prop-value").attr("value","null or invlid input")):alchemy.dash.select("#node-"+b+"-input").attr("value","null or invalid input")}},a.prototype.editorClear=function(){return alchemy.dash.selectAll(".node").classed({editing:!1}),alchemy.dash.selectAll(".edge").classed({editing:!1}),alchemy.dash.select("#node-editor").remove(),alchemy.dash.select("#edge-editor").remove(),alchemy.dash.select("#node-add-prop-submit").attr("placeholder",function(){return alchemy.vis.selectAll(".selected").empty()?"select a node or edge to edit properties":"add a property to this element"})},a.prototype.edgeEditor=function(a){var b,c,d,e,f,g,h,i,j,k,l,m;c=alchemy.conf.divSelector,f=alchemy.dash("#control-dash #editor"),i=f.select("#element-options"),h=this.elementEditorHTML("Edge"),g=i.append("div").attr("id","edge-editor").html(h),g.attr("class",function(){return alchemy.dash.select("#editor-interactions").classed("active")?"enabled":"hidden"}),b=f.select("#edge-editor form #add-property"),b.select("#add-prop-key").attr("placeholder","New Property Name").attr("value",null),b.select("#add-prop-value").attr("placeholder","New Property Value").attr("value",null),d=alchemy._edges[a.id].getProperties(),alchemy.vis.select("#edge-"+a.id).classed({editing:!0}),k=f.select("#edge-editor #properties-list");for(j in d)m=d[j],e=k.append("div").attr("id","edge-"+j).attr("class","property form-inline form-group"),e.append("label").attr("for","edge-"+j+"-input").attr("class","form-control property-name").text(""+j),e.append("input").attr("id","edge-"+j+"-input").attr("class","form-control property-value").attr("value",""+m);return alchemy.dash.selectAll("#add-prop-key, #add-prop-value, .property").on("keydown",function(){return 13===d3.event.keyCode&&event.preventDefault(),d3.select(this).classed({"edited-property":!0})}),alchemy.dash.select("#add-property-form").on("submit",function(){var a,b;return event.preventDefault(),a=alchemy.dash.select("#add-prop-key").property("value"),a=a.replace(/\s/g,"_"),b=alchemy.dash.select("#add-prop-value").property("value"),l(a,b,!0),alchemy.dash.selectAll("#add-property .edited-property").classed({"edited-property":!1}),this.reset()}),d3.select("#properties-list").on("submit",function(){var a,b,c,d,e,f,g;for(event.preventDefault(),b=alchemy.dash.selectAll(".edited-property"),g=b[0],e=0,f=g.length;f>e;e++)j=g[e],c=alchemy.dash.select(j),a=c.select("label").text(),d=c.select("input").property("value"),l(a,d,!1);return alchemy.dash.selectAll("#properties-list .edited-property").classed({"edited-property":!1}),this.reset()}),l=function(b,c,d){var e,f,g;return f=a.id,""!==b&&""!==c?(alchemy._edges[f].setProperty(""+b,""+c),g=alchemy.vis.select("#edge-"+f),e=new alchemy.drawing.DrawEdges,e.updateEdge(alchemy.vis.select("#edge-"+f)),d===!0?(alchemy.dash.select("#add-prop-key").attr("value","property added/updated to key: "+b),alchemy.dash.select("#add-prop-value").attr("value","property at "+b+" updated to: "+c)):alchemy.dash.select("#edge-"+b+"-input").attr("value","property at "+b+" updated to: "+c)):d===!0?(alchemy.dash.select("#add-prop-key").attr("value","null or invalid input"),alchemy.dash.select("#add-prop-value").attr("value","null or invlid input")):alchemy.dash.select("#edge-"+b+"-input").attr("value","null or invalid input")}},a}(),i=function(){function a(){this.reset=p(this.reset,this),this.deleteSelected=p(this.deleteSelected,this),this.addNodeDragended=p(this.addNodeDragended,this),this.addNodeDragging=p(this.addNodeDragging,this),this.addNodeStart=p(this.addNodeStart,this),this.edgeClick=p(this.edgeClick,this),this.nodeClick=p(this.nodeClick,this),this.nodeMouseUp=p(this.nodeMouseUp,this),this.editor=new alchemy.editor.Editor}return a.prototype.nodeMouseOver=function(){var a;return d3.select(this).select("circle").empty()||(a=d3.select(this).select("circle").attr("r"),d3.select(this).select("circle").attr("r",3*a)),this},a.prototype.nodeMouseUp=function(a){return this.sourceNode!==a?(this.mouseUpNode=!0,this.targetNode=a,this.click=!1):this.click=!0,this},a.prototype.nodeMouseOut=function(){var a;return d3.select(this).select("circle").empty()||(a=d3.select(this).select("circle").attr("r"),d3.select(this).select("circle").attr("r",a/3)),this},a.prototype.nodeClick=function(a){var b;return d3.event.stopPropagation(),alchemy.vis.select("#node-"+a.id).empty()||(b=alchemy.vis.select("#node-"+a.id).classed("selected"),alchemy.vis.select("#node-"+a.id).classed("selected",!b)),this.editor.editorClear(),this.editor.nodeEditor(a)},a.prototype.edgeClick=function(a){return d3.event.stopPropagation(),this.editor.editorClear(),this.editor.edgeEditor(a)},a.prototype.addNodeStart=function(a){return d3.event.sourceEvent.stopPropagation(),this.sourceNode=a,alchemy.vis.select("#dragline").classed({hidden:!1}),this},a.prototype.addNodeDragging=function(){var a,b;return a=d3.event.x,b=d3.event.y,alchemy.vis.select("#dragline").attr("x1",this.sourceNode.x).attr("y1",this.sourceNode.y).attr("x2",a).attr("y2",b).attr("style","stroke: #FFF"),this},a.prototype.addNodeDragended=function(){var a,b,c;return this.click||(this.mouseUpNode||(a=alchemy.vis.select("#dragline"),b=a.attr("x2"),c=a.attr("y2"),this.targetNode={id:""+_.uniqueId("addedNode_"),x:parseFloat(b),y:parseFloat(c),caption:"node added"}),this.newEdge={id:""+this.sourceNode.id+"-"+this.targetNode.id,source:this.sourceNode.id,target:this.targetNode.id,caption:"edited"},alchemy.editor.update(this.targetNode,this.newEdge)),this.reset(),this},a.prototype.deleteSelected=function(){switch(d3.event.keyCode){case 8:case 46:if("INPUT"!==d3.select(d3.event.target).node().tagName)return d3.event.preventDefault(),alchemy.editor.remove()}},a.prototype.reset=function(){return this.mouseUpNode=null,this.sourceNode=null,this.targetNode=null,this.newEdge=null,this.click=null,alchemy.vis.select("#dragline").classed({hidden:!0}).attr("x1",0).attr("y1",0).attr("x2",0).attr("y2",0),this},a}(),j=function(){function a(){this.enableEditor=p(this.enableEditor,this),this.drawNodes=alchemy._drawNodes,this.drawEdges=alchemy._drawEdges}return a.prototype.enableEditor=function(){var a,b,c;return alchemy.set.state("interactions","editor"),a=alchemy.vis.append("line").attr("id","dragline"),this.drawNodes.updateNode(alchemy.node),this.drawEdges.updateEdge(alchemy.edge),c=alchemy.vis.selectAll(".selected"),b=new alchemy.editor.Editor,c.empty()||1!==c.length?c.classed({selected:!1}):c.classed("node")?(b.nodeEditor(c.datum()),alchemy.dash.select("#node-editor").attr("class","enabled").style("opacity",1)):c.classed("edge")?(b.edgeEditor(c.datum()),alchemy.dash.select("#edge-editor").attr("class","enabled").style("opacity",1)):void 0},a.prototype.disableEditor=function(){return alchemy.setState("interactions","default"),alchemy.vis.select("#dragline").remove(),alchemy.dash.select("#node-editor").transition().duration(300).style("opacity",0),alchemy.dash.select("#node-editor").transition().delay(300).attr("class","hidden"),this.drawNodes.updateNode(alchemy.node),alchemy.vis.selectAll(".node").classed({selected:!1})},a.prototype.remove=function(){var a,b,c,d,e,f,g,h,i,j,k,l;for(e=alchemy.vis.selectAll(".selected.node"),j=e[0],l=[],f=0,h=j.length;h>f;f++)if(b=j[f],c=alchemy.vis.select(b).data()[0].id,d=alchemy._nodes[c],null!=d){for(k=d.adjacentEdges,g=0,i=k.length;i>g;g++)a=k[g],alchemy._edges=_.omit(alchemy._edges,""+a.id+"-"+a._index),alchemy.edge=alchemy.edge.data(_.map(alchemy._edges,function(a){return a._d3}),function(a){return a.id}),alchemy.vis.select("#edge-"+a.id+"-"+a._index).remove();alchemy._nodes=_.omit(alchemy._nodes,""+c),alchemy.node=alchemy.node.data(_.map(alchemy._nodes,function(a){return a._d3}),function(a){return a.id}),alchemy.vis.select(b).remove(),l.push("editor"===alchemy.get.state("interactions")?alchemy.modifyElements.nodeEditorClear():void 0)}else l.push(void 0);return l},a.prototype.addNode=function(a){var b;return b=alchemy._nodes[a.id]=new alchemy.models.Node({id:""+a.id}),b.setProperty("caption",a.caption),b.setD3Property("x",a.x),b.setD3Property("y",a.y),alchemy.node=alchemy.node.data(_.map(alchemy._nodes,function(a){return a._d3}),function(a){return a.id})},a.prototype.addEdge=function(a){var b;return b=alchemy._edges[a.id]=new alchemy.models.Edge(a),alchemy.edge=alchemy.edge.data(_.map(alchemy._edges,function(a){return a._d3}),function(a){return a.id})},a.prototype.update=function(a,b){return this.mouseUpNode?(alchemy.editor.addEdge(b),this.drawEdges.createEdge(alchemy.edge)):(alchemy.editor.addNode(a),alchemy.editor.addEdge(b),this.drawEdges.createEdge(alchemy.edge),this.drawNodes.createNode(alchemy.node)),alchemy.layout.tick()},a}(),b.prototype.Edge=function(a){var b;return b=function(){function b(b,c){var d;null==c&&(c=null),this.allNodesActive=p(this.allNodesActive,this),this.setProperties=p(this.setProperties,this),this.getStyles=p(this.getStyles,this),this.setProperties=p(this.setProperties,this),this.getProperties=p(this.getProperties,this),this._setID=p(this._setID,this),this._setD3Properties=p(this._setD3Properties,this),this.a=a,d=this.a.conf,this.id=this._setID(b),this._index=c,this._state="active",this._properties=b,this._edgeType=this._setEdgeType(),this._style=null!=d.edgeStyle[this._edgeType]?_.merge(_.clone(d.edgeStyle.all),d.edgeStyle[this._edgeType]):_.clone(d.edgeStyle.all),this._d3=_.merge({id:this.id,pos:this._index,edgeType:this._edgeType,source:this.a._nodes[this._properties.source]._d3,target:this.a._nodes[this._properties.target]._d3,self:this},this.a.svgStyles.edge.populate(this)),this._setCaption(b,d),this.a._nodes[""+b.source]._addEdge(this),this.a._nodes[""+b.target]._addEdge(this)}return b.prototype._setD3Properties=function(a){return _.merge(this._d3,a)},b.prototype._setID=function(a){return null!=a.id?a.id:""+a.source+"-"+a.target},b.prototype._setCaption=function(a,b){var c,d;return c=b.edgeCaption,d=function(a){switch(typeof c){case"string":return a[c];case"function":return c(a)}}(a),d?this._d3.caption=d:void 0},b.prototype._setEdgeType=function(){var a,b,c;return a=this.a.conf,a.edgeTypes&&(_.isPlainObject(a.edgeTypes)?(c=Object.keys(this.a.conf.edgeTypes),b=this._properties[c]):_.isArray(a.edgeTypes)?b=this._properties.caption:"string"==typeof a.edgeTypes&&(b=this._properties[a.edgeTypes])),void 0===b&&(b="all"),this._setD3Properties("edgeType",b),b},b.prototype.getProperties=function(){var a,b,c;return a=arguments[0],b=2<=arguments.length?o.call(arguments,1):[],null==a&&(a=null),null==a&&0===b.length?this._properties:0!==b.length?(c=_.union([a],b),_.pick(this._properties,c)):this._properties[a]},b.prototype.setProperties=function(a,b){return null==b&&(b=null),_.isPlainObject(a)?(_.assign(this._properties,a),"source"in a&&this._setD3Properties({source:alchemy._nodes[a.source]._d3}),"target"in a&&this._setD3Properties({target:alchemy._nodes[a.target]._d3})):(this._properties[a]=b,("source"===a||"target"===a)&&this._setD3Properties({property:alchemy._nodes[b]._d3})),this},b.prototype.getStyles=function(){var a,b,c;return b=arguments[0],c=2<=arguments.length?o.call(arguments,1):[],a=this,void 0===b?a._style:_.map(arguments,function(b){return a._style[b]})},b.prototype.setProperties=function(a,b){return null==b&&(b=null),_.isPlainObject(a)?(_.assign(this._properties,a),"source"in a&&this._setD3Properties({source:this.a._nodes[a.source]._d3}),"target"in a&&this._setD3Properties({target:this.a._nodes[a.target]._d3})):(this._properties[a]=b,("source"===a||"target"===a)&&this._setD3Properties({property:this.a._nodes[b]._d3})),this},b.prototype.setStyles=function(a,b){return null==b&&(b=null),void 0===a?a=this.a.svgStyles.edge.populate(this):_.isPlainObject(a)?_.assign(this._style,a):this._style[a]=b,this._setD3Properties(this.a.svgStyles.edge.update(this)),this.a._drawEdges.updateEdge(this._d3),this},b.prototype.toggleHidden=function(){return this._state="hidden"===this._state?"active":"hidden",this.setStyles()},b.prototype.allNodesActive=function(){var a,b,c,d;return a=this._properties.source,c=this._properties.target,b=alchemy.get.nodes(a)[0],d=alchemy.get.nodes(c)[0],"active"===b._state&&"active"===d._state},b.prototype.remove=function(){var a,b;return a=this,delete this.a._edges[a.id],null!=this.a._nodes[a._properties.source]&&_.remove(this.a._nodes[a._properties.source]._adjacentEdges,function(b){return b.id===a.id?b:void 0}),null!=this.a._nodes[a._properties.target]&&_.remove(this.a._nodes[a._properties.target]._adjacentEdges,function(b){return b.id===a.id?b:void 0}),this.a.vis.select("#edge-"+a.id+"-"+a._index).remove(),b=_.filter(this.a.force.links(),function(b){return b.id!==a.id?b:void 0}),this.a.force.links(b)},b}()},b.prototype.Node=function(a){var b;return b=function(){function b(b){this.getStyles=p(this.getStyles,this),this.setProperty=p(this.setProperty,this),this.getProperties=p(this.getProperties,this),this._setD3Properties=p(this._setD3Properties,this),this._setNodeType=p(this._setNodeType,this);var c;this.a=a,c=this.a.conf,this.id=b.id,this._properties=b,this._d3=_.merge({id:this.id,root:this._properties[c.rootNodes],self:this},this.a.svgStyles.node.populate(this)),this._nodeType=this._setNodeType(),this._style=c.nodeStyle[this._nodeType]?c.nodeStyle[this._nodeType]:c.nodeStyle.all,this._state="active",this._adjacentEdges=[]}return b.prototype._setNodeType=function(){var a,b,c,d;return a=this.a.conf,a.nodeTypes&&(_.isPlainObject(a.nodeTypes)?(b=Object.keys(this.a.conf.nodeTypes),d=_.values(a.nodeTypes),c=this._properties[b]):"string"==typeof a.nodeTypes&&(c=this._properties[a.nodeTypes])),void 0===c&&(c="all"),this._setD3Properties("nodeType",c),c},b.prototype._setD3Properties=function(a){return _.merge(this._d3,a)},b.prototype._addEdge=function(a){return this._adjacentEdges=_.union(this._adjacentEdges,[a])},b.prototype.getProperties=function(){var a,b,c;return a=arguments[0],b=2<=arguments.length?o.call(arguments,1):[],null==a&&(a=null),null==a&&0===b.length?this._properties:0!==b.length?(c=_.union([a],b),_.pick(this._properties,c)):this._properties[a]},b.prototype.setProperty=function(a,b){return null==b&&(b=null),_.isPlainObject(a)?_.assign(this._properties,a):this._properties[a]=b,this
},b.prototype.removeProperty=function(){var a,b,c,d,e;for(c=arguments[0],b=2<=arguments.length?o.call(arguments,1):[],d=0,e=arguments.length;e>d;d++)a=arguments[d],delete this._properties[a];return this},b.prototype.getStyles=function(){var a,b,c;return a=arguments[0],b=2<=arguments.length?o.call(arguments,1):[],c=this,void 0===a?c._style:_.map(arguments,function(a){return c._style[a]})},b.prototype.setStyles=function(a,b){return null==b&&(b=null),void 0===a?a=this.a.svgStyles.node.populate(this):_.isPlainObject(a)?_.assign(this._style,a):this._style[a]=b,this._setD3Properties(this.a.svgStyles.node.populate(this)),this.a._drawNodes.updateNode(this._d3),this},b.prototype.toggleHidden=function(){var a;return a=this.a,this._state="hidden"===this._state?"active":"hidden",this.setStyles(),_.each(this._adjacentEdges,function(b){var c,d,e,f,g;return g=b.id.split("-"),c=g[0],e=g[1],d=a._nodes[""+c]._state,f=a._nodes[""+e]._state,"hidden"===b._state&&"active"===d&&"active"===f?b.toggleHidden():"active"!==b._state||"hidden"!==d&&"hidden"!==f?void 0:b.toggleHidden()})},b.prototype.outDegree=function(){return this._adjacentEdges.length},b.prototype.remove=function(){for(;!_.isEmpty(this._adjacentEdges);)this._adjacentEdges[0].remove();return delete this.a._nodes[this.id],this.a.vis.select("#node-"+this.id).remove()},b}()},b.prototype.plugins=function(a){return{init:function(){return _.each(_.keys(a.conf.plugins),function(c){return a.plugins[c]=b.prototype.plugins[c](a),null!=a.plugins[c].init?a.plugins[c].init():void 0})}}},b.prototype.themes={"default":{backgroundColour:"#000000",nodeStyle:{all:{radius:function(){return 10},color:function(){return"#68B9FE"},borderColor:function(){return"#127DC1"},borderWidth:function(a,b){return b/3},captionColor:function(){return"#FFFFFF"},captionBackground:function(){return null},captionSize:12,selected:{color:function(){return"#FFFFFF"},borderColor:function(){return"#349FE3"}},highlighted:{color:function(){return"#EEEEFF"}},hidden:{color:function(){return"none"},borderColor:function(){return"none"}}}},edgeStyle:{all:{width:4,color:"#CCC",opacity:.2,directed:!0,curved:!0,selected:{opacity:1},highlighted:{opacity:1},hidden:{opacity:0}}}},white:{theme:"white",backgroundColour:"#FFFFFF",nodeStyle:{all:{radius:function(){return 10},color:function(){return"#68B9FE"},borderColor:function(){return"#127DC1"},borderWidth:function(a,b){return b/3},captionColor:function(){return"#FFFFFF"},captionBackground:function(){return null},captionSize:12,selected:{color:function(){return"#FFFFFF"},borderColor:function(){return"38DD38"}},highlighted:{color:function(){return"#EEEEFF"}},hidden:{color:function(){return"none"},borderColor:function(){return"none"}}}},edgeStyle:{all:{width:4,color:"#333",opacity:.4,directed:!1,curved:!1,selected:{color:"#38DD38",opacity:.9},highlighted:{color:"#383838",opacity:.7},hidden:{opacity:0}}}}},b.prototype.exports=function(a){var b;return b=a,{init:function(){return b.exports.show()},show:function(){return b.dash.select("#all-exports").append("li").attr({"class":"list-group-item active-label toggle"}).html("SVG").on("click",function(){var a,c,d,e,f;return d=d3.select(""+b.conf.divSelector+" svg").node(),c=(new XMLSerializer).serializeToString(d),e="data:image/svg+xml;utf8,"+c,a=e.replace("xlink:",""),f=window.open(a),f.focus()})}}},n=function(){function a(a){this.dataWarning=p(this.dataWarning,this),this.a=a}return a.prototype.dataWarning=function(){return this.a.conf.dataWarning&&"function"==typeof this.a.conf.dataWarning?this.a.conf.dataWarning():"default"===this.a.conf.dataWarning?console.log("No dataSource was loaded"):void 0},a.prototype.divWarning=function(){return"create an element that matches the value for 'divSelector' in your conf.\nFor instance, if you are using the default 'divSelector' conf, simply provide\n<div id='#alchemy'></div>."},a}()}).call(this);