/**
 * A collection of easing functions
 *
 * Parts of this collection are taken from D3.js library (https://d3js.org/)
 */
/**
 * The functions below are from D3.js library (https://d3js.org/)
 *
 * ----------------------------------------------------------------------------
 * Copyright 2017 Mike Bostock
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 * @hidden
 */
/**
 * ============================================================================
 * LINEAR FUNCTIONS
 * ============================================================================
 * @hidden
 */
/**
 * Easing function: "linear".
 */
export declare function linear(t: number): number;
/**
 * Easing function: "quadIn".
 */
export declare function quadIn(t: number): number;
/**
 * Easing function: "quadOut".
 */
export declare function quadOut(t: number): number;
/**
 * Easing function: "quadInOut".
 */
export declare function quadInOut(t: number): number;
/**
 * Easing function: "polyIn".
 */
export declare function polyIn(t: number, e: number): number;
/**
 * Easing function: "polyOut".
 */
export declare function polyOut(t: number, e: number): number;
/**
 * Easing function: "polyInOut".
 */
export declare function polyInOut(t: number, e: number): number;
/**
 * Easing function: "polyIn3".
 */
export declare function polyIn3(t: number): number;
/**
 * Easing function: "polyOut3".
 */
export declare function polyOut3(t: number): number;
/**
 * Easing function: "polyInOut3".
 */
export declare function polyInOut3(t: number): number;
/**
 * ============================================================================
 * EXPONENTIAL FUNCTIONS
 * ============================================================================
 * @hidden
 */
/**
 * Easing function: "expIn".
 */
export declare function expIn(t: number): number;
/**
 * Easing function: "expOut".
 */
export declare function expOut(t: number): number;
/**
 * Easing function: "expInOut".
 */
export declare function expInOut(t: number): number;
/**
 * ============================================================================
 * SINE FUNCTIONS
 * ============================================================================
 * @hidden
 */
/**
 * Easing function: "sinIn".
 */
export declare function sinIn(t: number): number;
/**
 * Easing function: "sinOut".
 */
export declare function sinOut(t: number): number;
/**
 * Easing function: "sinInOut".
 */
export declare function sinInOut(t: number): number;
/**
 * ============================================================================
 * CUBIC FUNCTIONS
 * ============================================================================
 * @hidden
 */
/**
 * Easing function: "cubicIn".
 */
export declare function cubicIn(t: number): number;
/**
 * Easing function: "cubicOut".
 */
export declare function cubicOut(t: number): number;
/**
 * Easing function: "cubicInOut".
 */
export declare function cubicInOut(t: number): number;
/**
 * ============================================================================
 * CIRCLE FUNCTIONS
 * ============================================================================
 * @hidden
 */
/**
 * Easing function: "circleIn".
 */
export declare function circleIn(t: number): number;
/**
 * Easing function: "circleOut".
 */
export declare function circleOut(t: number): number;
/**
 * Easing function: "circleInOut".
 */
export declare function circleInOut(t: number): number;
/**
 * Easing function: "bounceIn".
 */
export declare function bounceIn(t: number): number;
/**
 * Easing function: "bounceOut".
 */
export declare function bounceOut(t: number): number;
/**
 * Easing function: "bounceInOut".
 */
export declare function bounceInOut(t: number): number;
/**
 * Easing function: "elasticIn".
 *
 * @function elasticIn
 * @param a  Amplitude
 * @param p  period
 */
export declare function elasticIn(t: number): number;
/**
 * Easing function: "elasticOut".
 *
 * @function elasticOut
 * @param a  Amplitude
 * @param p  period
 */
export declare function elasticOut(t: number): number;
/**
 * Easing function: "elasticInOut".
 *
 * @function elasticInOut
 * @param a  Amplitude
 * @param p  period
 */
export declare function elasticInOut(t: number): number;
