import * as am4core from "@amcharts/amcharts4/core";
import * as am4charts from "@amcharts/amcharts4/charts";
import am4themes_animated from "@amcharts/amcharts4/themes/animated";
import am4plugins_timeline from "@amcharts/amcharts4/plugins/timeline";
import am4plugins_bullets from "@amcharts/amcharts4/plugins/bullets";

am4core.useTheme(am4themes_animated);

let insterfaceColors = new am4core.InterfaceColorSet();
let lineColor = insterfaceColors.getFor("background");

let chart = am4core.create("chartdiv", am4plugins_timeline.CurveChart);
chart.curveContainer.padding(20,20,20,20);

chart.data = [{ name: "", value: 13.71 }];

let categoryAxis = chart.yAxes.push(new am4charts.CategoryAxis<am4plugins_timeline.AxisRendererCurveX>());
categoryAxis.dataFields.category = "name";
categoryAxis.renderer.minGridDistance = 10;
categoryAxis.renderer.innerRadius = 0;
categoryAxis.renderer.radius = 100;
categoryAxis.renderer.line.stroke = lineColor;
categoryAxis.renderer.line.strokeWidth = 5;
categoryAxis.renderer.line.strokeOpacity = 1;

let labelTemplate = categoryAxis.renderer.labels.template;
labelTemplate.fill = lineColor;
labelTemplate.fontWeight = 600;
labelTemplate.fontSize = 13;

let gridTemplate = categoryAxis.renderer.grid.template;
gridTemplate.strokeWidth = 1;
gridTemplate.strokeOpacity = 1;
gridTemplate.stroke = lineColor;
gridTemplate.location = 0;
gridTemplate.above = true;

let fillTemplate = categoryAxis.renderer.axisFills.template;
fillTemplate.disabled = false;
fillTemplate.fill = am4core.color("#b84f49");
fillTemplate.fillOpacity = 1;

categoryAxis.fillRule = function(dataItem) {
    dataItem.axisFill.__disabled = false;
    dataItem.axisFill.opacity = 1;
}

let valueAxis = chart.xAxes.push(new am4charts.ValueAxis<am4plugins_timeline.AxisRendererCurveY>());
valueAxis.min = 0;
valueAxis.max = 15.6;
valueAxis.renderer.points = [{x:46.45512390136719, y:76.46989440917969}, {x:46.548179626464844, y:81.46658325195312}, {x:47.05908966064453, y:86.4395523071289}, {x:47.82523727416992, y:91.38014221191406}, {x:48.75651550292969, y:96.29248809814453}, {x:49.797393798828125, y:101.18286895751953}, {x:50.911293029785156, y:106.05718231201172}, {x:52.07081985473633, y:110.92086029052734}, {x:53.256202697753906, y:115.77831268310547}, {x:54.45045471191406, y:120.63359832763672}, {x:55.64010238647461, y:125.49000549316406}, {x:56.813907623291016, y:130.3502655029297}, {x:57.959346771240234, y:135.21728515625}, {x:59.0660514831543, y:140.09323120117188}, {x:60.123023986816406, y:144.98020935058594}, {x:61.11936950683594, y:149.87989807128906}, {x:62.04349136352539, y:154.79368591308594}, {x:62.88292694091797, y:159.72264099121094}, {x:63.623985290527344, y:164.6673126220703}, {x:64.25144958496094, y:169.62765502929688}, {x:64.7481918334961, y:174.60275268554688}, {x:65.09416961669922, y:179.59054565429688}, {x:65.2671890258789, y:184.58726501464844}, {x:65.24127197265625, y:189.58682250976562}, {x:64.9866714477539, y:194.579833984375}, {x:64.46954345703125, y:199.5523223876953}, {x:63.652225494384766, y:204.4841766357422}, {x:62.49420166015625, y:209.3470001220703}, {x:60.954708099365234, y:214.10250854492188}, {x:58.997257232666016, y:218.70140075683594}, {x:56.59602355957031, y:223.0845489501953}, {x:53.74329376220703, y:227.18785095214844}, {x:50.454833984375, y:230.95077514648438}, {x:46.779014587402344, y:234.33689880371094}, {x:42.78535842895508, y:237.34222412109375}, {x:38.536346435546875, y:239.97479248046875}, {x:34.08501434326172, y:242.2491455078125}, {x:29.4749698638916, y:244.18214416503906}, {x:24.741661071777344, y:245.79034423828125}, {x:19.914216995239258, y:247.08937072753906}, {x:15.016488075256348, y:248.0916748046875}, {x:10.068670272827148, y:248.80734252929688}, {x:5.088415145874023, y:249.24386596679688}, {x:0.09168336540460587, y:249.40554809570312}, {x:-4.906439304351807, y:249.29379272460938}, {x:-9.890823364257812, y:248.9073944091797}, {x:-14.845746994018555, y:248.2425994873047}, {x:-19.75396156311035, y:247.29281616210938}, {x:-24.595781326293945, y:246.0483856201172}, {x:-29.34832763671875, y:244.49789428710938}, {x:-33.98424530029297, y:242.62765502929688}, {x:-38.470272064208984, y:240.42233276367188}, {x:-42.766563415527344, y:237.8674774169922}, {x:-46.82551574707031, y:234.95065307617188}, {x:-50.596107482910156, y:231.6696319580078}, {x:-54.148799896240234, y:228.15206909179688}, {x:-57.531517028808594, y:224.4706573486328}, {x:-60.74784469604492, y:220.64295959472656}, {x:-63.80203628540039, y:216.68460083007812}, {x:-66.69824981689453, y:212.60922241210938}, {x:-69.44132995605469, y:208.42916870117188}, {x:-72.03521728515625, y:204.1549072265625}, {x:-74.48422241210938, y:199.79600524902344}, {x:-76.79206848144531, y:195.36074829101562}, {x:-78.96217346191406, y:190.85643005371094}, {x:-80.9975814819336, y:186.2896728515625}, {x:-82.90103912353516, y:181.6663360595703}, {x:-84.6745376586914, y:176.99159240722656}, {x:-86.32026672363281, y:172.27037048339844}, {x:-87.83961486816406, y:167.5069580078125}, {x:-89.23365783691406, y:162.7053680419922}, {x:-90.50315856933594, y:157.869384765625}, {x:-91.64849090576172, y:153.0024871826172}, {x:-92.66947937011719, y:148.1079864501953}, {x:-93.56596374511719, y:143.18911743164062}, {x:-94.33683013916016, y:138.24905395507812}, {x:-94.98112487792969, y:133.2908935546875}, {x:-95.49728393554688, y:128.31771850585938}, {x:-95.88310241699219, y:123.33280181884766}, {x:-96.13653564453125, y:118.33937072753906}, {x:-96.25435638427734, y:113.34095764160156}, {x:-96.2337875366211, y:108.3411636352539}, {x:-96.07066345214844, y:103.34400177001953}, {x:-95.76127624511719, y:98.35374450683594}, {x:-95.30091094970703, y:93.37520599365234}, {x:-94.6843490600586, y:88.41357421875}, {x:-93.90626525878906, y:83.47472381591797}, {x:-92.96076202392578, y:78.565185546875}, {x:-91.84153747558594, y:73.69233703613281}, {x:-90.5419921875, y:68.86449432373047}, {x:-89.05511474609375, y:64.09103393554688}, {x:-87.37396240234375, y:59.38249588012695}, {x:-85.49195098876953, y:54.75065612792969}, {x:-83.40200805664062, y:50.20890426635742}, {x:-81.09852600097656, y:45.771697998046875}, {x:-78.57648468017578, y:41.455081939697266}, {x:-75.83210754394531, y:37.276241302490234}, {x:-72.84657287597656, y:33.26679611206055}, {x:-69.56965637207031, y:29.491817474365234}, {x:-66.032470703125, y:25.9593448638916}, {x:-62.272071838378906, y:22.665210723876953}, {x:-58.3222541809082, y:19.600528717041016}, {x:-54.21247482299805, y:16.753738403320312}, {x:-49.96828842163086, y:14.111380577087402}, {x:-45.61104202270508, y:11.65964126586914}, {x:-41.15868377685547, y:9.385120391845703}, {x:-36.62623596191406, y:7.274646282196045}, {x:-32.02602767944336, y:5.316038131713867}, {x:-27.368410110473633, y:3.49822735786438}, {x:-22.661964416503906, y:1.8105790615081787}, {x:-17.913908004760742, y:0.24380269646644592}, {x:-13.130281448364258, y:-1.210625410079956}, {x:-8.315995216369629, y:-2.5605309009552}, {x:-3.4754154682159424, y:-3.8124895095825195}, {x:1.3879549503326416, y:-4.973319053649902}, {x:6.270873546600342, y:-6.048704624176025}, {x:11.170822143554688, y:-7.043537616729736}, {x:16.085535049438477, y:-7.962975978851318}, {x:21.013057708740234, y:-8.810965538024902}, {x:25.951719284057617, y:-9.591634750366211}, {x:30.899978637695312, y:-10.308605194091797}, {x:35.85669708251953, y:-10.964839935302734}, {x:40.820674896240234, y:-11.563661575317383}, {x:45.79094696044922, y:-12.107728958129883}, {x:50.76674270629883, y:-12.599350929260254}, {x:55.747127532958984, y:-13.040990829467773}, {x:60.731597900390625, y:-13.43460750579834}, {x:65.71947479248047, y:-13.782614707946777}, {x:70.71014404296875, y:-14.086698532104492}, {x:75.70333099365234, y:-14.347768783569336}, {x:80.69844818115234, y:-14.568004608154297}, {x:85.6951904296875, y:-14.748764038085938}, {x:90.69315338134766, y:-14.891241073608398}, {x:95.69206237792969, y:-14.996546745300293}, {x:100.69153594970703, y:-15.065693855285645}, {x:105.69142150878906, y:-15.099632263183594}, {x:110.69139862060547, y:-15.099230766296387}, {x:115.6912841796875, y:-15.065299034118652}, {x:120.69083404541016, y:-14.998588562011719}, {x:125.68983459472656, y:-14.899309158325195}, {x:130.68807983398438, y:-14.768254280090332}, {x:135.68539428710938, y:-14.605365753173828}, {x:140.68161010742188, y:-14.411070823669434}, {x:145.67652893066406, y:-14.18532943725586}, {x:150.66986083984375, y:-13.927678108215332}, {x:155.6614227294922, y:-13.637771606445312}, {x:160.65097045898438, y:-13.31458854675293}, {x:165.63807678222656, y:-12.955939292907715}, {x:170.62229919433594, y:-12.55923080444336}, {x:175.60267639160156, y:-12.116777420043945}, {x:180.5862579345703, y:-11.726715087890625}, {x:185.58079528808594, y:-11.49483871459961}, {x:190.57789611816406, y:-11.32458209991455}, {x:195.5765838623047, y:-11.2139310836792}, {x:200.57632446289062, y:-11.161140441894531}, {x:205.57626342773438, y:-11.163545608520508}, {x:210.57594299316406, y:-11.21925163269043}, {x:215.57476806640625, y:-11.326441764831543}, {x:220.572265625, y:-11.483386993408203}, {x:225.56802368164062, y:-11.688438415527344}, {x:230.5616912841797, y:-11.940020561218262}, {x:235.5528564453125, y:-12.236626625061035}, {x:240.5412139892578, y:-12.576826095581055}, {x:245.52659606933594, y:-12.959253311157227}, {x:250.50857543945312, y:-13.382594108581543}, {x:255.48707580566406, y:-13.845617294311523}, {x:260.4618225097656, y:-14.347126960754395}, {x:265.4327087402344, y:-14.885993003845215}, {x:270.3995056152344, y:-15.46151351928711}, {x:275.3619689941406, y:-16.072418212890625}, {x:280.3201904296875, y:-16.717620849609375}, {x:285.2738952636719, y:-17.396160125732422}, {x:290.22308349609375, y:-18.107154846191406}, {x:295.1676330566406, y:-18.849740982055664}, {x:300.107421875, y:-19.62309455871582}, {x:305.0423583984375, y:-20.427106857299805}, {x:309.9724426269531, y:-21.26038360595703}, {x:314.8976135253906, y:-22.1221923828125}, {x:319.8177795410156, y:-23.0118408203125}, {x:324.73297119140625, y:-23.92869758605957}, {x:329.64306640625, y:-24.872812271118164}, {x:334.5480041503906, y:-25.842945098876953}, {x:339.4478759765625, y:-26.83847427368164}, {x:344.3426818847656, y:-27.858869552612305}, {x:349.23223876953125, y:-28.903980255126953}, {x:354.1165466308594, y:-29.973283767700195}, {x:358.99566650390625, y:-31.06593894958496}, {x:363.86962890625, y:-32.181488037109375}, {x:368.73834228515625, y:-33.319766998291016}, {x:373.60174560546875, y:-34.48054885864258}, {x:378.45989990234375, y:-35.6629524230957}, {x:383.3128967285156, y:-36.86662673950195}, {x:388.1605224609375, y:-38.091392517089844}, {x:393.0028381347656, y:-39.33717727661133}, {x:397.83990478515625, y:-40.6031608581543}, {x:402.6717224121094, y:-41.889041900634766}, {x:407.4981994628906, y:-43.19464111328125}, {x:412.31939697265625, y:-44.52003479003906}, {x:417.1352233886719, y:-45.864418029785156}, {x:421.9458312988281, y:-47.22759246826172}, {x:426.7510681152344, y:-48.609249114990234}, {x:431.55096435546875, y:-50.00973129272461}, {x:436.34552001953125, y:-51.42825698852539}, {x:441.13458251953125, y:-52.86537551879883}, {x:445.91864013671875, y:-54.31879425048828}, {x:450.6969299316406, y:-55.79129409790039}, {x:455.4701843261719, y:-57.27967071533203}, {x:460.2378234863281, y:-58.78630065917969}, {x:465.0001525878906, y:-60.30957794189453}, {x:469.7572326660156, y:-61.849212646484375}, {x:474.5084228515625, y:-63.40665054321289}, {x:479.2546691894531, y:-64.97921752929688}, {x:483.994873046875, y:-66.56993865966797}, {x:488.7299499511719, y:-68.17581939697266}, {x:493.45928955078125, y:-69.79864501953125}, {x:498.18316650390625, y:-71.43738555908203}, {x:502.90142822265625, y:-73.09213256835938}, {x:507.61383056640625, y:-74.76333618164062}, {x:512.3207397460938, y:-76.44988250732422}, {x:517.021728515625, y:-78.15326690673828}, {x:521.717041015625, y:-79.87169647216797}, {x:526.40625, y:-81.60698699951172}, {x:531.0899047851562, y:-83.35740661621094}, {x:535.7671508789062, y:-85.12451934814453}, {x:540.4386596679688, y:-86.90709686279297}, {x:545.1038208007812, y:-88.70606231689453}, {x:549.7627563476562, y:-90.52113342285156}, {x:554.41552734375, y:-92.35196685791016}, {x:559.0614013671875, y:-94.20001220703125}, {x:563.7011108398438, y:-96.06350708007812}, {x:568.333740234375, y:-97.944580078125}, {x:572.959716796875, y:-99.84221649169922}, {x:577.5789184570312, y:-101.7561264038086}, {x:582.1904296875, y:-103.68852233886719}, {x:586.7946166992188, y:-105.63804626464844}, {x:591.3914794921875, y:-107.60499572753906}, {x:595.980224609375, y:-109.59054565429688}, ];
valueAxis.renderer.line.strokeOpacity = 0.1;
valueAxis.renderer.line.strokeWidth = 10;
valueAxis.renderer.maxLabelPosition = 0.98;
valueAxis.renderer.minLabelPosition = 0.02;
valueAxis.numberFormatter.numberFormat = "#.#\ cm";

let valueLabelTemplate = valueAxis.renderer.labels.template;
valueLabelTemplate.fill = lineColor;
valueLabelTemplate.fontSize = 11;
valueLabelTemplate.fontWeight = 600;
valueLabelTemplate.fillOpacity = 1;
valueLabelTemplate.horizontalCenter = "right";
valueLabelTemplate.verticalCenter = "bottom";
valueLabelTemplate.padding(0, 20, 0, 0);
valueLabelTemplate.adapter.add("rotation", (rotation, target) => {
    let value = target.dataItem.value;
    let position = valueAxis.valueToPosition(value);

    let angle = valueAxis.renderer.positionToAngle(position);
    return angle;
})

let valueGridTemplate = valueAxis.renderer.grid.template;
valueGridTemplate.strokeOpacity = 0.3;
valueGridTemplate.stroke = lineColor;

// SERIES
let series = chart.series.push(new am4plugins_timeline.CurveColumnSeries());
series.dataFields.categoryY = "name";
series.stroke = lineColor;
series.fill = lineColor;
series.dataFields.valueX = "value";
series.defaultState.transitionDuration = 4000;

let columnTemplate = series.columns.template;
columnTemplate.fill = lineColor;
columnTemplate.strokeOpacity = 0;
columnTemplate.fillOpacity = 0.3;
columnTemplate.height = am4core.percent(90);

let label = chart.curveContainer.createChild(am4core.Label);
label.fill = am4core.color("#b84f49");
label.fontSize = 15;
label.text = "Average erect penis size - 13.71 cm";
label.zIndex = 1000;
label.paddingTop = 20;

label.events.on("validated", positionLabel);

chart.events.on("maxsizechanged", positionLabel)

function positionLabel(){
    label.path = valueAxis.renderer.line.path;
    label.locationOnPath = 0.7;    
}