import { __extends } from "tslib";
import { Chord } from "./Chord";
import { ChordLinkDirected } from "./ChordLinkDirected";
import { chordDirected, ribbonArrow, ribbon } from "d3-chord";
import { Template } from "../../core/util/Template";
import { ListTemplate } from "../../core/util/List";
import * as $utils from "../../core/util/Utils";
/**
 * Directed chord series.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/flow-charts/} for more information
 * @important
 */
var ChordDirected = /** @class */ (function (_super) {
    __extends(ChordDirected, _super);
    function ChordDirected() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_d3chord", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: chordDirected()
        });
        Object.defineProperty(_this, "_ribbonArrow", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: ribbonArrow()
        });
        /**
         * List of link elements.
         *
         * @default new ListTemplate<ChordLinkDirected>
         */
        Object.defineProperty(_this, "links", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return ChordLinkDirected._new(_this._root, { themeTags: ["link", "shape"] }, [_this.links.template]); })
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(ChordDirected.prototype, "makeLink", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var link = this.linksContainer.children.push(this.links.make());
            link._setDataItem(dataItem);
            link.set("source", dataItem.get("source"));
            link.set("target", dataItem.get("target"));
            link.series = this;
            return link;
        }
    });
    Object.defineProperty(ChordDirected.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["directed"]);
            _super.prototype._afterNew.call(this);
            this._markDirtyKey("linkHeadRadius");
        }
    });
    Object.defineProperty(ChordDirected.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var linkHeadRadius = "linkHeadRadius";
            if (this.isDirty(linkHeadRadius)) {
                var headRadius = this.get(linkHeadRadius);
                if (headRadius == null) {
                    this._ribbon = ribbon();
                }
                else {
                    var ribbon_1 = ribbonArrow();
                    ribbon_1.headRadius(headRadius);
                    this._ribbon = ribbon_1;
                }
            }
            _super.prototype._prepareChildren.call(this);
        }
    });
    Object.defineProperty(ChordDirected, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ChordDirected"
    });
    Object.defineProperty(ChordDirected, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Chord.classNames.concat([ChordDirected.className])
    });
    return ChordDirected;
}(Chord));
export { ChordDirected };
//# sourceMappingURL=ChordDirected.js.map