import { __extends } from "tslib";
import { Chord } from "./Chord";
import * as $array from "../../core/util/Array";
import * as $math from "../../core/util/Math";
import * as $utils from "../../core/util/Utils";
/**
 * Chord series with think line links.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/flow-charts/} for more information
 * @important
 */
var ChordNonRibbon = /** @class */ (function (_super) {
    __extends(ChordNonRibbon, _super);
    function ChordNonRibbon() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ChordNonRibbon.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["chord", "basic"]);
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(ChordNonRibbon.prototype, "_makeMatrix", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            var matrix = [];
            $array.each(this.nodes.dataItems, function (sourceDataItem) {
                var group = [];
                matrix.push(group);
                $array.each(_this.nodes.dataItems, function (targetDataItem) {
                    var value = 1;
                    if (sourceDataItem === targetDataItem) {
                        value = 0;
                    }
                    group.push(value);
                });
            });
            return matrix;
        }
    });
    Object.defineProperty(ChordNonRibbon.prototype, "_updateLink", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_ribbon, link, _linkRadius, chordLayoutItem) {
            link._type = this.get("linkType");
            if (chordLayoutItem) {
                var linkType_1 = this.get("linkType");
                link.set("draw", function (display) {
                    var p0 = link._p0;
                    var p1 = link._p1;
                    if (p0 && p1) {
                        display.moveTo(p0.x, p0.y);
                        if (linkType_1 == "line") {
                            display.lineTo(p1.x, p1.y);
                        }
                        else {
                            display.quadraticCurveTo(0, 0, p1.x, p1.y);
                        }
                    }
                });
            }
        }
    });
    Object.defineProperty(ChordNonRibbon.prototype, "_getLinkPoints", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (link, linkRadius, _chordLayoutItem) {
            var source = link.get("source");
            var target = link.get("target");
            if (source && target) {
                var sourceSlice = source.get("slice");
                var targetSlice = target.get("slice");
                var startAngle0 = sourceSlice.get("startAngle", 0);
                var arc0 = sourceSlice.get("arc", 0);
                var angle0 = startAngle0 + arc0 / 2;
                var startAngle1 = targetSlice.get("startAngle", 0);
                var arc1 = targetSlice.get("arc", 0);
                var angle1 = startAngle1 + arc1 / 2;
                link._p0 = { x: linkRadius * $math.cos(angle0), y: linkRadius * $math.sin(angle0) };
                link._p1 = { x: linkRadius * $math.cos(angle1), y: linkRadius * $math.sin(angle1) };
            }
        }
    });
    Object.defineProperty(ChordNonRibbon, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ChordNonRibbon"
    });
    Object.defineProperty(ChordNonRibbon, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Chord.classNames.concat([ChordNonRibbon.className])
    });
    return ChordNonRibbon;
}(Chord));
export { ChordNonRibbon };
//# sourceMappingURL=ChordNonRibbon.js.map