import { __awaiter, __extends, __generator } from "tslib";
import { FlowDefaultTheme } from "./FlowDefaultTheme";
import { Series } from "../../core/render/Series";
import { Container } from "../../core/render/Container";
import { LinearGradient } from "../../core/render/gradients/LinearGradient";
import * as $array from "../../core/util/Array";
import * as $type from "../../core/util/Type";
/**
 * A base class for all flow type series: [[Sankey]] and [[Chord]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/flow-charts/} for more info
 */
var Flow = /** @class */ (function (_super) {
    __extends(Flow, _super);
    function Flow() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Container series will place their links in.
         *
         * @default Container.new()
         */
        Object.defineProperty(_this, "linksContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(Container.new(_this._root, {}))
        });
        Object.defineProperty(_this, "_nodesData", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(_this, "_linksData", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(_this, "_index", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_linksByIndex", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        return _this;
    }
    Object.defineProperty(Flow.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._defaultThemes.push(FlowDefaultTheme.new(this._root));
            this.fields.push("disabled", "sourceId", "targetId");
            if (this.nodes) {
                this.nodes.flow = this;
            }
            _super.prototype._afterNew.call(this);
            this.children.push(this.bulletsContainer);
        }
    });
    Object.defineProperty(Flow.prototype, "processDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.processDataItem.call(this, dataItem);
            var nodes = this.nodes;
            if (nodes) {
                var unknown = false;
                var sourceId = dataItem.get("sourceId");
                var sourceDataItem = nodes.getDataItemById(sourceId);
                if (!sourceDataItem) {
                    if (sourceId == null) {
                        sourceId = "undefined" + this._index;
                        this._index++;
                        unknown = true;
                    }
                    nodes.data.push({ id: sourceId, unknown: unknown });
                    sourceDataItem = nodes.getDataItemById(sourceId);
                    if (!unknown) {
                        sourceDataItem.set("name", sourceId);
                    }
                }
                unknown = false;
                var targetId = dataItem.get("targetId");
                var targetDataItem = nodes.getDataItemById(targetId);
                if (!targetDataItem) {
                    if (targetId == null) {
                        targetId = "undefined" + this._index;
                        this._index++;
                        unknown = true;
                    }
                    nodes.data.push({ id: targetId, unknown: unknown });
                    targetDataItem = nodes.getDataItemById(targetId);
                    if (!unknown) {
                        targetDataItem.set("name", targetId);
                    }
                }
                if (sourceDataItem) {
                    dataItem.set("source", sourceDataItem);
                    nodes.addOutgoingLink(sourceDataItem, dataItem);
                }
                if (targetDataItem) {
                    dataItem.set("target", targetDataItem);
                    nodes.addincomingLink(targetDataItem, dataItem);
                }
                dataItem.set("link", this.makeLink(dataItem));
                var sourceIndex = this.nodes.dataItems.indexOf(sourceDataItem);
                var targetIndex = this.nodes.dataItems.indexOf(targetDataItem);
                this._linksByIndex[sourceIndex + "_" + targetIndex] = dataItem;
                if (sourceDataItem.get("unknown")) {
                    if (targetDataItem) {
                        sourceDataItem.set("fill", targetDataItem.get("fill"));
                    }
                    dataItem.get("link").set("fillStyle", "gradient");
                }
                if (targetDataItem.get("unknown")) {
                    if (sourceDataItem) {
                        targetDataItem.set("fill", sourceDataItem.get("fill"));
                    }
                    dataItem.get("link").set("fillStyle", "gradient");
                }
                this._updateLinkColor(dataItem);
            }
        }
    });
    Object.defineProperty(Flow.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._prepareChildren.call(this);
            var valueLow = Infinity;
            var valueHigh = -Infinity;
            var valueSum = 0;
            if (this._valuesDirty) {
                this._nodesData = [];
                var nodes_1 = this.nodes;
                if (nodes_1) {
                    $array.each(nodes_1.dataItems, function (dataItem) {
                        _this._nodesData.push(dataItem.get("d3SankeyNode"));
                        var incoming = dataItem.get("incomingLinks");
                        var sumIncoming = 0;
                        var sumIncomingWorking = 0;
                        if (incoming) {
                            $array.each(incoming, function (link) {
                                var value = link.get("value");
                                var workingValue = link.get("valueWorking");
                                sumIncoming += value;
                                sumIncomingWorking += workingValue;
                            });
                        }
                        dataItem.set("sumIncoming", sumIncoming);
                        dataItem.set("sumIncomingWorking", sumIncomingWorking);
                        var outgoing = dataItem.get("outgoingLinks");
                        var sumOutgoing = 0;
                        var sumOutgoingWorking = 0;
                        if (outgoing) {
                            $array.each(outgoing, function (link) {
                                var value = link.get("value");
                                var workingValue = link.get("valueWorking");
                                sumOutgoing += value;
                                sumOutgoingWorking += workingValue;
                            });
                        }
                        dataItem.set("sumOutgoing", sumOutgoing);
                        dataItem.set("sumOutgoingWorking", sumOutgoingWorking);
                        dataItem.set("sum", sumIncoming + sumOutgoing);
                        dataItem.set("sumWorking", sumIncomingWorking + sumOutgoingWorking);
                        nodes_1.updateLegendValue(dataItem);
                    });
                }
                this._linksData = [];
                $array.each(this.dataItems, function (dataItem) {
                    var value = dataItem.get("value");
                    if ($type.isNumber(value)) {
                        var valueWorking = dataItem.get("valueWorking");
                        var d3SankeyLink = { source: dataItem.get("source").get("d3SankeyNode"), target: dataItem.get("target").get("d3SankeyNode"), value: valueWorking };
                        dataItem.setRaw("d3SankeyLink", d3SankeyLink);
                        _this._linksData.push(d3SankeyLink);
                        if (value < valueLow) {
                            valueLow = value;
                        }
                        if (value > valueHigh) {
                            valueHigh = value;
                        }
                        valueSum += value;
                        _this.updateLegendValue(dataItem);
                    }
                });
                this.setPrivateRaw("valueHigh", valueHigh);
                this.setPrivateRaw("valueLow", valueLow);
                this.setPrivateRaw("valueSum", valueSum);
            }
        }
    });
    Object.defineProperty(Flow.prototype, "_updateLinkColor", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var link = dataItem.get("link");
            var fillStyle = link.get("fillStyle");
            var strokeStyle = link.get("strokeStyle");
            var source = dataItem.get("source");
            var target = dataItem.get("target");
            var sourceFill = source.get("fill");
            var targetFill = target.get("fill");
            link.remove("fillGradient");
            link.remove("strokeGradient");
            switch (fillStyle) {
                case "solid":
                    link._applyTemplates();
                    break;
                case "source":
                    link.set("fill", sourceFill);
                    break;
                case "target":
                    link.set("fill", targetFill);
                    break;
                case "gradient":
                    var gradient = link._fillGradient;
                    if (!gradient) {
                        gradient = LinearGradient.new(this._root, {});
                        var sourceStop = { color: sourceFill };
                        if (source.get("unknown")) {
                            sourceStop.opacity = 0;
                        }
                        var targetStop = { color: targetFill };
                        if (target.get("unknown")) {
                            targetStop.opacity = 0;
                        }
                        gradient.set("stops", [sourceStop, targetStop]);
                        link._fillGradient = gradient;
                    }
                    link.set("fillGradient", gradient);
                    break;
                case "none":
                    link.set("fill", undefined); // do not use remove!
                    break;
            }
            switch (strokeStyle) {
                case "solid":
                    link._applyTemplates();
                    break;
                case "source":
                    link.set("stroke", sourceFill);
                    break;
                case "target":
                    link.set("stroke", targetFill);
                case "gradient":
                    var gradient = link._strokeGradient;
                    if (!gradient) {
                        gradient = LinearGradient.new(this._root, {});
                        var sourceStop = { color: sourceFill };
                        if (source.get("unknown")) {
                            sourceStop.opacity = 0;
                        }
                        var targetStop = { color: targetFill };
                        if (target.get("unknown")) {
                            targetStop.opacity = 0;
                        }
                        gradient.set("stops", [sourceStop, targetStop]);
                        link._strokeGradient = gradient;
                    }
                    link.set("strokeGradient", gradient);
                    break;
                case "none":
                    link.remove("stroke");
                    break;
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Flow.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.disposeDataItem.call(this, dataItem);
            var link = dataItem.get("link");
            if (link) {
                this.links.removeValue(link);
                link.dispose();
            }
        }
    });
    /**
     * Shows diagram's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(Flow.prototype, "hideDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, hiddenState, stateAnimationDuration, stateAnimationEasing, easing, linkGraphics;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.hideDataItem.call(this, dataItem, duration)];
                            hiddenState = this.states.create("hidden", {});
                            stateAnimationDuration = "stateAnimationDuration";
                            stateAnimationEasing = "stateAnimationEasing";
                            if (!$type.isNumber(duration)) {
                                duration = hiddenState.get(stateAnimationDuration, this.get(stateAnimationDuration, 0));
                            }
                            easing = hiddenState.get(stateAnimationEasing, this.get(stateAnimationEasing));
                            promises.push(dataItem.animate({ key: "valueWorking", to: 0, duration: duration, easing: easing }).waitForStop());
                            linkGraphics = dataItem.get("link");
                            linkGraphics.hide();
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * Shows diagram's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(Flow.prototype, "showDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, easing, linkGraphics;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.showDataItem.call(this, dataItem, duration)];
                            if (!$type.isNumber(duration)) {
                                duration = this.get("stateAnimationDuration", 0);
                            }
                            easing = this.get("stateAnimationEasing");
                            promises.push(dataItem.animate({ key: "valueWorking", to: dataItem.get("value"), duration: duration, easing: easing }).waitForStop());
                            linkGraphics = dataItem.get("link");
                            linkGraphics.show();
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    Object.defineProperty(Flow.prototype, "_positionBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (bullet) {
            var sprite = bullet.get("sprite");
            if (sprite) {
                var dataItem = sprite.dataItem;
                if (dataItem) {
                    var link = dataItem.get("link");
                    var sprite_1 = bullet.get("sprite");
                    if (sprite_1) {
                        var point = link.getPoint(this._getBulletLocation(bullet));
                        sprite_1.setAll({ x: point.x, y: point.y });
                        if (bullet.get("autoRotate")) {
                            sprite_1.set("rotation", point.angle + bullet.get("autoRotateAngle", 0));
                        }
                    }
                }
            }
        }
    });
    Object.defineProperty(Flow.prototype, "_getBulletLocation", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (bullet) {
            return bullet.get("locationY", 0);
        }
    });
    Object.defineProperty(Flow, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Flow"
    });
    Object.defineProperty(Flow, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Series.classNames.concat([Flow.className])
    });
    return Flow;
}(Series));
export { Flow };
//# sourceMappingURL=Flow.js.map