import { __extends } from "tslib";
import { Graphics } from "../../core/render/Graphics";
import { Percent } from "../../core/util/Percent";
/**
 * A base class for a flow link.
 */
var FlowLink = /** @class */ (function (_super) {
    __extends(FlowLink, _super);
    function FlowLink() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "series", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_fillGradient", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_strokeGradient", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(FlowLink.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this.isDirty("fillStyle")) {
                var series = this.series;
                var dataItem = this.dataItem;
                if (series && dataItem) {
                    series._updateLinkColor(dataItem);
                }
            }
        }
    });
    Object.defineProperty(FlowLink.prototype, "_getTooltipPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var tooltipY = this.get("tooltipY");
            var position = 0.5;
            if (tooltipY instanceof Percent) {
                position = tooltipY.value;
            }
            return this.getPoint(position);
        }
    });
    Object.defineProperty(FlowLink, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "FlowLink"
    });
    Object.defineProperty(FlowLink, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([FlowLink.className])
    });
    return FlowLink;
}(Graphics));
export { FlowLink };
//# sourceMappingURL=FlowLink.js.map