import { __awaiter, __extends, __generator } from "tslib";
import { Label } from "../../core/render/Label";
import { Series } from "../../core/render/Series";
import { Template } from "../../core/util/Template";
import { ListTemplate } from "../../core/util/List";
import { FlowNode } from "./FlowNode";
import * as $array from "../../core/util/Array";
/**
 * Holds instances of nodes for a [[Flow]] series.
 */
var FlowNodes = /** @class */ (function (_super) {
    __extends(FlowNodes, _super);
    function FlowNodes() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * List of label elements.
         *
         * @default new ListTemplate<Label>
         */
        Object.defineProperty(_this, "labels", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return Label._new(_this._root, {}, [_this.labels.template]); })
        });
        /**
         * List of node elements.
         *
         * @default new ListTemplate<FlowNode>
         */
        Object.defineProperty(_this, "nodes", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return FlowNode._new(_this._root, { themeTags: ["node"] }, [_this.nodes.template]); })
        });
        return _this;
    }
    Object.defineProperty(FlowNodes.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.fields.push("unknown", "name", "fill");
            this.set("idField", "id");
            this.set("nameField", "id");
            this.set("fillField", "fill");
            this.set("unknownField", "unknown");
            this.children.push(this.bulletsContainer);
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(FlowNodes.prototype, "_onDataClear", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var colors = this.get("colors");
            if (colors) {
                colors.reset();
            }
        }
    });
    Object.defineProperty(FlowNodes.prototype, "processDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.processDataItem.call(this, dataItem);
            dataItem.setRaw("d3SankeyNode", { name: dataItem.get("id"), dataItem: dataItem });
            if (dataItem.get("fill") == null) {
                var colors = this.get("colors");
                if (colors) {
                    dataItem.setRaw("fill", colors.next());
                }
            }
            dataItem.setRaw("node", this.makeNode(dataItem));
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(FlowNodes.prototype, "makeNode", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, themeTag) {
            var node = this.nodes.make();
            this.nodes.push(node);
            if (themeTag) {
                node.addTag(themeTag);
            }
            if (dataItem.get("unknown")) {
                node.addTag("unknown");
            }
            this.children.push(node);
            node._setDataItem(dataItem);
            node.series = this;
            dataItem.set("node", node);
            return node;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(FlowNodes.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.disposeDataItem.call(this, dataItem);
            var node = dataItem.get("node");
            if (node) {
                this.nodes.removeValue(node);
                node.dispose();
            }
            var label = dataItem.get("label");
            if (label) {
                this.labels.removeValue(label);
                label.dispose();
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(FlowNodes.prototype, "addincomingLink", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, link) {
            var incoming = dataItem.get("incomingLinks");
            if (!incoming) {
                incoming = [];
                dataItem.set("incomingLinks", incoming);
            }
            incoming.push(link);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(FlowNodes.prototype, "addOutgoingLink", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, link) {
            var outgoing = dataItem.get("outgoingLinks");
            if (!outgoing) {
                outgoing = [];
                dataItem.set("outgoingLinks", outgoing);
            }
            outgoing.push(link);
        }
    });
    /**
     * Shows node's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(FlowNodes.prototype, "showDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, flow, label, links;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.showDataItem.call(this, dataItem, duration)];
                            flow = this.flow;
                            if (flow) {
                                label = dataItem.get("label");
                                if (label) {
                                    label.show(duration);
                                }
                                links = dataItem.get("outgoingLinks");
                                if (links) {
                                    $array.each(links, function (link) {
                                        flow.showDataItem(link, duration);
                                    });
                                }
                                links = dataItem.get("incomingLinks");
                                if (links) {
                                    $array.each(links, function (link) {
                                        flow.showDataItem(link, duration);
                                    });
                                }
                            }
                            return [4 /*yield*/, promises];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * Hides series's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(FlowNodes.prototype, "hideDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, flow, label, links;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.hideDataItem.call(this, dataItem, duration)];
                            flow = this.flow;
                            if (flow) {
                                label = dataItem.get("label");
                                if (label) {
                                    label.hide(duration);
                                }
                                links = dataItem.get("outgoingLinks");
                                if (links) {
                                    $array.each(links, function (link) {
                                        flow.hideDataItem(link, duration);
                                    });
                                }
                                links = dataItem.get("incomingLinks");
                                if (links) {
                                    $array.each(links, function (link) {
                                        flow.hideDataItem(link, duration);
                                    });
                                }
                            }
                            return [4 /*yield*/, promises];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    Object.defineProperty(FlowNodes, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "FlowNodes"
    });
    Object.defineProperty(FlowNodes, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Series.classNames.concat([FlowNodes.className])
    });
    return FlowNodes;
}(Series));
export { FlowNodes };
//# sourceMappingURL=FlowNodes.js.map