import { __extends, __read } from "tslib";
import { FlowLink } from "./FlowLink";
import * as $math from "../../core/util/Math";
var SankeyLink = /** @class */ (function (_super) {
    __extends(SankeyLink, _super);
    function SankeyLink() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_svgPath", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: document.createElementNS("http://www.w3.org/2000/svg", "path")
        });
        Object.defineProperty(_this, "_totalLength", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        return _this;
    }
    Object.defineProperty(SankeyLink.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _a, _b, _c, _d;
            var _this = this;
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("source")) {
                var source_1 = this.get("source");
                if (source_1) {
                    var sourceNode_1 = source_1.get("node");
                    this._disposers.push(sourceNode_1.events.on("positionchanged", function () {
                        _this.markDirty();
                    }));
                }
            }
            if (this.isDirty("target")) {
                var target_1 = this.get("target");
                if (target_1) {
                    var targetNode_1 = target_1.get("node");
                    this._disposers.push(targetNode_1.events.on("positionchanged", function () {
                        _this.markDirty();
                    }));
                }
            }
            if (this.isPrivateDirty("orientation")) {
                var series = this.series;
                var dataItem = this.dataItem;
                if (dataItem && series) {
                    series._updateLinkColor(dataItem);
                }
            }
            var target = this.get("target");
            var source = this.get("source");
            var sourceNode;
            var targetNode;
            if (source && target) {
                this._clear = true;
                sourceNode = source.get("node");
                targetNode = target.get("node");
                var x0 = 0;
                var x1 = 0;
                var y0 = 0;
                var y1 = 0;
                var xt0 = 0;
                var yt0 = 0;
                var xt1 = 0;
                var yt1 = 0;
                var xb0 = 0;
                var xb1 = 0;
                var yb0 = 0;
                var yb1 = 0;
                var xm0 = 0;
                var xm1 = 0;
                var ym0 = 0;
                var ym1 = 0;
                var angle0 = 0;
                var angle1 = 0;
                var dataItem = this.dataItem;
                if (dataItem) {
                    var d3SankeyLink = dataItem.get("d3SankeyLink");
                    if (d3SankeyLink) {
                        var w = d3SankeyLink.width || 0;
                        var orientation_1 = this.getPrivate("orientation");
                        if (orientation_1 == "vertical") {
                            if (sourceNode) {
                                y0 = sourceNode.y();
                            }
                            if (targetNode) {
                                y1 = targetNode.y();
                            }
                            angle0 = 90;
                            angle1 = 90;
                            x0 = d3SankeyLink.y0 || 0;
                            x1 = d3SankeyLink.y1 || 0;
                            if (y1 < y0) {
                                _a = __read([x1, x0], 2), x0 = _a[0], x1 = _a[1];
                                _b = __read([y1, y0], 2), y0 = _b[0], y1 = _b[1];
                            }
                            if (source.get("unknown")) {
                                x0 = x1;
                                y0 = y0 + (y1 - y0) / 2;
                            }
                            if (target.get("unknown")) {
                                x1 = x0;
                                y1 = y0 + (y1 - y0) / 2;
                            }
                            xt0 = x0 - w / 2;
                            yt0 = y0;
                            xt1 = x1 - w / 2;
                            yt1 = y1;
                            xb0 = x0 + w / 2;
                            xb1 = x1 + w / 2;
                            yb0 = y0;
                            yb1 = y1;
                            xm0 = x0;
                            xm1 = x1;
                            ym0 = y0;
                            ym1 = y1;
                        }
                        else {
                            if (sourceNode) {
                                x0 = sourceNode.x();
                            }
                            if (targetNode) {
                                x1 = targetNode.x();
                            }
                            y0 = d3SankeyLink.y0 || 0;
                            y1 = d3SankeyLink.y1 || 0;
                            if (x1 < x0) {
                                _c = __read([x1, x0], 2), x0 = _c[0], x1 = _c[1];
                                _d = __read([y1, y0], 2), y0 = _d[0], y1 = _d[1];
                            }
                            if (source.get("unknown")) {
                                y0 = y1;
                                x0 = x0 + (x1 - x0) / 2;
                            }
                            if (target.get("unknown")) {
                                y1 = y0;
                                x1 = x0 + (x1 - x0) / 2;
                            }
                            xt0 = x0;
                            yt0 = y0 - w / 2;
                            xt1 = x1;
                            yt1 = y1 - w / 2;
                            xb0 = x0;
                            xb1 = x1;
                            yb0 = y0 + w / 2;
                            yb1 = y1 + w / 2;
                            xm0 = x0;
                            xm1 = x1;
                            ym0 = y0;
                            ym1 = y1;
                        }
                        if ($math.round(xt0, 3) == $math.round(xt1, 3)) {
                            xt1 += 0.01;
                        }
                        if ($math.round(yt0, 3) == $math.round(yt1, 3)) {
                            yt1 += 0.01;
                        }
                        if ($math.round(xb0, 3) == $math.round(xb1, 3)) {
                            xb1 += 0.01;
                        }
                        if ($math.round(yb0, 3) == $math.round(yb1, 3)) {
                            yb1 += 0.01;
                        }
                        var cpd = this.get("controlPointDistance", 0.2);
                        cpd = Math.min(0.4999, cpd);
                        var kxt0 = xt0 + (xt1 - xt0) * cpd * $math.cos(angle0);
                        var kyt0 = yt0 + (yt1 - yt0) * cpd * $math.sin(angle0);
                        var kxt1 = xt1 - (xt1 - xt0) * cpd * $math.cos(angle1);
                        var kyt1 = yt1 - (yt1 - yt0) * cpd * $math.sin(angle1);
                        var kxm0 = xm0 + (xm1 - xm0) * cpd * $math.cos(angle0);
                        var kym0 = ym0 + (ym1 - ym0) * cpd * $math.sin(angle0);
                        var kxm1 = xm1 - (xm1 - xm0) * cpd * $math.cos(angle1);
                        var kym1 = ym1 - (ym1 - ym0) * cpd * $math.sin(angle1);
                        var angle = $math.getAngle({ x: kxt0, y: kyt0 }, { x: kxt1, y: kyt1 });
                        var dx = (w / $math.cos(angle) - w) / $math.tan(angle) * $math.cos(angle0);
                        var dy = (w / $math.sin(angle) - w) * $math.tan(angle) * $math.sin(angle0);
                        var kxb0 = -dx / 2 + xb0 + (xb1 - xb0) * cpd * $math.cos(angle0);
                        var kyb0 = -dy / 2 + yb0 + (yb1 - yb0) * cpd * $math.sin(angle0);
                        var kxb1 = -dx / 2 + xb1 - (xb1 - xb0) * cpd * $math.cos(angle1);
                        var kyb1 = -dy / 2 + yb1 - (yb1 - yb0) * cpd * $math.sin(angle1);
                        kxt0 += dx / 2;
                        kyt0 += dy / 2;
                        kxt1 += dx / 2;
                        kyt1 += dy / 2;
                        if (orientation_1 == "vertical") {
                            kyt0 = Math.min(yt1, Math.max(yt0 + 1, kyt0));
                            kyb0 = Math.min(yb1, Math.max(yb0 + 1, kyb0));
                            kyt1 = Math.max(yt0, Math.min(yt1 - 1, kyt1));
                            kyb1 = Math.max(yb0, Math.min(yb1 - 1, kyb1));
                        }
                        else {
                            kxt0 = Math.min(xt1, Math.max(xt0 + 1, kxt0));
                            kxb0 = Math.min(xb1, Math.max(xb0 + 1, kxb0));
                            kxt1 = Math.max(xt0, Math.min(xt1 - 1, kxt1));
                            kxb1 = Math.max(xb0, Math.min(xb1 - 1, kxb1));
                        }
                        var segment_1 = [[xt0, yt0, xb0, yb0], [kxt0, kyt0, kxb0, kyb0], [kxt1, kyt1, kxb1, kyb1], [xt1, yt1, xb1, yb1]];
                        this.set("draw", function (display) {
                            var series = _this.series;
                            series._fillGenerator.context(display);
                            series._fillGenerator(segment_1);
                        });
                        var middleSegment = [[xm0, ym0], [kxm0, kym0], [kxm1, kym1], [xm1, ym1]];
                        var path = this.series._strokeGenerator(middleSegment);
                        if (path) {
                            this._svgPath.setAttribute("d", path);
                            this._totalLength = this._svgPath.getTotalLength();
                        }
                    }
                }
            }
            if (this.series && this.dataItem) {
                this.series._positionBullets(this.dataItem);
            }
        }
    });
    Object.defineProperty(SankeyLink.prototype, "getPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (location) {
            if (this._svgPath) {
                if (this._svgPath.getAttribute("d")) {
                    var p0 = this._svgPath.getPointAtLength(location * this._totalLength - 0.1);
                    var p1 = this._svgPath.getPointAtLength(location * this._totalLength + 0.1);
                    var p = this.toGlobal(this._svgPath.getPointAtLength(location * this._totalLength));
                    return { x: p.x, y: p.y, angle: $math.getAngle(p0, p1) };
                }
            }
            return { x: 0, y: 0, angle: 0 };
        }
    });
    Object.defineProperty(SankeyLink, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "SankeyLink"
    });
    Object.defineProperty(SankeyLink, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: FlowLink.classNames.concat([SankeyLink.className])
    });
    return SankeyLink;
}(FlowLink));
export { SankeyLink };
//# sourceMappingURL=SankeyLink.js.map