import { __extends } from "tslib";
import { Graphics } from "../../core/render/Graphics";
/**
 * Draws a slice for [[FunnelSeries]].
 */
var FunnelSlice = /** @class */ (function (_super) {
    __extends(FunnelSlice, _super);
    function FunnelSlice() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_projectionDirty", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_tlx", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_tly", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_trx", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_try", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_blx", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_bly", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_brx", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_bry", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_cprx", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_cplx", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_cpry", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_cply", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        return _this;
    }
    Object.defineProperty(FunnelSlice.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._afterNew.call(this);
            this.set("draw", function (display) {
                display.moveTo(_this._tlx, _this._tly);
                display.lineTo(_this._trx, _this._try);
                display.quadraticCurveTo(_this._cprx, _this._cpry, _this._brx, _this._bry);
                display.lineTo(_this._blx, _this._bly);
                display.quadraticCurveTo(_this._cplx, _this._cply, _this._tlx, _this._tly);
            });
        }
    });
    Object.defineProperty(FunnelSlice.prototype, "getPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (locationX, locationY) {
            var w = this.width();
            var h = this.height();
            var tw = this.get("topWidth", 0);
            var bw = this.get("bottomWidth", 0);
            if (this.get("orientation") == "vertical") {
                var tlx = -tw / 2;
                var trx = tw / 2;
                var brx = bw / 2;
                var blx = -bw / 2;
                var mlx = tlx + (blx - tlx) * locationY;
                var mrx = trx + (brx - trx) * locationY;
                return { x: mlx + (mrx - mlx) * locationX, y: h * locationY };
            }
            else {
                var tlx = -tw / 2;
                var trx = tw / 2;
                var brx = bw / 2;
                var blx = -bw / 2;
                var mlx = tlx + (blx - tlx) * locationX;
                var mrx = trx + (brx - trx) * locationX;
                return { x: w * locationX, y: mlx + (mrx - mlx) * locationY };
            }
        }
    });
    Object.defineProperty(FunnelSlice.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this.isDirty("topWidth") || this.isDirty("bottomWidth") || this.isDirty("expandDistance") || this.isDirty("orientation") || this.isDirty("width") || this.isDirty("height")) {
                var w = this.width();
                var h = this.height();
                var tw = this.get("topWidth", 0);
                var bw = this.get("bottomWidth", 0);
                this._clear = true;
                var ed = this.get("expandDistance", 0);
                if (this.get("orientation") == "vertical") {
                    this._tlx = -tw / 2;
                    this._tly = 0;
                    this._trx = tw / 2;
                    this._try = 0;
                    this._brx = bw / 2;
                    this._bry = h;
                    this._blx = -bw / 2;
                    this._bly = h;
                    this._cprx = this._trx + (this._brx - this._trx) / 2 + ed * h,
                        this._cpry = this._try + 0.5 * h;
                    this._cplx = this._tlx + (this._blx - this._tlx) / 2 - ed * h;
                    this._cply = this._tly + 0.5 * h;
                }
                else {
                    this._tly = -tw / 2;
                    this._tlx = 0;
                    this._try = tw / 2;
                    this._trx = 0;
                    this._bry = bw / 2;
                    this._brx = w;
                    this._bly = -bw / 2;
                    this._blx = w;
                    this._cpry = this._try + (this._bry - this._try) / 2 + ed * w,
                        this._cprx = this._trx + 0.5 * w;
                    this._cply = this._tly + (this._bly - this._tly) / 2 - ed * w;
                    this._cplx = this._tlx + 0.5 * w;
                }
            }
            _super.prototype._changed.call(this);
        }
    });
    Object.defineProperty(FunnelSlice, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "FunnelSlice"
    });
    Object.defineProperty(FunnelSlice, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([FunnelSlice.className])
    });
    return FunnelSlice;
}(Graphics));
export { FunnelSlice };
//# sourceMappingURL=FunnelSlice.js.map