import { __extends } from "tslib";
import { PyramidSeries } from "./PyramidSeries";
import { Graphics } from "../../core/render/Graphics";
import { p100, p50 } from "../../core/util/Percent";
/**
 * Creates a pictorial series for use in a [[SlicedChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/percent-charts/sliced-chart/pictorial-stacked-series/} for more info
 * @important
 */
var PictorialStackedSeries = /** @class */ (function (_super) {
    __extends(PictorialStackedSeries, _super);
    function PictorialStackedSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "pictorial"
        });
        /**
         * A [[Graphics]] element to used as a mask (shape) for the series.
         *
         * This element is read-only. To modify the mask/shape, use the `svgPath` setting.
         */
        Object.defineProperty(_this, "seriesMask", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: Graphics.new(_this._root, { position: "absolute", x: p50, y: p50, centerX: p50, centerY: p50 })
        });
        Object.defineProperty(_this, "seriesGraphics", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.slicesContainer.children.push(Graphics.new(_this._root, { themeTags: ["pictorial", "background"], position: "absolute", x: p50, y: p50, centerX: p50, centerY: p50 }))
        });
        return _this;
    }
    Object.defineProperty(PictorialStackedSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this.set("topWidth", p100);
            this.set("bottomWidth", p100);
            this.set("valueIs", "height");
            this.slicesContainer.set("mask", this.seriesMask);
        }
    });
    Object.defineProperty(PictorialStackedSeries.prototype, "_updateScale", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var slicesContainer = this.slicesContainer;
            var w = slicesContainer.innerWidth();
            var h = slicesContainer.innerHeight();
            var seriesMask = this.seriesMask;
            var seriesGraphics = this.seriesGraphics;
            var scale = seriesMask.get("scale", 1);
            var bounds = seriesMask.localBounds();
            var mw = bounds.right - bounds.left;
            var mh = bounds.bottom - bounds.top;
            if (this.get("orientation") == "horizontal") {
                scale = w / mw;
            }
            else {
                scale = h / mh;
            }
            if (scale != Infinity && scale != NaN) {
                seriesMask.set("scale", scale);
                seriesMask.set("x", w / 2);
                seriesMask.set("y", h / 2);
                seriesGraphics.set("scale", scale);
                seriesGraphics.set("x", w / 2);
                seriesGraphics.set("y", h / 2);
            }
        }
    });
    Object.defineProperty(PictorialStackedSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this.isDirty("svgPath")) {
                var svgPath = this.get("svgPath");
                this.seriesMask.set("svgPath", svgPath);
                this.seriesGraphics.set("svgPath", svgPath);
            }
            this._updateScale();
        }
    });
    Object.defineProperty(PictorialStackedSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "PictorialStackedSeries"
    });
    Object.defineProperty(PictorialStackedSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: PyramidSeries.classNames.concat([PictorialStackedSeries.className])
    });
    return PictorialStackedSeries;
}(PyramidSeries));
export { PictorialStackedSeries };
//# sourceMappingURL=PictorialStackedSeries.js.map