import { __extends, __read } from "tslib";
import { FunnelSeries } from "./FunnelSeries";
import { p100 } from "../../core/util/Percent";
import * as $utils from "../../core/util/Utils";
import * as $type from "../../core/util/Type";
/**
 * Creates a pyramid series for use in a [[SlicedChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/percent-charts/sliced-chart/pyramid-series/} for more info
 * @important
 */
var PyramidSeries = /** @class */ (function (_super) {
    __extends(PyramidSeries, _super);
    function PyramidSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "pyramid"
        });
        Object.defineProperty(_this, "_nextSize", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(PyramidSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            this._nextSize = undefined;
        }
    });
    Object.defineProperty(PyramidSeries.prototype, "decorateSlice", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _a, _b, _c, _d;
            var orientation = this.get("orientation");
            var slicesContainer = this.slicesContainer;
            var slice = dataItem.get("slice");
            var label = dataItem.get("label");
            var link = dataItem.get("link");
            var valueIs = this.get("valueIs", "area");
            var sum = this.getPrivate("valueAbsoluteSum", 0);
            if (sum == 0) {
                return;
            }
            var startLocation = this.get("startLocation", 0);
            var endLocation = this.get("endLocation", 1);
            var tw = this.get("topWidth", 0);
            var bw = this.get("bottomWidth", p100);
            var workingValue = Math.abs(dataItem.get("valueWorking", 0));
            var value = dataItem.get("value", 0);
            var sliceHeight;
            var sliceBottomWidth;
            var pyramidHeight = slicesContainer.innerHeight();
            var pyramidWidth = slicesContainer.innerWidth();
            var linkWidth = link.width();
            var linkHeight = link.height();
            if (orientation == "horizontal") {
                _a = __read([pyramidHeight, pyramidWidth], 2), pyramidWidth = _a[0], pyramidHeight = _a[1];
                _b = __read([linkHeight, linkWidth], 2), linkWidth = _b[0], linkHeight = _b[1];
            }
            var center = pyramidWidth / 2;
            var d = 1;
            if (value != 0) {
                d = workingValue / Math.abs(value);
            }
            else {
                if (dataItem.isHidden()) {
                    d = 0.000001;
                }
            }
            linkHeight *= d;
            pyramidHeight = pyramidHeight * (endLocation - startLocation) - linkHeight * (this._count * this._total - 1);
            var topWidth = $utils.relativeToValue(tw, pyramidWidth);
            if (!$type.isNumber(this._nextSize)) {
                this._nextSize = topWidth;
            }
            var bottomWidth = $utils.relativeToValue(bw, pyramidWidth);
            var sliceTopWidth = this._nextSize;
            var angle = Math.atan2(pyramidHeight, topWidth - bottomWidth);
            var c = Math.tan(Math.PI / 2 - angle);
            if (c == 0) {
                c = 0.00000001;
            }
            if (valueIs == "area") {
                var totalSquare = (topWidth + bottomWidth) / 2 * pyramidHeight;
                var square = totalSquare * workingValue / sum;
                var s = Math.abs(sliceTopWidth * sliceTopWidth - 2 * square * c);
                sliceHeight = (sliceTopWidth - Math.sqrt(s)) / c;
                if (sliceHeight > 0) {
                    sliceBottomWidth = (2 * square - sliceHeight * sliceTopWidth) / sliceHeight;
                }
                else {
                    sliceBottomWidth = sliceTopWidth;
                }
            }
            else {
                sliceHeight = pyramidHeight * workingValue / sum;
                sliceBottomWidth = sliceTopWidth - sliceHeight * c;
            }
            var labelCoord = this._nextCoord + sliceHeight / 2;
            var sliceX = center;
            var sliceY = this._nextCoord;
            var linkX = center;
            var linkY = sliceY + sliceHeight;
            if (orientation == "vertical") {
                label.set("y", labelCoord);
                if (label.get("opacity") > 0) {
                    this._rLabels.push({ label: label, y: labelCoord });
                }
                slice.set("height", sliceHeight);
            }
            else {
                label.set("x", labelCoord);
                if (label.get("opacity") > 0) {
                    this._hLabels.push({ label: label, y: labelCoord });
                }
                _c = __read([sliceY, sliceX], 2), sliceX = _c[0], sliceY = _c[1];
                _d = __read([linkY, linkX], 2), linkX = _d[0], linkY = _d[1];
                slice.set("width", sliceHeight);
            }
            slice.setAll({ orientation: orientation, bottomWidth: sliceBottomWidth, topWidth: sliceTopWidth, x: sliceX, y: sliceY });
            link.setAll({ orientation: orientation, x: linkX, y: linkY, topWidth: sliceBottomWidth, bottomWidth: sliceBottomWidth });
            this._nextSize = sliceBottomWidth;
            this._nextCoord += sliceHeight + linkHeight;
        }
    });
    Object.defineProperty(PyramidSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "PyramidSeries"
    });
    Object.defineProperty(PyramidSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: FunnelSeries.classNames.concat([PyramidSeries.className])
    });
    return PyramidSeries;
}(FunnelSeries));
export { PyramidSeries };
//# sourceMappingURL=PyramidSeries.js.map