import { __extends } from "tslib";
import { PercentChart } from "../percent/PercentChart";
/**
 * Creates a sliced chart for use with [[FunnelSeries]], [[PyramidSeries]], or [[PictorialStackedSeries]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/percent-charts/pie-chart/} for more info
 * @important
 */
var SlicedChart = /** @class */ (function (_super) {
    __extends(SlicedChart, _super);
    function SlicedChart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(SlicedChart.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this.seriesContainer.setAll({ isMeasured: true, layout: this._root.horizontalLayout });
        }
    });
    Object.defineProperty(SlicedChart, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "SlicedChart"
    });
    Object.defineProperty(SlicedChart, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: PercentChart.classNames.concat([SlicedChart.className])
    });
    return SlicedChart;
}(PercentChart));
export { SlicedChart };
//# sourceMappingURL=SlicedChart.js.map