import { __extends } from "tslib";
import { Graphics } from "../../core/render/Graphics";
/**
 * Draws a link between nodes in a hierarchy series.
 */
var HierarchyLink = /** @class */ (function (_super) {
    __extends(HierarchyLink, _super);
    function HierarchyLink() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(HierarchyLink.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear) {
                var source = this.get("source");
                var target = this.get("target");
                if (source && target) {
                    var sourceNode = source.get("node");
                    var targetNode = target.get("node");
                    this._display.moveTo(sourceNode.x(), sourceNode.y());
                    this._display.lineTo(targetNode.x(), targetNode.y());
                }
            }
        }
    });
    Object.defineProperty(HierarchyLink.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("source")) {
                var source = this.get("source");
                if (source) {
                    var sourceNode = source.get("node");
                    sourceNode.events.on("positionchanged", function () {
                        _this._markDirtyKey("stroke");
                    });
                }
            }
            if (this.isDirty("target")) {
                var target = this.get("target");
                if (target) {
                    var targetNode = target.get("node");
                    targetNode.events.on("positionchanged", function () {
                        _this._markDirtyKey("stroke");
                    });
                }
            }
        }
    });
    Object.defineProperty(HierarchyLink, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "HierarchyLink"
    });
    Object.defineProperty(HierarchyLink, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([HierarchyLink.className])
    });
    return HierarchyLink;
}(Graphics));
export { HierarchyLink };
//# sourceMappingURL=HierarchyLink.js.map