import { __extends } from "tslib";
import { Container } from "../../core/render/Container";
/**
 * Base class for hierarchy nodes.
 */
var HierarchyNode = /** @class */ (function (_super) {
    __extends(HierarchyNode, _super);
    function HierarchyNode() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Related series.
         */
        Object.defineProperty(_this, "series", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_clickDisposer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(HierarchyNode.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._afterNew.call(this);
            this.states.create("disabled", {});
            this.states.create("hover", {});
            this.states.create("hoverDisabled", {});
            this.on("disabled", function () {
                var dataItem = _this.dataItem;
                if (!dataItem.get("children")) {
                    _this.set("disabled", true);
                    return;
                }
                var disabled = _this.get("disabled");
                var series = _this.series;
                if (dataItem && series) {
                    if (dataItem.get("disabled") != disabled) {
                        if (disabled) {
                            series.disableDataItem(dataItem);
                        }
                        else {
                            series.enableDataItem(dataItem, series.get("downDepth", 1), 0);
                        }
                    }
                }
            });
        }
    });
    Object.defineProperty(HierarchyNode.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._changed.call(this);
            if (this.isDirty("toggleKey")) {
                var toggleKey = this.get("toggleKey");
                if (toggleKey == "disabled") {
                    this._clickDisposer = this.events.on("click", function () {
                        if (!_this._isDragging) {
                            var series = _this.series;
                            if (series) {
                                series.selectDataItem(_this.dataItem);
                            }
                        }
                    });
                }
                else {
                    if (this._clickDisposer) {
                        this._clickDisposer.dispose();
                    }
                }
            }
        }
    });
    Object.defineProperty(HierarchyNode, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "HierarchyNode"
    });
    Object.defineProperty(HierarchyNode, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Container.classNames.concat([HierarchyNode.className])
    });
    return HierarchyNode;
}(Container));
export { HierarchyNode };
//# sourceMappingURL=HierarchyNode.js.map