import { __extends } from "tslib";
import { HierarchyNode } from "./HierarchyNode";
import * as $array from "../../core/util/Array";
/**
 * A node class for [[LinkedHierarchy]].
 */
var LinkedHierarchyNode = /** @class */ (function (_super) {
    __extends(LinkedHierarchyNode, _super);
    function LinkedHierarchyNode() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(LinkedHierarchyNode.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this.states.create("disabled", {});
            this.states.create("hover", {});
            this.states.create("hoverDisabled", {});
        }
    });
    Object.defineProperty(LinkedHierarchyNode.prototype, "_updateLinks", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (duration) {
            var dataItem = this.dataItem;
            if (dataItem) {
                var links = dataItem.get("links");
                $array.each(links, function (link) {
                    var source = link.get("source");
                    var target = link.get("target");
                    if (source && target) {
                        if (source.get("node").isHidden() || target.get("node").isHidden()) {
                            link.hide(duration);
                        }
                        else {
                            link.show(duration);
                        }
                    }
                });
            }
        }
    });
    Object.defineProperty(LinkedHierarchyNode.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this.isDirty("disabled")) {
                this._updateLinks();
            }
        }
    });
    Object.defineProperty(LinkedHierarchyNode.prototype, "_onHide", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (duration) {
            _super.prototype._onHide.call(this, duration);
            this._updateLinks(duration);
        }
    });
    Object.defineProperty(LinkedHierarchyNode.prototype, "_onShow", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (duration) {
            _super.prototype._onShow.call(this, duration);
            this._updateLinks(duration);
        }
    });
    Object.defineProperty(LinkedHierarchyNode, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "LinkedHierarchyNode"
    });
    Object.defineProperty(LinkedHierarchyNode, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: HierarchyNode.classNames.concat([LinkedHierarchyNode.className])
    });
    return LinkedHierarchyNode;
}(HierarchyNode));
export { LinkedHierarchyNode };
//# sourceMappingURL=LinkedHierarchyNode.js.map