import { __extends } from "tslib";
import { LinkedHierarchy } from "./LinkedHierarchy";
import * as d3hierarchy from "d3-hierarchy";
;
/**
 * Displays a tree diagram.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/hierarchy/tree/} for more info
 * @important
 */
var Tree = /** @class */ (function (_super) {
    __extends(Tree, _super);
    function Tree() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "tree"
        });
        Object.defineProperty(_this, "_hierarchyLayout", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: d3hierarchy.tree()
        });
        Object.defineProperty(_this, "_packData", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(Tree.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this.isDirty("orientation")) {
                this._updateVisuals();
            }
        }
    });
    Object.defineProperty(Tree.prototype, "_updateVisuals", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this._rootNode) {
                var layout = this._hierarchyLayout;
                if (this.get("orientation") == "vertical") {
                    layout.size([this.innerWidth(), this.innerHeight()]);
                }
                else {
                    layout.size([this.innerHeight(), this.innerWidth()]);
                }
                layout(this._rootNode);
            }
            _super.prototype._updateVisuals.call(this);
        }
    });
    Object.defineProperty(Tree.prototype, "_getPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (hierarchyNode) {
            if (this.get("orientation") == "vertical") {
                return { x: hierarchyNode.x, y: hierarchyNode.y };
            }
            else {
                return { x: hierarchyNode.y, y: hierarchyNode.x };
            }
        }
    });
    Object.defineProperty(Tree, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Tree"
    });
    Object.defineProperty(Tree, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: LinkedHierarchy.classNames.concat([Tree.className])
    });
    return Tree;
}(LinkedHierarchy));
export { Tree };
//# sourceMappingURL=Tree.js.map