import { __extends } from "tslib";
import { MapLineSeries } from "./MapLineSeries";
import { geoGraticule } from "d3-geo";
/**
 * A [[MapChart]] series to draw a map grid.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/map-chart/graticule-series/} for more info
 * @important
 */
var GraticuleSeries = /** @class */ (function (_super) {
    __extends(GraticuleSeries, _super);
    function GraticuleSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_dataItem", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.makeDataItem({})
        });
        return _this;
    }
    Object.defineProperty(GraticuleSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this.dataItems.push(this._dataItem);
            this._generate();
        }
    });
    Object.defineProperty(GraticuleSeries.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._updateChildren.call(this);
            if (this.isDirty("step")) {
                this._generate();
            }
        }
    });
    Object.defineProperty(GraticuleSeries.prototype, "_generate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var graticule = geoGraticule();
            if (graticule) {
                var step = this.get("step", 10);
                graticule.stepMinor([360, 360]);
                graticule.stepMajor([step, step]);
                this._dataItem.set("geometry", graticule());
            }
        }
    });
    Object.defineProperty(GraticuleSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "GraticuleSeries"
    });
    Object.defineProperty(GraticuleSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: MapLineSeries.classNames.concat([GraticuleSeries.className])
    });
    return GraticuleSeries;
}(MapLineSeries));
export { GraticuleSeries };
//# sourceMappingURL=GraticuleSeries.js.map