import { __extends } from "tslib";
import { Theme } from "../../core/Theme";
import { p50 } from "../../core/util/Percent";
import { setColor } from "../../themes/DefaultTheme";
import { geoMercator } from "d3-geo";
import * as $ease from "../../core/util/Ease";
/**
 * @ignore
 */
var MapChartDefaultTheme = /** @class */ (function (_super) {
    __extends(MapChartDefaultTheme, _super);
    function MapChartDefaultTheme() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(MapChartDefaultTheme.prototype, "setupDefaultRules", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype.setupDefaultRules.call(this);
            var ic = this._root.interfaceColors;
            var r = this.rule.bind(this);
            /**
             * ========================================================================
             * charts/map
             * ========================================================================
             */
            r("MapChart").setAll({
                projection: geoMercator(),
                panX: "translateX",
                panY: "translateY",
                pinchZoom: true,
                zoomStep: 2,
                zoomLevel: 1,
                rotationX: 0,
                rotationY: 0,
                rotationZ: 0,
                maxZoomLevel: 32,
                minZoomLevel: 1,
                wheelY: "zoom",
                wheelX: "none",
                animationEasing: $ease.out($ease.cubic),
                wheelEasing: $ease.out($ease.cubic),
                wheelDuration: 0,
                wheelSensitivity: 1,
                maxPanOut: 0.4
            });
            {
                var rule = r("MapLine");
                rule.setAll({
                    precision: 0.5,
                    role: "figure",
                });
                setColor(rule, "stroke", ic, "grid");
            }
            r("MapPointSeries").setAll({
                clipFront: false,
                clipBack: true
            });
            {
                var rule = r("MapPolygon");
                rule.setAll({
                    precision: 0.5,
                    isMeasured: false,
                    role: "figure",
                    fillOpacity: 1,
                    position: "absolute",
                    strokeWidth: 0.2,
                    strokeOpacity: 1,
                });
                setColor(rule, "fill", ic, "primaryButton");
                setColor(rule, "stroke", ic, "background");
            }
            r("Graphics", ["map", "button", "plus", "icon"]).setAll({
                x: p50,
                y: p50,
                draw: function (display) {
                    display.moveTo(-4, 0);
                    display.lineTo(4, 0);
                    display.moveTo(0, -4);
                    display.lineTo(0, 4);
                }
            });
            r("Graphics", ["map", "button", "minus", "icon"]).setAll({
                x: p50,
                y: p50,
                draw: function (display) {
                    display.moveTo(-4, 0);
                    display.lineTo(4, 0);
                }
            });
            /**
             * ------------------------------------------------------------------------
             * charts/map: Series
             * ------------------------------------------------------------------------
             */
            r("GraticuleSeries").setAll({
                step: 10
            });
        }
    });
    return MapChartDefaultTheme;
}(Theme));
export { MapChartDefaultTheme };
//# sourceMappingURL=MapChartDefaultTheme.js.map