import type { IMapLineSeriesDataItem } from "./MapLineSeries";
import type { IMapPolygonSeriesDataItem } from "./MapPolygonSeries";
import type { Bullet } from "../../core/render/Bullet";
import type { DataItem } from "../../core/render/Component";
import { MapSeries, IMapSeriesSettings, IMapSeriesDataItem, IMapSeriesPrivate } from "./MapSeries";
import type { Animation } from "../../core/util/Entity";
export interface IMapPointSeriesPrivate extends IMapSeriesPrivate {
}
export interface IMapPointSeriesDataItem extends IMapSeriesDataItem {
    /**
     * GeoJSON geometry of the point.
     */
    geometry?: GeoJSON.Point | GeoJSON.MultiPoint;
    /**
     * Longitude.
     */
    longitude?: number;
    /**
     * Latitude.
     */
    latitude?: number;
    /**
     * Relative position (0-1) on the [[MapLine]] to place point on.
     */
    positionOnLine?: number;
    /**
     * Automatically rotate the point bullet to face the direction of the line
     * it is attached to.
     */
    autoRotate?: boolean;
    /**
     * The angle will be added to the automatically-calculated angle.
     *
     * Can be used to reverse the direction.
     */
    autoRotateAngle?: number;
    /**
     * A data item from a [[MapLineSeries]] the point is attached to.
     */
    lineDataItem?: DataItem<IMapLineSeriesDataItem>;
    /**
     * An ID of a [[MapLine]] the point is attached to.
     */
    lineId?: string;
    /**
     * A data item from a [[MapPolygonSeries]] to use for positioning of the
     * point.
     */
    polygonDataItem?: DataItem<IMapPolygonSeriesDataItem>;
    /**
     * An ID of the [[MapPolygon]] to use for centering the point.
     */
    polygonId?: string;
}
export interface IMapPointSeriesSettings extends IMapSeriesSettings {
    /**
     * A field in data that holds an ID of the related polygon.
     *
     * If set, the point will be positioned in the visual center of the target
     * polygon.
     */
    polygonIdField?: string;
    /**
     * If set to `true` will hide all points that are in the visible range of
     * the map.
     */
    clipFront?: boolean;
    /**
     * If set to `true` will hide all points that are in the invisible range of
     * the map.
     *
     * For example on the side of the globe facing away from the viewer when
     * used with Orthographic projection.
     *
     * NOTE: not all projections have invisible side.
     *
     * @default true
     */
    clipBack?: boolean;
    latitudeField?: string;
    longitudeField?: string;
}
/**
 * Creates a map series for displaying markers on the map.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/map-chart/map-point-series/} for more info
 * @important
 */
export declare class MapPointSeries extends MapSeries {
    static className: string;
    static classNames: Array<string>;
    _settings: IMapPointSeriesSettings;
    _privateSettings: IMapPointSeriesPrivate;
    _dataItemSettings: IMapPointSeriesDataItem;
    protected _types: Array<GeoJSON.GeoJsonGeometryTypes>;
    protected _afterNew(): void;
    /**
     * @ignore
     */
    markDirtyProjection(): void;
    /**
     * Forces a repaint of the element which relies on data.
     *
     * @since 5.0.21
     */
    markDirtyValues(dataItem: DataItem<this["_dataItemSettings"]>): void;
    protected processDataItem(dataItem: DataItem<this["_dataItemSettings"]>): void;
    protected _makeBullets(dataItem: DataItem<this["_dataItemSettings"]>): void;
    _positionBullet(bullet: Bullet): void;
    protected _positionBulletReal(bullet: Bullet, geometry: GeoJSON.Geometry, coordinates: [number, number], angle?: number): void;
    /**
     * Centers the map to specific series' data item and zooms to the level
     * specified in the parameters.
     *
     * @param  dataItem   Map point
     * @param  zoomLevel  Zoom level
     */
    zoomToDataItem(dataItem: DataItem<IMapPointSeriesDataItem>, zoomLevel: number): Animation<any> | undefined;
}
//# sourceMappingURL=MapPointSeries.d.ts.map