import type { MapChart } from "./MapChart";
import type { GeoProjection, GeoPath } from "d3-geo";
import { Series, ISeriesSettings, ISeriesDataItem, ISeriesPrivate, ISeriesEvents } from "../../core/render/Series";
export interface IMapSeriesDataItem extends ISeriesDataItem {
    geometry?: GeoJSON.Geometry;
    geometryType?: GeoJSON.GeoJsonGeometryTypes;
    value?: number;
}
export interface IMapSeriesSettings extends ISeriesSettings {
    /**
     * Map data in GeoJSON format.
     */
    geoJSON?: GeoJSON.GeoJSON;
    /**
     * An array of map object ids from geodata to include in the map.
     *
     * If set, only those objects listed in `include` will be shown.
     */
    include?: Array<string>;
    /**
     * An array of map object ids from geodata to omit when showing the map.
     */
    exclude?: Array<string>;
    /**
     * A field in series `data` that will hold map object's numeric value.
     *
     * It can be used in a number of places, e.g. tooltips, heat rules, etc.
     */
    valueField?: string;
    /**
     * @ignore
     */
    geometryField?: string;
    /**
     * @ignore
     */
    geometryTypeField?: string;
}
export interface IMapSeriesPrivate extends ISeriesPrivate {
}
export interface IMapSeriesEvents extends ISeriesEvents {
    /**
     * Invoked when geodata is finished loading and processed.
     */
    geodataprocessed: {};
}
/**
 * Base class for map series.
 */
export declare abstract class MapSeries extends Series {
    static className: string;
    static classNames: Array<string>;
    chart: MapChart | undefined;
    _settings: IMapSeriesSettings;
    _privateSettings: IMapSeriesPrivate;
    _dataItemSettings: IMapSeriesDataItem;
    _events: IMapSeriesEvents;
    protected _types: Array<GeoJSON.GeoJsonGeometryTypes>;
    _geometries: Array<GeoJSON.Geometry>;
    protected _geoJSONparsed: boolean;
    protected _afterNew(): void;
    _prepareChildren(): void;
    protected checkInclude(id: string, includes: string[] | undefined, excludes?: string[] | undefined): boolean;
    protected _parseGeoJSON(): void;
    /**
     * @ignore
     */
    abstract markDirtyProjection(): void;
    _placeBulletsContainer(_chart: MapChart): void;
    _removeBulletsContainer(): void;
    /**
     * @ignore
     */
    projection(): GeoProjection | undefined;
    /**
     * @ignore
     */
    geoPath(): GeoPath | undefined;
    protected _addGeometry(geometry: any): void;
    protected _removeGeometry(geometry: any): void;
    protected _dispose(): void;
}
//# sourceMappingURL=MapSeries.d.ts.map