import { __extends } from "tslib";
import { Series } from "../../core/render/Series";
import * as $array from "../../core/util/Array";
import * as $object from "../../core/util/Object";
/**
 * Base class for map series.
 */
var MapSeries = /** @class */ (function (_super) {
    __extends(MapSeries, _super);
    function MapSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_types", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(_this, "_geometries", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(_this, "_geoJSONparsed", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        return _this;
    }
    Object.defineProperty(MapSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.fields.push("geometry", "geometryType");
            this._setRawDefault("geometryField", "geometry");
            this._setRawDefault("geometryTypeField", "geometryType");
            this._setRawDefault("idField", "id");
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(MapSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this._valuesDirty || this.isDirty("geoJSON") || this.isDirty("include") || this.isDirty("exclude")) {
                var geoJSON = this.get("geoJSON");
                var previous = this._prevSettings.geoJSON;
                if (previous && previous != geoJSON) {
                    this._prevSettings.geoJSON = undefined;
                    this._geoJSONparsed = false;
                    this.data.clear();
                }
                if (!this._geoJSONparsed) {
                    this._parseGeoJSON();
                    this._geoJSONparsed = true;
                }
            }
        }
    });
    Object.defineProperty(MapSeries.prototype, "checkInclude", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (id, includes, excludes) {
            if (includes) {
                if (includes.length == 0) {
                    return false;
                }
                else {
                    if (includes.indexOf(id) == -1) {
                        return false;
                    }
                }
            }
            if (excludes && excludes.length > 0) {
                if (excludes.indexOf(id) != -1) {
                    return false;
                }
            }
            return true;
        }
    });
    Object.defineProperty(MapSeries.prototype, "_parseGeoJSON", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var geoJSON = this.get("geoJSON");
            if (geoJSON) {
                var features = void 0;
                if (geoJSON.type == "FeatureCollection") {
                    features = geoJSON.features;
                }
                else if (geoJSON.type == "Feature") {
                    features = [geoJSON];
                }
                else if (["Point", "LineString", "Polygon", "MultiPoint", "MultiLineString", "MultiPolygon"].indexOf(geoJSON.type) != -1) {
                    features = [{ geometry: geoJSON }];
                }
                else {
                    console.log("nothing found in geoJSON");
                }
                if (features) {
                    var _loop_1 = function (i, len) {
                        var feature = features[i];
                        var geometry = feature.geometry;
                        if (geometry) {
                            var type_1 = geometry.type;
                            var id_1 = feature.id;
                            // @todo
                            //if (this.chart.geodataNames && this.chart.geodataNames[id]) {
                            //	feature.properties.name = this.chart.geodataNames[id];
                            //}
                            if (this_1._types.indexOf(type_1) != -1) {
                                if (!this_1.checkInclude(id_1, this_1.get("include"), this_1.get("exclude"))) {
                                    return "continue";
                                }
                                var dataItem = void 0;
                                if (id_1 != null) {
                                    // find data object in user-provided data
                                    dataItem = $array.find(this_1.dataItems, function (value) {
                                        return value.get("id") == id_1;
                                    });
                                }
                                var dataObject = void 0;
                                if (dataItem) {
                                    dataObject = dataItem.dataContext;
                                }
                                // create one if not found
                                if (!dataItem) {
                                    dataObject = { geometry: geometry, geometryType: type_1, id: id_1, madeFromGeoData: true };
                                    this_1.data.push(dataObject);
                                }
                                // in case found
                                else {
                                    // if user-provided object doesn't have points data provided in any way:
                                    if (!dataObject.geometry) {
                                        dataObject.geometry = geometry;
                                        dataObject.geometryType = type_1;
                                        dataItem.set("geometry", geometry);
                                        dataItem.set("geometryType", type_1);
                                        this_1.processDataItem(dataItem);
                                    }
                                }
                                // copy properties data to datacontext
                                $object.softCopyProperties(feature.properties, dataObject);
                            }
                        }
                    };
                    var this_1 = this;
                    for (var i = 0, len = features.length; i < len; i++) {
                        _loop_1(i, len);
                    }
                }
                var type = "geodataprocessed";
                if (this.events.isEnabled(type)) {
                    this.events.dispatch(type, { type: type, target: this });
                }
            }
        }
    });
    Object.defineProperty(MapSeries.prototype, "_placeBulletsContainer", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_chart) {
            this.children.moveValue(this.bulletsContainer);
        }
    });
    Object.defineProperty(MapSeries.prototype, "_removeBulletsContainer", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(MapSeries.prototype, "projection", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var chart = this.chart;
            if (chart) {
                return chart.get("projection");
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(MapSeries.prototype, "geoPath", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var chart = this.chart;
            if (chart) {
                return chart.getPrivate("geoPath");
            }
        }
    });
    Object.defineProperty(MapSeries.prototype, "_addGeometry", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (geometry) {
            if (geometry) {
                this._geometries.push(geometry);
                var chart = this.chart;
                if (chart) {
                    chart.markDirtyGeometries();
                }
            }
        }
    });
    Object.defineProperty(MapSeries.prototype, "_removeGeometry", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (geometry) {
            if (geometry) {
                $array.remove(this._geometries, geometry);
                var chart = this.chart;
                if (chart) {
                    chart.markDirtyGeometries();
                }
            }
        }
    });
    Object.defineProperty(MapSeries.prototype, "_dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._dispose.call(this);
            var chart = this.chart;
            if (chart) {
                chart.series.removeValue(this);
            }
        }
    });
    Object.defineProperty(MapSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "MapSeries"
    });
    Object.defineProperty(MapSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Series.classNames.concat([MapSeries.className])
    });
    return MapSeries;
}(Series));
export { MapSeries };
//# sourceMappingURL=MapSeries.js.map