import { __extends } from "tslib";
import { Container } from "../../core/render/Container";
import { Graphics } from "../../core/render/Graphics";
import { Percent, percent } from "../../core/util/Percent";
import * as $utils from "../../core/util/Utils";
/**
 * A clock hand for use with [[RadarChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/radar-chart/gauge-charts/#Clock_hands} for more info
 * @important
 */
var ClockHand = /** @class */ (function (_super) {
    __extends(ClockHand, _super);
    function ClockHand() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A "hand" element.
         *
         * @default Graphics.new()
         */
        Object.defineProperty(_this, "hand", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(Graphics.new(_this._root, { themeTags: ["hand"] }))
        });
        /**
         * A "pin" element (hand's base).
         *
         * @default Graphics.new()
         */
        Object.defineProperty(_this, "pin", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(Graphics.new(_this._root, { themeTags: ["pin"] }))
        });
        return _this;
    }
    Object.defineProperty(ClockHand.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["clock"]);
            _super.prototype._afterNew.call(this);
            // to be redrawn when size changes
            this.set("width", percent(1));
            this.adapters.add("x", function () {
                return 0;
            });
            this.adapters.add("y", function () {
                return 0;
            });
            this.pin.set("draw", function (display, graphics) {
                var parent = graphics.parent;
                if (parent) {
                    var dataItem = parent.dataItem;
                    if (dataItem) {
                        var axis = dataItem.component;
                        if (axis) {
                            var chart = axis.chart;
                            if (chart) {
                                var cr = chart.getPrivate("radius", 0);
                                var r = $utils.relativeToValue(parent.get("pinRadius", 0), cr);
                                if (r < 0) {
                                    r = cr + r;
                                }
                                display.moveTo(r, 0);
                                display.arc(0, 0, r, 0, 360);
                            }
                        }
                    }
                }
            });
            this.hand.set("draw", function (display, graphics) {
                var parent = graphics.parent;
                if (parent) {
                    var bullet = parent.parent;
                    // to be redrawn when size changes
                    if (bullet) {
                        bullet.set("width", percent(1));
                    }
                    var dataItem = parent.dataItem;
                    if (dataItem) {
                        var axis = dataItem.component;
                        if (axis) {
                            var chart = axis.chart;
                            if (chart) {
                                var bw = parent.get("bottomWidth", 10) / 2;
                                var tw = parent.get("topWidth", 0) / 2;
                                var cr = chart.getPrivate("radius", 0);
                                var r = $utils.relativeToValue(parent.get("radius", 0), cr);
                                if (r < 0) {
                                    r = cr + r;
                                }
                                var ir = parent.get("innerRadius", 0);
                                if (ir instanceof Percent) {
                                    ir = $utils.relativeToValue(ir, cr);
                                }
                                else {
                                    if (ir < 0) {
                                        if (ir < 0) {
                                            ir = r + ir;
                                        }
                                    }
                                }
                                display.moveTo(ir, -bw);
                                display.lineTo(r, -tw);
                                display.lineTo(r, tw);
                                display.lineTo(ir, bw);
                                display.lineTo(ir, -bw);
                            }
                        }
                    }
                }
            });
        }
    });
    Object.defineProperty(ClockHand.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            this.hand._markDirtyKey("fill");
            this.pin._markDirtyKey("fill");
        }
    });
    Object.defineProperty(ClockHand, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ClockHand"
    });
    Object.defineProperty(ClockHand, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Container.classNames.concat([ClockHand.className])
    });
    return ClockHand;
}(Container));
export { ClockHand };
//# sourceMappingURL=ClockHand.js.map