import { __extends, __read } from "tslib";
import { BaseColumnSeries } from "../xy/series/BaseColumnSeries";
import { Slice } from "../../core/render/Slice";
import { Graphics } from "../../core/render/Graphics";
import { Template } from "../../core/util/Template";
import { ListTemplate } from "../../core/util/List";
import * as $math from "../../core/util/Math";
import * as $utils from "../../core/util/Utils";
/**
 * A column series for use in a [[RadarChart]].
 *
 * @important
 */
var RadarColumnSeries = /** @class */ (function (_super) {
    __extends(RadarColumnSeries, _super);
    function RadarColumnSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A [[TemplateList]] of all columns in series.
         *
         * `columns.template` can be used to set default settings for all columns,
         * or to change on existing ones.
         *
         * @default new ListTemplate<Slice>
         */
        Object.defineProperty(_this, "columns", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return Slice._new(_this._root, {
                position: "absolute",
                themeTags: $utils.mergeTags(_this.columns.template.get("themeTags", []), ["radar", "series", "column"])
            }, [_this.columns.template]); })
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(RadarColumnSeries.prototype, "makeColumn", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, listTemplate) {
            var column = this.mainContainer.children.push(listTemplate.make());
            column._setDataItem(dataItem);
            listTemplate.push(column);
            return column;
        }
    });
    Object.defineProperty(RadarColumnSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this.set("maskContent", false);
            this.bulletsContainer.set("maskContent", false);
            this.bulletsContainer.set("mask", Graphics.new(this._root, {}));
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(RadarColumnSeries.prototype, "getPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (positionX, positionY) {
            var yAxis = this.get("yAxis");
            var xAxis = this.get("xAxis");
            var rendererY = xAxis.get("renderer");
            var radius = yAxis.get("renderer").positionToCoordinate(positionY) + rendererY.getPrivate("innerRadius", 0);
            var rendererX = xAxis.get("renderer");
            var angle = rendererX.positionToAngle(positionX);
            return { x: radius * $math.cos(angle), y: radius * $math.sin(angle) };
        }
    });
    Object.defineProperty(RadarColumnSeries.prototype, "_updateSeriesGraphics", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, graphics, l, r, t, b) {
            var _a;
            graphics.setPrivate("visible", true);
            var xAxis = this.get("xAxis");
            var yAxis = this.get("yAxis");
            var rendererX = xAxis.get("renderer");
            var rendererY = yAxis.get("renderer");
            var axisInnerRadius = rendererY.getPrivate("innerRadius", 0);
            var startAngle = rendererX.fitAngle(rendererX.positionToAngle(l));
            var endAngle = rendererX.fitAngle(rendererX.positionToAngle(r));
            var innerRadius = rendererY.positionToCoordinate(b) + axisInnerRadius;
            var radius = rendererY.positionToCoordinate(t) + axisInnerRadius;
            var slice = graphics;
            dataItem.setRaw("startAngle", startAngle);
            dataItem.setRaw("endAngle", endAngle);
            dataItem.setRaw("innerRadius", innerRadius);
            dataItem.setRaw("radius", radius);
            var axisStartAngle = 0;
            var axisEndAngle = 360;
            if (yAxis == this.get("baseAxis")) {
                axisStartAngle = rendererY.getPrivate("startAngle", 0);
                axisEndAngle = rendererY.getPrivate("endAngle", 360);
            }
            else {
                axisStartAngle = rendererX.getPrivate("startAngle", 0);
                axisEndAngle = rendererX.getPrivate("endAngle", 360);
            }
            if (axisStartAngle > axisEndAngle) {
                _a = __read([axisEndAngle, axisStartAngle], 2), axisStartAngle = _a[0], axisEndAngle = _a[1];
            }
            if ((endAngle <= axisStartAngle) || (startAngle >= axisEndAngle) || (radius <= axisInnerRadius && innerRadius <= axisInnerRadius)) {
                slice.setPrivate("visible", false);
            }
            slice.setAll({ innerRadius: innerRadius, radius: radius, startAngle: startAngle, arc: endAngle - startAngle });
        }
    });
    Object.defineProperty(RadarColumnSeries.prototype, "_shouldInclude", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            var xAxis = this.get("xAxis");
            if (position < xAxis.get("start") || position > xAxis.get("end")) {
                return false;
            }
            return true;
        }
    });
    Object.defineProperty(RadarColumnSeries.prototype, "_shouldShowBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (positionX, _positionY) {
            var xAxis = this.get("xAxis");
            if (positionX < xAxis.get("start") || positionX > xAxis.get("end")) {
                return false;
            }
            return this._showBullets;
        }
    });
    Object.defineProperty(RadarColumnSeries.prototype, "_positionBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (bullet) {
            var sprite = bullet.get("sprite");
            if (sprite) {
                var dataItem = sprite.dataItem;
                var locationX = bullet.get("locationX", dataItem.get("locationX", 0.5));
                var locationY = bullet.get("locationY", dataItem.get("locationY", 0.5));
                var series = dataItem.component;
                var xAxis = series.get("xAxis");
                var yAxis = series.get("yAxis");
                var positionX = xAxis.getDataItemPositionX(dataItem, series._xField, locationX, series.get("vcx", 1));
                var positionY = yAxis.getDataItemPositionY(dataItem, series._yField, locationY, series.get("vcy", 1));
                var startAngle = dataItem.get("startAngle", 0);
                var endAngle = dataItem.get("endAngle", 0);
                var radius = dataItem.get("radius", 0);
                var innerRadius = dataItem.get("innerRadius", 0);
                if (series._shouldShowBullet(positionX, positionY)) {
                    sprite.setPrivate("visible", true);
                    var angle = startAngle + (endAngle - startAngle) * locationX;
                    var r = innerRadius + (radius - innerRadius) * locationY;
                    sprite.set("x", $math.cos(angle) * r);
                    sprite.set("y", $math.sin(angle) * r);
                }
                else {
                    sprite.setPrivate("visible", false);
                }
            }
        }
    });
    Object.defineProperty(RadarColumnSeries.prototype, "_handleMaskBullets", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
        }
    });
    Object.defineProperty(RadarColumnSeries.prototype, "_processAxisRange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (axisRange) {
            var _this = this;
            _super.prototype._processAxisRange.call(this, axisRange);
            axisRange.columns = new ListTemplate(Template.new({}), function () { return Slice._new(_this._root, {
                position: "absolute",
                themeTags: $utils.mergeTags(axisRange.columns.template.get("themeTags", []), ["radar", "series", "column"]),
            }, [_this.columns.template, axisRange.columns.template]); });
        }
    });
    Object.defineProperty(RadarColumnSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "RadarColumnSeries"
    });
    Object.defineProperty(RadarColumnSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: BaseColumnSeries.classNames.concat([RadarColumnSeries.className])
    });
    return RadarColumnSeries;
}(BaseColumnSeries));
export { RadarColumnSeries };
//# sourceMappingURL=RadarColumnSeries.js.map