import { __extends } from "tslib";
import { LineSeries } from "../xy/series/LineSeries";
import { Graphics } from "../../core/render/Graphics";
import * as $math from "../../core/util/Math";
/**
 * Draws a line series for use in a [[RadarChart]].
 *
 * @important
 */
var RadarLineSeries = /** @class */ (function (_super) {
    __extends(RadarLineSeries, _super);
    function RadarLineSeries() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(RadarLineSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this.set("maskContent", false);
            this.bulletsContainer.set("maskContent", false);
            this.bulletsContainer.set("mask", Graphics.new(this._root, {}));
        }
    });
    Object.defineProperty(RadarLineSeries.prototype, "_handleMaskBullets", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
        }
    });
    Object.defineProperty(RadarLineSeries.prototype, "getPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (positionX, positionY) {
            var yAxis = this.get("yAxis");
            var xAxis = this.get("xAxis");
            var rendererY = yAxis.get("renderer");
            var radius = rendererY.positionToCoordinate(positionY) + rendererY.getPrivate("innerRadius", 0);
            var rendererX = xAxis.get("renderer");
            var angle = rendererX.positionToAngle(positionX);
            return { x: radius * $math.cos(angle), y: radius * $math.sin(angle) };
        }
    });
    Object.defineProperty(RadarLineSeries.prototype, "_endLine", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (points, firstPoint) {
            if (this.get("connectEnds") && firstPoint) {
                points.push(firstPoint);
            }
        }
    });
    Object.defineProperty(RadarLineSeries.prototype, "_shouldInclude", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            var xAxis = this.get("xAxis");
            if (position < xAxis.get("start") || position > xAxis.get("end")) {
                return false;
            }
            return true;
        }
    });
    Object.defineProperty(RadarLineSeries.prototype, "_shouldShowBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (positionX, _positionY) {
            var xAxis = this.get("xAxis");
            if (positionX < xAxis.get("start") || positionX > xAxis.get("end")) {
                return false;
            }
            return this._showBullets;
        }
    });
    Object.defineProperty(RadarLineSeries.prototype, "_positionBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (bullet) {
            var sprite = bullet.get("sprite");
            if (sprite) {
                var dataItem = sprite.dataItem;
                var locationX = bullet.get("locationX", dataItem.get("locationX", 0.5));
                var locationY = bullet.get("locationY", dataItem.get("locationY", 0.5));
                var xAxis = this.get("xAxis");
                var yAxis = this.get("yAxis");
                //let baseAxis = this.get("baseAxis");
                //if(xAxis == baseAxis){
                //locationY = 1;
                //}
                //else if(yAxis == baseAxis){
                //locationX = 1;
                //}
                var positionX = xAxis.getDataItemPositionX(dataItem, this._xField, locationX, this.get("vcx", 1));
                var positionY = yAxis.getDataItemPositionY(dataItem, this._yField, locationY, this.get("vcy", 1));
                var point = this.getPoint(positionX, positionY);
                if (this._shouldShowBullet(positionX, positionY)) {
                    sprite.setPrivate("visible", true);
                    sprite.set("x", point.x);
                    sprite.set("y", point.y);
                }
                else {
                    sprite.setPrivate("visible", false);
                }
            }
        }
    });
    Object.defineProperty(RadarLineSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "RadarLineSeries"
    });
    Object.defineProperty(RadarLineSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: LineSeries.classNames.concat([RadarLineSeries.className])
    });
    return RadarLineSeries;
}(LineSeries));
export { RadarLineSeries };
//# sourceMappingURL=RadarLineSeries.js.map