import { __extends } from "tslib";
import { RadarLineSeries } from "./RadarLineSeries";
import { curveCardinalClosed, curveCardinal } from "d3-shape";
/**
 * Draws a smoothed line series for use in a [[RadarChart]].
 *
 * @important
 */
var SmoothedRadarLineSeries = /** @class */ (function (_super) {
    __extends(SmoothedRadarLineSeries, _super);
    function SmoothedRadarLineSeries() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(SmoothedRadarLineSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._setDefault("curveFactory", curveCardinalClosed.tension(this.get("tension", 0)));
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(SmoothedRadarLineSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this.isDirty("connectEnds")) {
                var connectEnds = this.get("connectEnds");
                if (connectEnds) {
                    this.setRaw("curveFactory", curveCardinalClosed.tension(this.get("tension", 0)));
                }
                else {
                    this.setRaw("curveFactory", curveCardinal.tension(this.get("tension", 0)));
                }
            }
            if (this.isDirty("tension")) {
                var cf = this.get("curveFactory");
                if (cf) {
                    cf.tension(this.get("tension", 0));
                }
            }
        }
    });
    Object.defineProperty(SmoothedRadarLineSeries.prototype, "_endLine", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_points, _firstPoint) {
        }
    });
    Object.defineProperty(SmoothedRadarLineSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "SmoothedRadarLineSeries"
    });
    Object.defineProperty(SmoothedRadarLineSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: RadarLineSeries.classNames.concat([SmoothedRadarLineSeries.className])
    });
    return SmoothedRadarLineSeries;
}(RadarLineSeries));
export { SmoothedRadarLineSeries };
//# sourceMappingURL=SmoothedRadarLineSeries.js.map