import { __extends } from "tslib";
import { Theme } from "../../core/Theme";
import { percent, p100, p50 } from "../../core/util/Percent";
import { Rectangle } from "../../core/render/Rectangle";
import * as $ease from "../../core/util/Ease";
/**
 * @ignore
 */
var WordCloudDefaultTheme = /** @class */ (function (_super) {
    __extends(WordCloudDefaultTheme, _super);
    function WordCloudDefaultTheme() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(WordCloudDefaultTheme.prototype, "setupDefaultRules", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype.setupDefaultRules.call(this);
            var ic = this._root.interfaceColors;
            var r = this.rule.bind(this);
            r("WordCloud").setAll({
                width: p100,
                height: p100,
                minFontSize: percent(2),
                maxFontSize: percent(15),
                excludeWords: [],
                angles: [0, -90],
                minWordLength: 1,
                step: 15,
                randomness: 0,
                autoFit: true,
                animationEasing: $ease.out($ease.cubic)
            });
            {
                var rule = r("Label", ["wordcloud"]);
                rule.setAll({
                    text: "{category}",
                    centerX: p50,
                    centerY: p50,
                    position: "absolute",
                    lineHeight: p100,
                    populateText: true
                });
                rule.setup = function (target) {
                    target.set("background", Rectangle.new(_this._root, {
                        fill: ic.get("background"),
                        fillOpacity: 0
                    }));
                };
            }
        }
    });
    return WordCloudDefaultTheme;
}(Theme));
export { WordCloudDefaultTheme };
//# sourceMappingURL=WordCloudDefaultTheme.js.map