import { __extends, __read } from "tslib";
import { Scrollbar } from "../../core/render/Scrollbar";
import { XYChart } from "./XYChart";
import { Graphics } from "../../core/render/Graphics";
import * as $utils from "../../core/util/Utils";
/**
 * Creates a scrollbar with chart preview in it.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/scrollbars/#Scrollbar_with_chart_preview} for more info
 * @important
 */
var XYChartScrollbar = /** @class */ (function (_super) {
    __extends(XYChartScrollbar, _super);
    function XYChartScrollbar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * An instance of an [[XYChart]] that is used to plot chart preview in
         * scrollbar.
         */
        Object.defineProperty(_this, "chart", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(XYChart.new(_this._root, {
                themeTags: ["chart"],
                interactive: false,
                interactiveChildren: false,
                panX: false,
                panY: false,
                wheelX: "none",
                wheelY: "none"
            }))
        });
        /**
         * A graphics element that is displayed over inactive portion of the
         * scrollbarpreview, to dim it down.
         */
        Object.defineProperty(_this, "overlay", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(Graphics.new(_this._root, {
                themeTags: ["overlay"],
                interactive: false
            }))
        });
        return _this;
    }
    Object.defineProperty(XYChartScrollbar.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._addOrientationClass();
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["scrollbar", "xy", "chart", this._settings.orientation]);
            var children = this.children;
            children.moveValue(this.thumb);
            children.moveValue(this.startGrip);
            children.moveValue(this.endGrip);
            this.thumb.set("opacity", 0);
            this.thumb.states.create("hover", { opacity: 0.2 });
            var plotContainer = this.chart.plotContainer;
            plotContainer.set("interactive", false);
            plotContainer.remove("background");
            plotContainer.children.removeValue(this.chart.zoomOutButton);
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(XYChartScrollbar.prototype, "_updateThumb", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._updateThumb.call(this);
            this.overlay.set("draw", function (display) {
                var _a, _b;
                var startGrip = _this.startGrip;
                var endGrip = _this.endGrip;
                var x0 = startGrip.x();
                var y0 = startGrip.y();
                var x1 = endGrip.x();
                var y1 = endGrip.y();
                var h = _this.height();
                var w = _this.width();
                if (x0 > x1) {
                    _a = __read([x1, x0], 2), x0 = _a[0], x1 = _a[1];
                }
                if (y0 > y1) {
                    _b = __read([y1, y0], 2), y0 = _b[0], y1 = _b[1];
                }
                if (_this.get("orientation") === "horizontal") {
                    display.moveTo(0, 0);
                    display.lineTo(x0, 0);
                    display.lineTo(x0, h);
                    display.lineTo(0, h);
                    display.lineTo(0, 0);
                    display.moveTo(x1, 0);
                    display.lineTo(w, 0);
                    display.lineTo(w, h);
                    display.lineTo(x1, h);
                    display.lineTo(x1, 0);
                }
                else {
                    display.moveTo(0, 0);
                    display.lineTo(0, y0);
                    display.lineTo(w, y0);
                    display.lineTo(w, 0);
                    display.lineTo(0, 0);
                    display.moveTo(0, y1);
                    display.lineTo(0, h);
                    display.lineTo(w, h);
                    display.lineTo(w, y1);
                    display.lineTo(0, y1);
                }
            });
        }
    });
    Object.defineProperty(XYChartScrollbar, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "XYChartScrollbar"
    });
    Object.defineProperty(XYChartScrollbar, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Scrollbar.classNames.concat([XYChartScrollbar.className])
    });
    return XYChartScrollbar;
}(Scrollbar));
export { XYChartScrollbar };
//# sourceMappingURL=XYChartScrollbar.js.map