import { __extends } from "tslib";
import { Entity } from "../../../core/util/Entity";
/**
 * Draws a bullet on an axis.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/#Axis_bullets} for more info
 */
var AxisBullet = /** @class */ (function (_super) {
    __extends(AxisBullet, _super);
    function AxisBullet() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Target axis object.
         */
        Object.defineProperty(_this, "axis", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(AxisBullet.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            var sprite = this.get("sprite");
            if (this.isDirty("sprite")) {
                if (sprite) {
                    sprite.setAll({ position: "absolute", role: "figure" });
                    this._disposers.push(sprite);
                }
            }
            if (this.isDirty("location")) {
                var dataItem = sprite.dataItem;
                if (this.axis && sprite && dataItem) {
                    this.axis._prepareDataItem(dataItem);
                }
            }
        }
    });
    Object.defineProperty(AxisBullet, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "AxisBullet"
    });
    Object.defineProperty(AxisBullet, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Entity.classNames.concat([AxisBullet.className])
    });
    return AxisBullet;
}(Entity));
export { AxisBullet };
//# sourceMappingURL=AxisBullet.js.map