import { __assign, __extends } from "tslib";
import { CategoryAxis } from "./CategoryAxis";
import * as $time from "../../../core/util/Time";
import * as $type from "../../../core/util/Type";
import * as $array from "../../../core/util/Array";
import * as $utils from "../../../core/util/Utils";
/**
 * Category-based date axis.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/category-date-axis/} for more info
 * @important
 */
var CategoryDateAxis = /** @class */ (function (_super) {
    __extends(CategoryDateAxis, _super);
    function CategoryDateAxis() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_frequency", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 1
        });
        Object.defineProperty(_this, "_itemMap", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        return _this;
    }
    Object.defineProperty(CategoryDateAxis.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["axis"]);
            this.fields.push("category");
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(CategoryDateAxis.prototype, "_prepareAxisItems", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            // temp
            this.setPrivateRaw("baseInterval", this.get("baseInterval"));
            var renderer = this.get("renderer");
            var len = this.dataItems.length;
            var startIndex = this.startIndex();
            if (startIndex > 0) {
                startIndex--;
            }
            var endIndex = this.endIndex();
            if (endIndex < len) {
                endIndex++;
            }
            var maxCount = renderer.axisLength() / Math.max(renderer.get("minGridDistance"), 1 / Number.MAX_SAFE_INTEGER);
            var frequency = Math.min(len, Math.ceil((endIndex - startIndex) / maxCount));
            startIndex = Math.floor(startIndex / frequency) * frequency;
            this._frequency = frequency;
            for (var j = 0; j < len; j++) {
                this.dataItems[j].hide();
            }
            var startTime = Number(this.dataItems[startIndex].get("category"));
            var endTime = Number(this.dataItems[endIndex - 1].get("category"));
            var realDuration = (endTime - startTime);
            if (endIndex - startIndex < maxCount) {
                realDuration = (endTime - startTime) - ((endTime - startTime) / this.baseDuration() - (endIndex - startIndex)) * this.baseDuration();
            }
            // if all items are on axis
            var gridInterval = $time.chooseInterval(0, realDuration, maxCount, this.get("gridIntervals"));
            var nextGridUnit = $time.getNextUnit(gridInterval.timeUnit);
            var baseInterval = this.getPrivate("baseInterval");
            if ($time.getIntervalDuration(gridInterval) < this.baseDuration()) {
                gridInterval = __assign({}, baseInterval);
            }
            var formats = this.get("dateFormats");
            var previousValue = -Infinity;
            var previousIndex = -Infinity;
            var previousUnitValue = -Infinity;
            var format;
            var selectedItems = [];
            var changed = false;
            for (var i = startIndex; i < endIndex; i++) {
                var dataItem = this.dataItems[i];
                var index = dataItem.get("index");
                var skip = false;
                var value = Number(dataItem.get("category"));
                var date = new Date(value);
                var unitValue = $time.getUnitValue(date, gridInterval.timeUnit);
                format = formats[gridInterval.timeUnit];
                var added = false;
                if (gridInterval.timeUnit != "year" && gridInterval.timeUnit != "week") {
                    if (nextGridUnit && this.get("markUnitChange") && $type.isNumber(previousValue)) {
                        if ($time.checkChange(value, previousValue, nextGridUnit, this._root.utc)) {
                            format = this.get("periodChangeDateFormats")[gridInterval.timeUnit];
                            if (index - frequency * 0.5 < previousIndex) {
                                selectedItems.pop();
                            }
                            selectedItems.push({ format: format, dataItem: dataItem });
                            changed = true;
                            added = true;
                            previousIndex = index;
                            previousUnitValue = unitValue;
                        }
                    }
                }
                var shouldAdd = false;
                if (gridInterval.timeUnit === "day" || gridInterval.timeUnit === "week") {
                    if (index - previousIndex >= frequency) {
                        shouldAdd = true;
                    }
                }
                else {
                    if (unitValue % gridInterval.count === 0) {
                        if (unitValue != previousUnitValue) {
                            shouldAdd = true;
                        }
                    }
                }
                if (!added && shouldAdd) {
                    if (index - frequency * 0.7 < previousIndex) {
                        if (changed) {
                            skip = true;
                        }
                    }
                    if (!skip) {
                        selectedItems.push({ format: format, dataItem: dataItem });
                        previousIndex = index;
                        previousUnitValue = unitValue;
                    }
                    changed = false;
                }
                previousValue = value;
            }
            if (selectedItems.length > 0) {
                var f_1 = selectedItems[0].dataItem.get("index", 0);
                $array.each(selectedItems, function (item) {
                    var dataItem = item.dataItem;
                    var format = item.format;
                    _this._createAssets(dataItem, []);
                    if (dataItem.isHidden()) {
                        dataItem.show();
                    }
                    var value = Number(dataItem.get("category"));
                    var date = new Date(value);
                    var label = dataItem.get("label");
                    if (label) {
                        label.set("text", _this._root.dateFormatter.format(date, format));
                    }
                    f_1++;
                    _this._prepareDataItem(dataItem, f_1, frequency);
                });
            }
        }
    });
    /**
     * Returns a duration of currently active `baseInterval` in milliseconds.
     *
     * @return Duration
     */
    Object.defineProperty(CategoryDateAxis.prototype, "baseDuration", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return $time.getIntervalDuration(this.getPrivate("baseInterval"));
        }
    });
    /**
     * Returns text to be used in an axis tooltip for specific relative position.
     *
     * @param   position  Position
     * @return            Tooltip text
     */
    Object.defineProperty(CategoryDateAxis.prototype, "getTooltipText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            //@todo number formatter + tag
            var dataItem = this.dataItems[this.axisPositionToIndex(position)];
            if (dataItem) {
                var format = this.get("dateFormats")[this.getPrivate("baseInterval").timeUnit];
                return this._root.dateFormatter.format(new Date(dataItem.get("category", 0)), this.get("tooltipDateFormat", format));
            }
        }
    });
    Object.defineProperty(CategoryDateAxis.prototype, "_updateTooltipText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (tooltip, position) {
            tooltip.label.set("text", this.getTooltipText(position));
        }
    });
    Object.defineProperty(CategoryDateAxis, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "CategoryDateAxis"
    });
    Object.defineProperty(CategoryDateAxis, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: CategoryAxis.classNames.concat([CategoryDateAxis.className])
    });
    return CategoryDateAxis;
}(CategoryAxis));
export { CategoryDateAxis };
//# sourceMappingURL=CategoryDateAxis.js.map