import { __extends } from "tslib";
import { Graphics } from "../../../core/render/Graphics";
/**
 * Creates an axis grid line.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/#Grid} for more info
 * @important
 */
var Grid = /** @class */ (function (_super) {
    __extends(Grid, _super);
    function Grid() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Grid.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isPrivateDirty("width") || this.isPrivateDirty("height")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Grid, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Grid"
    });
    Object.defineProperty(Grid, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([Grid.className])
    });
    return Grid;
}(Graphics));
export { Grid };
//# sourceMappingURL=Grid.js.map