import { __awaiter, __extends, __generator } from "tslib";
import { XYSeries } from "./XYSeries";
import { Percent } from "../../../core/util/Percent";
import { visualSettings } from "../../../core/render/Graphics";
import * as $array from "../../../core/util/Array";
import * as $type from "../../../core/util/Type";
/**
 * Base class for all "column-based" series
 */
var BaseColumnSeries = /** @class */ (function (_super) {
    __extends(BaseColumnSeries, _super);
    function BaseColumnSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_ph", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_pw", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        return _this;
    }
    Object.defineProperty(BaseColumnSeries.prototype, "_makeGraphics", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (listTemplate, dataItem) {
            return this.makeColumn(dataItem, listTemplate);
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_makeFieldNames", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._makeFieldNames.call(this);
            var xAxis = this.get("xAxis");
            var yAxis = this.get("yAxis");
            var categoryAxis = "CategoryAxis";
            var valueAxis = "ValueAxis";
            if (xAxis.isType(categoryAxis)) {
                if (!this.get("openCategoryXField")) {
                    this._xOpenField = this._xField;
                }
            }
            if (xAxis.isType(valueAxis)) {
                if (!this.get("openValueXField")) {
                    this._xOpenField = this._xField;
                }
            }
            if (yAxis.isType(categoryAxis)) {
                if (!this.get("openCategoryYField")) {
                    this._yOpenField = this._yField;
                }
            }
            if (yAxis.isType(valueAxis)) {
                if (!this.get("openValueYField")) {
                    this._yOpenField = this._yField;
                }
            }
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            var xAxis = this.get("xAxis");
            var yAxis = this.get("yAxis");
            var len = this.dataItems.length;
            var startIndex = Math.max(0, this.startIndex() - 2);
            var endIndex = Math.min(this.endIndex() + 2, len - 1);
            if (xAxis.inited && yAxis.inited) {
                for (var i = startIndex; i <= endIndex; i++) {
                    var dataItem = this.dataItems[i];
                    this._createGraphics(dataItem);
                }
            }
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            var chart = this.chart;
            if (chart) {
                this._ph = chart.plotContainer.height();
                this._pw = chart.plotContainer.width();
            }
            var xAxis = this.get("xAxis");
            var yAxis = this.get("yAxis");
            var baseAxis = this.get("baseAxis");
            var columnsTemplate = this.columns.template;
            if (this.isDirty("fill")) {
                if (columnsTemplate.get("fill") == null) {
                    columnsTemplate.set("fill", this.get("fill"));
                }
            }
            if (this.isDirty("stroke")) {
                if (columnsTemplate.get("stroke") == null) {
                    columnsTemplate.set("stroke", this.get("stroke"));
                }
            }
            var index = 0;
            var clusterCount = 0;
            var i = 0;
            $array.each(baseAxis.series, function (series) {
                if (series instanceof BaseColumnSeries) {
                    var stacked = series.get("stacked");
                    if (stacked && i == 0) {
                        clusterCount++;
                    }
                    if (!stacked && series.get("clustered")) {
                        clusterCount++;
                    }
                }
                if (series === _this) {
                    index = clusterCount - 1;
                }
                i++;
            });
            if (!this.get("clustered")) {
                index = 0;
                clusterCount = 1;
            }
            if (clusterCount === 0) {
                clusterCount = 1;
                index = 0;
            }
            var xRenderer = xAxis.get("renderer");
            var yRenderer = yAxis.get("renderer");
            var cellStartLocation = "cellStartLocation";
            var cellEndLocation = "cellEndLocation";
            var cellLocationX0 = xRenderer.get(cellStartLocation, 0);
            var cellLocationX1 = xRenderer.get(cellEndLocation, 1);
            var cellLocationY0 = yRenderer.get(cellStartLocation, 0);
            var cellLocationY1 = yRenderer.get(cellEndLocation, 1);
            this._aLocationX0 = cellLocationX0 + (index / clusterCount) * (cellLocationX1 - cellLocationX0);
            this._aLocationX1 = cellLocationX0 + (index + 1) / clusterCount * (cellLocationX1 - cellLocationX0);
            ;
            this._aLocationY0 = cellLocationY0 + (index / clusterCount) * (cellLocationY1 - cellLocationY0);
            this._aLocationY1 = cellLocationY0 + (index + 1) / clusterCount * (cellLocationY1 - cellLocationY0);
            if (xAxis.inited && yAxis.inited) {
                if (this._axesDirty || this._valuesDirty || this._stackDirty || this.isDirty("vcx") || this.isDirty("vcy") || this._sizeDirty) {
                    var len = this.dataItems.length;
                    var startIndex = Math.max(0, this.startIndex() - 2);
                    var endIndex = Math.min(this.endIndex() + 2, len - 1);
                    for (var i_1 = 0; i_1 < startIndex; i_1++) {
                        this._toggleColumn(this.dataItems[i_1], false);
                    }
                    var previous = this.dataItems[startIndex];
                    for (var i_2 = startIndex; i_2 <= endIndex; i_2++) {
                        var dataItem = this.dataItems[i_2];
                        if (dataItem.get("valueX") != null && dataItem.get("valueY") != null) {
                            previous = dataItem;
                            if (i_2 > 0 && startIndex > 0) {
                                for (var j = i_2 - 1; j >= 0; j--) {
                                    var dataItem_1 = this.dataItems[j];
                                    if (dataItem_1.get("valueX") != null && dataItem_1.get("valueY") != null) {
                                        previous = dataItem_1;
                                        break;
                                    }
                                }
                            }
                            break;
                        }
                    }
                    for (var i_3 = startIndex; i_3 <= endIndex; i_3++) {
                        var dataItem = this.dataItems[i_3];
                        this._updateGraphics(dataItem, previous);
                        if (dataItem.get("valueX") != null && dataItem.get("valueY") != null) {
                            previous = dataItem;
                        }
                    }
                    for (var i_4 = endIndex + 1; i_4 < len; i_4++) {
                        this._toggleColumn(this.dataItems[i_4], false);
                    }
                }
            }
            else {
                this._skipped = true;
            }
            _super.prototype._updateChildren.call(this);
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_createGraphics", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            var graphics = dataItem.get("graphics");
            if (!graphics) {
                graphics = this._makeGraphics(this.columns, dataItem);
                dataItem.set("graphics", graphics);
                graphics._setDataItem(dataItem);
                var legendDataItem = dataItem.get("legendDataItem");
                if (legendDataItem) {
                    var markerRectangle = legendDataItem.get("markerRectangle");
                    if (markerRectangle) {
                        markerRectangle.setAll({ fill: graphics.get("fill"), stroke: graphics.get("stroke") });
                    }
                }
                this.axisRanges.each(function (axisRange) {
                    var container = axisRange.container;
                    var graphicsArray = dataItem.get("rangeGraphics", []);
                    dataItem.set("rangeGraphics", graphicsArray);
                    var rangeGraphics = _this._makeGraphics(axisRange.columns, dataItem);
                    graphicsArray.push(rangeGraphics);
                    rangeGraphics.setPrivate("list", axisRange.columns);
                    container.children.push(rangeGraphics);
                });
            }
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_updateGraphics", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, previousDataItem) {
            var _this = this;
            var graphics = dataItem.get("graphics");
            //if (!graphics) {
            //	this._createGraphics(dataItem);
            //	graphics = dataItem.get("graphics")!;
            //}
            var xField = this._xField;
            var yField = this._yField;
            var valueX = dataItem.get(xField);
            var valueY = dataItem.get(yField);
            if (valueX != null && valueY != null) {
                var xOpenField = this._xOpenField;
                var yOpenField = this._yOpenField;
                var locationX = this.get("locationX", dataItem.get("locationX", 0.5));
                var locationY = this.get("locationY", dataItem.get("locationY", 0.5));
                var openLocationX = this.get("openLocationX", dataItem.get("openLocationX", locationX));
                var openLocationY = this.get("openLocationY", dataItem.get("openLocationY", locationY));
                var width = graphics.get("width");
                var height = graphics.get("height");
                var stacked = this.get("stacked");
                var xAxis = this.get("xAxis");
                var yAxis = this.get("yAxis");
                var baseAxis = this.get("baseAxis");
                var xStart = xAxis.get("start");
                var xEnd = xAxis.get("end");
                var yStart = yAxis.get("start");
                var yEnd = yAxis.get("end");
                var l_1;
                var r_1;
                var t_1;
                var b_1;
                var vcy = this.get("vcy", 1);
                var vcx = this.get("vcx", 1);
                var fitW_1 = false;
                var fitH_1 = false;
                if (yAxis.isType("CategoryAxis") && xAxis.isType("CategoryAxis")) {
                    var startLocation = this._aLocationX0 + openLocationX - 0.5;
                    var endLocation = this._aLocationX1 + locationX - 0.5;
                    if (width instanceof Percent) {
                        var offset = (endLocation - startLocation) * (1 - width.value) / 2;
                        startLocation += offset;
                        endLocation -= offset;
                    }
                    l_1 = xAxis.getDataItemPositionX(dataItem, xOpenField, startLocation, vcx);
                    r_1 = xAxis.getDataItemPositionX(dataItem, xField, endLocation, vcx);
                    startLocation = this._aLocationY0 + openLocationY - 0.5;
                    endLocation = this._aLocationY1 + locationY - 0.5;
                    if (height instanceof Percent) {
                        var offset = (endLocation - startLocation) * (1 - height.value) / 2;
                        startLocation += offset;
                        endLocation -= offset;
                    }
                    t_1 = yAxis.getDataItemPositionY(dataItem, yOpenField, startLocation, vcy);
                    b_1 = yAxis.getDataItemPositionY(dataItem, yField, endLocation, vcy);
                    dataItem.setRaw("point", { x: l_1 + (r_1 - l_1) / 2, y: t_1 + (b_1 - t_1) / 2 });
                }
                else if (xAxis === baseAxis) {
                    var startLocation = this._aLocationX0 + openLocationX - 0.5;
                    var endLocation = this._aLocationX1 + locationX - 0.5;
                    if (width instanceof Percent) {
                        var offset = (endLocation - startLocation) * (1 - width.value) / 2;
                        startLocation += offset;
                        endLocation -= offset;
                    }
                    l_1 = xAxis.getDataItemPositionX(dataItem, xOpenField, startLocation, vcx);
                    r_1 = xAxis.getDataItemPositionX(dataItem, xField, endLocation, vcx);
                    t_1 = yAxis.getDataItemPositionY(dataItem, yField, locationY, vcy);
                    if (this._yOpenField !== this._yField) {
                        b_1 = yAxis.getDataItemPositionY(dataItem, yOpenField, openLocationY, vcy);
                    }
                    else {
                        if (stacked) {
                            var stackToItemY = dataItem.get("stackToItemY");
                            if (stackToItemY) {
                                b_1 = yAxis.getDataItemPositionY(stackToItemY, yField, openLocationY, stackToItemY.component.get("vcy"));
                            }
                            else {
                                b_1 = yAxis.basePosition();
                            }
                        }
                        else {
                            b_1 = yAxis.basePosition();
                        }
                    }
                    dataItem.setRaw("point", { x: l_1 + (r_1 - l_1) / 2, y: t_1 });
                    fitH_1 = true;
                }
                else if (yAxis === baseAxis) {
                    var startLocation = this._aLocationY0 + openLocationY - 0.5;
                    var endLocation = this._aLocationY1 + locationY - 0.5;
                    if (height instanceof Percent) {
                        var offset = (endLocation - startLocation) * (1 - height.value) / 2;
                        startLocation += offset;
                        endLocation -= offset;
                    }
                    t_1 = yAxis.getDataItemPositionY(dataItem, yOpenField, startLocation, vcy);
                    b_1 = yAxis.getDataItemPositionY(dataItem, yField, endLocation, vcy);
                    r_1 = xAxis.getDataItemPositionX(dataItem, xField, locationX, vcx);
                    if (this._xOpenField !== this._xField) {
                        l_1 = xAxis.getDataItemPositionX(dataItem, xOpenField, openLocationX, vcx);
                    }
                    else {
                        if (stacked) {
                            var stackToItemX = dataItem.get("stackToItemX");
                            if (stackToItemX) {
                                l_1 = xAxis.getDataItemPositionX(stackToItemX, xField, openLocationX, stackToItemX.component.get("vcx"));
                            }
                            else {
                                l_1 = xAxis.basePosition();
                            }
                        }
                        else {
                            l_1 = xAxis.basePosition();
                        }
                    }
                    fitW_1 = true;
                    dataItem.setRaw("point", { x: r_1, y: t_1 + (b_1 - t_1) / 2 });
                }
                this._updateSeriesGraphics(dataItem, graphics, l_1, r_1, t_1, b_1, fitW_1, fitH_1);
                if ((l_1 < xStart && r_1 < xStart) || (l_1 > xEnd && r_1 > xEnd) || (t_1 < yStart && b_1 < yStart) || (t_1 > yEnd && b_1 > yEnd)) {
                    this._toggleColumn(dataItem, false);
                }
                else {
                    this._toggleColumn(dataItem, true);
                }
                var rangeGraphics = dataItem.get("rangeGraphics");
                if (rangeGraphics) {
                    $array.each(rangeGraphics, function (graphics) {
                        _this._updateSeriesGraphics(dataItem, graphics, l_1, r_1, t_1, b_1, fitW_1, fitH_1);
                    });
                }
                this._applyGraphicsStates(dataItem, previousDataItem);
            }
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_updateSeriesGraphics", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, graphics, l, r, t, b, fitW, fitH) {
            var width = graphics.get("width");
            var height = graphics.get("height");
            var maxWidth = graphics.get("maxWidth");
            var maxHeight = graphics.get("maxHeight");
            var ptl = this.getPoint(l, t);
            var pbr = this.getPoint(r, b);
            var tooltipPoint = dataItem.get("point");
            if (tooltipPoint) {
                var point = this.getPoint(tooltipPoint.x, tooltipPoint.y);
                tooltipPoint.x = point.x + this._x;
                tooltipPoint.y = point.y + this._y;
            }
            l = ptl.x;
            r = pbr.x;
            t = ptl.y;
            b = pbr.y;
            if ($type.isNumber(width)) {
                var offset = ((r - l) - width) / 2;
                l += offset;
                r -= offset;
            }
            if ($type.isNumber(maxWidth) && maxWidth < Math.abs(r - l)) {
                var offset = ((r - l) - maxWidth) / 2;
                l += offset;
                r -= offset;
            }
            if ($type.isNumber(height)) {
                var offset = ((b - t) - height) / 2;
                t += offset;
                b -= offset;
            }
            if ($type.isNumber(maxHeight) && maxHeight < Math.abs(b - t)) {
                var offset = ((b - t) - maxHeight) / 2;
                t += offset;
                b -= offset;
            }
            if (this.get("adjustBulletPosition")) {
                if (fitW) {
                    r = Math.min(Math.max(0, r), this._pw);
                    l = Math.min(Math.max(0, l), this._pw);
                }
                if (fitH) {
                    t = Math.min(Math.max(0, t), this._ph);
                    b = Math.min(Math.max(0, b), this._ph);
                }
            }
            dataItem.setRaw("left", l);
            dataItem.setRaw("right", r);
            dataItem.setRaw("top", t);
            dataItem.setRaw("bottom", b);
            graphics.setPrivate("width", r - l);
            graphics.setPrivate("height", b - t);
            graphics.set("x", l);
            graphics.set("y", b - (b - t));
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_handleDataSetChange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._handleDataSetChange.call(this);
            $array.each(this._dataItems, function (dataItem) {
                _this._toggleColumn(dataItem, false);
            });
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_applyGraphicsStates", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, previousDataItem) {
            var graphics = dataItem.get("graphics");
            var dropFromOpen = graphics.states.lookup("dropFromOpen");
            var riseFromOpen = graphics.states.lookup("riseFromOpen");
            var dropFromPrevious = graphics.states.lookup("dropFromPrevious");
            var riseFromPrevious = graphics.states.lookup("riseFromPrevious");
            if (dropFromOpen || dropFromPrevious || riseFromOpen || riseFromPrevious) {
                var xAxis = this.get("xAxis");
                var yAxis = this.get("yAxis");
                var baseAxis = this.get("baseAxis");
                var open_1;
                var close_1;
                var previousClose = void 0;
                if (baseAxis === xAxis && yAxis.isType("ValueAxis")) {
                    open_1 = dataItem.get(this._yOpenField);
                    close_1 = dataItem.get(this._yField);
                    previousClose = previousDataItem.get(this._yField);
                }
                else if (baseAxis === yAxis && xAxis.isType("ValueAxis")) {
                    open_1 = dataItem.get(this._xOpenField);
                    close_1 = dataItem.get(this._xField);
                    previousClose = previousDataItem.get(this._xField);
                }
                if ($type.isNumber(open_1) && $type.isNumber(close_1)) {
                    if (close_1 < open_1) {
                        if (dropFromOpen) {
                            dropFromOpen.apply();
                        }
                    }
                    else {
                        if (riseFromOpen) {
                            riseFromOpen.apply();
                        }
                    }
                    if ($type.isNumber(previousClose)) {
                        if (close_1 < previousClose) {
                            if (dropFromPrevious) {
                                dropFromPrevious.apply();
                            }
                        }
                        else {
                            if (riseFromPrevious) {
                                riseFromPrevious.apply();
                            }
                        }
                    }
                }
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(BaseColumnSeries.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.disposeDataItem.call(this, dataItem);
            var graphics = dataItem.get("graphics");
            if (graphics) {
                this.columns.removeValue(graphics);
                graphics.dispose();
            }
            var rangeGraphics = dataItem.get("rangeGraphics");
            if (rangeGraphics) {
                $array.each(rangeGraphics, function (graphics) {
                    var list = graphics.getPrivate("list");
                    if (list) {
                        list.removeValue(graphics);
                    }
                    graphics.dispose();
                });
            }
        }
    });
    /**
     * Hides series's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(BaseColumnSeries.prototype, "hideDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, graphics, rangeGraphics;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.hideDataItem.call(this, dataItem, duration)];
                            graphics = dataItem.get("graphics");
                            if (graphics) {
                                promises.push(graphics.hide(duration));
                            }
                            rangeGraphics = dataItem.get("rangeGraphics");
                            if (rangeGraphics) {
                                $array.each(rangeGraphics, function (graphics) {
                                    promises.push(graphics.hide(duration));
                                });
                            }
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_toggleColumn", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, visible) {
            var graphics = dataItem.get("graphics");
            if (graphics) {
                graphics.setPrivate("visible", visible);
            }
            var rangeGraphics = dataItem.get("rangeGraphics");
            if (rangeGraphics) {
                $array.each(rangeGraphics, function (graphics) {
                    graphics.setPrivate("visible", visible);
                });
            }
            var bullets = dataItem.bullets;
            if (bullets) {
                $array.each(bullets, function (bullet) {
                    bullet.setPrivate("hidden", !visible);
                });
            }
        }
    });
    /**
     * Shows series's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(BaseColumnSeries.prototype, "showDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, graphics, rangeGraphics;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.showDataItem.call(this, dataItem, duration)];
                            graphics = dataItem.get("graphics");
                            if (graphics) {
                                promises.push(graphics.show(duration));
                            }
                            rangeGraphics = dataItem.get("rangeGraphics");
                            if (rangeGraphics) {
                                $array.each(rangeGraphics, function (graphics) {
                                    promises.push(graphics.show(duration));
                                });
                            }
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(BaseColumnSeries.prototype, "updateLegendMarker", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            var legendDataItem = this.get("legendDataItem");
            if (legendDataItem) {
                var graphics_1 = this.columns.template;
                if (dataItem) {
                    var column = dataItem.get("graphics");
                    if (column) {
                        graphics_1 = column;
                    }
                }
                var markerRectangle_1 = legendDataItem.get("markerRectangle");
                if (markerRectangle_1) {
                    if (!legendDataItem.get("itemContainer").get("disabled")) {
                        $array.each(visualSettings, function (setting) {
                            markerRectangle_1.set(setting, graphics_1.get(setting, _this.get(setting)));
                        });
                    }
                }
            }
        }
    });
    Object.defineProperty(BaseColumnSeries.prototype, "_getTooltipTarget", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            if (this.get("seriesTooltipTarget") == "bullet") {
                return _super.prototype._getTooltipTarget.call(this, dataItem);
            }
            var column = dataItem.get("graphics");
            if (column) {
                return column;
            }
            return this;
        }
    });
    Object.defineProperty(BaseColumnSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "BaseColumnSeries"
    });
    Object.defineProperty(BaseColumnSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: XYSeries.classNames.concat([BaseColumnSeries.className])
    });
    return BaseColumnSeries;
}(XYSeries));
export { BaseColumnSeries };
//# sourceMappingURL=BaseColumnSeries.js.map