import { __extends } from "tslib";
import { BaseColumnSeries } from "./BaseColumnSeries";
import { Template } from "../../../core/util/Template";
import { ListTemplate } from "../../../core/util/List";
import { RoundedRectangle } from "../../../core/render/RoundedRectangle";
import * as $utils from "../../../core/util/Utils";
var ColumnSeries = /** @class */ (function (_super) {
    __extends(ColumnSeries, _super);
    function ColumnSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A [[TemplateList]] of all columns in series.
         *
         * `columns.template` can be used to set default settings for all columns,
         * or to change on existing ones.
         */
        Object.defineProperty(_this, "columns", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return RoundedRectangle._new(_this._root, {
                position: "absolute",
                themeTags: $utils.mergeTags(_this.columns.template.get("themeTags", []), ["series", "column"])
            }, [_this.columns.template]); })
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(ColumnSeries.prototype, "makeColumn", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, listTemplate) {
            var column = this.mainContainer.children.push(listTemplate.make());
            column._setDataItem(dataItem);
            listTemplate.push(column);
            return column;
        }
    });
    Object.defineProperty(ColumnSeries.prototype, "_processAxisRange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (axisRange) {
            var _this = this;
            _super.prototype._processAxisRange.call(this, axisRange);
            axisRange.columns = new ListTemplate(Template.new({}), function () { return RoundedRectangle._new(_this._root, {
                position: "absolute",
                themeTags: $utils.mergeTags(axisRange.columns.template.get("themeTags", []), ["series", "column"]),
            }, [_this.columns.template, axisRange.columns.template]); });
        }
    });
    Object.defineProperty(ColumnSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ColumnSeries"
    });
    Object.defineProperty(ColumnSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: BaseColumnSeries.classNames.concat([ColumnSeries.className])
    });
    return ColumnSeries;
}(BaseColumnSeries));
export { ColumnSeries };
//# sourceMappingURL=ColumnSeries.js.map