import { __extends } from "tslib";
import { LineSeries } from "./LineSeries";
import { curveMonotoneYTension } from "../../../core/render/MonotoneYTension";
/**
 * Smoothed line series suitable for vertical plots.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/series/smoothed-series/} for more info
 */
var SmoothedYLineSeries = /** @class */ (function (_super) {
    __extends(SmoothedYLineSeries, _super);
    function SmoothedYLineSeries() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(SmoothedYLineSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._setDefault("curveFactory", curveMonotoneYTension(this.get("tension", 0.5)));
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(SmoothedYLineSeries.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this.isDirty("tension")) {
                this.set("curveFactory", curveMonotoneYTension(this.get("tension", 0.5)));
                this._valuesDirty = true;
            }
            _super.prototype._updateChildren.call(this);
        }
    });
    Object.defineProperty(SmoothedYLineSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "SmoothedYLineSeries"
    });
    Object.defineProperty(SmoothedYLineSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: LineSeries.classNames.concat([SmoothedYLineSeries.className])
    });
    return SmoothedYLineSeries;
}(LineSeries));
export { SmoothedYLineSeries };
//# sourceMappingURL=SmoothedYLineSeries.js.map