import { __awaiter, __extends, __generator } from "tslib";
import { DataItem } from "../../../core/render/Component";
import { Series } from "../../../core/render/Series";
import * as $array from "../../../core/util/Array";
import * as $utils from "../../../core/util/Utils";
import { List } from "../../../core/util/List";
import * as $type from "../../../core/util/Type";
import * as $object from "../../../core/util/Object";
import { Container } from "../../../core/render/Container";
import { Graphics } from "../../../core/render/Graphics";
/**
 * @ignore
 */
function min(left, right) {
    if (left == null) {
        return right;
    }
    else if (right == null) {
        return left;
    }
    else if (right < left) {
        return right;
    }
    else {
        return left;
    }
}
/**
 * @ignore
 */
function max(left, right) {
    if (left == null) {
        return right;
    }
    else if (right == null) {
        return left;
    }
    else if (right > left) {
        return right;
    }
    else {
        return left;
    }
}
/**
 * A base class for all XY chart series.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/series/} for more info
 */
var XYSeries = /** @class */ (function (_super) {
    __extends(XYSeries, _super);
    function XYSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_xField", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_yField", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_xOpenField", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_yOpenField", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_xLowField", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_xHighField", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_yLowField", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_yHighField", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_axesDirty", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_stackDirty", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_selectionProcessed", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_dataSets", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(_this, "_mainContainerMask", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_x", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_y", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        /**
         * A [[Container]] that us used to put series' elements in.
         *
         * @default Container.new()
         */
        Object.defineProperty(_this, "mainContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(Container.new(_this._root, {}))
        });
        /**
         * A list of axis ranges that affect the series.
         *
         * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/axis-ranges/} for more info
         */
        Object.defineProperty(_this, "axisRanges", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new List()
        });
        Object.defineProperty(_this, "_skipped", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_couldStackTo", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(_this, "_reallyStackedTo", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(_this, "_stackedSeries", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: {}
        });
        Object.defineProperty(_this, "_aLocationX0", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_aLocationX1", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 1
        });
        Object.defineProperty(_this, "_aLocationY0", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_aLocationY1", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 1
        });
        Object.defineProperty(_this, "_showBullets", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: true
        });
        Object.defineProperty(_this, "valueXFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: [
                "valueX",
                "openValueX",
                "lowValueX",
                "highValueX"
            ]
        });
        Object.defineProperty(_this, "valueYFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: [
                "valueY",
                "openValueY",
                "lowValueY",
                "highValueY"
            ]
        });
        Object.defineProperty(_this, "_valueXFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_valueYFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        // used for full min/max
        Object.defineProperty(_this, "_valueXShowFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_valueYShowFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        // used for selection (uses working)
        Object.defineProperty(_this, "__valueXShowFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "__valueYShowFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_emptyDataItem", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new DataItem(_this, undefined, {})
        });
        Object.defineProperty(_this, "_dataSetId", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_tooltipFieldX", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_tooltipFieldY", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(XYSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            this.fields.push("categoryX", "categoryY", "openCategoryX", "openCategoryY");
            this.valueFields.push("valueX", "valueY", "openValueX", "openValueY", "lowValueX", "lowValueY", "highValueX", "highValueY");
            this._setRawDefault("vcx", 1);
            this._setRawDefault("vcy", 1);
            // this can't go to themes, as data might be parsed before theme
            this._setRawDefault("valueXShow", "valueXWorking");
            this._setRawDefault("valueYShow", "valueYWorking");
            this._setRawDefault("openValueXShow", "openValueXWorking");
            this._setRawDefault("openValueYShow", "openValueYWorking");
            this._setRawDefault("lowValueXShow", "lowValueXWorking");
            this._setRawDefault("lowValueYShow", "lowValueYWorking");
            this._setRawDefault("highValueXShow", "highValueXWorking");
            this._setRawDefault("highValueYShow", "highValueYWorking");
            this._setRawDefault("lowValueXGrouped", "low");
            this._setRawDefault("lowValueYGrouped", "low");
            this._setRawDefault("highValueXGrouped", "high");
            this._setRawDefault("highValueYGrouped", "high");
            _super.prototype._afterNew.call(this);
            this._settings.xAxis.series.push(this);
            this._settings.yAxis.series.push(this);
            this.set("maskContent", true);
            this._disposers.push(this.axisRanges.events.onAll(function (change) {
                if (change.type === "clear") {
                    $array.each(change.oldValues, function (axisRange) {
                        _this._removeAxisRange(axisRange);
                    });
                }
                else if (change.type === "push") {
                    _this._processAxisRange(change.newValue);
                }
                else if (change.type === "setIndex") {
                    _this._processAxisRange(change.newValue);
                }
                else if (change.type === "insertIndex") {
                    _this._processAxisRange(change.newValue);
                }
                else if (change.type === "removeIndex") {
                    _this._removeAxisRange(change.oldValue);
                }
                else if (change.type === "moveIndex") {
                    _this._processAxisRange(change.value);
                }
                else {
                    throw new Error("Unknown IStreamEvent type");
                }
            }));
            if (!this.get("baseAxis")) {
                var xAxis = this.get("xAxis");
                var yAxis = this.get("yAxis");
                if (yAxis.isType("CategoryAxis") || yAxis.isType("DateAxis")) {
                    this.set("baseAxis", yAxis);
                }
                else {
                    this.set("baseAxis", xAxis);
                }
            }
            this.states.create("hidden", { opacity: 1, visible: false });
            this._makeFieldNames();
        }
    });
    Object.defineProperty(XYSeries.prototype, "_processAxisRange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (axisRange) {
            var container = Container.new(this._root, {});
            axisRange.container = container;
            this.children.push(container);
            axisRange.series = this;
            var axisDataItem = axisRange.axisDataItem;
            axisDataItem.setRaw("isRange", true);
            var axis = axisDataItem.component;
            if (axis) {
                axis._processAxisRange(axisDataItem, ["range", "series"]);
                var bullet = axisDataItem.get("bullet");
                if (bullet) {
                    var sprite = bullet.get("sprite");
                    if (sprite) {
                        sprite.setPrivate("visible", false);
                    }
                }
                var axisFill = axisDataItem.get("axisFill");
                if (axisFill) {
                    container.set("mask", axisFill);
                }
                axis._seriesAxisRanges.push(axisDataItem);
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_removeAxisRange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (axisRange) {
            var axisDataItem = axisRange.axisDataItem;
            var axis = axisDataItem.component;
            axis.disposeDataItem(axisDataItem);
            $array.remove(axis._seriesAxisRanges, axisDataItem);
            var container = axisRange.container;
            if (container) {
                container.dispose();
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_updateFields", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._updateFields.call(this);
            this._valueXFields = [];
            this._valueYFields = [];
            this._valueXShowFields = [];
            this._valueYShowFields = [];
            this.__valueXShowFields = [];
            this.__valueYShowFields = [];
            if (this.valueXFields) {
                $array.each(this.valueXFields, function (key) {
                    var field = _this.get((key + "Field"));
                    if (field) {
                        _this._valueXFields.push(key);
                        var field_1 = _this.get((key + "Show"));
                        _this.__valueXShowFields.push(field_1);
                        if (field_1.indexOf("Working") != -1) {
                            _this._valueXShowFields.push(field_1.split("Working")[0]);
                        }
                        else {
                            _this._valueYShowFields.push(field_1);
                        }
                    }
                });
            }
            if (this.valueYFields) {
                $array.each(this.valueYFields, function (key) {
                    var field = _this.get((key + "Field"));
                    if (field) {
                        _this._valueYFields.push(key);
                        var field_2 = _this.get((key + "Show"));
                        _this.__valueYShowFields.push(field_2);
                        if (field_2.indexOf("Working") != -1) {
                            _this._valueYShowFields.push(field_2.split("Working")[0]);
                        }
                        else {
                            _this._valueYShowFields.push(field_2);
                        }
                    }
                });
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._dispose.call(this);
            var chart = this.chart;
            if (chart) {
                chart.series.removeValue(this);
            }
            $array.removeFirst(this.get("xAxis").series, this);
            $array.removeFirst(this.get("yAxis").series, this);
        }
    });
    // TODO use  SelectKeys<this["_privateSettings"], number | undefined>
    Object.defineProperty(XYSeries.prototype, "_min", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, value) {
            var newValue = min(this.getPrivate(key), value);
            this.setPrivate(key, newValue);
        }
    });
    // TODO use  SelectKeys<this["_privateSettings"], number | undefined>
    Object.defineProperty(XYSeries.prototype, "_max", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (key, value) {
            var newValue = max(this.getPrivate(key), value);
            this.setPrivate(key, newValue);
        }
    });
    Object.defineProperty(XYSeries.prototype, "_shouldMakeBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            if (!this.get("xAxis").inited || !this.get("yAxis").inited) {
                return false;
            }
            if (dataItem.get(this._xField) != null && dataItem.get(this._yField) != null) {
                return true;
            }
            return false;
        }
    });
    Object.defineProperty(XYSeries.prototype, "_makeFieldNames", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var xAxis = this.get("xAxis");
            var yAxis = this.get("yAxis");
            var xName = xAxis.getPrivate("name");
            var xCapName = $utils.capitalizeFirst(xName);
            var yName = yAxis.getPrivate("name");
            var yCapName = $utils.capitalizeFirst(yName);
            var xLetter = xAxis.get("renderer").getPrivate("letter");
            var yLetter = yAxis.get("renderer").getPrivate("letter");
            var open = "open";
            var low = "low";
            var high = "high";
            var show = "Show";
            if (xAxis.className === "ValueAxis") {
                this._xField = this.get((xName + xLetter + show));
                this._xOpenField = this.get((open + xCapName + xLetter + show));
                this._xLowField = this.get((low + xCapName + xLetter + show));
                this._xHighField = this.get((high + xCapName + xLetter + show));
            }
            else {
                this._xField = (xName + xLetter);
                this._xOpenField = (open + xCapName + xLetter);
                this._xLowField = (low + xCapName + xLetter);
                this._xHighField = (high + xCapName + xLetter);
            }
            if (yAxis.className === "ValueAxis") {
                this._yField = this.get((yName + yLetter + show));
                this._yOpenField = this.get((open + yCapName + yLetter + show));
                this._yLowField = this.get((low + yCapName + yLetter + show));
                this._yHighField = this.get((high + yCapName + yLetter + show));
            }
            else {
                this._yField = (yName + yLetter);
                this._yOpenField = (open + yCapName + yLetter);
                this._yLowField = (low + yCapName + yLetter);
                this._yHighField = (high + yCapName + yLetter);
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_fixVC", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var xAxis = this.get("xAxis");
            var yAxis = this.get("yAxis");
            var baseAxis = this.get("baseAxis");
            var hiddenState = this.states.lookup("hidden");
            var sequencedInterpolation = this.get("sequencedInterpolation");
            if (hiddenState) {
                var value = 0;
                if (sequencedInterpolation) {
                    value = 0.999999999999; // makes animate, good for stacked
                }
                if (xAxis === baseAxis) {
                    hiddenState.set("vcy", value);
                }
                else if (yAxis === baseAxis) {
                    hiddenState.set("vcx", value);
                }
                else {
                    hiddenState.set("vcy", value);
                    hiddenState.set("vcx", value);
                }
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_handleMaskBullets", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this.isDirty("maskBullets")) {
                this.bulletsContainer.set("maskContent", this.get("maskBullets"));
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._prepareChildren.call(this);
            this.set("width", this.get("xAxis").width());
            this.set("height", this.get("yAxis").height());
            this._handleMaskBullets();
            var xAxis = this.get("xAxis");
            var yAxis = this.get("yAxis");
            var baseAxis = this.get("baseAxis");
            var tooltipPositionX = this.get("tooltipPositionX");
            var tooltipFieldX;
            switch (tooltipPositionX) {
                case "open":
                    tooltipFieldX = this._xOpenField;
                    break;
                case "low":
                    tooltipFieldX = this._xLowField;
                    break;
                case "high":
                    tooltipFieldX = this._xHighField;
                    break;
                default:
                    tooltipFieldX = this._xField;
            }
            this._tooltipFieldX = tooltipFieldX;
            var tooltipPositionY = this.get("tooltipPositionY");
            var tooltipFieldY;
            switch (tooltipPositionY) {
                case "open":
                    tooltipFieldY = this._yOpenField;
                    break;
                case "low":
                    tooltipFieldY = this._yLowField;
                    break;
                case "high":
                    tooltipFieldY = this._yHighField;
                    break;
                default:
                    tooltipFieldY = this._yField;
            }
            this._tooltipFieldY = tooltipFieldY;
            if (this.isDirty("baseAxis")) {
                this._fixVC();
            }
            if (xAxis === baseAxis) {
                this.set("y", yAxis.y() - $utils.relativeToValue(yAxis.get("centerY", 0), yAxis.height()) - yAxis.parent.get("paddingTop", 0));
                this.bulletsContainer.set("y", this.y());
            }
            else if (yAxis === baseAxis) {
                this.set("x", xAxis.x() - $utils.relativeToValue(xAxis.get("centerX", 0), xAxis.width()) - xAxis.parent.get("paddingLeft", 0));
                this.bulletsContainer.set("x", this.x());
            }
            var stacked = this.get("stacked");
            if (this.isDirty("stacked")) {
                if (stacked) {
                    if (this._valuesDirty && !this._dataProcessed) {
                    }
                    else {
                        this._stack();
                    }
                }
                else {
                    this._unstack();
                }
            }
            if (this._valuesDirty && !this._dataProcessed) {
                this._dataProcessed = true;
                if (stacked) {
                    this._stack();
                }
                $array.each(this.dataItems, function (dataItem) {
                    $array.each(_this._valueXShowFields, function (key) {
                        var value = dataItem.get(key);
                        if (value != null) {
                            if (stacked) {
                                value += _this.getStackedXValue(dataItem, key);
                            }
                            _this._min("minX", value);
                            _this._max("maxX", value);
                        }
                    });
                    $array.each(_this._valueYShowFields, function (key) {
                        var value = dataItem.get(key);
                        if (value != null) {
                            if (stacked) {
                                value += _this.getStackedYValue(dataItem, key);
                            }
                            _this._min("minY", value);
                            _this._max("maxY", value);
                        }
                    });
                    xAxis.processSeriesDataItem(dataItem, _this._valueXFields);
                    yAxis.processSeriesDataItem(dataItem, _this._valueYFields);
                });
                xAxis._seriesValuesDirty = true;
                yAxis._seriesValuesDirty = true;
                if (!this.get("ignoreMinMax")) {
                    if (this.isPrivateDirty("minX") || this.isPrivateDirty("maxX")) {
                        xAxis.markDirtyExtremes();
                    }
                    if (this.isPrivateDirty("minY") || this.isPrivateDirty("maxY")) {
                        yAxis.markDirtyExtremes();
                    }
                }
                this._markStakedDirtyStack();
                //this.updateLegendMarker(undefined); // causes legend marker to change color instantly when on
                this.updateLegendValue(undefined);
            }
            if (this.isDirty("vcx") || this.isDirty("vcy")) {
                this._markStakedDirtyStack();
            }
            if (!this._dataGrouped) {
                xAxis._groupSeriesData(this);
                yAxis._groupSeriesData(this);
                this._dataGrouped = true;
            }
            if ((this._valuesDirty || this.isPrivateDirty("startIndex") || this.isPrivateDirty("endIndex") || this.isDirty("vcx") || this.isDirty("vcy") || this._stackDirty)) {
                var startIndex = this.startIndex();
                var endIndex = this.endIndex();
                var minBulletDistance = this.get("minBulletDistance", 0);
                if (minBulletDistance > 0 && baseAxis) {
                    if (baseAxis.get("renderer").axisLength() / (endIndex - startIndex) > minBulletDistance) {
                        this._showBullets = true;
                    }
                    else {
                        this._showBullets = false;
                    }
                }
                if ((this._psi != startIndex || this._pei != endIndex || this.isDirty("vcx") || this.isDirty("vcy") || this._stackDirty || this._valuesDirty) && !this._selectionProcessed) {
                    this._selectionProcessed = true;
                    var vcx = this.get("vcx", 1);
                    var vcy = this.get("vcy", 1);
                    var stacked_1 = this.get("stacked", false);
                    if (baseAxis === xAxis) {
                        yAxis._calculateTotals();
                        this.setPrivateRaw("selectionMinY", undefined);
                        this.setPrivateRaw("selectionMaxY", undefined);
                        for (var i = startIndex; i < endIndex; i++) {
                            this.processYSelectionDataItem(this.dataItems[i], vcy, stacked_1);
                        }
                    }
                    else if (baseAxis === yAxis) {
                        xAxis._calculateTotals();
                        this.setPrivateRaw("selectionMinX", undefined);
                        this.setPrivateRaw("selectionMaxX", undefined);
                        for (var i = startIndex; i < endIndex; i++) {
                            this.processXSelectionDataItem(this.dataItems[i], vcx, stacked_1);
                        }
                    }
                    if (baseAxis === xAxis) {
                        if (this.get("valueYShow") !== "valueYWorking") {
                            this.setPrivateRaw("minY", this.getPrivate("selectionMinY"));
                            this.setPrivateRaw("maxY", this.getPrivate("selectionMaxY"));
                            yAxis.markDirtyExtremes();
                        }
                    }
                    else if (baseAxis === yAxis) {
                        if (this.get("valueXShow") !== "valueXWorking") {
                            this.setPrivateRaw("minX", this.getPrivate("selectionMinX"));
                            this.setPrivateRaw("maxX", this.getPrivate("selectionMaxX"));
                            xAxis.markDirtyExtremes();
                        }
                    }
                    if (this.isPrivateDirty("selectionMinX") || this.isPrivateDirty("selectionMaxX")) {
                        xAxis.markDirtySelectionExtremes();
                    }
                    if (this.isPrivateDirty("selectionMinY") || this.isPrivateDirty("selectionMaxY")) {
                        yAxis.markDirtySelectionExtremes();
                    }
                    // this.updateLegendValue(undefined); flickers while panning
                }
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_makeRangeMask", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            if (this.axisRanges.length > 0) {
                var mainContainerMask_1 = this._mainContainerMask;
                if (mainContainerMask_1 == null) {
                    mainContainerMask_1 = this.children.push(Graphics.new(this._root, {}));
                    this._mainContainerMask = mainContainerMask_1;
                    mainContainerMask_1.set("draw", function (display, target) {
                        var parent = _this.parent;
                        if (parent) {
                            var w = _this._root.container.width();
                            var h = _this._root.container.height();
                            display.moveTo(-w, -h);
                            display.lineTo(-w, h * 2);
                            display.lineTo(w * 2, h * 2);
                            display.lineTo(w * 2, -h);
                            display.lineTo(-w, -h);
                            _this.axisRanges.each(function (axisRange) {
                                var fill = axisRange.axisDataItem.get("axisFill");
                                if (parent) {
                                    if (fill) {
                                        var draw = fill.get("draw");
                                        if (draw) {
                                            draw(display, target);
                                        }
                                    }
                                }
                            });
                        }
                        _this.mainContainer._display.mask = mainContainerMask_1._display;
                    });
                }
                mainContainerMask_1.markDirty();
                mainContainerMask_1._markDirtyKey("fill");
            }
            else {
                this.mainContainer._display.mask = null;
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._updateChildren.call(this);
            // save for performance
            this._x = this.x();
            this._y = this.y();
            this._makeRangeMask();
        }
    });
    Object.defineProperty(XYSeries.prototype, "_stack", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var chart = this.chart;
            if (chart) {
                var seriesIndex = chart.series.indexOf(this);
                this._couldStackTo = [];
                if (seriesIndex > 0) {
                    var series = void 0;
                    for (var i = seriesIndex - 1; i >= 0; i--) {
                        series = chart.series.getIndex(i);
                        if (series.get("xAxis") === this.get("xAxis") && series.get("yAxis") === this.get("yAxis") && series.className === this.className) {
                            this._couldStackTo.push(series);
                            if (!series.get("stacked")) {
                                break;
                            }
                        }
                    }
                }
                this._stackDataItems();
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_unstack", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            $object.each(this._reallyStackedTo, function (_key, value) {
                delete (value._stackedSeries[_this.uid]);
            });
            this._reallyStackedTo = {};
            $array.each(this.dataItems, function (dataItem) {
                dataItem.setRaw("stackToItemY", undefined);
                dataItem.setRaw("stackToItemX", undefined);
            });
        }
    });
    Object.defineProperty(XYSeries.prototype, "_stackDataItems", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            // this works only with the same number of data @todo: search by date/category?
            var baseAxis = this.get("baseAxis");
            var xAxis = this.get("xAxis");
            var yAxis = this.get("yAxis");
            var field;
            var stackToItemKey;
            if (baseAxis === xAxis) {
                field = "valueY";
                stackToItemKey = "stackToItemY";
            }
            else if (baseAxis === yAxis) {
                field = "valueX";
                stackToItemKey = "stackToItemX";
            }
            var len = this._couldStackTo.length;
            var index = 0;
            var stackToNegative = this.get("stackToNegative");
            this._reallyStackedTo = {};
            $array.each(this.dataItems, function (dataItem) {
                for (var s = 0; s < len; s++) {
                    var stackToSeries = _this._couldStackTo[s];
                    var stackToItem = stackToSeries.dataItems[index];
                    var value = dataItem.get(field);
                    if (stackToItem) {
                        var stackValue = stackToItem.get(field);
                        if (stackToNegative) {
                            if ($type.isNumber(value)) {
                                if ($type.isNumber(stackValue)) {
                                    if (value >= 0 && stackValue >= 0) {
                                        dataItem.setRaw(stackToItemKey, stackToItem);
                                        _this._reallyStackedTo[stackToSeries.uid] = stackToSeries;
                                        stackToSeries._stackedSeries[_this.uid] = _this;
                                        break;
                                    }
                                    if (value < 0 && stackValue < 0) {
                                        dataItem.setRaw(stackToItemKey, stackToItem);
                                        _this._reallyStackedTo[stackToSeries.uid] = stackToSeries;
                                        stackToSeries._stackedSeries[_this.uid] = _this;
                                        break;
                                    }
                                }
                            }
                            else {
                                break;
                            }
                        }
                        else {
                            if ($type.isNumber(value) && $type.isNumber(stackValue)) {
                                dataItem.setRaw(stackToItemKey, stackToItem);
                                _this._reallyStackedTo[stackToSeries.uid] = stackToSeries;
                                stackToSeries._stackedSeries[_this.uid] = _this;
                                break;
                            }
                        }
                    }
                }
                index++;
            });
        }
    });
    Object.defineProperty(XYSeries.prototype, "processXSelectionDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, vcx, stacked) {
            var _this = this;
            $array.each(this.__valueXShowFields, function (key) {
                var value = dataItem.get(key);
                if (value != null) {
                    if (stacked) {
                        value += _this.getStackedXValueWorking(dataItem, key);
                    }
                    _this._min("selectionMinX", value);
                    _this._max("selectionMaxX", value * vcx);
                }
            });
        }
    });
    Object.defineProperty(XYSeries.prototype, "processYSelectionDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, vcy, stacked) {
            var _this = this;
            $array.each(this.__valueYShowFields, function (key) {
                var value = dataItem.get(key);
                if (value != null) {
                    if (stacked) {
                        value += _this.getStackedYValueWorking(dataItem, key);
                    }
                    _this._min("selectionMinY", value);
                    _this._max("selectionMaxY", value * vcy);
                }
            });
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "getStackedYValueWorking", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, key) {
            var stackToItem = dataItem.get("stackToItemY");
            if (stackToItem) {
                var stackedToSeries = stackToItem.component;
                return stackToItem.get(key, 0) * stackedToSeries.get("vcy", 1) + this.getStackedYValueWorking(stackToItem, key);
            }
            return 0;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "getStackedXValueWorking", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, key) {
            var stackToItem = dataItem.get("stackToItemX");
            if (stackToItem) {
                var stackedToSeries = stackToItem.component;
                return stackToItem.get(key, 0) * stackedToSeries.get("vcx", 1) + this.getStackedXValueWorking(stackToItem, key);
            }
            return 0;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "getStackedYValue", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, key) {
            var stackToItem = dataItem.get("stackToItemY");
            if (stackToItem) {
                return stackToItem.get(key, 0) + this.getStackedYValue(stackToItem, key);
            }
            return 0;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "getStackedXValue", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, key) {
            var stackToItem = dataItem.get("stackToItemX");
            if (stackToItem) {
                return stackToItem.get(key, 0) + this.getStackedXValue(stackToItem, key);
            }
            return 0;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "createLegendMarker", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_dataItem) {
            this.updateLegendMarker();
        }
    });
    Object.defineProperty(XYSeries.prototype, "_markDirtyAxes", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._axesDirty = true;
            this.markDirty();
        }
    });
    Object.defineProperty(XYSeries.prototype, "_markDataSetDirty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._afterDataChange();
            this._valuesDirty = true;
            this._dataProcessed = false;
            this._aggregatesCalculated = false;
            this.markDirty();
        }
    });
    Object.defineProperty(XYSeries.prototype, "_clearDirty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._clearDirty.call(this);
            this._axesDirty = false;
            this._selectionProcessed = false;
            this._stackDirty = false;
            this._dataProcessed = false;
        }
    });
    Object.defineProperty(XYSeries.prototype, "_positionBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (bullet) {
            var sprite = bullet.get("sprite");
            if (sprite) {
                var dataItem = sprite.dataItem;
                var locationX = bullet.get("locationX", dataItem.get("locationX", 0.5));
                var locationY = bullet.get("locationY", dataItem.get("locationY", 0.5));
                var xAxis = this.get("xAxis");
                var yAxis = this.get("yAxis");
                var positionX = xAxis.getDataItemPositionX(dataItem, this._xField, locationX, this.get("vcx", 1));
                var positionY = yAxis.getDataItemPositionY(dataItem, this._yField, locationY, this.get("vcy", 1));
                var point = this.getPoint(positionX, positionY);
                var left = dataItem.get("left", point.x);
                var right = dataItem.get("right", point.x);
                var top_1 = dataItem.get("top", point.y);
                var bottom = dataItem.get("bottom", point.y);
                if (this._shouldShowBullet(positionX, positionY)) {
                    if (!bullet.getPrivate("hidden")) {
                        sprite.setPrivate("visible", true);
                    }
                    else {
                        sprite.setPrivate("visible", false);
                    }
                    var w = right - left;
                    var h = bottom - top_1;
                    if (sprite.isType("Label")) {
                        sprite.set("maxWidth", Math.abs(w));
                        sprite.set("maxHeight", Math.abs(h));
                    }
                    var x = left + w * locationX;
                    var y = bottom - h * locationY;
                    sprite.set("x", x);
                    sprite.set("y", y);
                }
                else {
                    sprite.setPrivate("visible", false);
                }
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_shouldShowBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_positionX, _positionY) {
            return this._showBullets;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "setDataSet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (id) {
            if (this._dataSets[id]) {
                this._handleDataSetChange();
                this._dataItems = this._dataSets[id];
                this._markDataSetDirty();
                this._dataSetId = id;
                var type = "datasetchanged";
                if (this.events.isEnabled(type)) {
                    this.events.dispatch(type, { type: type, target: this, id: id });
                }
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_handleDataSetChange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this.bullets.length > 0) {
                $array.each(this._dataItems, function (dataItem) {
                    var bullets = dataItem.bullets;
                    if (bullets) {
                        $array.each(bullets, function (bullet) {
                            var sprite = bullet.get("sprite");
                            if (sprite) {
                                sprite.setPrivate("visible", false);
                            }
                        });
                    }
                });
            }
        }
    });
    /**
     * Shows hidden series.
     *
     * @param   duration  Duration of animation in milliseconds
     * @return            Animation promise
     */
    Object.defineProperty(XYSeries.prototype, "show", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises;
                var _this = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            this._fixVC();
                            promises = [];
                            promises.push(_super.prototype.show.call(this, duration).then(function () {
                                _this._isShowing = false;
                                var xAxis = _this.get("xAxis");
                                var yAxis = _this.get("yAxis");
                                var baseAxis = _this.get("baseAxis");
                                if (yAxis !== baseAxis) {
                                    yAxis.markDirtySelectionExtremes();
                                }
                                if (xAxis !== baseAxis) {
                                    xAxis.markDirtySelectionExtremes();
                                }
                            }));
                            promises.push(this.bulletsContainer.show(duration));
                            promises.push(this._sequencedShowHide(true, duration));
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * Hides series.
     *
     * @param   duration  Duration of animation in milliseconds
     * @return            Animation promise
     */
    Object.defineProperty(XYSeries.prototype, "hide", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises;
                var _this = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            this._fixVC();
                            promises = [];
                            promises.push(_super.prototype.hide.call(this, duration).then(function () {
                                _this._isHiding = false;
                            }));
                            promises.push(this.bulletsContainer.hide(duration));
                            promises.push(this._sequencedShowHide(false, duration));
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * Shows series's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(XYSeries.prototype, "showDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, easing;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.showDataItem.call(this, dataItem, duration)];
                            if (!$type.isNumber(duration)) {
                                duration = this.get("stateAnimationDuration", 0);
                            }
                            easing = this.get("stateAnimationEasing");
                            $array.each(this._valueFields, function (key) {
                                promises.push(dataItem.animate({ key: key + "Working", to: dataItem.get(key), duration: duration, easing: easing }).waitForStop());
                            });
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * Hides series's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(XYSeries.prototype, "hideDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, hiddenState, easing, xAxis, yAxis, baseAxis, stacked, min_1, baseValue_1;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.hideDataItem.call(this, dataItem, duration)];
                            hiddenState = this.states.create("hidden", {});
                            if (!$type.isNumber(duration)) {
                                duration = hiddenState.get("stateAnimationDuration", this.get("stateAnimationDuration", 0));
                            }
                            easing = hiddenState.get("stateAnimationEasing", this.get("stateAnimationEasing"));
                            xAxis = this.get("xAxis");
                            yAxis = this.get("yAxis");
                            baseAxis = this.get("baseAxis");
                            stacked = this.get("stacked");
                            if (baseAxis === xAxis || !baseAxis) {
                                $array.each(this._valueYFields, function (key) {
                                    var min = yAxis.getPrivate("min");
                                    var baseValue = yAxis.baseValue();
                                    if ($type.isNumber(min) && min > baseValue) {
                                        baseValue = min;
                                    }
                                    if (stacked) {
                                        baseValue = 0;
                                    }
                                    promises.push(dataItem.animate({ key: key + "Working", to: baseValue, duration: duration, easing: easing }).waitForStop());
                                });
                            }
                            if (baseAxis === yAxis || !baseAxis) {
                                min_1 = xAxis.getPrivate("min");
                                baseValue_1 = xAxis.baseValue();
                                if ($type.isNumber(min_1) && min_1 > baseValue_1) {
                                    baseValue_1 = min_1;
                                }
                                if (stacked) {
                                    baseValue_1 = 0;
                                }
                                $array.each(this._valueXFields, function (key) {
                                    promises.push(dataItem.animate({ key: key + "Working", to: baseValue_1, duration: duration, easing: easing }).waitForStop());
                                });
                            }
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    Object.defineProperty(XYSeries.prototype, "_markDirtyStack", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._stackDirty = true;
            this.markDirty();
            this._markStakedDirtyStack();
        }
    });
    Object.defineProperty(XYSeries.prototype, "_markStakedDirtyStack", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var stackedSeries = this._stackedSeries;
            if (stackedSeries) {
                $object.each(stackedSeries, function (_key, value) {
                    if (!value._stackDirty) {
                        value._markDirtyStack();
                    }
                });
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_afterChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterChanged.call(this);
            if (this._skipped) {
                this._markDirtyAxes();
                this._skipped = false;
            }
        }
    });
    /**
     * Shows a tooltip for specific data item.
     *
     * @param  dataItem  Data item
     */
    Object.defineProperty(XYSeries.prototype, "showDataItemTooltip", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            this.updateLegendMarker(dataItem);
            this.updateLegendValue(dataItem);
            if (this.get("tooltip")) {
                if (!this.isHidden()) {
                    var tooltip = this.get("tooltip");
                    if (tooltip) {
                        tooltip._setDataItem(dataItem);
                        if (dataItem) {
                            var locationX = this.get("locationX", 0);
                            var locationY = this.get("locationY", 1);
                            var itemLocationX = dataItem.get("locationX", locationX);
                            var itemLocationY = dataItem.get("locationY", locationY);
                            var xAxis = this.get("xAxis");
                            var yAxis = this.get("yAxis");
                            var vcx = this.get("vcx", 1);
                            var vcy = this.get("vcy", 1);
                            var xPos = xAxis.getDataItemPositionX(dataItem, this._tooltipFieldX, this._aLocationX0 + (this._aLocationX1 - this._aLocationX0) * itemLocationX, vcx);
                            var yPos = yAxis.getDataItemPositionY(dataItem, this._tooltipFieldY, this._aLocationY0 + (this._aLocationY1 - this._aLocationY0) * itemLocationY, vcy);
                            var point = this.getPoint(xPos, yPos);
                            var show_1 = true;
                            $array.each(this._valueFields, function (field) {
                                if (dataItem.get(field) == null) {
                                    show_1 = false;
                                }
                            });
                            if (show_1) {
                                var chart = this.chart;
                                if (chart && chart.inPlot(point)) {
                                    tooltip.label.text.markDirtyText();
                                    tooltip.set("tooltipTarget", this._getTooltipTarget(dataItem));
                                    tooltip.set("pointTo", this._display.toGlobal({ x: point.x, y: point.y }));
                                }
                                else {
                                    tooltip._setDataItem(undefined);
                                }
                            }
                            else {
                                tooltip._setDataItem(undefined);
                            }
                        }
                    }
                }
                else {
                    this.hideTooltip();
                }
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_getTooltipTarget", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            if (this.get("seriesTooltipTarget") == "bullet") {
                var bullets = dataItem.bullets;
                if (bullets && bullets.length > 0) {
                    var bullet = bullets[0];
                    var sprite = bullet.get("sprite");
                    if (sprite) {
                        return sprite;
                    }
                }
            }
            return this;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "updateLegendValue", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var legendDataItem = this.get("legendDataItem");
            if (legendDataItem) {
                var label = legendDataItem.get("label");
                if (label) {
                    var txt = "";
                    if (dataItem) {
                        label._setDataItem(dataItem);
                        txt = this.get("legendLabelText", label.get("text", this.get("name", "")));
                    }
                    else {
                        label._setDataItem(this._emptyDataItem);
                        txt = this.get("legendRangeLabelText", this.get("legendLabelText", label.get("text", this.get("name", ""))));
                    }
                    label.set("text", txt);
                }
                var valueLabel = legendDataItem.get("valueLabel");
                if (valueLabel) {
                    var txt = "";
                    if (dataItem) {
                        valueLabel._setDataItem(dataItem);
                        txt = this.get("legendValueText", valueLabel.get("text", ""));
                    }
                    else {
                        valueLabel._setDataItem(this._emptyDataItem);
                        txt = this.get("legendRangeValueText", valueLabel.get("text", ""));
                    }
                    valueLabel.set("text", txt);
                }
            }
        }
    });
    Object.defineProperty(XYSeries.prototype, "_getItemReaderLabel", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var text = "X: {" + this._xField;
            if (this.get("xAxis").isType("DateAxis")) {
                text += ".formatDate()";
            }
            text += "}; Y: {" + this._yField;
            if (this.get("yAxis").isType("DateAxis")) {
                text += ".formatDate()";
            }
            text += "}";
            return text;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "getPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (positionX, positionY) {
            var x = this.get("xAxis").get("renderer").positionToCoordinate(positionX);
            var y = this.get("yAxis").get("renderer").positionToCoordinate(positionY);
            return { x: x, y: y };
        }
    });
    Object.defineProperty(XYSeries.prototype, "_shouldInclude", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_position) {
            return true;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(XYSeries.prototype, "handleCursorHide", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.hideTooltip();
            this.updateLegendValue(undefined);
            this.updateLegendMarker(undefined);
        }
    });
    Object.defineProperty(XYSeries.prototype, "_afterDataChange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterDataChange.call(this);
            this.resetExtremes();
        }
    });
    // todo description
    Object.defineProperty(XYSeries.prototype, "resetExtremes", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.setPrivate("selectionMinX", undefined);
            this.setPrivate("selectionMaxX", undefined);
            this.setPrivate("selectionMinY", undefined);
            this.setPrivate("selectionMaxY", undefined);
            this.setPrivate("minX", undefined);
            this.setPrivate("minY", undefined);
            this.setPrivate("maxX", undefined);
            this.setPrivate("maxY", undefined);
        }
    });
    /**
     * Creates and returns an axis range object.
     *
     * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/axis-ranges/} for more info
     * @param   axisDataItem  Axis data item
     * @return                Axis range
     */
    Object.defineProperty(XYSeries.prototype, "createAxisRange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (axisDataItem) {
            return this.axisRanges.push({
                axisDataItem: axisDataItem
            });
        }
    });
    Object.defineProperty(XYSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "XYSeries"
    });
    Object.defineProperty(XYSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Series.classNames.concat([XYSeries.className])
    });
    return XYSeries;
}(Series));
export { XYSeries };
//# sourceMappingURL=XYSeries.js.map