import { __awaiter, __extends, __generator } from "tslib";
import { Settings } from "../util/Entity";
import { Container } from "./Container";
import { ListData } from "../util/Data";
import * as $array from "../util/Array";
import * as $object from "../util/Object";
/**
 * A base element that holds data bit (data item) for any [[Component]].
 */
var DataItem = /** @class */ (function (_super) {
    __extends(DataItem, _super);
    function DataItem(component, dataContext, settings) {
        var _this = _super.call(this, settings) || this;
        /**
         * A data item's owener [[Component]].
         */
        Object.defineProperty(_this, "component", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * A reference to actual item in source data this item is based on.
         */
        Object.defineProperty(_this, "dataContext", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * @todo requires description
         */
        Object.defineProperty(_this, "bullets", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * A set of "open" values.
         */
        Object.defineProperty(_this, "open", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * A set of "close" values.
         */
        Object.defineProperty(_this, "close", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        _this.dataContext = dataContext;
        _this.component = component;
        _this._settings.visible = true;
        _this._checkDirty();
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(DataItem.prototype, "markDirty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.component.markDirtyValues(this);
        }
    });
    Object.defineProperty(DataItem.prototype, "_startAnimation", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.component._root._addAnimation(this);
        }
    });
    Object.defineProperty(DataItem.prototype, "_animationTime", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this.component._root.animationTime;
        }
    });
    Object.defineProperty(DataItem.prototype, "_dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this.component) {
                this.component.disposeDataItem(this);
            }
            _super.prototype._dispose.call(this);
        }
    });
    /**
     * Shows a data item that's currently hidden.
     */
    Object.defineProperty(DataItem.prototype, "show", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (duration) {
            this.setRaw("visible", true);
            if (this.component) {
                this.component.showDataItem(this, duration);
            }
        }
    });
    /**
     * Hides a data item that's currently visible.
     */
    Object.defineProperty(DataItem.prototype, "hide", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (duration) {
            this.setRaw("visible", false);
            if (this.component) {
                this.component.hideDataItem(this, duration);
            }
        }
    });
    Object.defineProperty(DataItem.prototype, "isHidden", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return !this.get("visible");
        }
    });
    return DataItem;
}(Settings));
export { DataItem };
/**
 * A base class for elements that make use of data.
 */
var Component = /** @class */ (function (_super) {
    __extends(Component, _super);
    function Component() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_data", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListData()
        });
        Object.defineProperty(_this, "_dataItems", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(_this, "_mainDataItems", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this._dataItems
        });
        Object.defineProperty(_this, "valueFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        Object.defineProperty(_this, "fields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: ["id"]
        });
        Object.defineProperty(_this, "_valueFields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_valueFieldsF", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_fields", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_fieldsF", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_valuesDirty", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_dataChanged", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_dataGrouped", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        /**
         * Indicates if the component has already been initialized.
         */
        Object.defineProperty(_this, "inited", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        return _this;
    }
    Object.defineProperty(Component.prototype, "data", {
        /**
         * @return  Data
         */
        get: function () {
            return this._data;
        },
        /**
         * Component's data.
         *
         * @see {@link https://www.amcharts.com/docs/v5/concepts/data/} for more info
         */
        set: function (data) {
            data.incrementRef();
            this._data.decrementRef();
            this._data = data;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "_dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._dispose.call(this);
            this._data.decrementRef();
        }
    });
    Object.defineProperty(Component.prototype, "_onDataClear", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
        }
    });
    Object.defineProperty(Component.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._afterNew.call(this);
            this._data.incrementRef();
            this._updateFields();
            this._disposers.push(this.data.events.onAll(function (change) {
                var dataItems = _this._mainDataItems;
                _this.markDirtyValues();
                _this._markDirtyGroup();
                _this._dataChanged = true;
                if (change.type === "clear") {
                    $array.each(dataItems, function (dataItem) {
                        dataItem.dispose();
                    });
                    dataItems.length = 0;
                    _this._onDataClear();
                }
                else if (change.type === "push") {
                    var dataItem = new DataItem(_this, change.newValue, _this._makeDataItem(change.newValue));
                    dataItems.push(dataItem);
                    _this.processDataItem(dataItem);
                }
                else if (change.type === "setIndex") {
                    var dataItem_1 = dataItems[change.index];
                    var properties_1 = _this._makeDataItem(change.newValue);
                    $object.keys(properties_1).forEach(function (key) {
                        dataItem_1.animate({
                            key: key,
                            to: properties_1[key],
                            duration: _this.get("interpolationDuration", 0),
                            easing: _this.get("interpolationEasing"),
                        });
                    });
                    dataItem_1.dataContext = change.newValue;
                }
                else if (change.type === "insertIndex") {
                    var dataItem = new DataItem(_this, change.newValue, _this._makeDataItem(change.newValue));
                    dataItems.splice(change.index, 0, dataItem);
                    _this.processDataItem(dataItem);
                }
                else if (change.type === "removeIndex") {
                    var dataItem = dataItems[change.index];
                    dataItem.dispose();
                    dataItems.splice(change.index, 1);
                }
                else if (change.type === "moveIndex") {
                    var dataItem = dataItems[change.oldIndex];
                    dataItems.splice(change.oldIndex, 1);
                    dataItems.splice(change.newIndex, 0, dataItem);
                }
                else {
                    throw new Error("Unknown IStreamEvent type");
                }
                _this._afterDataChange();
            }));
        }
    });
    Object.defineProperty(Component.prototype, "_updateFields", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            if (this.valueFields) {
                this._valueFields = [];
                this._valueFieldsF = {};
                $array.each(this.valueFields, function (key) {
                    var field = _this.get((key + "Field"));
                    if (field) {
                        _this._valueFields.push(key);
                        _this._valueFieldsF[key] = { fieldKey: key + "Field", workingKey: key + "Working" };
                    }
                });
            }
            if (this.fields) {
                this._fields = [];
                this._fieldsF = {};
                $array.each(this.fields, function (key) {
                    var field = _this.get((key + "Field"));
                    if (field) {
                        _this._fields.push(key);
                        _this._fieldsF[key] = key + "Field";
                    }
                });
            }
        }
    });
    Object.defineProperty(Component.prototype, "dataItems", {
        /**
         * A list of component's data items.
         *
         * @return  Data items
         */
        get: function () {
            return this._dataItems;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "processDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_dataItem) { }
    });
    Object.defineProperty(Component.prototype, "_makeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (data) {
            var _this = this;
            //const output: this["_dataItemSettings"] = {};
            var output = {}; // temporary to solve error
            if (this._valueFields) {
                $array.each(this._valueFields, function (key) {
                    var field = _this.get((_this._valueFieldsF[key].fieldKey));
                    output[key] = data[field];
                    output[_this._valueFieldsF[key].workingKey] = output[key];
                });
            }
            if (this._fields) {
                $array.each(this._fields, function (key) {
                    var field = _this.get((_this._fieldsF[key]));
                    output[key] = data[field];
                });
            }
            return output;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Component.prototype, "makeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (data) {
            var dataItem = new DataItem(this, undefined, data);
            this.processDataItem(dataItem);
            return dataItem;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Component.prototype, "pushDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (data) {
            var dataItem = this.makeDataItem(data);
            this._mainDataItems.push(dataItem);
            return dataItem;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Component.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_dataItem) { }
    });
    /**
     * Shows component's data item.
     *
     * @param   dataItem   Data item
     * @param   _duration  Animation duration in milliseconds
     * @return             Promise
     */
    Object.defineProperty(Component.prototype, "showDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, _duration) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    dataItem.set("visible", true);
                    return [2 /*return*/];
                });
            });
        }
    });
    /**
     * Hides component's data item.
     *
     * @param   dataItem   Data item
     * @param   _duration  Animation duration in milliseconds
     * @return             Promise
     */
    Object.defineProperty(Component.prototype, "hideDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, _duration) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    dataItem.set("visible", false);
                    return [2 /*return*/];
                });
            });
        }
    });
    Object.defineProperty(Component.prototype, "_clearDirty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._clearDirty.call(this);
            this._valuesDirty = false;
        }
    });
    Object.defineProperty(Component.prototype, "_afterDataChange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
        }
    });
    Object.defineProperty(Component.prototype, "_afterChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterChanged.call(this);
            if (this._dataChanged) {
                var type = "datavalidated";
                if (this.events.isEnabled(type)) {
                    this.events.dispatch(type, { type: type, target: this });
                }
                this._dataChanged = false;
            }
            this.inited = true;
        }
    });
    /**
     * Forces a repaint of the element which relies on data.
     *
     * @since 5.0.21
     */
    Object.defineProperty(Component.prototype, "markDirtyValues", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_dataItem) {
            this.markDirty();
            this._valuesDirty = true;
        }
    });
    Object.defineProperty(Component.prototype, "_markDirtyGroup", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._dataGrouped = false;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Component.prototype, "markDirtySize", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._sizeDirty = true;
            this.markDirty();
        }
    });
    Object.defineProperty(Component, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Component"
    });
    Object.defineProperty(Component, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Container.classNames.concat([Component.className])
    });
    return Component;
}(Container));
export { Component };
//# sourceMappingURL=Component.js.map