import { __extends } from "tslib";
import { Graphics } from "./Graphics";
/**
 * Draws a Ellipse.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
var Ellipse = /** @class */ (function (_super) {
    __extends(Ellipse, _super);
    function Ellipse() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Ellipse.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("radiusX") || this.isDirty("radiusY") || this.isDirty("rotation")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Ellipse.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear) {
                this._display.drawEllipse(0, 0, Math.abs(this.get("radiusX")), Math.abs(this.get("radiusY")));
            }
        }
    });
    Object.defineProperty(Ellipse, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Ellipse"
    });
    Object.defineProperty(Ellipse, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([Ellipse.className])
    });
    return Ellipse;
}(Graphics));
export { Ellipse };
//# sourceMappingURL=Ellipse.js.map