import { __extends } from "tslib";
import { Graphics } from "./Graphics";
import * as $draw from "../util/Draw";
/**
 * Draws a line.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
var Line = /** @class */ (function (_super) {
    __extends(Line, _super);
    function Line() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Line.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("points") || this.isDirty("segments") || this._sizeDirty || this.isPrivateDirty("width") || this.isPrivateDirty("height")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Line.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear) {
                var points = this.get("points");
                var segments = this.get("segments");
                if (points && points.length > 0) {
                    var point = points[0];
                    this._display.moveTo(point.x, point.y);
                    $draw.segmentedLine(this._display, [[points]]);
                }
                else if (segments) {
                    $draw.segmentedLine(this._display, segments);
                }
                else if (!this.get("draw")) {
                    var w = this.width();
                    var h = this.height();
                    this._display.moveTo(0, 0);
                    this._display.lineTo(w, h);
                }
            }
        }
    });
    Object.defineProperty(Line, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Line"
    });
    Object.defineProperty(Line, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([Line.className])
    });
    return Line;
}(Graphics));
export { Line };
//# sourceMappingURL=Line.js.map