import { __extends } from "tslib";
// import * as $object from "../util/Object";
import { p50, Percent } from "../util/Percent";
import { Label } from "./Label";
import { RadialText } from "./RadialText";
import * as $math from "../util/Math";
import * as $utils from "../util/Utils";
var RadialLabel = /** @class */ (function (_super) {
    __extends(RadialLabel, _super);
    function RadialLabel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_flipped", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        return _this;
    }
    Object.defineProperty(RadialLabel.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._textKeys.push("textType", "kerning");
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(RadialLabel.prototype, "_makeText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._text = this.children.push(RadialText.new(this._root, {}));
        }
    });
    /**
     * Returns base radius in pixels.
     *
     * @return Base radius
     */
    Object.defineProperty(RadialLabel.prototype, "baseRadius", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var radiusPrivate = this.getPrivate("radius", 0);
            var innerRadiusPrivate = this.getPrivate("innerRadius", 0);
            var baseRadius = this.get("baseRadius", 0);
            return innerRadiusPrivate + $utils.relativeToValue(baseRadius, radiusPrivate - innerRadiusPrivate);
        }
    });
    /**
     * Returns radius adjustment in pixels.
     *
     * @return Radius
     */
    Object.defineProperty(RadialLabel.prototype, "radius", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var inside = this.get("inside", false);
            return this.baseRadius() + this.get("radius", 0) * (inside ? -1 : 1);
        }
    });
    Object.defineProperty(RadialLabel.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._updateChildren.call(this);
            if (this.isDirty("baseRadius") || this.isPrivateDirty("radius") || this.isPrivateDirty("innerRadius") || this.isDirty("labelAngle") || this.isDirty("radius") || this.isDirty("inside") || this.isDirty("orientation") || this.isDirty("textType")) {
                var textType = this.get("textType", "adjusted");
                var inside = this.get("inside", false);
                var orientation_1 = this.get("orientation");
                var labelAngle = $math.normalizeAngle(this.get("labelAngle", 0));
                this._text.set("startAngle", this.get("labelAngle", 0));
                this._text.set("inside", inside);
                var sin = $math.sin(labelAngle);
                var cos = $math.cos(labelAngle);
                var baseRadius = this.baseRadius();
                var radius = this.radius();
                this._display.angle = 0;
                if (textType == "circular") {
                    this.setAll({
                        paddingTop: 0,
                        paddingBottom: 0,
                        paddingLeft: 0,
                        paddingRight: 0
                    });
                    // Circular labels are handled and positioned differently
                    this._text.set("orientation", orientation_1);
                    this._text.set("radius", radius);
                }
                else {
                    if (baseRadius == 0) {
                        labelAngle = 0;
                        radius = 0;
                    }
                    // Positioning of radial/regular labels are teh same
                    var x = radius * cos;
                    var y = radius * sin;
                    if (textType == "radial") {
                        this.setRaw("x", x);
                        this.setRaw("y", y);
                        if ((labelAngle < 90) || (labelAngle > 270) || orientation_1 != "auto") {
                            this._display.angle = labelAngle; // + 90;
                            this._flipped = false;
                        }
                        else {
                            this._display.angle = labelAngle + 180;
                            this._flipped = true;
                        }
                        this._dirty.rotation = false;
                    }
                    else if (textType == "adjusted") {
                        this.setRaw("centerX", p50);
                        this.setRaw("centerY", p50);
                        this.setRaw("x", x);
                        this.setRaw("y", y);
                    }
                    else if (textType == "regular") {
                        this.setRaw("x", x);
                        this.setRaw("y", y);
                    }
                }
                this.markDirtyPosition();
                this.markDirtyBounds();
            }
        }
    });
    Object.defineProperty(RadialLabel.prototype, "_updatePosition", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var textType = this.get("textType", "regular");
            var inside = this.get("inside", false);
            var dx = 0;
            var dy = 0;
            var labelAngle = this.get("labelAngle", 0);
            var bounds = this.localBounds();
            var w = bounds.right - bounds.left;
            var h = bounds.bottom - bounds.top;
            if (textType == "radial") {
                if (this._flipped) {
                    var centerX = this.get("centerX");
                    if (centerX instanceof Percent) {
                        w = w * (1 - centerX.value * 2);
                    }
                    dx = w * $math.cos(labelAngle);
                    dy = w * $math.sin(labelAngle);
                }
            }
            else if (!inside && textType == "adjusted") {
                dx = w / 2 * $math.cos(labelAngle);
                dy = h / 2 * $math.sin(labelAngle);
            }
            this.setRaw("dx", dx);
            this.setRaw("dy", dy);
            _super.prototype._updatePosition.call(this);
        }
    });
    Object.defineProperty(RadialLabel.prototype, "text", {
        /**
         * @ignore
         */
        get: function () {
            return this._text;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RadialLabel, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "RadialLabel"
    });
    Object.defineProperty(RadialLabel, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Label.classNames.concat([RadialLabel.className])
    });
    return RadialLabel;
}(Label));
export { RadialLabel };
//# sourceMappingURL=RadialLabel.js.map