import { __extends } from "tslib";
import { Text } from "./Text";
import * as $math from "../util/Math";
/**
 * @ignore
 */
var RadialText = /** @class */ (function (_super) {
    __extends(RadialText, _super);
    function RadialText() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_display", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this._root._renderer.makeRadialText("", _this.textStyle)
        });
        return _this;
    }
    Object.defineProperty(RadialText.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(RadialText.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            this._display.clear();
            if (this.isDirty("textType")) {
                this._display.textType = this.get("textType");
                this.markDirtyBounds();
            }
            if (this.isDirty("radius")) {
                this._display.radius = this.get("radius");
                this.markDirtyBounds();
            }
            if (this.isDirty("startAngle")) {
                this._display.startAngle = (this.get("startAngle", 0) + 90) * $math.RADIANS;
                this.markDirtyBounds();
            }
            if (this.isDirty("inside")) {
                this._display.inside = this.get("inside");
                this.markDirtyBounds();
            }
            if (this.isDirty("orientation")) {
                this._display.orientation = this.get("orientation");
                this.markDirtyBounds();
            }
            if (this.isDirty("kerning")) {
                this._display.kerning = this.get("kerning");
                this.markDirtyBounds();
            }
        }
    });
    Object.defineProperty(RadialText, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "RadialText"
    });
    Object.defineProperty(RadialText, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Text.classNames.concat([RadialText.className])
    });
    return RadialText;
}(Text));
export { RadialText };
//# sourceMappingURL=RadialText.js.map