import { __extends } from "tslib";
import { Chart } from "./Chart";
import { Container } from "../../core/render/Container";
import { ListAutoDispose } from "../../core/util/List";
import { p100 } from "../../core/util/Percent";
import * as $array from "../../core/util/Array";
/**
 * A base class for all series-based charts.
 */
var SerialChart = /** @class */ (function (_super) {
    __extends(SerialChart, _super);
    function SerialChart() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A [[Container]] where chart will store all series.
         *
         * @default Container.new()
         */
        Object.defineProperty(_this, "seriesContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: Container.new(_this._root, { width: p100, height: p100, isMeasured: false })
        });
        /**
         * A list of chart's series.
         */
        Object.defineProperty(_this, "series", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListAutoDispose()
        });
        return _this;
    }
    Object.defineProperty(SerialChart.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._afterNew.call(this);
            this._disposers.push(this.series);
            var children = this.seriesContainer.children;
            this._disposers.push(this.series.events.onAll(function (change) {
                if (change.type === "clear") {
                    $array.each(change.oldValues, function (series) {
                        _this._removeSeries(series);
                    });
                    var colors = _this.get("colors");
                    if (colors) {
                        colors.reset();
                    }
                }
                else if (change.type === "push") {
                    children.moveValue(change.newValue);
                    _this._processSeries(change.newValue);
                }
                else if (change.type === "setIndex") {
                    children.setIndex(change.index, change.newValue);
                    _this._processSeries(change.newValue);
                }
                else if (change.type === "insertIndex") {
                    children.insertIndex(change.index, change.newValue);
                    _this._processSeries(change.newValue);
                }
                else if (change.type === "removeIndex") {
                    _this._removeSeries(change.oldValue);
                }
                else if (change.type === "moveIndex") {
                    children.moveValue(change.value, change.newIndex);
                    _this._processSeries(change.value);
                }
                else {
                    throw new Error("Unknown IListEvent type");
                }
            }));
        }
    });
    Object.defineProperty(SerialChart.prototype, "_processSeries", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (series) {
            series.chart = this;
            series._placeBulletsContainer(this);
        }
    });
    Object.defineProperty(SerialChart.prototype, "_removeSeries", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (series) {
            if (!series.isDisposed()) {
                this.seriesContainer.children.removeValue(series);
                series._removeBulletsContainer();
            }
        }
    });
    Object.defineProperty(SerialChart, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "SerialChart"
    });
    Object.defineProperty(SerialChart, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Chart.classNames.concat([SerialChart.className])
    });
    return SerialChart;
}(Chart));
export { SerialChart };
//# sourceMappingURL=SerialChart.js.map