import { __extends } from "tslib";
import { Graphics } from "./Graphics";
import * as $utils from "../../core/util/Utils";
/**
 * Draws a Star.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
var Star = /** @class */ (function (_super) {
    __extends(Star, _super);
    function Star() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Star.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("radius") || this.isDirty("innerRadius") || this.isDirty("spikes")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Star.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear) {
                var display = this._display;
                var r = this.get("radius", 0);
                var ir = $utils.relativeToValue(this.get("innerRadius", 0), r);
                var spikes = this.get("spikes", 0);
                var step = Math.PI / spikes;
                var angle = Math.PI / 2 * 3;
                display.moveTo(0, -r);
                for (var i = 0; i < spikes; i++) {
                    display.lineTo(Math.cos(angle) * r, Math.sin(angle) * r);
                    angle += step;
                    display.lineTo(Math.cos(angle) * ir, Math.sin(angle) * ir);
                    angle += step;
                }
                display.lineTo(0, -r);
            }
        }
    });
    Object.defineProperty(Star, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Star"
    });
    Object.defineProperty(Star, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([Star.className])
    });
    return Star;
}(Graphics));
export { Star };
//# sourceMappingURL=Star.js.map