import { __extends } from "tslib";
import { Sprite } from "./Sprite";
import { populateString } from "../util/PopulateString";
import * as $array from "../util/Array";
/**
 * @ignore Text is an internal class. Use Label instead.
 */
var Text = /** @class */ (function (_super) {
    __extends(Text, _super);
    function Text() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "textStyle", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this._root._renderer.makeTextStyle()
        });
        Object.defineProperty(_this, "_display", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this._root._renderer.makeText("", _this.textStyle)
        });
        Object.defineProperty(_this, "_textStyles", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: [
                "textAlign",
                "fontFamily",
                "fontSize",
                "fontStyle",
                "fontWeight",
                "fontStyle",
                "fontVariant",
                "textDecoration",
                "shadowColor",
                "shadowBlur",
                "shadowOffsetX",
                "shadowOffsetY",
                "shadowOpacity",
                // "leading",
                // "letterSpacing",
                "lineHeight",
                "baselineRatio",
                //"padding",
                // "stroke",
                // "strokeThickness",
                // "trim",
                // "wordWrap",
                "direction",
                "textBaseline",
                "oversizedBehavior",
                "breakWords",
                "ellipsis",
                "minScale"
            ]
        });
        Object.defineProperty(_this, "_originalScale", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(Text.prototype, "_updateBounds", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (!this.get("text")) {
                var newBounds = {
                    left: 0,
                    right: 0,
                    top: 0,
                    bottom: 0,
                };
                this._adjustedLocalBounds = newBounds;
            }
            else {
                _super.prototype._updateBounds.call(this);
            }
        }
    });
    Object.defineProperty(Text.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._changed.call(this);
            this._display.clear();
            var textStyle = this.textStyle;
            if (this.isDirty("opacity")) {
                var opacity = this.get("opacity", 1);
                this._display.alpha = opacity;
            }
            if (this.isDirty("text") || this.isDirty("populateText")) {
                this._display.text = this._getText();
                this.markDirtyBounds();
                if (this.get("role") == "tooltip") {
                    this._root.updateTooltip(this);
                }
            }
            if (this.isDirty("width")) {
                textStyle.wordWrapWidth = this.width();
                this.markDirtyBounds();
            }
            if (this.isDirty("oversizedBehavior")) {
                textStyle.oversizedBehavior = this.get("oversizedBehavior", "none");
                this.markDirtyBounds();
            }
            if (this.isDirty("breakWords")) {
                textStyle.breakWords = this.get("breakWords", false);
                this.markDirtyBounds();
            }
            if (this.isDirty("ellipsis")) {
                textStyle.ellipsis = this.get("ellipsis");
                this.markDirtyBounds();
            }
            if (this.isDirty("ignoreFormatting")) {
                textStyle.ignoreFormatting = this.get("ignoreFormatting", false);
                this.markDirtyBounds();
            }
            if (this.isDirty("minScale")) {
                textStyle.minScale = this.get("minScale", 0);
                this.markDirtyBounds();
            }
            if (this.isDirty("fill")) {
                var fill = this.get("fill");
                if (fill) {
                    textStyle.fill = fill;
                }
            }
            if (this.isDirty("maxWidth")) {
                textStyle.maxWidth = this.get("maxWidth");
                this.markDirtyBounds();
            }
            if (this.isDirty("maxHeight")) {
                textStyle.maxHeight = this.get("maxHeight");
                this.markDirtyBounds();
            }
            $array.each(this._textStyles, function (styleName) {
                if (_this._dirty[styleName]) {
                    textStyle[styleName] = _this.get(styleName);
                    _this.markDirtyBounds();
                }
            });
            textStyle["fontSize"] = this.get("fontSize");
            textStyle["fontFamily"] = this.get("fontFamily");
            this._display.style = textStyle;
            if (this.isDirty("role") && this.get("role") == "tooltip") {
                this._root.updateTooltip(this);
            }
        }
    });
    Object.defineProperty(Text.prototype, "_getText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var text = this.get("text", "");
            return this.get("populateText") ? populateString(this, text) : text;
        }
    });
    Object.defineProperty(Text.prototype, "markDirtyText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._display.text = this._getText();
            if (this.get("role") == "tooltip") {
                this._root.updateTooltip(this);
            }
            this.markDirtyBounds();
            this.markDirty();
        }
    });
    Object.defineProperty(Text.prototype, "_setDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype._setDataItem.call(this, dataItem);
            if (this.get("populateText")) {
                this.markDirtyText();
            }
        }
    });
    Object.defineProperty(Text, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Text"
    });
    Object.defineProperty(Text, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Sprite.classNames.concat([Text.className])
    });
    return Text;
}(Sprite));
export { Text };
//# sourceMappingURL=Text.js.map