/** @ignore */ /** */
import { IRenderer, IContainer, IDisplayObject, IGraphics, IRendererEvents, IText, ITextStyle, IRadialText, IPicture, IRendererEvent, ILayer, ICanvasOptions, BlendMode, IPointerEvent, Id } from "./Renderer";
import type { IBounds } from "../../util/IBounds";
import type { IPoint } from "../../util/IPoint";
import { Color } from "../../util/Color";
import { Matrix } from "../../util/Matrix";
import { Percent } from "../../util/Percent";
import { Throttler } from "../../util/Throttler";
import { ArrayDisposer, DisposerClass, IDisposer, CounterDisposer } from "../../util/Disposer";
/**
 * @ignore
 */
export declare class CanvasPivot implements IPoint {
    protected _x: number;
    protected _y: number;
    get x(): number;
    get y(): number;
    set x(value: number);
    set y(value: number);
}
/**
 * @ignore
 */
export declare class CanvasDisplayObject extends DisposerClass implements IDisplayObject, IDisposer {
    _layer?: CanvasLayer;
    mask: CanvasGraphics | null;
    visible: boolean;
    exportable?: boolean;
    interactive: boolean;
    inactive: boolean;
    wheelable: boolean;
    isMeasured: boolean;
    buttonMode: boolean;
    alpha: number;
    compoundAlpha: number;
    angle: number;
    scale: number;
    x: number;
    y: number;
    pivot: CanvasPivot;
    filter?: string;
    cursorOverStyle?: string;
    _replacedCursorStyle?: string;
    _localMatrix: Matrix;
    _matrix: Matrix;
    protected _uMatrix: Matrix;
    protected _renderer: CanvasRenderer;
    _parent: CanvasContainer | undefined;
    protected _localBounds: IBounds | undefined;
    protected _bounds: IBounds | undefined;
    _colorId: string | undefined;
    constructor(renderer: CanvasRenderer);
    protected _dispose(): void;
    getCanvas(): HTMLCanvasElement;
    getLayer(): CanvasLayer;
    setLayer(order: number | undefined, visible?: boolean): void;
    markDirtyLayer(): void;
    clear(): void;
    invalidateBounds(): void;
    _addBounds(_bounds: IBounds): void;
    protected _getColorId(): string;
    protected _isInteractive(): boolean;
    protected _isInteractiveMask(): boolean;
    contains(child: CanvasDisplayObject): boolean;
    toGlobal(point: IPoint): IPoint;
    toLocal(point: IPoint): IPoint;
    getLocalMatrix(): Matrix;
    getLocalBounds(): IBounds;
    getAdjustedBounds(bounds: IBounds): IBounds;
    on<C, Key extends keyof IRendererEvents>(key: Key, callback: (this: C, event: IRendererEvents[Key]) => void, context?: C): IDisposer;
    _setMatrix(): void;
    _transform(context: CanvasRenderingContext2D, resolution: number): void;
    render(parentLayer: CanvasLayer): void;
    protected _render(parentLayer: CanvasLayer): void;
    hovering(): boolean;
    dragging(): boolean;
    dispose(): void;
}
/**
 * @ignore
 */
export declare class CanvasContainer extends CanvasDisplayObject implements IContainer {
    interactiveChildren: boolean;
    private _childLayers?;
    protected _children: Array<CanvasDisplayObject>;
    protected _isInteractiveMask(): boolean;
    addChild(child: CanvasDisplayObject): void;
    addChildAt(child: CanvasDisplayObject, index: number): void;
    removeChild(child: CanvasDisplayObject): void;
    protected _render(parentLayer: CanvasLayer): void;
    registerChildLayer(layer: CanvasLayer): void;
    markDirtyLayer(deep?: boolean): void;
    dispose(): void;
}
/**
 * @ignore
 */
declare abstract class Op {
    colorize(_context: CanvasRenderingContext2D, _forceColor: string | undefined): void;
    path(_context: CanvasRenderingContext2D): void;
    addBounds(_bounds: IBounds): void;
}
/**
 * @ignore
 */
export declare class CanvasGraphics extends CanvasDisplayObject implements IGraphics {
    protected _operations: Array<Op>;
    blendMode: BlendMode;
    protected _hasShadows: boolean;
    protected _fillAlpha?: number;
    protected _strokeAlpha?: number;
    clear(): void;
    protected _pushOp(op: Op): void;
    beginFill(color?: Color | CanvasGradient | CanvasPattern, alpha?: number): void;
    endFill(): void;
    endStroke(): void;
    lineStyle(width?: number, color?: Color | CanvasGradient | CanvasPattern, alpha?: number): void;
    setLineDash(dash?: number[]): void;
    setLineDashOffset(dashOffset?: number): void;
    drawRect(x: number, y: number, width: number, height: number): void;
    drawCircle(x: number, y: number, radius: number): void;
    drawEllipse(x: number, y: number, radiusX: number, radiusY: number): void;
    arc(cx: number, cy: number, radius: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;
    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): void;
    lineTo(x: number, y: number): void;
    moveTo(x: number, y: number): void;
    bezierCurveTo(cpX: number, cpY: number, cpX2: number, cpY2: number, toX: number, toY: number): void;
    quadraticCurveTo(cpX: number, cpY: number, toX: number, toY: number): void;
    closePath(): void;
    shadow(color: Color, blur?: number, offsetX?: number, offsetY?: number, opacity?: number): void;
    svgPath(path: string): void;
    _runPath(context: CanvasRenderingContext2D): void;
    protected _render(parentLayer: CanvasLayer): void;
    renderDetached(context: CanvasRenderingContext2D): void;
    _addBounds(bounds: IBounds): void;
}
/**
 * @ignore
 */
interface ILineChunk {
    style: string | undefined;
    fill: Color | undefined;
    text: string;
    width: number;
    height: number;
    left: number;
    right: number;
    ascent: number;
    offsetX: number;
    offsetY: number;
    textDecoration: string | undefined;
}
/**
 * @ignore
 */
interface ILine {
    offsetY: number;
    ascent: number;
    width: number;
    height: number;
    left: number;
    right: number;
    textChunks: Array<ILineChunk>;
}
/**
 * @ignore
 */
export declare class CanvasText extends CanvasDisplayObject implements IText {
    text: string;
    style: CanvasTextStyle;
    resolution: number;
    protected _textInfo: Array<ILine> | undefined;
    protected _textVisible: boolean;
    protected _originalScale?: number;
    constructor(renderer: CanvasRenderer, text: string, style: CanvasTextStyle);
    invalidateBounds(): void;
    private _shared;
    protected _prerender(layer: CanvasLayer, ignoreGhost?: boolean, ignoreFontWeight?: boolean): void;
    protected _getFontStyle(style2?: ITextStyle, ignoreFontWeight?: boolean): string;
    protected _render(parentLayer: CanvasLayer): void;
    _addBounds(bounds: IBounds): void;
    _measure(layer: CanvasLayer): IBounds;
    protected _fitRatio(bounds: IBounds): number;
    protected _truncateText(context: CanvasRenderingContext2D, text: string, maxWidth: number, breakWords?: boolean, fallbackBreakWords?: boolean): string;
    protected _measureText(text: string, context: CanvasRenderingContext2D): TextMetrics;
}
/**
 * @ignore
 */
export declare class CanvasTextStyle implements ITextStyle {
    fill?: Color | CanvasGradient | CanvasPattern;
    textAlign?: "start" | "end" | "left" | "right" | "center";
    fontFamily?: string;
    fontSize?: string | number;
    fontWeight?: 'normal' | 'bold' | 'bolder' | 'lighter' | '100' | '200' | '300' | '400' | '500' | '600' | '700' | '800' | '900';
    fontStyle?: 'normal' | 'italic' | 'oblique';
    fontVariant?: "normal" | "small-caps";
    textDecoration?: "underline";
    shadowColor?: Color | null;
    shadowBlur?: number;
    shadowOffsetX?: number;
    shadowOffsetY?: number;
    shadowOpacity?: number;
    lineHeight?: number | Percent;
    baselineRatio?: number;
    direction?: "ltr" | "rtl";
    textBaseline?: "top" | "hanging" | "middle" | "alphabetic" | "ideographic" | "bottom";
    oversizedBehavior?: "none" | "hide" | "fit" | "wrap" | "truncate";
    breakWords?: boolean;
    ellipsis?: string;
    maxWidth?: number;
    maxHeight?: number;
    minScale?: number;
    ignoreFormatting?: boolean;
}
/**
 * @ignore
 */
export declare class CanvasRadialText extends CanvasText implements IRadialText {
    textType?: "regular" | "circular" | "radial" | "aligned" | "adjusted";
    radius?: number;
    startAngle?: number;
    inside?: boolean;
    orientation?: "inward" | "outward" | "auto";
    kerning?: number;
    private _textReversed;
    _render(parentLayer: CanvasLayer): void;
    _renderCircular(parentLayer: CanvasLayer): void;
    _measure(layer: CanvasLayer): IBounds;
    _measureCircular(layer: CanvasLayer): IBounds;
}
/**
 * @ignore
 */
export declare class CanvasImage extends CanvasDisplayObject implements IPicture {
    width: number | undefined;
    height: number | undefined;
    image: HTMLImageElement | undefined;
    tainted?: boolean;
    shadowColor?: Color;
    shadowBlur?: number;
    shadowOffsetX?: number;
    shadowOffsetY?: number;
    shadowOpacity?: number;
    protected _imageMask: HTMLCanvasElement | undefined;
    constructor(renderer: CanvasRenderer, image: HTMLImageElement | undefined);
    protected _dispose(): void;
    getLocalBounds(): IBounds;
    protected _render(parentLayer: CanvasLayer): void;
    clear(): void;
    protected _getMask(image: HTMLImageElement): HTMLCanvasElement;
}
/**
 * @ignore
 */
export declare class CanvasRendererEvent<A> implements IRendererEvent<A> {
    event: A;
    point: IPoint;
    bbox: DOMRect;
    id: Id;
    simulated: boolean;
    native: boolean;
    constructor(event: A, point: IPoint, bbox: DOMRect);
}
/**
 * @ignore
 */
interface Event<Key extends keyof IRendererEvents> {
    object: CanvasDisplayObject;
    context: unknown;
    callback: (event: IRendererEvents[Key]) => void;
    disposed: boolean;
}
/**
 * @ignore
 */
interface Events<Key extends keyof IRendererEvents> {
    disposer: IDisposer;
    callbacks: Array<Event<Key>>;
    dispatching: boolean;
    cleanup: boolean;
}
/**
 * @ignore
 */
export declare class CanvasRenderer extends ArrayDisposer implements IRenderer, IDisposer {
    view: HTMLElement;
    protected _layerDom: HTMLElement;
    layers: Array<CanvasLayer>;
    _dirtyLayers: Array<CanvasLayer>;
    defaultLayer: CanvasLayer;
    protected _ghostView: HTMLCanvasElement;
    _ghostContext: CanvasRenderingContext2D;
    protected _patternCanvas: HTMLCanvasElement;
    protected _patternContext: CanvasRenderingContext2D;
    protected _width: number;
    protected _height: number;
    protected _clientWidth: number;
    protected _clientHeight: number;
    resolution: number;
    interactionsEnabled: boolean;
    protected _listeners: {
        [key: string]: CounterDisposer;
    };
    protected _events: {
        [Key in keyof IRendererEvents]?: Events<Key>;
    };
    protected _colorId: number;
    protected _colorMap: {
        [color: string]: CanvasDisplayObject;
    };
    _forceInteractive: number;
    _omitTainted: boolean;
    _hovering: Set<CanvasDisplayObject>;
    _dragging: Array<{
        id: Id;
        value: CanvasDisplayObject;
    }>;
    _mousedown: Array<{
        id: Id;
        value: CanvasDisplayObject;
    }>;
    protected _lastPointerMoveEvent: {
        event: IPointerEvent;
        native: boolean;
    };
    protected _mouseMoveThrottler: Throttler;
    constructor(resolution?: number);
    createLinearGradient(x1: number, y1: number, x2: number, y2: number): CanvasGradient;
    createRadialGradient(x1: number, y1: number, radius1: number, x2: number, y2: number, radius2: number): CanvasGradient;
    createPattern(graphics: CanvasGraphics, background: CanvasGraphics, repetition: string, width: number, height: number): CanvasPattern;
    makeContainer(): CanvasContainer;
    makeGraphics(): CanvasGraphics;
    makeText(text: string, style: CanvasTextStyle): CanvasText;
    makeTextStyle(): CanvasTextStyle;
    makeRadialText(text: string, style: CanvasTextStyle): CanvasRadialText;
    makePicture(image: HTMLImageElement | undefined): CanvasImage;
    resize(width: number, height: number): void;
    private createDetachedLayer;
    getLayerByOrder(order: number): CanvasLayer | undefined;
    getLayer(order: number, visible?: boolean): CanvasLayer;
    render(root: CanvasDisplayObject): void;
    paintId(obj: CanvasDisplayObject): string;
    _removeObject(obj: CanvasDisplayObject): void;
    getEvent<A extends IPointerEvent>(originalEvent: A, adjustPoint?: boolean): CanvasRendererEvent<A>;
    _getHitTarget(point: IPoint, bbox: DOMRect): CanvasDisplayObject | undefined | false;
    _withEvents<Key extends keyof IRendererEvents>(key: Key, f: (events: Events<Key>) => void): void;
    _dispatchEventAll<Key extends keyof IRendererEvents>(key: Key, event: IRendererEvents[Key]): void;
    _dispatchEvent<Key extends keyof IRendererEvents>(key: Key, target: CanvasDisplayObject, event: IRendererEvents[Key]): boolean;
    _dispatchMousedown(originalEvent: IPointerEvent): void;
    _dispatchGlobalMousemove(originalEvent: IPointerEvent, native: boolean): void;
    _dispatchGlobalMouseup(originalEvent: IPointerEvent, native: boolean): void;
    _dispatchDragMove(originalEvent: IPointerEvent): void;
    _dispatchDragEnd(originalEvent: IPointerEvent): void;
    _dispatchDoubleClick(originalEvent: IPointerEvent): void;
    _dispatchWheel(originalEvent: WheelEvent): void;
    _makeSharedEvent(key: string, f: () => IDisposer): IDisposer;
    _onPointerEvent(name: string, f: (event: IPointerEvent, native: boolean) => void): IDisposer;
    _initEvent(key: keyof IRendererEvents): IDisposer | undefined;
    _addEvent<C, Key extends keyof IRendererEvents>(object: CanvasDisplayObject, key: Key, callback: (this: C, event: IRendererEvents[Key]) => void, context?: C): IDisposer;
    getCanvas(root: CanvasDisplayObject, options?: ICanvasOptions): HTMLCanvasElement;
}
/**
 * @ignore
 */
export interface CanvasLayer extends ILayer {
    view: HTMLCanvasElement;
    context: CanvasRenderingContext2D;
    tainted?: boolean;
    exportableView?: HTMLCanvasElement;
    exportableContext?: CanvasRenderingContext2D;
    scale?: number;
}
export {};
//# sourceMappingURL=CanvasRenderer.d.ts.map