import { __extends } from "tslib";
import { Entity } from "../../util/Entity";
/**
 * Base class for gradients.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/colors-gradients-and-patterns/gradients/} for more info
 */
var Gradient = /** @class */ (function (_super) {
    __extends(Gradient, _super);
    function Gradient() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Gradient.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            // Applying themes because gradient will not have parent
            _super.prototype._afterNewApplyThemes.call(this);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Gradient.prototype, "getFill", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_target) {
            return {
                addColorStop: function (_offset, _color) { }
            };
        }
    });
    Object.defineProperty(Gradient.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            //if (this.isDirty("target") && this.get("target")) {
            //	this.get("target")!.events.on("boundschanged", () => {
            //	});
            //}
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Gradient.prototype, "getBounds", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (target) {
            var gradientTarget = this.get("target");
            if (gradientTarget) {
                var bounds = gradientTarget.globalBounds();
                var p0 = target.toLocal({ x: bounds.left, y: bounds.top });
                var p1 = target.toLocal({ x: bounds.right, y: bounds.top });
                var p2 = target.toLocal({ x: bounds.right, y: bounds.bottom });
                var p3 = target.toLocal({ x: bounds.left, y: bounds.bottom });
                return {
                    left: Math.min(p0.x, p1.x, p2.x, p3.x),
                    top: Math.min(p0.y, p1.y, p2.y, p3.y),
                    right: Math.max(p0.x, p1.x, p2.x, p3.x),
                    bottom: Math.max(p0.y, p1.y, p2.y, p3.y)
                };
            }
            return target._display.getLocalBounds();
        }
    });
    Object.defineProperty(Gradient, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Gradient"
    });
    Object.defineProperty(Gradient, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Entity.classNames.concat([Gradient.className])
    });
    return Gradient;
}(Entity));
export { Gradient };
//# sourceMappingURL=Gradient.js.map