import { __extends } from "tslib";
import { Gradient } from "./Gradient";
import { Color } from "../../util/Color";
import * as $array from "../../util/Array";
import * as $type from "../../util/Type";
import * as $math from "../../util/Math";
/**
 * Linear gradient.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/colors-gradients-and-patterns/gradients/} for more info
 */
var LinearGradient = /** @class */ (function (_super) {
    __extends(LinearGradient, _super);
    function LinearGradient() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(LinearGradient.prototype, "getFill", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (target) {
            var rotation = this.get("rotation", 0);
            var bounds = this.getBounds(target);
            var l = bounds.left || 0;
            var r = bounds.right || 0;
            var t = bounds.top || 0;
            var b = bounds.bottom || 0;
            var cos = $math.cos(rotation);
            var sin = $math.sin(rotation);
            var w = cos * (r - l);
            var h = sin * (b - t);
            var longer = Math.max(w, h);
            var gradient = this._root._renderer.createLinearGradient(l, t, l + longer * cos, t + longer * sin);
            var stops = this.get("stops");
            if (stops) {
                var i_1 = 0;
                $array.each(stops, function (stop) {
                    var offset = stop.offset;
                    if (!$type.isNumber(offset)) {
                        offset = i_1 / (stops.length - 1);
                    }
                    var opacity = stop.opacity;
                    if (!$type.isNumber(opacity)) {
                        opacity = 1;
                    }
                    var color = stop.color;
                    if (color) {
                        var lighten = stop.lighten;
                        if (lighten) {
                            color = Color.lighten(color, lighten);
                        }
                        var brighten = stop.brighten;
                        if (brighten) {
                            color = Color.brighten(color, brighten);
                        }
                        gradient.addColorStop(offset, 'rgba(' + color.r + ',' + color.g + ',' + color.b + ',' + opacity + ')');
                    }
                    i_1++;
                });
            }
            return gradient;
        }
    });
    Object.defineProperty(LinearGradient, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "LinearGradient"
    });
    Object.defineProperty(LinearGradient, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Gradient.classNames.concat([LinearGradient.className])
    });
    return LinearGradient;
}(Gradient));
export { LinearGradient };
//# sourceMappingURL=LinearGradient.js.map